import pyautogui  # type: ignore
import time
from recogniser import recognise
import subprocess

# constants
cardX = 112
cardY = 25
zerozero = (357, 423)
blank = (1188, 283)
new = (1080, 771)
# find the window
try:
    exa = pyautogui.getWindow("EXAPUNKS")  # 3.6
except AttributeError:
    exa = pyautogui.getWindowsWithTitle("EXAPUNKS")[0]  # 3.7+
# get its coords
exavector = exa.get_position()


def drag(x: int, y: int, x2: int, y2: int):
    """Drag the mouse from two points to another two points
    
    :param x: Starting x
    :type x: int
    :param y: Starting y
    :type y: int
    :param x2: Ending x
    :type x2: int
    :param y2: Ending y
    :type y2: int
    """
    pyautogui.moveTo(x + exavector[0], y + exavector[1])
    pyautogui.mouseDown()
    pyautogui.dragTo(x2 + exavector[0], y2 + exavector[1])
    pyautogui.mouseUp()


def solve_one():
    """Solve one game of ПАСЬЯНС"""
    # capture the board
    image = pyautogui.screenshot()
    image2 = image.crop(exavector)
    # CV
    board = recognise(image2, verbose=True, use_colour=True)
    # make sure we understand the board
    if board is not None:
        # run the solver
        result = subprocess.run(
            ["solver", "-v", str(board)], shell=False, stdout=subprocess.PIPE
        )
        moves = eval(result.stdout)
        try:
            for i in moves:
                # determine start and end co-ords
                x = i[0][0]
                y = i[0][1]
                x1 = i[1][0]
                y1 = i[1][1]
                # x=9 means we use the blank space
                if x == 9:
                    start = blank
                else:
                    start = (zerozero[0] + cardX * x, zerozero[1] + cardY * y)
                # x=9 means we use the blank space
                if x1 == 9:
                    end = blank
                else:
                    end = (zerozero[0] + cardX * x1, zerozero[1] + cardY * y1)
                drag(*start, *end)
        except:
            # something went wrong, try solving on a new board
            drag(*new, *new)
            time.sleep(6)
            solve_one()
    else:
        # didn't understand the board, try a new one
        drag(*new, *new)
        time.sleep(6)
        solve_one()


gamesLeft = int(input("How many games would you like the solver to solve?\n>>> "))
drag(1, 1, 1, 1)  # focus the window
try:  # solve that many games, waiting for the cards to deal and 2 seconds between
    # games so the user can cancel with PyAutoGUI's failsafe
    for i in range(gamesLeft):
        drag(*new, *new)
        time.sleep(6)
        solve_one()
        time.sleep(2)
except:  # something failed, tell the user
    import traceback

    traceback.print_exc()
    input()
