const /** @type{(player: Internal.Player, hand: Internal.InteractionHand_) => void} */updatePlayerWrench = (player, hand) => {
    const wrench = player.getHeldItem(hand);
    if (!wrench.hasTag("forge:tools/wrench")) {
        return;
    }
    const /** @type{string} */wrenchType = wrench.nbt?.defaultWrenchType;
    let block = player.rayTrace(player.reachDistance).block;
    let mod = (block?.id ?? "minecraft:air").split(":")[0];
    switch (mod) {
        case "create":
            player.setHeldItem(hand, Item.of("create:wrench").withNBT(wrench.nbt));
            return;
        case "ae2":
            if (wrenchType.startsWith("ae2:")) {
                // use the wrench type that was crafted
                player.setHeldItem(hand, Item.of(wrenchType).withNBT(wrench.nbt));
            } else {
                // default to certus quartz wrench
                player.setHeldItem(hand, Item.of("ae2:certus_quartz_wrench").withNBT(wrench.nbt));
            }
            return;
        case "enderio":
            player.setHeldItem(hand, Item.of("enderio:yeta_wrench").withNBT(wrench.nbt));
            return;
        case "thermal":
            player.setHeldItem(hand, Item.of("thermal:wrench").withNBT(wrench.nbt));
            return;
        default:
            // no known wrench for this mod, use the crafted wrench type if there
            // is one, otherwise just leave it
            if (wrenchType) {
                player.setHeldItem(hand, Item.of(wrenchType).withNBT(wrench.nbt));
            }
            return;
    }
};

PlayerEvents.tick(event => {
    updatePlayerWrench(event.player, "main_hand");
    updatePlayerWrench(event.player, "off_hand");
});
ServerEvents.recipes(event => {
    event.forEachRecipe({
        output: "#forge:tools/wrench",
    }, original => {
        let wrenchType = original.originalRecipeResult.id;
        original.replaceOutput(wrenchType, Item.of(wrenchType).withNBT({
            defaultWrenchType: wrenchType,
        }));
    });
});