ServerEvents.recipes(event => {
    let waxable = {};
    event.forEachRecipe({
        "input": "minecraft:honeycomb",
        "output": /^[^:]+:waxed/,
    }, recipe => {
        let inputId = recipe.originalRecipe.getIngredients().get(0).itemIds[0];
        let outputId = recipe.originalRecipeResult.id;
        if (!outputId.match("_door")) {
            waxable[inputId] = outputId;
        }
    });
    global.waxable = waxable;
});
BlockEvents.rightClicked(event => {
    const {player, block, item, level} = event;
    if (item.id !== "kubejs:wax") {
        return;
    }
    if (!global.waxable) {
        player.tell(Text.red("ERROR: no waxing recipes stored!"));
        return;
    }
    const waxResult = global.waxable[block.id];
    if (waxResult) {
        if (!player.creative) {
            item.count -= 1;
        }
        block.set(waxResult, block.properties);
        event.level.runCommandSilent(`/playsound minecraft:item.honeycomb.wax_on block @a ${block.x} ${block.y} ${block.z} 1 1 1`);
        level.spawnParticles(
            "minecraft:wax_on", true,
            block.x + 0.5, block.y + 0.5, block.z + 0.5,
            0.5, 0.5, 0.5,
            10, 0.1
        );
        player.swing(event.hand, true);
    }
});