const COLOURS = [
    "white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray",
    "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black",
];
ServerEvents.recipes(event => {
    const {
        conversion,
        crushing,
        cutting,
        milling,
        basin,
        mixing,
        compacting,
        pressing,
        sandpaper_polishing,
        splashing,
        haunting,
        deploying,
        filling,
        emptying,
        item_application,
        mechanical_crafting,
        sequenced_assembly,
    } = event.recipes.create;
    const processorRework = (kind) => {
        const inter = `createappliedkinetics:incomplete_${kind}_processor`;
        event.remove({id: `ae2:inscriber/${kind}_processor`});
        sequenced_assembly(
            [`ae2:${kind}_processor`],
            "ae2:printed_silicon",
            [
                deploying(
                    inter,
                    [inter, `ae2:printed_${kind}_processor`],
                ),
                filling(
                    inter,
                    [inter, {fluidTag: 'forge:redstone', amount: 100}],
                ),
                pressing(
                    inter,
                    inter,
                ),
            ],
        ).transitionalItem(inter)
            .loops(1)
            .id(`ae2:inscriber/${kind}_processor`);
    };
    processorRework("calculation");
    processorRework("logic");
    processorRework("engineering");

    event.remove({id: "create:industrial_iron_block_from_ingots_iron_stonecutting"});
    event.remove({id: "angelring:energetic_angel_ring"});
    event.custom({
        type: "tconstruct:melting",
        ingredient: {item: "minecraft:cobblestone"},
        result: {fluid: "tconstruct:seared_stone", amount: 250},
        temperature: 1000,
        time: 27,
    });

    event.shaped(
        "mysticalagriculture:witherproof_block",
        [
            " b ",
            "bsb",
            " b ",
        ],
        {
            s: "mysticalagriculture:soulstone",
            b: "tconstruct:necrotic_bone",
        }
    );
    event.shaped(
        "mysticalagriculture:witherproof_glass",
        [
            " b ",
            "bsb",
            " b ",
        ],
        {
            s: "tconstruct:soul_glass",
            b: "tconstruct:necrotic_bone",
        }
    );
    crushing(
        "mysticalagriculture:soul_dust",
        "mysticalagriculture:soulstone_cobble",
    );
    crushing(
        ["mysticalagriculture:soulstone_cobble", Item.of("mysticalagriculture:soul_dust").withChance(0.1)],
        "mysticalagriculture:soulstone",
    );
    event.replaceInput(
        {id: "mysticalagriculture:seed_reprocessor"},
        "mysticalagriculture:soulium_ingot",
        "mysticalagriculture:prudentium_ingot",
    );

    event.shaped(
        "tconstruct:smeltery_controller",
        [
            "bcb",
            "c c",
            "bcb",
        ],
        {
            b: "tconstruct:seared_brick",
            c: "minecraft:copper_ingot",
        },
    );
    const carFrame = colour => {
        mechanical_crafting(
            Item.of('automobility:automobile_frame', `{frame:"automobility:standard_${colour}"}`),
            [
                'cccdlscc',
                'i cccc i',
            ],
            {
                c: '#forge:ingots/copper',
                l: '#forge:leather',
                s: 'minecraft:calcite',
                i: '#forge:ingots/iron',
                d: `#forge:dyes/${colour}`,
            }
        );
    };
    for (const color of COLOURS) {
        carFrame(color);
    }
    mechanical_crafting(
        Item.of('automobility:automobile_engine', '{engine:"automobility:stone"}'),
        [
            ' c ',
            'lfl',
            ' s ',
        ],
        {
            c: 'minecraft:coal',
            l: '#minecraft:logs',
            s: '#minecraft:stone_tool_materials',
            f: 'minecraft:furnace',
        }
    );
    mechanical_crafting(
        Item.of('automobility:automobile_engine', '{engine:"automobility:copper"}'),
        [
            ' c ',
            'lfl',
            ' s ',
        ],
        {
            c: 'minecraft:coal',
            l: '#forge:ingots/copper',
            s: '#forge:nuggets/iron',
            f: 'minecraft:furnace',
        }
    );
    mechanical_crafting(
        Item.of('automobility:automobile_engine', '{engine:"automobility:iron"}'),
        [
            'ii ii',
            'irfsi',
            'ii ii',
        ],
        {
            i: '#forge:ingots/iron',
            r: 'minecraft:redstone_block',
            f: 'minecraft:furnace',
            s: '#minecraft:stone_tool_materials',
        }
    );
    mechanical_crafting(
        Item.of('automobility:automobile_engine', '{engine:"automobility:gold"}'),
        [
            'ii ii',
            'irfsi',
            'ii ii',
        ],
        {
            i: '#forge:ingots/gold',
            r: 'minecraft:redstone_block',
            f: 'minecraft:furnace',
            s: '#forge:ingots/iron',
        }
    );
    mechanical_crafting(
        Item.of('automobility:automobile_engine', '{engine:"automobility:diamond"}'),
        [
            ' c ',
            'lfl',
            ' s ',
        ],
        {
            c: 'minecraft:redstone_block',
            l: 'minecraft:diamond',
            s: 'minecraft:obsidian',
            f: 'minecraft:furnace',
        }
    );
    const wheel = (kind, hub, tyre) => {
        mechanical_crafting(
            Item.of('automobility:automobile_wheel', 4, `{wheel:"automobility:${kind}"}`),
            [
                ' tt ',
                'thht',
                'thht',
                ' tt ',
            ],
            {
                t: tyre,
                h: hub,
            }
        );
    };
    const smallWheel = (kind, hub, tyre) => {
        mechanical_crafting(
            Item.of('automobility:automobile_wheel', 4, `{wheel:"automobility:${kind}"}`),
            [
                'tht',
                'h h',
                'tht',
            ],
            {
                t: tyre,
                h: hub,
            }
        );
    };
    wheel("carriage", "minecraft:stick", "#minecraft:planks");
    wheel("plated", "#forge:ingots/copper", "#minecraft:logs");
    wheel("street", "#forge:ingots/iron", "#forge:cobblestone/deepslate");
    wheel("gilded", "#forge:ingots/gold", "#forge:ingots/nether_brick");
    wheel("bejeweled", "#forge:gems/diamond", "#forge:obsidian");
    smallWheel("standard", "#forge:nuggets/iron", "#forge:wool/black");
    smallWheel("tractor", "#forge:nuggets/gold", "#forge:wool/black");
    wheel("off_road", "#forge:storage_blocks/iron", "#forge:wool/black");
    smallWheel("steel", "#forge:ingots/iron", "#forge:wool/gray");
});