ServerEvents.recipes(event => {
    const {
        conversion,
        crushing,
        cutting,
        milling,
        basin,
        mixing,
        compacting,
        pressing,
        sandpaper_polishing,
        splashing,
        haunting,
        deploying,
        filling,
        emptying,
        item_application,
        mechanical_crafting,
        sequenced_assembly,
    } = event.recipes.create;
    const /** @deprecated */washing = splashing;
    function casting(kind, result, fluid, fluidMb, coolingTime, castItem, castConsumed) {
        if (castConsumed === undefined) {
            castConsumed = true;
        }
        return event.custom(castItem ? {
            type: `tconstruct:casting_${kind}`,
            fluid: fluid.startsWith("#")
                ? {tag: fluid.slice(1), amount: fluidMb}
                : {fluid: fluid, amount: fluidMb},
            cooling_time: coolingTime,
            result: result.startsWith("#")
                ? {tag: result.slice(1)}
                : {item: result},
            cast: castItem.startsWith("#")
                ? {tag: castItem.slice(1)}
                : {item: castItem},
            cast_consumed: castConsumed,
        } : {
            type: `tconstruct:casting_${kind}`,
            fluid: fluid.startsWith("#")
                ? {tag: fluid.slice(1), amount: fluidMb}
                : {fluid: fluid, amount: fluidMb},
            cooling_time: coolingTime,
            result: result.startsWith("#")
                ? {tag: result.slice(1)}
                : {item: result},
        });
    };
    function castingBasin(result, fluid, fluidMb, coolingTime, castItem, castConsumed) {
        return casting("basin", result, fluid, fluidMb, coolingTime, castItem, castConsumed);
    };
    function castingTable(result, fluid, fluidMb, coolingTime, castItem, castConsumed) {
        return casting("table", result, fluid, fluidMb, coolingTime, castItem, castConsumed);
    };
    function melting(result, mb, ingredient, time, temperature) {
        if (temperature === undefined) {
            temperature = 1000;
        }
        return event.custom({
            type: "tconstruct:melting",
            ingredient: ingredient.startsWith("#")
                ? {tag: ingredient.slice(1)}
                : {item: ingredient},
            result:
                result.startsWith("#")
                    ? {tag: result.slice(1), amount: mb}
                    : {fluid: result, amount: mb},
            temperature: temperature,
            time: time,
        });
    }

    compacting(
        "minecraft:tuff",
        [
            Item.of("minecraft:cobblestone", 4),
            Fluid.water(100),
        ],
    );
    compacting(
        "minecraft:deepslate",
        [
            "minecraft:cobblestone",
            Fluid.lava(100),
        ],
    );
    compacting(
        "minecraft:diamond",
        [
            Item.of("minecraft:coal_block", 4),
        ],
    ).superheated();

    event.shaped(
        Item.of("minecraft:calcite", 2),
        [
            "ab",
            "ba",
        ],
        {
            a: "minecraft:bone_meal",
            b: "minecraft:stone",
        },
    );

    mixing(
        "minecraft:dripstone_block",
        [
            "minecraft:calcite",
            Fluid.water(100),
        ],
    );
    crushing(
        [Item.of("minecraft:pointed_dripstone", 3), Item.of("minecraft:pointed_dripstone").withChance(0.75)],
        "minecraft:dripstone_block",
    );
    mixing(
        "create:asurine",
        [
            Item.of("create:zinc_nugget", 3),
            "minecraft:cobblestone",
        ],
    ).heated();
    event.shaped(
        Item.of("create:crimsite", 2),
        [
            "ab",
            "ba",
        ],
        {
            a: "minecraft:iron_nugget",
            b: "minecraft:cobblestone",
        },
    );
    mixing(
        "create:ochrum",
        [
            Item.of("minecraft:gold_nugget", 2),
            "minecraft:cobblestone",
        ],
    ).heated();
    mixing(
        "create:veridium",
        [
            Item.of("create:copper_nugget", 8),
            "minecraft:cobblestone",
        ],
    ).heated();

    haunting(
        "minecraft:crying_obsidian",
        "minecraft:obsidian",
    );

    crushing(
        "kubejs:crushed_scorchia",
        "create:scorchia",
    );
    splashing(
        Item.of("tconstruct:debris_nugget").withChance(0.005),
        "kubejs:crushed_scorchia",
    );

    haunting(
        "minecraft:wither_rose",
        "minecraft:poppy",
    );

    haunting("ae2:certus_quartz_crystal", "minecraft:quartz");
    haunting("minecraft:quartz", "ae2:certus_quartz_crystal");

    compacting(
        "minecraft:budding_amethyst",
        [
            "minecraft:amethyst_block",
            "ae2:growth_accelerator",
        ],
    ).superheated();
    compacting(
        "ae2:flawless_budding_quartz",
        [
            "ae2:flawed_budding_quartz",
            "ae2:growth_accelerator",
        ],
    ).superheated();
    compacting(
        "tconstruct:budding_earth_slime_crystal",
        [
            "tconstruct:earth_slime_crystal_block",
            "ae2:growth_accelerator",
        ],
    ).superheated();
    compacting(
        "tconstruct:budding_sky_slime_crystal",
        [
            "tconstruct:sky_slime_crystal_block",
            "ae2:growth_accelerator",
        ],
    ).superheated();
    compacting(
        "tconstruct:budding_ichor_slime_crystal",
        [
            "tconstruct:ichor_slime_crystal_block",
            "ae2:growth_accelerator",
        ],
    ).superheated();
    compacting(
        "tconstruct:budding_ender_slime_crystal",
        [
            "tconstruct:ender_slime_crystal_block",
            "ae2:growth_accelerator",
        ],
    ).superheated();
    castingBasin(
        "minecraft:end_stone",
        "#forge:ender", 25,
        15,
        "minecraft:cobblestone",
    );
    crushing(
        [
            Item.of("minecraft:ender_pearl").withChance(0.1),
            Item.of("minecraft:chorus_fruit").withChance(0.05),
            Item.of("minecraft:chorus_flower").withChance(0.01),
        ],
        "minecraft:end_stone",
    );
    crushing(
        [
            Item.of("#forge:dusts/obsidian"),
            Item.of("#forge:dusts/obsidian").withChance(0.5),
            Item.of("minecraft:amethyst_shard").withChance(0.05),
        ],
        "minecraft:crying_obsidian",
    );
    castingBasin(
        "mysticalagriculture:soulstone_cobble",
        "tconstruct:liquid_soul", 500,
        15,
        "minecraft:cobblestone",
    );
    castingTable(
        "enderio:enderman_head",
        "#forge:ender", 500,
        30,
        "mysticalagriculture:blank_skull",
    );

    event.shaped(
        "minecraft:zombie_head",
        [
            'fff',
            'fsf',
            'fff',
        ],
        {
            f: 'minecraft:rotten_flesh',
            s: 'mysticalagriculture:blank_skull',
        },
    );
    event.shaped(
        "minecraft:skeleton_skull",
        [
            'fff',
            'fsf',
            'fff',
        ],
        {
            f: 'minecraft:bone',
            s: 'mysticalagriculture:blank_skull',
        },
    );
    event.shaped(
        "minecraft:dragon_head",
        [
            'fff',
            'fsf',
            'fff',
        ],
        {
            f: 'tconstruct:dragon_scale',
            s: 'mysticalagriculture:blank_skull',
        },
    );
    event.shaped(
        "minecraft:dragon_egg",
        [
            'fff',
            'fsf',
            'fff',
        ],
        {
            f: 'tconstruct:dragon_scale',
            s: 'minecraft:egg',
        },
    );
    event.shaped(
        "minecraft:creeper_head",
        [
            'lgl',
            'gsg',
            'lgl',
        ],
        {
            l: '#minecraft:leaves',
            g: 'minecraft:gunpowder',
            s: 'mysticalagriculture:blank_skull',
        },
    );
    event.shaped(
        "minecraft:creeper_head",
        [
            'glg',
            'lsl',
            'glg',
        ],
        {
            l: '#minecraft:leaves',
            g: 'minecraft:gunpowder',
            s: 'mysticalagriculture:blank_skull',
        },
    );

    haunting(
        "tconstruct:necrotic_bone",
        "minecraft:bone",
    );
    event.shaped(
        "minecraft:wither_skeleton_skull",
        [
            'fff',
            'fsf',
            'fff',
        ],
        {
            f: 'tconstruct:necrotic_bone',
            s: 'mysticalagriculture:blank_skull',
        },
    );
    event.shaped(
        "tconstruct:blaze_head",
        [
            'fff',
            'fsf',
            'fff',
        ],
        {
            f: 'minecraft:blaze_powder',
            s: 'mysticalagriculture:blank_skull',
        },
    );
    haunting(
        "minecraft:phantom_membrane",
        "minecraft:leather",
    );

    mixing(
        Fluid.of('create:honey', 500),
        [
            Item.of('minecraft:sugar', 2),
            Item.of('kubejs:pollen', 3),
            Fluid.of('minecraft:water', 500),
        ]
    ).heated();
    mixing(
        Fluid.of('kubejs:molten_wax', 250),
        [
            Item.of('#minecraft:leaves', 3),
            Fluid.water(250),
        ]
    ).superheated();

    castingTable(
        "kubejs:wax",
        "kubejs:molten_wax", 250,
        15,
    );
    castingTable(
        "minecraft:candle",
        "kubejs:molten_wax", 250,
        15,
        "minecraft:string",
    );
    pressing(
        "kubejs:comb_base",
        "kubejs:wax",
    );
    filling(
        "minecraft:honeycomb",
        [
            "kubejs:comb_base",
            {fluidTag: 'forge:honey', amount: 250},
        ]
    );

    melting("kubejs:molten_wax", 250, "kubejs:wax", 20, 1);

    castingTable(
        "tconstruct:earth_slime_sapling",
        "tconstruct:earth_slime", 250,
        12,
        "#minecraft:saplings",
    );
    castingTable(
        "tconstruct:sky_slime_sapling",
        "tconstruct:sky_slime", 250,
        12,
        "#minecraft:saplings",
    );
    castingTable(
        "tconstruct:ender_slime_sapling",
        "tconstruct:ender_slime", 250,
        12,
        "#minecraft:saplings",
    );

    castingTable(
        "tconstruct:earth_slime_grass_seeds",
        "tconstruct:earth_slime", 250,
        12,
        "#forge:seeds",
    );
    castingTable(
        "tconstruct:sky_slime_grass_seeds",
        "tconstruct:sky_slime", 250,
        12,
        "#forge:seeds",
    );
    castingTable(
        "tconstruct:ender_slime_grass_seeds",
        "tconstruct:ender_slime", 250,
        12,
        "#forge:seeds",
    );

    haunting(
        "minecraft:spruce_sapling",
        "minecraft:oak_sapling",
    );
    haunting(
        "minecraft:birch_sapling",
        "minecraft:spruce_sapling",
    );
    haunting(
        "minecraft:jungle_sapling",
        "minecraft:birch_sapling",
    );
    haunting(
        "minecraft:acacia_sapling",
        "minecraft:jungle_sapling",
    );
    haunting(
        "minecraft:dark_oak_sapling",
        "minecraft:acacia_sapling",
    );
    haunting(
        "minecraft:cherry_sapling",
        "minecraft:dark_oak_sapling",
    );
    haunting(
        "thermal:rubberwood_sapling",
        "minecraft:cherry_sapling",
    );
    haunting(
        "minecraft:oak_sapling",
        "thermal:rubberwood_sapling",
    );

    sequenced_assembly(
        [Item.of("ae2:printed_silicon")],
        "#forge:silicon",
        [
            pressing(
                'kubejs:incomplete_printed_silicon',
                'kubejs:incomplete_printed_silicon',
            ),
        ],
    ).transitionalItem('kubejs:incomplete_printed_silicon').loops(8);
    sequenced_assembly(
        [Item.of("ae2:printed_logic_processor")],
        "#forge:plates/gold",
        [
            pressing(
                'kubejs:incomplete_printed_logic_processor',
                'kubejs:incomplete_printed_logic_processor',
            ),
        ],
    ).transitionalItem('kubejs:incomplete_printed_logic_processor').loops(8);
    event.shapeless(
        "create:golden_sheet",
        [
            "kubejs:incomplete_printed_logic_processor",
        ],
    );
    sequenced_assembly(
        [Item.of("ae2:printed_engineering_processor")],
        "minecraft:diamond",
        [
            pressing(
                'kubejs:incomplete_printed_engineering_processor',
                'kubejs:incomplete_printed_engineering_processor',
            ),
        ],
    ).transitionalItem('kubejs:incomplete_printed_engineering_processor').loops(8);
    sequenced_assembly(
        [Item.of("ae2:printed_calculation_processor")],
        "ae2:certus_quartz_crystal",
        [
            pressing(
                'kubejs:incomplete_printed_calculation_processor',
                'kubejs:incomplete_printed_calculation_processor',
            ),
        ],
    ).transitionalItem('kubejs:incomplete_printed_calculation_processor').loops(8);

    castingTable(
        "ae2:silicon_press",
        "tconstruct:molten_iron", 90,
        30,
        "ae2:printed_silicon",
    );
    castingTable(
        "ae2:calculation_processor_press",
        "tconstruct:molten_iron", 90,
        30,
        "ae2:printed_calculation_processor",
    );
    castingTable(
        "ae2:logic_processor_press",
        "tconstruct:molten_iron", 90,
        30,
        "ae2:printed_logic_processor",
    );
    castingTable(
        "ae2:engineering_processor_press",
        "tconstruct:molten_iron", 90,
        30,
        "ae2:printed_engineering_processor",
    );
    haunting(
        "ae2:mysterious_cube",
        "ae2:not_so_mysterious_cube",
    );
    haunting(
        "enderio:grains_of_infinity",
        "ae2:sky_dust",
    );
    haunting(
        "ae2:sky_dust",
        "enderio:grains_of_infinity",
    );

    crushing(
        ["ae2:sky_dust", Item.of("ae2:sky_dust").withChance(0.5), Item.of("ae2:sky_dust").withChance(0.05)],
        "ae2:sky_stone_block",
    );
    castingTable(
        "minecraft:netherite_upgrade_smithing_template",
        "tconstruct:molten_diamond", 500,
        36,
        "minecraft:netherite_ingot",
    );

    let inter = 'kubejs:incomplete_record';
    sequenced_assembly(
        ["mysticalagriculture:blank_record"],
        "minecraft:dried_kelp_block",
        [
            filling(
                inter,
                [inter, Fluid.water(500)],
            ),
            pressing(
                inter,
                inter,
            ),
            pressing(
                inter,
                inter,
            ),
            cutting(
                inter,
                inter,
            ),
            deploying(
                inter, [inter, "#forge:plates/iron"]
            )
        ]
    ).transitionalItem(inter).loops(1);
    event.shapeless(
        "minecraft:music_disc_mall",
        [
            "mysticalagriculture:blank_record",
            "#forge:dyes/purple",
            "minecraft:creeper_head",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_stal",
        [
            "mysticalagriculture:blank_record",
            "#forge:dyes/black",
            "minecraft:creeper_head",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_13",
        [
            "mysticalagriculture:blank_record",
            "#forge:dyes/yellow",
            "minecraft:creeper_head",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_11",
        [
            "mysticalagriculture:blank_record",
            "#forge:dyes/gray",
            "minecraft:creeper_head",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_5",
        [
            "mysticalagriculture:blank_record",
            "#forge:dyes/cyan",
            "minecraft:deepslate",
            "minecraft:end_stone",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_strad",
        [
            "mysticalagriculture:blank_record",
            "#forge:dyes/white",
            "minecraft:creeper_head",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_far",
        [
            "mysticalagriculture:blank_record",
            "#forge:dyes/cyan",
            "minecraft:creeper_head",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_relic",
        [
            "mysticalagriculture:blank_record",
            "minecraft:stone",
            "minecraft:copper_ingot",
            "minecraft:diamond",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_otherside",
        [
            "mysticalagriculture:blank_record",
            "minecraft:stone",
            "#forge:dyes/cyan",
            "minecraft:ender_pearl",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_cat",
        [
            "mysticalagriculture:blank_record",
            "#forge:dyes/lime",
            "minecraft:creeper_head",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_pigstep",
        [
            "mysticalagriculture:blank_record",
            "minecraft:netherrack",
            "minecraft:gold_ingot",
            "minecraft:netherite_scrap",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_ward",
        [
            "mysticalagriculture:blank_record",
            "#forge:dyes/green",
            "minecraft:creeper_head",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_wait",
        [
            "mysticalagriculture:blank_record",
            "#forge:dyes/light_blue",
            "minecraft:creeper_head",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_chirp",
        [
            "mysticalagriculture:blank_record",
            "#forge:dyes/red",
            "minecraft:creeper_head",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_mellohi",
        [
            "mysticalagriculture:blank_record",
            "#forge:dyes/magenta",
            "minecraft:creeper_head",
        ],
    );
    event.shapeless(
        "minecraft:music_disc_blocks",
        [
            "mysticalagriculture:blank_record",
            "#forge:dyes/orange",
            "minecraft:creeper_head",
        ],
    );

    event.shaped(
        "kubejs:kelp_wing",
        [
            "kk",
            "kk",
            "kk",
        ],
        {
            k: "minecraft:dried_kelp",
        },
    );
    let wing = "kubejs:incomplete_wing";
    sequenced_assembly(
        "kubejs:wing",
        "kubejs:kelp_wing",
        [
            deploying(
                wing,
                [wing, 'minecraft:phantom_membrane']
            ),
            pressing(
                wing,
                wing,
            ),
        ],
    ).transitionalItem(wing).loops(6);
    event.shaped(
        "minecraft:elytra",
        [
            "rsr",
            "w w",
        ],
        {
            r: "cb_microblock:stone_rod",
            s: "minecraft:nether_star",
            w: "kubejs:wing",
        },
    );
    haunting(
        Item.of("minecraft:chicken_spawn_egg").withChance(0.125),
        "minecraft:egg",
    );
    event.shaped(
        Item.of(
            'enderio:broken_spawner',
            '{BlockEntityTag:{EntityStorage:{Entity:{id:"minecraft:chicken"}}}}',
        ),
        [
            'bbb',
            'beb',
            'bbb',
        ],
        {
            b: "minecraft:iron_bars",
            e: "minecraft:chicken_spawn_egg",
        },
    );
    let gapple = "kubejs:incomplete_gapple";
    sequenced_assembly(
        Item.of("minecraft:enchanted_golden_apple"),
        Item.of("minecraft:apple"),
        [
            deploying(
                gapple,
                [gapple, 'minecraft:gold_block']
            ),
            filling(
                gapple,
                [gapple, {fluidTag: 'forge:experience', amount: 250}]
            ),
            deploying(
                gapple,
                [gapple, 'minecraft:gold_block']
            ),
            pressing(
                gapple,
                gapple,
            ),
        ],
    ).transitionalItem(gapple).loops(4);
    haunting(
        Item.of("create:experience_nugget").withChance(0.01),
        "minecraft:rotten_flesh",
    );
    crushing(
        "enderio:powdered_cobalt",
        "tconstruct:cobalt_ingot",
    );
    event.smelting(
        "tconstruct:cobalt_ingot",
        "#forge:dusts/cobalt",
    );
    crushing(
        ["kubejs:crushed_netherrack", Item.of("create:cinder_flour").withChance(0.5)],
        "minecraft:netherrack",
    ).processingTime(250).id("create:crushing/netherrack");
    crushing(
        ["create:cinder_flour", Item.of("create:cinder_flour").withChance(0.5)],
        "kubejs:crushed_netherrack",
    ).processingTime(350);
    splashing(
        [Item.of("minecraft:quartz").withChance(0.125), Item.of("minecraft:gold_nugget").withChance(0.0625), Item.of("tconstruct:cobalt_nugget").withChance(0.03125), Item.of("create:cinder_flour").withChance(0.25)],
        "kubejs:crushed_netherrack",
    );

    castingBasin(
        "minecraft:reinforced_deepslate",
        "tconstruct:molten_iron", 810,
        200,
        "minecraft:deepslate",
    );
    castingBasin(
        "minecraft:gilded_blackstone",
        "tconstruct:molten_gold", 180,
        60,
        "minecraft:blackstone",
    );
    splashing("minecraft:copper_block", "minecraft:oxidized_copper");

    compacting(
        "minecraft:crimson_nylium",
        [
            "minecraft:crimson_fungus",
            "minecraft:netherrack",
        ],
    );
    compacting(
        "minecraft:warped_nylium",
        [
            "minecraft:warped_fungus",
            "minecraft:netherrack",
        ],
    );
});