ServerEvents.recipes(event => {
    const {
        conversion,
        crushing,
        cutting,
        milling,
        basin,
        mixing,
        compacting,
        pressing,
        sandpaper_polishing,
        splashing,
        haunting,
        deploying,
        filling,
        emptying,
        item_application,
        mechanical_crafting,
        sequenced_assembly,
    } = event.recipes.create;
    const /** @deprecated */washing = splashing;
    function casting(kind, result, fluid, fluidMb, coolingTime, castItem, castConsumed) {
        if (castConsumed === undefined) {
            castConsumed = true;
        }
        return event.custom(castItem ? {
            type: `tconstruct:casting_${kind}`,
            fluid: fluid.startsWith("#")
                ? {tag: fluid.slice(1), amount: fluidMb}
                : {fluid: fluid, amount: fluidMb},
            cooling_time: coolingTime,
            result: result.startsWith("#")
                ? {tag: result.slice(1)}
                : {item: result},
            cast: castItem.startsWith("#")
                ? {tag: castItem.slice(1)}
                : {item: castItem},
            cast_consumed: castConsumed,
        } : {
            type: `tconstruct:casting_${kind}`,
            fluid: fluid.startsWith("#")
                ? {tag: fluid.slice(1), amount: fluidMb}
                : {fluid: fluid, amount: fluidMb},
            cooling_time: coolingTime,
            result: result.startsWith("#")
                ? {tag: result.slice(1)}
                : {item: result},
        });
    };
    function castingBasin(result, fluid, fluidMb, coolingTime, castItem, castConsumed) {
        return casting("basin", result, fluid, fluidMb, coolingTime, castItem, castConsumed);
    };
    function castingTable(result, fluid, fluidMb, coolingTime, castItem, castConsumed) {
        return casting("table", result, fluid, fluidMb, coolingTime, castItem, castConsumed);
    };
    function melting(result, mb, ingredient, time, temperature) {
        if (temperature === undefined) {
            temperature = 1000;
        }
        return event.custom({
            type: "tconstruct:melting",
            ingredient: ingredient.startsWith("#")
                ? {tag: ingredient.slice(1)}
                : {item: ingredient},
            result:
                result.startsWith("#")
                    ? {tag: result.slice(1), amount: mb}
                    : {fluid: result, amount: mb},
            temperature: temperature,
            time: time,
        });
    }
    event.replaceInput(
        {input: "createaddition:zinc_sheet"},
        "createaddition:zinc_sheet",
        "#forge:plates/zinc",
    );
    event.replaceInput(
        {input: "createdeco:zinc_sheet"},
        "createdeco:zinc_sheet",
        "#forge:plates/zinc",
    );
    event.replaceInput(
        {input: "createdeco:netherite_sheet"},
        "createdeco:netherite_sheet",
        "#forge:plates/netherite",
    );
    event.replaceInput(
        {input: "createaddition:electrum_ingot"},
        "createaddition:electrum_ingot",
        "#forge:ingots/electrum",
    );
    event.replaceInput(
        {input: "create_more_additions:silver_ingot"},
        "create_more_additions:silver_ingot",
        "#forge:ingots/silver",
    );
    event.replaceInput(
        {input: "create:copper_sheet", mod: "createdeco"},
        "create:copper_sheet",
        "#forge:plates/copper",
    );
    event.replaceInput(
        {input: "create:iron_sheet", mod: "createdeco"},
        "create:iron_sheet",
        "#forge:plates/iron",
    );

    const thermalDustRecipe = (output, input) => {
        milling(
            output,
            input,
        );
        crushing(
            [output, Item.of(output).withChance(0.05)],
            input,
        );
    };

    thermalDustRecipe('thermal:emerald_dust', 'minecraft:emerald');
    thermalDustRecipe('thermal:sulfur_dust', 'thermal:sulfur');
    thermalDustRecipe('thermal:cinnabar_dust', 'thermal:cinnabar');
    thermalDustRecipe('thermal:quartz_dust', 'minecraft:quartz');
    thermalDustRecipe('thermal:apatite_dust', 'thermal:apatite');
    thermalDustRecipe('thermal:niter_dust', 'thermal:niter');
    melting(
        "#forge:redstone", 100,
        "minecraft:redstone",
        3,
    );
    melting(
        "#forge:redstone", 900,
        "minecraft:redstone_block",
        27,
    );
    castingBasin(
        "minecraft:redstone_block",
        "#forge:redstone", 900,
        27
    );
    castingTable(
        "minecraft:redstone",
        "#forge:redstone", 100,
        3
    );

    melting(
        "#forge:glowstone", 250,
        "minecraft:glowstone_dust",
        5,
    );
    melting(
        "#forge:glowstone", 1000,
        "minecraft:glowstone",
        20,
    );
    castingBasin(
        "minecraft:glowstone",
        "#forge:glowstone", 1000,
        20,
    );
    castingTable(
        "minecraft:glowstone_dust",
        "#forge:glowstone", 250,
        5,
    );

    event.replaceInput(
        {
            input: "minecraft:honeycomb",
            not: [
                {id: "minecraft:beehive"},
                {id: "minecraft:honeycomb_block"},
                {id: "createaddition:mixing/biomass_from_honeycomb"}
            ],
        },
        "minecraft:honeycomb",
        "#kubejs:wax"
    );

    crushing(
        "thermal:iron_dust",
        "minecraft:iron_ingot"
    );
    crushing(
        Item.of("thermal:sawdust", 8),
        "#forge:logs"
    );
    melting(
        "#forge:experience", 60,
        "create:experience_nugget",
        9,
        500,
    );
    melting(
        "#forge:experience", 540,
        "create:experience_block",
        81,
        500,
    );
    castingTable(
        "create:experience_nugget",
        "#forge:experience", 60,
        9,
        "tconstruct:nugget_cast",
        false,
    );
    castingTable(
        "create:experience_nugget",
        "#forge:experience", 60,
        9,
        "tconstruct:nugget_sand_cast",
        true,
    );
    castingBasin(
        "create:experience_block",
        "#forge:experience", 540,
        81,
    );
    emptying(
        [Fluid.of("enderio:xp_juice", 250), "minecraft:glass_bottle"],
        "minecraft:experience_bottle",
    );
    filling(
        "minecraft:experience_bottle",
        ["minecraft:glass_bottle", {fluidTag: 'forge:experience', amount: 250}]
    );
    crushing(
        [
            "kubejs:crushed_raw_cobalt",
            Item.of("create:experience_nugget", 2).withChance(.75)
        ],
        "#forge:raw_materials/cobalt",
    ).processingTime(400);
    crushing(
        [
            Item.of("kubejs:crushed_raw_cobalt", 9),
            Item.of("create:experience_nugget", 18).withChance(0.75),
        ],
        "#forge:storage_blocks/raw_cobalt",
    ).processingTime(400);
    crushing(
        [
            "kubejs:crushed_raw_cobalt",
            Item.of("kubejs:crushed_raw_cobalt").withChance(0.75),
            Item.of("create:experience_nugget", 2).withChance(0.75),
            Item.of("minecraft:netherrack").withChance(0.125)
        ],
        "#forge:ores/cobalt",
    ).processingTime(250);
    event.blasting(
        "tconstruct:cobalt_ingot",
        "kubejs:crushed_raw_cobalt",
    );
    event.smelting(
        "tconstruct:cobalt_ingot",
        "kubejs:crushed_raw_cobalt",
    );
    event.blasting(
        "tconstruct:cobalt_ingot",
        "#forge:dusts/cobalt",
    );
    event.smelting(
        "tconstruct:cobalt_ingot",
        "#forge:dusts/cobalt",
    );
    splashing(
        Item.of("tconstruct:cobalt_nugget", 9),
        "kubejs:crushed_raw_cobalt",
    );
    const oreRecipe = (drop, count, ore) => crushing(
        [
            Item.of(drop, count),
            Item.of(drop).withChance(0.25),
            Item.of("create:experience_nugget").withChance(0.75),
            Item.of("minecraft:cobblestone").withChance(0.125),
        ],
        ore,
    ).processingTime(250);
    const deepslateOreRecipe = (drop, count, ore) => crushing(
        [
            Item.of(drop, count),
            Item.of(drop).withChance(0.25),
            Item.of("create:experience_nugget").withChance(0.75),
            Item.of("minecraft:cobbled_deepslate").withChance(0.125),
        ],
        ore,
    ).processingTime(350);
    oreRecipe(
        "mysticalagriculture:prosperity_shard", 3,
        "mysticalagriculture:prosperity_ore"
    );
    deepslateOreRecipe(
        "mysticalagriculture:prosperity_shard", 4,
        "mysticalagriculture:deepslate_prosperity_ore"
    );
    oreRecipe(
        "mysticalagriculture:inferium_essence", 4,
        "mysticalagriculture:inferium_ore"
    );
    deepslateOreRecipe(
        "mysticalagriculture:inferium_essence", 5,
        "mysticalagriculture:deepslate_inferium_ore"
    );

    deepslateOreRecipe("thermal:apatite", 3, "thermal:deepslate_apatite_ore");
    deepslateOreRecipe("thermal:cinnabar", 3, "thermal:deepslate_cinnabar_ore");
    deepslateOreRecipe("thermal:niter", 3, "thermal:deepslate_niter_ore");
    deepslateOreRecipe("thermal:sulfur", 3, "thermal:deepslate_sulfur_ore");

    oreRecipe("thermal:ruby", 1, "thermal:ruby_ore");
    deepslateOreRecipe("thermal:ruby", 1, "thermal:deepslate_ruby_ore");
    oreRecipe("thermal:sapphire", 1, "thermal:sapphire_ore");
    deepslateOreRecipe("thermal:sapphire", 1, "thermal:deepslate_sapphire_ore");

    event.remove(
        {id: "create_more_additions:silver/crushed_raw_silver_from_crushing_deepslate_ore"}
    );
    event.remove(
        {id: "create_more_additions:silver/crushed_raw_silver_from_crushing_ore"}
    );
    event.remove(
        {id: "create_more_additions:silver/crushed_raw_silver_from_crushing_raw_silver"}
    );
    event.remove(
        {id: "create_more_additions:silver/crushed_raw_silver_from_crushing_raw_ore_block"}
    );
});
ServerEvents.tags('item', event => {
    event.add("kubejs:wax", "minecraft:honeycomb");
    event.add("forge:plates/zinc", "createdeco:zinc_sheet");
    event.add("forge:plates", "createdeco:zinc_sheet");
    event.add("forge:plates/netherite", "createdeco:netherite_sheet");
});