/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    abstract class CharsetDecoder {
        getClass(): typeof any;
        replacement(): string;
        maxCharsPerByte(): number;
        averageCharsPerByte(): number;
        onMalformedInput(arg0: Internal.CodingErrorAction_): this;
        notify(): void;
        unmappableCharacterAction(): Internal.CodingErrorAction;
        wait(arg0: number, arg1: number): void;
        onUnmappableCharacter(arg0: Internal.CodingErrorAction_): this;
        decode(arg0: Internal.ByteBuffer_, arg1: Internal.CharBuffer_, arg2: boolean): Internal.CoderResult;
        malformedInputAction(): Internal.CodingErrorAction;
        reset(): this;
        isAutoDetecting(): boolean;
        toString(): string;
        charset(): Internal.Charset;
        notifyAll(): void;
        flush(arg0: Internal.CharBuffer_): Internal.CoderResult;
        replaceWith(arg0: string): this;
        detectedCharset(): Internal.Charset;
        decode(arg0: Internal.ByteBuffer_): Internal.CharBuffer;
        isCharsetDetected(): boolean;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        get class(): typeof any
        get autoDetecting(): boolean
        get charsetDetected(): boolean
    }
    type CharsetDecoder_ = CharsetDecoder;
    class RotatedBlockProvider extends Internal.BlockStateProvider {
        constructor(arg0: Internal.Block_)
        getClass(): typeof any;
        toString(): string;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static simple(arg0: Internal.Block_): Internal.SimpleStateProvider;
        hashCode(): number;
        static simple(arg0: Internal.BlockState_): Internal.SimpleStateProvider;
        wait(): void;
        static "simple(net.minecraft.world.level.block.state.BlockState)"(arg0: Internal.BlockState_): Internal.SimpleStateProvider;
        wait(arg0: number): void;
        getState(arg0: Internal.RandomSource_, arg1: BlockPos_): Internal.BlockState;
        equals(arg0: any): boolean;
        static "simple(net.minecraft.world.level.block.Block)"(arg0: Internal.Block_): Internal.SimpleStateProvider;
        get class(): typeof any
        static readonly CODEC: Internal.Codec<Internal.RotatedBlockProvider>;
    }
    type RotatedBlockProvider_ = RotatedBlockProvider;
    interface ShortIterable extends Internal.Iterable<number> {
        /**
         * @deprecated
        */
        "forEach(java.util.function.Consumer)"(arg0: Internal.Consumer_<number>): void;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        iterator(): Internal.Iterator<any>;
        spliterator(): Internal.Spliterator<any>;
        "forEach(it.unimi.dsi.fastutil.shorts.ShortConsumer)"(arg0: Internal.ShortConsumer_): void;
        forEach(arg0: Internal.ShortConsumer_): void;
        forEach(arg0: Internal.IntConsumer_): void;
        "forEach(java.util.function.IntConsumer)"(arg0: Internal.IntConsumer_): void;
        intIterator(): Internal.IntIterator;
        intSpliterator(): Internal.IntSpliterator;
    }
    type ShortIterable_ = ShortIterable;
    class WrappedGenericStack extends Internal.AEBaseItem {
        constructor(arg0: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        handler$cfm000$onUseOn(context: Internal.UseOnContext_, cir: Internal.CallbackInfoReturnable_<any>): void;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        addToMainCreativeTab(arg0: Internal.CreativeModeTab$Output_): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        static wrap(arg0: Internal.AEKey_, arg1: number): Internal.ItemStack;
        getDescriptionId(): string;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        isEdible(): boolean;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        unwrapWhat(arg0: Internal.ItemStack_): Internal.AEKey;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        unwrapAmount(arg0: Internal.ItemStack_): number;
        static wrap(arg0: appeng.api.stacks.GenericStack_): Internal.ItemStack;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        self(): Internal.Item;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        getRegistryName(): ResourceLocation;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set burnTime(i: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        get registryName(): ResourceLocation
    }
    type WrappedGenericStack_ = WrappedGenericStack;
    interface IRecipeTypeInfo {
        abstract getId(): ResourceLocation;
        abstract getType<T extends Internal.RecipeType<any>>(): T;
        abstract getSerializer<T extends Internal.RecipeSerializer<any>>(): T;
        get id(): ResourceLocation
        get type(): T
        get serializer(): T
    }
    type IRecipeTypeInfo_ = IRecipeTypeInfo;
    interface IDelayedWaitCondition {
        abstract runDelayed(arg0: Internal.IDelayedWaitCondition$DelayedWaitConditionContext_): boolean;
        (arg0: Internal.IDelayedWaitCondition$DelayedWaitConditionContext): boolean;
        readonly NBT_DELAY: ("Delay") & (string);
    }
    type IDelayedWaitCondition_ = IDelayedWaitCondition | ((arg0: Internal.IDelayedWaitCondition$DelayedWaitConditionContext)=> boolean);
    class ColorApplicatorItem extends Internal.AEBasePoweredItem implements Internal.IMouseWheelItem, Internal.IBlockTool, Internal.IBasicCellItem {
        constructor(arg0: Internal.Item$Properties_)
        cycleColors(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: number): void;
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        addToMainCreativeTab(arg0: Internal.CreativeModeTab$Output_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        setFuzzyMode(arg0: Internal.ItemStack_, arg1: Internal.FuzzyMode_): void;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getKeyType(): Internal.AEKeyType;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        isEditable(arg0: Internal.ItemStack_): boolean;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        getActiveColor(arg0: Internal.ItemStack_): Internal.AEColor;
        setActiveColor(arg0: Internal.ItemStack_, arg1: Internal.AEColor_): void;
        getAECurrentPower(arg0: Internal.ItemStack_): number;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        static createFullColorApplicator(): Internal.ItemStack;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        abstract "useOn(net.minecraft.world.item.context.UseOnContext)"(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        setAttackSpeed(attackSpeed: number): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        getBytes(arg0: Internal.ItemStack_): number;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        getConfigInventory(arg0: Internal.ItemStack_): Internal.ConfigInventory;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        consumeItem(arg0: Internal.ItemStack_, arg1: Internal.AEItemKey_, arg2: boolean): boolean;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        addCellInformationToTooltip(arg0: Internal.ItemStack_, arg1: Internal.List_<net.minecraft.network.chat.Component>): void;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        getCellTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        self(): Internal.Item;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        setRarity(arg0: Internal.Rarity_): void;
        handler$cfm000$onUseOn(context: Internal.UseOnContext_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getDescriptionId(): string;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getAEMaxPower(arg0: Internal.ItemStack_): number;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        consumeColor(arg0: Internal.ItemStack_, arg1: Internal.AEColor_, arg2: boolean): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        getPowerFlow(arg0: Internal.ItemStack_): Internal.AccessRestriction;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        getTotalTypes(arg0: Internal.ItemStack_): number;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        toString(): string;
        getBytesPerType(arg0: Internal.ItemStack_): number;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        onWheel(arg0: Internal.ItemStack_, arg1: boolean): void;
        isStorageCell(arg0: Internal.ItemStack_): boolean;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        storableInStorageCell(): boolean;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        getIdleDrain(): number;
        notify(): void;
        getChargeRate(arg0: Internal.ItemStack_): number;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        setArmorProtection(armorProtection: number): void;
        getColor(arg0: Internal.ItemStack_): Internal.ItemStack;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        isBlackListed(arg0: Internal.ItemStack_, arg1: Internal.AEKey_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getFuzzyMode(arg0: Internal.ItemStack_): Internal.FuzzyMode;
        extractAEPower(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.Actionable_): number;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        injectAEPower(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.Actionable_): number;
        getUpgrades(arg0: Internal.ItemStack_): Internal.IUpgradeInventory;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        getRegistryName(): ResourceLocation;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        get keyType(): Internal.AEKeyType
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get complex(): boolean
        get descriptionId(): string
        get creativeTab(): string
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        set attackDamage(attackDamage: number)
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get idleDrain(): number
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        get registryName(): ResourceLocation
    }
    type ColorApplicatorItem_ = ColorApplicatorItem;
    class BlockRearAttachment extends Internal.RearAttachment {
        constructor(arg0: Internal.RearAttachmentType_<any>, arg1: Internal.AutomobileEntity_, arg2: Internal.BlockState_, arg3: Internal.BiFunction_<Internal.ContainerLevelAccess, Internal.BlockRearAttachment, Internal.MenuProvider>)
        getClass(): typeof any;
        setAnimation(arg0: number): void;
        toNbt(): Internal.CompoundTag;
        setYaw(arg0: number): void;
        createMenu(arg0: Internal.ContainerLevelAccess_): Internal.MenuProvider;
        static grindstone(arg0: Internal.RearAttachmentType_<any>, arg1: Internal.AutomobileEntity_): Internal.BlockRearAttachment;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        yaw(): number;
        scaledYawVec(): Vec3d;
        yawVec(): Vec3d;
        hasMenu(): boolean;
        static smithingTable(arg0: Internal.RearAttachmentType_<any>, arg1: Internal.AutomobileEntity_): Internal.BlockRearAttachment;
        automobile(): Internal.AutomobileEntity;
        onTrackedYawUpdated(arg0: number): void;
        getPassengerHeightOffset(): number;
        isRideable(): boolean;
        static cartographyTable(arg0: Internal.RearAttachmentType_<any>, arg1: Internal.AutomobileEntity_): Internal.BlockRearAttachment;
        static loom(arg0: Internal.RearAttachmentType_<any>, arg1: Internal.AutomobileEntity_): Internal.BlockRearAttachment;
        onTrackedAnimationUpdated(arg0: number): void;
        readNbt(arg0: Internal.CompoundTag_): void;
        animation(): number;
        onRemoved(): void;
        toString(): string;
        static autoMechanicTable(arg0: Internal.RearAttachmentType_<any>, arg1: Internal.AutomobileEntity_): Internal.BlockRearAttachment;
        static fromNbt(arg0: Internal.CompoundTag_): Internal.RearAttachmentType<any>;
        writeNbt(arg0: Internal.CompoundTag_): void;
        notifyAll(): void;
        pos(): Vec3d;
        pull(arg0: Vec3d_): void;
        yaw(arg0: number): number;
        tick(): void;
        static stonecutter(arg0: Internal.RearAttachmentType_<any>, arg1: Internal.AutomobileEntity_): Internal.BlockRearAttachment;
        hashCode(): number;
        wait(): void;
        static craftingTable(arg0: Internal.RearAttachmentType_<any>, arg1: Internal.AutomobileEntity_): Internal.BlockRearAttachment;
        wait(arg0: number): void;
        updatePacketRequested(arg0: Internal.ServerPlayer_): void;
        origin(): Vec3d;
        equals(arg0: any): boolean;
        get class(): typeof any
        set animation(arg0: number)
        set yaw(arg0: number)
        get passengerHeightOffset(): number
        get rideable(): boolean
        static readonly TITLE_STONECUTTER: (Internal.MutableComponent) & (net.minecraft.network.chat.Component);
        static readonly TITLE_LOOM: (Internal.MutableComponent) & (net.minecraft.network.chat.Component);
        static readonly TITLE_GRINDSTONE: (Internal.MutableComponent) & (net.minecraft.network.chat.Component);
        static readonly TITLE_CARTOGRAPHY: (Internal.MutableComponent) & (net.minecraft.network.chat.Component);
        readonly block: Internal.BlockState;
        static readonly TITLE_CRAFTING: (Internal.MutableComponent) & (net.minecraft.network.chat.Component);
        static readonly TITLE_SMITHING: (Internal.MutableComponent) & (net.minecraft.network.chat.Component);
    }
    type BlockRearAttachment_ = BlockRearAttachment;
    class CrashReport {
        constructor(arg0: string, arg1: Internal.Throwable_)
        getClass(): typeof any;
        static preload(): void;
        getException(): Internal.Throwable;
        getTitle(): string;
        toString(): string;
        saveToFile(arg0: Internal.File_): boolean;
        static forThrowable(arg0: Internal.Throwable_, arg1: string): Internal.CrashReport;
        notifyAll(): void;
        getSystemReport(): Internal.SystemReport;
        getDetails(arg0: Internal.StringBuilder_): void;
        getExceptionMessage(): string;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getFriendlyReport(): string;
        addCategory(arg0: string): Internal.CrashReportCategory;
        hashCode(): number;
        getSaveFile(): Internal.File;
        wait(): void;
        wait(arg0: number): void;
        addCategory(arg0: string, arg1: number): Internal.CrashReportCategory;
        equals(arg0: any): boolean;
        getDetails(): string;
        get class(): typeof any
        get exception(): Internal.Throwable
        get title(): string
        get systemReport(): Internal.SystemReport
        get exceptionMessage(): string
        get friendlyReport(): string
        get saveFile(): Internal.File
        get details(): string
    }
    type CrashReport_ = CrashReport;
    interface RandomGenerator {
        nextFloat(arg0: number): number;
        ints(arg0: number, arg1: number): Internal.IntStream;
        getDefault(): this;
        abstract nextLong(): number;
        nextDouble(): number;
        nextLong(arg0: number, arg1: number): number;
        nextGaussian(): number;
        doubles(arg0: number, arg1: number, arg2: number): Internal.DoubleStream;
        nextDouble(arg0: number): number;
        nextInt(arg0: number): number;
        nextFloat(): number;
        nextLong(arg0: number): number;
        ints(arg0: number, arg1: number, arg2: number): Internal.IntStream;
        nextFloat(arg0: number, arg1: number): number;
        of(arg0: string): this;
        doubles(): Internal.DoubleStream;
        nextInt(): number;
        nextBytes(arg0: number[]): void;
        longs(arg0: number): Internal.LongStream;
        longs(arg0: number, arg1: number, arg2: number): Internal.LongStream;
        nextBoolean(): boolean;
        nextDouble(arg0: number, arg1: number): number;
        nextExponential(): number;
        longs(arg0: number, arg1: number): Internal.LongStream;
        nextInt(arg0: number, arg1: number): number;
        longs(): Internal.LongStream;
        isDeprecated(): boolean;
        doubles(arg0: number): Internal.DoubleStream;
        nextGaussian(arg0: number, arg1: number): number;
        ints(): Internal.IntStream;
        ints(arg0: number): Internal.IntStream;
        doubles(arg0: number, arg1: number): Internal.DoubleStream;
        get "default"(): Internal.RandomGenerator
        get deprecated(): boolean
        (): number;
    }
    type RandomGenerator_ = (()=> number) | RandomGenerator;
    interface StructurePieceAccessor {
        abstract addPiece(arg0: Internal.StructurePiece_): void;
        abstract findCollisionPiece(arg0: Internal.BoundingBox_): Internal.StructurePiece;
    }
    type StructurePieceAccessor_ = StructurePieceAccessor;
    interface SignApplicator {
        abstract tryApplyToSign(arg0: Internal.Level_, arg1: Internal.SignBlockEntity_, arg2: boolean, arg3: Internal.Player_): boolean;
        canApplyToSign(arg0: Internal.SignText_, arg1: Internal.Player_): boolean;
        (arg0: Internal.Level, arg1: Internal.SignBlockEntity, arg2: boolean, arg3: Internal.Player): boolean;
    }
    type SignApplicator_ = ((arg0: Internal.Level, arg1: Internal.SignBlockEntity, arg2: boolean, arg3: Internal.Player)=> boolean) | SignApplicator;
    abstract class ThermalRecipe extends Internal.SerializableRecipe {
        getClass(): typeof any;
        getOutputItemChances(): Internal.List<number>;
        getGroup(): string;
        matches(arg0: Internal.FalseIInventory_, arg1: Internal.Level_): boolean;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        "assemble(net.minecraft.world.Container,net.minecraft.core.RegistryAccess)"(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        getOutputItems(): Internal.List<Internal.ItemStack>;
        getInputFluids(): Internal.List<cofh.lib.common.fluid.FluidIngredient>;
        getInputItems(): Internal.List<Internal.Ingredient>;
        isCatalyzable(): boolean;
        "matches(cofh.lib.common.inventory.FalseIInventory,net.minecraft.world.level.Level)"(arg0: Internal.FalseIInventory_, arg1: Internal.Level_): boolean;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getRemainingItems(arg0: Internal.FalseIInventory_): Internal.NonNullList<Internal.ItemStack>;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        toString(): string;
        notifyAll(): void;
        canCraftInDimensions(arg0: number, arg1: number): boolean;
        "matches(net.minecraft.world.Container,net.minecraft.world.level.Level)"(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        assemble(arg0: Internal.FalseIInventory_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        hashCode(): number;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        getOutputFluids(): Internal.List<Internal.FluidStack>;
        wait(): void;
        isIncomplete(): boolean;
        wait(arg0: number): void;
        getEnergy(): number;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        equals(arg0: any): boolean;
        "assemble(cofh.lib.common.inventory.FalseIInventory,net.minecraft.core.RegistryAccess)"(arg0: Internal.FalseIInventory_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getXp(): number;
        get class(): typeof any
        get outputItemChances(): Internal.List<number>
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get outputItems(): Internal.List<Internal.ItemStack>
        get inputFluids(): Internal.List<cofh.lib.common.fluid.FluidIngredient>
        get inputItems(): Internal.List<Internal.Ingredient>
        get catalyzable(): boolean
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get outputFluids(): Internal.List<Internal.FluidStack>
        get incomplete(): boolean
        get energy(): number
        get xp(): number
    }
    type ThermalRecipe_ = ThermalRecipe;
    abstract class MethodHandle implements Internal.Constable {
        getClass(): typeof any;
        invokeExact(...arg0: any[]): any;
        invokeWithArguments(...arg0: any[]): any;
        type(): Internal.MethodType;
        isVarargsCollector(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        asCollector(arg0: typeof any, arg1: number): this;
        toString(): string;
        describeConstable(): Internal.Optional<Internal.MethodHandleDesc>;
        notifyAll(): void;
        withVarargs(arg0: boolean): this;
        asSpreader(arg0: typeof any, arg1: number): this;
        asFixedArity(): this;
        asVarargsCollector(arg0: typeof any): this;
        asCollector(arg0: number, arg1: typeof any, arg2: number): this;
        "invokeWithArguments(java.lang.Object[])"(...arg0: any[]): any;
        hashCode(): number;
        invokeWithArguments(arg0: Internal.List_<any>): any;
        wait(): void;
        invoke(...arg0: any[]): any;
        asType(arg0: Internal.MethodType_): this;
        wait(arg0: number): void;
        asSpreader(arg0: number, arg1: typeof any, arg2: number): this;
        "invokeWithArguments(java.util.List)"(arg0: Internal.List_<any>): any;
        equals(arg0: any): boolean;
        bindTo(arg0: any): this;
        get class(): typeof any
        get varargsCollector(): boolean
    }
    type MethodHandle_ = MethodHandle;
    class AdvancedDisplayTarget extends Internal.DisplayTarget {
        constructor()
        isReserved(line: number, target: Internal.BlockEntity_, context: Internal.DisplayLinkContext_): boolean;
        getClass(): typeof any;
        getLineOptionText(line: number): net.minecraft.network.chat.Component;
        requiresComponentSanitization(): boolean;
        toString(): string;
        acceptText(line: number, text: Internal.List_<Internal.MutableComponent>, context: Internal.DisplayLinkContext_): void;
        notifyAll(): void;
        provideStats(context: Internal.DisplayLinkContext_): Internal.DisplayTargetStats;
        static reserve(arg0: number, arg1: Internal.BlockEntity_, arg2: Internal.DisplayLinkContext_): void;
        static get(arg0: Internal.LevelAccessor_, arg1: BlockPos_): Internal.DisplayTarget;
        static displayTarget<B extends Internal.Block, P>(arg0: Internal.RegistryEntry_<Internal.DisplayTarget>): Internal.NonNullUnaryOperator<com.tterrag.registrate.builders.BlockBuilder<B, P>>;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static start(): void;
        hashCode(): number;
        static get(arg0: ResourceLocation_): Internal.DisplayTarget;
        wait(): void;
        static stop(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        getMultiblockBounds(level: Internal.LevelAccessor_, pos: BlockPos_): Internal.AABB;
        static prepare(filter: string, maxLines: number): Internal.List<Internal.StationDisplayData>;
        get class(): typeof any
    }
    type AdvancedDisplayTarget_ = AdvancedDisplayTarget;
    class CriterionProgress {
        constructor()
        getClass(): typeof any;
        grant(): void;
        serializeToJson(): Internal.JsonElement;
        toString(): string;
        getObtained(): Internal.Date;
        notifyAll(): void;
        revoke(): void;
        isDone(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static fromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.CriterionProgress;
        hashCode(): number;
        wait(): void;
        static fromJson(arg0: string): Internal.CriterionProgress;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        serializeToNetwork(arg0: Internal.FriendlyByteBuf_): void;
        get class(): typeof any
        get obtained(): Internal.Date
        get done(): boolean
    }
    type CriterionProgress_ = CriterionProgress;
    interface ImageConsumer {
        abstract setPixels(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.ColorModel_, arg5: number[], arg6: number, arg7: number): void;
        abstract setHints(arg0: number): void;
        abstract setDimensions(arg0: number, arg1: number): void;
        abstract setProperties(arg0: Internal.Hashtable_<any, any>): void;
        abstract "setPixels(int,int,int,int,java.awt.image.ColorModel,byte[],int,int)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.ColorModel_, arg5: number[], arg6: number, arg7: number): void;
        abstract imageComplete(arg0: number): void;
        abstract "setPixels(int,int,int,int,java.awt.image.ColorModel,int[],int,int)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.ColorModel_, arg5: number[], arg6: number, arg7: number): void;
        abstract setPixels(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.ColorModel_, arg5: number[], arg6: number, arg7: number): void;
        abstract setColorModel(arg0: Internal.ColorModel_): void;
        set hints(arg0: number)
        set properties(arg0: Internal.Hashtable_<any, any>)
        set colorModel(arg0: Internal.ColorModel_)
        readonly COMPLETESCANLINES: (4) & (number);
        readonly SINGLEPASS: (8) & (number);
        readonly SINGLEFRAME: (16) & (number);
        readonly RANDOMPIXELORDER: (1) & (number);
        readonly TOPDOWNLEFTRIGHT: (2) & (number);
        readonly IMAGEERROR: (1) & (number);
        readonly STATICIMAGEDONE: (3) & (number);
        readonly IMAGEABORTED: (4) & (number);
        readonly SINGLEFRAMEDONE: (2) & (number);
    }
    type ImageConsumer_ = ImageConsumer;
    interface DoubleIterator extends Internal.PrimitiveIterator$OfDouble {
        forEachRemaining(arg0: any): void;
        forEachRemaining(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): void;
        "forEachRemaining(java.util.function.DoubleConsumer)"(arg0: Internal.DoubleConsumer_): void;
        skip(arg0: number): number;
        /**
         * @deprecated
        */
        next(): number;
        abstract nextDouble(): number;
        "forEachRemaining(it.unimi.dsi.fastutil.doubles.DoubleConsumer)"(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): void;
        /**
         * @deprecated
        */
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        remove(): void;
        forEachRemaining(arg0: Internal.DoubleConsumer_): void;
        "forEachRemaining(java.lang.Object)"(arg0: any): void;
        /**
         * @deprecated
        */
        "forEachRemaining(java.util.function.Consumer)"(arg0: Internal.Consumer_<number>): void;
        abstract hasNext(): boolean;
    }
    type DoubleIterator_ = DoubleIterator;
    interface ClientPlayerKJS extends Internal.PlayerKJS {
        getDistance(pos: BlockPos_): number;
        isFake(): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        getStats(): Internal.PlayerStatsJS;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        addFood(f: number, m: number): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getXpLevel(): number;
        setSelectedSlot(index: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        isLiving(): boolean;
        getTotalMovementSpeed(): number;
        rayTrace(): Internal.RayTraceResultJS;
        paint(tag: Internal.CompoundTag_): void;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        getFoodLevel(): number;
        notify(title: net.minecraft.network.chat.Component_, text: net.minecraft.network.chat.Component_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        getCraftingGrid(): Internal.InventoryKJS;
        setXpLevel(l: number): void;
        setFoodLevel(foodLevel: number): void;
        setSaturation(saturation: number): void;
        addXPLevels(l: number): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getPersistentData(): Internal.CompoundTag;
        sendData(channel: string): void;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        getSelectedSlot(): number;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        getOpenInventory(): Internal.AbstractContainerMenu;
        getXp(): number;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        setXp(xp: number): void;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        isMiningBlock(): boolean;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isAmbientCreature(): boolean;
        notify(notification: Notification_): void;
        getInventoryChangeListener(): Internal.KubeJSInventoryListener;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getStages(): Internal.Stages;
        getName(): net.minecraft.network.chat.Component;
        boostElytraFlight(): void;
        addExhaustion(exhaustion: number): void;
        getPassengers(): Internal.EntityArrayList;
        giveInHand(item: Internal.ItemStack_): void;
        setMouseItem(item: Internal.ItemStack_): void;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sendData(channel: string, data: Internal.CompoundTag_): void;
        addXP(xp: number): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        getInventory(): Internal.InventoryKJS;
        give(item: Internal.ItemStack_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        spawn(): void;
        getMainHandItem(): Internal.ItemStack;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        isSelf(): boolean;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        sendInventoryUpdate(): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        getMouseItem(): Internal.ItemStack;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        abstract getData(): Internal.AttachedData<Internal.Player>;
        getProfile(): Internal.GameProfile;
        getSaturation(): number;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        runCommand(command: string): number;
        addItemCooldown(item: Internal.Item_, ticks: number): void;
        get fake(): boolean
        get stats(): Internal.PlayerStatsJS
        set defaultMovementSpeedMultiplier(speed: number)
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get xpLevel(): number
        set selectedSlot(index: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get foodLevel(): number
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get craftingGrid(): Internal.InventoryKJS
        set xpLevel(l: number)
        set foodLevel(foodLevel: number)
        set saturation(saturation: number)
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get persistentData(): Internal.CompoundTag
        get item(): Internal.ItemStack
        set x(x: number)
        get selectedSlot(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get openInventory(): Internal.AbstractContainerMenu
        get xp(): number
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set xp(xp: number)
        get defaultMovementSpeed(): number
        get miningBlock(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get ambientCreature(): boolean
        get inventoryChangeListener(): Internal.KubeJSInventoryListener
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get stages(): Internal.Stages
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set mouseItem(item: Internal.ItemStack_)
        set totalMovementSpeedMultiplier(speed: number)
        get inventory(): Internal.InventoryKJS
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set feetArmorItem(item: Internal.ItemStack_)
        get self(): boolean
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get mouseItem(): Internal.ItemStack
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get data(): Internal.AttachedData<Internal.Player>
        get profile(): Internal.GameProfile
        get saturation(): number
        set headArmorItem(item: Internal.ItemStack_)
        (): Internal.AttachedData_<Internal.Player>;
    }
    type ClientPlayerKJS_ = ClientPlayerKJS | (()=> Internal.AttachedData_<Internal.Player>);
    interface GenericLoaderRegistry$IHaveLoader {
        abstract getLoader(): Internal.RecordLoadable<Internal.GenericLoaderRegistry$IHaveLoader>;
        get loader(): Internal.RecordLoadable<Internal.GenericLoaderRegistry$IHaveLoader>
        (): Internal.RecordLoadable_<Internal.GenericLoaderRegistry$IHaveLoader>;
    }
    type GenericLoaderRegistry$IHaveLoader_ = (()=> Internal.RecordLoadable_<Internal.GenericLoaderRegistry$IHaveLoader>) | GenericLoaderRegistry$IHaveLoader;
    interface ProgressListener {
        abstract progressStart(arg0: net.minecraft.network.chat.Component_): void;
        abstract stop(): void;
        abstract progressStartNoAbort(arg0: net.minecraft.network.chat.Component_): void;
        abstract progressStagePercentage(arg0: number): void;
        abstract progressStage(arg0: net.minecraft.network.chat.Component_): void;
    }
    type ProgressListener_ = ProgressListener;
    class BeehiveBlockEntity$BeeReleaseStatus extends Internal.Enum<Internal.BeehiveBlockEntity$BeeReleaseStatus> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        "compareTo(net.minecraft.world.level.block.entity.BeehiveBlockEntity$BeeReleaseStatus)"(arg0: Internal.BeehiveBlockEntity$BeeReleaseStatus_): number;
        toString(): string;
        notifyAll(): void;
        static values(): Internal.BeehiveBlockEntity$BeeReleaseStatus[];
        compareTo(arg0: Internal.BeehiveBlockEntity$BeeReleaseStatus_): number;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        name(): string;
        getDeclaringClass(): typeof Internal.BeehiveBlockEntity$BeeReleaseStatus;
        hashCode(): number;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        static valueOf(arg0: string): Internal.BeehiveBlockEntity$BeeReleaseStatus;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.BeehiveBlockEntity$BeeReleaseStatus>>;
        get class(): typeof any
        get declaringClass(): typeof Internal.BeehiveBlockEntity$BeeReleaseStatus
        static readonly EMERGENCY: (Internal.BeehiveBlockEntity$BeeReleaseStatus) & (Internal.BeehiveBlockEntity$BeeReleaseStatus);
        static readonly HONEY_DELIVERED: (Internal.BeehiveBlockEntity$BeeReleaseStatus) & (Internal.BeehiveBlockEntity$BeeReleaseStatus);
        static readonly BEE_RELEASED: (Internal.BeehiveBlockEntity$BeeReleaseStatus) & (Internal.BeehiveBlockEntity$BeeReleaseStatus);
    }
    type BeehiveBlockEntity$BeeReleaseStatus_ = "bee_released" | "honey_delivered" | BeehiveBlockEntity$BeeReleaseStatus | "emergency";
    interface IClientConfiguration {
        abstract getEnableMouseIndicatorInRadialMenu(): Internal.Supplier<boolean>;
        abstract getInvertBitBagFullness(): Internal.Supplier<boolean>;
        abstract getPreviewChiselingColor(): Internal.Supplier<Internal.List<number>>;
        abstract getPreviewPlacementColor(): Internal.Supplier<Internal.List<number>>;
        abstract getShouldBrokenBlocksBeAddedToClipboard(): Internal.Supplier<boolean>;
        getInstance(): this;
        abstract getFaceLayerCacheSize(): Internal.Supplier<number>;
        abstract getPatternExportPath(): Internal.Supplier<string>;
        abstract getUseGetLightValue(): Internal.Supplier<boolean>;
        abstract getFailedPlacementRenderMode(): Internal.Supplier<Internal.PlacementPreviewRenderMode>;
        abstract getMutatorPreviewChiselingColor(): Internal.Supplier<Internal.List<number>>;
        abstract getBitStorageContentCacheSize(): Internal.Supplier<number>;
        abstract getPreviewRenderer(): Internal.Supplier<string>;
        abstract getShouldScrollInteractionsChangeMode(): Internal.Supplier<boolean>;
        abstract getModelBuildingThreadCount(): Internal.Supplier<number>;
        abstract getInvertPickBlockBehaviour(): Internal.Supplier<boolean>;
        abstract getSuccessfulPlacementColor(): Internal.Supplier<Vec4f>;
        abstract getToolModeRenderer(): Internal.Supplier<string>;
        abstract getMissingBitsOrSpacePatternPlacementColor(): Internal.Supplier<Vec4f>;
        abstract getModelCacheSize(): Internal.Supplier<number>;
        abstract getShowCoolDownError(): Internal.Supplier<boolean>;
        abstract getMutatorPreviewDebug(): Internal.Supplier<boolean>;
        abstract getEnableFaceLightmapExtraction(): Internal.Supplier<boolean>;
        abstract getSuccessfulPlacementRenderMode(): Internal.Supplier<Internal.PlacementPreviewRenderMode>;
        abstract getMutatorPreviewPlacementColor(): Internal.Supplier<Internal.List<number>>;
        abstract getNotFittingPatternPlacementColor(): Internal.Supplier<Vec4f>;
        abstract getClipboardSize(): Internal.Supplier<number>;
        abstract getCullTestingCacheSize(): Internal.Supplier<number>;
        abstract getStackModelCacheSize(): Internal.Supplier<number>;
        abstract getShouldPickedBlocksBeAddedToClipboard(): Internal.Supplier<boolean>;
        get enableMouseIndicatorInRadialMenu(): Internal.Supplier<boolean>
        get invertBitBagFullness(): Internal.Supplier<boolean>
        get previewChiselingColor(): Internal.Supplier<Internal.List<number>>
        get previewPlacementColor(): Internal.Supplier<Internal.List<number>>
        get shouldBrokenBlocksBeAddedToClipboard(): Internal.Supplier<boolean>
        get instance(): Internal.IClientConfiguration
        get faceLayerCacheSize(): Internal.Supplier<number>
        get patternExportPath(): Internal.Supplier<string>
        get useGetLightValue(): Internal.Supplier<boolean>
        get failedPlacementRenderMode(): Internal.Supplier<Internal.PlacementPreviewRenderMode>
        get mutatorPreviewChiselingColor(): Internal.Supplier<Internal.List<number>>
        get bitStorageContentCacheSize(): Internal.Supplier<number>
        get previewRenderer(): Internal.Supplier<string>
        get shouldScrollInteractionsChangeMode(): Internal.Supplier<boolean>
        get modelBuildingThreadCount(): Internal.Supplier<number>
        get invertPickBlockBehaviour(): Internal.Supplier<boolean>
        get successfulPlacementColor(): Internal.Supplier<Vec4f>
        get toolModeRenderer(): Internal.Supplier<string>
        get missingBitsOrSpacePatternPlacementColor(): Internal.Supplier<Vec4f>
        get modelCacheSize(): Internal.Supplier<number>
        get showCoolDownError(): Internal.Supplier<boolean>
        get mutatorPreviewDebug(): Internal.Supplier<boolean>
        get enableFaceLightmapExtraction(): Internal.Supplier<boolean>
        get successfulPlacementRenderMode(): Internal.Supplier<Internal.PlacementPreviewRenderMode>
        get mutatorPreviewPlacementColor(): Internal.Supplier<Internal.List<number>>
        get notFittingPatternPlacementColor(): Internal.Supplier<Vec4f>
        get clipboardSize(): Internal.Supplier<number>
        get cullTestingCacheSize(): Internal.Supplier<number>
        get stackModelCacheSize(): Internal.Supplier<number>
        get shouldPickedBlocksBeAddedToClipboard(): Internal.Supplier<boolean>
    }
    type IClientConfiguration_ = IClientConfiguration;
    class ModificationTableBlock extends Internal.Block {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        asItem(): Internal.Item;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getName(): Internal.MutableComponent;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type ModificationTableBlock_ = ModificationTableBlock;
    class SignableCommand <S> extends Internal.Record {
        constructor(arg0: Internal.List_<Internal.SignableCommand$Argument<S>>)
        static of<S>(arg0: Internal.ParseResults_<S>): Internal.SignableCommand<S>;
        getClass(): typeof any;
        "arguments"(): Internal.List<Internal.SignableCommand$Argument<S>>;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
    }
    type SignableCommand_<S> = SignableCommand<S>;
    class BiomeSpecialEffectsBuilder extends Internal.BiomeSpecialEffects$Builder {
        getClass(): typeof any;
        getAmbientAdditionsSound(): Internal.Optional<Internal.AmbientAdditionsSettings>;
        ambientAdditionsSound(arg0: Internal.AmbientAdditionsSettings_): Internal.BiomeSpecialEffects$Builder;
        waterColor(): number;
        grassColorOverride(arg0: number): Internal.BiomeSpecialEffects$Builder;
        getAmbientMoodSound(): Internal.Optional<Internal.AmbientMoodSettings>;
        getFoliageColorOverride(): Internal.Optional<number>;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        ambientParticle(arg0: Internal.AmbientParticleSettings_): Internal.BiomeSpecialEffects$Builder;
        getAmbientLoopSound(): Internal.Optional<Internal.Holder<Internal.SoundEvent>>;
        build(): Internal.BiomeSpecialEffects;
        waterFogColor(arg0: number): Internal.BiomeSpecialEffects$Builder;
        getGrassColorOverride(): Internal.Optional<number>;
        puzzleslib$setBackgroundMusic(arg0: Internal.Optional_<any>): void;
        puzzleslib$setGrassColorOverride(arg0: Internal.Optional_<any>): void;
        getFogColor(): number;
        getSkyColor(): number;
        grassColorModifier(arg0: Internal.BiomeSpecialEffects$GrassColorModifier_): Internal.BiomeSpecialEffects$Builder;
        static create(arg0: number, arg1: number, arg2: number, arg3: number): Internal.BiomeSpecialEffectsBuilder;
        getGrassColorModifier(): Internal.BiomeSpecialEffects$GrassColorModifier;
        static copyOf(arg0: Internal.BiomeSpecialEffects_): Internal.BiomeSpecialEffectsBuilder;
        toString(): string;
        fogColor(arg0: number): Internal.BiomeSpecialEffects$Builder;
        ambientLoopSound(arg0: Internal.Holder_<Internal.SoundEvent>): Internal.BiomeSpecialEffects$Builder;
        backgroundMusic(arg0: Internal.Music_): Internal.BiomeSpecialEffects$Builder;
        notifyAll(): void;
        puzzleslib$setAmbientAdditionsSettings(arg0: Internal.Optional_<any>): void;
        waterColor(arg0: number): Internal.BiomeSpecialEffects$Builder;
        ambientMoodSound(arg0: Internal.AmbientMoodSettings_): Internal.BiomeSpecialEffects$Builder;
        puzzleslib$setFoliageColorOverride(arg0: Internal.Optional_<any>): void;
        hashCode(): number;
        getBackgroundMusic(): Internal.Optional<Internal.Music>;
        foliageColorOverride(arg0: number): Internal.BiomeSpecialEffects$Builder;
        getWaterFogColor(): number;
        puzzleslib$setAmbientMoodSettings(arg0: Internal.Optional_<any>): void;
        wait(): void;
        wait(arg0: number): void;
        puzzleslib$setAmbientParticle(arg0: Internal.Optional_<any>): void;
        getAmbientParticle(): Internal.Optional<Internal.AmbientParticleSettings>;
        skyColor(arg0: number): Internal.BiomeSpecialEffects$Builder;
        equals(arg0: any): boolean;
        puzzleslib$setAmbientLoopSoundEvent(arg0: Internal.Optional_<any>): void;
        get class(): typeof any
        get ambientAdditionsSound(): Internal.Optional<Internal.AmbientAdditionsSettings>
        get ambientMoodSound(): Internal.Optional<Internal.AmbientMoodSettings>
        get foliageColorOverride(): Internal.Optional<number>
        get ambientLoopSound(): Internal.Optional<Internal.Holder<Internal.SoundEvent>>
        get grassColorOverride(): Internal.Optional<number>
        get fogColor(): number
        get skyColor(): number
        get grassColorModifier(): Internal.BiomeSpecialEffects$GrassColorModifier
        get backgroundMusic(): Internal.Optional<Internal.Music>
        get waterFogColor(): number
        get ambientParticle(): Internal.Optional<Internal.AmbientParticleSettings>
    }
    type BiomeSpecialEffectsBuilder_ = BiomeSpecialEffectsBuilder;
    class SemaphoreItem extends Internal.BlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        static setBlockEntityData(arg0: Internal.ItemStack_, arg1: Internal.BlockEntityType_<any>, arg2: Internal.CompoundTag_): void;
        handler$cfm000$onUseOn(context: Internal.UseOnContext_, cir: Internal.CallbackInfoReturnable_<any>): void;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getDescriptionId(): string;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        isEdible(): boolean;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getBlockEntityData(arg0: Internal.ItemStack_): Internal.CompoundTag;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        removeFromBlockToItemMap(arg0: Internal.Map_<Internal.Block, Internal.Item>, arg1: Internal.Item_): void;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        static updateCustomBlockEntityTag(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.ItemStack_): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        place(pContext: Internal.BlockPlaceContext_): Internal.InteractionResult;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        getBlock(): Internal.Block;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        updatePlacementContext(arg0: Internal.BlockPlaceContext_): Internal.BlockPlaceContext;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        registerBlocks(arg0: Internal.Map_<Internal.Block, Internal.Item>, arg1: Internal.Item_): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static updateState<T extends Internal.Comparable<T>>(arg0: Internal.BlockState_, arg1: Internal.Property_<T>, arg2: string): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        self(): Internal.Item;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        puzzleslib$setBlock(arg0: Internal.Block_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set burnTime(i: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get block(): Internal.Block
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
    }
    type SemaphoreItem_ = SemaphoreItem;
    class ImmutableCollections$List12 <E> extends Internal.ImmutableCollections$AbstractImmutableList<E> implements Internal.Serializable {
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        sort(arg0: Internal.Comparator_<E>): void;
        notify(): void;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        "remove(int)"(arg0: number): E;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        addAll(arg0: number, arg1: Internal.Collection_<E>): boolean;
        abstract addAll(arg0: Internal.Collection_<E>): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        subList(arg0: number, arg1: number): Internal.List<E>;
        indexOf(arg0: any): number;
        add(arg0: number, arg1: E): void;
        forEach(arg0: Internal.Consumer_<E>): void;
        toArray<T>(arg0: T[]): T[];
        abstract remove(arg0: any): boolean;
        abstract "remove(java.lang.Object)"(arg0: any): boolean;
        listIterator(arg0: number): Internal.ListIterator<E>;
        iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        stream(): Internal.Stream<E>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        wait(): void;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        static "of(java.lang.Object[])"<E>(...arg0: E[]): Internal.List<E>;
        lastIndexOf(arg0: any): number;
        getClass(): typeof any;
        get(arg0: number): E;
        abstract add(arg0: E): boolean;
        listIterator(): Internal.ListIterator<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        parallelStream(): Internal.Stream<E>;
        isEmpty(): boolean;
        wait(arg0: number, arg1: number): void;
        set(arg0: number, arg1: E): E;
        static of<E>(...arg0: E[]): Internal.List<E>;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        remove(arg0: number): E;
        contains(arg0: any): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        static "of(java.lang.Object)"<E>(arg0: E): Internal.List<E>;
        replaceAll(arg0: Internal.UnaryOperator_<E>): void;
        toString(): string;
        notifyAll(): void;
        "toArray(java.lang.Object[])"<T>(arg0: T[]): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        "toArray(java.util.function.IntFunction)"<T>(arg0: Internal.IntFunction_<T[]>): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        toArray(): any[];
        size(): number;
        hashCode(): number;
        abstract clear(): void;
        wait(arg0: number): void;
        spliterator(): Internal.Spliterator<E>;
        equals(arg0: any): boolean;
        get class(): typeof any
        get empty(): boolean
    }
    type ImmutableCollections$List12_<E> = ImmutableCollections$List12<E>;
    class NarratedElementType extends Internal.Enum<Internal.NarratedElementType> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        toString(): string;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        static valueOf(arg0: string): Internal.NarratedElementType;
        name(): string;
        hashCode(): number;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        static values(): Internal.NarratedElementType[];
        compareTo(arg0: Internal.NarratedElementType_): number;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.NarratedElementType>>;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        getDeclaringClass(): typeof Internal.NarratedElementType;
        "compareTo(net.minecraft.client.gui.narration.NarratedElementType)"(arg0: Internal.NarratedElementType_): number;
        get class(): typeof any
        get declaringClass(): typeof Internal.NarratedElementType
        static readonly HINT: (Internal.NarratedElementType) & (Internal.NarratedElementType);
        static readonly POSITION: (Internal.NarratedElementType) & (Internal.NarratedElementType);
        static readonly TITLE: (Internal.NarratedElementType) & (Internal.NarratedElementType);
        static readonly USAGE: (Internal.NarratedElementType) & (Internal.NarratedElementType);
    }
    type NarratedElementType_ = NarratedElementType | "hint" | "position" | "title" | "usage";
    class TrackGraphLocation {
        constructor()
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        position: number;
        graph: Internal.TrackGraph;
        edge: Internal.Couple<Internal.TrackNodeLocation>;
    }
    type TrackGraphLocation_ = TrackGraphLocation;
    abstract class SimpleChannelInboundHandler <I> extends Internal.ChannelInboundHandlerAdapter {
        getClass(): typeof any;
        channelActive(arg0: Internal.ChannelHandlerContext_): void;
        acceptInboundMessage(arg0: any): boolean;
        toString(): string;
        notifyAll(): void;
        isSharable(): boolean;
        handlerRemoved(arg0: Internal.ChannelHandlerContext_): void;
        channelReadComplete(arg0: Internal.ChannelHandlerContext_): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        channelWritabilityChanged(arg0: Internal.ChannelHandlerContext_): void;
        channelInactive(arg0: Internal.ChannelHandlerContext_): void;
        hashCode(): number;
        wait(): void;
        channelUnregistered(arg0: Internal.ChannelHandlerContext_): void;
        userEventTriggered(arg0: Internal.ChannelHandlerContext_, arg1: any): void;
        wait(arg0: number): void;
        exceptionCaught(arg0: Internal.ChannelHandlerContext_, arg1: Internal.Throwable_): void;
        handlerAdded(arg0: Internal.ChannelHandlerContext_): void;
        equals(arg0: any): boolean;
        channelRegistered(arg0: Internal.ChannelHandlerContext_): void;
        channelRead(arg0: Internal.ChannelHandlerContext_, arg1: any): void;
        get class(): typeof any
        get sharable(): boolean
    }
    type SimpleChannelInboundHandler_<I> = SimpleChannelInboundHandler<I>;
    class DoorControlBehaviour extends Internal.BlockEntityBehaviour {
        constructor(arg0: Internal.SmartBlockEntity_)
        getClass(): typeof any;
        isSafeNBT(): boolean;
        destroy(): void;
        write(arg0: Internal.CompoundTag_, arg1: boolean): void;
        onNeighborChanged(arg0: BlockPos_): void;
        static get<T extends Internal.BlockEntityBehaviour>(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BehaviourType_<T>): T;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getPos(): BlockPos;
        unload(): void;
        read(arg0: Internal.CompoundTag_, arg1: boolean): void;
        setLazyTickRate(arg0: number): void;
        static get<T extends Internal.BlockEntityBehaviour>(arg0: Internal.BlockEntity_, arg1: Internal.BehaviourType_<T>): T;
        initialize(): void;
        getWorld(): Internal.Level;
        toString(): string;
        notifyAll(): void;
        writeSafe(arg0: Internal.CompoundTag_): void;
        tick(): void;
        lazyTick(): void;
        hashCode(): number;
        set(arg0: Internal.DoorControl_): void;
        getRequiredItems(): Internal.ItemRequirement;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        onBlockChanged(arg0: Internal.BlockState_): void;
        getType(): Internal.BehaviourType<any>;
        get class(): typeof any
        get safeNBT(): boolean
        get pos(): BlockPos
        set lazyTickRate(arg0: number)
        get world(): Internal.Level
        get requiredItems(): Internal.ItemRequirement
        get type(): Internal.BehaviourType<any>
        static readonly TYPE: Internal.BehaviourType<Internal.DoorControlBehaviour>;
        mode: Internal.DoorControl;
    }
    type DoorControlBehaviour_ = DoorControlBehaviour;
    interface ICraftingCPU {
        abstract getSelectionMode(): Internal.CpuSelectionMode;
        abstract isBusy(): boolean;
        abstract getName(): net.minecraft.network.chat.Component;
        abstract getCoProcessors(): number;
        abstract cancelJob(): void;
        abstract getJobStatus(): Internal.CraftingJobStatus;
        abstract getAvailableStorage(): number;
        get selectionMode(): Internal.CpuSelectionMode
        get busy(): boolean
        get name(): net.minecraft.network.chat.Component
        get coProcessors(): number
        get jobStatus(): Internal.CraftingJobStatus
        get availableStorage(): number
    }
    type ICraftingCPU_ = ICraftingCPU;
    class PBRSpriteHolder {
        constructor()
        getClass(): typeof any;
        getNormalSprite(): Internal.TextureAtlasSprite;
        toString(): string;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        close(): void;
        wait(arg0: number): void;
        setNormalSprite(sprite: Internal.TextureAtlasSprite_): void;
        setSpecularSprite(sprite: Internal.TextureAtlasSprite_): void;
        equals(arg0: any): boolean;
        getSpecularSprite(): Internal.TextureAtlasSprite;
        get class(): typeof any
        get normalSprite(): Internal.TextureAtlasSprite
        set normalSprite(sprite: Internal.TextureAtlasSprite_)
        set specularSprite(sprite: Internal.TextureAtlasSprite_)
        get specularSprite(): Internal.TextureAtlasSprite
    }
    type PBRSpriteHolder_ = PBRSpriteHolder;
    class ConnectedPillarBlock extends Internal.LayeredBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        asItem(): Internal.Item;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        static getConnection(arg0: Internal.BlockState_, arg1: Internal.Direction_): boolean;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        static connection(arg0: Internal.Direction$Axis_, arg1: Internal.Direction_): Internal.BooleanProperty;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        static setConnection(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: boolean): Internal.BlockState;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getName(): Internal.MutableComponent;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static rotatePillar(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly NORTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly SOUTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly WEST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly EAST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    }
    type ConnectedPillarBlock_ = ConnectedPillarBlock;
    abstract class CustomRecipe implements Internal.CraftingRecipe {
        constructor(arg0: ResourceLocation_, arg1: Internal.CraftingBookCategory_)
        getClass(): typeof any;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        abstract matches(arg0: Internal.CraftingContainer_, arg1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        notify(): void;
        getRemainingItems(arg0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        wait(arg0: number, arg1: number): void;
        abstract assemble(arg0: Internal.CraftingContainer_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        category(): Internal.CraftingBookCategory;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        toString(): string;
        notifyAll(): void;
        abstract canCraftInDimensions(arg0: number, arg1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        hashCode(): number;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        wait(): void;
        isIncomplete(): boolean;
        wait(arg0: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        equals(arg0: any): boolean;
        get class(): typeof any
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type CustomRecipe_ = CustomRecipe;
    class DensityFunctions$Clamp extends Internal.Record implements Internal.DensityFunctions$PureTransformer {
        getClass(): typeof any;
        halfNegative(): Internal.DensityFunction;
        abs(): Internal.DensityFunction;
        toString(): string;
        maxValue(): number;
        notifyAll(): void;
        codec(): Internal.KeyDispatchDataCodec<Internal.DensityFunction>;
        compute(arg0: Internal.DensityFunction$FunctionContext_): number;
        squeeze(): Internal.DensityFunction;
        transform(arg0: number): number;
        square(): Internal.DensityFunction;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        mapAll(arg0: Internal.DensityFunction$Visitor_): Internal.DensityFunction;
        clamp(arg0: number, arg1: number): Internal.DensityFunction;
        hashCode(): number;
        quarterNegative(): Internal.DensityFunction;
        wait(): void;
        cube(): Internal.DensityFunction;
        wait(arg0: number): void;
        fillArray(arg0: number[], arg1: Internal.DensityFunction$ContextProvider_): void;
        minValue(): number;
        input(): Internal.DensityFunction;
        equals(arg0: any): boolean;
        get class(): typeof any
        static readonly CODEC: Internal.KeyDispatchDataCodec<Internal.DensityFunctions$Clamp>;
    }
    type DensityFunctions$Clamp_ = DensityFunctions$Clamp;
    class SlopeBlockItem extends Internal.BlockItem {
        constructor(arg0: Internal.Block_, arg1: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        static setBlockEntityData(arg0: Internal.ItemStack_, arg1: Internal.BlockEntityType_<any>, arg2: Internal.CompoundTag_): void;
        handler$cfm000$onUseOn(context: Internal.UseOnContext_, cir: Internal.CallbackInfoReturnable_<any>): void;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getDescriptionId(): string;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        isEdible(): boolean;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getBlockEntityData(arg0: Internal.ItemStack_): Internal.CompoundTag;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        removeFromBlockToItemMap(arg0: Internal.Map_<Internal.Block, Internal.Item>, arg1: Internal.Item_): void;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        static updateCustomBlockEntityTag(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.ItemStack_): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        place(arg0: Internal.BlockPlaceContext_): Internal.InteractionResult;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        getBlock(): Internal.Block;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        updatePlacementContext(arg0: Internal.BlockPlaceContext_): Internal.BlockPlaceContext;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        registerBlocks(arg0: Internal.Map_<Internal.Block, Internal.Item>, arg1: Internal.Item_): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static updateState<T extends Internal.Comparable<T>>(arg0: Internal.BlockState_, arg1: Internal.Property_<T>, arg2: string): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        self(): Internal.Item;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        puzzleslib$setBlock(arg0: Internal.Block_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set burnTime(i: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get block(): Internal.Block
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
    }
    type SlopeBlockItem_ = SlopeBlockItem;
    class ShockedMobEffect extends Internal.CustomParticleMobEffect {
        constructor(arg0: Internal.MobEffectCategory_, arg1: number)
        getDisplayName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        addAttributeModifier(arg0: Internal.Attribute_, arg1: string, arg2: number, arg3: Internal.AttributeModifier$Operation_): Internal.MobEffect;
        isInstantenous(): boolean;
        addAttributeModifiers(arg0: Internal.LivingEntity_, arg1: Internal.AttributeMap_, arg2: number): void;
        applyInstantenousEffect(arg0: Internal.Entity_, arg1: Internal.Entity_, arg2: Internal.LivingEntity_, arg3: number, arg4: number): void;
        notify(): void;
        getChance(): number;
        isBeneficial(): boolean;
        wait(arg0: number, arg1: number): void;
        getColor(): number;
        getEffectRendererInternal(): any;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientMobEffectExtensions>): void;
        onTrack(arg0: Internal.LivingEntity_, arg1: Internal.MobEffectInstance_, arg2: Internal.Player_): void;
        removeAttributeModifiers(arg0: Internal.LivingEntity_, arg1: Internal.AttributeMap_, arg2: number): void;
        onApply(arg0: Internal.LivingEntity_, arg1: Internal.MobEffectInstance_): void;
        applyEffectTick(arg0: Internal.LivingEntity_, arg1: number): void;
        getAttributeModifierValue(arg0: number, arg1: Internal.AttributeModifier_): number;
        getSortOrder(arg0: Internal.MobEffectInstance_): number;
        getDescriptionId(): string;
        static getIdFromNullable(arg0: Internal.MobEffect_): number;
        getCategory(): Internal.MobEffectCategory;
        toString(): string;
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        notifyAll(): void;
        onRemove(arg0: Internal.LivingEntity_, arg1: Internal.MobEffectInstance_): void;
        getParticle(): Internal.ParticleOptions;
        setFactorDataFactory(arg0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>): Internal.MobEffect;
        createFactorData(): Internal.Optional<Internal.MobEffectInstance$FactorData>;
        static byId(arg0: number): Internal.MobEffect;
        hashCode(): number;
        getAttributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        isDurationEffectTick(arg0: number, arg1: number): boolean;
        onExpire(arg0: Internal.LivingEntity_, arg1: Internal.MobEffectInstance_): void;
        static getId(arg0: Internal.MobEffect_): number;
        get displayName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get instantenous(): boolean
        get chance(): number
        get beneficial(): boolean
        get color(): number
        get effectRendererInternal(): any
        get descriptionId(): string
        get category(): Internal.MobEffectCategory
        get curativeItems(): Internal.List<Internal.ItemStack>
        get particle(): Internal.ParticleOptions
        set factorDataFactory(arg0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>)
        get attributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>
    }
    type ShockedMobEffect_ = ShockedMobEffect;
    class TrackSwitchBlockEntity extends Internal.SmartBlockEntity implements Internal.TransformableBlockEntity, Internal.IHaveGoggleInformation {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        emf$hasVehicle(): boolean;
        requestModelDataUpdate(): void;
        emf$getVelocity(): Vec3d;
        etf$getType(): Internal.EntityType<any>;
        destroy(): void;
        containedFluidTooltip(arg0: Internal.List_<net.minecraft.network.chat.Component>, arg1: boolean, arg2: Internal.LazyOptional_<Internal.IFluidHandler>): boolean;
        sodiumdynamiclights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$isBlockEntity(): boolean;
        getTargetAnalogOutput(): number;
        readClient(arg0: Internal.CompoundTag_): void;
        isVirtual(): boolean;
        /**
         * @deprecated
        */
        setBlockState(arg0: Internal.BlockState_): void;
        remove(): void;
        load(arg0: Internal.CompoundTag_): void;
        award(arg0: Internal.CreateAdvancement_): void;
        setChanged(): void;
        setCulled(value: boolean): void;
        saveWithoutMetadata(): Internal.CompoundTag;
        setTimeout(): void;
        isOutOfCamera(): boolean;
        "getUpdatePacket()"(): Internal.Packet<any>;
        packetTarget(): Internal.PacketDistributor$PacketTarget;
        emf$prevZ(): number;
        etf$canBeBright(): boolean;
        setRemoved(): void;
        emf$isOnGround(): boolean;
        sdl$isDynamicLightEnabled(): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        etf$getPose(): Internal.Pose;
        etf$getEntityKey(): string;
        writeSafe(arg0: Internal.CompoundTag_): void;
        isCulled(): boolean;
        getType(): Internal.BlockEntityType<any>;
        writeClient(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        etf$getOptifineId(): number;
        transform(blockEntity: Internal.BlockEntity_, structureTransform: Internal.StructureTransform_): void;
        "getUpdatePacket()"(): Internal.ClientboundBlockEntityDataPacket;
        refreshBlockState(): void;
        getRenderBoundingBox(): Internal.AABB;
        getClass(): typeof any;
        sendToMenu(arg0: Internal.FriendlyByteBuf_): void;
        emf$isInvisible(): boolean;
        isReverseRight(): boolean;
        static getPosFromTag(arg0: Internal.CompoundTag_): BlockPos;
        sdl$shouldUpdateDynamicLight(): boolean;
        emf$isSprinting(): boolean;
        etf$distanceTo(entity: Internal.Entity_): number;
        addBehaviours(behaviours: Internal.List_<Internal.BlockEntityBehaviour>): void;
        onChunkUnloaded(): void;
        saveToItem(arg0: Internal.ItemStack_): void;
        attachBehaviourLate(arg0: Internal.BlockEntityBehaviour_): void;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        emf$isInLava(): boolean;
        static addEntityType(arg0: Internal.CompoundTag_, arg1: Internal.BlockEntityType_<any>): void;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        clearRemoved(): void;
        emf$isWet(): boolean;
        getUpdatePacket(): Internal.Packet<any>;
        isReverseLeft(): boolean;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        setLazyTickRate(arg0: number): void;
        awardIfNear(arg0: Internal.CreateAdvancement_, arg1: number): void;
        sdl$getDynamicLightX(): number;
        containedChunk(): Internal.LevelChunk;
        getPersistentData(): Internal.CompoundTag;
        toString(): string;
        markVirtual(): void;
        emf$isGlowing(): boolean;
        triggerEvent(arg0: number, arg1: number): boolean;
        hasLevel(): boolean;
        notifyAll(): void;
        isAutomatic(): boolean;
        forEachBehaviour(arg0: Internal.Consumer_<Internal.BlockEntityBehaviour>): void;
        sdl$dynamicLightTick(): void;
        invalidate(): void;
        etf$getScoreboardTeam(): Internal.Team;
        callSaveMetadata(arg0: Internal.CompoundTag_): void;
        emf$getZ(): number;
        hasExit(state: Internal.TrackSwitchBlock$SwitchState_): boolean;
        setWorldPosition(arg0: BlockPos_): void;
        wait(arg0: number): void;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        etf$getVelocity(): Vec3d;
        reviveCaps(): void;
        sendData(): void;
        getBehaviour<T extends Internal.BlockEntityBehaviour>(arg0: Internal.BehaviourType_<T>): T;
        sdl$setDynamicLightEnabled(enabled: boolean): void;
        etf$getWorld(): Internal.Level;
        getUpdateTag(): Internal.CompoundTag;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        emf$getYaw(): number;
        setLevel(arg0: Internal.Level_): void;
        sdl$getLuminance(): number;
        notify(): void;
        addBehavioursDeferred(arg0: Internal.List_<Internal.BlockEntityBehaviour>): void;
        getBlockPos(): BlockPos;
        sdl$resetDynamicLight(): void;
        isRemoved(): boolean;
        etf$getNbt(): Internal.CompoundTag;
        emf$isSneaking(): boolean;
        etf$getBlockPos(): BlockPos;
        onLoad(): void;
        getSwitch(): Internal.TrackSwitch;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        sdl$getDynamicLightY(): number;
        emf$prevPitch(): number;
        sodiumdynamiclights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        etf$getBlockY(): number;
        initialize(): void;
        etf$getHandItems(): Internal.Iterable<any>;
        emf$getY(): number;
        etf$getArmorItems(): Internal.Iterable<any>;
        invalidateCaps(): void;
        emf$prevX(): number;
        getBlockState(): Internal.BlockState;
        tick(): void;
        canPlayerUse(arg0: Internal.Player_): boolean;
        lazyTick(): void;
        emf$age(): number;
        getState(): Internal.TrackSwitchBlock$SwitchState;
        etf$hasCustomName(): boolean;
        clientLazyTick(): void;
        static loadStatic(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.CompoundTag_): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        wait(): void;
        setStatePonder(state: Internal.TrackSwitchBlock$SwitchState_): void;
        emf$isTouchingWater(): boolean;
        m_183515_(arg0: Internal.CompoundTag_): void;
        emf$getVariableMap(): Internal.Object2FloatOpenHashMap<any>;
        getOverlayModel(): Internal.PartialModel;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        saveWithId(): Internal.CompoundTag;
        notifyUpdate(): void;
        setOutOfCamera(value: boolean): void;
        sdl$getDynamicLightLevel(): Internal.Level;
        wait(arg0: number, arg1: number): void;
        isChunkUnloaded(): boolean;
        getLevel(): Internal.Level;
        getRequiredItems(arg0: Internal.BlockState_): Internal.ItemRequirement;
        onlyOpCanSetNbt(): boolean;
        removeBehaviour(arg0: Internal.BehaviourType_<any>): void;
        sdl$getDynamicLightZ(): number;
        onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        saveWithFullMetadata(): Internal.CompoundTag;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        getIcon(arg0: boolean): Internal.ItemStack;
        emf$prevY(): number;
        emf$getX(): number;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        emf$isOnFire(): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        isNormal(): boolean;
        blockHolderGetter(): Internal.HolderGetter<Internal.Block>;
        etf$getUuid(): Internal.UUID;
        getAllBehaviours(): Internal.Collection<Internal.BlockEntityBehaviour>;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        isForcedVisible(): boolean;
        emf$hasPassengers(): boolean;
        serializeNBT(): Internal.CompoundTag;
        isLocked(): boolean;
        registerAwardables(arg0: Internal.List_<Internal.BlockEntityBehaviour>, ...arg1: Internal.CreateAdvancement_[]): void;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        hashCode(): number;
        emf$getTypeString(): string;
        getModelData(): Internal.ModelData;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        emf$getPitch(): number;
        emf$isAlive(): boolean;
        equals(arg0: any): boolean;
        get targetAnalogOutput(): number
        get virtual(): boolean
        /**
         * @deprecated
        */
        set blockState(arg0: Internal.BlockState_)
        set culled(value: boolean)
        get outOfCamera(): boolean
        get "updatePacket()"(): Internal.Packet<any>
        get culled(): boolean
        get type(): Internal.BlockEntityType<any>
        get "updatePacket()"(): Internal.ClientboundBlockEntityDataPacket
        get renderBoundingBox(): Internal.AABB
        get class(): typeof any
        get reverseRight(): boolean
        get updatePacket(): Internal.Packet<any>
        get reverseLeft(): boolean
        set lazyTickRate(arg0: number)
        get persistentData(): Internal.CompoundTag
        get automatic(): boolean
        set worldPosition(arg0: BlockPos_)
        get updateTag(): Internal.CompoundTag
        set level(arg0: Internal.Level_)
        get blockPos(): BlockPos
        get removed(): boolean
        get "switch"(): Internal.TrackSwitch
        get blockState(): Internal.BlockState
        get state(): Internal.TrackSwitchBlock$SwitchState
        set statePonder(state: Internal.TrackSwitchBlock$SwitchState_)
        get overlayModel(): Internal.PartialModel
        set outOfCamera(value: boolean)
        get chunkUnloaded(): boolean
        get level(): Internal.Level
        get normal(): boolean
        get allBehaviours(): Internal.Collection<Internal.BlockEntityBehaviour>
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        get forcedVisible(): boolean
        get locked(): boolean
        get modelData(): Internal.ModelData
        edgePoint: Internal.TrackTargetingBehaviour<Internal.TrackSwitch>;
        ponderData: Internal.TrackSwitchBlockEntity$PonderData;
    }
    type TrackSwitchBlockEntity_ = TrackSwitchBlockEntity;
    class MutablePair <L, R> extends org.apache.commons.lang3.tuple.Pair<L, R> {
        constructor()
        constructor(arg0: L, arg1: R)
        getClass(): typeof any;
        getLeft(): L;
        static of<L, R>(arg0: L, arg1: R): Internal.MutablePair<L, R>;
        getRight(): R;
        compareTo(arg0: org.apache.commons.lang3.tuple.Pair_<L, R>): number;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        "compareTo(org.apache.commons.lang3.tuple.Pair)"(arg0: org.apache.commons.lang3.tuple.Pair_<L, R>): number;
        compareTo(arg0: any): number;
        static copyOf<K, V>(arg0: Internal.Map$Entry_<K, V>): Internal.Map$Entry<K, V>;
        static comparingByKey<K extends Internal.Comparable<any>, V>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        setRight(arg0: R): void;
        setLeft(arg0: L): void;
        toString(arg0: string): string;
        getKey(): L;
        static comparingByKey<K, V>(arg0: Internal.Comparator_<K>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        toString(): string;
        notifyAll(): void;
        static emptyArray<L, R>(): Internal.MutablePair<L, R>[];
        getValue(): R;
        static comparingByValue<K, V extends Internal.Comparable<any>>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        hashCode(): number;
        static of<L, R>(arg0: Internal.Map$Entry_<L, R>): Internal.MutablePair<L, R>;
        wait(): void;
        wait(arg0: number): void;
        static comparingByValue<K, V>(arg0: Internal.Comparator_<V>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        setValue(arg0: R): R;
        get class(): typeof any
        get left(): L
        get right(): R
        set right(arg0: R)
        set left(arg0: L)
        get key(): L
        get value(): R
        set value(arg0: R)
        left: L;
        right: R;
        static readonly EMPTY_ARRAY: Internal.MutablePair<any, any>[];
    }
    type MutablePair_<L, R> = MutablePair<L, R>;
    abstract class IntProvider {
        constructor()
        abstract getMinValue(): number;
        getClass(): typeof any;
        abstract sample(arg0: Internal.RandomSource_): number;
        toString(): string;
        abstract getMaxValue(): number;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        abstract getType(): Internal.IntProviderType<any>;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        static codec(arg0: number, arg1: number): Internal.Codec<Internal.IntProvider>;
        static codec<T extends Internal.IntProvider>(arg0: number, arg1: number, arg2: Internal.Codec_<T>): Internal.Codec<T>;
        get minValue(): number
        get class(): typeof any
        get maxValue(): number
        get type(): Internal.IntProviderType<any>
        static readonly CODEC: Internal.Codec<Internal.IntProvider>;
        static readonly NON_NEGATIVE_CODEC: Internal.Codec<Internal.IntProvider>;
        static readonly POSITIVE_CODEC: Internal.Codec<Internal.IntProvider>;
    }
    type IntProvider_ = {max_inclusive: number, clamped_normal: Internal.IntProvider_, mean: number, deviation: number, min_inclusive: number} | number | {clamped_normal: Internal.IntProvider_, mean: number, deviation: number, value: number} | {max_inclusive: number, clamped: Internal.IntProvider_, min_inclusive: number} | {clamped_normal: Internal.IntProvider_, mean: number, deviation: number, min: number, max: number} | IntProvider | {clamped: Internal.IntProvider_, bounds: [number, number]} | {clamped: Internal.IntProvider_, min: number, max: number} | {value: number, clamped: Internal.IntProvider_} | [number, number] | {clamped_normal: Internal.IntProvider_, mean: number, deviation: number, bounds: [number, number]};
    class BrainDebugRenderer$PoiInfo {
        constructor(arg0: BlockPos_, arg1: string, arg2: number)
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        type: string;
        readonly pos: BlockPos;
        freeTicketCount: number;
    }
    type BrainDebugRenderer$PoiInfo_ = BrainDebugRenderer$PoiInfo;
    class IModFileInfo$LanguageSpec extends Internal.Record {
        constructor(languageName: string, acceptedVersions: Internal.VersionRange_)
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        acceptedVersions(): Internal.VersionRange;
        wait(arg0: number): void;
        languageName(): string;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
    }
    type IModFileInfo$LanguageSpec_ = IModFileInfo$LanguageSpec;
    class Method extends Internal.Executable {
        getClass(): typeof any;
        isVarArgs(): boolean;
        getAnnotatedParameterTypes(): Internal.AnnotatedType[];
        getGenericExceptionTypes(): Internal.Type[];
        getModifiers(): number;
        getDeclaredAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        notify(): void;
        static setAccessible(arg0: Internal.AccessibleObject_[], arg1: boolean): void;
        wait(arg0: number, arg1: number): void;
        getAnnotatedReturnType(): Internal.AnnotatedType;
        getDefaultValue(): any;
        getParameterTypes(): typeof any[];
        getParameterAnnotations(): Internal.Annotation[][];
        getParameters(): any[];
        getName(): string;
        trySetAccessible(): boolean;
        getParameterCount(): number;
        invoke(arg0: any, ...arg1: any[]): any;
        getDeclaredAnnotations(): Internal.Annotation[];
        getAnnotatedReceiverType(): Internal.AnnotatedType;
        isAnnotationPresent(arg0: typeof Internal.Annotation): boolean;
        getAnnotatedExceptionTypes(): Internal.AnnotatedType[];
        setAccessible(arg0: boolean): void;
        getAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        getDeclaredAnnotation<T extends Internal.Annotation>(arg0: T): T;
        toString(): string;
        getGenericParameterTypes(): Internal.Type[];
        notifyAll(): void;
        isSynthetic(): boolean;
        getAnnotation<T extends Internal.Annotation>(arg0: T): T;
        getTypeParameters(): any[];
        isDefault(): boolean;
        getDeclaringClass(): typeof any;
        getExceptionTypes(): typeof any[];
        hashCode(): number;
        getReturnType(): typeof any;
        canAccess(arg0: any): boolean;
        isBridge(): boolean;
        toGenericString(): string;
        wait(): void;
        getGenericReturnType(): Internal.Type;
        wait(arg0: number): void;
        getAnnotations(): Internal.Annotation[];
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        isAccessible(): boolean;
        get class(): typeof any
        get varArgs(): boolean
        get annotatedParameterTypes(): Internal.AnnotatedType[]
        get genericExceptionTypes(): Internal.Type[]
        get modifiers(): number
        get annotatedReturnType(): Internal.AnnotatedType
        get defaultValue(): any
        get parameterTypes(): typeof any[]
        get parameterAnnotations(): Internal.Annotation[][]
        get parameters(): any[]
        get name(): string
        get parameterCount(): number
        get declaredAnnotations(): Internal.Annotation[]
        get annotatedReceiverType(): Internal.AnnotatedType
        get annotatedExceptionTypes(): Internal.AnnotatedType[]
        set accessible(arg0: boolean)
        get genericParameterTypes(): Internal.Type[]
        get synthetic(): boolean
        get typeParameters(): any[]
        get "default"(): boolean
        get declaringClass(): typeof any
        get exceptionTypes(): typeof any[]
        get returnType(): typeof any
        get bridge(): boolean
        get genericReturnType(): Internal.Type
        get annotations(): Internal.Annotation[]
        /**
         * @deprecated
        */
        get accessible(): boolean
    }
    type Method_ = Method;
    class FluidAmountDisplaySource extends Internal.SingleLineDisplaySource {
        constructor()
        getClass(): typeof any;
        getName(): net.minecraft.network.chat.Component;
        initConfigurationWidgets(arg0: Internal.DisplayLinkContext_, arg1: Internal.ModularGuiLineBuilder_, arg2: boolean): void;
        loadFlapDisplayLayout(arg0: Internal.DisplayLinkContext_, arg1: Internal.FlapDisplayBlockEntity_, arg2: Internal.FlapDisplayLayout_): void;
        toString(): string;
        shouldPassiveReset(): boolean;
        loadFlapDisplayLayout(arg0: Internal.DisplayLinkContext_, arg1: Internal.FlapDisplayBlockEntity_, arg2: Internal.FlapDisplayLayout_, arg3: number): void;
        notifyAll(): void;
        transferData(arg0: Internal.DisplayLinkContext_, arg1: Internal.DisplayTarget_, arg2: number): void;
        provideFlapDisplayText(arg0: Internal.DisplayLinkContext_, arg1: Internal.DisplayTargetStats_): Internal.List<Internal.List<Internal.MutableComponent>>;
        static getAll(arg0: Internal.LevelAccessor_, arg1: BlockPos_): Internal.List<Internal.DisplaySource>;
        populateData(arg0: Internal.DisplayLinkContext_): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        onSignalReset(arg0: Internal.DisplayLinkContext_): void;
        static displaySource<B extends Internal.Block, P>(arg0: Internal.RegistryEntry_<Internal.DisplaySource>): Internal.NonNullUnaryOperator<com.tterrag.registrate.builders.BlockBuilder<B, P>>;
        hashCode(): number;
        wait(): void;
        static get(arg0: ResourceLocation_): Internal.DisplaySource;
        provideText(arg0: Internal.DisplayLinkContext_, arg1: Internal.DisplayTargetStats_): Internal.List<Internal.MutableComponent>;
        wait(arg0: number): void;
        getPassiveRefreshTicks(): number;
        equals(arg0: any): boolean;
        get class(): typeof any
        get name(): net.minecraft.network.chat.Component
        get passiveRefreshTicks(): number
    }
    type FluidAmountDisplaySource_ = FluidAmountDisplaySource;
    class BlockExCharger extends Internal.BlockBaseGui<Internal.TileExCharger> {
        constructor()
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        addToMainCreativeTab(arg0: Internal.CreativeModeTab$Output_): void;
        static fixtureProps(): Internal.BlockBehaviour$Properties;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        asItem(): Internal.Item;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getOrientation(arg0: Internal.BlockState_): Internal.BlockOrientation;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        getBlockEntity(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.TileExCharger;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getOrientationStrategy(): Internal.IOrientationStrategy;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        openGui(arg0: Internal.AEBaseBlockEntity_, arg1: Internal.Player_): void;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getBlockEntityBlockState(arg0: Internal.BlockState_, arg1: Internal.BlockEntity_): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        onActivated(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Player_, arg3: Internal.InteractionHand_, arg4: Internal.ItemStack_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        setBlockEntity(arg0: typeof Internal.TileExCharger, arg1: Internal.BlockEntityType_<Internal.TileExCharger>, arg2: Internal.BlockEntityTicker_<Internal.TileExCharger>, arg3: Internal.BlockEntityTicker_<Internal.TileExCharger>): void;
        static metalProps(): Internal.BlockBehaviour$Properties;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        openGui(arg0: Internal.TileExCharger_, arg1: Internal.Player_): void;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        "openGui(com.glodblock.github.extendedae.common.tileentities.TileExCharger,net.minecraft.world.entity.player.Player)"(arg0: Internal.TileExCharger_, arg1: Internal.Player_): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        static defaultProps(arg0: Internal.MapColor_, arg1: SoundType_): Internal.BlockBehaviour$Properties;
        getId(): string;
        getBlockEntity(arg0: Internal.BlockGetter_, arg1: number, arg2: number, arg3: number): Internal.TileExCharger;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        static stoneProps(): Internal.BlockBehaviour$Properties;
        static glassProps(): Internal.BlockBehaviour$Properties;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getName(): Internal.MutableComponent;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getBlockEntityType(): Internal.BlockEntityType<Internal.TileExCharger>;
        getMod(): string;
        "openGui(appeng.blockentity.AEBaseBlockEntity,net.minecraft.world.entity.player.Player)"(arg0: Internal.AEBaseBlockEntity_, arg1: Internal.Player_): void;
        check(arg0: Internal.TileExCharger_, arg1: Internal.ItemStack_, arg2: Internal.Level_, arg3: BlockPos_, arg4: Internal.BlockHitResult_, arg5: Internal.Player_): Internal.InteractionResult;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        getRegistryName(): ResourceLocation;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get orientationStrategy(): Internal.IOrientationStrategy
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get blockEntityType(): Internal.BlockEntityType<Internal.TileExCharger>
        get mod(): string
        get registryName(): ResourceLocation
        set hasCollision(arg0: boolean)
    }
    type BlockExCharger_ = BlockExCharger;
    class ImmutableCollections$SetN <E> extends Internal.ImmutableCollections$AbstractImmutableSet<E> implements Internal.Serializable {
        getClass(): typeof any;
        abstract add(arg0: E): boolean;
        parallelStream(): Internal.Stream<E>;
        isEmpty(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        static of<E>(arg0: E, arg1: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        contains(arg0: any): boolean;
        abstract addAll(arg0: Internal.Collection_<E>): boolean;
        static "of(java.lang.Object[])"<E>(...arg0: E[]): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        toString(): string;
        forEach(arg0: Internal.Consumer_<E>): void;
        notifyAll(): void;
        toArray<T>(arg0: T[]): T[];
        "toArray(java.lang.Object[])"<T>(arg0: T[]): T[];
        abstract remove(arg0: any): boolean;
        "toArray(java.util.function.IntFunction)"<T>(arg0: Internal.IntFunction_<T[]>): T[];
        toArray(): any[];
        iterator(): Internal.Iterator<E>;
        hashCode(): number;
        size(): number;
        static of<E>(arg0: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        static of<E>(...arg0: E[]): Internal.Set<E>;
        static of<E>(): Internal.Set<E>;
        stream(): Internal.Stream<E>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        wait(): void;
        abstract clear(): void;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        wait(arg0: number): void;
        spliterator(): Internal.Spliterator<E>;
        equals(arg0: any): boolean;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        static "of(java.lang.Object)"<E>(arg0: E): Internal.Set<E>;
        get class(): typeof any
        get empty(): boolean
    }
    type ImmutableCollections$SetN_<E> = ImmutableCollections$SetN<E>;
    class ItemSiloMountedStorageType extends Internal.MountedItemStorageType<Internal.ItemSiloMountedStorage> {
        constructor()
        getClass(): typeof any;
        hashCode(): number;
        is(arg0: Internal.TagKey_<Internal.MountedItemStorageType<any>>): boolean;
        mount(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.ItemSiloMountedStorage;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        static mountedItemStorage<B extends Internal.Block, P>(arg0: Internal.RegistryEntry_<Internal.MountedItemStorageType<any>>): Internal.NonNullUnaryOperator<com.tterrag.registrate.builders.BlockBuilder<B, P>>;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
    }
    type ItemSiloMountedStorageType_ = ItemSiloMountedStorageType;
    interface CustomIngredientActionCallback {
        abstract transform(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.InventoryKJS_): Internal.ItemStack;
        (arg0: Internal.ItemStack, arg1: number, arg2: Internal.InventoryKJS): Internal.ItemStack_;
    }
    type CustomIngredientActionCallback_ = ((arg0: Internal.ItemStack, arg1: number, arg2: Internal.InventoryKJS)=> Internal.ItemStack_) | CustomIngredientActionCallback;
    class DisplaySide extends Internal.Enum<Internal.DisplaySide> implements Internal.StringRepresentable {
        getClass(): typeof any;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>, arg1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.DisplaySide[];
        getDeclaringClass(): typeof Internal.DisplaySide;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        "compareTo(net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide)"(arg0: Internal.DisplaySide_): number;
        static fromName(arg0: string): Internal.DisplaySide;
        previous(): this;
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        toString(): string;
        notifyAll(): void;
        compareTo(arg0: Internal.DisplaySide_): number;
        name(): string;
        hashCode(): number;
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.DisplaySide>>;
        ordinal(): number;
        wait(): void;
        next(): this;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        static valueOf(arg0: string): Internal.DisplaySide;
        get class(): typeof any
        get serializedName(): string
        get declaringClass(): typeof Internal.DisplaySide
        static readonly FRONT: (Internal.DisplaySide) & (Internal.DisplaySide);
        static readonly LEFT: (Internal.DisplaySide) & (Internal.DisplaySide);
        static readonly RIGHT: (Internal.DisplaySide) & (Internal.DisplaySide);
    }
    type DisplaySide_ = "front" | "right" | DisplaySide | "left";
    class SpeedUpgradeItem extends Internal.Item {
        constructor(arg0: Internal.Item$Properties_, arg1: number)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        handler$cfm000$onUseOn(context: Internal.UseOnContext_, cir: Internal.CallbackInfoReturnable_<any>): void;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getDescriptionId(): string;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        isEdible(): boolean;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        self(): Internal.Item;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set burnTime(i: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
    }
    type SpeedUpgradeItem_ = SpeedUpgradeItem;
    interface ArtifactVersion extends Internal.Comparable<Internal.ArtifactVersion> {
        abstract compareTo(arg0: Internal.ArtifactVersion_): number;
        abstract getBuildNumber(): number;
        abstract parseVersion(arg0: string): void;
        abstract getMinorVersion(): number;
        abstract getMajorVersion(): number;
        abstract getIncrementalVersion(): number;
        abstract getQualifier(): string;
        get buildNumber(): number
        get minorVersion(): number
        get majorVersion(): number
        get incrementalVersion(): number
        get qualifier(): string
    }
    type ArtifactVersion_ = ArtifactVersion;
    class VersionedInventoryTrackerBehaviour extends Internal.BlockEntityBehaviour {
        constructor(arg0: Internal.SmartBlockEntity_)
        getClass(): typeof any;
        awaitNewVersion(arg0: Internal.IItemHandler_): void;
        stillWaiting(arg0: Internal.InvManipulationBehaviour_): boolean;
        isSafeNBT(): boolean;
        "awaitNewVersion(com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour)"(arg0: Internal.InvManipulationBehaviour_): void;
        destroy(): void;
        onNeighborChanged(arg0: BlockPos_): void;
        write(arg0: Internal.CompoundTag_, arg1: boolean): void;
        static get<T extends Internal.BlockEntityBehaviour>(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BehaviourType_<T>): T;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        "awaitNewVersion(net.minecraftforge.items.IItemHandler)"(arg0: Internal.IItemHandler_): void;
        getPos(): BlockPos;
        unload(): void;
        read(arg0: Internal.CompoundTag_, arg1: boolean): void;
        "stillWaiting(net.minecraftforge.items.IItemHandler)"(arg0: Internal.IItemHandler_): boolean;
        setLazyTickRate(arg0: number): void;
        reset(): void;
        static get<T extends Internal.BlockEntityBehaviour>(arg0: Internal.BlockEntity_, arg1: Internal.BehaviourType_<T>): T;
        initialize(): void;
        awaitNewVersion(arg0: Internal.InvManipulationBehaviour_): void;
        getWorld(): Internal.Level;
        toString(): string;
        notifyAll(): void;
        writeSafe(arg0: Internal.CompoundTag_): void;
        tick(): void;
        lazyTick(): void;
        hashCode(): number;
        getRequiredItems(): Internal.ItemRequirement;
        wait(): void;
        stillWaiting(arg0: Internal.IItemHandler_): boolean;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        onBlockChanged(arg0: Internal.BlockState_): void;
        "stillWaiting(com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour)"(arg0: Internal.InvManipulationBehaviour_): boolean;
        getType(): Internal.BehaviourType<any>;
        get class(): typeof any
        get safeNBT(): boolean
        get pos(): BlockPos
        set lazyTickRate(arg0: number)
        get world(): Internal.Level
        get requiredItems(): Internal.ItemRequirement
        get type(): Internal.BehaviourType<any>
        static readonly TYPE: Internal.BehaviourType<Internal.VersionedInventoryTrackerBehaviour>;
    }
    type VersionedInventoryTrackerBehaviour_ = VersionedInventoryTrackerBehaviour;
    class Locale$LanguageRange {
        constructor(arg0: string, arg1: number)
        constructor(arg0: string)
        getWeight(): number;
        getClass(): typeof any;
        toString(): string;
        static parse(arg0: string): Internal.List<Internal.Locale$LanguageRange>;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        static parse(arg0: string, arg1: Internal.Map_<string, Internal.List<string>>): Internal.List<Internal.Locale$LanguageRange>;
        wait(arg0: number): void;
        static mapEquivalents(arg0: Internal.List_<Internal.Locale$LanguageRange>, arg1: Internal.Map_<string, Internal.List<string>>): Internal.List<Internal.Locale$LanguageRange>;
        equals(arg0: any): boolean;
        getRange(): string;
        get weight(): number
        get class(): typeof any
        get range(): string
        static readonly MAX_WEIGHT: (1.0) & (number);
        static readonly MIN_WEIGHT: (0.0) & (number);
    }
    type Locale$LanguageRange_ = Locale$LanguageRange;
    interface ArgumentType <T> {
        abstract parse(arg0: Internal.StringReader_): T;
        getExamples(): Internal.Collection<string>;
        listSuggestions<S>(arg0: Internal.CommandContext_<S>, arg1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        get examples(): Internal.Collection<string>
        (arg0: Internal.StringReader): T;
    }
    type ArgumentType_<T> = ((arg0: Internal.StringReader)=> T) | ArgumentType<T>;
    class ItemCooldowns implements Internal.AccessorItemCooldowns {
        constructor()
        getClass(): typeof any;
        toString(): string;
        bookshelf$getCooldowns(): Internal.Map<any, any>;
        notifyAll(): void;
        isOnCooldown(arg0: Internal.Item_): boolean;
        notify(): void;
        removeCooldown(arg0: Internal.Item_): void;
        wait(arg0: number, arg1: number): void;
        tick(): void;
        hashCode(): number;
        addCooldown(arg0: Internal.Item_, arg1: number): void;
        bookshelf$getTickCount(): number;
        wait(): void;
        getCooldownPercent(arg0: Internal.Item_, arg1: number): number;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        get class(): typeof any
    }
    type ItemCooldowns_ = ItemCooldowns;
    class Capability <T> {
        addListener(arg0: Internal.Consumer_<Internal.Capability<T>>): this;
        getClass(): typeof any;
        toString(): string;
        orEmpty<R>(arg0: Internal.Capability_<R>, arg1: Internal.LazyOptional_<T>): Internal.LazyOptional<R>;
        notifyAll(): void;
        isRegistered(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        getName(): string;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        get class(): typeof any
        get registered(): boolean
        get name(): string
    }
    type Capability_<T> = Capability<T>;
    class StonecutterRecipe extends Internal.SingleItemRecipe {
        constructor(arg0: ResourceLocation_, arg1: string, arg2: Internal.Ingredient_, arg3: Internal.ItemStack_)
        getClass(): typeof any;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getRemainingItems(arg0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        toString(): string;
        notifyAll(): void;
        canCraftInDimensions(arg0: number, arg1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        hashCode(): number;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        wait(): void;
        isIncomplete(): boolean;
        wait(arg0: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        equals(arg0: any): boolean;
        get class(): typeof any
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type StonecutterRecipe_ = StonecutterRecipe;
    class DataPackEventJS extends Internal.EventJS {
        constructor(d: any_, rm: any_)
        getClass(): typeof any;
        /**
         * Stops the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `exit` denotes a `default` outcome.
        */
        exit(): any;
        /**
         * Cancels the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `cancel` denotes a `false` outcome.
        */
        cancel(value: any): any;
        toString(): string;
        notifyAll(): void;
        /**
         * Stops the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `exit` denotes a `default` outcome.
        */
        exit(value: any): any;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        /**
         * Stops the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `success` denotes a `true` outcome.
        */
        success(value: any): any;
        hashCode(): number;
        wait(): void;
        add(id: ResourceLocation_, content: string): void;
        /**
         * Cancels the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `cancel` denotes a `false` outcome.
        */
        cancel(): any;
        wait(arg0: number): void;
        /**
         * Stops the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `success` denotes a `true` outcome.
        */
        success(): any;
        equals(arg0: any): boolean;
        addJson(id: ResourceLocation_, json: Internal.JsonElement_): void;
        get class(): typeof any
    }
    type DataPackEventJS_ = DataPackEventJS;
    abstract class HorizontalAxisKineticBlock extends Internal.KineticBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getRotationAxis(arg0: Internal.BlockState_): Internal.Direction$Axis;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        asItem(): Internal.Item;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        static getPreferredHorizontalAxis(arg0: Internal.BlockPlaceContext_): Internal.Direction$Axis;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        static playRemoveSound(arg0: Internal.Level_, arg1: BlockPos_): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        getRotatedBlockState(arg0: Internal.BlockState_, arg1: Internal.Direction_): Internal.BlockState;
        getParticleInitialRadius(): number;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        static playRotateSound(arg0: Internal.Level_, arg1: BlockPos_): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        hideStressImpact(): boolean;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        onWrenched(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        onSneakWrenched(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        getParticleTargetRadius(): number;
        updateAfterWrenched(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_): Internal.BlockState;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getName(): Internal.MutableComponent;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        showCapacityWithAnnotation(): boolean;
        static stateById(arg0: number): Internal.BlockState;
        hasShaftTowards(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Direction_): boolean;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get particleInitialRadius(): number
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        get particleTargetRadius(): number
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly HORIZONTAL_AXIS: Internal.Property<Internal.Direction$Axis>;
    }
    type HorizontalAxisKineticBlock_ = HorizontalAxisKineticBlock;
    class MechanicalPistonBlock extends Internal.DirectionalAxisKineticBlock implements Internal.IBE<Internal.MechanicalPistonBlockEntity> {
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        static isStickyPiston(arg0: Internal.BlockState_): boolean;
        getRotationAxis(arg0: Internal.BlockState_): Internal.Direction$Axis;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        getBlockEntityClass(): typeof Internal.MechanicalPistonBlockEntity;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        asItem(): Internal.Item;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        static playRemoveSound(arg0: Internal.Level_, arg1: BlockPos_): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        getPreferredFacing(arg0: Internal.BlockPlaceContext_): Internal.Direction;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        onBlockEntityUse(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Function_<Internal.MechanicalPistonBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        getRotatedBlockState(arg0: Internal.BlockState_, arg1: Internal.Direction_): Internal.BlockState;
        getParticleInitialRadius(): number;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        transform(arg0: Internal.BlockState_, arg1: Internal.StructureTransform_): Internal.BlockState;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getTicker<S extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        wait(): void;
        static playRotateSound(arg0: Internal.Level_, arg1: BlockPos_): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        static onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        hideStressImpact(): boolean;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        static maxAllowedPistonPoles(): number;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.MechanicalPistonBlockEntity>;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        static sticky(arg0: Internal.BlockBehaviour$Properties_): Internal.MechanicalPistonBlock;
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        onWrenched(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        onSneakWrenched(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        getParticleTargetRadius(): number;
        updateAfterWrenched(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_): Internal.BlockState;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        getBlockEntity(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.MechanicalPistonBlockEntity;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        static normal(arg0: Internal.BlockBehaviour$Properties_): Internal.MechanicalPistonBlock;
        static isExtensionPole(arg0: Internal.BlockState_): boolean;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityOptional(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.Optional<Internal.MechanicalPistonBlockEntity>;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        static isPiston(arg0: Internal.BlockState_): boolean;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        withBlockEntityDo(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Consumer_<Internal.MechanicalPistonBlockEntity>): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getName(): Internal.MutableComponent;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static isPistonHead(arg0: Internal.BlockState_): boolean;
        showCapacityWithAnnotation(): boolean;
        static stateById(arg0: number): Internal.BlockState;
        hasShaftTowards(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Direction_): boolean;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        get blockEntityClass(): typeof Internal.MechanicalPistonBlockEntity
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get particleInitialRadius(): number
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        get blockEntityType(): Internal.BlockEntityType<Internal.MechanicalPistonBlockEntity>
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        get particleTargetRadius(): number
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly STATE: Internal.EnumProperty<Internal.MechanicalPistonBlock$PistonState>;
    }
    type MechanicalPistonBlock_ = MechanicalPistonBlock;
    class DoorControl extends Internal.Enum<Internal.DoorControl> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        toString(): string;
        static valueOf(arg0: string): Internal.DoorControl;
        "compareTo(com.simibubi.create.content.decoration.slidingDoor.DoorControl)"(arg0: Internal.DoorControl_): number;
        notifyAll(): void;
        static createWidget(arg0: number, arg1: number, arg2: Internal.Consumer_<Internal.DoorControl>, arg3: Internal.DoorControl_): Internal.Pair<Internal.ScrollInput, Internal.Label>;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.DoorControl>>;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        static values(): Internal.DoorControl[];
        name(): string;
        hashCode(): number;
        getDeclaringClass(): typeof Internal.DoorControl;
        matches(arg0: Internal.Direction_): boolean;
        ordinal(): number;
        wait(): void;
        compareTo(arg0: Internal.DoorControl_): number;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        get class(): typeof any
        get declaringClass(): typeof Internal.DoorControl
        static readonly SOUTH: (Internal.DoorControl) & (Internal.DoorControl);
        static readonly NONE: (Internal.DoorControl) & (Internal.DoorControl);
        static readonly WEST: (Internal.DoorControl) & (Internal.DoorControl);
        static readonly ALL: (Internal.DoorControl) & (Internal.DoorControl);
        static readonly NORTH: (Internal.DoorControl) & (Internal.DoorControl);
        static readonly EAST: (Internal.DoorControl) & (Internal.DoorControl);
    }
    type DoorControl_ = "west" | "east" | "south" | "north" | DoorControl | "none" | "all";
    class EMFModelPartRoot extends Internal.EMFModelPartVanilla {
        constructor(mobNameForFileAndMap: Internal.EMFModel_ID_, directoryContext: Internal.EMFDirectoryHandler_, vanillaRoot: Internal.ModelPart_, optifinePartNames: Internal.Collection_<string>, mapForCreatedParts: Internal.Map_<string, Internal.EMFModelPartVanilla>)
        checkIfShouldExpireEntity(id: Internal.UUID_): void;
        copyFrom(arg0: Internal.ModelPart_): void;
        offsetRotation(arg0: Vec3f_): void;
        loadPose(arg0: Internal.PartPose_): void;
        visit(arg0: Internal.PoseStack_, arg1: Internal.ModelPart$Visitor_): void;
        notify(): void;
        simplePrintChildren(depth: number): string;
        renderBoxesNoChildren(matrices: Internal.PoseStack_, vertices: Internal.VertexConsumer_, alpha: number): void;
        getChild(arg0: string): Internal.ModelPart;
        getVanillaFormatRoot(): Internal.ModelPart;
        flywheel$compile(arg0: Internal.PoseStack$Pose_, arg1: Internal.VertexConsumer_, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): void;
        setHideInTheseStates(variant: number): void;
        discoverAndInitVariants(fallbackPropertiesName: string): void;
        isVisible(): boolean;
        getAllEMFCustomChildren(): Internal.ModelPart[];
        setVariant1ToVanilla0(): void;
        getTopLevelJemTexture(): ResourceLocation;
        flywheel$children(): Internal.Map<any, any>;
        getVanillaModelPartsOfCurrentState(): Internal.ModelPart;
        wait(): void;
        setVariantStateTo(newVariant: number): void;
        offsetScale(arg0: Vec3f_): void;
        getCuboids(): Internal.ModelCuboid[];
        addVariantOfJem(jemData: Internal.EMFJemData_, variant: number): void;
        getClass(): typeof any;
        getAllChildPartsAsAnimationMap(prefixableParents: string, variantNum: number, optifinePartNameMap: Internal.Map_<string, string>): Internal.Object2ReferenceOpenHashMap<string, Internal.EMFModelPart>;
        renderBoxes(matrices: Internal.PoseStack_, vertices: Internal.VertexConsumer_): void;
        compile(pose: Internal.PoseStack$Pose_, vertexConsumer: Internal.VertexConsumer_, i: number, j: number, red: number, green: number, blue: number, alpha: number): void;
        hasChild(arg0: string): boolean;
        toStringShort(): string;
        render(matrices: Internal.PoseStack_, vertices: Internal.VertexConsumer_, light: number, overlay: number, red: number, green: number, blue: number, alpha: number): void;
        getInitialPose(): Internal.PartPose;
        setPos(arg0: number, arg1: number, arg2: number): void;
        isEmpty(): boolean;
        getAllParts(): Internal.Stream<Internal.ModelPart>;
        wait(arg0: number, arg1: number): void;
        setRotation(arg0: number, arg1: number, arg2: number): void;
        setInitialPose(arg0: Internal.PartPose_): void;
        translateAndRotate(matrixStack: Internal.PoseStack_): void;
        getChildren(): Internal.ModelPart[];
        emf$setTextureSize(size: number[]): void;
        emf$insertKnownMappings(newName: Internal.EMFModel_ID_): void;
        tryRenderVanillaRootNormally(matrixStack: Internal.PoseStack_, vertexConsumer: Internal.VertexConsumer_, light: number, overlay: number): void;
        render(arg0: Internal.PoseStack_, arg1: Internal.VertexConsumer_, arg2: number, arg3: number): void;
        receiveRootAnimationRunnable(variant: number, run: Internal.Runnable_): void;
        toString(): string;
        notifyAll(): void;
        emf$getTextureSize(): number[];
        getRandomCube(arg0: Internal.RandomSource_): Internal.ModelPart$Cube;
        isHidden(): boolean;
        hasAnimation(): boolean;
        offsetPos(arg0: Vec3f_): void;
        receiveAnimations(variant: number, animationList: Internal.Collection_<Internal.EMFAnimation>): void;
        hashCode(): number;
        static from(arg0: Internal.ModelPart_): Internal.ModelPartData;
        resetVanillaPartsToDefaults(): void;
        resetPose(): void;
        wait(arg0: number): void;
        storePose(): Internal.PartPose;
        equals(arg0: any): boolean;
        getAllVanillaPartsEMF(): Internal.Collection<Internal.EMFModelPartVanilla>;
        doVariantCheck(): void;
        get vanillaFormatRoot(): Internal.ModelPart
        set hideInTheseStates(variant: number)
        get visible(): boolean
        get allEMFCustomChildren(): Internal.ModelPart[]
        get topLevelJemTexture(): ResourceLocation
        get vanillaModelPartsOfCurrentState(): Internal.ModelPart
        set variantStateTo(newVariant: number)
        get cuboids(): Internal.ModelCuboid[]
        get class(): typeof any
        get initialPose(): Internal.PartPose
        get empty(): boolean
        get allParts(): Internal.Stream<Internal.ModelPart>
        set initialPose(arg0: Internal.PartPose_)
        get children(): Internal.ModelPart[]
        get hidden(): boolean
        get allVanillaPartsEMF(): Internal.Collection<Internal.EMFModelPartVanilla>
        directoryContext: Internal.EMFDirectoryHandler;
        readonly modelName: Internal.EMFModel_ID;
        readonly vanillaRoot: Internal.ModelPart;
        readonly entitySuffixMap: Internal.EntityIntLRU;
        containsCustomModel: boolean;
        variantTester: Internal.ETFApi$ETFVariantSuffixProvider;
    }
    type EMFModelPartRoot_ = EMFModelPartRoot;
    class LanternBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        asItem(): Internal.Item;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getName(): Internal.MutableComponent;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly WATERLOGGED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly HANGING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    }
    type LanternBlock_ = LanternBlock;
    abstract class AbstractAdvancedSidedDisplayBlock extends Internal.AbstractAdvancedDisplayBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getPropertyFromNeighbours<T extends Internal.Comparable<T>>(pState: Internal.BlockState_, pLevel: Internal.Level_, pPos: BlockPos_, property: Internal.Property_<T>): Internal.BlockState;
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        asItem(): Internal.Item;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        static playRemoveSound(arg0: Internal.Level_, arg1: BlockPos_): void;
        getBlockEntityOptional(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.Optional<Internal.AdvancedDisplayBlockEntity>;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        getRenderShape(pState: Internal.BlockState_): Internal.RenderShape;
        static getConnection(state: Internal.BlockState_, side: Internal.Direction_): boolean;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        getRotatedBlockState(arg0: Internal.BlockState_, arg1: Internal.Direction_): Internal.BlockState;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        tick(pState: Internal.BlockState_, pLevel: Internal.ServerLevel_, pPos: BlockPos_, pRandom: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockEntityUse(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Function_<Internal.AdvancedDisplayBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        use(pState: Internal.BlockState_, pLevel: Internal.Level_, pPos: BlockPos_, pPlayer: Internal.Player_, pHand: Internal.InteractionHand_, pHit: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(context: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getTicker<S extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        wait(): void;
        static playRotateSound(arg0: Internal.Level_, arg1: BlockPos_): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(state: Internal.BlockState_, pDirection: Internal.Direction_, pNeighborState: Internal.BlockState_, pLevel: Internal.LevelAccessor_, pCurrentPos: BlockPos_, pNeighborPos: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(pState: Internal.BlockState_, pRotation: Internal.Rotation_): Internal.BlockState;
        static onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getPropertyFromNeighbour<T extends Internal.Comparable<T>>(pState: Internal.BlockState_, pLevel: Internal.Level_, pPos: BlockPos_, relPos: BlockPos_, property: Internal.Property_<T>): Internal.BlockState;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        onRemove(pState: Internal.BlockState_, pLevel: Internal.Level_, pPos: BlockPos_, pNewState: Internal.BlockState_, pIsMoving: boolean): void;
        abstract getRenderAspectRatio(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_): de.mrjulsen.mcdragonlib.data.Pair<number, number>;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        abstract getRenderOffset(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_): de.mrjulsen.mcdragonlib.data.Pair<number, number>;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        withBlockEntityDo(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Consumer_<Internal.AdvancedDisplayBlockEntity>): void;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        abstract getRenderRotation(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_): Internal.Tripple<number, number, number>;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDefaultPlacementState(context: Internal.BlockPlaceContext_, state: Internal.BlockState_, other: Internal.BlockState_): Internal.BlockState;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getExcludedProperties(): Internal.Collection<Internal.Property<any>>;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        updateNeighbours(pState: Internal.BlockState_, pLevel: Internal.Level_, pPos: BlockPos_): void;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        onSneakWrenched(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        getBlockEntityClass(): typeof Internal.AdvancedDisplayBlockEntity;
        abstract isSingleLined(): boolean;
        updateAfterWrenched(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_): Internal.BlockState;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        onPlace(pState: Internal.BlockState_, pLevel: Internal.Level_, pPos: BlockPos_, pOldState: Internal.BlockState_, pIsMoving: boolean): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        appendOnPlace(context: Internal.BlockPlaceContext_, state: Internal.BlockState_, other: Internal.BlockState_): Internal.BlockState;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        static setConnection(state: Internal.BlockState_, side: Internal.Direction_, connect: boolean): Internal.BlockState;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        static getDisplayColor(): Internal.BlockColor;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        abstract getRenderZOffset(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_): de.mrjulsen.mcdragonlib.data.Pair<number, number>;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        applyPropertiesOf(current: Internal.BlockState_, state: Internal.BlockState_): Internal.BlockState;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        canConnectWithBlock(level: Internal.IBlockGetter_, selfState: Internal.BlockState_, otherState: Internal.BlockState_): boolean;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(pState: Internal.BlockState_, pMirror: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getName(): Internal.MutableComponent;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getBlockEntity(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.AdvancedDisplayBlockEntity;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.AdvancedDisplayBlockEntity>;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        get excludedProperties(): Internal.Collection<Internal.Property<any>>
        set speedFactor(arg0: number)
        get blockEntityClass(): typeof Internal.AdvancedDisplayBlockEntity
        get singleLined(): boolean
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        get displayColor(): Internal.BlockColor
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        get blockEntityType(): Internal.BlockEntityType<Internal.AdvancedDisplayBlockEntity>
        set hasCollision(arg0: boolean)
        static readonly SIDE: Internal.EnumProperty<Internal.ESide>;
    }
    type AbstractAdvancedSidedDisplayBlock_ = AbstractAdvancedSidedDisplayBlock;
    interface Tier {
        /**
         * @deprecated
        */
        abstract getLevel(): number;
        abstract getAttackDamageBonus(): number;
        abstract getRepairIngredient(): Internal.Ingredient;
        abstract getEnchantmentValue(): number;
        abstract getUses(): number;
        abstract getSpeed(): number;
        getTag(): Internal.TagKey<Internal.Block>;
        /**
         * @deprecated
        */
        get level(): number
        get attackDamageBonus(): number
        get repairIngredient(): Internal.Ingredient
        get enchantmentValue(): number
        get uses(): number
        get speed(): number
        get tag(): Internal.TagKey<Internal.Block>
    }
    type Tier_ = string | Tier;
    class SporeBlossomBlock extends Internal.Block {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        asItem(): Internal.Item;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getName(): Internal.MutableComponent;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type SporeBlossomBlock_ = SporeBlossomBlock;
    class PostPass implements Internal.AutoCloseable {
        constructor(arg0: Internal.ResourceManager_, arg1: string, arg2: Internal.RenderTarget_, arg3: Internal.RenderTarget_)
        getClass(): typeof any;
        setOrthoMatrix(arg0: Matrix4f_): void;
        process(arg0: number): void;
        toString(): string;
        notifyAll(): void;
        addAuxAsset(arg0: string, arg1: Internal.IntSupplier_, arg2: number, arg3: number): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        getName(): string;
        close(): void;
        getEffect(): Internal.EffectInstance;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        get class(): typeof any
        set orthoMatrix(arg0: Matrix4f_)
        get name(): string
        get effect(): Internal.EffectInstance
        readonly outTarget: Internal.RenderTarget;
        readonly inTarget: Internal.RenderTarget;
    }
    type PostPass_ = PostPass;
    class ClientboundTagQueryPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor(arg0: Internal.FriendlyByteBuf_)
        constructor(arg0: number, arg1: Internal.CompoundTag_)
        handle(arg0: Internal.PacketListener_): void;
        getClass(): typeof any;
        write(arg0: Internal.FriendlyByteBuf_): void;
        toString(): string;
        notifyAll(): void;
        getTransactionId(): number;
        notify(): void;
        isSkippable(): boolean;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        handle(arg0: Internal.ClientGamePacketListener_): void;
        wait(arg0: number): void;
        "handle(net.minecraft.network.protocol.game.ClientGamePacketListener)"(arg0: Internal.ClientGamePacketListener_): void;
        getTag(): Internal.CompoundTag;
        equals(arg0: any): boolean;
        "handle(net.minecraft.network.PacketListener)"(arg0: Internal.PacketListener_): void;
        get class(): typeof any
        get transactionId(): number
        get skippable(): boolean
        get tag(): Internal.CompoundTag
    }
    type ClientboundTagQueryPacket_ = ClientboundTagQueryPacket;
    interface BufferedImageOp {
        abstract createCompatibleDestImage(arg0: Internal.BufferedImage_, arg1: Internal.ColorModel_): Internal.BufferedImage;
        abstract filter(arg0: Internal.BufferedImage_, arg1: Internal.BufferedImage_): Internal.BufferedImage;
        abstract getBounds2D(arg0: Internal.BufferedImage_): Internal.Rectangle2D;
        abstract getRenderingHints(): Internal.RenderingHints;
        abstract getPoint2D(arg0: Internal.Point2D_, arg1: Internal.Point2D_): Internal.Point2D;
        get renderingHints(): Internal.RenderingHints
    }
    type BufferedImageOp_ = BufferedImageOp;
    class HitResult$Type extends Internal.Enum<Internal.HitResult$Type> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getDeclaringClass(): typeof Internal.HitResult$Type;
        getClass(): typeof any;
        toString(): string;
        "compareTo(net.minecraft.world.phys.HitResult$Type)"(arg0: Internal.HitResult$Type_): number;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        name(): string;
        hashCode(): number;
        static valueOf(arg0: string): Internal.HitResult$Type;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.HitResult$Type>>;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        static values(): Internal.HitResult$Type[];
        compareTo(arg0: Internal.HitResult$Type_): number;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        get declaringClass(): typeof Internal.HitResult$Type
        get class(): typeof any
        static readonly MISS: (Internal.HitResult$Type) & (Internal.HitResult$Type);
        static readonly ENTITY: (Internal.HitResult$Type) & (Internal.HitResult$Type);
        static readonly BLOCK: (Internal.HitResult$Type) & (Internal.HitResult$Type);
    }
    type HitResult$Type_ = "miss" | "block" | HitResult$Type | "entity";
    class SynchedEntityData$DataValue <T> extends Internal.Record {
        constructor(id: number, serializer: Internal.EntityDataSerializer_<T>, value: T)
        getClass(): typeof any;
        write(arg0: Internal.FriendlyByteBuf_): void;
        toString(): string;
        notifyAll(): void;
        value(): T;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        id(): number;
        wait(): void;
        serializer(): Internal.EntityDataSerializer<T>;
        wait(arg0: number): void;
        static create<T>(arg0: Internal.EntityDataAccessor_<T>, arg1: T): Internal.SynchedEntityData$DataValue<T>;
        static read(arg0: Internal.FriendlyByteBuf_, arg1: number): Internal.SynchedEntityData$DataValue<any>;
        equals(arg0: any): boolean;
        get class(): typeof any
    }
    type SynchedEntityData$DataValue_<T> = SynchedEntityData$DataValue<T>;
    abstract class ImmutableList <E> extends Internal.ImmutableCollection<E> implements Internal.RandomAccess, Internal.List<E> {
        static builder<E>(): Internal.ImmutableList$Builder<E>;
        static copyOf<E>(arg0: E[]): Internal.ImmutableList<E>;
        reverse(): this;
        static sortedCopyOf<E>(arg0: Internal.Comparator_<E>, arg1: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        static copyOf<E>(arg0: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        /**
         * @deprecated
        */
        sort(arg0: Internal.Comparator_<E>): void;
        notify(): void;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        /**
         * @deprecated
        */
        "remove(int)"(arg0: number): E;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        /**
         * @deprecated
        */
        addAll(arg0: number, arg1: Internal.Collection_<E>): boolean;
        listIterator(): Internal.ListIterator<any>;
        abstract addAll(arg0: Internal.Collection_<E>): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.ImmutableList<E>;
        indexOf(arg0: any): number;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: E): void;
        forEach(arg0: Internal.Consumer_<E>): void;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.ImmutableList<E>;
        abstract toArray<T>(arg0: T[]): T[];
        static "of(java.lang.Object)"<E>(arg0: E): Internal.ImmutableList<E>;
        abstract remove(arg0: any): boolean;
        abstract "remove(java.lang.Object)"(arg0: any): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.ImmutableList<E>;
        stream(): Internal.Stream<E>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        wait(): void;
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        static "copyOf(java.lang.Iterable)"<E>(arg0: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        static "of(java.lang.Object[])"<E>(...arg0: E[]): Internal.List<E>;
        iterator(): Internal.UnmodifiableIterator<E>;
        lastIndexOf(arg0: any): number;
        static of<E>(arg0: E, arg1: E): Internal.ImmutableList<E>;
        getClass(): typeof any;
        abstract get(arg0: number): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.ImmutableList<E>;
        static "copyOf(java.util.Collection)"<E>(arg0: Internal.Collection_<E>): Internal.ImmutableList<E>;
        abstract add(arg0: E): boolean;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.ImmutableList<E>;
        parallelStream(): Internal.Stream<E>;
        abstract isEmpty(): boolean;
        wait(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: E): E;
        static of<E>(...arg0: E[]): Internal.List<E>;
        listIterator(arg0: number): Internal.ListIterator<any>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E, arg10: E, arg11: E, ...arg12: E[]): Internal.ImmutableList<E>;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.ImmutableList<E>;
        static builderWithExpectedSize<E>(arg0: number): Internal.ImmutableList$Builder<E>;
        static of<E>(): Internal.ImmutableList<E>;
        /**
         * @deprecated
        */
        remove(arg0: number): E;
        static of<E>(arg0: E): Internal.ImmutableList<E>;
        contains(arg0: any): boolean;
        static "copyOf(java.util.Iterator)"<E>(arg0: Internal.Iterator_<E>): Internal.ImmutableList<E>;
        /**
         * @deprecated
        */
        replaceAll(arg0: Internal.UnaryOperator_<E>): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.ImmutableList<E>;
        toString(): string;
        notifyAll(): void;
        static sortedCopyOf<E extends Internal.Comparable<any>>(arg0: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        static "copyOf(java.lang.Object[])"<E>(arg0: E[]): Internal.ImmutableList<E>;
        abstract "toArray(java.lang.Object[])"<T>(arg0: T[]): T[];
        "toArray(java.util.function.IntFunction)"<T>(arg0: Internal.IntFunction_<T[]>): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E, arg10: E): Internal.ImmutableList<E>;
        abstract toArray(): any[];
        /**
         * @deprecated
        */
        asList(): this;
        subList(arg0: number, arg1: number): Internal.List<any>;
        hashCode(): number;
        abstract size(): number;
        static toImmutableList<E>(): Internal.Collector<E, any, Internal.ImmutableList<E>>;
        abstract clear(): void;
        wait(arg0: number): void;
        spliterator(): Internal.Spliterator<E>;
        equals(arg0: any): boolean;
        static copyOf<E>(arg0: Internal.Iterator_<E>): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.ImmutableList<E>;
        get class(): typeof any
        get empty(): boolean
    }
    type ImmutableList_<E> = ImmutableList<E>;
    /**
     * Methods for working with Java classes. Reflection my beloved ♥
    */
    class JavaWrapper {
        constructor(manager: any_)
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeItem"): Internal.IForgeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.datatransfer.FlavorMap"): Internal.FlavorMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.Consumer"): Internal.Consumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.schematics.requirement.ItemRequirement"): typeof Internal.ItemRequirement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.extendedae_plus.api.SmartDoublingHolder"): Internal.SmartDoublingHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "top.theillusivec4.curios.api.type.capability.ICurio$SoundInfo"): typeof Internal.ICurio$SoundInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.CarpetBlockBuilder"): typeof Internal.CarpetBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.block.InventoryBlock"): typeof slimeknights.mantle.block.InventoryBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.Screen$NarratableSearchResult"): typeof Internal.Screen$NarratableSearchResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.VillagerBabiesSensor"): typeof Internal.VillagerBabiesSensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.schedule.ScheduleItem"): typeof Internal.ScheduleItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.utils.IdParser"): typeof Internal.IdParser;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.particles.ParticleTypes$1"): typeof Internal.ParticleTypes$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.SurfaceRules$RuleSource"): Internal.SurfaceRules$RuleSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.visual.EntityVisual"): Internal.EntityVisual;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.smeltery.block.SearedLanternBlock"): typeof Internal.SearedLanternBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.drawable.IDrawable"): Internal.IDrawable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.base.common.recipe.ShapedEntityStorageRecipe$Serializer"): typeof Internal.ShapedEntityStorageRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.parts.IPartModel"): Internal.IPartModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.fan.processing.FanProcessingType$AirFlowParticleAccess"): Internal.FanProcessingType$AirFlowParticleAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.ingredients.IIngredientTypeWithSubtypes"): Internal.IIngredientTypeWithSubtypes;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.InputReplacement"): Internal.InputReplacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.vertex.VertexList"): Internal.VertexList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.bindings.BlockWrapper"): typeof Block;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.AugmentItem"): typeof Internal.AugmentItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.HangingSignBlockEntity"): typeof Internal.HangingSignBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.codecs.BaseMapCodec"): Internal.BaseMapCodec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.GlazedTerracottaBlock"): typeof Internal.GlazedTerracottaBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.Long2FloatFunction"): Internal.Long2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.data.loadable.Loadable"): Internal.Loadable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "fuzs.puzzleslib.mixin.accessor.BiomeSpecialEffectsBuilderForgeAccessor"): Internal.BiomeSpecialEffectsBuilderForgeAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.CustomizeGuiOverlayEvent$DebugText"): typeof Internal.CustomizeGuiOverlayEvent$DebugText;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.living.PotionColorCalculationEvent"): typeof Internal.PotionColorCalculationEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket$Action"): typeof Internal.ClientboundSetPlayerTeamPacket$Action;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.lib.util.recipes.ThermalFuel"): typeof Internal.ThermalFuel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_bogeys.blocks.base.CRBogeyBlock"): typeof Internal.CRBogeyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.block.EntityBlockActive6Way"): typeof Internal.EntityBlockActive6Way;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.modifiers.util.LazyModifier"): typeof Internal.LazyModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.brassgearbox.BrassGearboxBlock"): typeof Internal.BrassGearboxBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.BiPredicate"): Internal.BiPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity"): Internal.IMultiStateCopycatBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.util.NonNullSupplier"): Internal.NonNullSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.EnderChestBlock"): typeof Internal.EnderChestBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mari_023.ae2wtlib.wut.recipe.Combine"): typeof Internal.Combine;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.functions.PointFree"): typeof Internal.PointFree;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2LongFunction"): Internal.Double2LongFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.resources.ResourceManagerReloadListener"): Internal.ResourceManagerReloadListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BedBlock"): typeof Internal.BedBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.ModelBlockRenderer"): typeof Internal.ModelBlockRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration"): typeof Internal.ReplaceBlockConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.resources.RegistryFileCodec"): typeof Internal.RegistryFileCodec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.chassis.AbstractChassisBlock"): typeof Internal.AbstractChassisBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.UniqueTag"): typeof Internal.UniqueTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.world.ClimateSettingsBuilder"): typeof Internal.ClimateSettingsBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.realmsclient.dto.RealmsNews"): typeof Internal.RealmsNews;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlock"): typeof Internal.MechanicalBearingBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.parts.ICableBusContainer"): Internal.ICableBusContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.DensityFunction$NoiseHolder"): typeof Internal.DensityFunction$NoiseHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.ServerScoreboard"): typeof Internal.ServerScoreboard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.debug.DebugCardItem"): typeof Internal.DebugCardItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.MobSpawnType"): typeof Internal.MobSpawnType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.material.IMaterialValue"): Internal.IMaterialValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.ItemStackedOnOtherEvent"): typeof Internal.ItemStackedOnOtherEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.ThrownEnderpearl"): typeof Internal.ThrownEnderpearl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SpectralArrowItem"): typeof Internal.SpectralArrowItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.create.events.BoilerHeaterHandlerEvent$BoilerHeaterCallback"): Internal.BoilerHeaterHandlerEvent$BoilerHeaterCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock"): typeof Internal.EncasedCogwheelBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.ILimitedGlobalStation"): Internal.ILimitedGlobalStation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.PickaxeItemBuilder"): typeof Internal.PickaxeItemBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.entity.TrainStatus$StatusMessage"): typeof Internal.TrainStatus$StatusMessage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.MapDecoder"): Internal.MapDecoder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.single_deco.LinkPinBlock"): typeof Internal.LinkPinBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.providers.RegistrateItemTagsProvider"): typeof Internal.RegistrateItemTagsProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.item.ChiseledBlockItem"): typeof Internal.ChiseledBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.platform.InputConstants$Key"): typeof Internal.InputConstants$Key;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.api.crafting.IReprocessorRecipe"): Internal.IReprocessorRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.npc.WanderingTrader"): typeof Internal.WanderingTrader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.blockentity.networking.EnergyAcceptorBlockEntity"): typeof Internal.EnergyAcceptorBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.api.conduit.ConduitNode$IOState"): typeof Internal.ConduitNode$IOState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "codechicken.lib.vec.uv.UV"): typeof Internal.UV;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.network.FilteredText"): typeof Internal.FilteredText;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.AbstractIllager"): typeof Internal.AbstractIllager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.crafting.recipe.ShapedTagRecipe"): typeof Internal.ShapedTagRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WitherWallSkullBlock"): typeof Internal.WitherWallSkullBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "create_more_additions.block.SilverWallBlock"): typeof Internal.SilverWallBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.item.SpawnEggItemCoFH"): typeof Internal.SpawnEggItemCoFH;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.MonoTrackBufferBlock$Style"): typeof Internal.MonoTrackBufferBlock$Style;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.ServerLevelAccessor"): Internal.ServerLevelAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.blockentity.AEBaseInvBlockEntity"): typeof Internal.AEBaseInvBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeItem"): typeof Internal.PumpUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock$PanelSlot"): typeof Internal.FactoryPanelBlock$PanelSlot;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.machines.common.item.CapacitorBankItem"): typeof Internal.CapacitorBankItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.blockentity.misc.VibrationChamberBlockEntity"): typeof Internal.VibrationChamberBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.KeyEvent"): typeof Internal.KeyEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.data.recipes.ShapelessRecipeBuilder"): typeof Internal.ShapelessRecipeBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Toolkit"): typeof Internal.Toolkit;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.mcdragonlib.client.ber.IBlockEntityRendererInstance"): Internal.IBlockEntityRendererInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.machines.common.io.item.MachineInventoryLayout$Builder"): typeof Internal.MachineInventoryLayout$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.FrogAttackablesSensor"): typeof Internal.FrogAttackablesSensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.client.multiplayer.AccessorClientAdvancements"): Internal.AccessorClientAdvancements;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.AbstractMultimap"): typeof Internal.AbstractMultimap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.infinity.InfinityUpgradeItem$Wrapper"): typeof Internal.InfinityUpgradeItem$Wrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.misc.EnchantmentBuilder"): typeof Internal.EnchantmentBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.displayLink.DisplayLinkContext"): typeof Internal.DisplayLinkContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.FlowerPotBlock"): typeof Internal.FlowerPotBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.level.LevelEvent$Save"): typeof Internal.LevelEvent$Save;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.VertexFormatElement$Usage"): typeof Internal.VertexFormatElement$Usage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Wolf"): typeof Internal.Wolf;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.ponder.api.element.PonderOverlayElement"): Internal.PonderOverlayElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.widgets.IRecipeWidget"): Internal.IRecipeWidget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.heightproviders.BiasedToBottomHeight"): typeof Internal.BiasedToBottomHeight;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DragGestureListener"): Internal.DragGestureListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.extensions.injected.InjectedBlockExtension"): Internal.InjectedBlockExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.IArmPoseTransformer"): Internal.IArmPoseTransformer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeVoid"): typeof Internal.ItemUpgradeVoid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.glodblock.github.extendedae.recipe.util.IngredientStack"): typeof Internal.IngredientStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.geom.ModelLayerLocation"): typeof Internal.ModelLayerLocation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.EnchantmentCategory"): typeof Internal.EnchantmentCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.denismasterherobrine.angelring.item.vanilla.LegacyAngelRing"): typeof Internal.LegacyAngelRing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.AccessibleSelection"): Internal.AccessibleSelection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.block.BaseGlassBlock"): typeof Internal.BaseGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.EndCrystalItem"): typeof Internal.EndCrystalItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.render.SuperRenderTypeBuffer"): Internal.SuperRenderTypeBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.Feature"): typeof Internal.Feature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.BooleanProperty"): typeof Internal.BooleanProperty;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.synchronization.SingletonArgumentInfo$Template"): typeof Internal.SingletonArgumentInfo$Template;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.builder.ITooltipBuilder"): Internal.ITooltipBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.providers.RegistrateAdvancementProvider"): typeof Internal.RegistrateAdvancementProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.AbstractContraptionEntity$ContraptionRotationState"): typeof Internal.AbstractContraptionEntity$ContraptionRotationState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.encasing.CasingBlock"): typeof Internal.CasingBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrbysco.neoauth.mixin.AbuseReportContextAccessor"): Internal.AbuseReportContextAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation"): Internal.IHaveHoveringInformation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.mounted.CartAssemblerBlock$MinecartAnchorBlock"): typeof Internal.CartAssemblerBlock$MinecartAnchorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController"): typeof Internal.BlockEntityController;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.crankwheel.CrankWheelBlock$Small"): typeof Internal.CrankWheelBlock$Small;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbteams.api.property.TeamPropertyValue"): typeof Internal.TeamPropertyValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.attributes.AttributeMap"): typeof Internal.AttributeMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.scores.criteria.ObjectiveCriteria"): typeof Internal.ObjectiveCriteria;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.OrRecipeComponent"): typeof Internal.OrRecipeComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.ticks.TickContainerAccess"): Internal.TickContainerAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.LevelChunk$EntityCreationType"): typeof Internal.LevelChunk$EntityCreationType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard"): typeof Internal.ValueSettingsBoard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagradditions.world.modifiers.EndProsperityOreModifier"): typeof Internal.EndProsperityOreModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.fluids.FluidType"): typeof Internal.FluidType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.chute.SmartChuteBlock"): typeof Internal.SmartChuteBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeConfig"): typeof Internal.CookingUpgradeConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.widgets.IScrollGridWidget"): Internal.IScrollGridWidget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.extensions.injected.InjectedGameEventExtension"): Internal.InjectedGameEventExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.RedstoneLampBlock"): typeof Internal.RedstoneLampBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.storage.StorageTier"): typeof Internal.StorageTier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.foliageplacers.RandomSpreadFoliagePlacer"): typeof Internal.RandomSpreadFoliagePlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.Products$P6"): typeof Internal.Products$P6;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.modifiers.ModifierManager$ModifiersLoadedEvent"): typeof Internal.ModifierManager$ModifiersLoadedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WitherSkullBlock"): typeof Internal.WitherSkullBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Targeting"): Internal.Targeting;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.helpers.patternprovider.PatternProviderLogicHost"): Internal.PatternProviderLogicHost;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.OptionalDouble"): typeof Internal.OptionalDouble;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern$CraftingGridAccessor"): Internal.IMolecularAssemblerSupportedPattern$CraftingGridAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.IGenericCrossingTrackBE"): Internal.IGenericCrossingTrackBE;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.profiling.ResultField"): typeof Internal.ResultField;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.ChestType"): typeof Internal.ChestType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.schematics.SchematicPrinter"): typeof Internal.SchematicPrinter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.bogey.BogeyVisual"): Internal.BogeyVisual;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.painter.PainterObjectStorage"): typeof Internal.PainterObjectStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.AbstractArrow"): typeof Internal.AbstractArrow;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerInteractEvent"): typeof Internal.PlayerInteractEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.machines.common.recipe.EnchanterRecipe$Serializer"): typeof Internal.EnchanterRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Parrot$Variant"): typeof Internal.Parrot$Variant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.FenceGateBlock"): typeof Internal.FenceGateBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ModelEvent$BakingCompleted"): typeof Internal.ModelEvent$BakingCompleted;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.EntityArgument$Info$Template"): typeof Internal.EntityArgument$Info$Template;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.EndGatewayConfiguration"): typeof Internal.EndGatewayConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.depot.DepotBlockEntity"): typeof Internal.DepotBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.base.common.block.EnderSkullBlock"): typeof Internal.EnderSkullBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.memory.MemoryStatus"): typeof Internal.MemoryStatus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbultimine.mixin.ShovelItemAccess"): Internal.ShovelItemAccess;
        /**
         * Creates a custom ConsoleJS instance for you to use to, well, log stuff
        */
        createConsole(name: string): Internal.ConsoleJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.material.Transparency"): typeof dev.engine_room.flywheel.api.material.Transparency;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.locks.Lock"): Internal.Lock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.orientation.RelativeSide"): typeof Internal.RelativeSide;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.item.multistate.IMultiStateItemStack"): Internal.IMultiStateItemStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.MobCategory"): typeof Internal.MobCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.ImmutableCollections$ListN"): typeof Internal.ImmutableCollections$ListN;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ResourceArgument$Info"): typeof Internal.ResourceArgument$Info;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.crn.data.train.PredictionTimes$DepartureTime"): typeof Internal.PredictionTimes$DepartureTime;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.heightproviders.HeightProvider"): typeof Internal.HeightProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.ModCheck$Confidence"): typeof Internal.ModCheck$Confidence;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.providers.RegistrateTagsProvider$IntrinsicImpl"): typeof Internal.RegistrateTagsProvider$IntrinsicImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.FontMetrics"): typeof Internal.FontMetrics;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity"): typeof Internal.ChiseledBookShelfBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blockpredicates.AnyOfPredicate"): typeof Internal.AnyOfPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.Short2CharFunction"): Internal.Short2CharFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2FloatFunction"): Internal.Double2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.network.PlayMessages$SpawnEntity"): typeof Internal.PlayMessages$SpawnEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.ModifyRecipeCraftingGrid"): typeof Internal.ModifyRecipeCraftingGrid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.link.RedstoneLinkBlock"): typeof Internal.RedstoneLinkBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSoundEntityPacket"): typeof Internal.ClientboundSoundEntityPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.client.render.effects.EnergyParticleData"): typeof Internal.EnergyParticleData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerEvent$PlayerLoggedOutEvent"): typeof Internal.PlayerEvent$PlayerLoggedOutEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.special.ShapedKubeJSRecipe"): typeof Internal.ShapedKubeJSRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.api.crafting.IInfusionRecipe"): Internal.IInfusionRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.shared.particle.FluidParticleData$Type"): typeof Internal.FluidParticleData$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.attributefilter.ItemDamageAttribute$Type"): typeof Internal.ItemDamageAttribute$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.LangEventJS"): typeof Internal.LangEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.builder.IRecipeLayoutBuilder"): Internal.IRecipeLayoutBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.PrimitiveIterator$OfDouble"): Internal.PrimitiveIterator$OfDouble;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.zapper.terrainzapper.WorldshaperItem"): typeof Internal.WorldshaperItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.LongSerializationPolicy"): typeof Internal.LongSerializationPolicy;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.ItemComponents$3"): typeof Internal.ItemComponents$3;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.AbstractHurtingProjectile"): typeof Internal.AbstractHurtingProjectile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.switches.TrackSwitchBlock"): typeof Internal.TrackSwitchBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.TypeAdapter"): typeof Internal.TypeAdapter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.glodblock.github.extendedae.recipe.CircuitCutterRecipe"): typeof Internal.CircuitCutterRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.npc.VillagerProfession"): typeof Internal.VillagerProfession;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.index.CARecipes$1"): typeof Internal.CARecipes$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.elevator.ElevatorPulleyBlock"): typeof Internal.ElevatorPulleyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ScoreHolderArgument"): typeof Internal.ScoreHolderArgument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ExperienceOrb"): typeof Internal.ExperienceOrb;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector4i"): typeof Internal.Vector4i;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.caffeinemc.mods.sodium.api.vertex.attributes.CommonVertexAttribute"): typeof Internal.CommonVertexAttribute;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.ForgeConfigSpec$ValueSpec"): typeof Internal.ForgeConfigSpec$ValueSpec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.shaders.Program"): typeof Internal.Program;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.WideTrackBufferBlock"): typeof Internal.WideTrackBufferBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.AttachedStemBlock"): typeof Internal.AttachedStemBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.BasaltColumnsFeature"): typeof Internal.BasaltColumnsFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "traben.entity_texture_features.features.state.ETFEntityRenderState"): Internal.ETFEntityRenderState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.kinds.K1"): Internal.K1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.DataResult"): typeof Internal.DataResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.item.EarthChargeItem"): typeof Internal.EarthChargeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2ReferenceMap$Entry"): Internal.Object2ReferenceMap$Entry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.chars.Char2ObjectFunction"): Internal.Char2ObjectFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.embeddedt.embeddium.render.matrix_stack.CachingPoseStack"): Internal.CachingPoseStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.server.ServerEventJS"): typeof Internal.ServerEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.switches.SwitchDisplaySource"): typeof Internal.SwitchDisplaySource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.crn.data.train.portable.TrainDisplayData$State"): typeof Internal.TrainDisplayData$State;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.LecternMenu"): typeof Internal.LecternMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.shaders.EffectProgram"): typeof Internal.EffectProgram;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.DoubleToIntFunction"): Internal.DoubleToIntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.SpringFeature"): typeof Internal.SpringFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.SimpleRandomSelectorFeature"): typeof Internal.SimpleRandomSelectorFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.item.tool.BasePaxelItem"): typeof Internal.BasePaxelItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Vex"): typeof Internal.Vex;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$BlockDisplay"): typeof Internal.Display$BlockDisplay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.util.ConfigInventory"): typeof Internal.ConfigInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.ConstantInt"): typeof Internal.ConstantInt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.utils.RestrictedCompoundTag"): typeof Internal.RestrictedCompoundTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.item.tool.IUnsealItem"): Internal.IUnsealItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.level.ChunkEvent$Load"): typeof Internal.ChunkEvent$Load;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Entity$RemovalReason"): typeof Internal.Entity$RemovalReason;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.network.IContainerFactory"): Internal.IContainerFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase"): typeof Internal.CapManipulationBehaviourBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.HashMap"): typeof Internal.HashMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.extensions.common.IClientBlockExtensions"): Internal.IClientBlockExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder$Helmet"): typeof Internal.ArmorItemBuilder$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity"): typeof Internal.MechanicalMixerBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.WithPersistentData"): Internal.WithPersistentData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tables.block.ITabbedBlock"): Internal.ITabbedBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.geom.PartPose"): typeof Internal.PartPose;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.block.InfusionPedestalBlock"): typeof Internal.InfusionPedestalBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.ChorusPlantBlock"): typeof Internal.ChorusPlantBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.base.common.enchantment.AutoSmeltEnchantment"): typeof Internal.AutoSmeltEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.BasicItemJS$Builder"): typeof Internal.BasicItemJS$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.me.cluster.IAECluster"): Internal.IAECluster;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.fluids.pipes.EncasedPipeBlock"): typeof Internal.EncasedPipeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeBlock"): Internal.IForgeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.BuildersTeaItem"): typeof Internal.BuildersTeaItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingUpgradeItem"): typeof Internal.EverlastingUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.StringSplitter"): typeof Internal.StringSplitter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.bogey.BogeyStyle$SizeRenderer"): typeof Internal.BogeyStyle$SizeRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.AbstractIllager$IllagerArmPose"): typeof Internal.AbstractIllager$IllagerArmPose;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.funnel.FunnelBlockEntity"): typeof Internal.FunnelBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.UserType"): typeof Internal.UserType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.NetherrackBlock"): typeof Internal.NetherrackBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.crn.data.train.TrainData"): typeof Internal.TrainData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.fan.EncasedFanBlock"): typeof Internal.EncasedFanBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.ComponentRole"): typeof Internal.ComponentRole;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType"): typeof Internal.LootScoreProviderType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.sound.SoundEvent"): typeof net.minecraftforge.client.event.sound.SoundEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.TerrainAdjustment"): typeof Internal.TerrainAdjustment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.StreamTagVisitor$ValueResult"): typeof Internal.StreamTagVisitor$ValueResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.BlockModificationEventJS"): typeof Internal.BlockModificationEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.crafting.recipe.InfusionRecipe$Serializer"): typeof Internal.InfusionRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.api.IResourceStorage"): Internal.IResourceStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.glodblock.github.extendedae.common.blocks.matrix.BlockAssemblerMatrixWall"): typeof Internal.BlockAssemblerMatrixWall;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData"): typeof com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.decorative.solid.BuddingCertusQuartzBlock"): typeof Internal.BuddingCertusQuartzBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tables.block.ScorchedAnvilBlock"): typeof Internal.ScorchedAnvilBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.block.SlimeNyliumBlock"): typeof Internal.SlimeNyliumBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.BufferStrategy"): typeof Internal.BufferStrategy;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration"): typeof Internal.LargeDripstoneConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.WritableRenderedImage"): Internal.WritableRenderedImage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.visual.SectionTrackedVisual$SectionCollector"): Internal.SectionTrackedVisual$SectionCollector;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.WindowListener"): Internal.WindowListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderBuffers"): typeof Internal.RenderBuffers;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.io.Serializable"): Internal.Serializable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.decorative.solid.QuartzGlassBlock"): typeof Internal.QuartzGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.util.Function16"): Internal.Function16;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.LightTexture"): typeof Internal.LightTexture;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.format.DecimalStyle"): typeof Internal.DecimalStyle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton"): typeof Internal.DLButton;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.glodblock.github.extendedae.common.blocks.matrix.BlockAssemblerMatrixGlass"): typeof Internal.BlockAssemblerMatrixGlass;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlock"): typeof Internal.ContraptionControlsBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PermissionsChangedEvent"): typeof Internal.PermissionsChangedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.event.forge.PopupMenuEvent$FullscreenPopupMenuEvent"): typeof Internal.PopupMenuEvent$FullscreenPopupMenuEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.SignableCommand"): typeof Internal.SignableCommand;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.OffsetTime"): typeof Internal.OffsetTime;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.network.ServerStatusPing"): typeof Internal.ServerStatusPing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.visual.DynamicVisual"): Internal.DynamicVisual;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "squeek.appleskin.api.event.TooltipOverlayEvent"): typeof Internal.TooltipOverlayEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "malte0811.ferritecore.mixin.blockstatecache.VoxelShapeAccess"): Internal.VoxelShapeAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.MenuComponent"): typeof Internal.MenuComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.helpers.IConfigInvHost"): Internal.IConfigInvHost;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.profiling.ProfileResults"): Internal.ProfileResults;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.swing.text.StyleConstants$FontConstants"): typeof Internal.StyleConstants$FontConstants;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.crate.CreativeCrateMountedStorage"): typeof Internal.CreativeCrateMountedStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.crafting.ICraftingSimulationRequester"): Internal.ICraftingSimulationRequester;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.api.function.CachedSupplier"): typeof Internal.CachedSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_bogeys.blocks.standard.medium.Medium202TrailingBogeyBlock"): typeof Internal.Medium202TrailingBogeyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.LingeringPotionItem"): typeof Internal.LingeringPotionItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.base.common.block.glass.FusedQuartzBlock"): typeof Internal.FusedQuartzBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageWrapper"): typeof Internal.MountedFluidStorageWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.AEBaseBlock"): typeof Internal.AEBaseBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.InkSacItem"): typeof Internal.InkSacItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.registry.registries.DeferredSupplier"): Internal.DeferredSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.ObjectList"): Internal.ObjectList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.spectator.SpectatorMenuCategory"): Internal.SpectatorMenuCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2DoubleFunction"): Internal.Double2DoubleFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.api.conduit.SlotType"): typeof Internal.SlotType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket"): typeof Internal.ServerboundRecipeBookSeenRecipePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.ForgeConfigSpec$IntValue"): typeof Internal.ForgeConfigSpec$IntValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.tools.powered.powersink.AEBasePoweredItem"): typeof Internal.AEBasePoweredItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BarrelBlockEntity"): typeof Internal.BarrelBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.ProjectileImpactEvent"): typeof Internal.ProjectileImpactEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.multistate.mutator.IGenerallyModifiableAreaMutator"): Internal.IGenerallyModifiableAreaMutator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.AnvilMenu"): typeof Internal.AnvilMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.ContraptionWorld"): typeof Internal.ContraptionWorld;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "codechicken.microblock.api.MicroMaterial"): typeof Internal.MicroMaterial;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest"): typeof Internal.PosRuleTest;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.Symbol"): Internal.Symbol;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.gigaherz.graph3.GraphObject"): Internal.GraphObject;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.DiskFeature"): typeof Internal.DiskFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.EnumMap"): typeof Internal.EnumMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer"): typeof Internal.LootPoolEntryContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin.AccessorBlockEntityType"): Internal.AccessorBlockEntityType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.Widget$DrawLayer"): typeof Internal.Widget$DrawLayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.contraption.ContraptionType"): typeof Internal.ContraptionType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.MenuProvider"): Internal.MenuProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.living.MobEffectEvent$Added"): typeof Internal.MobEffectEvent$Added;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.crafting.ISpecialRecipe"): Internal.ISpecialRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.connector.LargeConnectorBlockEntity"): typeof Internal.LargeConnectorBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SimpleFoiledItem"): typeof Internal.SimpleFoiledItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.KeyboardHandler"): typeof Internal.KeyboardHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tools.modifiers.traits.skull.SelfDestructiveModifier$SelfDestructiveEffect"): typeof Internal.SelfDestructiveModifier$SelfDestructiveEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.botanypots.data.recipes.potinteraction.BasicPotInteractionSerializer"): typeof Internal.BasicPotInteractionSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.DyeItem"): typeof Internal.DyeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.talrey.createdeco.blocks.CatwalkRailingBlock"): typeof Internal.CatwalkRailingBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liukrast.eg.api.logistics.ColoredFactoryPanelSupportBehaviour"): typeof Internal.ColoredFactoryPanelSupportBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.GoalSelectorDebugRenderer"): typeof Internal.GoalSelectorDebugRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Spliterator"): Internal.Spliterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.WoodVariantTrackBufferBlock"): typeof Internal.WoodVariantTrackBufferBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "traben.entity_model_features.models.IEMFModelNameContainer"): Internal.IEMFModelNameContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.anvil.AnvilUpgradeItem"): typeof Internal.AnvilUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.base.common.block.glass.GlassCollisionPredicate"): typeof Internal.GlassCollisionPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.LevelChunk"): typeof Internal.LevelChunk;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.effect.MobEffectInstance$FactorData"): typeof Internal.MobEffectInstance$FactorData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.loot.ConditionContainer"): Internal.ConditionContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap"): typeof Internal.Object2IntLinkedOpenHashMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.impl.ItemPropertiesExtensionImpl"): Internal.ItemPropertiesExtensionImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.MapItem"): typeof Internal.MapItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.Int2DoubleFunction"): Internal.Int2DoubleFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.mod.wrapper.AABBWrapper"): AABB;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.tool.EssenceFishingRodItem"): typeof Internal.EssenceFishingRodItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "codechicken.multipart.api.part.BaseMultipart"): typeof Internal.BaseMultipart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.block.EntityBlockActive4Way"): typeof Internal.EntityBlockActive4Way;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.blockinformation.IBlockInformation"): Internal.IBlockInformation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.material.LightShader"): Internal.LightShader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.Structure$StructureSettings"): typeof Internal.Structure$StructureSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.RotationAxis"): typeof RotationAxis;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.horse.Llama"): typeof Internal.Llama;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.fluids.pump.PumpBlock"): typeof Internal.PumpBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.linkedtransmitter.LinkedTransmitterItem"): typeof Internal.LinkedTransmitterItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.particles.ParticleOptions$Deserializer"): Internal.ParticleOptions$Deserializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.DripstoneClusterFeature"): typeof Internal.DripstoneClusterFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.village.VillagerTradesEvent"): typeof Internal.VillagerTradesEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.copycat.fence.WrappedFenceBlock"): typeof Internal.WrappedFenceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.CarvingMask$Mask"): Internal.CarvingMask$Mask;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.model.ItemTransforms"): typeof Internal.ItemTransforms;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.pickup.PickupUpgradeWrapper"): typeof Internal.PickupUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DragSourceDragEvent"): typeof Internal.DragSourceDragEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.StemBlock"): typeof Internal.StemBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.JobAttributes$MultipleDocumentHandlingType"): typeof Internal.JobAttributes$MultipleDocumentHandlingType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.crn.data.train.ScheduleSection"): typeof Internal.ScheduleSection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.CommandBlockEntity"): typeof Internal.CommandBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrbysco.neoauth.mixin.SplashTextResourceSupplierAccessor"): Internal.SplashTextResourceSupplierAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.ColorConfig"): typeof Internal.ColorConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.api.data.recipes.RecipeBase"): typeof Internal.RecipeBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.fluid.RedstoneFluid$FluidBlock"): typeof Internal.RedstoneFluid$FluidBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes$ChuteType"): typeof Internal.AllArmInteractionPointTypes$ChuteType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.integration.forge.jei.AddJEIEventJS"): typeof Internal.AddJEIEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.api.registry.RegistryObject"): typeof net.darkhax.bookshelf.api.registry.RegistryObject;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.track.TrackMaterial"): typeof Internal.TrackMaterial;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.tool.CardboardSwordItem"): typeof Internal.CardboardSwordItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.Camera"): typeof Internal.Camera;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer$Builder"): typeof Internal.LootPoolEntryContainer$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.ClientLevelKJS"): Internal.ClientLevelKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.SlotAccess"): Internal.SlotAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.LinkedHashSet"): typeof Internal.LinkedHashSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.horse.Mule"): typeof Internal.Mule;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.filter.FilterItemStack"): typeof Internal.FilterItemStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.repository.Pack$Position"): typeof Internal.Pack$Position;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ClientChatEvent"): typeof Internal.ClientChatEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BlockEntityTicker"): Internal.BlockEntityTicker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket"): typeof Internal.ClientboundPlayerCombatKillPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.ThrownExperienceBottle"): typeof Internal.ThrownExperienceBottle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket"): typeof Internal.ServerboundAcceptTeleportationPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.schema.minecraft.ShapelessRecipeSchema$ShapelessRecipeJS"): typeof Internal.ShapelessRecipeSchema$ShapelessRecipeJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderType"): typeof Internal.RenderType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.crn.data.train.portable.StationDisplayData"): typeof Internal.StationDisplayData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.WrappedJS"): Internal.WrappedJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.tables.block.ChestBlock"): typeof slimeknights.tconstruct.tables.block.ChestBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.phys.shapes.DiscreteVoxelShape$IntLineConsumer"): Internal.DiscreteVoxelShape$IntLineConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.ReflectionAccessFilter"): Internal.ReflectionAccessFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibContainer"): Internal.IDragonLibContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.block.EnderAirBlock"): typeof Internal.EnderAirBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings"): typeof Internal.StructurePlaceSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.registries.MissingMappingsEvent$Mapping"): typeof Internal.MissingMappingsEvent$Mapping;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.IGridServiceProvider"): Internal.IGridServiceProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.entity.BlockEntityJS"): typeof Internal.BlockEntityJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.foundationgames.automobility.util.SimpleMapContentRegistry"): typeof Internal.SimpleMapContentRegistry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.LongPredicate"): it.unimi.dsi.fastutil.longs.LongPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.item.filter.attribute.attributes.InItemGroupAttribute$Type"): typeof Internal.InItemGroupAttribute$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.SimpleCookingSerializer"): typeof Internal.SimpleCookingSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.telemetry.TelemetryPropertyMap"): typeof Internal.TelemetryPropertyMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.bell.PeculiarBellBlockEntity"): typeof Internal.PeculiarBellBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.base.AbstractEncasedShaftBlock"): typeof Internal.AbstractEncasedShaftBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blending.Blender"): typeof Internal.Blender;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.spatial.ISpatialService"): Internal.ISpatialService;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.EntityPositionSource"): typeof Internal.EntityPositionSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.MenuShortcut"): typeof Internal.MenuShortcut;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ru.zznty.create_factory_abstractions.api.generic.key.GenericKey"): Internal.GenericKey;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.hooks.AEToolItem"): Internal.AEToolItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Component"): typeof Internal.Component;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.StreamTagVisitor$EntryResult"): typeof Internal.StreamTagVisitor$EntryResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.BlockState"): typeof Internal.BlockState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.FarmlandTrampledEventJS"): typeof Internal.FarmlandTrampledEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.piston.MovingPistonBlock"): typeof Internal.MovingPistonBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.PackType"): typeof Internal.PackType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.data.CreateRegistrate$1"): typeof Internal.CreateRegistrate$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntitySlave"): typeof Internal.BlockEntitySlave;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.FrameTimer"): typeof Internal.FrameTimer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liukrast.eg.api.util.IFPExtra"): Internal.IFPExtra;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.base.KineticBlock"): typeof Internal.KineticBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.RegularImmutableList"): typeof Internal.RegularImmutableList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.ITickTimer"): Internal.ITickTimer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.LongArrayTag"): typeof Internal.LongArrayTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.HeightmapPlacement"): typeof Internal.HeightmapPlacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.FireworkRocketEntity"): typeof Internal.FireworkRocketEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SnowLayerBlock"): typeof Internal.SnowLayerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.registries.MissingMappingsEvent"): typeof Internal.MissingMappingsEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.chaincogwheel.ChainCogwheelBlock"): typeof Internal.ChainCogwheelBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.SculkShriekerBlockEntity"): typeof Internal.SculkShriekerBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType"): typeof Internal.UpgradeRenderDataType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.tableCloth.TableClothBlockItem"): typeof Internal.TableClothBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.oierbravo.createmechanicalextruder.components.extruder.ExtruderBlockEntity"): typeof Internal.ExtruderBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.horse.SkeletonHorse"): typeof Internal.SkeletonHorse;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.CustomNameData"): typeof Internal.CustomNameData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.blockentity.misc.LightDetectorBlockEntity"): typeof Internal.LightDetectorBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.logging.slf4j.Log4jLogger"): typeof Internal.Log4jLogger;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.ZoneId"): typeof Internal.ZoneId;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.FishingSpeedEnchantment"): typeof Internal.FishingSpeedEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.FocusTraversalPolicy"): typeof Internal.FocusTraversalPolicy;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blending.Blender$BlendingOutput"): typeof Internal.Blender$BlendingOutput;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.data.recipes.RecipeBuilder"): Internal.RecipeBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix4dc"): Internal.Matrix4dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.enchantment.MysticalEnlightenmentEnchantment"): typeof Internal.MysticalEnlightenmentEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.level.TicketType"): typeof Internal.TicketType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration"): typeof Internal.HugeMushroomFeatureConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.logging.log4j.util.StringBuilderFormattable"): Internal.StringBuilderFormattable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.fluids.capability.templates.FluidTank"): typeof Internal.FluidTank;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.blockentity.spatial.SpatialIOPortBlockEntity"): typeof Internal.SpatialIOPortBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.lighting.ChunkSkyLightSources"): typeof Internal.ChunkSkyLightSources;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.TextureStitchEvent"): typeof Internal.TextureStitchEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.entries.SequentialEntry$Builder"): typeof Internal.SequentialEntry$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WallSkullBlock"): typeof Internal.WallSkullBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.events.GuiEventListener"): Internal.GuiEventListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.CreativeModeTab$Type"): typeof Internal.CreativeModeTab$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.ShortBidirectionalIterator"): Internal.ShortBidirectionalIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote"): typeof Internal.ItemUpgradeRemote;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator"): it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.freewheelclutch.FreewheelClutchBlock"): typeof Internal.FreewheelClutchBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin.AccessorPortableStorageInterfaceBlockEntity"): Internal.AccessorPortableStorageInterfaceBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.util.client.PositionedIngredient"): typeof Internal.PositionedIngredient;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.crn.util.PenaltyResult"): typeof Internal.PenaltyResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.ILimited"): Internal.ILimited;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.DataSenderKJS"): Internal.DataSenderKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory"): Internal.ISettingsCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.tableCloth.ShoppingListItem"): typeof Internal.ShoppingListItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.texture.TextureManager"): typeof Internal.TextureManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.SubtitleOverlay"): typeof Internal.SubtitleOverlay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.fluids.pipes.SmartFluidPipeBlock"): typeof Internal.SmartFluidPipeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.UseOnContextAccessor"): Internal.UseOnContextAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.base.common.recipe.GrindingBallRecipe$Serializer"): typeof Internal.GrindingBallRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.IMagnetPreventionChecker"): Internal.IMagnetPreventionChecker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.command.CommandRegistryEventJS"): typeof Internal.CommandRegistryEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.CrossbowItem"): typeof Internal.CrossbowItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration"): typeof Internal.OreConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.ExplosionDamageCalculator"): typeof Internal.ExplosionDamageCalculator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.ItemInHandRenderer"): typeof Internal.ItemInHandRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositUpgradeItem"): typeof Internal.DepositUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.system.Struct"): typeof Internal.Struct;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ResourceOrTagArgument$Info"): typeof Internal.ResourceOrTagArgument$Info;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.machines.common.blockentity.multienergy.ICapacityTier"): Internal.ICapacityTier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.iris.texture.pbr.TextureAtlasExtension"): Internal.TextureAtlasExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.FluidComponents$2"): typeof Internal.FluidComponents$2;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider"): Internal.BlockEntityRendererProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.players.ServerOpListEntry"): typeof Internal.ServerOpListEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.GraphicsConfigTemplate"): typeof Internal.GraphicsConfigTemplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "create_more_additions.block.SilverOreBlock"): typeof Internal.SilverOreBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundInteractPacket$Handler"): Internal.ServerboundInteractPacket$Handler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.tutorial.TutorialStepInstance"): Internal.TutorialStepInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.crafting.PushDirection"): typeof Internal.PushDirection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.glodblock.github.extendedae.recipe.util.MachineRecipe"): com.glodblock.github.extendedae.recipe.util.MachineRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.SweepingEdgeEnchantment"): typeof Internal.SweepingEdgeEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "fuzs.puzzleslib.mixin.accessor.AbstractContainerMenuAccessor"): Internal.AbstractContainerMenuAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.WorldStem"): typeof Internal.WorldStem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.gui.NavigatableSimiScreen"): typeof Internal.NavigatableSimiScreen;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.IntOpenHashSet"): typeof Internal.IntOpenHashSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.ShortPredicate"): Internal.ShortPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.LongToIntFunction"): Internal.LongToIntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.foundationgames.automobility.util.duck.CollisionArea"): Internal.CollisionArea;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.FeaturePlaceContext"): typeof Internal.FeaturePlaceContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$TextDisplay$LineSplitter"): Internal.Display$TextDisplay$LineSplitter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.TickEvent$PlayerTickEvent"): typeof Internal.TickEvent$PlayerTickEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.RedstoneSide"): typeof Internal.RedstoneSide;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_bogeys.blocks.standard.large.LargeCreateStyle0120BogeyBlock"): typeof Internal.LargeCreateStyle0120BogeyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Zombie"): typeof Internal.Zombie;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.SkullModelBase"): typeof Internal.SkullModelBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix4x3dc"): Internal.Matrix4x3dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.station.GlobalStation"): typeof Internal.GlobalStation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.gui.AbstractSimiScreen"): typeof Internal.AbstractSimiScreen;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.SurfaceSystem"): typeof Internal.SurfaceSystem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.base.common.item.tool.ElectromagnetItem"): typeof Internal.ElectromagnetItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.WorldDimensions$Complete"): typeof Internal.WorldDimensions$Complete;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WetSpongeBlock"): typeof Internal.WetSpongeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.IFuelInventory"): Internal.IFuelInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.crafting.CraftingSubmitErrorCode"): typeof Internal.CraftingSubmitErrorCode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlockEntity"): typeof Internal.ModularAccumulatorBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.repository.PackCompatibility"): typeof Internal.PackCompatibility;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.telemetry.TelemetryEventSender"): Internal.TelemetryEventSender;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.energy.BaseElectricBlockEntity"): typeof Internal.BaseElectricBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.level.BlockEvent"): typeof Internal.BlockEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.yggdrasil.ServicesKeyType"): typeof Internal.ServicesKeyType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$TextDisplay$CachedInfo"): typeof Internal.Display$TextDisplay$CachedInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.ScheduledEvents"): typeof Internal.ScheduledEvents;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.spectator.SpectatorMenuListener"): Internal.SpectatorMenuListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.scores.Team$Visibility"): typeof Internal.Team$Visibility;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.foundationgames.automobility.automobile.DisplayStat"): typeof Internal.DisplayStat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.bytes.Byte2CharFunction"): Internal.Byte2CharFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.MouseListener"): Internal.MouseListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.slf4j.Marker"): org.slf4j.Marker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity$State"): typeof Internal.SchematicannonBlockEntity$State;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.api.commands.args.SingletonArgumentInfo"): typeof net.darkhax.bookshelf.api.commands.args.SingletonArgumentInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ru.zznty.create_factory_abstractions.generic.support.GenericPackagerBlockEntity"): Internal.GenericPackagerBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.effect.MobEffectInstance"): typeof Internal.MobEffectInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.DetectorBlockEventJS"): typeof Internal.DetectorBlockEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.crn.data.CarriageData"): typeof Internal.CarriageData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.forsteri.createappliedkinetics.content.energyProvider.EnergyProviderBlockEntity"): typeof Internal.EnergyProviderBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.HorizontalDirectionalBlockBuilder"): typeof Internal.HorizontalDirectionalBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.goal.Goal"): typeof Internal.Goal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.vibrations.VibrationSystem$Data"): typeof Internal.VibrationSystem$Data;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.decoration.HangingEntity"): typeof Internal.HangingEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket"): typeof Internal.ClientboundContainerSetDataPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.smokestack.block.SmokeStackBlock$SmokeStackType"): typeof Internal.SmokeStackBlock$SmokeStackType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.glodblock.github.extendedae.common.tileentities.TileCircuitCutter"): typeof Internal.TileCircuitCutter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.OptionInstance$CycleableValueSet"): Internal.OptionInstance$CycleableValueSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.PrivilegedAction"): Internal.PrivilegedAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerEvent$PlayerRespawnEvent"): typeof Internal.PlayerEvent$PlayerRespawnEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.blay09.mods.balm.api.event.client.screen.ContainerScreenDrawEvent"): typeof Internal.ContainerScreenDrawEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.ExtraCodecs$LazyInitializedCodec"): typeof Internal.ExtraCodecs$LazyInitializedCodec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.inventoryaccessport.InventoryAccessPortBlock"): typeof Internal.InventoryAccessPortBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.types.Type$FieldNotFoundException"): typeof Internal.Type$FieldNotFoundException;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.control.MoveControl"): typeof Internal.MoveControl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.level.ExplosionEventJS"): typeof Internal.ExplosionEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.minecart.MinecartCouplingItem"): typeof Internal.MinecartCouplingItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket$Action"): typeof Internal.ServerboundSeenAdvancementsPacket$Action;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.BiomeGenerationSettings$PlainBuilder"): typeof Internal.BiomeGenerationSettings$PlainBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoublePredicate"): it.unimi.dsi.fastutil.doubles.DoublePredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.events.ContainerEventHandler"): Internal.ContainerEventHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "codechicken.lib.data.MCDataOutput"): Internal.MCDataOutput;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.runtime.IEditModeConfig"): Internal.IEditModeConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.platform.forge.ingredient.KubeJSIngredient"): typeof Internal.KubeJSIngredient;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Shearable"): Internal.Shearable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.item.documentation.IDocumentableItem"): Internal.IDocumentableItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.runtime.config.IJeiConfigValue"): Internal.IJeiConfigValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SupportType"): typeof Internal.SupportType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.Enchantment$Rarity"): typeof Internal.Enchantment$Rarity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.render.ContraptionMatrices"): typeof Internal.ContraptionMatrices;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeFluid"): Internal.IForgeFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.RenderingHints"): typeof Internal.RenderingHints;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector4dc"): Internal.Vector4dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.fluid.CombinedTankWrapper"): typeof Internal.CombinedTankWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.data.loadable.field.ConstantField"): typeof Internal.ConstantField;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.network.NetworkDirection"): typeof Internal.NetworkDirection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.machines.common.block.TravelAnchorBlock"): typeof Internal.TravelAnchorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement"): Internal.SpecialBlockItemRequirement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.realmsclient.dto.RealmsServer$WorldType"): typeof Internal.RealmsServer$WorldType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.event.EventResult"): typeof Internal.EventResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.block.EntityBlockActive"): typeof Internal.EntityBlockActive;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.copycatsplus.copycats.mixin.copycat.sliding_door.SlidingDoorBlockEntityAccessor"): Internal.SlidingDoorBlockEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.DiodeBlock"): typeof Internal.DiodeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.data.tags.IntrinsicHolderTagsProvider"): typeof Internal.IntrinsicHolderTagsProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.leclowndu93150.baguettelib.event.entity.CreativeFlightEvent"): typeof Internal.CreativeFlightEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.util.recipes.device.FisherBoost"): typeof Internal.FisherBoost;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.EntityTeleportEvent"): typeof Internal.EntityTeleportEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CandleBlock"): typeof Internal.CandleBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.semaphore.SemaphoreBlock"): typeof Internal.SemaphoreBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.EntityLeaveLevelEvent"): typeof Internal.EntityLeaveLevelEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler"): typeof Internal.SettingsHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.bindings.ItemWrapper"): Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.shared.item.CheeseBlockItem"): typeof Internal.CheeseBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.impl.registry.SimpleRegistryImpl$SingleImpl"): typeof Internal.SimpleRegistryImpl$SingleImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$RenderChunk$ChunkCompileTask"): typeof Internal.ChunkRenderDispatcher$RenderChunk$ChunkCompileTask;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.spatial.SpatialIOPortBlock"): typeof Internal.SpatialIOPortBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.block.EnderiumGlassBlock"): typeof Internal.EnderiumGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.kinds.K2"): Internal.K2;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.crafting.recipe.ShapelessTagRecipe$Serializer"): typeof Internal.ShapelessTagRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.util.LazyOptional"): typeof Internal.LazyOptional;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.multistate.accessor.IAreaAccessor"): Internal.IAreaAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.platform.InputConstants$Type"): typeof Internal.InputConstants$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.PlayerAdvancements"): typeof Internal.PlayerAdvancements;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.displayLink.LinkWithBulbBlockEntity"): typeof Internal.LinkWithBulbBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.item.SatchelItem"): typeof Internal.SatchelItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.illusivesoulworks.polymorph.mixin.core.AccessorAbstractFurnaceBlockEntity"): Internal.AccessorAbstractFurnaceBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.SignedMessageBody$Packed"): typeof Internal.SignedMessageBody$Packed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.ponder.mixin.client.accessor.BufferBuilderAccessor"): Internal.BufferBuilderAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.PalettedContainerRO$PackedData"): typeof Internal.PalettedContainerRO$PackedData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.LongIterator"): Internal.LongIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.event.forge.PopupMenuEvent$Layer"): typeof Internal.PopupMenuEvent$Layer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.LootTable"): typeof Internal.LootTable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$GenericInterpolator"): Internal.Display$GenericInterpolator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes$SmokingType"): typeof Internal.AllFanProcessingTypes$SmokingType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.DispenserBlockAccessor"): Internal.DispenserBlockAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector3i"): typeof Internal.Vector3i;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.server.ServerStoppedEvent"): typeof Internal.ServerStoppedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RenderTooltipEvent$Pre"): typeof Internal.RenderTooltipEvent$Pre;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.AttachedData"): typeof Internal.AttachedData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.item.withmode.IWithModeItem"): Internal.IWithModeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.runtime.IJeiKeyMapping"): Internal.IJeiKeyMapping;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.treedecorators.TrunkVineDecorator"): typeof Internal.TrunkVineDecorator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RenderLevelStageEvent"): typeof Internal.RenderLevelStageEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundClientCommandPacket"): typeof Internal.ServerboundClientCommandPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.model.generators.ModelFile$ExistingModelFile"): typeof Internal.ModelFile$ExistingModelFile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixBase"): typeof Internal.TileAssemblerMatrixBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration"): typeof Internal.HugeFungusConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.qnb.QuantumLinkChamberBlock"): typeof Internal.QuantumLinkChamberBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.item.withmode.group.IToolModeGroup"): Internal.IToolModeGroup;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BrushableBlockEntity"): typeof Internal.BrushableBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.Codec$ResultFunction"): Internal.Codec$ResultFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "create_more_additions.block.ElectrumWallBlock"): typeof Internal.ElectrumWallBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.armor.CardboardArmorItem"): typeof Internal.CardboardArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerInteractEvent$LeftClickBlock$Action"): typeof Internal.PlayerInteractEvent$LeftClickBlock$Action;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.bogey.StandardBogeyBlock"): typeof Internal.StandardBogeyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.copycatsplus.copycats.content.copycat.ladder.CopycatLadderBlock"): typeof Internal.CopycatLadderBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.effect.InstantenousMobEffect"): typeof Internal.InstantenousMobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.flag.FeatureFlagSet"): typeof Internal.FeatureFlagSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.item.AccessorItemCooldowns"): Internal.AccessorItemCooldowns;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.glodblock.github.extendedae.common.blocks.BlockExIOPort"): typeof Internal.BlockExIOPort;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mari_023.ae2wtlib.terminal.ItemWT"): typeof Internal.ItemWT;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbteams.api.property.PrivacyMode"): typeof Internal.PrivacyMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.ItemCraftedEventJS"): typeof Internal.ItemCraftedEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.model.ItemModelGenerator"): typeof Internal.ItemModelGenerator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$MouseScrolled"): typeof Internal.ScreenEvent$MouseScrolled;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.stats.Stat"): typeof Internal.Stat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers"): typeof Internal.BlockStandardDrawers;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.TargetBlock"): typeof Internal.TargetBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.realmsclient.dto.ValueObject"): typeof Internal.ValueObject;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderStateShard$OverlayStateShard"): typeof Internal.RenderStateShard$OverlayStateShard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.foundationgames.automobility.item.TooltipItem"): typeof Internal.TooltipItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.BanDetails"): typeof Internal.BanDetails;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.OptionalLong"): typeof Internal.OptionalLong;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.BaseCommandBlock"): typeof Internal.BaseCommandBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BigDripleafStemBlock"): typeof Internal.BigDripleafStemBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration"): typeof Internal.SpringConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.StairBlockBuilder"): typeof Internal.StairBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.ponder.api.element.ParrotElement"): ParrotElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.common.enchantment.EnchantmentCoFH"): typeof Internal.EnchantmentCoFH;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.shared.block.TableBlock"): typeof Internal.TableBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.LazyLoadedValue"): typeof Internal.LazyLoadedValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.BasicBlockJS$Builder"): typeof Internal.BasicBlockJS$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo$DisplayItem"): typeof Internal.RenderInfo$DisplayItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.MinecartTNT"): typeof Internal.MinecartTNT;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.armor.BaseArmorItem"): typeof com.simibubi.create.content.equipment.armor.BaseArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration"): typeof Internal.DripstoneClusterConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$MouseButtonPressed"): typeof Internal.ScreenEvent$MouseButtonPressed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.VertexFormat$IndexType"): typeof Internal.VertexFormat$IndexType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.material.ShapedMaterialRecipe$Serializer"): typeof Internal.ShapedMaterialRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.inventory.bit.IBitInventoryItemStack"): Internal.IBitInventoryItemStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.bytes.Byte2IntFunction"): Internal.Byte2IntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.level.FireworksJS$Shape"): typeof Internal.FireworksJS$Shape;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.CreativeModeTab$Row"): typeof Internal.CreativeModeTab$Row;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Polygon"): typeof Internal.Polygon;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Paint"): Internal.Paint;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.chars.Char2BooleanFunction"): Internal.Char2BooleanFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.item.filter.attribute.attributes.FluidContentsAttribute$Type"): typeof Internal.FluidContentsAttribute$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.random.RandomGenerator"): Internal.RandomGenerator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.DropExperienceBlock"): typeof Internal.DropExperienceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.util.filter.IFilter"): Internal.IFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.util.IWorldObject"): Internal.IWorldObject;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Vindicator"): typeof Internal.Vindicator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.eventbus.api.IEventListener"): Internal.IEventListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.dispenser.DefaultDispenseItemBehavior"): typeof Internal.DefaultDispenseItemBehavior;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.copycatsplus.copycats.content.copycat.slice.CopycatSliceBlock"): typeof Internal.CopycatSliceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.PaintingTextureManager"): typeof Internal.PaintingTextureManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.runtime.IEditModeConfig$HideMode"): typeof Internal.IEditModeConfig$HideMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.event.events.client.ClientCommandRegistrationEvent$ClientCommandSourceStack"): Internal.ClientCommandRegistrationEvent$ClientCommandSourceStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.clock.CuckooClockBlockEntity"): typeof Internal.CuckooClockBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.AccessibleBundle"): typeof Internal.AccessibleBundle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.level.ExplosionJS"): typeof Internal.ExplosionJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.lib.transform.Transform"): Internal.Transform;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.worldselection.WorldCreationUiState"): typeof Internal.WorldCreationUiState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.Heightmap"): typeof Internal.Heightmap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.TropicalFish"): typeof Internal.TropicalFish;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.Climate$TargetPoint"): typeof Internal.Climate$TargetPoint;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.api.crafting.ISoulExtractionRecipe"): Internal.ISoulExtractionRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.food.FoodData"): typeof Internal.FoodData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.GameEventListenerRegistry$ListenerVisitor"): Internal.GameEventListenerRegistry$ListenerVisitor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch"): typeof Internal.PrimaryMatch;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.TridentImpalerEnchantment"): typeof Internal.TridentImpalerEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.input.MouseButton"): typeof Internal.MouseButton;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.toasts.Toast$Visibility"): typeof Internal.Toast$Visibility;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Collections$UnmodifiableRandomAccessList"): typeof Internal.Collections$UnmodifiableRandomAccessList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.crn.data.TrainLine"): typeof Internal.TrainLine;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.entity.LivingEntityEventJS"): typeof Internal.LivingEntityEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.zone.ZoneRules"): typeof Internal.ZoneRules;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.MinecartFurnace"): typeof Internal.MinecartFurnace;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.effect.ShockedMobEffect"): typeof Internal.ShockedMobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.forgespi.language.IModInfo"): Internal.IModInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.DoubleSupplier"): Internal.DoubleSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest"): typeof Internal.RuleTest;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.model.geometry.IGeometryBakingContext"): Internal.IGeometryBakingContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.system.Struct$StructValidation"): Internal.Struct$StructValidation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.LocalDateTime"): typeof Internal.LocalDateTime;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.player.SimplePlayerEventJS"): typeof Internal.SimplePlayerEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.widgets.IScrollGridWidgetFactory"): Internal.IScrollGridWidgetFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler$Frequency"): typeof Internal.RedstoneLinkNetworkHandler$Frequency;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.copycat.CopycatBlock"): typeof Internal.CopycatBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour"): typeof Internal.InvManipulationBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.outliner.Outliner"): typeof Internal.Outliner;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.Climate$Sampler"): typeof Internal.Climate$Sampler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.ListConfig"): typeof Internal.ListConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.tags.TagLoader$EntryWithSource"): typeof Internal.TagLoader$EntryWithSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeLivingEntity"): Internal.IForgeLivingEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.copycatsplus.copycats.content.copycat.byte_panel.CopycatBytePanelBlock"): typeof Internal.CopycatBytePanelBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "toni.sodiumdynamiclights.accessor.WorldRendererAccessor"): toni.sodiumdynamiclights.accessor.WorldRendererAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.LastSeenMessages$Update"): typeof Internal.LastSeenMessages$Update;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ContainerScreenEvent$Render$Foreground"): typeof Internal.ContainerScreenEvent$Render$Foreground;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeWrapper"): typeof Internal.CookingUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.PowderSnowCauldronBlock"): typeof Internal.PowderSnowCauldronBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.TimeArgument"): typeof Internal.TimeArgument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.base.common.item.tool.SoulVialItem"): typeof Internal.SoulVialItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SmokerBlock"): typeof Internal.SmokerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.distant_signals.IOverridableSignal"): Internal.IOverridableSignal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.scores.Team$CollisionRule"): typeof Internal.Team$CollisionRule;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.SuspiciousStewRecipe"): typeof Internal.SuspiciousStewRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.recipe.modificationtable.ModificationTableRecipeSerializer"): typeof Internal.ModificationTableRecipeSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.geom.AffineTransform"): typeof Internal.AffineTransform;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.ForgeConfigSpec$EnumValue"): typeof Internal.ForgeConfigSpec$EnumValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.chainDrive.ChainGearshiftBlock"): typeof Internal.ChainGearshiftBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetObjectivePacket"): typeof Internal.ClientboundSetObjectivePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.renderable.RenderableImage"): Internal.RenderableImage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour"): typeof Internal.LogisticallyLinkedBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlock"): typeof Internal.TrackCouplerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.event.PipeCollisionEvent$Flow"): typeof Internal.PipeCollisionEvent$Flow;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.booleans.Boolean2LongFunction"): Internal.Boolean2LongFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundGameEventPacket$Type"): typeof Internal.ClientboundGameEventPacket$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.RecipeManager"): typeof Internal.RecipeManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.providers.DataGenContext"): typeof Internal.DataGenContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.speedController.SpeedControllerBlock"): typeof Internal.SpeedControllerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.PositionSourceType"): Internal.PositionSourceType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.WidgetLayout"): Internal.WidgetLayout;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap"): typeof Internal.Reference2ObjectOpenHashMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.inventory.MenuAccess"): Internal.MenuAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.IdMap"): Internal.IdMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket"): typeof Internal.ServerboundSeenAdvancementsPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.flag.FeatureElement"): Internal.FeatureElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerInteractEvent$EntityInteract"): typeof Internal.PlayerInteractEvent$EntityInteract;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.piston.PistonStructureResolver"): typeof Internal.PistonStructureResolver;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.transport.BeltInventory"): typeof Internal.BeltInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.parts.IPart"): Internal.IPart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbteams.api.property.TeamPropertyArgument"): typeof Internal.TeamPropertyArgument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.PathfinderMob"): typeof Internal.PathfinderMob;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.ClipBlockStateContext"): typeof Internal.ClipBlockStateContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.level.ServerPlayerGameMode"): typeof Internal.ServerPlayerGameMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner"): Internal.ClientTooltipPositioner;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.parts.IPartItem"): Internal.IPartItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.embeddedt.modernfix.duck.IProfilingServerFunctionManager"): Internal.IProfilingServerFunctionManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.block.FoliageType"): typeof Internal.FoliageType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.BiomeSpecialEffects"): typeof Internal.BiomeSpecialEffects;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure"): typeof Internal.BuriedTreasureStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.types.families.Algebra"): Internal.Algebra;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.fluidvessel.FluidVesselMountedStorage"): typeof Internal.FluidVesselMountedStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.fluidvessel.FluidVesselMountedStorageType"): typeof Internal.FluidVesselMountedStorageType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liukrast.eg.api.logistics.board.PanelBlockItem"): typeof Internal.PanelBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.MachineUpgradeItem"): typeof Internal.MachineUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.mcdragonlib.client.render.ICustomItemRenderer"): Internal.ICustomItemRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Finish"): typeof Internal.LivingEntityUseItemEvent$Finish;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.model.generators.VariantBlockStateBuilder$PartialBlockstate"): typeof Internal.VariantBlockStateBuilder$PartialBlockstate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.stream.Collector$Characteristics"): typeof Internal.Collector$Characteristics;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.debug.MeteoritePlacerItem"): typeof Internal.MeteoritePlacerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.ByteTag"): typeof Internal.ByteTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.fluids.item.ContainerFoodItem$FluidContainerFoodItem"): typeof Internal.ContainerFoodItem$FluidContainerFoodItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.GuiAccessor"): Internal.GuiAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.ShipwreckStructure"): typeof Internal.ShipwreckStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.track.TrackMaterial$TrackModelHolder"): typeof Internal.TrackMaterial$TrackModelHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.RaidDebugRenderer"): typeof Internal.RaidDebugRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.levelWrappers.WrappedLevel"): typeof Internal.WrappedLevel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.nbt.IToolContext"): Internal.IToolContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "immersive_paintings.item.ImmersiveGraffitiItem"): typeof Internal.ImmersiveGraffitiItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CocoaBlock"): typeof Internal.CocoaBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.util.ItemBase"): typeof Internal.ItemBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2FloatMap$Entry"): Internal.Object2FloatMap$Entry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.ingredient.IRecipeSlotView"): Internal.IRecipeSlotView;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.implementations.blockentities.IColorableBlockEntity"): Internal.IColorableBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.BlockStateBlockItemGroup$IStyle"): Internal.BlockStateBlockItemGroup$IStyle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.sequenced.SequencedAssemblyItem"): typeof Internal.SequencedAssemblyItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.foliageplacers.MegaJungleFoliagePlacer"): typeof Internal.MegaJungleFoliagePlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.Style"): typeof Internal.Style;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.loot.ChestLootEventJS"): typeof Internal.ChestLootEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.io.ConfigParser"): Internal.ConfigParser;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.TrackBufferBlock"): typeof Internal.TrackBufferBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.actors.harvester.HarvesterBlock"): typeof Internal.HarvesterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.HotbarManager"): typeof Internal.HotbarManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.LevelStorageSource$LevelCandidates"): typeof Internal.LevelStorageSource$LevelCandidates;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.IInWorldGridNodeHost"): Internal.IInWorldGridNodeHost;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.OptionInstance$ValueSet"): Internal.OptionInstance$ValueSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour"): typeof Internal.SmartFluidTankBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.fluid.SapFluid$1"): typeof Internal.SapFluid$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.util.ITintable"): Internal.ITintable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.PotionItem"): typeof Internal.PotionItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.providers.RegistrateGenericProvider$Generator"): Internal.RegistrateGenericProvider$Generator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2IntSortedMap"): Internal.Object2IntSortedMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.smeltery.block.controller.TinyMultiblockControllerBlock"): typeof Internal.TinyMultiblockControllerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.particle.ParticleProvider"): Internal.ParticleProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.level.LevelEvent$Load"): typeof Internal.LevelEvent$Load;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.RandomSelectorFeature"): typeof Internal.RandomSelectorFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.PlayerHeadBlock"): typeof Internal.PlayerHeadBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.DecoratedPotBlock"): typeof Internal.DecoratedPotBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.funnel.AbstractFunnelBlock"): typeof Internal.AbstractFunnelBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock"): typeof Internal.AbstractSimpleShaftBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.toolbox.ToolboxInventory"): typeof Internal.ToolboxInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2FloatFunction"): Internal.Object2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.bracket.BracketBlockItem"): typeof Internal.BracketBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.PinkPetalsBlock"): typeof Internal.PinkPetalsBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.CookingBookCategory"): typeof Internal.CookingBookCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.ShapedRecipe"): typeof Internal.ShapedRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RenderHighlightEvent"): typeof Internal.RenderHighlightEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.PlayerRideable"): Internal.PlayerRideable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.metadata.animation.AnimationMetadataSectionSerializer"): typeof Internal.AnimationMetadataSectionSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.copycat.verticalstep.CopycatVerticalStepBlock"): typeof Internal.CopycatVerticalStepBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlock"): typeof Internal.PackagerLinkBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder"): typeof Internal.StructurePiecesBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.generator.AssetJsonGenerator"): typeof Internal.AssetJsonGenerator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.IntProvider"): typeof Internal.IntProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.callbacks.AfterEntityFallenOnBlockCallbackJS"): typeof Internal.AfterEntityFallenOnBlockCallbackJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.ClientLevel$ClientLevelData"): typeof Internal.ClientLevel$ClientLevelData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.GameRules"): typeof Internal.GameRules;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.file.FileConfig"): Internal.FileConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.ShortList"): Internal.ShortList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.mcdragonlib.client.ITickable"): Internal.ITickable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.BlockItemBuilder"): typeof Internal.BlockItemBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "codechicken.multipart.block.BlockMultipart"): typeof Internal.BlockMultipart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.bracket.BracketBlock$BracketType"): typeof Internal.BracketBlock$BracketType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Shape"): Internal.Shape;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.tool.EssenceStaffItem"): typeof Internal.EssenceStaffItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.FormattedText"): Internal.FormattedText;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.report.AbuseReport"): typeof Internal.AbuseReport;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.registry.SimpleRegistry"): Internal.SimpleRegistry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.atomic.AtomicInteger"): typeof Internal.AtomicInteger;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.foundationgames.automobility.automobile.WheelBase"): typeof Internal.WheelBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ItemCooldowns"): typeof Internal.ItemCooldowns;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.treedecorators.CocoaDecorator"): typeof Internal.CocoaDecorator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.BookItem"): typeof Internal.BookItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.PlacementFilter"): typeof Internal.PlacementFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.inventories.InternalInventory"): Internal.InternalInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour"): typeof Internal.ScrollOptionBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "create_more_additions.item.ElectrumArmorItem"): typeof Internal.ElectrumArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.maxhenkel.gravestone.corelib.death.PlayerDeathEvent"): typeof Internal.PlayerDeathEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.chute.ChuteItem"): typeof Internal.ChuteItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.Products$P10"): typeof Internal.Products$P10;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.compat.computercraft.AbstractComputerBehaviour"): typeof Internal.AbstractComputerBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.registry.RegistryEventJS"): typeof Internal.RegistryEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Reference2ReferenceFunction"): Internal.Reference2ReferenceFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.multistate.accessor.world.IInWorldStateEntryInfo"): Internal.IInWorldStateEntryInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.LongTag"): typeof Internal.LongTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.recipe.charging.ChargingRecipe"): typeof Internal.ChargingRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.station.StationMarker"): typeof Internal.StationMarker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.players.BanListEntry"): typeof Internal.BanListEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Ocelot"): typeof Internal.Ocelot;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundSwingPacket"): typeof Internal.ServerboundSwingPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.level.ChunkEvent"): typeof Internal.ChunkEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.locks.ReadWriteLock"): Internal.ReadWriteLock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$MouseButtonPressed$Pre"): typeof Internal.ScreenEvent$MouseButtonPressed$Pre;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.ContainerEntity"): Internal.ContainerEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.base.Suppliers$NonSerializableMemoizingSupplier"): typeof Internal.Suppliers$NonSerializableMemoizingSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.events.AbstractContainerEventHandler"): typeof Internal.AbstractContainerEventHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CartographyTableBlock"): typeof Internal.CartographyTableBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.fluids.tank.BoilerData$BoilerFluidHandler"): typeof Internal.BoilerData$BoilerFluidHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.buffer.WoodVariantTrackBufferBlockEntity"): typeof Internal.WoodVariantTrackBufferBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.player.EntityArrayList"): typeof Internal.EntityArrayList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.Lazy"): typeof Internal.Lazy;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter"): Internal.VertexBufferWriter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.conduits.common.conduit.ConduitGraphObject"): typeof Internal.ConduitGraphObject;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.transmission.ClutchBlock"): typeof Internal.ClutchBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.ComponentPath"): Internal.ComponentPath;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.StringTag"): typeof Internal.StringTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.WateringCanItem"): typeof Internal.WateringCanItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.iris.texture.pbr.SpriteContentsExtension"): Internal.SpriteContentsExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RenderLivingEvent$Pre"): typeof Internal.RenderLivingEvent$Pre;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.StainedGlassPaneBlock"): typeof Internal.StainedGlassPaneBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.worldselection.WorldCreationUiState$SelectedGameMode"): typeof Internal.WorldCreationUiState$SelectedGameMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.report.ReportChatMessage"): typeof Internal.ReportChatMessage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour$OccupiedPredicate"): Internal.DirectBeltInputBehaviour$OccupiedPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyFilterAttribute"): typeof Internal.AlchemyFilterAttribute;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "codechicken.microblock.part.StandardMicroblockPart"): typeof Internal.StandardMicroblockPart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.IStrictSignalTrain"): Internal.IStrictSignalTrain;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.TemptingSensor"): typeof Internal.TemptingSensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.DeadBushBlock"): typeof Internal.DeadBushBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.TooltipFlag"): Internal.TooltipFlag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.item.tool.BaseAxeItem"): typeof Internal.BaseAxeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2ShortFunction"): Internal.Double2ShortFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.WardenEntitySensor"): typeof Internal.WardenEntitySensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour"): typeof Internal.FactoryPanelBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.blockentity.storage.SkyStoneTankBlockEntity"): typeof Internal.SkyStoneTankBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer"): typeof Internal.RecipeWrapperSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_bogeys.blocks.standard.DoubleAxleBogeyBlock"): typeof Internal.DoubleAxleBogeyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.data.recipes.RecipeProvider"): typeof Internal.RecipeProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.WrappedExecutable"): Internal.WrappedExecutable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.StateHolder"): typeof Internal.StateHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.copycat.MigratingCopycatBlock"): typeof Internal.MigratingCopycatBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.registrars.ModRecipeTypes$1"): typeof Internal.ModRecipeTypes$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.gui.element.ScreenElement"): Internal.ScreenElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.HopperBlock"): typeof Internal.HopperBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.attributes.AttributeModifier"): typeof Internal.AttributeModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.behaviors.GenericInternalInventory"): Internal.GenericInternalInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.chars.Char2FloatFunction"): Internal.Char2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket"): typeof Internal.ServerboundCommandSuggestionPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_tracks.monorail.MonorailTrackBlock"): typeof Internal.MonorailTrackBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.BaseAuthenticationService"): typeof Internal.BaseAuthenticationService;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgePackResources"): Internal.IForgePackResources;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.api.crop.CropTier"): typeof Internal.CropTier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.BundlePacket"): typeof Internal.BundlePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$ChunkTaskResult"): typeof Internal.ChunkRenderDispatcher$ChunkTaskResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.item.SlimeGrassSeedItem"): typeof Internal.SlimeGrassSeedItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.item.filter.attribute.attributes.BookCopyAttribute$Type"): typeof Internal.BookCopyAttribute$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.RecipeBookMenu"): typeof Internal.RecipeBookMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.base.common.recipe.FireCraftingRecipe$Serializer"): typeof Internal.FireCraftingRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity"): typeof Internal.StockTickerBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.mixin.features.textures.SpriteContentsInvoker"): Internal.SpriteContentsInvoker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.system.StructBuffer"): typeof Internal.StructBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.steamWhistle.WhistleBlock"): typeof Internal.WhistleBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.station.StationBlock"): typeof Internal.StationBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.ResultConsumer"): Internal.ResultConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.status.ServerStatus$Favicon"): typeof Internal.ServerStatus$Favicon;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.RepeatingPlacement"): typeof Internal.RepeatingPlacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.carver.CarverConfiguration"): typeof Internal.CarverConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhaseManager"): typeof Internal.EnderDragonPhaseManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeLevel"): Internal.IForgeLevel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.facade.FacadePart"): typeof Internal.FacadePart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.botanypots.data.recipes.soil.BasicSoilSerializer"): typeof Internal.BasicSoilSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.Int2LongFunction"): Internal.Int2LongFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase"): typeof Internal.UpgradeWrapperBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Reference2ObjectFunction"): Internal.Reference2ObjectFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.util.nullness.NonNullBiConsumer"): Internal.NonNullBiConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.IBufferBlockedTrain"): Internal.IBufferBlockedTrain;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock$Prudentium"): typeof Internal.EssenceFurnaceBlock$Prudentium;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.WidgetLayout$Horizontal"): typeof Internal.WidgetLayout$Horizontal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.fluidvessel.FluidVesselBlock$WindowType"): typeof Internal.FluidVesselBlock$WindowType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.ReplacementMatch"): Internal.ReplacementMatch;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.BlockComponent"): typeof Internal.BlockComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.decoration.LeashFenceKnotEntity"): typeof Internal.LeashFenceKnotEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundSignUpdatePacket"): typeof Internal.ServerboundSignUpdatePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.client.render.vertex.buffer.ExtendedBufferBuilder"): Internal.ExtendedBufferBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.builders.FluidBuilder$1"): typeof Internal.FluidBuilder$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.part.MaterialItem"): typeof Internal.MaterialItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.gantry.GantryShaftBlockEntity"): typeof Internal.GantryShaftBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.entity.TravellingPoint$ITurnListener"): Internal.TravellingPoint$ITurnListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.base.common.item.misc.LocationPrintoutItem"): typeof Internal.LocationPrintoutItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.displayLink.source.KineticStressDisplaySource"): typeof Internal.KineticStressDisplaySource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.WorldlyContainer"): Internal.WorldlyContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.FishingHook$FishHookState"): typeof Internal.FishingHook$FishHookState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.util.AECableType"): typeof Internal.AECableType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WoolCarpetBlock"): typeof Internal.WoolCarpetBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.ponder.api.scene.DebugInstructions"): Internal.DebugInstructions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.PageAttributes$MediaType"): typeof Internal.PageAttributes$MediaType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.glodblock.github.extendedae.common.blocks.BlockWirelessHub"): typeof Internal.BlockWirelessHub;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.capabilities.ICapabilitySerializable"): Internal.ICapabilitySerializable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.mounted.CartAssemblerBlock$CartAssemblerAction"): typeof Internal.CartAssemblerBlock$CartAssemblerAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation"): Internal.IHaveGoggleInformation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundTabListPacket"): typeof Internal.ClientboundTabListPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.TreeFertilizerItem"): typeof Internal.TreeFertilizerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.armortrim.TrimMaterial"): typeof Internal.TrimMaterial;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.embeddedt.embeddium.api.eventbus.EmbeddiumEvent"): typeof Internal.EmbeddiumEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.commons.lang3.mutable.MutableBoolean"): typeof Internal.MutableBoolean;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity"): typeof Internal.BaseBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.crypto.ExemptionMechanism"): typeof Internal.ExemptionMechanism;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.RandomBooleanFeatureConfiguration"): typeof Internal.RandomBooleanFeatureConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.nbt.StatsNBT"): typeof Internal.StatsNBT;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket"): typeof Internal.ClientboundSetChunkCacheRadiusPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.fluid.InputFluid"): Internal.InputFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.chars.Char2ShortFunction"): Internal.Char2ShortFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes$CampfireType"): typeof Internal.AllArmInteractionPointTypes$CampfireType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity"): typeof Internal.BasinOperatingBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.mod.util.MinecraftRemapper"): typeof Internal.MinecraftRemapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.RecipeType$1"): typeof Internal.RecipeType$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.crn.data.TrainExitSide"): typeof Internal.TrainExitSide;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.schedule.Activity"): typeof Internal.Activity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.lang.StringBuilder"): typeof Internal.StringBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.Minecart"): typeof Internal.Minecart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock$Imperium"): typeof Internal.EssenceFurnaceBlock$Imperium;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.AbstractButton"): typeof Internal.AbstractButton;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin.AccessorAbstractContraptionEntity"): Internal.AccessorAbstractContraptionEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.shaders.FogShape"): typeof Internal.FogShape;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour$TankSegment"): typeof Internal.SmartFluidTankBehaviour$TankSegment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.base.common.item.capacitors.BaseCapacitorItem"): typeof Internal.BaseCapacitorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.render.SpriteShiftEntry"): typeof Internal.SpriteShiftEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.BossEvent"): typeof Internal.BossEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.WritableLevelData"): Internal.WritableLevelData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.particles.ParticleOptions"): Internal.ParticleOptions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.displayLink.source.PercentOrProgressBarDisplaySource"): typeof Internal.PercentOrProgressBarDisplaySource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.sequenced.IAssemblyRecipe"): Internal.IAssemblyRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour"): typeof Internal.BlockEntityBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.tool.EssenceHoeItem"): typeof Internal.EssenceHoeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.recipe.IFocusFactory"): Internal.IFocusFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.server.permission.events.PermissionGatherEvent"): typeof Internal.PermissionGatherEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.ContainerListener"): net.minecraft.world.ContainerListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundResourcePackPacket$Action"): typeof Internal.ServerboundResourcePackPacket$Action;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.model.ItemOverrides"): typeof Internal.ItemOverrides;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.carver.CarverDebugSettings"): typeof Internal.CarverDebugSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.MagmaCube"): typeof Internal.MagmaCube;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.VolatileImage"): typeof Internal.VolatileImage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.MobSpawnSettings$SpawnerData"): typeof Internal.MobSpawnSettings$SpawnerData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.BossEvent$BossBarColor"): typeof Internal.BossEvent$BossBarColor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.pathing.IPathingService"): Internal.IPathingService;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.me.cluster.implementations.QuantumCluster"): typeof Internal.QuantumCluster;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProvider"): Internal.ScoreboardNameProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator"): typeof Internal.AttachedToLeavesDecorator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.rolling_mill.RollingMillBlockEntity"): typeof Internal.RollingMillBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Silverfish"): typeof Internal.Silverfish;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tterrag.registrate.builders.BuilderCallback"): Internal.BuilderCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.visual.TickableVisual"): Internal.TickableVisual;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.shared.block.OrientableBlock"): typeof Internal.OrientableBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.LegacyRandomSource"): typeof Internal.LegacyRandomSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.Accessible"): Internal.Accessible;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapperAccessor"): Internal.IUpgradeWrapperAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.tools.quartz.QuartzCuttingKnifeItem"): typeof Internal.QuartzCuttingKnifeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Collections$UnmodifiableCollection"): typeof Internal.Collections$UnmodifiableCollection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.steamWhistle.WhistleExtenderBlock$WhistleExtenderShape"): typeof Internal.WhistleExtenderBlock$WhistleExtenderShape;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.HangingRootsBlock"): typeof Internal.HangingRootsBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.IntPredicate"): Internal.IntPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.level.BlockEvent$EntityPlaceEvent"): typeof Internal.BlockEvent$EntityPlaceEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorRoutingTable$RoutingTableEntry"): typeof Internal.ChainConveyorRoutingTable$RoutingTableEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.RodBlock"): typeof Internal.RodBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.ponder.api.ParticleEmitter"): Internal.ParticleEmitter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.smeltery.block.CastingBasinBlock"): typeof Internal.CastingBasinBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.entity.player.PlayerRenderer"): typeof Internal.PlayerRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.util.Pair"): typeof com.mojang.datafixers.util.Pair;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.storage.cells.ICellWorkbenchItem"): Internal.ICellWorkbenchItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.text.NumberFormat$Style"): typeof Internal.NumberFormat$Style;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.palettes.ConnectedGlassBlock"): typeof Internal.ConnectedGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.batchedentityrendering.impl.BlendingStateHolder"): Internal.BlendingStateHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.builder.LiteralArgumentBuilder"): typeof Internal.LiteralArgumentBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.itemHatch.ItemHatchBlockEntity"): typeof Internal.ItemHatchBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType"): typeof Internal.Dynamic2CommandExceptionType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$Render"): typeof Internal.ScreenEvent$Render;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.botanypots.data.displaystate.DisplayState"): typeof Internal.DisplayState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "at.ridgo8.moreoverlays.api.lightoverlay.ILightScanner"): Internal.ILightScanner;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.machines.common.recipe.PaintingRecipe"): typeof Internal.PaintingRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2ShortFunction"): Internal.Object2ShortFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$KeyPressed"): typeof Internal.ScreenEvent$KeyPressed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Spliterator$OfPrimitive"): Internal.Spliterator$OfPrimitive;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.JsonDeserializationContext"): Internal.JsonDeserializationContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.sounds.TickableSoundInstance"): Internal.TickableSoundInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.boss.enderdragon.phases.DragonStrafePlayerPhase"): typeof Internal.DragonStrafePlayerPhase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin.AccessorCarriage"): Internal.AccessorCarriage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.floats.Float2LongFunction"): Internal.Float2LongFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement"): typeof Internal.RandomSpreadStructurePlacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.model.ModelBakery"): typeof Internal.ModelBakery;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SoulFireBlock"): typeof Internal.SoulFireBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.Screen$DeferredTooltipRendering"): typeof Internal.Screen$DeferredTooltipRendering;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.DamageEnchantment"): typeof Internal.DamageEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.qnb.QuantumBaseBlock"): typeof Internal.QuantumBaseBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.BoatItem"): typeof Internal.BoatItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin.client.AccessorEntity"): Internal.AccessorEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.mixin.features.textures.animations.upload.SpriteContentsAnimationAccessor"): me.jellysquid.mods.sodium.mixin.features.textures.animations.upload.SpriteContentsAnimationAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.HumanoidArm"): typeof Internal.HumanoidArm;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.DebugInfoEventJS"): typeof Internal.DebugInfoEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.extendedae_plus.content.controller.NetworkPatternControllerBlock"): typeof Internal.NetworkPatternControllerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.CursorType"): typeof Internal.CursorType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.base.common.item.tool.ColdFireIgniter"): typeof Internal.ColdFireIgniter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.GolemSensor"): typeof Internal.GolemSensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.WorldgenRandom$Algorithm"): typeof Internal.WorldgenRandom$Algorithm;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin.AccessorCarriageContraptionEntity"): Internal.AccessorCarriageContraptionEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.PageAttributes"): typeof Internal.PageAttributes;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.RecipeKJS"): Internal.RecipeKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.DoubleUnaryOperator"): Internal.DoubleUnaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "create_more_additions.item.ElectrumArmorItem$Chestplate"): typeof Internal.ElectrumArmorItem$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbteams.data.TeamArgument"): typeof Internal.TeamArgument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket"): typeof Internal.ClientboundBlockEntityDataPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.IGridService"): Internal.IGridService;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.LevelRendererAccessor"): com.simibubi.create.foundation.mixin.accessor.LevelRendererAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.inventories.ISegmentedInventory"): Internal.ISegmentedInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory"): Internal.TypeWrapperFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liukrast.eg.content.logistics.FactoryPanelDisplayTarget"): typeof Internal.FactoryPanelDisplayTarget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.model.generators.BlockStateProvider$ConfiguredModelList"): typeof Internal.BlockStateProvider$ConfiguredModelList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.fluids.pipes.SmartFluidPipeBlockEntity"): typeof Internal.SmartFluidPipeBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ArmorMaterial"): Internal.ArmorMaterial;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.control.Control"): Internal.Control;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeAbstractMinecart"): Internal.IForgeAbstractMinecart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.tags.TagNetworkSerialization$NetworkPayload"): typeof Internal.TagNetworkSerialization$NetworkPayload;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.fluid.HoneyFluid$1"): typeof Internal.HoneyFluid$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.CommandBuildContext"): Internal.CommandBuildContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ru.zznty.create_factory_logistics.logistics.networkLink.NetworkLinkQualificationRecipe$Serializer"): typeof Internal.NetworkLinkQualificationRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity"): typeof Internal.PortableStorageInterfaceBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.machines.common.recipe.SagMillingRecipe$Container"): typeof Internal.SagMillingRecipe$Container;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.AgeableListModel"): typeof Internal.AgeableListModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.helpers.patternprovider.PatternContainer"): Internal.PatternContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.contraption.storage.item.simple.SimpleMountedStorageType"): typeof Internal.SimpleMountedStorageType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.HierarchyEvent"): typeof Internal.HierarchyEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.JavaMembers$MethodInfo"): typeof Internal.JavaMembers$MethodInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.drawable.IDrawableAnimated$StartDirection"): typeof Internal.IDrawableAnimated$StartDirection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.Theme"): typeof Internal.Theme;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Phantom"): typeof Internal.Phantom;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.MobSpawnSettings$Builder"): typeof Internal.MobSpawnSettings$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.lib.transform.Scale"): Internal.Scale;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.Tristate"): typeof Internal.Tristate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.recipe.transfer.IRecipeTransferManager"): Internal.IRecipeTransferManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.WeepingVinesFeature"): typeof Internal.WeepingVinesFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.BooleanComponent"): typeof Internal.BooleanComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.dimension.end.EndDragonFight"): typeof Internal.EndDragonFight;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.JobAttributes$DefaultSelectionType"): typeof Internal.JobAttributes$DefaultSelectionType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.PriorityQueue"): typeof Internal.PriorityQueue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_bogeys.blocks.standard.large.LargeCreateStyle060BogeyBlock"): typeof Internal.LargeCreateStyle060BogeyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.forge.block.ForgeChiseledBlock"): typeof Internal.ForgeChiseledBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.SpawnPlacementRegisterEvent"): typeof Internal.SpawnPlacementRegisterEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.yggdrasil.request.AbuseReportRequest$ClientInfo"): typeof Internal.AbuseReportRequest$ClientInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.crn.block.AdvancedDisplayBlock"): typeof Internal.AdvancedDisplayBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "codechicken.lib.vec.Matrix4"): typeof Internal.Matrix4;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.MobEffectInstanceAccessor"): Internal.MobEffectInstanceAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.chrono.Chronology"): Internal.Chronology;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixGlass"): typeof Internal.TileAssemblerMatrixGlass;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.ItemKJS"): Internal.ItemKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.item.IAugmentableItem"): Internal.IAugmentableItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.machines.common.io.item.MachineInventoryLayout"): typeof Internal.MachineInventoryLayout;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.chat.ChatLog"): typeof Internal.ChatLog;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor"): typeof Internal.RuleProcessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.behaviour.dispenser.storage.DispenserMountedStorageType"): typeof Internal.DispenserMountedStorageType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.NopProcessor"): typeof Internal.NopProcessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.Delayed"): Internal.Delayed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.IMergeableBE"): Internal.IMergeableBE;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.random.WeightedEntry$IntrusiveBase"): typeof Internal.WeightedEntry$IntrusiveBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType"): typeof Internal.FoliagePlacerType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.booleans.Boolean2FloatFunction"): Internal.Boolean2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blamejared.controlling.mixin.AccessKeyMapping"): Internal.AccessKeyMapping;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.ColorModel"): typeof Internal.ColorModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.api.item.IEnergyContainerItem"): Internal.IEnergyContainerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Mob"): typeof Internal.Mob;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_tracks.generic_crossing.GenericCrossingBlockEntity"): typeof Internal.GenericCrossingBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.me.service.CraftingService"): typeof Internal.CraftingService;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.resources.ResourceLocation"): typeof ResourceLocation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_bogeys.special.monobogey.InvisibleMonoBogeyBlock"): typeof Internal.InvisibleMonoBogeyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.registries.IForgeRegistryInternal"): Internal.IForgeRegistryInternal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CrossCollisionBlock"): typeof Internal.CrossCollisionBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.LongUnaryOperator"): Internal.LongUnaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.heightproviders.UniformHeight"): typeof Internal.UniformHeight;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.ComponentKJS"): Internal.ComponentKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.brake.BrakeBlockEntity"): typeof Internal.BrakeBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Saddleable"): Internal.Saddleable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity$OperationMode"): typeof Internal.TrackCouplerBlockEntity$OperationMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.event.EventJS"): typeof Internal.EventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.village.poi.PoiRecord"): typeof Internal.PoiRecord;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.LongSummaryStatistics"): typeof Internal.LongSummaryStatistics;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.registry.RegistryCallback"): Internal.RegistryCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix4x3d"): typeof Internal.Matrix4x3d;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.FormattedCharSink"): Internal.FormattedCharSink;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.util.recipes.machine.InsolatorRecipe$Serializer"): typeof Internal.InsolatorRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.base.Predicate"): com.google.common.base.Predicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.MenuContainer"): Internal.MenuContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CaveVinesBlock"): typeof Internal.CaveVinesBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.OnDatapackSyncEvent"): typeof Internal.OnDatapackSyncEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.ponder.api.scene.PositionUtil"): Internal.PositionUtil;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.client.modifiers.ModifierModelManager$ModifierModelRegistrationEvent"): typeof Internal.ModifierModelManager$ModifierModelRegistrationEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.BlockPredicateFilter"): typeof Internal.BlockPredicateFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.SharedSuggestionProvider$ElementSuggestionType"): typeof Internal.SharedSuggestionProvider$ElementSuggestionType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap"): typeof Internal.Int2ObjectOpenHashMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.misc.CustomStatBuilder"): typeof Internal.CustomStatBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BaseCoralFanBlock"): typeof Internal.BaseCoralFanBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.client.particle.types.PointToPointParticleType"): typeof Internal.PointToPointParticleType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.spec.AlgorithmParameterSpec"): Internal.AlgorithmParameterSpec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.schema.DynamicRecipeComponent$Factory"): Internal.DynamicRecipeComponent$Factory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.pipeline.RenderTarget"): typeof Internal.RenderTarget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration"): typeof Internal.SpikeConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer$Inventory"): Internal.IMultiBlockEntityContainer$Inventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.gui.ModularGuiLine"): typeof Internal.ModularGuiLine;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.graph.TrackEdge"): typeof Internal.TrackEdge;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.WaterWalkerEnchantment"): typeof Internal.WaterWalkerEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RegisterRecipeBookCategoriesEvent"): typeof Internal.RegisterRecipeBookCategoriesEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.CrashReportCategory"): typeof Internal.CrashReportCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.MysticalEssenceItem"): typeof Internal.MysticalEssenceItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeConversion"): typeof Internal.ItemUpgradeConversion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.switches.forge.TrackSwitchBlockImpl"): typeof Internal.TrackSwitchBlockImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.impl.mixin.ModelPartAccessor"): Internal.ModelPartAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.machines.common.io.fluid.MachineFluidTank"): typeof Internal.MachineFluidTank;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix3x2dc"): Internal.Matrix3x2dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.AreaEffectCloud"): typeof Internal.AreaEffectCloud;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.registration.object.IdAwareObject"): Internal.IdAwareObject;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.IntBinaryOperator"): it.unimi.dsi.fastutil.ints.IntBinaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.storage.SpatialStorageCellItem"): typeof Internal.SpatialStorageCellItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.mcdragonlib.client.ber.RenderGraphics"): typeof Internal.RenderGraphics;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.fluids.fluids.SlimeFluid$Flowing"): typeof Internal.SlimeFluid$Flowing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.text.FieldPosition"): typeof Internal.FieldPosition;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.AbstractSkeleton"): typeof Internal.AbstractSkeleton;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.MobType"): typeof Internal.MobType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.linkedtransmitter.LinkedButtonBlock"): typeof Internal.LinkedButtonBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.chainDrive.ChainDriveBlock$Part"): typeof Internal.ChainDriveBlock$Part;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade"): Internal.IOverflowResponseUpgrade;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.ImmutableEnumMap"): typeof Internal.ImmutableEnumMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "codechicken.enderstorage.block.BlockEnderTank"): typeof Internal.BlockEnderTank;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.item.BlockItemCoFH"): typeof Internal.BlockItemCoFH;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.conduits.common.conduit.block.ConduitBlockEntity"): typeof com.enderio.conduits.common.conduit.block.ConduitBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.tunnel.BeltTunnelItem"): typeof Internal.BeltTunnelItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder$Chestplate"): typeof Internal.ArmorItemBuilder$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.AccessibleAction"): Internal.AccessibleAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.NyliumBlock"): typeof Internal.NyliumBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap"): typeof Internal.Object2ObjectOpenHashMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.recipe.category.IRecipeCategory"): Internal.IRecipeCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.content.custom_bogeys.blocks.standard.medium.MediumBogeyBlock"): typeof Internal.MediumBogeyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.copycatsplus.copycats.content.copycat.board.CopycatBoardBlock"): typeof Internal.CopycatBoardBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.gui.ModularGuiLineBuilder"): typeof Internal.ModularGuiLineBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.copycatsplus.copycats.CCBlockStateProperties$Side"): typeof Internal.CCBlockStateProperties$Side;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.contraption.storage.item.MountedItemStorage"): typeof Internal.MountedItemStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BedBlockEntity"): typeof Internal.BedBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.debug.ChunkLoaderBlock"): typeof Internal.ChunkLoaderBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.Lifecycle"): typeof Internal.Lifecycle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.effect.ShockingEffect"): typeof Internal.ShockingEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.InputEvent$MouseButton$Pre"): typeof Internal.InputEvent$MouseButton$Pre;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.LoomMenu"): typeof Internal.LoomMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.ui.SelectableResource"): Internal.SelectableResource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.forgespi.language.IModInfo$ModVersion"): Internal.IModInfo$ModVersion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.server.IntegratedServer"): typeof Internal.IntegratedServer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.ShulkerBullet"): typeof Internal.ShulkerBullet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.shared.item.TinkerBookItem"): typeof Internal.TinkerBookItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.chat.report.AbuseReportSender"): Internal.AbuseReportSender;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.brake.BrakeBlock"): typeof Internal.BrakeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.horse.TraderLlama"): typeof Internal.TraderLlama;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour$InsertionCallback"): Internal.DirectBeltInputBehaviour$InsertionCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.mantle.data.loadable.field.ContextKey"): typeof Internal.ContextKey;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.RecipeComponentBuilder"): typeof Internal.RecipeComponentBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.UniformInt"): typeof Internal.UniformInt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "codechicken.microblock.part.IMicroShrinkRender"): Internal.IMicroShrinkRender;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket"): typeof Internal.ClientboundContainerSetSlotPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.crafting.ICraftingService"): Internal.ICraftingService;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.graph.EdgeData"): typeof Internal.EdgeData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.Products$P14"): typeof Internal.Products$P14;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.display.IWaypointDisplay"): Internal.IWaypointDisplay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.AbstractMinecart$Type"): typeof Internal.AbstractMinecart$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.item.MagnifyingGlassItem"): typeof Internal.MagnifyingGlassItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.decoration.ItemFrame"): typeof Internal.ItemFrame;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ambient.AmbientCreature"): typeof Internal.AmbientCreature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Rectangle"): typeof Internal.Rectangle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.format.ResolverStyle"): typeof Internal.ResolverStyle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.BiomeManager$NoiseBiomeSource"): Internal.BiomeManager$NoiseBiomeSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.api.block.InventoryBlock"): typeof Internal.InventoryBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.worldgen.meteorite.MeteoriteStructure"): typeof Internal.MeteoriteStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.block.EntityBlock4Way"): typeof Internal.EntityBlock4Way;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.item.wireframe.IWireframeProvidingItem"): Internal.IWireframeProvidingItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.DensityFunctions$RangeChoice"): typeof Internal.DensityFunctions$RangeChoice;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.Instrument"): typeof Internal.Instrument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay"): Internal.ModifierLevelDisplay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.HolderLookup$Provider"): Internal.HolderLookup$Provider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock"): typeof Internal.PistonExtensionPoleBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.PlayerInfo"): typeof Internal.PlayerInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.copycat.board.CopycatBoxItem"): typeof Internal.CopycatBoxItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.stacks.AEKeyType"): typeof Internal.AEKeyType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.file.FileNotFoundAction"): Internal.FileNotFoundAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.BeeDebugRenderer$HiveInfo"): typeof Internal.BeeDebugRenderer$HiveInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.actors.roller.RollerBlock"): typeof Internal.RollerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Reference2FloatFunction"): Internal.Reference2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.fluids.potion.PotionFluid$BottleType"): typeof Internal.PotionFluid$BottleType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.schemas.Schema"): typeof Internal.Schema;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.lib.transform.PoseTransformStack"): typeof Internal.PoseTransformStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.items.tools.powered.ColorApplicatorItem"): typeof Internal.ColorApplicatorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.blockentity.misc.CondenserBlockEntity"): typeof Internal.CondenserBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.ConfigGroup"): typeof Internal.ConfigGroup;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.registry.menu.MenuRegistry$ScreenFactory"): Internal.MenuRegistry$ScreenFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.status.ServerStatus$Version"): typeof Internal.ServerStatus$Version;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.NetherWartBlock"): typeof Internal.NetherWartBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.font.glyphs.BakedGlyph"): typeof Internal.BakedGlyph;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.material.CutoutShader"): Internal.CutoutShader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.ponder.api.element.PonderSceneElement"): Internal.PonderSceneElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.navigation.ScreenDirection"): typeof Internal.ScreenDirection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.embeddedt.embeddium.model.EpsilonizableBlockElement"): Internal.EpsilonizableBlockElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.model.ModelBakery$BakedCacheKey"): typeof Internal.ModelBakery$BakedCacheKey;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Queue"): Internal.Queue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.SignableCommand$Argument"): typeof Internal.SignableCommand$Argument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.players.StoredUserEntry"): typeof Internal.StoredUserEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.data.TriState"): typeof Internal.TriState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.CatVariant"): typeof Internal.CatVariant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.AbstractChestBlock"): typeof Internal.AbstractChestBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ClientPlayerNetworkEvent$LoggingIn"): typeof Internal.ClientPlayerNetworkEvent$LoggingIn;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.ImmutableCollections$MapN"): typeof Internal.ImmutableCollections$MapN;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.AbstractGolem"): typeof Internal.AbstractGolem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.TropicalFish$Pattern"): typeof Internal.TropicalFish$Pattern;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.model.generators.ItemModelProvider"): typeof Internal.ItemModelProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.shaders.Shader"): Internal.Shader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.internal.Excluder"): typeof Internal.Excluder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.ConstProperties"): Internal.ConstProperties;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.init.ModFluids$1"): typeof Internal.ModFluids$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.crafting.MolecularAssemblerBlock"): typeof Internal.MolecularAssemblerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.PlayerDataStorage"): typeof Internal.PlayerDataStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.goal.GoalSelector"): typeof Internal.GoalSelector;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.IceSpikeFeature"): typeof Internal.IceSpikeFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundAwardStatsPacket"): typeof Internal.ClientboundAwardStatsPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.flywheel.FlywheelBlock"): typeof Internal.FlywheelBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BarrelBlock"): typeof Internal.BarrelBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.WritableBookItem"): typeof Internal.WritableBookItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.border.WorldBorder$Settings"): typeof Internal.WorldBorder$Settings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour$ProcessingCallback"): Internal.BeltProcessingBehaviour$ProcessingCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.EnderChestBlockEntity"): typeof Internal.EnderChestBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.data.BlockFamily"): typeof Internal.BlockFamily;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.copycatsplus.copycats.content.copycat.half_panel.CopycatHalfPanelBlock"): typeof Internal.CopycatHalfPanelBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.capabilities.ICapabilityProvider"): Internal.ICapabilityProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "top.theillusivec4.curios.api.type.capability.ICurioItem"): Internal.ICurioItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.DimensionSpecialEffects"): typeof Internal.DimensionSpecialEffects;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.codecs.UnboundedMapCodec"): typeof Internal.UnboundedMapCodec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.AccessibleStateSet"): typeof Internal.AccessibleStateSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.machines.common.recipe.MachineRecipe"): Internal.MachineRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.iris.mixin.texture.SpriteContentsTickerAccessor"): Internal.SpriteContentsTickerAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.spectator.SpectatorMenuItem"): Internal.SpectatorMenuItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.toolbox.ToolboxMountedStorageType"): typeof Internal.ToolboxMountedStorageType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.AxisAngle4d"): typeof Internal.AxisAngle4d;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.zapper.terrainzapper.PlacementOptions"): typeof Internal.PlacementOptions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.crn.block.blockentity.TrainStationClockBlockEntity"): typeof Internal.TrainStationClockBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.ConcurrentMap"): Internal.ConcurrentMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.LangEventJS$Key"): typeof Internal.LangEventJS$Key;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RenderTooltipEvent"): typeof Internal.RenderTooltipEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.boss.enderdragon.phases.DragonSittingScanningPhase"): typeof Internal.DragonSittingScanningPhase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Guardian"): typeof Internal.Guardian;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.narration.NarratableEntry"): Internal.NarratableEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.mixin.features.textures.animations.upload.SpriteContentsAnimationFrameAccessor"): Internal.SpriteContentsAnimationFrameAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.synchronization.brigadier.FloatArgumentInfo$Template"): typeof Internal.FloatArgumentInfo$Template;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.TextureStitchEvent$Post"): typeof Internal.TextureStitchEvent$Post;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.copycatsplus.copycats.content.copycat.button.CopycatButtonBlock"): typeof Internal.CopycatButtonBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.flashyreese.mods.sodiumextra.mixin.gui.MinecraftClientAccessor"): me.flashyreese.mods.sodiumextra.mixin.gui.MinecraftClientAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider"): typeof Internal.RandomizedIntStateProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.WorldOptions"): typeof Internal.WorldOptions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.BlockBlobFeature"): typeof Internal.BlockBlobFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.base.common.blockentity.IWrenchable"): com.enderio.base.common.blockentity.IWrenchable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundPlayerLookAtPacket"): typeof Internal.ClientboundPlayerLookAtPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.tools.helper.ModifierBuilder"): Internal.ModifierBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.MelonBlock"): typeof Internal.MelonBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.api.ContainerType"): typeof Internal.ContainerType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.gui.widget.Label"): typeof Internal.Label;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.common.fluid.FluidIngredient$IFluidList"): Internal.FluidIngredient$IFluidList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity"): typeof Internal.ThresholdSwitchBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liukrast.eg.content.item.DisplayCollectorBlockItem"): typeof Internal.DisplayCollectorBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.ObjectSortedSet"): Internal.ObjectSortedSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult"): typeof Internal.UpgradeSlotChangeResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaFacingSizedSlotted$Slots23"): typeof Internal.BlockMetaFacingSizedSlotted$Slots23;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity"): typeof Internal.BlazeBurnerBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Locale$IsoCountryCode"): typeof Internal.Locale$IsoCountryCode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.aizistral.nochatreports.common.core.ServerDataExtension"): Internal.ServerDataExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.library.recipe.ingredient.MaterialValueIngredient"): typeof Internal.MaterialValueIngredient;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.PoseStack"): typeof Internal.PoseStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "create_more_additions.block.ElectrumSlabBlock"): typeof Internal.ElectrumSlabBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.conduits.common.conduit.RightClickAction"): Internal.RightClickAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic$ObservableFilterItemStackHandler"): typeof Internal.FilterLogic$ObservableFilterItemStackHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2ObjectMap$Entry"): Internal.Object2ObjectMap$Entry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.block.DirtType"): typeof Internal.DirtType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.waterwheel.WaterWheelBlock"): typeof Internal.WaterWheelBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.Products$P4"): typeof Internal.Products$P4;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.implementations.blockentities.ICraftingMachine"): Internal.ICraftingMachine;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.api.IFluidHandlerWrapperUpgrade"): Internal.IFluidHandlerWrapperUpgrade;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.crafting.PatternProviderBlock"): typeof Internal.PatternProviderBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.LayeredCauldronBlock"): typeof Internal.LayeredCauldronBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.PlayLevelSoundEvent"): typeof Internal.PlayLevelSoundEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe"): Internal.IJeiAnvilRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance"): typeof Internal.AbstractCriterionTriggerInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.CardboardBlock"): typeof Internal.CardboardBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.instance.Instance"): Internal.Instance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.event.PipeCollisionEvent"): typeof Internal.PipeCollisionEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.IPreAssembleCallback"): Internal.IPreAssembleCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.implementations.blockentities.ICrankable"): Internal.ICrankable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "codechicken.microblock.util.MaskedCuboid"): typeof Internal.MaskedCuboid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.types.Type$Mu"): typeof Internal.Type$Mu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket"): typeof Internal.ClientboundCustomChatCompletionsPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity"): typeof Internal.SimpleKineticBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.InfestedRotatedPillarBlock"): typeof Internal.InfestedRotatedPillarBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.toolbox.ToolboxBlock"): typeof Internal.ToolboxBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.world.block.SlimeFungusBlock"): typeof Internal.SlimeFungusBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.client.render.effects.ParticleTypes$2"): typeof Internal.ParticleTypes$2;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.color.block.BlockColors"): typeof Internal.BlockColors;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.entity.ItemRenderer"): typeof Internal.ItemRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.crn.block.AdvancedDisplaySmallBlock"): typeof Internal.AdvancedDisplaySmallBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.synchronization.brigadier.IntegerArgumentInfo$Template"): typeof Internal.IntegerArgumentInfo$Template;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ResourceOrTagKeyArgument$Result"): Internal.ResourceOrTagKeyArgument$Result;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.foundationgames.automobility.automobile.AutomobileFrame$FrameModel"): typeof Internal.AutomobileFrame$FrameModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.DispenserBlockEntity"): typeof Internal.DispenserBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.LoomBlock"): typeof Internal.LoomBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.iris.vertices.BlockSensitiveBufferBuilder"): Internal.BlockSensitiveBufferBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.living.MobEffectEvent$Expired"): typeof Internal.MobEffectEvent$Expired;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "codechicken.lib.vec.Quat"): typeof Internal.Quat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.gigaherz.graph3.ContextDataFactory"): Internal.ContextDataFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.context.ParsedCommandNode"): typeof Internal.ParsedCommandNode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.steamWhistle.WhistleBlockEntity"): typeof Internal.WhistleBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.LevelRenderer"): typeof Internal.LevelRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.IScreenWrapper"): Internal.IScreenWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liukrast.eg.content.logistics.DisplayCollectorBlock"): typeof Internal.DisplayCollectorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaFacingSizedOpen$Open2"): typeof Internal.BlockMetaFacingSizedOpen$Open2;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$TextDisplay$Align"): typeof Internal.Display$TextDisplay$Align;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.storage.IOWorker"): typeof Internal.IOWorker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.Codec"): Internal.Codec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundResourcePackPacket"): typeof Internal.ServerboundResourcePackPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.SuspiciousStewItemAccessor"): Internal.SuspiciousStewItemAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.IntProviderType"): Internal.IntProviderType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.player.StackedContents"): typeof Internal.StackedContents;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.DaylightDetectorBlockEntity"): typeof Internal.DaylightDetectorBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.fluid.SmartFluidTank"): typeof Internal.SmartFluidTank;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.io.ConfigWriter"): Internal.ConfigWriter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.networking.IGrid"): Internal.IGrid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.suggestion.Suggestion"): typeof Internal.Suggestion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.level.gen.properties.AddLakeProperties"): typeof Internal.AddLakeProperties;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.BundlerInfo$Provider"): Internal.BundlerInfo$Provider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.Int2IntFunction"): Internal.Int2IntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundBlockEntityTagQuery"): typeof Internal.ServerboundBlockEntityTagQuery;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.materials.ExperienceNuggetItem"): typeof Internal.ExperienceNuggetItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.api.storage.cells.StorageCell"): Internal.StorageCell;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.ponder.foundation.element.PonderElementBase"): typeof Internal.PonderElementBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.FallingBlockEntityAccessor"): Internal.FallingBlockEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.navigation.FocusNavigationEvent$ArrowNavigation"): typeof Internal.FocusNavigationEvent$ArrowNavigation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.content.inventorybridge.InventoryBridgeBlockEntity"): typeof Internal.InventoryBridgeBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.glodblock.github.extendedae.recipe.util.MachineResult"): typeof Internal.MachineResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.maven.artifact.versioning.ArtifactVersion"): Internal.ArtifactVersion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier"): Internal.RuleBlockEntityModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.gui.element.RenderElement"): Internal.RenderElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "slimeknights.tconstruct.smeltery.item.DummyMaterialItem"): typeof Internal.DummyMaterialItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.GameEventListener$Holder"): Internal.GameEventListener$Holder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.VertexSorting"): Internal.VertexSorting;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.model.generators.ConfiguredModel$Builder"): typeof Internal.ConfiguredModel$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.FenceBlockBuilder"): typeof Internal.FenceBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.AxeItemBuilder"): typeof Internal.AxeItemBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.IRecipeLayoutDrawable"): Internal.IRecipeLayoutDrawable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.simpleRelays.AbstractShaftBlock"): typeof Internal.AbstractShaftBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BellBlock"): typeof Internal.BellBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.block.WitherproofBlock"): typeof Internal.WitherproofBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.mcdragonlib.client.gui.DLScreen"): typeof Internal.DLScreen;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.advancements.CriterionTriggerInstance"): Internal.CriterionTriggerInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.math.BlockFace"): typeof Internal.BlockFace;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.item.TagDependentIngredientItem"): typeof Internal.TagDependentIngredientItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity"): typeof Internal.WindmillBearingBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.NBTIOWrapper"): NBTIO;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.createmod.catnip.animation.LerpedFloat"): typeof Internal.LerpedFloat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.ExperienceCapsuleItem"): typeof Internal.ExperienceCapsuleItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.BufferBuilder$RenderedBuffer"): typeof Internal.BufferBuilder$RenderedBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.rolling_mill.RollingMillBlock"): typeof Internal.RollingMillBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities"): typeof Internal.NearestVisibleLivingEntities;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.floats.Float2ReferenceFunction"): Internal.Float2ReferenceFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.track.BezierConnection$Segment"): typeof Internal.BezierConnection$Segment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.foundationgames.automobility.automobile.attachment.rear.EmptyRearAttachment"): typeof Internal.EmptyRearAttachment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.networking.ControllerBlock"): typeof appeng.block.networking.ControllerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.irisshaders.batchedentityrendering.impl.MemoryTrackingBuffer"): Internal.MemoryTrackingBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.gauge.GaugeShaper"): typeof Internal.GaugeShaper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hlysine.create_connected.mixin.sequencedgearshift.AbstractSimiScreenAccessor"): Internal.AbstractSimiScreenAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.tree.CommandNode"): typeof Internal.CommandNode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.vibrations.VibrationSystem$Listener"): typeof Internal.VibrationSystem$Listener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.item.withmode.IRenderableMode"): Internal.IRenderableMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.measuring.MeasuringMode"): typeof Internal.MeasuringMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.repository.PackRepository"): typeof Internal.PackRepository;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.enderio.base.common.item.tool.CoordinateSelectorItem"): typeof Internal.CoordinateSelectorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.network.IObserveTileEntity"): Internal.IObserveTileEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.Minecraft$ChatStatus"): typeof Internal.Minecraft$ChatStatus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.handlers.IGuiClickableArea"): Internal.IGuiClickableArea;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.callbacks.CanBeReplacedCallbackJS"): typeof Internal.CanBeReplacedCallbackJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent"): Internal.ClientTooltipComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "appeng.block.misc.GrowthAcceleratorBlock"): typeof Internal.GrowthAcceleratorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup"): Internal.IDrawerGroup;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.NameMap"): typeof Internal.NameMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.ClientChunkCache$Storage"): typeof Internal.ClientChunkCache$Storage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoubleListIterator"): Internal.DoubleListIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.almostreliable.ponderjs.mixin.ParticleAccessor"): Internal.ParticleAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket"): typeof Internal.ClientboundSetEntityDataPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.Realms32BitWarningStatus"): typeof Internal.Realms32BitWarningStatus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.funnel.FunnelBlockEntity$Mode"): typeof Internal.FunnelBlockEntity$Mode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem"): typeof Internal.BackpackItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.ItemTooltipEventJS$StaticTooltipHandlerFromJS"): Internal.ItemTooltipEventJS$StaticTooltipHandlerFromJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.BiasedToBottomInt"): typeof Internal.BiasedToBottomInt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.util.Either$Right"): typeof Internal.Either$Right;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeConfig"): typeof Internal.AutoCookingUpgradeConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.DataLayer"): typeof Internal.DataLayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.mrjulsen.mcdragonlib.data.INBTSerializable"): de.mrjulsen.mcdragonlib.data.INBTSerializable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.entity.AccessorEntity"): net.darkhax.bookshelf.mixin.accessors.entity.AccessorEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.CompletionStage"): Internal.CompletionStage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.lang.Number"): typeof number;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.TurtleEggBlock"): typeof Internal.TurtleEggBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.impl.registry.SimpleRegistryImpl"): typeof Internal.SimpleRegistryImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "codechicken.lib.capability.CapabilityCache"): typeof Internal.CapabilityCache;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.world.AccessorRecipeManager"): Internal.AccessorRecipeManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo"): Internal.IStateEntryInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.engine_room.flywheel.api.visualization.EntityVisualizer"): Internal.EntityVisualizer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.tree.ArgumentCommandNode"): typeof Internal.ArgumentCommandNode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The 