/// <reference path="./internals/internal_*.d.ts" />
declare class BlockPos extends Vec3i {
    constructor(arg0: Vec3i_)
    constructor(arg0: number, arg1: number, arg2: number)
    south(): this;
    mutable(): Internal.BlockPos$MutableBlockPos;
    above(): this;
    offset(arg0: Vec3i_): this;
    getY(): number;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    static betweenClosed(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Iterable<BlockPos>;
    static getY(arg0: number): number;
    toShortString(): string;
    static betweenClosedStream(arg0: BlockPos_, arg1: BlockPos_): Internal.Stream<BlockPos>;
    notify(): void;
    static "betweenClosedStream(net.minecraft.world.level.levelgen.structure.BoundingBox)"(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    compareTo(arg0: any): number;
    multiply(arg0: number): this;
    relative(arg0: Internal.Direction_): Vec3i;
    static offset(arg0: number, arg1: number, arg2: number, arg3: number): number;
    asLong(): number;
    static spiralAround(arg0: BlockPos_, arg1: number, arg2: Internal.Direction_, arg3: Internal.Direction_): Internal.Iterable<Internal.BlockPos$MutableBlockPos>;
    west(arg0: number): this;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(arg0: number): Vec3i;
    south(arg0: number): this;
    "compareTo(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
    west(): Vec3i;
    static betweenClosedStream(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    static breadthFirstTraversal(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.BiConsumer_<BlockPos, Internal.Consumer<BlockPos>>, arg4: Internal.Predicate_<BlockPos>): number;
    static randomInCube(arg0: Internal.RandomSource_, arg1: number, arg2: BlockPos_, arg3: number): Internal.Iterable<BlockPos>;
    "relative(net.minecraft.core.Direction$Axis,int)"(arg0: Internal.Direction$Axis_, arg1: number): this;
    static betweenClosed(arg0: BlockPos_, arg1: BlockPos_): Internal.Iterable<BlockPos>;
    distSqr(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): Vec3i;
    static offset(arg0: number, arg1: Internal.Direction_): number;
    getCenter(): Vec3d;
    wait(): void;
    static containing(arg0: Internal.Position_): BlockPos;
    setY(arg0: number): Vec3i;
    east(arg0: number): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    north(): Vec3i;
    getClass(): typeof any;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    east(): this;
    static getX(arg0: number): number;
    below(): this;
    static getZ(arg0: number): number;
    static findClosestMatch(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.Predicate_<BlockPos>): Internal.Optional<BlockPos>;
    above(arg0: number): Vec3i;
    atY(arg0: number): this;
    wait(arg0: number, arg1: number): void;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    rotate(arg0: Internal.Rotation_): this;
    static "betweenClosedStream(net.minecraft.world.phys.AABB)"(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    static betweenClosedStream(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Stream<BlockPos>;
    getZ(): number;
    static randomBetweenClosed(arg0: Internal.RandomSource_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): Internal.Iterable<BlockPos>;
    static withinManhattanStream(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Stream<BlockPos>;
    offset(arg0: number, arg1: number, arg2: number): Vec3i;
    immutable(): this;
    toString(): string;
    north(arg0: number): Vec3i;
    static asLong(arg0: number, arg1: number, arg2: number): number;
    notifyAll(): void;
    distManhattan(arg0: Vec3i_): number;
    static getFlatIndex(arg0: number): number;
    static of(arg0: number): BlockPos;
    get(arg0: Internal.Direction$Axis_): number;
    cross(arg0: Vec3i_): Vec3i;
    /**
     * @deprecated
    */
    static squareOutSouthEast(arg0: BlockPos_): Internal.Stream<BlockPos>;
    static withinManhattan(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Iterable<BlockPos>;
    static containing(arg0: number, arg1: number, arg2: number): BlockPos;
    static betweenClosedStream(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    hashCode(): number;
    relative(arg0: Internal.Direction_, arg1: number): Vec3i;
    setZ(arg0: number): Vec3i;
    wait(arg0: number): void;
    relative(arg0: Internal.Direction$Axis_, arg1: number): this;
    compareTo(arg0: Vec3i_): number;
    setX(arg0: number): Vec3i;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    equals(arg0: any): boolean;
    "relative(net.minecraft.core.Direction,int)"(arg0: Internal.Direction_, arg1: number): Vec3i;
    get y(): number
    get center(): Vec3d
    set y(arg0: number)
    get class(): typeof any
    get x(): number
    get z(): number
    set z(arg0: number)
    set x(arg0: number)
    static readonly PACKED_Y_LENGTH: (12) & (number);
    static readonly CODEC: Internal.Codec<BlockPos>;
    static readonly ZERO: (BlockPos) & (BlockPos);
}
type BlockPos_ = Vec3d_ | [number, number, number] | BlockPos;
/**
 * Various block related helper functions
*/
declare class Block {
    constructor()
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static id(id: ResourceLocation_): Internal.BlockIDPredicate;
    static entity(id: ResourceLocation_): Internal.BlockEntityPredicate;
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    static getFacing(): Internal.Map<string, Internal.Direction>;
    /**
     * Gets a blocks id from the Block
    */
    static getId(block: Internal.Block_): ResourceLocation;
    notify(): void;
    static id(id: ResourceLocation_, properties: Internal.Map_<string, any>): Internal.BlockIDPredicate;
    wait(arg0: number, arg1: number): void;
    /**
     * Gets a list of all blocks with tags
    */
    static getTaggedIds(tag: ResourceLocation_): Internal.List<ResourceLocation>;
    hashCode(): number;
    /**
     * Gets a Block from a block id
    */
    static getBlock(id: ResourceLocation_): Internal.Block;
    wait(): void;
    wait(arg0: number): void;
    static custom(predicate: Internal.BlockPredicate_): Internal.BlockPredicate;
    /**
     * Gets a list of the classname of all registered blocks
    */
    static getTypeList(): Internal.List<string>;
    equals(arg0: any): boolean;
    get class(): typeof any
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    get facing(): Internal.Map<string, Internal.Direction>
    /**
     * Gets a list of the classname of all registered blocks
    */
    get typeList(): Internal.List<string>
}
type Block_ = Block;
declare class Vec3d implements Internal.Position {
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Vec3f_)
    lengthSqr(): number;
    distanceToSqr(arg0: Vec3d_): number;
    notify(): void;
    yRot(arg0: number): this;
    z(): number;
    xRot(arg0: number): this;
    align(arg0: Internal.EnumSet_<Internal.Direction$Axis>): this;
    x(): number;
    closerThan(arg0: Internal.Position_, arg1: number): boolean;
    static atLowerCornerWithOffset(arg0: Vec3i_, arg1: number, arg2: number, arg3: number): Vec3d;
    subtract(arg0: Vec3d_): this;
    static upFromBottomCenterOf(arg0: Vec3i_, arg1: number): Vec3d;
    reverse(): this;
    scale(arg0: number): this;
    wait(): void;
    length(): number;
    distanceToSqr(arg0: number, arg1: number, arg2: number): number;
    subtract(arg0: number, arg1: number, arg2: number): this;
    zRot(arg0: number): this;
    lerp(arg0: Vec3d_, arg1: number): this;
    horizontalDistance(): number;
    normalize(): this;
    get(arg0: Internal.Direction$Axis_): number;
    getClass(): typeof any;
    relative(arg0: Internal.Direction_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number): this;
    cross(arg0: Vec3d_): this;
    static atCenterOf(arg0: Vec3i_): Vec3d;
    static directionFromRotation(arg0: Internal.Vec2_): Vec3d;
    add(arg0: Vec3d_): this;
    wait(arg0: number, arg1: number): void;
    "with"(arg0: Internal.Direction$Axis_, arg1: number): this;
    static atBottomCenterOf(arg0: Vec3i_): Vec3d;
    horizontalDistanceSqr(): number;
    dot(arg0: Vec3d_): number;
    multiply(arg0: number, arg1: number, arg2: number): this;
    y(): number;
    offsetRandom(arg0: Internal.RandomSource_, arg1: number): this;
    vectorTo(arg0: Vec3d_): this;
    toString(): string;
    static atLowerCornerOf(arg0: Vec3i_): Vec3d;
    notifyAll(): void;
    static fromRGB24(arg0: number): Vec3d;
    distanceTo(arg0: Vec3d_): number;
    multiply(arg0: Vec3d_): this;
    hashCode(): number;
    toVector3f(): Vec3f;
    wait(arg0: number): void;
    static directionFromRotation(arg0: number, arg1: number): Vec3d;
    equals(arg0: any): boolean;
    get class(): typeof any
    readonly z: number;
    static readonly ZERO: (Vec3d) & (Vec3d);
    static readonly CODEC: Internal.Codec<Vec3d>;
    readonly x: number;
    readonly y: number;
}
type Vec3d_ = [number, number, number] | Vec3d;
declare class RotationAxis extends Internal.Enum<RotationAxis> {
    deg(f: number): Quaternionf;
    static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static valueOf(name: string): RotationAxis;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    name(): string;
    static values(): RotationAxis[];
    hashCode(): number;
    rad(f: number): Quaternionf;
    getDeclaringClass(): typeof RotationAxis;
    ordinal(): number;
    wait(): void;
    "compareTo(dev.latvian.mods.kubejs.util.RotationAxis)"(arg0: RotationAxis_): number;
    wait(arg0: number): void;
    compareTo(arg0: RotationAxis_): number;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<RotationAxis>>;
    get class(): typeof any
    get declaringClass(): typeof RotationAxis
    static readonly XN: (RotationAxis) & (RotationAxis);
    static readonly ZP: (RotationAxis) & (RotationAxis);
    static readonly YN: (RotationAxis) & (RotationAxis);
    static readonly XP: (RotationAxis) & (RotationAxis);
    static readonly YP: (RotationAxis) & (RotationAxis);
    static readonly ZN: (RotationAxis) & (RotationAxis);
    readonly vec: Vec3f;
}
type RotationAxis_ = "yp" | "xp" | "yn" | "xn" | "zp" | RotationAxis | "zn";
declare class ResourceLocation implements Internal.ResourceLocationAccess, Internal.SpecialEquality, Internal.Comparable<ResourceLocation> {
    constructor(arg0: string, arg1: string)
    constructor(arg0: string)
    static isValidNamespace(arg0: string): boolean;
    compareTo(arg0: ResourceLocation_): number;
    toLanguageKey(arg0: string): string;
    static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
    notify(): void;
    compareTo(arg0: any): number;
    static tryBuild(arg0: string, arg1: string): ResourceLocation;
    static isAllowedInResourceLocation(arg0: string): boolean;
    withPath(arg0: string): this;
    static tryParse(arg0: string): ResourceLocation;
    static validPathChar(arg0: string): boolean;
    toLanguageKey(arg0: string, arg1: string): string;
    toDebugFileName(): string;
    /**
     * @deprecated
     * This method is marked to be removed in future!
    */
    static of(arg0: string, arg1: string): ResourceLocation;
    specialEquals(o: any, shallow: boolean): boolean;
    static read(arg0: Internal.StringReader_): ResourceLocation;
    static bySeparator(arg0: string, arg1: string): ResourceLocation;
    toLanguageKey(): string;
    static isValidResourceLocation(arg0: string): boolean;
    static parse(arg0: string): ResourceLocation;
    "withPath(java.util.function.UnaryOperator)"(arg0: Internal.UnaryOperator_<string>): this;
    wait(): void;
    static fromNamespaceAndPath(arg0: string, arg1: string): ResourceLocation;
    "compareTo(java.lang.Object)"(arg0: any): number;
    getClass(): typeof any;
    static validNamespaceChar(arg0: string): boolean;
    static read(arg0: string): Internal.DataResult<ResourceLocation>;
    static withDefaultNamespace(arg0: string): ResourceLocation;
    toShortLanguageKey(): string;
    static isValidPath(arg0: string): boolean;
    wait(arg0: number, arg1: number): void;
    setPath(arg0: string): void;
    "withPath(java.lang.String)"(arg0: string): this;
    getPath(): string;
    getNamespace(): string;
    compareNamespaced(arg0: ResourceLocation_): number;
    "compareTo(net.minecraft.resources.ResourceLocation)"(arg0: ResourceLocation_): number;
    toString(): string;
    withSuffix(arg0: string): this;
    notifyAll(): void;
    static tryBySeparator(arg0: string, arg1: string): ResourceLocation;
    static "read(com.mojang.brigadier.StringReader)"(arg0: Internal.StringReader_): ResourceLocation;
    hashCode(): number;
    static "read(java.lang.String)"(arg0: string): Internal.DataResult<ResourceLocation>;
    setNamespace(arg0: string): void;
    withPath(arg0: Internal.UnaryOperator_<string>): this;
    wait(arg0: number): void;
    withPrefix(arg0: string): this;
    equals(arg0: any): boolean;
    get class(): typeof any
    set path(arg0: string)
    get path(): string
    get namespace(): string
    set namespace(arg0: string)
    static readonly REALMS_NAMESPACE: ("realms") & (string);
    static readonly CODEC: Internal.Codec<ResourceLocation>;
    static readonly ERROR_INVALID: (Internal.SimpleCommandExceptionType) & (Internal.SimpleCommandExceptionType);
    static readonly NAMESPACE_SEPARATOR: (":") & (string);
    static readonly DEFAULT_NAMESPACE: ("minecraft") & (string);
}
type ResourceLocation_ = string | ResourceLocation | Special.CustomStat;
declare class any {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
}
type any_ = any;
declare class Stats {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly SWIM_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly FLY_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_SHULKER_BOX: (ResourceLocation) & (ResourceLocation);
    static readonly TOTAL_WORLD_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly TUNE_NOTEBLOCK: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_RESISTED: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_DROPPED: Internal.StatType<Internal.Item>;
    static readonly PLAYER_KILLS: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BREWINGSTAND: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_CAMPFIRE: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_DISPENSER: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_FURNACE: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_ENDERCHEST: (ResourceLocation) & (ResourceLocation);
    static readonly ANIMALS_BRED: (ResourceLocation) & (ResourceLocation);
    static readonly POT_FLOWER: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_STONECUTTER: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_PICKED_UP: Internal.StatType<Internal.Item>;
    static readonly FALL_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_ABSORBED: (ResourceLocation) & (ResourceLocation);
    static readonly FISH_CAUGHT: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_ANVIL: (ResourceLocation) & (ResourceLocation);
    static readonly BOAT_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_RECORD: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT_RESISTED: (ResourceLocation) & (ResourceLocation);
    static readonly RAID_WIN: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT: (ResourceLocation) & (ResourceLocation);
    static readonly DEATHS: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_SMOKER: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_USED: Internal.StatType<Internal.Item>;
    static readonly BELL_RING: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_SMITHING_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_DROPPER: (ResourceLocation) & (ResourceLocation);
    static readonly DROP: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_LECTERN: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly WALK_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly CLIMB_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly TRADED_WITH_VILLAGER: (ResourceLocation) & (ResourceLocation);
    static readonly RAID_TRIGGER: (ResourceLocation) & (ResourceLocation);
    static readonly STRIDER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_BROKEN: Internal.StatType<Internal.Item>;
    static readonly BLOCK_MINED: Internal.StatType<Internal.Block>;
    static readonly TIME_SINCE_REST: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BEACON: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_HOPPER: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_NOTEBLOCK: (ResourceLocation) & (ResourceLocation);
    static readonly CUSTOM: Internal.StatType<ResourceLocation>;
    static readonly CROUCH_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly JUMP: (ResourceLocation) & (ResourceLocation);
    static readonly ENTITY_KILLED: Internal.StatType<Internal.EntityType<any>>;
    static readonly ENTITY_KILLED_BY: Internal.StatType<Internal.EntityType<any>>;
    static readonly INTERACT_WITH_CARTOGRAPHY_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly MOB_KILLS: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_CHEST: (ResourceLocation) & (ResourceLocation);
    static readonly SLEEP_IN_BED: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_ARMOR: (ResourceLocation) & (ResourceLocation);
    static readonly CROUCH_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly TALKED_TO_VILLAGER: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT_ABSORBED: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_LOOM: (ResourceLocation) & (ResourceLocation);
    static readonly LEAVE_GAME: (ResourceLocation) & (ResourceLocation);
    static readonly HORSE_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly WALK_ON_WATER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly MINECART_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly ENCHANT_ITEM: (ResourceLocation) & (ResourceLocation);
    static readonly TIME_SINCE_DEATH: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_TAKEN: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BLAST_FURNACE: (ResourceLocation) & (ResourceLocation);
    static readonly TRIGGER_TRAPPED_CHEST: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_GRINDSTONE: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_BARREL: (ResourceLocation) & (ResourceLocation);
    static readonly SPRINT_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_BLOCKED_BY_SHIELD: (ResourceLocation) & (ResourceLocation);
    static readonly EAT_CAKE_SLICE: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_CRAFTING_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_BANNER: (ResourceLocation) & (ResourceLocation);
    static readonly TARGET_HIT: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_CRAFTED: Internal.StatType<Internal.Item>;
    static readonly WALK_UNDER_WATER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly PIG_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_SHULKER_BOX: (ResourceLocation) & (ResourceLocation);
    static readonly USE_CAULDRON: (ResourceLocation) & (ResourceLocation);
    static readonly AVIATE_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly FILL_CAULDRON: (ResourceLocation) & (ResourceLocation);
}
type Stats_ = Stats;
declare class Fluid {
    constructor()
    static of(o: Internal.FluidStackJS_): Internal.FluidStackJS;
    getClass(): typeof any;
    static getEmpty(): Internal.FluidStackJS;
    static getType(id: ResourceLocation_): Internal.Fluid;
    static of(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    toString(): string;
    static of(o: Internal.FluidStackJS_, amount: number, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static "of(dev.latvian.mods.kubejs.fluid.FluidStackJS,net.minecraft.nbt.CompoundTag)"(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    notifyAll(): void;
    static lava(amount: number): Internal.FluidStackJS;
    static of(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static lava(): Internal.FluidStackJS;
    static getTypes(): Internal.List<string>;
    static "of(dev.latvian.mods.kubejs.fluid.FluidStackJS,int)"(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    wait(): void;
    static getId(fluid: Internal.Fluid_): ResourceLocation;
    wait(arg0: number): void;
    static water(amount: number): Internal.FluidStackJS;
    static exists(id: ResourceLocation_): boolean;
    equals(arg0: any): boolean;
    static water(): Internal.FluidStackJS;
    get class(): typeof any
    get empty(): Internal.FluidStackJS
    get types(): Internal.List<string>
    static readonly LAVA_ID: (ResourceLocation) & (ResourceLocation);
    static readonly WATER_ID: (ResourceLocation) & (ResourceLocation);
}
type Fluid_ = Fluid;
declare class InputItem implements Internal.InputReplacement, Internal.IngredientSupplierKJS, Internal.JsonSerializable {
    replaceInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.InputReplacement_): any;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    isEmpty(): boolean;
    notify(): void;
    toJson(): Internal.JsonElement;
    withCount(count: number): this;
    wait(arg0: number, arg1: number): void;
    static of(o: InputItem_): InputItem;
    toJson(alwaysNest: boolean): Internal.JsonElement;
    validForMatching(): boolean;
    static of(ingredient: Internal.Ingredient_, count: number): InputItem;
    hashCode(): number;
    unwrap(): Internal.List<InputItem>;
    wait(): void;
    wait(arg0: number): void;
    transform(transformer: Internal.InputReplacementTransformer_): Internal.InputReplacementTransformer$Replacement;
    equals(arg0: any): boolean;
    kjs$asIngredient(): Internal.Ingredient;
    get class(): typeof any
    get empty(): boolean
    readonly ingredient: Internal.Ingredient;
    readonly count: number;
    static readonly EMPTY: (InputItem) & (InputItem);
    static readonly PARSE_CACHE: ({"kubejs:comb_base": InputItem, "#minecraft:leaves": InputItem, "createappliedkinetics:incomplete_logic_processor": InputItem, "thermal:apatite": InputItem, "ae2:certus_quartz_crystal": InputItem, "kubejs:crushed_scorchia": InputItem, "minecraft:bone": InputItem, "minecraft:dripstone_block": InputItem, "minecraft:acacia_sapling": InputItem, "kubejs:incomplete_printed_logic_processor": InputItem, "minecraft:calcite": InputItem, "kubejs:buckram": InputItem, "#forge:plates/netherite": InputItem, "minecraft:iron_ingot": InputItem, "minecraft:emerald": InputItem, "#kubejs:wax": InputItem, "minecraft:bone_meal": InputItem, "minecraft:rotten_flesh": InputItem, "ae2:printed_logic_processor": InputItem, "ae2:printed_calculation_processor": InputItem, "ae2:growth_accelerator": InputItem, "kubejs:incomplete_printed_silicon": InputItem, "minecraft:iron_nugget": InputItem, "tconstruct:ichor_slime_crystal_block": InputItem, "kubejs:incomplete_printed_engineering_processor": InputItem, "#forge:plates/zinc": InputItem, "thermal:niter": InputItem, "createappliedkinetics:incomplete_engineering_processor": InputItem, "tconstruct:ender_slime_crystal_block": InputItem, "minecraft:oak_sapling": InputItem, "#forge:plates/gold": InputItem, "minecraft:cobblestone": InputItem, "minecraft:spruce_sapling": InputItem, "#forge:leather": InputItem, "minecraft:stone": InputItem, "minecraft:poppy": InputItem, "thermal:rubberwood_sapling": InputItem, "ae2:not_so_mysterious_cube": InputItem, "minecraft:jungle_sapling": InputItem, "#forge:plates/iron": InputItem, "minecraft:amethyst_block": InputItem, "createappliedkinetics:incomplete_calculation_processor": InputItem, "enderio:grains_of_infinity": InputItem, "minecraft:string": InputItem, "#forge:plates/copper": InputItem, "minecraft:birch_sapling": InputItem, "ae2:printed_engineering_processor": InputItem, "mysticalagriculture:blank_skull": InputItem, "ae2:sky_stone_block": InputItem, "minecraft:diamond": InputItem, "#forge:silicon": InputItem, "ae2:flawed_budding_quartz": InputItem, "#forge:ingots/electrum": InputItem, "ae2:sky_dust": InputItem, "minecraft:quartz": InputItem, "tconstruct:earth_slime_crystal_block": InputItem, "thermal:sulfur": InputItem, "kubejs:incomplete_printed_calculation_processor": InputItem, "minecraft:obsidian": InputItem, "ae2:quartz_block": InputItem, "kubejs:cotton_seed": InputItem, "minecraft:gunpowder": InputItem, "tconstruct:sky_slime_crystal_block": InputItem, "minecraft:end_stone": InputItem, "minecraft:dark_oak_sapling": InputItem, "thermal:cinnabar": InputItem, "minecraft:leather": InputItem, "tconstruct:necrotic_bone": InputItem, "kubejs:wax": InputItem, "minecraft:cherry_sapling": InputItem, "minecraft:crying_obsidian": InputItem, "ae2:printed_silicon": InputItem}) & (Internal.Map<string, InputItem>);
}
type InputItem_ = Internal.Ingredient_ | InputItem;
declare class PonderPointing extends Internal.Enum<PonderPointing> implements Internal.StringRepresentable {
    getClass(): typeof any;
    static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>, arg1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
    getSerializedName(): string;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    "compareTo(net.createmod.catnip.math.Pointing)"(arg0: PonderPointing_): number;
    compareTo(arg0: any): number;
    static valueOf(arg0: string): PonderPointing;
    static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
    compareTo(arg0: PonderPointing_): number;
    getXRotation(): number;
    getCombinedDirection(arg0: Internal.Direction_): Internal.Direction;
    static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
    toString(): string;
    static values(): PonderPointing[];
    notifyAll(): void;
    name(): string;
    describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<PonderPointing>>;
    hashCode(): number;
    static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
    getDeclaringClass(): typeof PonderPointing;
    ordinal(): number;
    wait(): void;
    wait(arg0: number): void;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    get class(): typeof any
    get serializedName(): string
    get XRotation(): number
    get declaringClass(): typeof PonderPointing
    static readonly RIGHT: (PonderPointing) & (PonderPointing);
    static readonly UP: (PonderPointing) & (PonderPointing);
    static readonly DOWN: (PonderPointing) & (PonderPointing);
    static readonly LEFT: (PonderPointing) & (PonderPointing);
}
type PonderPointing_ = "up" | "down" | PonderPointing | "right" | "left";
declare interface Color {
    of(o: any): dev.latvian.mods.rhino.mod.util.color.Color;
    rgba(r: number, g: number, b: number, a: number): dev.latvian.mods.rhino.mod.util.color.Color;
    createMapped(o: any, ...names: string[]): dev.latvian.mods.rhino.mod.util.color.Color;
    readonly DARK_PURPLE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly YELLOW: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly CYAN_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GRAY: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BROWN_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIGHT_PURPLE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly PURPLE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_AQUA: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GREEN: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIGHT_GRAY_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly WHITE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly MAGENTA_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly RED: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BLACK_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly TEXT: ({"dark_red": Internal.ChatFormatting, "green": Internal.ChatFormatting, "underline": Internal.ChatFormatting, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "bold": Internal.ChatFormatting, "italic": Internal.ChatFormatting, "dark_blue": Internal.ChatFormatting, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "red": Internal.ChatFormatting, "aqua": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "blue": Internal.ChatFormatting, "white": Internal.ChatFormatting, "dark_aqua": Internal.ChatFormatting, "dark_gray": Internal.ChatFormatting, "reset": Internal.ChatFormatting, "strikethrough": Internal.ChatFormatting, "obfuscated": Internal.ChatFormatting}) & (Internal.Map<string, Internal.ChatFormatting>);
    readonly RED_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GRAY_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_GRAY: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly NONE: (Internal.NoColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly ORANGE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly WHITE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DYE: ({"magenta": Internal.DyeColor, "pink": Internal.DyeColor, "green": Internal.DyeColor, "lime": Internal.DyeColor, "light_gray": Internal.DyeColor, "yellow": Internal.DyeColor, "black": Internal.DyeColor, "light_blue": Internal.DyeColor, "brown": Internal.DyeColor, "cyan": Internal.DyeColor, "orange": Internal.DyeColor, "red": Internal.DyeColor, "gray": Internal.DyeColor, "white": Internal.DyeColor, "blue": Internal.DyeColor, "purple": Internal.DyeColor}) & (Internal.Map<string, Internal.DyeColor>);
    readonly BLACK: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BLUE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_GREEN: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_RED: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GOLD: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly MAP: ({"": Internal.NoColor, "light_blue_dye": Internal.DyeColor, "BLUE_DYE": Internal.DyeColor, "purple_dye": Internal.DyeColor, "dark_red": Internal.ChatFormatting, "lightGrayDye": Internal.DyeColor, "DARK_AQUA": Internal.ChatFormatting, "none": Internal.NoColor, "green_dye": Internal.DyeColor, "blackDye": Internal.DyeColor, "dark_blue": Internal.ChatFormatting, "red": Internal.ChatFormatting, "pink_dye": Internal.DyeColor, "aqua": Internal.ChatFormatting, "white": Internal.ChatFormatting, "WHITE_DYE": Internal.DyeColor, "dark_gray": Internal.ChatFormatting, "LIGHT_PURPLE": Internal.ChatFormatting, "BROWN_DYE": Internal.DyeColor, "BLACK": Internal.ChatFormatting, "darkPurple": Internal.ChatFormatting, "NONE": Internal.NoColor, "LIGHT_BLUE_DYE": Internal.DyeColor, "AQUA": Internal.ChatFormatting, "lightBlueDye": Internal.DyeColor, "limeDye": Internal.DyeColor, "PURPLE_DYE": Internal.DyeColor, "GREEN_DYE": Internal.DyeColor, "magenta_dye": Internal.DyeColor, "-": Internal.NoColor, "lime_dye": Internal.DyeColor, "yellowDye": Internal.DyeColor, "grayDye": Internal.DyeColor, "purpleDye": Internal.DyeColor, "DARK_PURPLE": Internal.ChatFormatting, "ORANGE_DYE": Internal.DyeColor, "darkGray": Internal.ChatFormatting, "brownDye": Internal.DyeColor, "YELLOW": Internal.ChatFormatting, "LIME_DYE": Internal.DyeColor, "blueDye": Internal.DyeColor, "white_dye": Internal.DyeColor, "pinkDye": Internal.DyeColor, "blue_dye": Internal.DyeColor, "cyanDye": Internal.DyeColor, "GOLD": Internal.ChatFormatting, "GRAY": Internal.ChatFormatting, "MAGENTA_DYE": Internal.DyeColor, "BLUE": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "darkBlue": Internal.ChatFormatting, "transparent": Internal.NoColor, "orange_dye": Internal.DyeColor, "red_dye": Internal.DyeColor, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "darkRed": Internal.ChatFormatting, "greenDye": Internal.DyeColor, "DARK_RED": Internal.ChatFormatting, "redDye": Internal.DyeColor, "GRAY_DYE": Internal.DyeColor, "orangeDye": Internal.DyeColor, "yellow_dye": Internal.DyeColor, "black_dye": Internal.DyeColor, "magentaDye": Internal.DyeColor, "WHITE": Internal.ChatFormatting, "green": Internal.ChatFormatting, "LIGHT_GRAY_DYE": Internal.DyeColor, "BLACK_DYE": Internal.DyeColor, "darkGreen": Internal.ChatFormatting, "RED_DYE": Internal.DyeColor, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "lightPurple": Internal.ChatFormatting, "PINK_DYE": Internal.DyeColor, "DARK_BLUE": Internal.ChatFormatting, "GREEN": Internal.ChatFormatting, "darkAqua": Internal.ChatFormatting, "gray_dye": Internal.DyeColor, "CYAN_DYE": Internal.DyeColor, "RED": Internal.ChatFormatting, "brown_dye": Internal.DyeColor, "cyan_dye": Internal.DyeColor, "blue": Internal.ChatFormatting, "whiteDye": Internal.DyeColor, "dark_aqua": Internal.ChatFormatting, "YELLOW_DYE": Internal.DyeColor, "DARK_GREEN": Internal.ChatFormatting, "DARK_GRAY": Internal.ChatFormatting}) & (Internal.Map<string, dev.latvian.mods.rhino.mod.util.color.Color>);
    readonly GREEN_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIGHT_BLUE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly AQUA: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_BLUE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly PINK_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BLUE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly YELLOW_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIME_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
}
type Color_ = Color;
declare const Color: Color;
declare class JsonIO {
    constructor()
    getClass(): typeof any;
    static readJson(path: Internal.Path_): Internal.JsonElement;
    static toPrettyString(json: Internal.JsonElement_): string;
    static getJsonHashString(json: Internal.JsonElement_): string;
    notify(): void;
    static toObject(json: Internal.JsonElement_): any;
    wait(arg0: number, arg1: number): void;
    static primitiveOf(o: any): Internal.JsonPrimitive;
    static readString(path: Internal.Path_): string;
    static writeJsonHash(stream: Internal.DataOutputStream_, element: Internal.JsonElement_): void;
    static parseRaw(string: string): Internal.JsonElement;
    static write(path: Internal.Path_, json: Internal.JsonObject_): void;
    static read(path: Internal.Path_): Internal.Map<any, any>;
    toString(): string;
    notifyAll(): void;
    static toArray(element: Internal.JsonElement_): Internal.JsonArray;
    static parse(string: string): any;
    static toPrimitive(element: Internal.JsonElement_): any;
    hashCode(): number;
    static copy(element: Internal.JsonElement_): Internal.JsonElement;
    wait(): void;
    wait(arg0: number): void;
    static getJsonHashBytes(json: Internal.JsonElement_): number[];
    static toString(json: Internal.JsonElement_): string;
    equals(arg0: any): boolean;
    static of(o: any): Internal.JsonElement;
    get class(): typeof any
}
type JsonIO_ = JsonIO;
/**
 * Various item related helper methods
*/
declare interface Item {
    /**
     * Returns an ItemStack of the input
    */
    of(in_: Internal.ItemStack_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    of(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count and NBT data
    */
    of(in_: Internal.ItemStack_, count: number, nbt: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    withNBT(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.ItemStack;
    getTypeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>;
    playerHeadFromSkinHash(hash: string): Internal.ItemStack;
    /**
     * Get the item that represents air/an empty slot
    */
    getEmpty(): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    "of(net.minecraft.world.item.ItemStack,int)"(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Gets an Item from an item id
    */
    getItem(id: ResourceLocation_): Internal.Item;
    getVariants(item: Internal.ItemStack_): Internal.Collection<Internal.ItemStack>;
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    getList(): Internal.List<Internal.ItemStack>;
    /**
     * Returns a Firework with the input properties
    */
    fireworks(properties: Internal.Map_<string, any>): Internal.FireworksJS;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    "of(net.minecraft.world.item.ItemStack,net.minecraft.nbt.CompoundTag)"(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    playerHead(name: string): Internal.ItemStack;
    playerHeadFromUrl(url: string): Internal.ItemStack;
    /**
     * Get a list of all the item ids in the game
    */
    getTypeList(): Internal.List<string>;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    of(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Checks if the provided item id exists in the registry
    */
    exists(id: ResourceLocation_): boolean;
    playerHead(uuid: Internal.UUID_, textureBase64: string): Internal.ItemStack;
    /**
     * Checks if the passed in object is an ItemStack.
     * Note that this does not mean it will not function as an ItemStack if passed to something that requests one.
    */
    isItem(o: any): boolean;
    /**
     * Gets an items id from the Item
    */
    getId(item: Internal.Item_): ResourceLocation;
    get typeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>
    /**
     * Get the item that represents air/an empty slot
    */
    get empty(): Internal.ItemStack
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    get list(): Internal.List<Internal.ItemStack>
    /**
     * Get a list of all the item ids in the game
    */
    get typeList(): Internal.List<string>
    readonly KJS_ARMOR_MODIFIER_UUID_PER_SLOT: Internal.UUID[];
    readonly KJS_BASE_ATTACK_SPEED_UUID: (Internal.UUID) & (Internal.UUID);
    readonly KJS_BASE_ATTACK_DAMAGE_UUID: (Internal.UUID) & (Internal.UUID);
}
type Item_ = Item;
declare const Item: Item;
declare abstract class number implements Internal.Serializable {
    constructor()
    abstract longValue(): number;
    getClass(): typeof any;
    abstract doubleValue(): number;
    toString(): string;
    abstract floatValue(): number;
    notifyAll(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    shortValue(): number;
    hashCode(): number;
    abstract intValue(): number;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    byteValue(): number;
    get class(): typeof any
}
type number_ = number;
declare interface ParrotElement extends Internal.AnimatedSceneElement {
    abstract getPositionOffset(): Vec3d;
    abstract setRotation(arg0: Vec3d_, arg1: boolean): void;
    abstract setPose(arg0: Internal.ParrotPose_): void;
    tick(arg0: Internal.PonderScene_): void;
    abstract setPositionOffset(arg0: Vec3d_, arg1: boolean): void;
    abstract getRotation(): Vec3d;
    abstract setFadeVec(arg0: Vec3d_): void;
    reset(arg0: Internal.PonderScene_): void;
    abstract forceApplyFade(arg0: number): void;
    abstract renderFirst(arg0: Internal.PonderLevel_, arg1: Internal.MultiBufferSource_, arg2: Internal.GuiGraphics_, arg3: number): void;
    abstract renderLast(arg0: Internal.PonderLevel_, arg1: Internal.MultiBufferSource_, arg2: Internal.GuiGraphics_, arg3: number): void;
    abstract setFade(arg0: number): void;
    whileSkipping(arg0: Internal.PonderScene_): void;
    abstract renderLayer(arg0: Internal.PonderLevel_, arg1: Internal.MultiBufferSource_, arg2: Internal.RenderType_, arg3: Internal.GuiGraphics_, arg4: number): void;
    abstract isVisible(): boolean;
    abstract setVisible(arg0: boolean): void;
    get positionOffset(): Vec3d
    set pose(arg0: Internal.ParrotPose_)
    get rotation(): Vec3d
    set fadeVec(arg0: Vec3d_)
    set fade(arg0: number)
    get visible(): boolean
    set visible(arg0: boolean)
}
type ParrotElement_ = ParrotElement;
declare const ParrotElement: ParrotElement;
declare class Notification {
    constructor()
    constructor(buf: Internal.FriendlyByteBuf_)
    getClass(): typeof any;
    write(buf: Internal.FriendlyByteBuf_): void;
    toString(): string;
    static make(consumer: Internal.Consumer_<Notification>): Notification;
    notifyAll(): void;
    setIcon(icon: string): void;
    static of(cx: Internal.Context_, object: any): Notification;
    show(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    setAtlasIcon(icon: string): void;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    setItemIcon(stack: Internal.ItemStack_): void;
    get class(): typeof any
    set icon(icon: string)
    set atlasIcon(icon: string)
    set itemIcon(stack: Internal.ItemStack_)
    duration: Duration;
    static readonly DEFAULT_DURATION: (Duration) & (Duration);
    backgroundColor: dev.latvian.mods.rhino.mod.util.color.Color;
    iconSize: number;
    static readonly DEFAULT_BACKGROUND_COLOR: (Internal.SimpleColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    static readonly DEFAULT_BORDER_COLOR: (Internal.SimpleColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    borderColor: dev.latvian.mods.rhino.mod.util.color.Color;
    text: net.minecraft.network.chat.Component;
    outlineColor: dev.latvian.mods.rhino.mod.util.color.Color;
    textShadow: boolean;
    static readonly NO_TEXT: net.minecraft.network.chat.Component[];
}
type Notification_ = Notification;
declare interface Facing {
    readonly south: (Internal.Direction) & (Internal.Direction);
    readonly up: (Internal.Direction) & (Internal.Direction);
    readonly UP: (Internal.Direction) & (Internal.Direction);
    readonly NORTH: (Internal.Direction) & (Internal.Direction);
    readonly east: (Internal.Direction) & (Internal.Direction);
    readonly DOWN: (Internal.Direction) & (Internal.Direction);
    readonly EAST: (Internal.Direction) & (Internal.Direction);
    readonly west: (Internal.Direction) & (Internal.Direction);
    readonly north: (Internal.Direction) & (Internal.Direction);
    readonly down: (Internal.Direction) & (Internal.Direction);
    readonly ALL: ({"east": Internal.Direction, "south": Internal.Direction, "north": Internal.Direction, "west": Internal.Direction, "up": Internal.Direction, "down": Internal.Direction}) & (Internal.Map<string, Internal.Direction>);
    readonly WEST: (Internal.Direction) & (Internal.Direction);
    readonly SOUTH: (Internal.Direction) & (Internal.Direction);
}
type Facing_ = Facing;
declare const Facing: Facing;
declare class Quaternionf implements Internal.Cloneable, Internal.Externalizable, Internal.Quaternionfc {
    constructor()
    constructor(arg0: Internal.AxisAngle4d_)
    constructor(arg0: Internal.Quaternionfc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.AxisAngle4f_)
    constructor(arg0: Internal.Quaterniondc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    "transform(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    slerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transformInverse(arg0: Internal.Vector4d_): Internal.Vector4d;
    invert(): this;
    transformPositiveY(arg0: Vec3f_): Vec3f;
    transformPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    mul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    "getAsMatrix3f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformInverse(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    setFromUnnormalized(arg0: Internal.Matrix3fc_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    conjugate(arg0: Quaternionf_): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    transform(arg0: Internal.Vector4d_): Internal.Vector4d;
    fromAxisAngleDeg(arg0: Internal.Vector3fc_, arg1: number): this;
    "transformUnitPositiveZ(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    rotateLocalZ(arg0: number): this;
    premul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    scale(arg0: number): this;
    rotationZ(arg0: number): this;
    transformInverse(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveY(arg0: Vec4f_): Vec4f;
    transformPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    premul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformUnitPositiveY(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    invert(arg0: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "get(org.joml.Quaternionf)"(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverse(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transform(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    positiveZ(arg0: Vec3f_): Vec3f;
    div(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    setFromNormalized(arg0: Internal.Matrix3dc_): this;
    difference(arg0: Quaternionf_): this;
    normalize(): this;
    getClass(): typeof any;
    transformPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZ(arg0: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformPositiveZ(arg0: Vec3f_): Vec3f;
    transformUnit(arg0: Vec4f_): Vec4f;
    "setAngleAxis(double,double,double,double)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    scale(arg0: number, arg1: Quaternionf_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    "transformInverse(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    mul(arg0: number): this;
    "transformUnitPositiveX(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    static slerp(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    "transformPositiveY(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    get(arg0: Matrix4f_): Matrix4f;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transform(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4fc_): this;
    "setFromNormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    getAsMatrix3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(org.joml.Matrix4x3f)"(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    "transformInverseUnit(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    transformInverseUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    rotationAxis(arg0: Internal.AxisAngle4f_): this;
    normalize(arg0: Quaternionf_): this;
    mul(arg0: number, arg1: Quaternionf_): this;
    "transformPositiveZ(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformUnit(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    w(): number;
    transformPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformInverse(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    transformPositiveZ(arg0: Vec4f_): Vec4f;
    conjugateBy(arg0: Internal.Quaternionfc_): this;
    "transformInverse(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverse(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    get(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    transform(arg0: Vec3f_): Vec3f;
    "get(org.joml.Matrix3d)"(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    wait(arg0: number): void;
    "nlerp(org.joml.Quaternionfc,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    slerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    get(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    fromAxisAngleRad(arg0: number, arg1: number, arg2: number, arg3: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    transformPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "get(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocalY(arg0: number, arg1: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveY(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    setFromUnnormalized(arg0: Internal.Matrix3dc_): this;
    isFinite(): boolean;
    "nlerpIterative(org.joml.Quaternionfc,float,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformUnitPositiveX(arg0: Vec3f_): Vec3f;
    rotateLocalX(arg0: number): this;
    get(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    x(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transform(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transformPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: Vec3f_): Vec3f;
    "transformPositiveX(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "transform(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transform(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "setFromUnnormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    transformInverseUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "mul(float,org.joml.Quaternionf)"(arg0: number, arg1: Quaternionf_): this;
    "transformUnitPositiveZ(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformInverseUnit(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4fc_): this;
    fromAxisAngleRad(arg0: Internal.Vector3fc_, arg1: number): this;
    wait(): void;
    setFromNormalized(arg0: Internal.Matrix3fc_): this;
    premul(arg0: Internal.Quaternionfc_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    "transformPositiveX(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    get(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    "getAsMatrix4f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformInverse(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "transformUnit(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    static "nlerpIterative(org.joml.Quaternionf[],float[],float,org.joml.Quaternionf)"(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    transformInverse(arg0: Vec4f_): Vec4f;
    getEulerAnglesZXY(arg0: Vec3f_): Vec3f;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    "get(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    add(arg0: Internal.Quaternionfc_): this;
    rotateLocalZ(arg0: number, arg1: Quaternionf_): this;
    getAsMatrix4f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformUnit(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    add(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    dot(arg0: Quaternionf_): number;
    "transformUnitPositiveY(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "getAsMatrix4f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    static "nlerp(org.joml.Quaternionfc[],float[],org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    rotateLocalY(arg0: number): this;
    "transformInverse(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    y(): number;
    transformInverse(arg0: Vec3f_): Vec3f;
    "setFromNormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_): this;
    "transformUnitPositiveX(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setFromNormalized(arg0: Internal.Matrix4x3fc_): this;
    "get(org.joml.Matrix4d)"(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    static nlerp(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    getAsMatrix4x3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3dc_): this;
    "transformInverse(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveZ(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "mul(float)"(arg0: number): this;
    conjugate(): this;
    transformInverse(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    equals(arg0: any): boolean;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    "transformInverseUnit(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformInverseUnit(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "setFromNormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    "transformInverse(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transform(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    fromAxisAngleDeg(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "setFromUnnormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "getAsMatrix4x3f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformUnitPositiveZ(arg0: Vec3f_): Vec3f;
    "setFromNormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    transformUnitPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformUnitPositiveZ(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    z(): number;
    "transformUnitPositiveY(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    "setAngleAxis(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    "get(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    getAsMatrix3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    toString(arg0: Internal.NumberFormat_): string;
    transformInverseUnit(arg0: Vec3f_): Vec3f;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    lengthSquared(): number;
    setFromUnnormalized(arg0: Internal.Matrix4dc_): this;
    getEulerAnglesYXZ(arg0: Vec3f_): Vec3f;
    get(arg0: Quaternionf_): this;
    transformUnitPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateX(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveY(arg0: Vec4f_): Vec4f;
    identity(): this;
    "transformInverseUnit(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    clone(): any;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    "mul(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "setFromUnnormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "transformUnitPositiveX(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateLocalX(arg0: number, arg1: Quaternionf_): this;
    "transformPositiveY(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    static "slerp(org.joml.Quaternionf[],float[],org.joml.Quaternionf)"(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    transformInverseUnit(arg0: Vec4f_): Vec4f;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set(arg0: Internal.Quaternionfc_): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    setFromNormalized(arg0: Internal.Matrix4x3dc_): this;
    "get(org.joml.Matrix4x3d)"(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    transformInverseUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverseUnit(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveY(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformUnit(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "transformInverseUnit(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformUnit(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    get(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    toString(): string;
    "transformPositiveZ(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    notifyAll(): void;
    "setFromNormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    "transformInverse(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    equals(arg0: Internal.Quaternionfc_, arg1: number): boolean;
    scaling(arg0: number): this;
    transformInverse(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "slerp(org.joml.Quaternionfc,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    setFromUnnormalized(arg0: Internal.Matrix4x3fc_): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "transform(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Vec4f_): Vec4f;
    premul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    getAsMatrix4x3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: Internal.Quaternionfc_): this;
    rotateY(arg0: number): this;
    "transformInverse(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    notify(): void;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    rotationX(arg0: number): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformPositiveY(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverseUnit(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "getAsMatrix4x3f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.AxisAngle4f_): this;
    "getAsMatrix3f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    conjugateBy(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    "transform(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    angle(): number;
    "transformPositiveX(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformInverseUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transform(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "transformInverseUnit(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): Matrix3f;
    "setFromNormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    "transformUnitPositiveZ(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateZ(arg0: number, arg1: Quaternionf_): this;
    "transformInverseUnit(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    positiveX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformUnitPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "transformPositiveX(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    getAsMatrix4f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotateX(arg0: number): this;
    "transformInverseUnit(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveX(arg0: Vec3f_): Vec3f;
    difference(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "transformInverse(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "get(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    wait(arg0: number, arg1: number): void;
    "setFromUnnormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    set(arg0: Internal.Quaterniondc_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "transformUnit(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "mul(org.joml.Quaternionfc,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number): this;
    transform(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "transformUnitPositiveY(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transformUnit(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transform(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    "transformUnit(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4dc_): this;
    static nlerpIterative(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    rotationY(arg0: number): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    transformInverse(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    "transformInverseUnit(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveX(arg0: Vec4f_): Vec4f;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): Matrix4f;
    set(arg0: Internal.AxisAngle4d_): this;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    hashCode(): number;
    positiveY(arg0: Vec3f_): Vec3f;
    "transformInverse(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "setFromUnnormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_): this;
    transformUnitPositiveZ(arg0: Vec4f_): Vec4f;
    get(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "transformPositiveZ(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    "transform(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformUnitPositiveX(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    transformUnitPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateY(arg0: number, arg1: Quaternionf_): this;
    "setFromUnnormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    "transformUnit(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set fromUnnormalized(arg0: Internal.Matrix3fc_)
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    set fromNormalized(arg0: Internal.Matrix3dc_)
    get class(): typeof any
    set fromNormalized(arg0: Internal.Matrix4fc_)
    set "fromNormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set fromUnnormalized(arg0: Internal.Matrix3dc_)
    get finite(): boolean
    set "fromUnnormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set fromUnnormalized(arg0: Internal.Matrix4fc_)
    set fromNormalized(arg0: Internal.Matrix3fc_)
    set "fromNormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_)
    set fromNormalized(arg0: Internal.Matrix4x3fc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3dc_)
    set "fromNormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "fromUnnormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_)
    set "fromNormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set fromUnnormalized(arg0: Internal.Matrix4dc_)
    set "fromUnnormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    set fromNormalized(arg0: Internal.Matrix4x3dc_)
    set "fromNormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3fc_)
    set "fromNormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "fromUnnormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set fromNormalized(arg0: Internal.Matrix4dc_)
    set "fromUnnormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_)
    set "fromUnnormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    z: number;
    y: number;
    x: number;
    w: number;
}
type Quaternionf_ = Quaternionf;
declare class BlockProperties {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly LEVEL_FLOWING: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly PERSISTENT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HORIZONTAL_FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly WEST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CHISELED_BOOKSHELF_SLOT_5_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly NOTE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly AGE_5: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EGGS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NORTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_RECORD: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SCULK_SENSOR_PHASE: Internal.EnumProperty<Internal.SculkSensorPhase>;
    static readonly EAST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly HALF: Internal.EnumProperty<Internal.Half>;
    static readonly RESPAWN_ANCHOR_CHARGES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly HANGING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly TILT: Internal.EnumProperty<Internal.Tilt>;
    static readonly STABILITY_DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_4_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_BOTTLE_2: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LAYERS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly SOUTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CRACKED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CONDITIONAL: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LOCKED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly POWER: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EYE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SOUTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly MAX_AGE_1: (1) & (number);
    static readonly ATTACHED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_LEVEL_15: (15) & (number);
    static readonly BELL_ATTACHMENT: Internal.EnumProperty<Internal.BellAttachType>;
    static readonly MAX_DISTANCE: (7) & (number);
    static readonly FLOWER_AMOUNT: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EXTENDED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly INVERTED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MODE_COMPARATOR: Internal.EnumProperty<Internal.ComparatorMode>;
    static readonly MOISTURE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly LIT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NORTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly AGE_3: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STAIRS_SHAPE: Internal.EnumProperty<Internal.StairsShape>;
    static readonly MAX_LEVEL_8: (8) & (number);
    static readonly MIN_RESPAWN_ANCHOR_CHARGES: (0) & (number);
    static readonly BAMBOO_LEAVES: Internal.EnumProperty<Internal.BambooLeaves>;
    static readonly HORIZONTAL_AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly FALLING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ENABLED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ATTACH_FACE: Internal.EnumProperty<Internal.AttachFace>;
    static readonly OPEN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly UNSTABLE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_4: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EAST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ORIENTATION: Internal.EnumProperty<Internal.FrontAndTop>;
    static readonly DOUBLE_BLOCK_HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    static readonly MAX_RESPAWN_ANCHOR_CHARGES: (4) & (number);
    static readonly CHEST_TYPE: Internal.EnumProperty<Internal.ChestType>;
    static readonly MAX_AGE_7: (7) & (number);
    static readonly DOWN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_2_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_15: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STRUCTUREBLOCK_MODE: Internal.EnumProperty<Internal.StructureMode>;
    static readonly SLAB_TYPE: Internal.EnumProperty<Internal.SlabType>;
    static readonly EAST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly WATERLOGGED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BLOOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SHRIEKING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_1: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly FACING_HOPPER: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly VERTICAL_DIRECTION: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly PICKLES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_25: (25) & (number);
    static readonly LEVEL_HONEY: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DUSTED: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_4: (4) & (number);
    static readonly PISTON_TYPE: Internal.EnumProperty<Internal.PistonType>;
    static readonly HATCH: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly SNOWY: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly TRIGGERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_1_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SIGNAL_FIRE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LEVEL_CAULDRON: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly AGE_2: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DRAG: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CAN_SUMMON: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LEVEL: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STAGE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_5: (5) & (number);
    static readonly NORTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly UP: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_0_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BITES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly IN_WALL: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_25: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STABILITY_MAX_DISTANCE: (7) & (number);
    static readonly HAS_BOTTLE_1: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_7: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_3_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SOUTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_15: (15) & (number);
    static readonly DISARMED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly RAIL_SHAPE: Internal.EnumProperty<Internal.RailShape>;
    static readonly DOOR_HINGE: Internal.EnumProperty<Internal.DoorHingeSide>;
    static readonly LEVEL_COMPOSTER: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DELAY: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MIN_LEVEL: (0) & (number);
    static readonly RAIL_SHAPE_STRAIGHT: Internal.EnumProperty<Internal.RailShape>;
    static readonly MIN_LEVEL_CAULDRON: (1) & (number);
    static readonly BOTTOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_BOOK: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CANDLES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NOTEBLOCK_INSTRUMENT: Internal.EnumProperty<Internal.NoteBlockInstrument>;
    static readonly WEST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SHORT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BERRIES: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_2: (2) & (number);
    static readonly HAS_BOTTLE_0: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly WEST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly ROTATION_16: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_LEVEL_3: (3) & (number);
    static readonly BED_PART: Internal.EnumProperty<Internal.BedPart>;
    static readonly POWERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_3: (3) & (number);
    static readonly OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly DRIPSTONE_THICKNESS: Internal.EnumProperty<Internal.DripstoneThickness>;
    static readonly FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
}
type BlockProperties_ = BlockProperties;
declare class PonderPalette extends Internal.Enum<PonderPalette> {
    static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    getDeclaringClass(): typeof PonderPalette;
    compareTo(arg0: PonderPalette_): number;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    "compareTo(net.createmod.ponder.api.PonderPalette)"(arg0: PonderPalette_): number;
    static values(): PonderPalette[];
    compareTo(arg0: any): number;
    name(): string;
    getColor(): number;
    hashCode(): number;
    ordinal(): number;
    wait(): void;
    describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<PonderPalette>>;
    static valueOf(arg0: string): PonderPalette;
    wait(arg0: number): void;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    getColorObject(): net.createmod.catnip.theme.Color;
    get class(): typeof any
    get declaringClass(): typeof PonderPalette
    get color(): number
    get colorObject(): net.createmod.catnip.theme.Color
    static readonly RED: (PonderPalette) & (PonderPalette);
    static readonly SLOW: (PonderPalette) & (PonderPalette);
    static readonly FAST: (PonderPalette) & (PonderPalette);
    static readonly WHITE: (PonderPalette) & (PonderPalette);
    static readonly INPUT: (PonderPalette) & (PonderPalette);
    static readonly MEDIUM: (PonderPalette) & (PonderPalette);
    static readonly GREEN: (PonderPalette) & (PonderPalette);
    static readonly OUTPUT: (PonderPalette) & (PonderPalette);
    static readonly BLUE: (PonderPalette) & (PonderPalette);
    static readonly BLACK: (PonderPalette) & (PonderPalette);
}
type PonderPalette_ = "medium" | "slow" | PonderPalette | "white" | "output" | "red" | "input" | "blue" | "fast" | "black" | "green";
declare class Vec3i implements Internal.Comparable<Vec3i> {
    constructor(arg0: number, arg1: number, arg2: number)
    getY(): number;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    toShortString(): string;
    notify(): void;
    compareTo(arg0: any): number;
    east(arg0: number): this;
    relative(arg0: Internal.Direction_): this;
    multiply(arg0: number): this;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(arg0: number): this;
    above(): this;
    "compareTo(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
    east(): this;
    west(): this;
    relative(arg0: Internal.Direction$Axis_, arg1: number): this;
    distSqr(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): this;
    wait(): void;
    setY(arg0: number): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    north(): this;
    getClass(): typeof any;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    south(arg0: number): this;
    above(arg0: number): this;
    west(arg0: number): this;
    wait(arg0: number, arg1: number): void;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    "relative(net.minecraft.core.Direction$Axis,int)"(arg0: Internal.Direction$Axis_, arg1: number): this;
    getZ(): number;
    offset(arg0: number, arg1: number, arg2: number): this;
    toString(): string;
    north(arg0: number): this;
    below(): this;
    notifyAll(): void;
    distManhattan(arg0: Vec3i_): number;
    get(arg0: Internal.Direction$Axis_): number;
    offset(arg0: Vec3i_): this;
    cross(arg0: Vec3i_): this;
    south(): this;
    hashCode(): number;
    relative(arg0: Internal.Direction_, arg1: number): this;
    setZ(arg0: number): this;
    wait(arg0: number): void;
    compareTo(arg0: Vec3i_): number;
    setX(arg0: number): this;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    equals(arg0: any): boolean;
    "relative(net.minecraft.core.Direction,int)"(arg0: Internal.Direction_, arg1: number): this;
    get y(): number
    set y(arg0: number)
    get class(): typeof any
    get x(): number
    get z(): number
    set z(arg0: number)
    set x(arg0: number)
    static readonly ZERO: (Vec3i) & (Vec3i);
    static readonly CODEC: Internal.Codec<Vec3i>;
}
type Vec3i_ = Vec3i;
declare class Blocks {
    constructor()
    static never(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static log(arg0: Internal.MapColor_, arg1: Internal.MapColor_, arg2: SoundType_): Internal.RotatedPillarBlock;
    static lambda$static$4(arg0: Internal.BlockState_): number;
    static m_187432_(arg0: Internal.BlockState_): number;
    static always(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static rebuildCache(): void;
    notify(): void;
    static log(arg0: Internal.MapColor_, arg1: Internal.MapColor_): Internal.RotatedPillarBlock;
    static m_181165_(arg0: Internal.BlockState_): number;
    static m_152681_(arg0: Internal.BlockState_): number;
    static m_50803_(arg0: Internal.BlockState_): number;
    static pistonBase(arg0: boolean): Internal.PistonBaseBlock;
    static m_50859_(arg0: Internal.BlockState_): number;
    static lambda$static$0(arg0: Internal.BlockState_): number;
    static stainedGlass(arg0: Internal.DyeColor_): Internal.StainedGlassBlock;
    static lambda$static$2(arg0: Internal.BlockState_): number;
    static lambda$bed$50(arg0: Internal.DyeColor_, arg1: Internal.BlockState_): Internal.MapColor;
    static m_152691_(arg0: Internal.BlockState_): number;
    static lambda$static$14(): Internal.Item;
    static m_50846_(arg0: Internal.BlockState_): number;
    static lambda$static$16(): Internal.Item;
    static m_152662_(arg0: Internal.BlockState_): number;
    static lambda$netherStem$53(arg0: Internal.MapColor_, arg1: Internal.BlockState_): Internal.MapColor;
    static stoneButton(): Internal.ButtonBlock;
    static woodenButton(arg0: Internal.BlockSetType_, ...arg1: Internal.FeatureFlag_[]): Internal.ButtonBlock;
    static lambda$static$22(arg0: Internal.BlockState_): number;
    static m_152631_(arg0: Internal.BlockState_): number;
    static lambda$shulkerBox$54(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static lambda$log$51(arg0: Internal.MapColor_, arg1: Internal.MapColor_, arg2: Internal.BlockState_): Internal.MapColor;
    static lambda$static$24(arg0: Internal.BlockState_): number;
    static litBlockEmission(arg0: number): Internal.ToIntFunction<Internal.BlockState>;
    static netherStem(arg0: Internal.MapColor_): Internal.Block;
    static m_187434_(arg0: Internal.BlockState_): number;
    wait(): void;
    static m_50839_(arg0: Internal.BlockState_): number;
    static m_50873_(arg0: Internal.BlockState_): number;
    static ocelotOrParrot(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static flowerPot(arg0: Internal.Block_, ...arg1: Internal.FeatureFlag_[]): Internal.FlowerPotBlock;
    getClass(): typeof any;
    static lambda$static$3(arg0: Internal.BlockState_): number;
    static lambda$static$5(arg0: Internal.BlockState_): number;
    static m_187430_(arg0: Internal.BlockState_): number;
    static m_152638_(arg0: Internal.BlockState_): number;
    static m_152650_(arg0: Internal.BlockState_): number;
    static lambda$static$31(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    wait(arg0: number, arg1: number): void;
    static m_50885_(arg0: Internal.BlockState_): number;
    static lambda$static$36(arg0: Internal.BlockState_): number;
    static lambda$static$13(arg0: Internal.BlockState_): number;
    static m_50857_(arg0: Internal.BlockState_): number;
    static register(arg0: string, arg1: Internal.Block_): Internal.Block;
    static lambda$static$44(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static m_50853_(arg0: Internal.BlockState_): number;
    static m_181167_(arg0: Internal.BlockState_): number;
    static m_152683_(arg0: Internal.BlockState_): number;
    static lambda$static$38(arg0: Internal.BlockState_): number;
    static lambda$static$1(arg0: Internal.BlockState_): number;
    static lambda$static$15(): Internal.Item;
    static never(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static m_50871_(arg0: Internal.BlockState_): number;
    static lambda$static$29(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static lambda$static$17(): Internal.Item;
    static lambda$litBlockEmission$49(arg0: number, arg1: Internal.BlockState_): number;
    toString(): string;
    static bed(arg0: Internal.DyeColor_): Internal.BedBlock;
    notifyAll(): void;
    static m_152685_(arg0: Internal.BlockState_): number;
    static m_50827_(arg0: Internal.BlockState_): number;
    static shulkerBox(arg0: Internal.DyeColor_, arg1: Internal.BlockBehaviour$Properties_): Internal.ShulkerBoxBlock;
    static lambda$static$21(arg0: Internal.BlockState_): number;
    static m_152606_(arg0: Internal.BlockState_): number;
    static candle(arg0: Internal.MapColor_): Internal.CandleBlock;
    static lambda$static$8(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static lambda$static$6(): Internal.BlockEntityType<any>;
    static lambda$log$52(arg0: Internal.MapColor_, arg1: Internal.MapColor_, arg2: Internal.BlockState_): Internal.MapColor;
    static lambda$static$23(arg0: Internal.BlockState_): number;
    hashCode(): number;
    static leaves(arg0: SoundType_): Internal.LeavesBlock;
    static m_187436_(arg0: Internal.BlockState_): number;
    static lambda$static$7(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    wait(arg0: number): void;
    static m_50875_(arg0: Internal.BlockState_): number;
    static always(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    equals(arg0: any): boolean;
    static lambda$pistonBase$55(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    get class(): typeof any
    static MANGROVE_PROPAGULE: (Internal.MangrovePropaguleBlock) & (Internal.Block);
    static STONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POTTED_CRIMSON_FUNGUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CHERRY_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static POLISHED_ANDESITE: (Internal.Block) & (Internal.Block);
    static RED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static TORCH: (Internal.TorchBlock) & (Internal.Block);
    static COAL_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_CRIMSON_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static FIRE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static WEEPING_VINES_PLANT: (Internal.WeepingVinesPlantBlock) & (Internal.Block);
    static PEONY: (Internal.TallFlowerBlock) & (Internal.Block);
    static CARROTS: (Internal.CarrotBlock) & (Internal.Block);
    static YELLOW_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CYAN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BLUE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static TUBE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static SMITHING_TABLE: (Internal.SmithingTableBlock) & (Internal.Block);
    static ACACIA_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static MAGENTA_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static POTTED_CHERRY_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static PLAYER_WALL_HEAD: (Internal.PlayerWallHeadBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static MANGROVE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SPRUCE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static IRON_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static TRIPWIRE: (Internal.TripWireBlock) & (Internal.Block);
    static BLACK_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static LIGHT_BLUE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static ACACIA_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CRIMSON_FUNGUS: (Internal.FungusBlock) & (Internal.Block);
    static BUBBLE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static LIGHT_BLUE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static PRISMARINE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static PURPLE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static RED_NETHER_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static SCULK_SENSOR: (Internal.SculkSensorBlock) & (Internal.Block);
    static YELLOW_WOOL: (Internal.Block) & (Internal.Block);
    static MAGENTA_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static SAND: (Internal.SandBlock) & (Internal.Block);
    static MYCELIUM: (Internal.MyceliumBlock) & (Internal.Block);
    static LIGHT_GRAY_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static ORANGE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CORNFLOWER: (Internal.FlowerBlock) & (Internal.Block);
    static DARK_OAK_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static GRANITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static REDSTONE_LAMP: (Internal.RedstoneLampBlock) & (Internal.Block);
    static LIGHT: (Internal.LightBlock) & (Internal.Block);
    static TUBE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static WARPED_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static DANDELION: (Internal.FlowerBlock) & (Internal.Block);
    static PINK_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WARPED_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static RED_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SOUL_SOIL: (Internal.Block) & (Internal.Block);
    static ACACIA_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static CRIMSON_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static HEAVY_WEIGHTED_PRESSURE_PLATE: (Internal.WeightedPressurePlateBlock) & (Internal.Block);
    static PRISMARINE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static TWISTING_VINES_PLANT: (Internal.TwistingVinesPlantBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WARPED_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static RED_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WARPED_WART_BLOCK: (Internal.Block) & (Internal.Block);
    static EXPOSED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static COARSE_DIRT: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_REDSTONE_ORE: (Internal.RedStoneOreBlock) & (Internal.Block);
    static TUFF: (Internal.Block) & (Internal.Block);
    static CHISELED_BOOKSHELF: (Internal.ChiseledBookShelfBlock) & (Internal.Block);
    static ACACIA_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEEPSLATE_IRON_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPLE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static LIGHTNING_ROD: (Internal.LightningRodBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static CHERRY_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LILY_PAD: (Internal.WaterlilyBlock) & (Internal.Block);
    static GREEN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static BARRIER: (Internal.BarrierBlock) & (Internal.Block);
    static PINK_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static DRAGON_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static YELLOW_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static STRIPPED_BIRCH_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SEAGRASS: (Internal.SeagrassBlock) & (Internal.Block);
    static CHERRY_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static HORN_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static MOSSY_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static SPRUCE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static WAXED_COPPER_BLOCK: (Internal.Block) & (Internal.Block);
    static STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GRANITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static NETHER_BRICK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static MOSS_CARPET: (Internal.CarpetBlock) & (Internal.Block);
    static DARK_OAK_PLANKS: (Internal.Block) & (Internal.Block);
    static MAGENTA_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static ANDESITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_NETHER_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BIRCH_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BAMBOO_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BROWN_CONCRETE: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_DIAMOND_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static BEETROOTS: (Internal.BeetrootBlock) & (Internal.Block);
    static POTTED_BAMBOO: (Internal.FlowerPotBlock) & (Internal.Block);
    static FERN: (Internal.TallGrassBlock) & (Internal.Block);
    static CRIMSON_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WAXED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static ACACIA_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BLACK_WOOL: (Internal.Block) & (Internal.Block);
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static BRAIN_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static VINE: (Internal.VineBlock) & (Internal.Block);
    static CHERRY_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static ANDESITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static INFESTED_DEEPSLATE: (Internal.InfestedRotatedPillarBlock) & (Internal.Block);
    static ACACIA_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SPONGE: (Internal.SpongeBlock) & (Internal.Block);
    static REDSTONE_ORE: (Internal.RedStoneOreBlock) & (Internal.Block);
    static STRIPPED_ACACIA_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static REDSTONE_WALL_TORCH: (Internal.RedstoneWallTorchBlock) & (Internal.Block);
    static CYAN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BLACK_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static CAMPFIRE: (Internal.CampfireBlock) & (Internal.Block);
    static OCHRE_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static COBBLESTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DRAGON_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static POTTED_WITHER_ROSE: (Internal.FlowerPotBlock) & (Internal.Block);
    static BLACKSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GRAY_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CYAN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static BAMBOO_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static BIRCH_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static POTTED_CORNFLOWER: (Internal.FlowerPotBlock) & (Internal.Block);
    static STICKY_PISTON: (Internal.PistonBaseBlock) & (Internal.Block);
    static LIGHT_BLUE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WEATHERED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static CYAN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static RAW_GOLD_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_BIRCH_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LARGE_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static POLISHED_ANDESITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_PORTAL: (Internal.NetherPortalBlock) & (Internal.Block);
    static JUNGLE_PLANKS: (Internal.Block) & (Internal.Block);
    static PINK_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STRIPPED_WARPED_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static POTTED_OAK_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static MANGROVE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static DARK_OAK_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static ORANGE_CONCRETE: (Internal.Block) & (Internal.Block);
    static BLUE_ORCHID: (Internal.FlowerBlock) & (Internal.Block);
    static STRIPPED_BAMBOO_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BIRCH_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GRAY_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static DEEPSLATE_TILES: (Internal.Block) & (Internal.Block);
    static CRIMSON_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static WHITE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static KELP: (Internal.KelpBlock) & (Internal.Block);
    static BROWN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static INFESTED_CRACKED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static JUNGLE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static LIGHT_GRAY_CONCRETE: (Internal.Block) & (Internal.Block);
    static RED_MUSHROOM_BLOCK: (Internal.HugeMushroomBlock) & (Internal.Block);
    static GRAY_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static MOSS_BLOCK: (Internal.MossBlock) & (Internal.Block);
    static LIME_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static CRIMSON_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CARVED_PUMPKIN: (Internal.EquipableCarvedPumpkinBlock) & (Internal.Block);
    static POTATOES: (Internal.PotatoBlock) & (Internal.Block);
    static PURPUR_PILLAR: (Internal.RotatedPillarBlock) & (Internal.Block);
    static MUD_BRICKS: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static MANGROVE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHERRY_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static NOTE_BLOCK: (Internal.NoteBlock) & (Internal.Block);
    static ENDER_CHEST: (Internal.EnderChestBlock) & (Internal.Block);
    static CYAN_BED: (Internal.BedBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static BIRCH_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static YELLOW_CONCRETE: (Internal.Block) & (Internal.Block);
    static DEAD_TUBE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_WARPED_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LEVER: (Internal.LeverBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static LIGHT_BLUE_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_MANGROVE_PROPAGULE: (Internal.FlowerPotBlock) & (Internal.Block);
    static DROPPER: (Internal.DropperBlock) & (Internal.Block);
    static SPRUCE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static RED_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CRAFTING_TABLE: (Internal.CraftingTableBlock) & (Internal.Block);
    static SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GRASS: (Internal.TallGrassBlock) & (Internal.Block);
    static CHERRY_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MEDIUM_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static CRIMSON_ROOTS: (Internal.RootsBlock) & (Internal.Block);
    static WITHER_ROSE: (Internal.WitherRoseBlock) & (Internal.Block);
    static OXEYE_DAISY: (Internal.FlowerBlock) & (Internal.Block);
    static OAK_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static EMERALD_BLOCK: (Internal.Block) & (Internal.Block);
    static BUDDING_AMETHYST: (Internal.BuddingAmethystBlock) & (Internal.Block);
    static RAIL: (Internal.RailBlock) & (Internal.Block);
    static JUNGLE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BROWN_MUSHROOM_BLOCK: (Internal.HugeMushroomBlock) & (Internal.Block);
    static DARK_OAK_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static DIAMOND_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LADDER: (Internal.LadderBlock) & (Internal.Block);
    static OAK_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static MELON: (Internal.MelonBlock) & (Internal.Block);
    static CRIMSON_PLANKS: (Internal.Block) & (Internal.Block);
    static GLOW_LICHEN: (Internal.GlowLichenBlock) & (Internal.Block);
    static REDSTONE_WIRE: (Internal.RedStoneWireBlock) & (Internal.Block);
    static HORN_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static DARK_PRISMARINE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CAVE_VINES_PLANT: (Internal.CaveVinesPlantBlock) & (Internal.Block);
    static ACACIA_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static YELLOW_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_WALL: (Internal.WallBlock) & (Internal.Block);
    static CRIMSON_NYLIUM: (Internal.NyliumBlock) & (Internal.Block);
    static POTTED_BLUE_ORCHID: (Internal.FlowerPotBlock) & (Internal.Block);
    static CYAN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static SCULK_CATALYST: (Internal.SculkCatalystBlock) & (Internal.Block);
    static STRIPPED_MANGROVE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DISPENSER: (Internal.DispenserBlock) & (Internal.Block);
    static PRISMARINE_WALL: (Internal.WallBlock) & (Internal.Block);
    static ORANGE_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static BLACK_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static SPORE_BLOSSOM: (Internal.SporeBlossomBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static DEEPSLATE_TILE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static JUNGLE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DIRT_PATH: (Internal.DirtPathBlock) & (Internal.Block);
    static BLUE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GREEN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static HONEYCOMB_BLOCK: (Internal.Block) & (Internal.Block);
    static ICE: (Internal.IceBlock) & (Internal.Block);
    static BAMBOO_MOSAIC_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POTTED_BIRCH_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static WHITE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WATER: (Internal.LiquidBlock) & (Internal.Block);
    static CRACKED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static WATER_CAULDRON: (Internal.LayeredCauldronBlock) & (Internal.Block);
    static MUD_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WAXED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_WALL: (Internal.WallBlock) & (Internal.Block);
    static OAK_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static OAK_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static POTTED_BROWN_MUSHROOM: (Internal.FlowerPotBlock) & (Internal.Block);
    static WARPED_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static JUKEBOX: (Internal.JukeboxBlock) & (Internal.Block);
    static MANGROVE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static PLAYER_HEAD: (Internal.PlayerHeadBlock) & (Internal.Block);
    static PURPLE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BIRCH_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POWDER_SNOW_CAULDRON: (Internal.PowderSnowCauldronBlock) & (Internal.Block);
    static BROWN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static BREWING_STAND: (Internal.BrewingStandBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static REDSTONE_TORCH: (Internal.RedstoneTorchBlock) & (Internal.Block);
    static BAMBOO_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static BLACK_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static POLISHED_GRANITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MAGENTA_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BLACK_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static NETHER_SPROUTS: (Internal.NetherSproutsBlock) & (Internal.Block);
    static GREEN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static SPRUCE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PURPLE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static CONDUIT: (Internal.ConduitBlock) & (Internal.Block);
    static ORANGE_WOOL: (Internal.Block) & (Internal.Block);
    static POTTED_WHITE_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static PRISMARINE_BRICKS: (Internal.Block) & (Internal.Block);
    static POLISHED_BLACKSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static SEA_LANTERN: (Internal.Block) & (Internal.Block);
    static MAGENTA_BED: (Internal.BedBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STONE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static SCAFFOLDING: (Internal.ScaffoldingBlock) & (Internal.Block);
    static NETHER_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DIORITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static PISTON_HEAD: (Internal.PistonHeadBlock) & (Internal.Block);
    static BLACK_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PURPLE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static LIME_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static OAK_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static CUT_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static LIME_BED: (Internal.BedBlock) & (Internal.Block);
    static SPAWNER: (Internal.SpawnerBlock) & (Internal.Block);
    static FROSTED_ICE: (Internal.FrostedIceBlock) & (Internal.Block);
    static IRON_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static WARPED_ROOTS: (Internal.RootsBlock) & (Internal.Block);
    static STONE: (Internal.Block) & (Internal.Block);
    static MUD_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SOUL_LANTERN: (Internal.LanternBlock) & (Internal.Block);
    static COPPER_BLOCK: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static WAXED_OXIDIZED_COPPER: (Internal.Block) & (Internal.Block);
    static WARPED_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POLISHED_BASALT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DAYLIGHT_DETECTOR: (Internal.DaylightDetectorBlock) & (Internal.Block);
    static CRIMSON_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CHERRY_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GOLD_BLOCK: (Internal.Block) & (Internal.Block);
    static POTTED_LILY_OF_THE_VALLEY: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIGHT_BLUE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static LIGHT_GRAY_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static DRIPSTONE_BLOCK: (Internal.Block) & (Internal.Block);
    static COBBLED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static BIG_DRIPLEAF: (Internal.BigDripleafBlock) & (Internal.Block);
    static MANGROVE_LEAVES: (Internal.MangroveLeavesBlock) & (Internal.Block);
    static GRAY_WOOL: (Internal.Block) & (Internal.Block);
    static INFESTED_CHISELED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static GRAY_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static CHERRY_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static REPEATING_COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static WARPED_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static RED_BED: (Internal.BedBlock) & (Internal.Block);
    static CHERRY_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static POTTED_DANDELION: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_CACTUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static DIORITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static HOPPER: (Internal.HopperBlock) & (Internal.Block);
    static SPRUCE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static BARREL: (Internal.BarrelBlock) & (Internal.Block);
    static MELON_STEM: (Internal.StemBlock) & (Internal.Block);
    static ROOTED_DIRT: (Internal.RootedDirtBlock) & (Internal.Block);
    static LIGHT_BLUE_WOOL: (Internal.Block) & (Internal.Block);
    static SOUL_WALL_TORCH: (Internal.WallTorchBlock) & (Internal.Block);
    static LAPIS_BLOCK: (Internal.Block) & (Internal.Block);
    static ANDESITE: (Internal.Block) & (Internal.Block);
    static YELLOW_BED: (Internal.BedBlock) & (Internal.Block);
    static END_STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BLAST_FURNACE: (Internal.BlastFurnaceBlock) & (Internal.Block);
    static SMALL_DRIPLEAF: (Internal.SmallDripleafBlock) & (Internal.Block);
    static KELP_PLANT: (Internal.KelpPlantBlock) & (Internal.Block);
    static RED_SAND: (Internal.SandBlock) & (Internal.Block);
    static JUNGLE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static QUARTZ_BRICKS: (Internal.Block) & (Internal.Block);
    static CRIMSON_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static ZOMBIE_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static LIME_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static RAW_COPPER_BLOCK: (Internal.Block) & (Internal.Block);
    static CHERRY_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static ORANGE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static LOOM: (Internal.LoomBlock) & (Internal.Block);
    static GREEN_WOOL: (Internal.Block) & (Internal.Block);
    static BROWN_WOOL: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static PIGLIN_WALL_HEAD: (Internal.PiglinWallSkullBlock) & (Internal.Block);
    static BLUE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static PINK_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static SMOKER: (Internal.SmokerBlock) & (Internal.Block);
    static ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static BROWN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static FLOWER_POT: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIGHT_BLUE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STONECUTTER: (Internal.StonecutterBlock) & (Internal.Block);
    static CUT_RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_CONCRETE: (Internal.Block) & (Internal.Block);
    static DARK_OAK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static GREEN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BAMBOO: (Internal.BambooStalkBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static DARK_OAK_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static MAGENTA_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static DARK_OAK_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static CHISELED_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static CRIMSON_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static PITCHER_CROP: (Internal.PitcherCropBlock) & (Internal.Block);
    static CHERRY_LEAVES: (Internal.CherryLeavesBlock) & (Internal.Block);
    static RED_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static QUARTZ_PILLAR: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHISELED_POLISHED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static PURPLE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static RED_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static AMETHYST_CLUSTER: (Internal.AmethystClusterBlock) & (Internal.Block);
    static DARK_PRISMARINE: (Internal.Block) & (Internal.Block);
    static MANGROVE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SCULK_VEIN: (Internal.SculkVeinBlock) & (Internal.Block);
    static JUNGLE_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static YELLOW_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static OBSERVER: (Internal.ObserverBlock) & (Internal.Block);
    static END_STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SPRUCE_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static MANGROVE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BAMBOO_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static SPRUCE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static NETHER_WART: (Internal.NetherWartBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static OBSIDIAN: (Internal.Block) & (Internal.Block);
    static PURPLE_CONCRETE: (Internal.Block) & (Internal.Block);
    static BLACK_CONCRETE: (Internal.Block) & (Internal.Block);
    static WARPED_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static REINFORCED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static DRAGON_EGG: (Internal.DragonEggBlock) & (Internal.Block);
    static PACKED_MUD: (Internal.Block) & (Internal.Block);
    static ACACIA_PLANKS: (Internal.Block) & (Internal.Block);
    static RED_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static DARK_OAK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_WEIGHTED_PRESSURE_PLATE: (Internal.WeightedPressurePlateBlock) & (Internal.Block);
    static FIRE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static QUARTZ_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static PURPUR_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STRIPPED_JUNGLE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static RED_WOOL: (Internal.Block) & (Internal.Block);
    static FARMLAND: (Internal.FarmBlock) & (Internal.Block);
    static DARK_OAK_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static ORANGE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LIGHT_BLUE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BRICKS: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CAKE: (Internal.CakeBlock) & (Internal.Block);
    static GREEN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static JUNGLE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static BLUE_BED: (Internal.BedBlock) & (Internal.Block);
    static OAK_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static MANGROVE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static DEEPSLATE_BRICKS: (Internal.Block) & (Internal.Block);
    static BASALT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static REPEATER: (Internal.RepeaterBlock) & (Internal.Block);
    static PURPLE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static AZURE_BLUET: (Internal.FlowerBlock) & (Internal.Block);
    static LILY_OF_THE_VALLEY: (Internal.FlowerBlock) & (Internal.Block);
    static STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BIRCH_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static BIRCH_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_BLUE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BROWN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static FIRE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static SANDSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static RESPAWN_ANCHOR: (Internal.RespawnAnchorBlock) & (Internal.Block);
    static PRISMARINE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHERRACK: (Internal.NetherrackBlock) & (Internal.Block);
    static CAVE_VINES: (Internal.CaveVinesBlock) & (Internal.Block);
    static WARPED_NYLIUM: (Internal.NyliumBlock) & (Internal.Block);
    static POTTED_POPPY: (Internal.FlowerPotBlock) & (Internal.Block);
    static POINTED_DRIPSTONE: (Internal.PointedDripstoneBlock) & (Internal.Block);
    static ORANGE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static LIGHT_GRAY_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICKS: (Internal.Block) & (Internal.Block);
    static GLASS: (Internal.GlassBlock) & (Internal.Block);
    static WARPED_PLANKS: (Internal.Block) & (Internal.Block);
    static WET_SPONGE: (Internal.WetSpongeBlock) & (Internal.Block);
    static GRASS_BLOCK: (Internal.GrassBlock) & (Internal.Block);
    static COAL_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPUR_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WARPED_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEEPSLATE_COPPER_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static POLISHED_DIORITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static ANCIENT_DEBRIS: (Internal.Block) & (Internal.Block);
    static GRAY_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static WHITE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static END_STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static PODZOL: (Internal.SnowyDirtBlock) & (Internal.Block);
    static CHERRY_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static COMPARATOR: (Internal.ComparatorBlock) & (Internal.Block);
    static ACACIA_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static CHISELED_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static WAXED_WEATHERED_COPPER: (Internal.Block) & (Internal.Block);
    static SUGAR_CANE: (Internal.SugarCaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static NETHERITE_BLOCK: (Internal.Block) & (Internal.Block);
    static OAK_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static WHITE_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_AZURE_BLUET: (Internal.FlowerPotBlock) & (Internal.Block);
    static SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static ORANGE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static ORANGE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BRAIN_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static PINK_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static GRAY_BED: (Internal.BedBlock) & (Internal.Block);
    static GLASS_PANE: (Internal.IronBarsBlock) & (Internal.Block);
    static GRAVEL: (Internal.GravelBlock) & (Internal.Block);
    static BAMBOO_MOSAIC: (Internal.Block) & (Internal.Block);
    static SUSPICIOUS_GRAVEL: (Internal.BrushableBlock) & (Internal.Block);
    static ENCHANTING_TABLE: (Internal.EnchantmentTableBlock) & (Internal.Block);
    static LILAC: (Internal.TallFlowerBlock) & (Internal.Block);
    static STRIPPED_SPRUCE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static MANGROVE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static RED_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static STRIPPED_JUNGLE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static ALLIUM: (Internal.FlowerBlock) & (Internal.Block);
    static MUD_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static LIGHT_GRAY_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static ZOMBIE_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static WHITE_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static PINK_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static CRACKED_DEEPSLATE_BRICKS: (Internal.Block) & (Internal.Block);
    static WHITE_WOOL: (Internal.Block) & (Internal.Block);
    static GREEN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static GRAY_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BLACK_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static TUBE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static JUNGLE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static CUT_SANDSTONE: (Internal.Block) & (Internal.Block);
    static POLISHED_GRANITE: (Internal.Block) & (Internal.Block);
    static DARK_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SKELETON_WALL_SKULL: (Internal.WallSkullBlock) & (Internal.Block);
    static TALL_GRASS: (Internal.DoublePlantBlock) & (Internal.Block);
    static POTTED_JUNGLE_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static YELLOW_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static PEARLESCENT_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DARK_OAK_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static MAGENTA_WOOL: (Internal.Block) & (Internal.Block);
    static PUMPKIN_STEM: (Internal.StemBlock) & (Internal.Block);
    static MUD: (Internal.MudBlock) & (Internal.Block);
    static GRINDSTONE: (Internal.GrindstoneBlock) & (Internal.Block);
    static LIGHT_BLUE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BAMBOO_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static BLUE_ICE: (Internal.HalfTransparentBlock) & (Internal.Block);
    static BROWN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static FLOWERING_AZALEA: (Internal.AzaleaBlock) & (Internal.Block);
    static CHERRY_PLANKS: (Internal.Block) & (Internal.Block);
    static PACKED_ICE: (Internal.Block) & (Internal.Block);
    static ACACIA_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static GRAY_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static DARK_OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLUE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static ORANGE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BEEHIVE: (Internal.BeehiveBlock) & (Internal.Block);
    static PURPLE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static BLUE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static BLACK_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WHITE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static NETHER_GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LODESTONE: (Internal.Block) & (Internal.Block);
    static WEEPING_VINES: (Internal.WeepingVinesBlock) & (Internal.Block);
    static MAGENTA_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static OAK_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static END_PORTAL: (Internal.EndPortalBlock) & (Internal.Block);
    static TINTED_GLASS: (Internal.TintedGlassBlock) & (Internal.Block);
    static LIME_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static SKELETON_SKULL: (Internal.SkullBlock) & (Internal.Block);
    static LIME_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static END_STONE: (Internal.Block) & (Internal.Block);
    static JUNGLE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static TWISTING_VINES: (Internal.TwistingVinesBlock) & (Internal.Block);
    static END_PORTAL_FRAME: (Internal.EndPortalFrameBlock) & (Internal.Block);
    static CRIMSON_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SPRUCE_PLANKS: (Internal.Block) & (Internal.Block);
    static POLISHED_GRANITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static YELLOW_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SNIFFER_EGG: (Internal.SnifferEggBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CHERRY_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static ORANGE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static LIGHT_BLUE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static ACACIA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static GRAY_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static GRAY_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BIRCH_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CRACKED_DEEPSLATE_TILES: (Internal.Block) & (Internal.Block);
    static HANGING_ROOTS: (Internal.HangingRootsBlock) & (Internal.Block);
    static TURTLE_EGG: (Internal.TurtleEggBlock) & (Internal.Block);
    static BLACKSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static BAMBOO_SAPLING: (Internal.BambooSaplingBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WHITE_BED: (Internal.BedBlock) & (Internal.Block);
    static CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static DETECTOR_RAIL: (Internal.DetectorRailBlock) & (Internal.Block);
    static COPPER_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static CAULDRON: (Internal.CauldronBlock) & (Internal.Block);
    static LANTERN: (Internal.LanternBlock) & (Internal.Block);
    static GLOWSTONE: (Internal.Block) & (Internal.Block);
    static YELLOW_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static VOID_AIR: (Internal.AirBlock) & (Internal.Block);
    static PURPUR_BLOCK: (Internal.Block) & (Internal.Block);
    static INFESTED_STONE: (Internal.InfestedBlock) & (Internal.Block);
    static CHAIN: (Internal.ChainBlock) & (Internal.Block);
    static STRIPPED_SPRUCE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static OAK_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static OAK_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static MAGMA_BLOCK: (Internal.MagmaBlock) & (Internal.Block);
    static DIORITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static RED_SANDSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static LAPIS_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static SPRUCE_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static SMOOTH_STONE: (Internal.Block) & (Internal.Block);
    static BUBBLE_COLUMN: (Internal.BubbleColumnBlock) & (Internal.Block);
    static CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static POLISHED_DIORITE: (Internal.Block) & (Internal.Block);
    static BIRCH_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static AIR: (Internal.AirBlock) & (Internal.Block);
    static AZALEA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static WHITE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static CAVE_AIR: (Internal.AirBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE: (Internal.Block) & (Internal.Block);
    static OAK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static BAMBOO_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static EMERALD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static CYAN_WOOL: (Internal.Block) & (Internal.Block);
    static BIRCH_PLANKS: (Internal.Block) & (Internal.Block);
    static POTTED_ORANGE_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_WARPED_ROOTS: (Internal.FlowerPotBlock) & (Internal.Block);
    static SPRUCE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static DARK_PRISMARINE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static SMALL_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static SPRUCE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WITHER_SKELETON_SKULL: (Internal.WitherSkullBlock) & (Internal.Block);
    static BUBBLE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static CREEPER_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static STRIPPED_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static ACACIA_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHAIN_COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static PIGLIN_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static MANGROVE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static INFESTED_MOSSY_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static BROWN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BLUE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static ACACIA_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static CYAN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static FLETCHING_TABLE: (Internal.FletchingTableBlock) & (Internal.Block);
    static TORCHFLOWER_CROP: (Internal.TorchflowerCropBlock) & (Internal.Block);
    static GRAY_CONCRETE: (Internal.Block) & (Internal.Block);
    static WARPED_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static HORN_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static BROWN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static END_GATEWAY: (Internal.EndGatewayBlock) & (Internal.Block);
    static DEEPSLATE_TILE_WALL: (Internal.WallBlock) & (Internal.Block);
    static POTTED_ALLIUM: (Internal.FlowerPotBlock) & (Internal.Block);
    static COBBLESTONE: (Internal.Block) & (Internal.Block);
    static OAK_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CALCITE: (Internal.Block) & (Internal.Block);
    static MANGROVE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static POTTED_OXEYE_DAISY: (Internal.FlowerPotBlock) & (Internal.Block);
    static FIRE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static STRIPPED_CRIMSON_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BIRCH_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static TERRACOTTA: (Internal.Block) & (Internal.Block);
    static JUNGLE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static CYAN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BAMBOO_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static END_ROD: (Internal.EndRodBlock) & (Internal.Block);
    static LIGHT_BLUE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SMOOTH_QUARTZ: (Internal.Block) & (Internal.Block);
    static PRISMARINE: (Internal.Block) & (Internal.Block);
    static SMOOTH_QUARTZ_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static NETHER_QUARTZ_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static MUDDY_MANGROVE_ROOTS: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LIGHT_GRAY_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static MANGROVE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static DEEPSLATE_TILE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static ATTACHED_PUMPKIN_STEM: (Internal.AttachedStemBlock) & (Internal.Block);
    static CYAN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static OXIDIZED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static COCOA: (Internal.CocoaBlock) & (Internal.Block);
    static JUNGLE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static BIRCH_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static SPRUCE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POTTED_RED_MUSHROOM: (Internal.FlowerPotBlock) & (Internal.Block);
    static MAGENTA_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static JUNGLE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WARPED_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CRIMSON_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CHEST: (Internal.ChestBlock) & (Internal.Block);
    static SPRUCE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BLACKSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIME_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static GILDED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static SUNFLOWER: (Internal.TallFlowerBlock) & (Internal.Block);
    static ORANGE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static VERDANT_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PETRIFIED_OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_NETHER_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DRIED_KELP_BLOCK: (Internal.Block) & (Internal.Block);
    static BONE_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WHITE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static POTTED_SPRUCE_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static DEAD_HORN_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BUBBLE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static GREEN_CONCRETE: (Internal.Block) & (Internal.Block);
    static CHORUS_FLOWER: (Internal.ChorusFlowerBlock) & (Internal.Block);
    static GRAY_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static YELLOW_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static LIGHT_GRAY_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PINK_WOOL: (Internal.Block) & (Internal.Block);
    static PINK_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static CYAN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DARK_OAK_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POWERED_RAIL: (Internal.PoweredRailBlock) & (Internal.Block);
    static LIGHT_BLUE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static POWDER_SNOW: (Internal.PowderSnowBlock) & (Internal.Block);
    static ORANGE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static PINK_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BLACK_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SPRUCE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static GRAY_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static WARPED_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static JIGSAW: (Internal.JigsawBlock) & (Internal.Block);
    static WHITE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SPRUCE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIGHT_GRAY_WOOL: (Internal.Block) & (Internal.Block);
    static PISTON: (Internal.PistonBaseBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static DIRT: (Internal.Block) & (Internal.Block);
    static BLUE_CONCRETE: (Internal.Block) & (Internal.Block);
    static RED_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static TALL_SEAGRASS: (Internal.TallSeagrassBlock) & (Internal.Block);
    static CHORUS_PLANT: (Internal.ChorusPlantBlock) & (Internal.Block);
    static PINK_CONCRETE: (Internal.Block) & (Internal.Block);
    static WHITE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static MOVING_PISTON: (Internal.MovingPistonBlock) & (Internal.Block);
    static CHERRY_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static MANGROVE_ROOTS: (Internal.MangroveRootsBlock) & (Internal.Block);
    static POTTED_ACACIA_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static MANGROVE_PLANKS: (Internal.Block) & (Internal.Block);
    static ACACIA_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static BAMBOO_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static RED_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BLUE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static BELL: (Internal.BellBlock) & (Internal.Block);
    static MUSHROOM_STEM: (Internal.HugeMushroomBlock) & (Internal.Block);
    static EXPOSED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static CYAN_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_CRIMSON_ROOTS: (Internal.FlowerPotBlock) & (Internal.Block);
    static GREEN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static CHISELED_QUARTZ_BLOCK: (Internal.Block) & (Internal.Block);
    static JUNGLE_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static FROGSPAWN: (Internal.FrogspawnBlock) & (Internal.Block);
    static SOUL_TORCH: (Internal.TorchBlock) & (Internal.Block);
    static BOOKSHELF: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_COPPER: (Internal.Block) & (Internal.Block);
    static CRIMSON_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static DIAMOND_BLOCK: (Internal.Block) & (Internal.Block);
    static RED_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static CRIMSON_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MAGENTA_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static STRIPPED_DARK_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static SPRUCE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BLUE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static STRIPPED_CHERRY_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CALIBRATED_SCULK_SENSOR: (Internal.CalibratedSculkSensorBlock) & (Internal.Block);
    static AMETHYST_BLOCK: (Internal.AmethystBlock) & (Internal.Block);
    static STRUCTURE_BLOCK: (Internal.StructureBlock) & (Internal.Block);
    static BAMBOO_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BRAIN_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static BAMBOO_MOSAIC_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STRIPPED_DARK_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BLUE_WOOL: (Internal.Block) & (Internal.Block);
    static IRON_BARS: (Internal.IronBarsBlock) & (Internal.Block);
    static IRON_BLOCK: (Internal.Block) & (Internal.Block);
    static SUSPICIOUS_SAND: (Internal.BrushableBlock) & (Internal.Block);
    static HORN_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static MAGENTA_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static HONEY_BLOCK: (Internal.HoneyBlock) & (Internal.Block);
    static END_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static JACK_O_LANTERN: (Internal.CarvedPumpkinBlock) & (Internal.Block);
    static TARGET: (Internal.TargetBlock) & (Internal.Block);
    static BRAIN_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static DEAD_FIRE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLUE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WITHER_SKELETON_WALL_SKULL: (Internal.WitherWallSkullBlock) & (Internal.Block);
    static CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static BIRCH_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static ROSE_BUSH: (Internal.TallFlowerBlock) & (Internal.Block);
    static YELLOW_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static LECTERN: (Internal.LecternBlock) & (Internal.Block);
    static CRIMSON_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static DAMAGED_ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static POLISHED_DIORITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static HAY_BLOCK: (Internal.HayBlock) & (Internal.Block);
    static WARPED_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHERRY_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static MANGROVE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WEATHERED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static LIME_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static TRIPWIRE_HOOK: (Internal.TripWireHookBlock) & (Internal.Block);
    static CLAY: (Internal.Block) & (Internal.Block);
    static SNOW: (Internal.SnowLayerBlock) & (Internal.Block);
    static WHEAT: (Internal.CropBlock) & (Internal.Block);
    static CYAN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static WEATHERED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static BROWN_MUSHROOM: (Internal.MushroomBlock) & (Internal.Block);
    static SHROOMLIGHT: (Internal.Block) & (Internal.Block);
    static CRIMSON_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static PRISMARINE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POPPY: (Internal.FlowerBlock) & (Internal.Block);
    static STRUCTURE_VOID: (Internal.StructureVoidBlock) & (Internal.Block);
    static ORANGE_BED: (Internal.BedBlock) & (Internal.Block);
    static DEEPSLATE_COAL_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPLE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static REDSTONE_BLOCK: (Internal.PoweredBlock) & (Internal.Block);
    static BLACK_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static WAXED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GREEN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static POTTED_AZALEA: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIME_CONCRETE: (Internal.Block) & (Internal.Block);
    static BAMBOO_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PURPLE_WOOL: (Internal.Block) & (Internal.Block);
    static SOUL_FIRE: (Internal.SoulFireBlock) & (Internal.Block);
    static CHISELED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: (Internal.Block) & (Internal.Block);
    static PINK_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static CARTOGRAPHY_TABLE: (Internal.CartographyTableBlock) & (Internal.Block);
    static BLACK_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GREEN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static CYAN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static QUARTZ_BLOCK: (Internal.Block) & (Internal.Block);
    static BAMBOO_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static WHITE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static WARPED_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static COMPOSTER: (Internal.ComposterBlock) & (Internal.Block);
    static DARK_OAK_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static ACACIA_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static PITCHER_PLANT: (Internal.DoublePlantBlock) & (Internal.Block);
    static CHISELED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static POTTED_PINK_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static LARGE_FERN: (Internal.DoublePlantBlock) & (Internal.Block);
    static TNT: (Internal.TntBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WARPED_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static SMOOTH_QUARTZ_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LAVA_CAULDRON: (Internal.LavaCauldronBlock) & (Internal.Block);
    static SCULK_SHRIEKER: (Internal.SculkShriekerBlock) & (Internal.Block);
    static BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static CHISELED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static AZALEA: (Internal.AzaleaBlock) & (Internal.Block);
    static SMOOTH_STONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static JUNGLE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static LIME_WOOL: (Internal.Block) & (Internal.Block);
    static LIME_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static GREEN_BED: (Internal.BedBlock) & (Internal.Block);
    static ACTIVATOR_RAIL: (Internal.PoweredRailBlock) & (Internal.Block);
    static SEA_PICKLE: (Internal.SeaPickleBlock) & (Internal.Block);
    static PINK_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static BLUE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WEATHERED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static CRACKED_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static FURNACE: (Internal.FurnaceBlock) & (Internal.Block);
    static COBBLESTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MANGROVE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static CHERRY_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BAMBOO_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_GRAY_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static MANGROVE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static COBBLESTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static BEDROCK: (Internal.Block) & (Internal.Block);
    static BIRCH_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static PURPLE_BED: (Internal.BedBlock) & (Internal.Block);
    static LIME_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static SCULK: (Internal.SculkBlock) & (Internal.Block);
    static ACACIA_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static COBWEB: (Internal.WebBlock) & (Internal.Block);
    static CRIMSON_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_BED: (Internal.BedBlock) & (Internal.Block);
    static STRIPPED_ACACIA_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BEE_NEST: (Internal.BeehiveBlock) & (Internal.Block);
    static LAVA: (Internal.LiquidBlock) & (Internal.Block);
    static POTTED_WARPED_FUNGUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static NETHER_WART_BLOCK: (Internal.Block) & (Internal.Block);
    static TORCHFLOWER: (Internal.FlowerBlock) & (Internal.Block);
    static ATTACHED_MELON_STEM: (Internal.AttachedStemBlock) & (Internal.Block);
    static DEEPSLATE_EMERALD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static BROWN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static POTTED_DARK_OAK_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_FERN: (Internal.FlowerPotBlock) & (Internal.Block);
    static PUMPKIN: (Internal.PumpkinBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static RED_MUSHROOM: (Internal.MushroomBlock) & (Internal.Block);
    static BROWN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PURPLE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static ORANGE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static RAW_IRON_BLOCK: (Internal.Block) & (Internal.Block);
    static WALL_TORCH: (Internal.WallTorchBlock) & (Internal.Block);
    static CACTUS: (Internal.CactusBlock) & (Internal.Block);
    static FIRE: (Internal.FireBlock) & (Internal.Block);
    static SLIME_BLOCK: (Internal.SlimeBlock) & (Internal.Block);
    static CHIPPED_ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static QUARTZ_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIGHT_BLUE_BED: (Internal.BedBlock) & (Internal.Block);
    static GREEN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static JUNGLE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static SOUL_SAND: (Internal.SoulSandBlock) & (Internal.Block);
    static CUT_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MAGENTA_CONCRETE: (Internal.Block) & (Internal.Block);
    static GRANITE: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SMOOTH_BASALT: (Internal.Block) & (Internal.Block);
    static DEAD_BUSH: (Internal.DeadBushBlock) & (Internal.Block);
    static DARK_OAK_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static SOUL_CAMPFIRE: (Internal.CampfireBlock) & (Internal.Block);
    static MAGENTA_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static SPRUCE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static CREEPER_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static BROWN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static YELLOW_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BLUE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static JUNGLE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static LIME_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static ACACIA_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static TUBE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static BROWN_BED: (Internal.BedBlock) & (Internal.Block);
    static PURPLE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static LIGHT_GRAY_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static BIG_DRIPLEAF_STEM: (Internal.BigDripleafStemBlock) & (Internal.Block);
    static LIME_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WARPED_FUNGUS: (Internal.FungusBlock) & (Internal.Block);
    static WHITE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static DARK_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static STRIPPED_MANGROVE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CRYING_OBSIDIAN: (Internal.CryingObsidianBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MAGENTA_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static POTTED_TORCHFLOWER: (Internal.FlowerPotBlock) & (Internal.Block);
    static STONE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static IRON_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static TRAPPED_CHEST: (Internal.TrappedChestBlock) & (Internal.Block);
    static LIGHT_GRAY_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static OAK_PLANKS: (Internal.Block) & (Internal.Block);
    static FLOWERING_AZALEA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static POTTED_FLOWERING_AZALEA: (Internal.FlowerPotBlock) & (Internal.Block);
    static POLISHED_ANDESITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BUBBLE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static ANDESITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static YELLOW_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BIRCH_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLACKSTONE: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_BED: (Internal.BedBlock) & (Internal.Block);
    static STRIPPED_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_PETALS: (Internal.PinkPetalsBlock) & (Internal.Block);
    static DIORITE: (Internal.Block) & (Internal.Block);
    static SWEET_BERRY_BUSH: (Internal.SweetBerryBushBlock) & (Internal.Block);
    static DECORATED_POT: (Internal.DecoratedPotBlock) & (Internal.Block);
    static INFESTED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static POTTED_RED_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static RED_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static BAMBOO_PLANKS: (Internal.Block) & (Internal.Block);
    static BIRCH_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static JUNGLE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static GREEN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BEACON: (Internal.BeaconBlock) & (Internal.Block);
    static DEEPSLATE_LAPIS_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static OAK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BIRCH_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static SANDSTONE: (Internal.Block) & (Internal.Block);
    static SNOW_BLOCK: (Internal.Block) & (Internal.Block);
    static BLACK_BED: (Internal.BedBlock) & (Internal.Block);
    static BROWN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static POTTED_DEAD_BUSH: (Internal.FlowerPotBlock) & (Internal.Block);
    static STRIPPED_CHERRY_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GRANITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DEEPSLATE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DARK_OAK_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WHITE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static BAMBOO_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static INFESTED_COBBLESTONE: (Internal.InfestedBlock) & (Internal.Block);
}
type Blocks_ = Blocks;
declare interface BlockStatePredicate extends Internal.ReplacementMatch, Internal.Predicate<Internal.BlockState> {
    fromString(s: string): this;
    ruleTestOf(o: any): Internal.RuleTest;
    asRuleTest(): Internal.RuleTest;
    getBlockIds(): Internal.Set<ResourceLocation>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    check(targetStates: Internal.List_<Internal.OreConfiguration$TargetBlockState>): boolean;
    abstract test(arg0: Internal.BlockState_): boolean;
    getBlockStates(): Internal.Collection<Internal.BlockState>;
    getBlocks(): Internal.Collection<Internal.Block>;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    testBlock(block: Internal.Block_): boolean;
    of(o: BlockStatePredicate_): this;
    test(arg0: any): boolean;
    and(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    abstract "test(net.minecraft.world.level.block.state.BlockState)"(arg0: Internal.BlockState_): boolean;
    or(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    negate(): Internal.Predicate<Internal.BlockState>;
    "test(java.lang.Object)"(arg0: any): boolean;
    get blockIds(): Internal.Set<ResourceLocation>
    get blockStates(): Internal.Collection<Internal.BlockState>
    get blocks(): Internal.Collection<Internal.Block>
    readonly AIR_ID: (ResourceLocation) & (ResourceLocation);
}
type BlockStatePredicate_ = RegExp | "-" | `#${Special.BlockTag}` | BlockStatePredicate_[] | Internal.Block_ | Internal.BlockState_ | "*" | BlockStatePredicate | {not?: BlockStatePredicate_, or?: BlockStatePredicate_};
declare const BlockStatePredicate: BlockStatePredicate;
declare class KMath {
    constructor()
    getClass(): typeof any;
    static block(x: number, y: number, z: number): BlockPos;
    static deg(value: number): number;
    static v3d(x: number, y: number, z: number): Internal.Vector3d;
    static ceil(value: number): number;
    static map(value: number, min0: number, max0: number, min1: number, max1: number): number;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static clamp(value: number, min: number, max: number): number;
    static v4f(x: number, y: number, z: number, w: number): Vec4f;
    static rad(value: number): number;
    static degreesDifference(current: number, target: number): number;
    static floor(value: number): number;
    static lerp(value: number, min: number, max: number): number;
    static v3f(x: number, y: number, z: number): Vec3f;
    toString(): string;
    notifyAll(): void;
    static m4f(): Matrix4f;
    static rotateIfNecessary(current: number, target: number, max: number): number;
    static v3(x: number, y: number, z: number): Vec3d;
    static quaternion(x: number, y: number, z: number, w: number): Quaternionf;
    hashCode(): number;
    static wrapDegrees(d: number): number;
    static m3f(): Matrix3f;
    wait(): void;
    static approachDegrees(current: number, target: number, speed: number): number;
    static clampedLerp(value: number, min: number, max: number): number;
    wait(arg0: number): void;
    static approach(current: number, target: number, speed: number): number;
    equals(arg0: any): boolean;
    static isPowerOfTwo(value: number): boolean;
    get class(): typeof any
    static readonly PI: (3.141592653589793) & (number);
    static readonly RADIANS_TO_DEGREES: (57.29577951308232) & (number);
    static readonly DEGREES_TO_RADIANS: (0.017453292519943295) & (number);
    static readonly E: (2.718281828459045) & (number);
}
type KMath_ = KMath;
declare class Items {
    constructor()
    getClass(): typeof any;
    toString(): string;
    static registerBlock(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    notifyAll(): void;
    static "registerItem(net.minecraft.resources.ResourceKey,net.minecraft.world.item.Item)"(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    static "registerItem(net.minecraft.resources.ResourceLocation,net.minecraft.world.item.Item)"(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static registerBlock(arg0: Internal.Block_): Internal.Item;
    static "registerBlock(net.minecraft.world.level.block.Block,net.minecraft.world.item.Item)"(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    static "registerBlock(net.minecraft.world.item.BlockItem)"(arg0: Internal.BlockItem_): Internal.Item;
    static registerItem(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static "registerBlock(net.minecraft.world.level.block.Block)"(arg0: Internal.Block_): Internal.Item;
    static registerItem(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static "registerItem(java.lang.String,net.minecraft.world.item.Item)"(arg0: string, arg1: Internal.Item_): Internal.Item;
    wait(): void;
    static registerBlock(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    wait(arg0: number): void;
    static registerItem(arg0: string, arg1: Internal.Item_): Internal.Item;
    equals(arg0: any): boolean;
    static registerBlock(arg0: Internal.BlockItem_): Internal.Item;
    static "registerBlock(net.minecraft.world.level.block.Block,net.minecraft.world.level.block.Block[])"(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    get class(): typeof any
    static POWERED_RAIL: (Internal.BlockItem) & (Internal.Item);
    static GUARDIAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ: (Internal.Item) & (Internal.Item);
    static TUBE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static TURTLE_EGG: (Internal.BlockItem) & (Internal.Item);
    static HANGING_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static CYAN_DYE: (Internal.DyeItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_DEEPSLATE_TILES: (Internal.BlockItem) & (Internal.Item);
    static OAK_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_ROD: (Internal.Item) & (Internal.Item);
    static GRASS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DRIED_KELP: (Internal.Item) & (Internal.Item);
    static TURTLE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GRAY_BANNER: (Internal.BannerItem) & (Internal.Item);
    static MAGENTA_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FUNGUS: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BEETROOT: (Internal.Item) & (Internal.Item);
    static LIGHT_GRAY_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GRAY_BED: (Internal.BedItem) & (Internal.Item);
    static MUDDY_MANGROVE_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static OAK_SIGN: (Internal.SignItem) & (Internal.Item);
    static ACACIA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHAIN: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_DYE: (Internal.DyeItem) & (Internal.Item);
    static STRIPPED_SPRUCE_LOG: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static DEBUG_STICK: (Internal.DebugStickItem) & (Internal.Item);
    static DUNE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static MUSIC_DISC_CAT: (Internal.RecordItem) & (Internal.Item);
    static GOLDEN_SWORD: (Internal.SwordItem) & (Internal.Item);
    static VERDANT_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static WARPED_NYLIUM: (Internal.BlockItem) & (Internal.Item);
    static TIPPED_ARROW: (Internal.TippedArrowItem) & (Internal.Item);
    static MILK_BUCKET: (Internal.MilkBucketItem) & (Internal.Item);
    static LAPIS_ORE: (Internal.BlockItem) & (Internal.Item);
    static WEEPING_VINES: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TORCHFLOWER: (Internal.BlockItem) & (Internal.Item);
    static LODESTONE: (Internal.BlockItem) & (Internal.Item);
    static IRON_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static MANGROVE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static INFESTED_STONE: (Internal.BlockItem) & (Internal.Item);
    static OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_QUARTZ: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BRUSH: (Internal.BrushItem) & (Internal.Item);
    static END_PORTAL_FRAME: (Internal.BlockItem) & (Internal.Item);
    static AZURE_BLUET: (Internal.BlockItem) & (Internal.Item);
    static NETHER_QUARTZ_ORE: (Internal.BlockItem) & (Internal.Item);
    static COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static SPRUCE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static PUMPKIN: (Internal.BlockItem) & (Internal.Item);
    static COBWEB: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CARROT: (Internal.ItemNameBlockItem) & (Internal.Item);
    static GOLDEN_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static BLACKSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static SUNFLOWER: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static COPPER_ORE: (Internal.BlockItem) & (Internal.Item);
    static CHEST: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_GRANITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static SKELETON_SKULL: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static RESPAWN_ANCHOR: (Internal.BlockItem) & (Internal.Item);
    static BUCKET: (Internal.BucketItem) & (Internal.Item);
    static ZOMBIFIED_PIGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GLASS: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static FIRE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static LAVA_BUCKET: (Internal.BucketItem) & (Internal.Item);
    static ENDER_PEARL: (Internal.EnderpearlItem) & (Internal.Item);
    static DRIED_KELP_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WILD_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static JUNGLE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BOOKSHELF: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static COBBLESTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static TWISTING_VINES: (Internal.BlockItem) & (Internal.Item);
    static GRINDSTONE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static PHANTOM_MEMBRANE: (Internal.Item) & (Internal.Item);
    static BRICK: (Internal.Item) & (Internal.Item);
    static ARCHER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static JUNGLE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static TINTED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static OAK_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static FLOWERING_AZALEA: (Internal.BlockItem) & (Internal.Item);
    static POPPED_CHORUS_FRUIT: (Internal.Item) & (Internal.Item);
    static PRISMARINE_CRYSTALS: (Internal.Item) & (Internal.Item);
    static LAPIS_LAZULI: (Internal.Item) & (Internal.Item);
    static SQUID_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_INGOT: (Internal.Item) & (Internal.Item);
    static DEEPSLATE_EMERALD_ORE: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static NETHERITE_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static CHICKEN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BEEHIVE: (Internal.BlockItem) & (Internal.Item);
    static SPYGLASS: (Internal.SpyglassItem) & (Internal.Item);
    static NETHERITE_AXE: (Internal.AxeItem) & (Internal.Item);
    static ELDER_GUARDIAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BLUE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static MULE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ORANGE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static FIREWORK_STAR: (Internal.FireworkStarItem) & (Internal.Item);
    static SPIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static SKULL_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static FROG_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DIRT: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static WOODEN_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static GLOWSTONE_DUST: (Internal.Item) & (Internal.Item);
    static ITEM_FRAME: (Internal.ItemFrameItem) & (Internal.Item);
    static MUSIC_DISC_RELIC: (Internal.RecordItem) & (Internal.Item);
    static SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_FENCE: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE: (Internal.ItemNameBlockItem) & (Internal.Item);
    static CARROT_ON_A_STICK: Internal.Item;
    static SOUL_TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static LIME_CARPET: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static SUGAR_CANE: (Internal.BlockItem) & (Internal.Item);
    static COMMAND_BLOCK_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static SMOOTH_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHEST_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static SCUTE: (Internal.Item) & (Internal.Item);
    static FEATHER: (Internal.Item) & (Internal.Item);
    static JUNGLE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CUT_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_QUARTZ_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WHITE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static COPPER_INGOT: (Internal.Item) & (Internal.Item);
    static SWEET_BERRIES: (Internal.ItemNameBlockItem) & (Internal.Item);
    static GREEN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BUBBLE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BELL: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PITCHER_POD: (Internal.ItemNameBlockItem) & (Internal.Item);
    static BLACK_DYE: (Internal.DyeItem) & (Internal.Item);
    static WHITE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static DETECTOR_RAIL: (Internal.BlockItem) & (Internal.Item);
    static TIDE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static LIME_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static PIGLIN_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static CHORUS_FLOWER: (Internal.BlockItem) & (Internal.Item);
    static WARPED_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static WARDEN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHISELED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SNOWBALL: (Internal.SnowballItem) & (Internal.Item);
    static LANTERN: (Internal.BlockItem) & (Internal.Item);
    static CYAN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static MAP: (Internal.EmptyMapItem) & (Internal.Item);
    static WHITE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_COPPER_ORE: (Internal.BlockItem) & (Internal.Item);
    static CUT_STANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BLAST_FURNACE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static CYAN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static IRON_INGOT: (Internal.Item) & (Internal.Item);
    static PINK_BANNER: (Internal.BannerItem) & (Internal.Item);
    static MAGMA_CUBE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WHITE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static TRADER_LLAMA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TNT: (Internal.BlockItem) & (Internal.Item);
    static OAK_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static CHERRY_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_FENCE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_BANNER: (Internal.BannerItem) & (Internal.Item);
    static ROTTEN_FLESH: (Internal.Item) & (Internal.Item);
    static RIB_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WRITTEN_BOOK: (Internal.WrittenBookItem) & (Internal.Item);
    static DISC_FRAGMENT_5: (Internal.DiscFragmentItem) & (Internal.Item);
    static SNIFFER_EGG: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_DYE: (Internal.DyeItem) & (Internal.Item);
    static CLAY: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static BRAIN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static SPAWNER: (Internal.BlockItem) & (Internal.Item);
    static LIME_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SCRAP: (Internal.Item) & (Internal.Item);
    static NETHER_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static STONE: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SKELETON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static AMETHYST_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static HOGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ZOGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIME_DYE: (Internal.DyeItem) & (Internal.Item);
    static IRON_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MAGENTA_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PETRIFIED_OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_SHARD: (Internal.Item) & (Internal.Item);
    static NETHER_GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BASALT: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CHERRY_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static SANDSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static ENDER_DRAGON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STRIPPED_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_GRANITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static OBSERVER: (Internal.BlockItem) & (Internal.Item);
    static GRAY_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_SWORD: (Internal.SwordItem) & (Internal.Item);
    static FOX_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHERRY_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_WOOL: (Internal.BlockItem) & (Internal.Item);
    static CALCITE: (Internal.BlockItem) & (Internal.Item);
    static PUMPKIN_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static FERMENTED_SPIDER_EYE: (Internal.Item) & (Internal.Item);
    static HEART_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static PURPLE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static MUTTON: (Internal.Item) & (Internal.Item);
    static PURPLE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static ZOMBIE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSIC_DISC_PIGSTEP: (Internal.RecordItem) & (Internal.Item);
    static REDSTONE_TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static LEATHER_LEGGINGS: (Internal.DyeableArmorItem) & (Internal.Item);
    static PIGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static RED_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static COD: (Internal.Item) & (Internal.Item);
    static MUSIC_DISC_11: (Internal.RecordItem) & (Internal.Item);
    static AZALEA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static NETHER_WART: (Internal.ItemNameBlockItem) & (Internal.Item);
    static NAME_TAG: (Internal.NameTagItem) & (Internal.Item);
    static CYAN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static JACK_O_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static WARPED_SLAB: (Internal.BlockItem) & (Internal.Item);
    static FURNACE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CARPET: (Internal.BlockItem) & (Internal.Item);
    static POWDER_SNOW_BUCKET: (Internal.SolidBucketItem) & (Internal.Item);
    static BUBBLE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static WHITE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static BOOK: (Internal.BookItem) & (Internal.Item);
    static RED_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static DARK_PRISMARINE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CRIMSON_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_BED: (Internal.BedItem) & (Internal.Item);
    static EMERALD_ORE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static COD_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DIAMOND: (Internal.Item) & (Internal.Item);
    static AZALEA: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static SPRUCE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MELON_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static WEATHERED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSIC_DISC_13: (Internal.RecordItem) & (Internal.Item);
    static LIGHT_GRAY_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_WOOD: (Internal.BlockItem) & (Internal.Item);
    static FLOWER_POT: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_WOOD: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FENCE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_POLISHED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static SEA_PICKLE: (Internal.BlockItem) & (Internal.Item);
    static LARGE_FERN: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static AMETHYST_SHARD: (Internal.Item) & (Internal.Item);
    static CHICKEN: (Internal.Item) & (Internal.Item);
    static GRAY_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static TOTEM_OF_UNDYING: (Internal.Item) & (Internal.Item);
    static STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static GREEN_BED: (Internal.BedItem) & (Internal.Item);
    static DROPPER: (Internal.BlockItem) & (Internal.Item);
    static LIME_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static KNOWLEDGE_BOOK: (Internal.KnowledgeBookItem) & (Internal.Item);
    static LOOM: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static FISHING_ROD: (Internal.FishingRodItem) & (Internal.Item);
    static BROWN_DYE: (Internal.DyeItem) & (Internal.Item);
    static MEDIUM_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static ROOTED_DIRT: (Internal.BlockItem) & (Internal.Item);
    static SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static WARPED_STEM: (Internal.BlockItem) & (Internal.Item);
    static SHEAF_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RED_SAND: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SHEARS: (Internal.ShearsItem) & (Internal.Item);
    static PANDA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static POTATO: (Internal.ItemNameBlockItem) & (Internal.Item);
    static LAPIS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static COMPOSTER: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static TROPICAL_FISH: (Internal.Item) & (Internal.Item);
    static POTION: (Internal.PotionItem) & (Internal.Item);
    static MANGROVE_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static JIGSAW: (Internal.GameMasterBlockItem) & (Internal.Item);
    static PRISMARINE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static TROPICAL_FISH_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static WARPED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static LIGHT_BLUE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_CHESTPLATE: (Internal.DyeableArmorItem) & (Internal.Item);
    static RED_BED: (Internal.BedItem) & (Internal.Item);
    static STONE_HOE: (Internal.HoeItem) & (Internal.Item);
    static JUNGLE_LOG: (Internal.BlockItem) & (Internal.Item);
    static GLOW_SQUID_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static EYE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static BROWN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PUFFERFISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static GREEN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static BREAD: (Internal.Item) & (Internal.Item);
    static COOKED_CHICKEN: (Internal.Item) & (Internal.Item);
    static BIRCH_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_SLAB: (Internal.BlockItem) & (Internal.Item);
    static GOLD_NUGGET: (Internal.Item) & (Internal.Item);
    static PHANTOM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WAXED_WEATHERED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static WHEAT_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static DEEPSLATE_TILES: (Internal.BlockItem) & (Internal.Item);
    static PORKCHOP: (Internal.Item) & (Internal.Item);
    static SCAFFOLDING: (Internal.ScaffoldingBlockItem) & (Internal.Item);
    static END_ROD: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE: (Internal.BlockItem) & (Internal.Item);
    static PACKED_MUD: (Internal.BlockItem) & (Internal.Item);
    static STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static REINFORCED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static LILY_OF_THE_VALLEY: (Internal.BlockItem) & (Internal.Item);
    static VILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STONE_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static PARROT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WHEAT: (Internal.Item) & (Internal.Item);
    static JUNGLE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_AXE: (Internal.AxeItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static NETHERRACK: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static GRAY_WOOL: (Internal.BlockItem) & (Internal.Item);
    static COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WEATHERED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_PILLAR: (Internal.BlockItem) & (Internal.Item);
    static STONE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_NETHER_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CAKE: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static FARMLAND: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static PUMPKIN_PIE: (Internal.Item) & (Internal.Item);
    static SHULKER_SHELL: (Internal.Item) & (Internal.Item);
    static OAK_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static RABBIT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIGHT_WEIGHTED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static APPLE: (Internal.Item) & (Internal.Item);
    static DIAMOND_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WARPED_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_LOG: (Internal.BlockItem) & (Internal.Item);
    static ELYTRA: (Internal.ElytraItem) & (Internal.Item);
    static WARPED_SIGN: (Internal.SignItem) & (Internal.Item);
    static GREEN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static BEE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PINK_DYE: (Internal.DyeItem) & (Internal.Item);
    static PLAYER_HEAD: (Internal.PlayerHeadItem) & (Internal.Item);
    static GLOW_LICHEN: (Internal.BlockItem) & (Internal.Item);
    static STONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static ROSE_BUSH: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static GLOW_ITEM_FRAME: (Internal.ItemFrameItem) & (Internal.Item);
    static WHITE_TULIP: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static OBSIDIAN: (Internal.BlockItem) & (Internal.Item);
    static BLADE_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static EGG: (Internal.EggItem) & (Internal.Item);
    static WITCH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static OCELOT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static HORN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHER_SPROUTS: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static TALL_GRASS: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BLACK_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SPIDER_EYE: (Internal.Item) & (Internal.Item);
    static FILLED_MAP: (Internal.MapItem) & (Internal.Item);
    static MUD_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static AXOLOTL_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static ZOMBIE_HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_PRISMARINE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_SIGN: (Internal.SignItem) & (Internal.Item);
    static STRIPPED_JUNGLE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static MUSHROOM_STEM: (Internal.BlockItem) & (Internal.Item);
    static LILAC: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BAMBOO_RAFT: (Internal.BoatItem) & (Internal.Item);
    static SUSPICIOUS_STEW: (Internal.SuspiciousStewItem) & (Internal.Item);
    static SUSPICIOUS_GRAVEL: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static IRON_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_DEEPSLATE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SHULKER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static LIGHT_GRAY_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MELON_SLICE: (Internal.Item) & (Internal.Item);
    static HONEYCOMB_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static PEARLESCENT_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static ANCIENT_DEBRIS: (Internal.BlockItem) & (Internal.Item);
    static HOPPER_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static MAGMA_CREAM: (Internal.Item) & (Internal.Item);
    static ZOMBIE_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static POLISHED_GRANITE: (Internal.BlockItem) & (Internal.Item);
    static PINK_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static HONEYCOMB: (Internal.HoneycombItem) & (Internal.Item);
    static NOTE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static RED_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static FURNACE_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static DRAGON_BREATH: (Internal.Item) & (Internal.Item);
    static CYAN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static CHORUS_PLANT: (Internal.BlockItem) & (Internal.Item);
    static WAXED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static TURTLE_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static DARK_OAK_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static COAL_ORE: (Internal.BlockItem) & (Internal.Item);
    static COAL: (Internal.Item) & (Internal.Item);
    static COAST_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static GRAY_CARPET: (Internal.BlockItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DANGER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static GREEN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static BARREL: (Internal.BlockItem) & (Internal.Item);
    static RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WHITE_DYE: (Internal.DyeItem) & (Internal.Item);
    static ORANGE_DYE: (Internal.DyeItem) & (Internal.Item);
    static ENCHANTED_BOOK: (Internal.EnchantedBookItem) & (Internal.Item);
    static SOUL_SOIL: (Internal.BlockItem) & (Internal.Item);
    static IRON_NUGGET: (Internal.Item) & (Internal.Item);
    static ENDERMITE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHERITE_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static LEVER: (Internal.BlockItem) & (Internal.Item);
    static COOKED_SALMON: (Internal.Item) & (Internal.Item);
    static CAULDRON: (Internal.Items$1) & (Internal.Item);
    static ALLIUM: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static EXPLORER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static POISONOUS_POTATO: (Internal.Item) & (Internal.Item);
    static FLOWER_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static SMOOTH_STONE: (Internal.BlockItem) & (Internal.Item);
    static WHITE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static SNORT_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_MUSHROOM_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GHAST_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHER_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static IRON_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static AXOLOTL_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ORANGE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SEA_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static STONE_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static LIME_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SHIELD: (Internal.ShieldItem) & (Internal.Item);
    static DIORITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static STONE_SWORD: (Internal.SwordItem) & (Internal.Item);
    static GOLDEN_HOE: (Internal.HoeItem) & (Internal.Item);
    static BLACK_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_ORE: (Internal.BlockItem) & (Internal.Item);
    static BLACK_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_DYE: (Internal.DyeItem) & (Internal.Item);
    static REPEATER: (Internal.BlockItem) & (Internal.Item);
    static SPECTRAL_ARROW: (Internal.SpectralArrowItem) & (Internal.Item);
    static CHERRY_SLAB: (Internal.BlockItem) & (Internal.Item);
    static LEAD: (Internal.LeadItem) & (Internal.Item);
    static WHITE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DEAD_TUBE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BROWN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static WAXED_OXIDIZED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static PINK_WOOL: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_BOAT: (Internal.BoatItem) & (Internal.Item);
    static BLACK_CARPET: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static BREWING_STAND: (Internal.BlockItem) & (Internal.Item);
    static BIG_DRIPLEAF: (Internal.Items$1) & (Internal.Item);
    static CARVED_PUMPKIN: (Internal.BlockItem) & (Internal.Item);
    static OAK_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static PINK_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DIORITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_BOAT: (Internal.BoatItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_WOOD: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_QUARTZ_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static END_STONE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_BED: (Internal.BedItem) & (Internal.Item);
    static LIGHT: (Internal.BlockItem) & (Internal.Item);
    static BONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DRIPSTONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WET_SPONGE: (Internal.BlockItem) & (Internal.Item);
    static FLINT: (Internal.Item) & (Internal.Item);
    static INFESTED_CHISELED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static GRAY_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static HUSK_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PINK_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_ICE: (Internal.BlockItem) & (Internal.Item);
    static JUKEBOX: (Internal.BlockItem) & (Internal.Item);
    static FIRE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static FIRE_CHARGE: (Internal.FireChargeItem) & (Internal.Item);
    static COOKED_MUTTON: (Internal.Item) & (Internal.Item);
    static BASALT: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static PIG_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSHROOM_STEW: (Internal.BowlFoodItem) & (Internal.Item);
    static PURPLE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static HOWL_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static SMALL_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static WEATHERED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static RED_WOOL: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PROPAGULE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static PAPER: (Internal.Item) & (Internal.Item);
    static IRON_HOE: (Internal.HoeItem) & (Internal.Item);
    static MAGENTA_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static STICKY_PISTON: (Internal.BlockItem) & (Internal.Item);
    static COMPASS: (Internal.CompassItem) & (Internal.Item);
    static RED_SANDSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static DARK_PRISMARINE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static CLAY_BALL: (Internal.Item) & (Internal.Item);
    static CYAN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static STONECUTTER: (Internal.BlockItem) & (Internal.Item);
    static MINECART: (Internal.MinecartItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RED_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SHELTER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static AIR: (Internal.AirItem) & (Internal.Item);
    static SEAGRASS: (Internal.BlockItem) & (Internal.Item);
    static GLOWSTONE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_BED: (Internal.BedItem) & (Internal.Item);
    static ANVIL: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static RAW_COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_SIGN: (Internal.SignItem) & (Internal.Item);
    static MAGENTA_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SKELETON_SKULL: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DONKEY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static WAXED_COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ENCHANTED_GOLDEN_APPLE: (Internal.EnchantedGoldenAppleItem) & (Internal.Item);
    static MANGROVE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MUD: (Internal.BlockItem) & (Internal.Item);
    static OAK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static GOAT_HORN: (Internal.InstrumentItem) & (Internal.Item);
    static HOST_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CAVE_SPIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ_PILLAR: (Internal.BlockItem) & (Internal.Item);
    static DEAD_FIRE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static SUGAR: (Internal.Item) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static SCULK_VEIN: (Internal.BlockItem) & (Internal.Item);
    static FLETCHING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_MOSSY_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static BROWN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PINK_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PLENTY_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RED_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CLOCK: (Internal.Item) & (Internal.Item);
    static GRAY_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static EMERALD: (Internal.Item) & (Internal.Item);
    static DEEPSLATE_DIAMOND_ORE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BROWN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static KELP: (Internal.BlockItem) & (Internal.Item);
    static WITHER_ROSE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static TADPOLE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OAK_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static SPRUCE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static CRAFTING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static BAKED_POTATO: (Internal.Item) & (Internal.Item);
    static MANGROVE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CYAN_BED: (Internal.BedItem) & (Internal.Item);
    static CHISELED_BOOKSHELF: (Internal.BlockItem) & (Internal.Item);
    static NAUTILUS_SHELL: (Internal.Item) & (Internal.Item);
    static SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STICK: (Internal.Item) & (Internal.Item);
    static HEAVY_WEIGHTED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static COARSE_DIRT: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_SLAB: (Internal.BlockItem) & (Internal.Item);
    static SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static LIGHTNING_ROD: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_FENCE: (Internal.BlockItem) & (Internal.Item);
    static POLAR_BEAR_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ACACIA_LOG: (Internal.BlockItem) & (Internal.Item);
    static MOJANG_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static DEEPSLATE_REDSTONE_ORE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static ENCHANTING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_ANDESITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PINK_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BREWER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static DIORITE: (Internal.BlockItem) & (Internal.Item);
    static RED_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static GRAY_DYE: (Internal.DyeItem) & (Internal.Item);
    static LIGHT_GRAY_BED: (Internal.BedItem) & (Internal.Item);
    static BAMBOO_SIGN: (Internal.SignItem) & (Internal.Item);
    static IRON_ORE: (Internal.BlockItem) & (Internal.Item);
    static SCULK_SENSOR: (Internal.BlockItem) & (Internal.Item);
    static BUNDLE: (Internal.BundleItem) & (Internal.Item);
    static STRING: (Internal.ItemNameBlockItem) & (Internal.Item);
    static STRIPPED_JUNGLE_LOG: (Internal.BlockItem) & (Internal.Item);
    static END_CRYSTAL: (Internal.EndCrystalItem) & (Internal.Item);
    static LEATHER_BOOTS: (Internal.DyeableArmorItem) & (Internal.Item);
    static SLIME_BALL: (Internal.Item) & (Internal.Item);
    static ORANGE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_IRON_ORE: (Internal.BlockItem) & (Internal.Item);
    static BOW: (Internal.BowItem) & (Internal.Item);
    static ORANGE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_ORCHID: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static LLAMA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CAMPFIRE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BUBBLE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static RED_MUSHROOM: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static SAND: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_HOE: (Internal.HoeItem) & (Internal.Item);
    static RED_MUSHROOM_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static MYCELIUM: (Internal.BlockItem) & (Internal.Item);
    static PINK_TULIP: (Internal.BlockItem) & (Internal.Item);
    static PINK_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GOAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static INFESTED_CRACKED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static RABBIT: (Internal.Item) & (Internal.Item);
    static PRISMARINE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE_LAMP: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static TUBE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static MANGROVE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static LIME_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static STRIPPED_ACACIA_WOOD: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static ARMOR_STAND: (Internal.ArmorStandItem) & (Internal.Item);
    static CHERRY_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static BROWN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static STONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static MANGROVE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static PRISMARINE_WALL: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_BANNER: (Internal.BannerItem) & (Internal.Item);
    static RED_NETHER_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static IRON_GOLEM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CRIMSON_NYLIUM: (Internal.BlockItem) & (Internal.Item);
    static FIRE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static EXPERIENCE_BOTTLE: (Internal.ExperienceBottleItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static SMITHING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_SIGN: (Internal.SignItem) & (Internal.Item);
    static YELLOW_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static VEX_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PIGLIN_BRUTE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GRAY_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static COBBLESTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_POWDER: (Internal.Item) & (Internal.Item);
    static MUSIC_DISC_MALL: (Internal.RecordItem) & (Internal.Item);
    static LARGE_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BUDDING_AMETHYST: (Internal.BlockItem) & (Internal.Item);
    static RABBIT_FOOT: (Internal.Item) & (Internal.Item);
    static BAMBOO_MOSAIC: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SKULL_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static ACACIA_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static BURN_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static BEACON: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_SPRUCE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static OAK_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CRIMSON_STEM: (Internal.BlockItem) & (Internal.Item);
    static GLOW_INK_SAC: (Internal.GlowInkSacItem) & (Internal.Item);
    static CYAN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CAMEL_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static POLISHED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static GRASS: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BROWN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_CHIRP: (Internal.RecordItem) & (Internal.Item);
    static MUSIC_DISC_FAR: (Internal.RecordItem) & (Internal.Item);
    static RED_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_WALL: (Internal.BlockItem) & (Internal.Item);
    static BLUE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static WOODEN_AXE: (Internal.AxeItem) & (Internal.Item);
    static SPORE_BLOSSOM: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CROSSBOW: (Internal.CrossbowItem) & (Internal.Item);
    static BAMBOO_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static HORN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static ORANGE_TULIP: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static GREEN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RABBIT_HIDE: (Internal.Item) & (Internal.Item);
    static COOKED_COD: (Internal.Item) & (Internal.Item);
    static BLACK_BED: (Internal.BedItem) & (Internal.Item);
    static PUFFERFISH: (Internal.Item) & (Internal.Item);
    static ENDER_EYE: (Internal.EnderEyeItem) & (Internal.Item);
    static INFESTED_COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static GOLD_INGOT: (Internal.Item) & (Internal.Item);
    static VEX_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static STRIPPED_MANGROVE_LOG: (Internal.BlockItem) & (Internal.Item);
    static ICE: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_MOSAIC_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_BANNER: (Internal.BannerItem) & (Internal.Item);
    static OAK_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static LIME_BANNER: (Internal.BannerItem) & (Internal.Item);
    static PINK_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static SMALL_DRIPLEAF: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static LILY_PAD: (Internal.PlaceOnWaterBlockItem) & (Internal.Item);
    static CREEPER_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static GLOW_BERRIES: (Internal.ItemNameBlockItem) & (Internal.Item);
    static HOPPER: (Internal.BlockItem) & (Internal.Item);
    static PUFFERFISH_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static PURPLE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static HAY_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static HEART_OF_THE_SEA: (Internal.Item) & (Internal.Item);
    static WARD_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_WART_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SWORD: (Internal.SwordItem) & (Internal.Item);
    static SHEEP_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ANGLER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static PODZOL: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_HOE: (Internal.HoeItem) & (Internal.Item);
    static GRAY_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_WARPED_STEM: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SIGN: (Internal.SignItem) & (Internal.Item);
    static RABBIT_STEW: (Internal.BowlFoodItem) & (Internal.Item);
    static DEAD_TUBE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DECORATED_POT: (Internal.BlockItem) & (Internal.Item);
    static OAK_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static LIME_BED: (Internal.BedItem) & (Internal.Item);
    static TUFF: (Internal.BlockItem) & (Internal.Item);
    static GRAVEL: (Internal.BlockItem) & (Internal.Item);
    static BARRIER: (Internal.BlockItem) & (Internal.Item);
    static DRAGON_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static MUSIC_DISC_MELLOHI: (Internal.RecordItem) & (Internal.Item);
    static IRON_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static VINDICATOR_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SMOOTH_BASALT: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DROWNED_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHER_STAR: (Internal.SimpleFoiledItem) & (Internal.Item);
    static CRIMSON_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static FLINT_AND_STEEL: (Internal.FlintAndSteelItem) & (Internal.Item);
    static MAGENTA_BED: (Internal.BedItem) & (Internal.Item);
    static BONE: (Internal.Item) & (Internal.Item);
    static BROWN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CALIBRATED_SCULK_SENSOR: (Internal.BlockItem) & (Internal.Item);
    static COMPARATOR: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_HORSE_ARMOR: (Internal.DyeableHorseArmorItem) & (Internal.Item);
    static STRIPPED_BAMBOO_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static MOSS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CREEPER_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static JUNGLE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BLACK_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static COOKIE: (Internal.Item) & (Internal.Item);
    static GRANITE: (Internal.BlockItem) & (Internal.Item);
    static LEATHER: (Internal.Item) & (Internal.Item);
    static SALMON_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static DANDELION: (Internal.BlockItem) & (Internal.Item);
    static WARPED_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static PRISMARINE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static IRON_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static IRON_SWORD: (Internal.SwordItem) & (Internal.Item);
    static BONE_MEAL: (Internal.BoneMealItem) & (Internal.Item);
    static GRAY_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static DEAD_FIRE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POINTED_DRIPSTONE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static ALLAY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static COW_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ARMS_UP_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BLUE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_WARD: (Internal.RecordItem) & (Internal.Item);
    static PINK_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static BLUE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHORUS_FRUIT: (Internal.ChorusFruitItem) & (Internal.Item);
    static VINE: (Internal.BlockItem) & (Internal.Item);
    static COAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_WALL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_OTHERSIDE: (Internal.RecordItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SNOW_GOLEM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SCULK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_ANDESITE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_SIGN: (Internal.SignItem) & (Internal.Item);
    static COCOA_BEANS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static CYAN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_DYE: (Internal.DyeItem) & (Internal.Item);
    static CYAN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static GLOBE_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static SPRUCE_LOG: (Internal.BlockItem) & (Internal.Item);
    static TUBE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static GREEN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CONDUIT: (Internal.BlockItem) & (Internal.Item);
    static GLISTERING_MELON_SLICE: (Internal.Item) & (Internal.Item);
    static RAVAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SKELETON_HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BRAIN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO: (Internal.BlockItem) & (Internal.Item);
    static COOKED_PORKCHOP: (Internal.Item) & (Internal.Item);
    static GOLDEN_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static CUT_RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static BAMBOO_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_STONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static IRON_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static SMOKER: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_BIRCH_WOOD: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MOSS_CARPET: (Internal.BlockItem) & (Internal.Item);
    static FIREWORK_ROCKET: (Internal.FireworkRocketItem) & (Internal.Item);
    static OCHRE_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static TADPOLE_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static DRAGON_EGG: (Internal.BlockItem) & (Internal.Item);
    static PRIZE_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static DARK_OAK_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static COOKED_RABBIT: (Internal.Item) & (Internal.Item);
    static CHERRY_BOAT: (Internal.BoatItem) & (Internal.Item);
    static END_STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static GREEN_DYE: (Internal.DyeItem) & (Internal.Item);
    static MUSIC_DISC_WAIT: (Internal.RecordItem) & (Internal.Item);
    static RED_NETHER_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static PITCHER_PLANT: (Internal.BlockItem) & (Internal.Item);
    static LIME_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static AMETHYST_CLUSTER: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_COAL_ORE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_MANGROVE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static STONE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static RED_DYE: (Internal.DyeItem) & (Internal.Item);
    static SPLASH_POTION: (Internal.SplashPotionItem) & (Internal.Item);
    static PURPLE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static STRIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OXEYE_DAISY: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PINK_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CHERRY_WOOD: (Internal.BlockItem) & (Internal.Item);
    static REPEATING_COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static CHERRY_SIGN: (Internal.SignItem) & (Internal.Item);
    static CRYING_OBSIDIAN: (Internal.BlockItem) & (Internal.Item);
    static RAISER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CREEPER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BAMBOO_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static SCULK_SHRIEKER: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static POLISHED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PINK_PETALS: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_DYE: (Internal.DyeItem) & (Internal.Item);
    static CRIMSON_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static PURPLE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BEETROOT_SOUP: (Internal.BowlFoodItem) & (Internal.Item);
    static CRIMSON_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static FLOWERING_AZALEA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static OAK_BOAT: (Internal.BoatItem) & (Internal.Item);
    static POLISHED_ANDESITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BROWN_BED: (Internal.BedItem) & (Internal.Item);
    static BLUE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CRIMSON_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static TARGET: (Internal.BlockItem) & (Internal.Item);
    static SOUL_SAND: (Internal.BlockItem) & (Internal.Item);
    static DAYLIGHT_DETECTOR: (Internal.BlockItem) & (Internal.Item);
    static MOOSHROOM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIGHT_BLUE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DAMAGED_ANVIL: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static RAW_IRON_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static TROPICAL_FISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BAMBOO_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static INK_SAC: (Internal.InkSacItem) & (Internal.Item);
    static LINGERING_POTION: (Internal.LingeringPotionItem) & (Internal.Item);
    static BRAIN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static GILDED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE: (Internal.BlockItem) & (Internal.Item);
    static SOUL_CAMPFIRE: (Internal.BlockItem) & (Internal.Item);
    static LECTERN: (Internal.BlockItem) & (Internal.Item);
    static SHROOMLIGHT: (Internal.BlockItem) & (Internal.Item);
    static GOLD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static SNIFFER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHERRY_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static PAINTING: (Internal.HangingEntityItem) & (Internal.Item);
    static MANGROVE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static IRON_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ARROW: (Internal.ArrowItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_DARK_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_STEM: (Internal.BlockItem) & (Internal.Item);
    static SOUL_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static BLUE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static WRITABLE_BOOK: (Internal.WritableBookItem) & (Internal.Item);
    static PURPLE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CUT_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static LIME_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STRAY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STRIPPED_BIRCH_LOG: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_WALL: (Internal.BlockItem) & (Internal.Item);
    static SLIME_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHER_WART_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_MOSAIC_SLAB: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SKELETON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CRIMSON_FENCE: (Internal.BlockItem) & (Internal.Item);
    static SUSPICIOUS_SAND: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static STRUCTURE_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static CAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static IRON_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static STRIPPED_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static PISTON: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_UPGRADE_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static DEEPSLATE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static COD_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static HONEY_BOTTLE: (Internal.HoneyBottleItem) & (Internal.Item);
    static EXPOSED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_STRAD: (Internal.RecordItem) & (Internal.Item);
    static GREEN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PINK_BED: (Internal.BedItem) & (Internal.Item);
    static LADDER: (Internal.BlockItem) & (Internal.Item);
    static SCULK_CATALYST: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static SNOW_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_CHEST_RAFT: (Internal.BoatItem) & (Internal.Item);
    static SALMON: (Internal.Item) & (Internal.Item);
    static DISPENSER: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static OAK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RED_BANNER: (Internal.BannerItem) & (Internal.Item);
    static IRON_AXE: (Internal.AxeItem) & (Internal.Item);
    static DEEPSLATE_LAPIS_ORE: (Internal.BlockItem) & (Internal.Item);
    static SILVERFISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ENDERMAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GOLDEN_AXE: (Internal.AxeItem) & (Internal.Item);
    static OAK_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static GRANITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHARCOAL: (Internal.Item) & (Internal.Item);
    static WOODEN_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static MELON: (Internal.BlockItem) & (Internal.Item);
    static ECHO_SHARD: (Internal.Item) & (Internal.Item);
    static BAMBOO_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static DIRT_PATH: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static WHITE_BED: (Internal.BedItem) & (Internal.Item);
    static DIORITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static RECOVERY_COMPASS: (Internal.Item) & (Internal.Item);
    static SNOW: (Internal.BlockItem) & (Internal.Item);
    static GRAY_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GHAST_TEAR: (Internal.Item) & (Internal.Item);
    static GOLDEN_CARROT: (Internal.Item) & (Internal.Item);
    static FERN: (Internal.BlockItem) & (Internal.Item);
    static CORNFLOWER: (Internal.BlockItem) & (Internal.Item);
    static CHAIN_COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static ZOMBIE_VILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIME_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static TRIPWIRE_HOOK: (Internal.BlockItem) & (Internal.Item);
    static EVOKER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SALMON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DEEPSLATE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RAW_GOLD: (Internal.Item) & (Internal.Item);
    static BIRCH_SIGN: (Internal.SignItem) & (Internal.Item);
    static FROGSPAWN: (Internal.PlaceOnWaterBlockItem) & (Internal.Item);
    static SADDLE: (Internal.SaddleItem) & (Internal.Item);
    static YELLOW_WOOL: (Internal.BlockItem) & (Internal.Item);
    static TRIDENT: (Internal.TridentItem) & (Internal.Item);
    static LIGHT_BLUE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WARPED_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static SLIME_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static ENDER_CHEST: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_BED: (Internal.BedItem) & (Internal.Item);
    static CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WANDERING_TRADER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WAXED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RAIL: (Internal.BlockItem) & (Internal.Item);
    static EMERALD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static POPPY: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_HELMET: (Internal.DyeableArmorItem) & (Internal.Item);
    static ACACIA_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static CARTOGRAPHY_TABLE: (Internal.BlockItem) & (Internal.Item);
    static RED_TULIP: (Internal.BlockItem) & (Internal.Item);
    static TRAPPED_CHEST: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_LOG: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_LOG: (Internal.BlockItem) & (Internal.Item);
    static CHIPPED_ANVIL: (Internal.BlockItem) & (Internal.Item);
    static MAGMA_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GUNPOWDER: (Internal.Item) & (Internal.Item);
    static OXIDIZED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BLACK_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static BLUE_DYE: (Internal.DyeItem) & (Internal.Item);
    static PACKED_ICE: (Internal.BlockItem) & (Internal.Item);
    static PEONY: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static CRIMSON_FUNGUS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static BEETROOT_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static IRON_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static GOLDEN_APPLE: (Internal.Item) & (Internal.Item);
    static LIGHT_BLUE_BED: (Internal.BedItem) & (Internal.Item);
    static WARPED_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CACTUS: (Internal.BlockItem) & (Internal.Item);
    static TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static GLASS_BOTTLE: (Internal.BottleItem) & (Internal.Item);
    static MAGENTA_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STRUCTURE_VOID: (Internal.BlockItem) & (Internal.Item);
    static DEAD_TUBE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GREEN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_BLOCKS: (Internal.RecordItem) & (Internal.Item);
    static COOKED_BEEF: (Internal.Item) & (Internal.Item);
    static DIAMOND_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static WOODEN_SWORD: (Internal.SwordItem) & (Internal.Item);
    static CRIMSON_SIGN: (Internal.SignItem) & (Internal.Item);
    static NETHER_BRICK: (Internal.Item) & (Internal.Item);
    static STONE_AXE: (Internal.AxeItem) & (Internal.Item);
    static DEAD_BUSH: (Internal.BlockItem) & (Internal.Item);
    static CYAN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static DEEPSLATE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WHITE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static GRANITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static MINER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_MUSHROOM: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static WOLF_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MAGENTA_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CYAN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RAW_IRON: (Internal.Item) & (Internal.Item);
    static WEATHERED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_DARK_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_FENCE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static IRON_BARS: (Internal.BlockItem) & (Internal.Item);
    static SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BEDROCK: (Internal.BlockItem) & (Internal.Item);
    static MOURNER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static STRIPPED_CHERRY_LOG: (Internal.BlockItem) & (Internal.Item);
    static TNT_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static BEE_NEST: (Internal.BlockItem) & (Internal.Item);
    static ACTIVATOR_RAIL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_5: (Internal.RecordItem) & (Internal.Item);
    static DEAD_FIRE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static GOLDEN_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static STRIPPED_WARPED_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_CARPET: (Internal.BlockItem) & (Internal.Item);
    static TORCHFLOWER_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static HONEY_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_ACACIA_LOG: (Internal.BlockItem) & (Internal.Item);
    static FRIEND_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RAW_GOLD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FUNGUS_ON_A_STICK: Internal.Item;
    static SMOOTH_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static DOLPHIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHERITE_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static GRANITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static LIME_WOOL: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static WOODEN_HOE: (Internal.HoeItem) & (Internal.Item);
    static HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WATER_BUCKET: (Internal.BucketItem) & (Internal.Item);
    static SMOOTH_QUARTZ_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static HORN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_STAL: (Internal.RecordItem) & (Internal.Item);
    static SPONGE: (Internal.BlockItem) & (Internal.Item);
    static PIGLIN_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static RAW_COPPER: (Internal.Item) & (Internal.Item);
    static DARK_OAK_BOAT: (Internal.BoatItem) & (Internal.Item);
    static REDSTONE_ORE: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BOWL: (Internal.Item) & (Internal.Item);
    static BLACK_WOOL: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BEEF: (Internal.Item) & (Internal.Item);
    static COBBLESTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CYAN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static SPRUCE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static HEARTBREAK_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static CRIMSON_HYPHAE: (Internal.BlockItem) & (Internal.Item);
}
type Items_ = Items;
declare interface NBTIO {
    write(path: Internal.Path_, nbt: Internal.CompoundTag_): void;
    read(path: Internal.Path_): Internal.CompoundTag;
}
type NBTIO_ = NBTIO;
declare const NBTIO: NBTIO;
declare class SoundType {
    constructor(arg0: number, arg1: number, arg2: Internal.SoundEvent_, arg3: Internal.SoundEvent_, arg4: Internal.SoundEvent_, arg5: Internal.SoundEvent_, arg6: Internal.SoundEvent_)
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    getHitSound(): Internal.SoundEvent;
    getStepSound(): Internal.SoundEvent;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    getFallSound(): Internal.SoundEvent;
    getPlaceSound(): Internal.SoundEvent;
    getVolume(): number;
    hashCode(): number;
    getPitch(): number;
    wait(): void;
    wait(arg0: number): void;
    getBreakSound(): Internal.SoundEvent;
    equals(arg0: any): boolean;
    get class(): typeof any
    get hitSound(): Internal.SoundEvent
    get stepSound(): Internal.SoundEvent
    get fallSound(): Internal.SoundEvent
    get placeSound(): Internal.SoundEvent
    get volume(): number
    get pitch(): number
    get breakSound(): Internal.SoundEvent
    static readonly EMPTY: (SoundType) & (SoundType);
    static readonly SAND: (SoundType) & (SoundType);
    static readonly DECORATED_POT: (SoundType) & (SoundType);
    static readonly TUFF: (SoundType) & (SoundType);
    static readonly GRAVEL: (SoundType) & (SoundType);
    static readonly SHROOMLIGHT: (SoundType) & (SoundType);
    static readonly MOSS: (SoundType) & (SoundType);
    readonly pitch: number;
    static readonly GRASS: (SoundType) & (SoundType);
    static readonly SOUL_SOIL: (SoundType) & (SoundType);
    static readonly WEEPING_VINES: (SoundType) & (SoundType);
    static readonly ANCIENT_DEBRIS: (SoundType) & (SoundType);
    static readonly SCULK_SENSOR: (SoundType) & (SoundType);
    static readonly POINTED_DRIPSTONE: (SoundType) & (SoundType);
    static readonly ROOTED_DIRT: (SoundType) & (SoundType);
    static readonly FROGSPAWN: (SoundType) & (SoundType);
    static readonly NETHER_ORE: (SoundType) & (SoundType);
    static readonly COPPER: (SoundType) & (SoundType);
    static readonly LANTERN: (SoundType) & (SoundType);
    static readonly BONE_BLOCK: (SoundType) & (SoundType);
    static readonly FROGLIGHT: (SoundType) & (SoundType);
    static readonly SNOW: (SoundType) & (SoundType);
    static readonly SCULK_VEIN: (SoundType) & (SoundType);
    static readonly CHERRY_WOOD: (SoundType) & (SoundType);
    static readonly POLISHED_DEEPSLATE: (SoundType) & (SoundType);
    static readonly NYLIUM: (SoundType) & (SoundType);
    static readonly DEEPSLATE: (SoundType) & (SoundType);
    static readonly SPORE_BLOSSOM: (SoundType) & (SoundType);
    static readonly BASALT: (SoundType) & (SoundType);
    static readonly CHERRY_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly SMALL_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly CANDLE: (SoundType) & (SoundType);
    static readonly FLOWERING_AZALEA: (SoundType) & (SoundType);
    static readonly ANVIL: (SoundType) & (SoundType);
    static readonly SCAFFOLDING: (SoundType) & (SoundType);
    static readonly DEEPSLATE_BRICKS: (SoundType) & (SoundType);
    static readonly CORAL_BLOCK: (SoundType) & (SoundType);
    static readonly BAMBOO_SAPLING: (SoundType) & (SoundType);
    static readonly LILY_PAD: (SoundType) & (SoundType);
    static readonly MOSS_CARPET: (SoundType) & (SoundType);
    static readonly LADDER: (SoundType) & (SoundType);
    static readonly LARGE_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly GLOW_LICHEN: (SoundType) & (SoundType);
    static readonly CROP: (SoundType) & (SoundType);
    static readonly PINK_PETALS: (SoundType) & (SoundType);
    static readonly AZALEA_LEAVES: (SoundType) & (SoundType);
    static readonly POWDER_SNOW: (SoundType) & (SoundType);
    static readonly METAL: (SoundType) & (SoundType);
    static readonly HONEY_BLOCK: (SoundType) & (SoundType);
    static readonly NETHER_BRICKS: (SoundType) & (SoundType);
    static readonly SUSPICIOUS_SAND: (SoundType) & (SoundType);
    static readonly GILDED_BLACKSTONE: (SoundType) & (SoundType);
    static readonly HARD_CROP: (SoundType) & (SoundType);
    static readonly SCULK_CATALYST: (SoundType) & (SoundType);
    static readonly DEEPSLATE_TILES: (SoundType) & (SoundType);
    static readonly PACKED_MUD: (SoundType) & (SoundType);
    static readonly SCULK: (SoundType) & (SoundType);
    static readonly VINE: (SoundType) & (SoundType);
    static readonly BAMBOO: (SoundType) & (SoundType);
    static readonly GLASS: (SoundType) & (SoundType);
    static readonly DRIPSTONE_BLOCK: (SoundType) & (SoundType);
    static readonly CHERRY_SAPLING: (SoundType) & (SoundType);
    static readonly CALCITE: (SoundType) & (SoundType);
    static readonly MUD_BRICKS: (SoundType) & (SoundType);
    static readonly STEM: (SoundType) & (SoundType);
    static readonly BAMBOO_WOOD: (SoundType) & (SoundType);
    static readonly SOUL_SAND: (SoundType) & (SoundType);
    static readonly MUD: (SoundType) & (SoundType);
    static readonly BIG_DRIPLEAF: (SoundType) & (SoundType);
    static readonly BAMBOO_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly TWISTING_VINES: (SoundType) & (SoundType);
    static readonly NETHERRACK: (SoundType) & (SoundType);
    static readonly AMETHYST_CLUSTER: (SoundType) & (SoundType);
    static readonly SLIME_BLOCK: (SoundType) & (SoundType);
    static readonly SCULK_SHRIEKER: (SoundType) & (SoundType);
    static readonly CHAIN: (SoundType) & (SoundType);
    static readonly WOOD: (SoundType) & (SoundType);
    static readonly AZALEA: (SoundType) & (SoundType);
    static readonly MANGROVE_ROOTS: (SoundType) & (SoundType);
    static readonly CHISELED_BOOKSHELF: (SoundType) & (SoundType);
    static readonly NETHER_GOLD_ORE: (SoundType) & (SoundType);
    static readonly CHERRY_LEAVES: (SoundType) & (SoundType);
    static readonly AMETHYST: (SoundType) & (SoundType);
    static readonly DECORATED_POT_CRACKED: (SoundType) & (SoundType);
    static readonly CAVE_VINES: (SoundType) & (SoundType);
    static readonly SUSPICIOUS_GRAVEL: (SoundType) & (SoundType);
    static readonly LODESTONE: (SoundType) & (SoundType);
    readonly volume: number;
    static readonly FUNGUS: (SoundType) & (SoundType);
    static readonly SMALL_DRIPLEAF: (SoundType) & (SoundType);
    static readonly HANGING_ROOTS: (SoundType) & (SoundType);
    static readonly SWEET_BERRY_BUSH: (SoundType) & (SoundType);
    static readonly NETHER_WOOD: (SoundType) & (SoundType);
    static readonly NETHER_WART: (SoundType) & (SoundType);
    static readonly STONE: (SoundType) & (SoundType);
    static readonly NETHER_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly HANGING_SIGN: (SoundType) & (SoundType);
    static readonly WET_GRASS: (SoundType) & (SoundType);
    static readonly NETHERITE_BLOCK: (SoundType) & (SoundType);
    static readonly MEDIUM_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly MUDDY_MANGROVE_ROOTS: (SoundType) & (SoundType);
    static readonly WOOL: (SoundType) & (SoundType);
    static readonly ROOTS: (SoundType) & (SoundType);
    static readonly WART_BLOCK: (SoundType) & (SoundType);
    static readonly NETHER_SPROUTS: (SoundType) & (SoundType);
}
type SoundType_ = SoundType;
declare class Duration implements Internal.TemporalAmount, Internal.Comparable<Duration>, Internal.Serializable {
    "dividedBy(java.time.Duration)"(arg0: Duration_): number;
    static parse(arg0: Internal.CharSequence_): Duration;
    notify(): void;
    compareTo(arg0: any): number;
    minusHours(arg0: number): this;
    plusMillis(arg0: number): this;
    toNanosPart(): number;
    getUnits(): Internal.List<Internal.TemporalUnit>;
    multipliedBy(arg0: number): this;
    dividedBy(arg0: number): this;
    get(arg0: Internal.TemporalUnit_): number;
    minusNanos(arg0: number): this;
    static ofSeconds(arg0: number): Duration;
    minus(arg0: Duration_): this;
    isNegative(): boolean;
    static ofMinutes(arg0: number): Duration;
    static ofNanos(arg0: number): Duration;
    toDays(): number;
    toHoursPart(): number;
    toSecondsPart(): number;
    minusDays(arg0: number): this;
    static ofMillis(arg0: number): Duration;
    wait(): void;
    plusNanos(arg0: number): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    minusSeconds(arg0: number): this;
    toMinutes(): number;
    plus(arg0: number, arg1: Internal.TemporalUnit_): this;
    getClass(): typeof any;
    toMillis(): number;
    toHours(): number;
    getSeconds(): number;
    toMinutesPart(): number;
    static ofSeconds(arg0: number, arg1: number): Duration;
    isZero(): boolean;
    wait(arg0: number, arg1: number): void;
    static of(arg0: number, arg1: Internal.TemporalUnit_): Duration;
    withSeconds(arg0: number): this;
    static between(arg0: Internal.Temporal_, arg1: Internal.Temporal_): Duration;
    plusSeconds(arg0: number): this;
    plusMinutes(arg0: number): this;
    toNanos(): number;
    negated(): this;
    static ofDays(arg0: number): Duration;
    addTo(arg0: Internal.Temporal_): Internal.Temporal;
    compareTo(arg0: Duration_): number;
    toString(): string;
    minus(arg0: number, arg1: Internal.TemporalUnit_): this;
    plus(arg0: Duration_): this;
    notifyAll(): void;
    toDaysPart(): number;
    "compareTo(java.time.Duration)"(arg0: Duration_): number;
    plusDays(arg0: number): this;
    static from(arg0: Internal.TemporalAmount_): Duration;
    getNano(): number;
    truncatedTo(arg0: Internal.TemporalUnit_): this;
    plusHours(arg0: number): this;
    subtractFrom(arg0: Internal.Temporal_): Internal.Temporal;
    hashCode(): number;
    minusMillis(arg0: number): this;
    wait(arg0: number): void;
    dividedBy(arg0: Duration_): number;
    equals(arg0: any): boolean;
    abs(): this;
    minusMinutes(arg0: number): this;
    static ofHours(arg0: number): Duration;
    withNanos(arg0: number): this;
    "dividedBy(long)"(arg0: number): this;
    toSeconds(): number;
    toMillisPart(): number;
    get units(): Internal.List<Internal.TemporalUnit>
    get negative(): boolean
    get class(): typeof any
    get seconds(): number
    get zero(): boolean
    get nano(): number
    static readonly ZERO: (Duration) & (Duration);
}
type Duration_ = Duration;
declare class OutputItem implements Internal.OutputReplacement {
    getClass(): typeof any;
    getCount(): number;
    withRolls(rolls: Internal.IntProvider_): this;
    static of(from: any): OutputItem;
    isEmpty(): boolean;
    notify(): void;
    withCount(count: number): this;
    wait(arg0: number, arg1: number): void;
    weakNBT(): InputItem;
    strongNBT(): InputItem;
    replaceOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.OutputReplacement_): any;
    withChance(chance: number): this;
    withRolls(min: number, max: number): this;
    getNbt(): Internal.CompoundTag;
    toString(): string;
    transform(transformer: Internal.OutputReplacementTransformer_): Internal.OutputReplacementTransformer$Replacement;
    notifyAll(): void;
    getChance(): number;
    static of(item: Internal.ItemStack_, chance: number): OutputItem;
    hashCode(): number;
    wait(): void;
    wait(arg0: number): void;
    hasChance(): boolean;
    equals(arg0: any): boolean;
    /**
     * @deprecated
    */
    ignoreNBT(): InputItem;
    get class(): typeof any
    get count(): number
    get empty(): boolean
    get nbt(): Internal.CompoundTag
    get chance(): number
    static readonly EMPTY: (OutputItem) & (OutputItem);
    readonly item: Internal.ItemStack;
    readonly rolls: Internal.IntProvider;
    readonly chance: number;
}
type OutputItem_ = Internal.ItemStack_ | OutputItem;
declare class DamageSource {
    constructor(arg0: Internal.Holder_<Internal.DamageType>)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Vec3d_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_, arg3: Vec3d_)
    getClass(): typeof any;
    getSourcePosition(): Vec3d;
    scalesWithDifficulty(): boolean;
    typeHolder(): Internal.Holder<Internal.DamageType>;
    "is(net.minecraft.tags.TagKey)"(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    notify(): void;
    getLocalizedDeathMessage(arg0: Internal.LivingEntity_): net.minecraft.network.chat.Component;
    wait(arg0: number, arg1: number): void;
    is(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    type(): Internal.DamageType;
    "is(net.minecraft.resources.ResourceKey)"(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    getType(): string;
    getActual(): Internal.Entity;
    getPlayer(): Internal.Player;
    toString(): string;
    isIndirect(): boolean;
    getImmediate(): Internal.Entity;
    notifyAll(): void;
    getFoodExhaustion(): number;
    sourcePositionRaw(): Vec3d;
    is(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    hashCode(): number;
    isCreativePlayer(): boolean;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get sourcePosition(): Vec3d
    get type(): string
    get actual(): Internal.Entity
    get player(): Internal.Player
    get indirect(): boolean
    get immediate(): Internal.Entity
    get foodExhaustion(): number
    get creativePlayer(): boolean
}
type DamageSource_ = DamageSource;
declare class Platform {
    constructor()
    getClass(): typeof any;
    static getMcVersion(): string;
    static isForge(): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static isFabric(): boolean;
    static isGeneratingData(): boolean;
    static getInfo(modID: string): Internal.PlatformWrapper$ModInfo;
    static isLoaded(modId: string): boolean;
    static getName(): string;
    static setModName(modId: string, name: string): void;
    static getMinecraftVersion(): number;
    static isDevelopmentEnvironment(): boolean;
    static getList(): Internal.Set<string>;
    toString(): string;
    notifyAll(): void;
    static isClientEnvironment(): boolean;
    static getModVersion(): string;
    static breakpoint(...args: any[]): void;
    hashCode(): number;
    static getMinecraftVersionString(): string;
    static getMods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get mcVersion(): string
    get forge(): boolean
    get fabric(): boolean
    get generatingData(): boolean
    get name(): string
    get minecraftVersion(): number
    get developmentEnvironment(): boolean
    get list(): Internal.Set<string>
    get clientEnvironment(): boolean
    get modVersion(): string
    get minecraftVersionString(): string
    get mods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>
}
type Platform_ = Platform;
declare class Vec3f implements Internal.Cloneable, Internal.Vector3fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Vector3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.Vector2fc_, arg1: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: Internal.Vector2ic_, arg1: number)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3ic_)
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    "get(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    set(arg0: number, arg1: number, arg2: number): this;
    div(arg0: number, arg1: number, arg2: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateY(arg0: number): this;
    "mul(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    angleCos(arg0: Internal.Vector3fc_): number;
    "fma(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    "set(float)"(arg0: number): this;
    static length(arg0: number, arg1: number, arg2: number): number;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_): this;
    normalize(arg0: number, arg1: Vec3f_): this;
    sub(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    half(arg0: number, arg1: number, arg2: number): this;
    round(): this;
    "fma(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    "mulAdd(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "div(float)"(arg0: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    get(arg0: number): number;
    "mulAdd(float,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    mul(arg0: number, arg1: number, arg2: number): this;
    ceil(arg0: Vec3f_): this;
    negate(): this;
    getClass(): typeof any;
    "mulPosition(org.joml.Matrix4x3fc,org.joml.Vector3f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number): number;
    add(arg0: Internal.Vector3fc_): this;
    div(arg0: number, arg1: Vec3f_): this;
    ceil(): this;
    distanceSquared(arg0: number, arg1: number, arg2: number): number;
    "mulDirection(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    "div(float,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): this;
    add(arg0: number, arg1: number, arg2: number): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotateZ(arg0: number): this;
    distanceSquared(arg0: Internal.Vector3fc_): number;
    set(arg0: number[]): this;
    equals(arg0: Internal.Vector3fc_, arg1: number): boolean;
    "normalize(float)"(arg0: number): this;
    "set(double)"(arg0: number): this;
    div(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    max(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "mulAdd(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mulPositionW(arg0: Internal.Matrix4fc_): number;
    mulPosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): Quaternionf;
    "mul(org.joml.Matrix3x2fc,org.joml.Vector3f)"(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3x2fc_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    mulDirection(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    wait(arg0: number): void;
    rotateZ(arg0: number, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_): this;
    "mulDirection(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    angleSigned(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): number;
    absolute(arg0: Vec3f_): this;
    normalize(arg0: Vec3f_): this;
    normalize(arg0: number): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: number, arg2: Vec3f_): this;
    normalize(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mul(arg0: Internal.Vector3fc_): this;
    mulTransposePosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    isFinite(): boolean;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    getToAddress(arg0: number): Internal.Vector3fc;
    "mulDirection(org.joml.Matrix4dc,org.joml.Vector3f)"(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    "mul(org.joml.Matrix3dc,org.joml.Vector3f)"(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4x3fc,org.joml.Vector3f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    x(): number;
    absolute(): this;
    mulDirection(arg0: Internal.Matrix4dc_): this;
    "set(float,float,float)"(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Vector2dc,float)"(arg0: Internal.Vector2dc_, arg1: number): this;
    mulDirection(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    "mul(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    fma(arg0: number, arg1: Internal.Vector3fc_): this;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    sub(arg0: Internal.Vector3fc_): this;
    minComponent(): number;
    orthogonalize(arg0: Internal.Vector3fc_): this;
    set(arg0: Internal.Vector3fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec3f_): this;
    "set(org.joml.Vector2ic,float)"(arg0: Internal.Vector2ic_, arg1: number): this;
    set(arg0: Internal.ByteBuffer_): this;
    "mul(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    "set(org.joml.Vector3dc)"(arg0: Internal.Vector3dc_): this;
    rotateX(arg0: number): this;
    round(arg0: Vec3f_): this;
    half(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mul(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "normalize(org.joml.Vector3f)"(arg0: Vec3f_): this;
    "set(float[])"(arg0: number[]): this;
    y(): number;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    "get(int,org.joml.Vector3i)"(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    set(arg0: Internal.Vector2fc_, arg1: number): this;
    distance(arg0: Internal.Vector3fc_): number;
    "mul(org.joml.Matrix3fc,org.joml.Vector3f)"(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    "mulPosition(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector3fc_): this;
    equals(arg0: any): boolean;
    setFromAddress(arg0: number): this;
    "mul(float)"(arg0: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "mul(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    "get(org.joml.Vector3f)"(arg0: Vec3f_): this;
    equals(arg0: number, arg1: number, arg2: number): boolean;
    add(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_): this;
    set(arg0: Internal.FloatBuffer_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    z(): number;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulPositionW(arg0: Internal.Matrix4fc_, arg1: Vec3f_): number;
    mulDirection(arg0: Internal.Matrix4fc_): this;
    "fma(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    toString(arg0: Internal.NumberFormat_): string;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "div(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    lengthSquared(): number;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "set(double,double,double)"(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Vector2fc,float)"(arg0: Internal.Vector2fc_, arg1: number): this;
    mulTranspose(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): this;
    clone(): any;
    cross(arg0: Internal.Vector3fc_): this;
    maxComponent(): number;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector3dc_): this;
    mul(arg0: number): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    dot(arg0: number, arg1: number, arg2: number): number;
    mulTranspose(arg0: Internal.Matrix3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    floor(): this;
    zero(): this;
    reflect(arg0: number, arg1: number, arg2: number): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    mulPosition(arg0: Internal.Matrix4x3fc_): this;
    sub(arg0: number, arg1: number, arg2: number): this;
    length(): number;
    toString(): string;
    notifyAll(): void;
    "mulPosition(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "mulPosition(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    setComponent(arg0: number, arg1: number): this;
    "mul(org.joml.Matrix3x2fc)"(arg0: Internal.Matrix3x2fc_): this;
    div(arg0: number): this;
    orthogonalize(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    div(arg0: Internal.Vector3fc_): this;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    set(arg0: Internal.Vector3ic_): this;
    "mul(float,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): this;
    min(arg0: Internal.Vector3fc_): this;
    cross(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    half(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    notify(): void;
    "mulAdd(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    floor(arg0: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    half(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    smoothStep(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    set(arg0: Internal.Vector2dc_, arg1: number): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    negate(arg0: Vec3f_): this;
    mul(arg0: number, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4fc_): this;
    hermite(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: number, arg4: Vec3f_): this;
    get(arg0: Internal.Vector3d_): Internal.Vector3d;
    "set(org.joml.Vector3ic)"(arg0: Internal.Vector3ic_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateY(arg0: number, arg1: Vec3f_): this;
    "get(int)"(arg0: number): number;
    distance(arg0: number, arg1: number, arg2: number): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    dot(arg0: Internal.Vector3fc_): number;
    "set(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    div(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_): this;
    min(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    wait(arg0: number, arg1: number): void;
    "mulDirection(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number): this;
    set(arg0: Internal.Vector2ic_, arg1: number): this;
    "div(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Quaternionf_): Quaternionf;
    mulTransposePosition(arg0: Internal.Matrix4fc_): this;
    angle(arg0: Internal.Vector3fc_): number;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    "fma(float,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    angleSigned(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    fma(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    mulDirection(arg0: Internal.Matrix4x3fc_): this;
    mulDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    hashCode(): number;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: Vec3f_): this;
    rotateX(arg0: number, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_): this;
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(float)"(arg0: number)
    get class(): typeof any
    set "(double)"(arg0: number)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    get finite(): boolean
    set "(org.joml.Vector3dc)"(arg0: Internal.Vector3dc_)
    set "(float[])"(arg0: number[])
    set fromAddress(arg0: number)
    set "(org.joml.Vector3ic)"(arg0: Internal.Vector3ic_)
    set "(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_)
    z: number;
    y: number;
    x: number;
}
type Vec3f_ = Vec3f;
declare class Vec4f implements Internal.Cloneable, Internal.Vector4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: Internal.Vector2fc_, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3fc_, arg1: number)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: Internal.Vector2ic_, arg1: number, arg2: number)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.Vector4fc_)
    constructor(arg0: Internal.Vector3ic_, arg1: number)
    constructor(arg0: Internal.Vector4ic_)
    min(arg0: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector4ic_): this;
    div(arg0: Internal.Vector4fc_): this;
    "fma(float,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    normalize3(arg0: Vec4f_): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateAbout(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "div(float)"(arg0: number): this;
    mul(arg0: Internal.Vector4fc_): this;
    dot(arg0: number, arg1: number, arg2: number, arg3: number): number;
    setComponent(arg0: number, arg1: number): this;
    "set(double,double,double,double)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    fma(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    rotateZ(arg0: number, arg1: Vec4f_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "mul(org.joml.Matrix4fc,org.joml.Vector4f)"(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    z(): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    div(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    min(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    "mul(float)"(arg0: number): this;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    dot(arg0: Internal.Vector4fc_): number;
    set(arg0: number, arg1: number, arg2: number): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "set(org.joml.Vector2fc,float,float)"(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    rotateZ(arg0: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    "mul(float,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): this;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    fma(arg0: number, arg1: Internal.Vector4fc_): this;
    normalize3(): this;
    div(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lengthSquared(): number;
    round(arg0: Vec4f_): this;
    mul(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    distanceSquared(arg0: Internal.Vector4fc_): number;
    get(arg0: number): number;
    set(arg0: number[]): this;
    sub(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector3ic_, arg1: number): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    clone(): any;
    getClass(): typeof any;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    maxComponent(): number;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    "set(org.joml.Vector4ic)"(arg0: Internal.Vector4ic_): this;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector4fc_): this;
    "mul(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    negate(arg0: Vec4f_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "fma(float,org.joml.Vector4fc)"(arg0: number, arg1: Internal.Vector4fc_): this;
    getToAddress(arg0: number): Internal.Vector4fc;
    get(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateY(arg0: number, arg1: Vec4f_): this;
    "get(int,org.joml.Vector4i)"(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    set(arg0: Internal.Vector3fc_, arg1: number): this;
    "mul(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "fma(org.joml.Vector4fc,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    ceil(arg0: Vec4f_): this;
    "fma(org.joml.Vector4fc,org.joml.Vector4fc)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    "mul(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "set(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    mulAffineTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    negate(): this;
    "mulAdd(float,org.joml.Vector4fc)"(arg0: number, arg1: Internal.Vector4fc_): this;
    w(): number;
    rotate(arg0: Internal.Quaternionfc_): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    length(): number;
    toString(): string;
    distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    normalize(arg0: number): this;
    mul(arg0: number): this;
    notifyAll(): void;
    ceil(): this;
    smoothStep(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number): this;
    "mul(org.joml.Matrix4x3fc,org.joml.Vector4f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    floor(arg0: Vec4f_): this;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    "get(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    div(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    "set(org.joml.Vector3ic,float)"(arg0: Internal.Vector3ic_, arg1: number): this;
    angle(arg0: Internal.Vector4fc_): number;
    floor(): this;
    wait(arg0: number): void;
    static "lengthSquared(int,int,int,int)"(arg0: number, arg1: number, arg2: number, arg3: number): number;
    "set(org.joml.Vector3fc,float)"(arg0: Internal.Vector3fc_, arg1: number): this;
    max(arg0: Internal.Vector4fc_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number): this;
    set(arg0: Internal.FloatBuffer_): this;
    "get(org.joml.Vector4f)"(arg0: Vec4f_): this;
    angleCos(arg0: Internal.Vector4fc_): number;
    "set(float)"(arg0: number): this;
    get(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    hermite(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: number, arg4: Vec4f_): this;
    "set(float,float,float)"(arg0: number, arg1: number, arg2: number): this;
    absolute(): this;
    distance(arg0: Internal.Vector4fc_): number;
    mul(arg0: number, arg1: Vec4f_): this;
    notify(): void;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    normalize(): this;
    isFinite(): boolean;
    "normalize(org.joml.Vector4f)"(arg0: Vec4f_): this;
    get(arg0: Vec4f_): this;
    static length(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateX(arg0: number, arg1: Vec4f_): this;
    "mul(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    div(arg0: number): this;
    setFromAddress(arg0: number): this;
    "div(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_): this;
    "div(float,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): this;
    x(): number;
    absolute(arg0: Vec4f_): this;
    div(arg0: number, arg1: Vec4f_): this;
    mulTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: Internal.ByteBuffer_): this;
    "mulProject(org.joml.Matrix4fc,org.joml.Vector4f)"(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "set(double)"(arg0: number): this;
    "div(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    wait(): void;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    zero(): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    static "lengthSquared(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): number;
    "get(int)"(arg0: number): number;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "normalize(float)"(arg0: number): this;
    rotateX(arg0: number): this;
    minComponent(): number;
    add(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    round(): this;
    set(arg0: Internal.Vector4dc_): this;
    "mulAdd(org.joml.Vector4fc,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "mulProject(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    add(arg0: Internal.Vector4fc_): this;
    "mulAdd(org.joml.Vector4fc,org.joml.Vector4fc)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    equals(arg0: Internal.Vector4fc_, arg1: number): boolean;
    wait(arg0: number, arg1: number): void;
    "set(org.joml.Vector2ic,float,float)"(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    sub(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    mulTranspose(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    "mulAdd(float,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    y(): number;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    normalize(arg0: Vec4f_): this;
    set(arg0: number): this;
    rotateY(arg0: number): this;
    hashCode(): number;
    set(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    distance(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    "set(org.joml.Vector4dc)"(arg0: Internal.Vector4dc_): this;
    set(arg0: number): this;
    equals(arg0: any): boolean;
    mul(arg0: Internal.Matrix4fc_): this;
    "set(float[])"(arg0: number[]): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    normalize(arg0: number, arg1: Vec4f_): this;
    get class(): typeof any
    set "(org.joml.Vector4ic)"(arg0: Internal.Vector4ic_)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set "(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(float)"(arg0: number)
    get finite(): boolean
    set fromAddress(arg0: number)
    set "(double)"(arg0: number)
    set "(org.joml.Vector4dc)"(arg0: Internal.Vector4dc_)
    set "(float[])"(arg0: number[])
    z: number;
    y: number;
    x: number;
    w: number;
}
type Vec4f_ = Vec4f;
declare interface UUID {
    toString(id: Internal.UUID_): string;
    digits(sb: Internal.StringBuilder_, val: number, digits: number): void;
    fromString(o: any): Internal.UUID;
}
type UUID_ = UUID;
declare const UUID: UUID;
/**
 * Various Ingredient related helper methods
*/
declare interface Ingredient {
    static of(ingredient: Internal.Ingredient_, count: number): Internal.Ingredient;
    /**
     * Returns an ingredient of the input
    */
    of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Returns an ingredient of the input, with the specified count
    */
    of(ingredient: Internal.Ingredient_, count: number): InputItem;
    /**
     * Make a custom ingredient where a match must match the provided predicate function
    */
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    /**
     * Register a custom ingredient action for use in recipes with Recipe#customIngredientAction
    */
    registerCustomIngredientAction(id: string, callback: Internal.CustomIngredientActionCallback_): void;
    /**
     * Make a custom ingredient where items must match both the parent ingredient and the custom predicate function
    */
    custom(parent: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    static of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Checks if the passed in object is an Ingredient.
     * Note that this does not mean it will not function as an Ingredient if passed to something that requests one.
    */
    isIngredient(o: any): boolean;
    /**
     * Make a custom ingredient where an item must match both the parent ingredient and the item's nbt must match the custom predicate function
    */
    customNBT(in_: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.CompoundTag>): Internal.Ingredient;
    /**
     * An ingredient that matches everything
    */
    readonly all: (Internal.WildcardIngredient) & (Internal.Ingredient);
    /**
     * A completely empty ingredient that will only match air
    */
    readonly none: (Internal.Ingredient) & (Internal.Ingredient);
}
type Ingredient_ = Ingredient;
declare const Ingredient: Ingredient;
declare class JavaMath {
    static "nextUp(float)"(arg0: number): number;
    static asin(arg0: number): number;
    static expm1(arg0: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static ceil(arg0: number): number;
    static exp(arg0: number): number;
    static "decrementExact(long)"(arg0: number): number;
    static "floorMod(long,int)"(arg0: number, arg1: number): number;
    static "incrementExact(int)"(arg0: number): number;
    static ulp(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static "copySign(float,float)"(arg0: number, arg1: number): number;
    static "fma(double,double,double)"(arg0: number, arg1: number, arg2: number): number;
    static "negateExact(int)"(arg0: number): number;
    static "abs(float)"(arg0: number): number;
    static "min(double,double)"(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static round(arg0: number): number;
    static hypot(arg0: number, arg1: number): number;
    static round(arg0: number): number;
    static "scalb(float,int)"(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static "subtractExact(long,long)"(arg0: number, arg1: number): number;
    static "floorDiv(long,long)"(arg0: number, arg1: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static log(arg0: number): number;
    static signum(arg0: number): number;
    static "max(float,float)"(arg0: number, arg1: number): number;
    static "nextAfter(double,double)"(arg0: number, arg1: number): number;
    static cos(arg0: number): number;
    getClass(): typeof any;
    static min(arg0: number, arg1: number): number;
    static nextUp(arg0: number): number;
    static "min(int,int)"(arg0: number, arg1: number): number;
    static "floorMod(int,int)"(arg0: number, arg1: number): number;
    static "max(long,long)"(arg0: number, arg1: number): number;
    static "fma(float,float,float)"(arg0: number, arg1: number, arg2: number): number;
    static "nextDown(double)"(arg0: number): number;
    static atan2(arg0: number, arg1: number): number;
    static cosh(arg0: number): number;
    static "round(float)"(arg0: number): number;
    static toIntExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static "floorDiv(int,int)"(arg0: number, arg1: number): number;
    static sinh(arg0: number): number;
    static toDegrees(arg0: number): number;
    static "multiplyExact(long,long)"(arg0: number, arg1: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static "scalb(double,int)"(arg0: number, arg1: number): number;
    static "decrementExact(int)"(arg0: number): number;
    static tanh(arg0: number): number;
    toString(): string;
    static "negateExact(long)"(arg0: number): number;
    static "nextUp(double)"(arg0: number): number;
    notifyAll(): void;
    static floorMod(arg0: number, arg1: number): number;
    static "min(long,long)"(arg0: number, arg1: number): number;
    static nextDown(arg0: number): number;
    static "absExact(long)"(arg0: number): number;
    static "addExact(int,int)"(arg0: number, arg1: number): number;
    static absExact(arg0: number): number;
    static pow(arg0: number, arg1: number): number;
    static scalb(arg0: number, arg1: number): number;
    wait(arg0: number): void;
    static "abs(int)"(arg0: number): number;
    static addExact(arg0: number, arg1: number): number;
    static atan(arg0: number): number;
    static "addExact(long,long)"(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    notify(): void;
    static multiplyExact(arg0: number, arg1: number): number;
    static "ulp(float)"(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static random(): number;
    static "ulp(double)"(arg0: number): number;
    static nextUp(arg0: number): number;
    static sqrt(arg0: number): number;
    static "multiplyExact(int,int)"(arg0: number, arg1: number): number;
    static "copySign(double,double)"(arg0: number, arg1: number): number;
    static "abs(double)"(arg0: number): number;
    static "subtractExact(int,int)"(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static addExact(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static "floorMod(long,long)"(arg0: number, arg1: number): number;
    static floor(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static "abs(long)"(arg0: number): number;
    static rint(arg0: number): number;
    static "min(float,float)"(arg0: number, arg1: number): number;
    static "max(int,int)"(arg0: number, arg1: number): number;
    static absExact(arg0: number): number;
    static signum(arg0: number): number;
    wait(): void;
    static log10(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static tan(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static sin(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    wait(arg0: number, arg1: number): void;
    static max(arg0: number, arg1: number): number;
    static "max(double,double)"(arg0: number, arg1: number): number;
    static toRadians(arg0: number): number;
    static "multiplyExact(long,int)"(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static negateExact(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static negateExact(arg0: number): number;
    static "getExponent(float)"(arg0: number): number;
    static "incrementExact(long)"(arg0: number): number;
    static "signum(float)"(arg0: number): number;
    static nextDown(arg0: number): number;
    static "nextAfter(float,double)"(arg0: number, arg1: number): number;
    static IEEEremainder(arg0: number, arg1: number): number;
    static "round(double)"(arg0: number): number;
    static abs(arg0: number): number;
    static getExponent(arg0: number): number;
    static "getExponent(double)"(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static multiplyFull(arg0: number, arg1: number): number;
    static multiplyHigh(arg0: number, arg1: number): number;
    hashCode(): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static getExponent(arg0: number): number;
    static "floorDiv(long,int)"(arg0: number, arg1: number): number;
    static cbrt(arg0: number): number;
    static acos(arg0: number): number;
    static log1p(arg0: number): number;
    static "nextDown(float)"(arg0: number): number;
    equals(arg0: any): boolean;
    static "signum(double)"(arg0: number): number;
    static "absExact(int)"(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    get class(): typeof any
    static readonly PI: (3.141592653589793) & (number);
    static readonly E: (2.718281828459045) & (number);
}
type JavaMath_ = JavaMath;
declare interface NBT {
    accessTagMap(tag: Internal.CompoundTag_): Internal.Map<string, Internal.Tag>;
    read(buf: Internal.FriendlyByteBuf_): Internal.OrderedCompoundTag;
    toJson(t: Internal.Tag_): Internal.JsonElement;
    toTagCollection(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    quoteAndEscapeForJS(stringBuilder: Internal.StringBuilder_, string: string): void;
    l(v: number): Internal.Tag;
    b(v: number): Internal.Tag;
    byteArrayTag(v: number[]): Internal.Tag;
    listTag(): Internal.Tag;
    floatTag(v: number): Internal.Tag;
    byteTag(v: number): Internal.Tag;
    s(v: number): Internal.Tag;
    listTag(list: Internal.List_<any>): Internal.Tag;
    ia(v: number[]): Internal.Tag;
    d(v: number): Internal.Tag;
    longArrayTag(v: number[]): Internal.Tag;
    isTagCollection(o: any): boolean;
    "toTagCollection(java.util.Collection)"(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    longTag(v: number): Internal.Tag;
    compoundTag(): Internal.Tag;
    intTag(v: number): Internal.Tag;
    shortTag(v: number): Internal.Tag;
    la(v: number[]): Internal.Tag;
    stringTag(v: string): Internal.Tag;
    toTagCollection(v: any): Internal.CollectionTag<any>;
    convertType(tagType: Internal.TagType_<any>): Internal.TagType<any>;
    f(v: number): Internal.Tag;
    toTag(v: any): Internal.Tag;
    fromTag(t: Internal.Tag_): any;
    toTagList(list: any): Internal.ListTag;
    toTagCompound(v: any): Internal.CompoundTag;
    isTagCompound(o: any): boolean;
    doubleTag(v: number): Internal.Tag;
    intArrayTag(v: number[]): Internal.Tag;
    compoundTag(map: Internal.Map_<any, any>): Internal.Tag;
    ba(v: number[]): Internal.Tag;
    i(v: number): Internal.Tag;
    "toTagCollection(java.lang.Object)"(v: any): Internal.CollectionTag<any>;
    readonly VALUE_UNWRAPPER: Internal.ValueUnwrapper;
    readonly LIST_TYPE: Internal.TagType<Internal.ListTag>;
    readonly COMPOUND_TYPE: Internal.TagType<Internal.OrderedCompoundTag>;
}
type NBT_ = NBT;
declare const NBT: NBT;
declare interface FluidAmounts {
    readonly MILLIBUCKET: (1) & (number);
    readonly MB: (1) & (number);
    readonly INGOT: (90) & (number);
    readonly BOTTLE: (250) & (number);
    readonly B: (1000) & (number);
    readonly NUGGET: (10) & (number);
    readonly METAL_BLOCK: (810) & (number);
    readonly BUCKET: (1000) & (number);
}
type FluidAmounts_ = FluidAmounts;
declare const FluidAmounts: FluidAmounts;
declare class Matrix3f implements Internal.Cloneable, Internal.Matrix3fc, Internal.Externalizable {
    constructor(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_)
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix2fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number)
    rotateLocalY(arg0: number, arg1: Matrix3f_): this;
    setColumn(arg0: number, arg1: Internal.Vector3fc_): this;
    mapnZnXY(): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    mapZXnY(): this;
    mapYXnZ(arg0: Matrix3f_): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "getUnnormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapnYnXZ(arg0: Matrix3f_): this;
    "scale(float)"(arg0: number): this;
    "getTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapYnXnZ(arg0: Matrix3f_): this;
    "getNormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(arg0: Matrix3f_): this;
    "get(int,int)"(arg0: number, arg1: number): number;
    mapXnYnZ(): this;
    mapnYnZX(): this;
    m20(arg0: number): this;
    set(arg0: Internal.Matrix4fc_): this;
    rotationZ(arg0: number): this;
    mapnYnXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZYnX(): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    sub(arg0: Internal.Matrix3fc_): this;
    "rotate(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    setColumn(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnYnZnX(): this;
    getRowColumn(arg0: number, arg1: number): number;
    positiveZ(arg0: Vec3f_): Vec3f;
    mapnYZX(arg0: Matrix3f_): this;
    mapnXnZY(arg0: Matrix3f_): this;
    rotateZ(arg0: number, arg1: Matrix3f_): this;
    mapXZY(arg0: Matrix3f_): this;
    mapYZnX(): this;
    mapnZnYX(arg0: Matrix3f_): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotateLocalZ(arg0: number, arg1: Matrix3f_): this;
    getClass(): typeof any;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapZYX(): this;
    mapYnZnX(): this;
    mapnXnYnZ(): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix3f_): this;
    scale(arg0: number): this;
    m20(): number;
    set(arg0: Internal.Matrix3fc_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapnXnYZ(): this;
    "rotate(org.joml.AxisAngle4f,org.joml.Matrix3f)"(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    get(arg0: Matrix4f_): Matrix4f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    m21(arg0: number): this;
    rotationY(arg0: number): this;
    "get3x4(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXYnZ(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYX(): this;
    cofactor(arg0: Matrix3f_): this;
    mapnYZnX(arg0: Matrix3f_): this;
    set(arg0: Internal.ByteBuffer_): this;
    setTransposed(arg0: Internal.Matrix3fc_): this;
    getScale(arg0: Vec3f_): Vec3f;
    mapXnZY(arg0: Matrix3f_): this;
    rotateY(arg0: number, arg1: Matrix3f_): this;
    transform(arg0: Vec3f_): Vec3f;
    mapYnZX(): this;
    "scale(org.joml.Vector3fc,org.joml.Matrix3f)"(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    mapnXZY(arg0: Matrix3f_): this;
    "scale(float,org.joml.Matrix3f)"(arg0: number, arg1: Matrix3f_): this;
    wait(arg0: number): void;
    set(arg0: Internal.Quaterniondc_): this;
    scale(arg0: Internal.Vector3fc_): this;
    mapZYnX(): this;
    normal(arg0: Matrix3f_): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setRow(arg0: number, arg1: Internal.Vector3fc_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Quaternionfc_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    rotateLocalY(arg0: number): this;
    "get(org.joml.Matrix3f)"(arg0: Matrix3f_): this;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    m21(): number;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    sub(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    isFinite(): boolean;
    mapnYZX(): this;
    mapZnYX(arg0: Matrix3f_): this;
    transpose(arg0: Matrix3f_): this;
    rotation(arg0: Internal.Quaternionfc_): this;
    mapnXnYZ(arg0: Matrix3f_): this;
    mapnXnZnY(): this;
    "set(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    m10(): number;
    mapXnZnY(): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    mapZXY(arg0: Matrix3f_): this;
    rotationX(arg0: number): this;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    mapYnXZ(): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    getToAddress(arg0: number): Internal.Matrix3fc;
    reflect(arg0: number, arg1: number, arg2: number): this;
    setRow(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: number, arg1: number): number;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnZnXnY(arg0: Matrix3f_): this;
    set(arg0: Internal.FloatBuffer_): this;
    mapXZnY(arg0: Matrix3f_): this;
    rotateLocalX(arg0: number, arg1: Matrix3f_): this;
    mulLocal(arg0: Internal.Matrix3fc_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapnYXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: Vec3f_): Vec3f;
    "rotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotateLocalZ(arg0: number): this;
    lerp(arg0: Internal.Matrix3fc_, arg1: number, arg2: Matrix3f_): this;
    m22(): number;
    mapYXnZ(): this;
    mapZnYnX(arg0: Matrix3f_): this;
    "rotation(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYXZ(arg0: Matrix3f_): this;
    reflection(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnZXnY(): this;
    invert(): this;
    m11(): number;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnXnY(arg0: Matrix3f_): this;
    rotateXYZ(arg0: Vec3f_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnXnZY(): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(): this;
    mapnZnYnX(arg0: Matrix3f_): this;
    equals(arg0: any): boolean;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapXZY(): this;
    m00(): number;
    mapYnZX(arg0: Matrix3f_): this;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    "scaling(float)"(arg0: number): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnZXY(): this;
    "scaling(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    "reflect(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    scaling(arg0: Internal.Vector3fc_): this;
    identity(): this;
    mulLocal(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapXZnY(): this;
    "get3x4(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflect(arg0: Internal.Vector3fc_): this;
    "getNormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    setFromAddress(arg0: number): this;
    mapnZnYnX(): this;
    mul(arg0: Internal.Matrix3fc_): this;
    m01(arg0: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    m12(): number;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYnX(): this;
    mapnZYnX(arg0: Matrix3f_): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    mapZYnX(arg0: Matrix3f_): this;
    normal(): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    mapnXZY(): this;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    "rotate(org.joml.Quaternionfc,org.joml.Matrix3f)"(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    get(arg0: number[]): number[];
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    negateY(): this;
    toString(arg0: Internal.NumberFormat_): string;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXYnZ(arg0: Matrix3f_): this;
    mapnYXnZ(): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number[], arg1: number): number[];
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnXnYnZ(arg0: Matrix3f_): this;
    mapZYX(arg0: Matrix3f_): this;
    "scale(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    m12(arg0: number): this;
    m01(): number;
    mapnYnZX(arg0: Matrix3f_): this;
    clone(): any;
    quadraticFormProduct(arg0: Internal.Vector3fc_): number;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    "set(int,int,float)"(arg0: number, arg1: number, arg2: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflection(arg0: Internal.Quaternionfc_): this;
    mapnYnZnX(arg0: Matrix3f_): this;
    transformTranspose(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    mapnZnXnY(): this;
    "reflection(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    m02(arg0: number): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXY(arg0: Matrix3f_): this;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    mapnYnXZ(): this;
    mapnXZnY(): this;
    mapYZX(): this;
    "get3x4(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnYXZ(): this;
    mulComponentWise(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapZXnY(arg0: Matrix3f_): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    negateX(): this;
    "set(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    mapnZYX(arg0: Matrix3f_): this;
    toString(): string;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    notifyAll(): void;
    mapYZnX(arg0: Matrix3f_): this;
    mapnZnYX(): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    mapnZXnY(arg0: Matrix3f_): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    mapZnXY(arg0: Matrix3f_): this;
    "reflect(org.joml.Vector3fc,org.joml.Matrix3f)"(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    reflection(arg0: Internal.Vector3fc_): this;
    rotateX(arg0: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    mapnXZnY(arg0: Matrix3f_): this;
    "rotate(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYXZ(): this;
    setSkewSymmetric(arg0: number, arg1: number, arg2: number): this;
    "rotate(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    notify(): void;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m02(): number;
    mapZnXnY(): this;
    "set(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "set(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    negateX(arg0: Matrix3f_): this;
    mapnYZnX(): this;
    m22(arg0: number): this;
    mulComponentWise(arg0: Internal.Matrix3fc_): this;
    invert(arg0: Matrix3f_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    reflect(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    "getTransposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnZYX(): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): this;
    "get(float[],int)"(arg0: number[], arg1: number): number[];
    rotateX(arg0: number, arg1: Matrix3f_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "getTransposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateYXZ(arg0: Vec3f_): this;
    determinant(): number;
    transpose(): this;
    add(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    "set(float[])"(arg0: number[]): this;
    "reflect(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    m10(arg0: number): this;
    mapYnZnX(arg0: Matrix3f_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    rotateY(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    "reflect(org.joml.Quaternionfc,org.joml.Matrix3f)"(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    lerp(arg0: Internal.Matrix3fc_, arg1: number): this;
    add(arg0: Internal.Matrix3fc_): this;
    scale(arg0: number, arg1: Matrix3f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapYnXZ(arg0: Matrix3f_): this;
    mapnZXY(arg0: Matrix3f_): this;
    "get3x4(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapZnXY(): this;
    wait(arg0: number, arg1: number): void;
    cofactor(): this;
    mapnYnXnZ(): this;
    quadraticFormProduct(arg0: number, arg1: number, arg2: number): number;
    "get(float[])"(arg0: number[]): number[];
    "set(org.joml.Matrix2fc)"(arg0: Internal.Matrix2fc_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    mapXnZnY(arg0: Matrix3f_): this;
    swap(arg0: Matrix3f_): this;
    set(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "reflection(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    obliqueZ(arg0: number, arg1: number): this;
    negateY(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    m00(arg0: number): this;
    mapXnYnZ(arg0: Matrix3f_): this;
    mapXnZY(): this;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): Matrix4f;
    mapYZX(arg0: Matrix3f_): this;
    equals(arg0: Internal.Matrix3fc_, arg1: number): boolean;
    set(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: Internal.Matrix2fc_): this;
    mapnXnZnY(arg0: Matrix3f_): this;
    rotateZ(arg0: number): this;
    "getUnnormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    hashCode(): number;
    positiveY(arg0: Vec3f_): Vec3f;
    mapYnXnZ(): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    mapZXY(): this;
    mapnYXZ(arg0: Matrix3f_): this;
    scaling(arg0: number): this;
    set(arg0: number[]): this;
    zero(): this;
    set(arg0: Internal.Quaternionfc_): this;
    m11(arg0: number): this;
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    get class(): typeof any
    set transposed(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set "(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    set fromAddress(arg0: number)
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set "(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(float[])"(arg0: number[])
    set "(org.joml.Matrix2fc)"(arg0: Internal.Matrix2fc_)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    m10: number;
    m21: number;
    m20: number;
    m01: number;
    m12: number;
    m00: number;
    m11: number;
    m22: number;
    m02: number;
}
type Matrix3f_ = Matrix3f;
declare class Matrix4f implements Internal.Cloneable, Internal.Matrix4fc, Internal.Externalizable {
    constructor(arg0: Internal.Matrix3fc_)
    constructor()
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix4dc_)
    constructor(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: Internal.Matrix4x3fc_)
    scaleXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    testSphere(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    zero(): this;
    m32(arg0: number): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    "get4x3(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix4f_): this;
    "orthoLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setTransposedFromAddress(arg0: number): this;
    mapYXnZ(arg0: Matrix4f_): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "perspectiveRect(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRowColumn(arg0: number, arg1: number): number;
    "normalize3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    "unprojectInv(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    "mulPerspectiveAffine(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "normal(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    "project(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    rotateX(arg0: number, arg1: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    m10(arg0: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapZYnX(): this;
    rotateLocalY(arg0: number, arg1: Matrix4f_): this;
    set(arg0: Internal.Matrix3fc_): this;
    invertAffine(arg0: Matrix4f_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number, arg4: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m32(): number;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    "frustumLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYX(): this;
    mapYnXnZ(arg0: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    normal(arg0: Matrix3f_): Matrix3f;
    m21(arg0: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    rotationY(arg0: number): this;
    getRotation(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "unproject(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "ortho(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m21(): number;
    isFinite(): boolean;
    transformProject(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    m30(arg0: number): this;
    setRotationYXZ(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix4fc_): this;
    m10(): number;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number): this;
    set(arg0: number, arg1: number, arg2: number): this;
    mapnZnXnY(): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get3x3(org.joml.Matrix3d)"(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    mapYXZ(arg0: Matrix4f_): this;
    "get4x3Transposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotation(arg0: Internal.Quaternionfc_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    rotateAffine(arg0: Internal.Quaternionfc_): this;
    get4x3Transposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    transpose3x3(arg0: Matrix3f_): Matrix3f;
    translate(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    "transformProject(org.joml.Vector4fc,org.joml.Vector3f)"(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "set4x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapYZnX(): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleLocal(arg0: number): this;
    rotateZ(arg0: number, arg1: Matrix4f_): this;
    setTransposed(arg0: Internal.FloatBuffer_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    set(arg0: Internal.FloatBuffer_): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    "getRow(int,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): Vec4f;
    perspectiveInvOrigin(arg0: Vec3f_): Vec3f;
    transformTranspose(arg0: Vec4f_): Vec4f;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapnYnXZ(arg0: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYX(arg0: Matrix4f_): this;
    mapnZXnY(): this;
    "shadow(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getToAddress(arg0: number): Internal.Matrix4fc;
    mapnXZY(): this;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    transformProject(arg0: Vec4f_): Vec4f;
    "set(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    negateZ(): this;
    m23(): number;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    lookAtPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    equals(arg0: Internal.Matrix4fc_, arg1: number): boolean;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get4x3Transposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    m12(): number;
    mapnYnZX(arg0: Matrix4f_): this;
    "getColumn(int,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): Vec4f;
    translationRotate(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    "reflect(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "orthoSymmetricLH(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapXZY(): this;
    transformDirection(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformProject(float,float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    "mul(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    m01(arg0: number): this;
    mapYXnZ(): this;
    m01(): number;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    mapYZnX(arg0: Matrix4f_): this;
    "translationRotateScaleInvert(org.joml.Vector3fc,org.joml.Quaternionfc,float)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    translate(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnZXnY(arg0: Matrix4f_): this;
    mapZnXY(arg0: Matrix4f_): this;
    transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Vec3f_, arg7: Vec3f_): this;
    invertOrtho(): this;
    "scaling(float)"(arg0: number): this;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "get4x3Transposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateLocalY(arg0: number): this;
    billboardCylindrical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "scaling(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "ortho(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapnYXZ(): this;
    setFromIntrinsic(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    negateX(): this;
    setColumn(arg0: number, arg1: Internal.Vector4fc_): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    notify(): void;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get4x3(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    rotateYXZ(arg0: Vec3f_): this;
    mapnYXZ(arg0: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "reflection(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    cofactor3x3(arg0: Matrix4f_): this;
    "rotate(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    translationRotateScaleMulAffine(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    "orthoSymmetric(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    invertOrtho(arg0: Matrix4f_): this;
    mapYZX(arg0: Matrix4f_): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    m03(): number;
    "get(float[])"(arg0: number[]): number[];
    translationRotateScaleMulAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: Matrix4f_): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    cofactor3x3(): this;
    scaleXY(arg0: number, arg1: number): this;
    m12(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    translateLocal(arg0: Internal.Vector3fc_): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaling(arg0: number): this;
    mapZnXY(): this;
    "setTransposed(float[])"(arg0: number[]): this;
    "unprojectInv(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "transformProject(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    hashCode(): number;
    positiveY(arg0: Vec3f_): Vec3f;
    negateX(arg0: Matrix4f_): this;
    setOrtho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translation(arg0: Internal.Vector3fc_): this;
    translationRotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m23(arg0: number): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "orthoSymmetric(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    setRow(arg0: number, arg1: Internal.Vector4fc_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    trapezoidCrop(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaternionfc_): this;
    transformPosition(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setOrtho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInvRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZnYnX(arg0: Matrix4f_): this;
    "getNormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "get(int,int)"(arg0: number, arg1: number): number;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    get4x3(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number, arg16: Matrix4f_): this;
    "transformProject(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapZYX(): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    get3x3(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    mapnXnYnZ(): this;
    setTransposed(arg0: Internal.ByteBuffer_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "frustum(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYnX(arg0: Matrix4f_): this;
    positiveZ(arg0: Vec3f_): Vec3f;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    invertPerspective(): this;
    mapnYnZX(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    mapXnZY(arg0: Matrix4f_): this;
    translate(arg0: number, arg1: number, arg2: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number): this;
    "rotate(org.joml.Quaternionfc,org.joml.Matrix4f)"(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapnXYnZ(): this;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    mulLocal(arg0: Internal.Matrix4fc_): this;
    rotateXYZ(arg0: Internal.Vector3fc_): this;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    get3x3(arg0: Matrix3f_): Matrix3f;
    set(arg0: number[], arg1: number): this;
    "mulPerspectiveAffine(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "set3x3(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    mapXnYnZ(): this;
    negateZ(arg0: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "getColumn(int,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): Vec3f;
    mul(arg0: Internal.Matrix4x3fc_): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "project(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateTowardsXY(arg0: number, arg1: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Matrix4f_): this;
    setLookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    rotateLocalZ(arg0: number): this;
    sub(arg0: Internal.Matrix4fc_): this;
    scale(arg0: number): this;
    "transformProject(float,float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    m03(arg0: number): this;
    mapnYZX(): this;
    get(arg0: number, arg1: number): number;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "translationRotateScale(org.joml.Vector3fc,org.joml.Quaternionfc,float)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    invert(): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    "setTransposed(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "get4x3Transposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    perspectiveNear(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnYZX(arg0: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_): this;
    "getTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: Vec4f_, arg1: Matrix4f_): this;
    "scale(org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    perspectiveOrigin(arg0: Vec3f_): Vec3f;
    frustumAabb(arg0: Vec3f_, arg1: Vec3f_): this;
    "set(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    "rotation(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mulLocal(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "set(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    "mul(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    setTranslation(arg0: Internal.Vector3fc_): this;
    mapXnYnZ(arg0: Matrix4f_): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    isAffine(): boolean;
    "scale(float,org.joml.Matrix4f)"(arg0: number, arg1: Matrix4f_): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapYnXnZ(): this;
    "get3x4(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_): this;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_): this;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getNormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotateX(arg0: number): this;
    invertFrustum(): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    mapnYnZnX(arg0: Matrix4f_): this;
    "invertPerspectiveView(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnYnXnZ(): this;
    set4x3(arg0: Internal.Matrix4x3fc_): this;
    identity(): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translateLocal(arg0: number, arg1: number, arg2: number): this;
    clone(): any;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    invert(arg0: Matrix4f_): this;
    mapZnYnX(): this;
    frustumRayDir(arg0: number, arg1: number, arg2: Vec3f_): Vec3f;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnYX(): this;
    "mulPerspectiveAffine(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    translationRotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "mul(org.joml.Matrix3x2fc,org.joml.Matrix4f)"(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    sub4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    properties(): number;
    "unproject(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    toString(): string;
    translationRotateInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    mapnYnXZ(): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mapnZnXY(arg0: Matrix4f_): this;
    "perspectiveOffCenterFovLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    translateLocal(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mapnZnYnX(): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    normalize3x3(arg0: Matrix3f_): Matrix3f;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    scaleLocal(arg0: number, arg1: Matrix4f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    "perspectiveOffCenter(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateZ(arg0: number): this;
    rotateLocalZ(arg0: number, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: Matrix4f_): this;
    "get3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "invertPerspectiveView(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    "rotate(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapYnZnX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "set(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflection(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    testPoint(arg0: number, arg1: number, arg2: number): boolean;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveFov(): number;
    "get4x3(org.joml.Matrix4x3f)"(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    mapZYnX(arg0: Matrix4f_): this;
    mapZXY(): this;
    "get4x3(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "get4x3(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "transpose3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    mapnXYnZ(arg0: Matrix4f_): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number): this;
    withLookAtUp(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnYnZnX(): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapYnZnX(arg0: Matrix4f_): this;
    mapnZnYX(arg0: Matrix4f_): this;
    mapnXnYnZ(arg0: Matrix4f_): this;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    origin(arg0: Vec3f_): Vec3f;
    determinantAffine(): number;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    obliqueZ(arg0: number, arg1: number): this;
    "mul(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    "perspective(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnZYnX(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateY(arg0: number, arg1: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    "orthoLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    rotateAffine(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapXZnY(arg0: Matrix4f_): this;
    rotateLocalX(arg0: number, arg1: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZXY(arg0: Matrix4f_): this;
    mapnYXnZ(arg0: Matrix4f_): this;
    mapZXnY(): this;
    m31(): number;
    transformAffine(arg0: Vec4f_): Vec4f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    get4x3Transposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "scale(float)"(arg0: number): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m20(arg0: number): this;
    reflection(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotationZ(arg0: number): this;
    mapZXY(arg0: Matrix4f_): this;
    static perspectiveOffCenterViewFromRectangle(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_, arg4: number, arg5: boolean, arg6: Matrix4f_, arg7: Matrix4f_): void;
    cofactor3x3(arg0: Matrix3f_): Matrix3f;
    mapnYnXnZ(arg0: Matrix4f_): this;
    "getRotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    m20(): number;
    get(arg0: Matrix4f_): this;
    transform(arg0: Vec4f_): Vec4f;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    normal(arg0: Matrix4f_): this;
    m33(arg0: number): this;
    "get3x4(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    set3x3(arg0: Internal.Matrix3fc_): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    unprojectRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    "translationRotateScale(org.joml.Vector3fc,org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    normalize3x3(arg0: Matrix4f_): this;
    "shadow(org.joml.Vector4f,float,float,float,float)"(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    "frustumLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    getScale(arg0: Vec3f_): Vec3f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    setRotationXYZ(arg0: number, arg1: number, arg2: number): this;
    mapZnXnY(): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    invertFrustum(arg0: Matrix4f_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    wait(arg0: number): void;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "transformProject(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotationTowardsXY(arg0: number, arg1: number): this;
    "normalize3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    orthoCrop(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "shadow(org.joml.Vector4f,float,float,float,float,org.joml.Matrix4f)"(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    unprojectInvRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    transpose3x3(arg0: Matrix4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "reflect(org.joml.Quaternionfc,org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    "unprojectInv(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    m33(): number;
    transpose(arg0: Matrix4f_): this;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    set(arg0: Internal.Matrix4fc_): this;
    rotationX(arg0: number): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    m22(): number;
    m31(arg0: number): this;
    mapZYX(arg0: Matrix4f_): this;
    mulAffineR(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m11(): number;
    mapYnZX(arg0: Matrix4f_): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_): this;
    mapnZnXY(): this;
    setTransposed(arg0: Internal.Matrix4fc_): this;
    setRotationZYX(arg0: number, arg1: number, arg2: number): this;
    assume(arg0: number): this;
    "unproject(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    mul0(arg0: Internal.Matrix4fc_): this;
    rotateTowardsXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    transformAab(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_, arg3: Vec3f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    equals(arg0: any): boolean;
    "perspectiveOffCenterFov(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    mapnZYnX(arg0: Matrix4f_): this;
    m00(): number;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    "cofactor3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    m13(arg0: number): this;
    invertPerspective(arg0: Matrix4f_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZXY(): this;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    "normal(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    translationRotateScaleInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    get(arg0: number[], arg1: number): number[];
    mapXZnY(): this;
    "setTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    negateY(): this;
    set(arg0: Internal.Matrix4dc_): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapnZYX(arg0: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    sub(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "perspectiveRect(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getRow(arg0: number, arg1: Vec4f_): Vec4f;
    "perspectiveLH(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "getRotation(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    getColumn(arg0: number, arg1: Vec4f_): Vec4f;
    mapnYXnZ(): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    transpose3x3(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAroundAffine(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    transformProject(arg0: Vec3f_): Vec3f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    sub4x3(arg0: Matrix4f_): this;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    translationRotateInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    testAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
    "reflect(org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    m13(): number;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    mapYZX(): this;
    "get4x3(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "getRow(int,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): Vec3f;
    "unprojectInv(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    setFromAddress(arg0: number): this;
    m02(arg0: number): this;
    "mulPerspectiveAffine(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    transformAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    mapnYZnX(arg0: Matrix4f_): this;
    m02(): number;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    transformTranspose(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    transpose(): this;
    "perspectiveOffCenterFov(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    "set(float[])"(arg0: number[]): this;
    m11(arg0: number): this;
    set(arg0: number[]): this;
    mulAffine(arg0: Internal.Matrix4fc_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    "project(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    positiveX(arg0: Vec3f_): Vec3f;
    setTranslation(arg0: number, arg1: number, arg2: number): this;
    m22(arg0: number): this;
    mapXnZY(): this;
    originAffine(arg0: Vec3f_): Vec3f;
    "set4x3(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    mapnZYX(): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number): this;
    "get3x4(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    normal(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    setLookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    mulTranslationAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "reflection(org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "unproject(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mul(arg0: Internal.Matrix3x2fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    "perspectiveOffCenterFovLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    scaling(arg0: Internal.Vector3fc_): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    mapnYZnX(): this;
    m00(arg0: number): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    get4x3Transposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "rotate(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.ByteBuffer_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    "getUnnormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    set3x3(arg0: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    "getTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXZY(arg0: Matrix4f_): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnXnZY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaterniondc_): this;
    mapXZY(arg0: Matrix4f_): this;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mulComponentWise(arg0: Internal.Matrix4fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    "perspectiveLH(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    add(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    swap(arg0: Matrix4f_): this;
    transformDirection(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    negateY(arg0: Matrix4f_): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    getClass(): typeof any;
    "transformProject(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    add(arg0: Internal.Matrix4fc_): this;
    determineProperties(): this;
    mapXnZnY(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    "set(float[],int)"(arg0: number[], arg1: number): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "shadow(float,float,float,float,org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    withLookAtUp(arg0: Internal.Vector3fc_): this;
    mapYnZX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapnXnYZ(): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mapnXnZnY(): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    lookAtPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    setTransposed(arg0: number[], arg1: number): this;
    mapZnXnY(arg0: Matrix4f_): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "translationRotateScaleInvert(org.joml.Vector3fc,org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    get4x3Transposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    get4x3(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    scale(arg0: Internal.Vector3fc_): this;
    "mul(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "cofactor3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    transformPosition(arg0: Vec3f_): Vec3f;
    "rotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    affineSpan(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    perspectiveFrustumSlice(arg0: number, arg1: number, arg2: Matrix4f_): this;
    transformDirection(arg0: Vec3f_): Vec3f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    determinant3x3(): number;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "frustum(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    projectedGridRange(arg0: Internal.Matrix4fc_, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXnY(arg0: Matrix4f_): this;
    rotationAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    set4x3(arg0: Matrix4f_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "setTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "get(org.joml.Matrix4d)"(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    get4x3(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    translateLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnXnYZ(arg0: Matrix4f_): this;
    normalize3x3(): this;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    mapnXnZY(): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    translation(arg0: number, arg1: number, arg2: number): this;
    "transpose3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    frustumPlane(arg0: number, arg1: Vec4f_): Vec4f;
    transformPosition(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    invertAffine(): this;
    frustumCorner(arg0: number, arg1: Vec3f_): Vec3f;
    "project(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    get(arg0: number[]): number[];
    shadow(arg0: Vec4f_, arg1: Internal.Matrix4fc_, arg2: Matrix4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    mapZXnY(arg0: Matrix4f_): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    get4x3(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "get3x4(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYnXZ(): this;
    setTransposed(arg0: number[]): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "scale(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    rotateY(arg0: number): this;
    rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    invertPerspectiveView(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    notifyAll(): void;
    add4x3(arg0: Internal.Matrix4fc_): this;
    mapnXZnY(): this;
    mulAffineR(arg0: Internal.Matrix4fc_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "orthoSymmetricLH(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    transformAffine(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    perspectiveFar(): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapnXnZnY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaternionfc_): this;
    "rotate(org.joml.AxisAngle4f,org.joml.Matrix4f)"(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    mapYnXZ(arg0: Matrix4f_): this;
    "getTransposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "perspective(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get(float[],int)"(arg0: number[], arg1: number): number[];
    "getTransposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapXnZnY(arg0: Matrix4f_): this;
    mapYXZ(): this;
    determinant(): number;
    "reflect(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    add4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    wait(arg0: number, arg1: number): void;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "perspectiveOffCenter(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapnXZnY(arg0: Matrix4f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    translate(arg0: Internal.Vector3fc_): this;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    m30(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    "getUnnormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "mul(org.joml.Matrix3x2fc)"(arg0: Internal.Matrix3x2fc_): this;
    getTranslation(arg0: Vec3f_): Vec3f;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    invertPerspectiveView(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    set transposedFromAddress(arg0: number)
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    get finite(): boolean
    set transposed(arg0: Internal.FloatBuffer_)
    set "(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "transposed(float[])"(arg0: number[])
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set transposed(arg0: Internal.ByteBuffer_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "transposed(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set "(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set translation(arg0: Internal.Vector3fc_)
    get affine(): boolean
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set "(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set transposed(arg0: Internal.Matrix4fc_)
    set "transposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set fromAddress(arg0: number)
    set "(float[])"(arg0: number[])
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    get class(): typeof any
    set "transposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set transposed(arg0: number[])
}
type Matrix4f_ = Matrix4f;
/**
 * The hub for all things text components. Format text to your hearts content!
*/
declare class Component {
    constructor()
    getClass(): typeof any;
    /**
     * Returns a component of the input, colored light purple
    */
    static lightPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored blue
    */
    static blue(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translatable(key: string): Internal.MutableComponent;
    /**
     * Returns a ClickEvent of the input
    */
    static clickEventOf(o: any): Internal.ClickEvent;
    /**
     * Returns a colorful representation of the input nbt. Useful for displaying NBT to the player
    */
    static prettyPrintNbt(tag: Internal.Tag_): net.minecraft.network.chat.Component;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translatable(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns an empty component
    */
    static empty(): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored white
    */
    static white(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translate(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a plain component of the string, or empty if it is an empty string
    */
    static ofString(s: string): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translate(key: string): Internal.MutableComponent;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    /**
     * Returns a component displaying all entities matching the input selector
    */
    static selector(selector: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored yellow
    */
    static yellow(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark purple
    */
    static darkPurple(text: any): Internal.MutableComponent;
    /**
     * Checks if the passed in component, and all its children are empty
    */
    static isEmpty(component: net.minecraft.network.chat.Component_): boolean;
    /**
     * Returns a Component of the input
    */
    static of(o: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gray
    */
    static gray(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark blue
    */
    static darkBlue(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark red
    */
    static darkRed(text: any): Internal.MutableComponent;
    toString(): string;
    /**
     * Returns a component of the input, colored gold
    */
    static gold(text: any): Internal.MutableComponent;
    notifyAll(): void;
    /**
     * Returns a component of the input, colored red
    */
    static red(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark green
    */
    static darkGreen(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored green
    */
    static green(text: any): Internal.MutableComponent;
    /**
     * Returns a keybinding component of the input keybinding descriptor
    */
    static keybind(keybind: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark aqua
    */
    static darkAqua(text: any): Internal.MutableComponent;
    /**
     * Joins all components
    */
    static join(...texts: net.minecraft.network.chat.Component_[]): Internal.MutableComponent;
    hashCode(): number;
    /**
     * Returns a score component of the input objective, for the provided selector
    */
    static score(selector: string, objective: string): Internal.MutableComponent;
    /**
     * Returns a plain component of the passed in string, even if empty
    */
    static string(text: string): Internal.MutableComponent;
    wait(): void;
    /**
     * Returns a component displaying all entities matching the input selector, with a custom separator
    */
    static selector(selector: string, separator: net.minecraft.network.chat.Component_): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored aqua
    */
    static aqua(text: any): Internal.MutableComponent;
    /**
     * Joins all components in the list with the separator component
    */
    static join(separator: Internal.MutableComponent_, texts: Internal.Iterable_<net.minecraft.network.chat.Component>): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored black
    */
    static black(text: any): Internal.MutableComponent;
    wait(arg0: number): void;
    /**
     * Returns a component of the input, colored dark gray
    */
    static darkGray(text: any): Internal.MutableComponent;
    /**
     * Returns a plain component of the input
    */
    static literal(text: string): Internal.MutableComponent;
    equals(arg0: any): boolean;
    get class(): typeof any
}
type Component_ = Component;
/**
 * A collection of utilities
*/
declare interface Utils {
    /**
     * Capitalises the first letter of the string unless it is "a", "an", "the", "of", "on", "in", "and", "or", "but" or "for"
    */
    toTitleCase(s: string): string;
    /**
     * Returns a Stat of the passed in ResourceLocation.
     * Note that this requires the same ResourceLocation to get the same stat, so should not be used unless you want to make your own stat, and are storing an actual ResourceLocation somewhere to access it.
    */
    getStat(id: ResourceLocation_): Internal.Stat<ResourceLocation>;
    /**
     * Returns the provided snake_case_string in Title Case
    */
    snakeCaseToTitleCase(string: string): string;
    /**
     * Returns a new counting map
    */
    newCountingMap(): Internal.CountingMap;
    /**
     * Capitalises the first letter of the string. If ignoreSpecial is true, it will also capitalise articles and prepositions
    */
    toTitleCase(s: string, ignoreSpecial: boolean): string;
    /**
     * Tries to parse the first parameter as a double and returns that. The second parameter is returned if parsing fails
    */
    parseDouble(object: any, def: number): number;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    getRandom(): Internal.Random;
    /**
     * Returns a new mutable list
    */
    newList(): Internal.List<any>;
    /**
     * Returns the results of rolling the specified loot table (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_): Internal.List<Internal.ItemStack>;
    /**
     * Get a new random with the specified seed
    */
    newRandom(seed: number): Internal.Random;
    /**
     * Gets all ids from the registry with the specified id
    */
    getRegistryIds(id: ResourceLocation_): Internal.List<ResourceLocation>;
    /**
     * Gets the current system time, in milliseconds
    */
    getSystemTime(): number;
    /**
     * Get an immutable empty list
    */
    emptyList<T>(): Internal.List<T>;
    /**
     * Runs the provided supplier function in KubeJS' background thread and returns its CompletableFuture
    */
    supplyAsync(task: Internal.Supplier_<any>): Internal.CompletableFuture<any>;
    /**
     * Returns a ResourceLocation with the specified namepsace and path
    */
    id(namespace: string, path: string): ResourceLocation;
    /**
     * Returns a lazy value with the supplier function as its value factory
    */
    lazy<T>(supplier: Internal.Supplier_<T>): Internal.Lazy<T>;
    /**
     * Checks if the passed in object is an instance of WrappedJS
    */
    isWrapped(o: any): boolean;
    /**
     * Returns the provided snake_case_string in camelCase
    */
    snakeCaseToCamelCase(string: string): string;
    /**
     * Returns the creative tab associated with the id
    */
    findCreativeTab(id: ResourceLocation_): Internal.CreativeModeTab;
    /**
     * Gets a SoundEvent from the id
    */
    getSound(id: ResourceLocation_): Internal.SoundEvent;
    /**
     * Returns a lazy value with the supplier function as its value factory, that will expire after the specified number of milliseconds
    */
    expiringLazy<T>(supplier: Internal.Supplier_<T>, time: number): Internal.Lazy<T>;
    /**
     * Get an immutable empty map
    */
    emptyMap<K, V>(): Internal.Map<K, V>;
    /**
     * Gets a random object from the list using the passed in random
    */
    randomOf(random: Internal.Random_, objects: Internal.Collection_<any>): any;
    /**
     * Gets the specified registry
    */
    getRegistry(id: ResourceLocation_): Internal.RegistryInfo<any>;
    /**
     * Returns a new mutable map
    */
    newMap(): Internal.Map<any, any>;
    particleOptions(o: any): Internal.ParticleOptions;
    /**
     * Returns a copy the object if possible, or the object itself if not
    */
    copy(o: any): any;
    /**
     * Returns a regex pattern of the input with the specified flags
    */
    regex(pattern: string, flags: number): Internal.Pattern;
    /**
     * Typewraps the input string to a ResourceLocation. Format should be namespace:path
    */
    id(id: ResourceLocation_): ResourceLocation;
    /**
     * Returns a regex pattern of the input
    */
    regex(s: any): Internal.Pattern;
    /**
     * Runs the provided runnable function in KubeJS' background thread and returns its CompletableFuture
    */
    runAsync(task: Internal.Runnable_): Internal.CompletableFuture<void>;
    /**
     * Parses a block state from the input string. May throw for invalid inputs!
    */
    parseBlockState(o: any): Internal.BlockState;
    /**
     * Immediately run the passed runnable function in a try-catch block, and log the exception if it throws
    */
    queueIO(runnable: Internal.Runnable_): void;
    /**
     * Tries to parse the first parameter as an integer, and returns that. The second parameter is returned if parsing fails
    */
    parseInt(object: any, def: number): number;
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    getServer(): Internal.MinecraftServer;
    /**
     * Returns the results of rolling the specified loot table with the entity as a parameter (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_, entity: Internal.Entity_): Internal.List<Internal.ItemStack>;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    get random(): Internal.Random
    /**
     * Gets the current system time, in milliseconds
    */
    get systemTime(): number
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    get server(): Internal.MinecraftServer
    readonly ERROR_PARTICLE: (Internal.DustParticleOptions) & (Internal.DustParticleOptions);
}
type Utils_ = Utils;
declare const Utils: Utils;
declare interface AABB {
    ofSize(vec3: Vec3d_, x: number, y: number, z: number): Internal.AABB;
    ofBlock(pos: BlockPos_): Internal.AABB;
    of(x0: number, y0: number, z0: number, x1: number, y1: number, z1: number): Internal.AABB;
    ofSize(x: number, y: number, z: number): Internal.AABB;
    ofBlocks(pos1: BlockPos_, pos2: BlockPos_): Internal.AABB;
    wrap(o: any): Internal.AABB;
    readonly CUBE: (Internal.AABB) & (Internal.AABB);
    readonly EMPTY: (Internal.AABB) & (Internal.AABB);
}
type AABB_ = AABB;
declare const AABB: AABB;
declare class PonderInputWindowElement extends Internal.AnimatedOverlayElementBase {
    constructor(arg0: Vec3d_, arg1: PonderPointing_)
    getClass(): typeof any;
    render(arg0: Internal.PonderScene_, arg1: Internal.PonderUI_, arg2: Internal.GuiGraphics_, arg3: number, arg4: number): void;
    render(arg0: Internal.PonderScene_, arg1: Internal.PonderUI_, arg2: Internal.GuiGraphics_, arg3: number): void;
    getFade(arg0: number): number;
    toString(): string;
    notifyAll(): void;
    builder(): Internal.InputElementBuilder;
    tick(arg0: Internal.PonderScene_): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    reset(arg0: Internal.PonderScene_): void;
    wait(): void;
    wait(arg0: number): void;
    setFade(arg0: number): void;
    whileSkipping(arg0: Internal.PonderScene_): void;
    equals(arg0: any): boolean;
    isVisible(): boolean;
    setVisible(arg0: boolean): void;
    get class(): typeof any
    set fade(arg0: number)
    get visible(): boolean
    set visible(arg0: boolean)
}
type PonderInputWindowElement_ = PonderInputWindowElement;
declare namespace Special {
    type Mod = "kuma_api" | "sodiumextras" | "scena" | "immersive_aircraft" | "sophisticatedcore" | "noautojump" | "bowinfinityfix" | "controlling" | "modernfix" | "create_factory_logistics" | "create_more_additions" | "gravestonecurioscompat" | "bookshelf" | "sophisticatedbackpacks" | "railways" | "balm" | "createbetterfps" | "carryon" | "sodiumoptionsapi" | "jeresources" | "baguettelib" | "cloth_config" | "sodiumdynamiclights" | "ok_zoomer" | "embeddium" | "rubidium" | "create_connected" | "glodium" | "entity_model_features" | "entity_texture_features" | "fastipping" | "gottagofast" | "modelfix" | "curios" | "oculus" | "searchables" | "angelring" | "ftbultimine" | "sodiumoptionsmodcompat" | "createrailwaysnavigator" | "moreoverlays" | "transition" | "tinkerleveling" | "dynamic_fps" | "modder_name_lib" | "fastleafdecay" | "codechickenlib" | "cb_multipart" | "cb_microblock" | "cb_multipart_minecraft" | "create_factory_abstractions" | "kubejsbotanypots" | "enchantinginfuser" | "borderlesswindow" | "fastback" | "bellsandwhistles" | "rhino" | "neo_auth" | "cucumber" | "jmi" | "fastboot" | "copycats" | "jei" | "trender" | "invtweaks" | "clumps" | "journeymap" | "configured" | "botanypots" | "guideme" | "memoryleakfix" | "enderstorage" | "puzzlesaccessapi" | "forge" | "fasterladderclimbing" | "mysticalagriculture" | "mysticalagradditions" | "craftingtweaks" | "minecraft" | "cofh_core" | "thermal" | "thermal_foundation" | "thermal_expansion" | "distanthorizons" | "tconstruct" | "dragonlib" | "architectury" | "kubejs" | "probejs" | "ftblibrary" | "ftbteams" | "ponderjs" | "ftbchunks" | "fabric_api_base" | "mousetweaks" | "wildfire_gender" | "nochatreports" | "jade" | "ae2" | "ae2netanalyser" | "ae2wtlib" | "createappliedkinetics" | "expatternprovider" | "extendedae_plus" | "spectrelib" | "wrench_wrapper" | "enderio" | "flywheel" | "ponder" | "irisflw" | "create" | "createdeco" | "create_mechanical_extruder" | "extra_gauges" | "mantle" | "gravestone" | "polymorph" | "polyeng" | "storagedrawers" | "immersive_paintings" | "entityculling" | "cryonicconfig" | "kubejs_create" | "immediatelyfast" | "automobility" | "appleskin" | "ferritecore" | "chisel" | "embeddium_extra" | "puzzleslib" | "rebind_narrator" | "chiselsandbits" | "journeymapteams" | "createaddition"
    type Ingredient = "codechickenlib:conditional" | "kubejs:wildcard" | "kubejs:custom" | "kubejs:custom_predicate" | "kubejs:mod" | "kubejs:regex" | "kubejs:creative_tab" | "forge:compound" | "forge:nbt" | "forge:partial_nbt" | "forge:difference" | "forge:intersection" | "minecraft:item" | "mysticalagriculture:all_hoes" | "mysticalagriculture:filled_soul_jars" | "mysticalagriculture:crop_component" | "tconstruct:no_container" | "tconstruct:block_tag" | "tconstruct:material" | "tconstruct:material_value" | "tconstruct:tool_hook" | "create:block_tag_ingredient" | "mantle:fluid_container" | "mantle:potion" | "cofh_core:with_count";
    type Advancement = "createdeco:recipes/building_blocks/long_umber_brick_slab" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_magenta" | "createdeco:recipes/building_blocks/umber_brick_slab_from_corner_umber_bricks_stonecutting" | "minecraft:recipes/decorations/brick_wall" | "enderio:recipes/misc/conduit_probe" | "create:recipes/misc/crafting/logistics/gray_table_cloth_clear" | "tconstruct:tools/materials_and_you" | "tconstruct:recipes/decorations/common/glass/purple_clear_stained_glass_pane_from_panes" | "minecraft:recipes/building_blocks/polished_deepslate" | "createdeco:recipes/building_blocks/short_red_brick_stairs_from_tiled_red_brick_stairs_stonecutting" | "create_connected:recipes/crafting/kinetics/six_way_gearbox" | "enderio:recipes/building_blocks/recolor_clear_glass_e_blue" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_locometal_smokebox" | "minecraft:husbandry/allay_deliver_item_to_player" | "minecraft:recipes/combat/leather_helmet" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab" | "ae2:recipes/misc/misc/tank_sky_stone" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_locometal_boiler" | "ae2:recipes/misc/block_cutter/stairs/smooth_quartz_stairs" | "enderio:recipes/building_blocks/recolor_clear_glass_e_light_blue" | "minecraft:recipes/decorations/ladder" | "createdeco:recipes/building_blocks/cracked_dusk_brick_stairs_from_cracked_dusk_bricks_stonecutting" | "createdeco:recipes/decorations/light_blue_shipping_container" | "minecraft:recipes/decorations/magenta_stained_glass_pane" | "copycats:recipes/crafting/copycat_slope" | "minecraft:recipes/building_blocks/stripped_mangrove_wood" | "enderio:recipes/building_blocks/recolor_clear_glass_da_white" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_brass_wrapped_locometal" | "createdeco:recipes/decorations/copper_support_wedge" | "create:recipes/building_blocks/cut_tuff_from_stone_types_tuff_stonecutting" | "create:recipes/building_blocks/small_ochrum_brick_slab_recycling" | "create:recipes/misc/smelting/ingot_osmium_compat_mekanism" | "createdeco:recipes/building_blocks/corner_umber_brick_stairs_from_umber_bricks_stonecutting" | "tconstruct:recipes/misc/common/materials/manyullyn_nugget_from_ingot" | "createdeco:recipes/decorations/zinc_bars_from_stonecutting" | "createdeco:recipes/building_blocks/short_dean_bricks_from_dean_bricks_stonecutting" | "create:recipes/building_blocks/cut_deepslate_brick_stairs" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs_from_short_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_short_dean_brick_stairs_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_em_red" | "createdeco:recipes/building_blocks/tiled_verdant_bricks_from_short_verdant_bricks_stonecutting" | "create:recipes/building_blocks/cut_andesite_brick_stairs" | "ae2:recipes/misc/network/cables/dense_smart_fluix_clean" | "createdeco:recipes/building_blocks/short_red_bricks_from_long_red_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_plated_locometal" | "railways:recipes/misc/crafting/palettes/wrapping/green_brass_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_locometal_boiler" | "ae2:recipes/misc/network/parts/import_bus" | "tconstruct:recipes/misc/common/puny_smelting" | "copycats:recipes/crafting/copycat_layer" | "createdeco:recipes/building_blocks/tiled_red_bricks_from_short_red_bricks_stonecutting" | "create:recipes/decorations/brass_bars_from_ingots_brass_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_iron_wrapped_locometal" | "enderio:recipes/misc/copper_alloy_block" | "enderio:recipes/building_blocks/recolor_fused_quartz_purple" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_orange" | "create:recipes/building_blocks/small_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "create:recipes/misc/smelting/zinc_ingot_from_ore" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs" | "minecraft:recipes/misc/emerald" | "createdeco:recipes/decorations/iron_catwalk_stairs_from_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_green" | "enderio:recipes/building_blocks/invert_fused_quartz_da" | "ae2:recipes/misc/decorative/quartz_fixture" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "create:recipes/building_blocks/cut_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/decorations/deepslate_brick_wall_from_deepslate_bricks_stonecutting" | "create:recipes/building_blocks/scoria_from_stone_types_scoria_stonecutting" | "createdeco:recipes/building_blocks/short_dusk_brick_wall_from_dusk_bricks_stonecutting" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_copper_stonecutting" | "create:recipes/misc/crafting/kinetics/light_gray_valve_handle_from_other_valve_handle" | "railways:recipes/misc/crafting/copycat_headstock_link_and_pin" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab" | "create:recipes/building_blocks/crafting/kinetics/yellow_seat_from_other_seat" | "minecraft:adventure/trim_with_all_exclusive_armor_patterns" | "minecraft:recipes/misc/copper_ingot_from_blasting_deepslate_copper_ore" | "tconstruct:recipes/decorations/tables/tinker_station" | "create:recipes/misc/crafting/kinetics/chute" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_tiled_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/yellow_brass_wrapped_locometal" | "create:recipes/misc/crafting/kinetics/brown_valve_handle_from_other_valve_handle" | "ae2:recipes/misc/shaped/walls/sky_stone_brick" | "createdeco:recipes/building_blocks/mossy_pearl_brick_stairs" | "minecraft:recipes/building_blocks/smooth_quartz_slab" | "ae2:recipes/misc/shaped/slabs/sky_stone_small_brick" | "sophisticatedbackpacks:recipes/misc/advanced_feeding_upgrade" | "minecraft:recipes/building_blocks/end_stone_brick_slab" | "createdeco:recipes/building_blocks/long_dean_bricks_from_tiled_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_brick_wall_from_dean_bricks_stonecutting" | "minecraft:recipes/decorations/polished_deepslate_wall" | "create:recipes/building_blocks/granite_from_stone_types_granite_stonecutting" | "createdeco:recipes/building_blocks/long_red_brick_slab_from_short_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/mossy_dusk_bricks_from_vine" | "create:clockwork_bearing" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_long_dean_bricks_stonecutting" | "minecraft:recipes/decorations/orange_bed" | "createdeco:recipes/building_blocks/corner_red_brick_stairs_from_tiled_red_brick_stairs_stonecutting" | "minecraft:recipes/food/cooked_chicken_from_campfire_cooking" | "enderio:recipes/building_blocks/recolor_clear_glass_em_purple" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_cyan" | "minecraft:recipes/building_blocks/deepslate_bricks" | "expatternprovider:recipes/misc/ebus_upgrade" | "createdeco:recipes/building_blocks/blue_brick_slab_from_long_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_dean_bricks_stonecutting" | "create:recipes/building_blocks/weathered_copper_shingle_slab_from_weathered_copper_shingles_stonecutting" | "enderio:recipes/tools/staff_of_levity" | "create:recipes/building_blocks/cut_diorite_brick_wall" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_verdant_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/corner_blue_brick_wall_from_short_blue_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/corner_umber_brick_wall_from_short_umber_brick_wall_stonecutting" | "tconstruct:recipes/misc/common/materials/steel_ingot_from_block" | "createdeco:recipes/building_blocks/cracked_blue_brick_wall" | "tconstruct:recipes/misc/common/materials/netherite_nugget_from_ingot" | "create:recipes/building_blocks/cut_ochrum_wall" | "sophisticatedbackpacks:recipes/misc/deposit_upgrade" | "create:recipes/building_blocks/crafting/logistics/yellow_table_cloth" | "minecraft:recipes/building_blocks/light_blue_stained_glass" | "create:recipes/misc/crafting/kinetics/elevator_pulley" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_corner_scarlet_bricks_stonecutting" | "minecraft:recipes/misc/lapis_lazuli_from_blasting_lapis_ore" | "createdeco:recipes/building_blocks/corner_pearl_brick_stairs_from_pearl_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_np_light_gray" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_from_brick" | "minecraft:recipes/decorations/light_gray_glazed_terracotta" | "minecraft:recipes/building_blocks/mossy_stone_bricks_from_vine" | "minecraft:recipes/redstone/birch_button" | "minecraft:recipes/building_blocks/jungle_wood" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_brown" | "minecraft:recipes/combat/netherite_chestplate_smithing" | "create:recipes/building_blocks/cut_diorite_brick_stairs" | "minecraft:recipes/decorations/purple_glazed_terracotta" | "tconstruct:recipes/misc/tables/pattern" | "minecraft:story/deflect_arrow" | "createdeco:recipes/building_blocks/scarlet_bricks_from_short_scarlet_bricks_stonecutting" | "tconstruct:recipes/decorations/common/glass/lime_clear_stained_glass_pane_from_panes" | "railways:recipes/misc/crafting/palettes/wrapping/green_copper_wrapped_locometal" | "ae2:recipes/misc/tools/paintballs_purple" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_white" | "createdeco:recipes/building_blocks/corner_umber_brick_wall_from_short_umber_bricks_stonecutting" | "enderio:recipes/building_blocks/invert_fused_quartz_ep" | "enderio:recipes/building_blocks/invert_fused_quartz_em" | "create:recipes/building_blocks/cut_veridium_brick_slab_from_stone_types_veridium_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_gray" | "createdeco:recipes/building_blocks/short_blue_brick_wall_from_corner_blue_brick_wall_stonecutting" | "enderio:recipes/building_blocks/invert_fused_quartz_ea" | "createdeco:recipes/building_blocks/dusk_bricks_from_short_dusk_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_purple" | "createdeco:recipes/building_blocks/mossy_blue_bricks_from_vine" | "enderio:recipes/misc/dark_steel_nugget" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_slashed_locometal" | "enderio:recipes/building_blocks/invert_fused_quartz_dp" | "enderio:recipes/redstone/resetting_lever_three_hundred" | "enderio:recipes/misc/photovoltaic_composite" | "enderio:recipes/building_blocks/invert_fused_quartz_dm" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_soul_glass" | "create:recipes/misc/crafting/kinetics/package_filter" | "enderio:recipes/building_blocks/recolor_clear_glass_e_lime" | "create:recipes/misc/crafting/kinetics/gantry_shaft" | "createdeco:recipes/building_blocks/verdant_bricks_from_corner_verdant_bricks_stonecutting" | "createdeco:recipes/decorations/zinc_catwalk_railing_from_stonecutting" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_long_blue_brick_stairs_stonecutting" | "tconstruct:world/earth_island" | "createdeco:recipes/building_blocks/corner_red_brick_slab_from_short_red_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_andesite_stairs_from_stone_types_andesite_stonecutting" | "minecraft:recipes/brewing/magma_cream" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_long_pearl_brick_slab_stonecutting" | "create:recipes/building_blocks/cut_scoria_stairs" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_locometal_pillar" | "storagedrawers:recipes/storagedrawers/one_stack_upgrade" | "create:recipes/building_blocks/cut_granite_brick_slab_from_stone_types_granite_stonecutting" | "create:recipes/building_blocks/small_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "minecraft:nether/brew_potion" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_tiled_dusk_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/short_umber_bricks_from_corner_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_plated_locometal" | "createdeco:recipes/building_blocks/corner_dean_brick_stairs" | "createdeco:recipes/building_blocks/long_scarlet_brick_wall_from_corner_scarlet_brick_wall_stonecutting" | "ae2:recipes/misc/network/blocks/cell_workbench" | "createdeco:recipes/decorations/red_andesite_lamp" | "create:recipes/building_blocks/dark_oak_window" | "minecraft:recipes/decorations/deepslate_tile_wall_from_deepslate_tiles_stonecutting" | "minecraft:recipes/decorations/purple_stained_glass_pane_from_glass_pane" | "create:recipes/building_blocks/polished_cut_crimsite_wall" | "createdeco:recipes/building_blocks/short_scarlet_brick_wall_from_corner_scarlet_bricks_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tile_slab_from_honeycomb" | "ae2:recipes/misc/tools/fluix_sword" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal" | "tconstruct:recipes/building_blocks/smeltery/scorched/chiseled_scorched_bricks_crafting" | "extra_gauges:recipes/redstone/counter_gauge" | "minecraft:husbandry/fishy_business" | "tconstruct:recipes/building_blocks/common/glass/cyan_clear_stained_glass" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_plated_locometal" | "enderio:recipes/redstone/resetting_lever_five_from_inv" | "create:recipes/misc/crafting/kinetics/mechanical_press" | "createdeco:recipes/building_blocks/corner_umber_brick_wall_from_umber_brick_wall_stonecutting" | "minecraft:nether/explore_nether" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_long_pearl_brick_stairs_stonecutting" | "ae2:recipes/misc/network/cells/item_storage_cell_64k" | "enderio:recipes/misc/conductive_alloy_grinding_ball" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tile_stairs_from_honeycomb" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_plated_locometal" | "ae2:recipes/misc/network/upgrade_wireless_crafting_terminal" | "minecraft:recipes/building_blocks/polished_diorite" | "create:recipes/decorations/brass_ladder_from_ingots_brass_stonecutting" | "create:recipes/building_blocks/cut_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "create:recipes/misc/crafting/kinetics/rope_pulley" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_magenta" | "minecraft:recipes/building_blocks/raw_iron_block" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingles_from_honeycomb" | "create:recipes/building_blocks/polished_cut_veridium_from_stone_types_veridium_stonecutting" | "createdeco:recipes/building_blocks/corner_pearl_brick_slab_from_long_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/mud_brick_slab_from_mud_bricks_stonecutting" | "tconstruct:recipes/redstone/world/wood/skyroot/door" | "chiselsandbits:recipes/tools/magnifying_glass" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_green" | "create:recipes/building_blocks/crafting/kinetics/green_seat_from_other_seat" | "createdeco:recipes/building_blocks/corner_blue_brick_slab_from_long_blue_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_tuff_from_stone_types_tuff_stonecutting" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_corner_dean_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_flat_riveted_locometal" | "ae2:recipes/misc/tools/portable_fluid_cell_4k" | "railways:recipes/misc/crafting/palettes/wrapping/lime_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_long_scarlet_brick_stairs_stonecutting" | "createdeco:recipes/decorations/industrial_iron_support_wedge" | "createdeco:recipes/building_blocks/dean_brick_wall_from_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/end_stone_brick_slab_from_end_stone_stonecutting" | "minecraft:recipes/decorations/blue_stained_glass_pane_from_glass_pane" | "minecraft:recipes/misc/netherite_scrap_from_blasting" | "create:glass_pipe" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_long_blue_bricks_stonecutting" | "minecraft:recipes/combat/diamond_sword" | "minecraft:recipes/decorations/cyan_stained_glass_pane" | "create:recipes/combat/crafting/appliances/netherite_diving_helmet_from_netherite" | "minecraft:recipes/building_blocks/stripped_warped_hyphae" | "minecraft:recipes/decorations/jukebox" | "ae2:recipes/misc/block_cutter/stairs/smooth_sky_stone_stairs" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_flat_slashed_locometal" | "minecraft:recipes/misc/silence_armor_trim_smithing_template_smithing_trim" | "enderio:recipes/building_blocks/invert_fused_quartz_nm" | "enderio:recipes/building_blocks/invert_fused_quartz_np" | "enderio:recipes/building_blocks/recolor_clear_glass_e_yellow" | "tconstruct:recipes/building_blocks/world/wood/enderbark/log_to_wood" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/slab" | "minecraft:recipes/misc/gold_nugget" | "enderio:recipes/building_blocks/invert_fused_quartz_na" | "ae2:recipes/misc/network/blocks/pattern_providers_interface_part" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_cyan" | "ae2:recipes/misc/network/blocks/quantum_link" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_plated_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_flat_riveted_locometal" | "minecraft:recipes/building_blocks/smooth_sandstone_slab_from_smooth_sandstone_stonecutting" | "minecraft:nether/all_effects" | "ae2:recipes/misc/decorative/certus_quartz_bricks" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_riveted_locometal" | "createdeco:recipes/building_blocks/tiled_verdant_brick_wall" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingle_stairs_from_honeycomb" | "createdeco:recipes/building_blocks/short_dusk_brick_wall_from_short_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_short_dean_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_locometal_smokebox" | "railways:recipes/misc/crafting/track_switch_brass" | "enderio:recipes/redstone/resetting_lever_ten_inv_from_prev" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_copper_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_locometal_pillar" | "enderio:recipes/building_blocks/recolor_clear_glass_na_yellow" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_black" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_iron_wrapped_locometal_boiler" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_yellow" | "create:recipes/building_blocks/cut_scorchia_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/decorations/white_glazed_terracotta" | "minecraft:recipes/combat/iron_helmet" | "minecraft:recipes/tools/golden_shovel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/dye_magenta_carpet" | "create:recipes/building_blocks/oxidized_copper_shingle_stairs" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_verdant_bricks_stonecutting" | "copycats:recipes/crafting/copycat_iron_trapdoor" | "createdeco:recipes/building_blocks/corner_dusk_brick_slab_from_tiled_dusk_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/smart_chute" | "create:recipes/building_blocks/polished_cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_iron_wrapped_locometal" | "createdeco:recipes/decorations/industrial_iron_bars_from_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_pink" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_magenta" | "minecraft:recipes/food/beetroot_soup" | "createdeco:recipes/decorations/brass_bars_overlay" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_green" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_locometal_smokebox" | "minecraft:recipes/food/golden_apple" | "createdeco:recipes/building_blocks/tiled_umber_brick_wall_from_corner_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_wall_from_corner_blue_brick_wall_stonecutting" | "ae2:recipes/misc/misc/fluixpearl" | "minecraft:recipes/building_blocks/orange_stained_glass" | "createdeco:recipes/building_blocks/blue_bricks_from_corner_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/purple_brass_wrapped_locometal" | "ae2:recipes/misc/tools/portable_fluid_cell_1k" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_long_pearl_brick_slab_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_riveted_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_black" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_short_dean_brick_stairs_stonecutting" | "minecraft:adventure/two_birds_one_arrow" | "minecraft:recipes/decorations/end_crystal" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_tiled_verdant_bricks_stonecutting" | "enderio:recipes/redstone/resetting_lever_thirty_inv_from_base" | "ae2:recipes/misc/network/crafting/256k_cpu_crafting_storage" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_purple" | "enderio:recipes/misc/void_chassis" | "tconstruct:smeltery/melter" | "createdeco:recipes/decorations/brass_catwalk_stairs_from_stonecutting" | "create:root" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_brass_wrapped_locometal" | "tconstruct:recipes/building_blocks/common/glass/light_blue_clear_stained_glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_riveted_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_a_gray" | "createdeco:recipes/building_blocks/dusk_bricks_from_long_dusk_bricks_stonecutting" | "create:train_crash_backwards" | "create:recipes/building_blocks/exposed_copper_tile_stairs" | "minecraft:recipes/decorations/soul_lantern" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_light_gray" | "minecraft:recipes/misc/sentry_armor_trim_smithing_template" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_yellow" | "enderio:recipes/building_blocks/recolor_clear_glass_e_green" | "minecraft:recipes/decorations/cherry_fence" | "createdeco:recipes/building_blocks/corner_blue_brick_slab_from_long_blue_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_short_blue_bricks_stonecutting" | "expatternprovider:recipes/misc/assembler_matrix_pattern" | "minecraft:recipes/decorations/birch_fence" | "minecraft:recipes/decorations/sandstone_wall_from_sandstone_stonecutting" | "create:recipes/misc/crafting/kinetics/andesite_door" | "sophisticatedbackpacks:recipes/misc/advanced_refill_upgrade" | "ae2:recipes/misc/network/cells/spatial_components_1" | "createdeco:recipes/building_blocks/mossy_red_brick_slab" | "ae2:recipes/misc/network/cells/spatial_components_0" | "minecraft:recipes/combat/golden_boots" | "enderio:recipes/building_blocks/recolor_clear_glass_d_black" | "railways:recipes/misc/crafting/link_and_pin" | "minecraft:recipes/tools/wooden_axe" | "tconstruct:recipes/decorations/world/wood/enderbark/hanging_sign" | "tconstruct:recipes/redstone/smeltery/scorched/gauge" | "minecraft:recipes/building_blocks/chiseled_sandstone" | "create_connected:recipes/crafting/kinetics/six_way_gearbox_from_gearbox" | "create:recipes/building_blocks/cut_limestone_slab" | "ae2:recipes/misc/network/cables/dense_smart_light_gray" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_long_dusk_brick_stairs_stonecutting" | "createdeco:recipes/decorations/light_gray_placard" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_corner_pearl_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_wall_from_corner_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_tiled_umber_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_flat_riveted_locometal" | "create:potato_cannon" | "create:recipes/misc/crafting/kinetics/spout" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_black" | "ae2:recipes/misc/network/cells/spatial_storage_cell_16_cubed" | "createdeco:recipes/building_blocks/corner_red_brick_slab" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_tiled_verdant_bricks_stonecutting" | "create:recipes/building_blocks/cut_deepslate_from_stone_types_deepslate_stonecutting" | "copycats:recipes/crafting/copycat_vertical_half_layer" | "minecraft:recipes/decorations/yellow_stained_glass_pane" | "createdeco:recipes/building_blocks/short_red_brick_stairs_from_corner_red_brick_stairs_stonecutting" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_honeycomb" | "minecraft:recipes/building_blocks/granite_slab_from_granite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_copper_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/corner_dusk_brick_stairs_from_long_dusk_bricks_stonecutting" | "ae2wtlib:recipes/wireless_universal_terminal/upgrade_pattern_access" | "create:recipes/building_blocks/cut_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_wall" | "createdeco:recipes/building_blocks/tiled_blue_brick_wall_from_short_blue_brick_wall_stonecutting" | "tconstruct:recipes/misc/common/materials/cinderslime_nugget_from_ingot" | "createdeco:recipes/building_blocks/corner_scarlet_brick_slab_from_corner_scarlet_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_scoria_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/small_tuff_brick_slab_recycling" | "tconstruct:smeltery/gold_casting" | "minecraft:recipes/building_blocks/cut_sandstone" | "minecraft:recipes/building_blocks/smooth_red_sandstone" | "createdeco:recipes/building_blocks/tiled_pearl_brick_wall_from_short_pearl_brick_wall_stonecutting" | "minecraft:recipes/decorations/blackstone_wall" | "minecraft:recipes/misc/cyan_dye_from_pitcher_plant" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_green" | "enderio:recipes/building_blocks/collision_token_fused_quartz_p" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs_from_long_red_brick_stairs_stonecutting" | "ae2:recipes/misc/network/cables/covered_brown" | "enderio:recipes/building_blocks/collision_token_fused_quartz_m" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab_from_weathered_cut_copper_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_black" | "create:chained_drain" | "minecraft:recipes/decorations/purple_candle" | "createdeco:recipes/building_blocks/corner_scarlet_brick_slab_from_scarlet_bricks_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/blue_seat" | "minecraft:recipes/decorations/pink_glazed_terracotta" | "minecraft:recipes/misc/coal" | "minecraft:recipes/transportation/spruce_chest_boat" | "createdeco:recipes/building_blocks/blue_brick_slab_from_tiled_blue_bricks_stonecutting" | "enderio:recipes/building_blocks/collision_token_fused_quartz_a" | "create:recipes/building_blocks/crafting/logistics/gray_postbox_from_other_postbox" | "createdeco:recipes/building_blocks/corner_dusk_brick_wall_from_long_dusk_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_corner_dusk_bricks_stonecutting" | "minecraft:recipes/combat/leather_chestplate" | "createdeco:recipes/building_blocks/tiled_dean_brick_wall_from_corner_dean_bricks_stonecutting" | "ae2:recipes/misc/network/cells/item_storage_cell_256k" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_green" | "minecraft:recipes/misc/magenta_dye_from_blue_red_pink" | "tconstruct:recipes/redstone/world/wood/enderbark/fence_gate" | "createdeco:recipes/building_blocks/corner_verdant_brick_stairs_from_short_verdant_bricks_stonecutting" | "minecraft:recipes/decorations/yellow_candle" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_purple" | "minecraft:nether/obtain_blaze_rod" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_flat_riveted_locometal" | "enderio:recipes/redstone/resetting_lever_ten" | "createdeco:recipes/building_blocks/corner_dusk_brick_wall_from_long_dusk_bricks_stonecutting" | "ae2:recipes/misc/network/cables/dense_smart_white" | "create:recipes/building_blocks/cut_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "create:recipes/misc/crafting/kinetics/placard" | "createdeco:recipes/building_blocks/tiled_dusk_bricks_from_short_dusk_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_a_orange" | "create:recipes/misc/crafting/logistics/stock_ticker_clear" | "immersive_aircraft:misc/aircraftery" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_black" | "create:recipes/building_blocks/small_tuff_brick_wall" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_corner_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/light_gray_iron_wrapped_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_e_black" | "create:recipes/building_blocks/polished_cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "enderio:recipes/misc/conduit_binder_from_blasting" | "minecraft:adventure/shoot_arrow" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_slashed_locometal" | "minecraft:recipes/building_blocks/polished_blackstone_stairs" | "createdeco:recipes/building_blocks/short_umber_brick_wall" | "createdeco:recipes/decorations/industrial_iron_hull_from_stonecutting" | "createdeco:recipes/decorations/decal_up" | "create:recipes/misc/smelting/lead_ingot_compat_thermal" | "createdeco:recipes/building_blocks/short_pearl_brick_wall_from_tiled_pearl_bricks_stonecutting" | "create:recipes/building_blocks/cut_scoria_slab_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/polished_cut_crimsite_slab_recycling" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab" | "createdeco:recipes/building_blocks/dean_brick_slab_from_long_dean_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_wall_from_long_pearl_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_corner_dusk_bricks_stonecutting" | "expatternprovider:recipes/misc/assembler_matrix_speed" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_locometal_boiler" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_gray" | "createdeco:recipes/decorations/zinc_mesh_fence_from_stonecutting" | "minecraft:recipes/decorations/pink_candle" | "ae2:recipes/misc/network/cables/smart_gray" | "enderio:recipes/building_blocks/recolor_clear_glass_p_blue" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_long_scarlet_bricks_stonecutting" | "minecraft:recipes/building_blocks/deepslate_brick_stairs" | "create:recipes/building_blocks/small_dripstone_brick_stairs_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/light_blue_bed" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_locometal_smokebox" | "railways:recipes/misc/crafting/palettes/wrapping/white_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_iron_wrapped_locometal" | "ae2:recipes/misc/network/wireless_part" | "createdeco:recipes/building_blocks/mossy_scarlet_bricks_from_vine" | "createdeco:recipes/building_blocks/corner_verdant_brick_slab_from_verdant_brick_slab_stonecutting" | "minecraft:recipes/decorations/purple_stained_glass_pane" | "minecraft:recipes/building_blocks/brick_stairs_from_bricks_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_polished_blackstone_stonecutting" | "create:hand_crank_000" | "createdeco:recipes/building_blocks/corner_pearl_brick_stairs_from_tiled_pearl_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_brass_wrapped_locometal_boiler" | "ae2:recipes/misc/network/cables/covered_fluix_clean" | "minecraft:nether/charge_respawn_anchor" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_tiled_umber_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_pink" | "minecraft:recipes/building_blocks/bamboo_planks" | "createdeco:recipes/building_blocks/tiled_umber_brick_wall_from_umber_brick_wall_stonecutting" | "expatternprovider:recipes/misc/ebus_out" | "create:mechanical_mixer" | "create_connected:brass_gearbox" | "minecraft:recipes/decorations/crafting_table" | "create:recipes/misc/crafting/kinetics/portable_storage_interface" | "createdeco:recipes/building_blocks/long_red_brick_slab_from_short_red_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/cut_copper_stairs_from_copper_block_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_purple" | "minecraft:recipes/decorations/chest" | "minecraft:story/shiny_gear" | "createdeco:recipes/building_blocks/mossy_dusk_brick_slab" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_black" | "create:recipes/misc/blasting/ingot_tin_compat_ic2" | "minecraft:recipes/misc/stick" | "minecraft:recipes/redstone/crimson_pressure_plate" | "enderio:recipes/misc/extraction_speed_upgrade_3_upgrade" | "create:funnel" | "minecraft:recipes/redstone/polished_blackstone_button" | "enderio:recipes/building_blocks/recolor_clear_glass_da_blue" | "copycats:recipes/crafting/copycat_beam" | "tconstruct:recipes/misc/common/materials/queens_slime_ingot_from_nuggets" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_riveted_locometal" | "create:recipes/building_blocks/cut_andesite_slab" | "createdeco:recipes/decorations/cyan_placard" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_locometal_smokebox" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_paver_stairs" | "createdeco:recipes/building_blocks/corner_blue_brick_wall_from_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_iron_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/cracked_scarlet_brick_stairs_from_cracked_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_iron_wrapped_locometal" | "create:recipes/misc/crafting/kinetics/steam_engine" | "minecraft:recipes/building_blocks/pink_terracotta" | "minecraft:recipes/building_blocks/mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_wall_from_corner_umber_brick_wall_stonecutting" | "minecraft:adventure/summon_iron_golem" | "create:recipes/building_blocks/weathered_copper_shingle_stairs" | "tconstruct:recipes/decorations/common/copper_platform" | "create:recipes/building_blocks/cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "create:recipes/building_blocks/weathered_copper_shingle_slab" | "ae2:recipes/misc/network/parts/panels_monitor" | "ae2:recipes/misc/tools/fluix_upgrade_smithing_template" | "createdeco:recipes/building_blocks/blue_brick_wall_from_tiled_blue_brick_wall_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingle_slab_from_honeycomb" | "create:recipes/building_blocks/cut_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "createdeco:recipes/building_blocks/corner_scarlet_brick_stairs_from_tiled_scarlet_brick_stairs_stonecutting" | "minecraft:recipes/redstone/lectern" | "enderio:recipes/building_blocks/recolor_clear_glass_white" | "enderio:recipes/building_blocks/recolor_clear_glass_d_light_gray" | "create:recipes/building_blocks/cut_crimsite_brick_slab_recycling" | "minecraft:recipes/building_blocks/stone_stairs_from_stone_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_brown" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_yellow" | "createdeco:recipes/building_blocks/corner_dusk_brick_slab_from_short_dusk_brick_slab_stonecutting" | "minecraft:recipes/misc/magenta_dye_from_purple_and_pink" | "minecraft:recipes/decorations/mossy_stone_brick_wall" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_long_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_red_brick_wall_from_corner_red_bricks_stonecutting" | "copycats:recipes/crafting/copycat_stairs_from_conversion" | "create:recipes/building_blocks/polished_cut_asurine_stairs_from_stone_types_asurine_stonecutting" | "expatternprovider:recipes/misc/tag_export_bus" | "createdeco:recipes/building_blocks/long_dusk_brick_wall_from_short_dusk_brick_wall_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_gray" | "create:recipes/building_blocks/horizontal_framed_glass_from_glass_colorless_stonecutting" | "minecraft:adventure/sleep_in_bed" | "enderio:recipes/misc/energetic_alloy_grinding_ball" | "minecraft:recipes/food/cooked_rabbit_from_campfire_cooking" | "create:recipes/building_blocks/cut_scorchia_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_brass_wrapped_locometal" | "minecraft:recipes/decorations/birch_sign" | "minecraft:recipes/transportation/cherry_boat" | "enderio:recipes/building_blocks/recolor_clear_glass_da_lime" | "create_connected:recipes/crafting/palettes/copycat_fence_compat" | "createdeco:recipes/decorations/red_shipping_container" | "storagedrawers:recipes/storagedrawers/dark_oak_drawers" | "copycats:recipes/crafting/copycat_step_from_conversion" | "enderio:recipes/building_blocks/recolor_clear_glass_p_white" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_brown" | "tconstruct:recipes/combat/tools/armor/travelers_boots" | "minecraft:recipes/tools/diamond_pickaxe" | "enderio:recipes/building_blocks/recolor_clear_glass_na_blue" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_short_pearl_bricks_stonecutting" | "minecraft:recipes/decorations/brown_glazed_terracotta" | "storagedrawers:recipes/storagedrawers/illumination_upgrade" | "createdeco:recipes/building_blocks/scarlet_bricks_from_tiled_scarlet_bricks_stonecutting" | "create:recipes/building_blocks/oxidized_copper_tile_slab_from_oxidized_copper_tiles_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_brick_wall_from_long_dean_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_d_green" | "create:recipes/building_blocks/crafting/kinetics/light_blue_seat" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_corner_verdant_bricks_stonecutting" | "minecraft:adventure/voluntary_exile" | "minecraft:recipes/decorations/granite_wall_from_granite_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_blackstone_stonecutting" | "createdeco:recipes/misc/industrial_iron_ingot" | "createdeco:recipes/building_blocks/blue_brick_slab_from_long_blue_brick_slab_stonecutting" | "create:recipes/building_blocks/polished_cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "storagedrawers:recipes/storagedrawers/remote_upgrade" | "create:recipes/misc/crafting/kinetics/gearbox" | "minecraft:recipes/building_blocks/cherry_planks" | "createdeco:recipes/building_blocks/corner_scarlet_bricks_from_short_scarlet_bricks_stonecutting" | "createdeco:recipes/decorations/brass_bars" | "create:recipes/building_blocks/polished_cut_scoria_slab" | "createdeco:recipes/decorations/iron_catwalk_from_stonecutting" | "create:recipes/misc/crafting/logistics/light_blue_table_cloth_clear" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs_from_corner_red_brick_stairs_stonecutting" | "create:recipes/building_blocks/polished_cut_tuff_stairs_from_stone_types_tuff_stonecutting" | "minecraft:recipes/combat/golden_chestplate" | "tconstruct:recipes/combat/gadgets/shuriken/flint_shuriken" | "createdeco:recipes/building_blocks/cracked_dean_brick_stairs" | "sophisticatedbackpacks:recipes/misc/feeding_upgrade" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_green" | "create:recipes/misc/crafting/logistics/brass_tunnel" | "expatternprovider:recipes/misc/threshold_level_emitter" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_tiled_scarlet_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/pink_brass_wrapped_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_light_blue" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_locometal_pillar" | "minecraft:recipes/misc/red_dye_from_poppy" | "createdeco:recipes/building_blocks/pearl_brick_wall_from_corner_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/clay" | "create:recipes/building_blocks/small_granite_brick_stairs" | "create:mechanical_crafter" | "create:recipes/building_blocks/crafting/logistics/yellow_postbox_from_other_postbox" | "tconstruct:recipes/redstone/smeltery/scorched/ingot_gauge" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_orange" | "ae2:recipes/misc/network/cells/fluid_storage_cell_1k_storage" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_short_umber_brick_stairs_stonecutting" | "create:recipes/misc/blasting/iron_ingot_from_crushed" | "create:recipes/building_blocks/small_dripstone_brick_slab" | "enderio:recipes/building_blocks/recolor_clear_glass_na_lime" | "createdeco:recipes/building_blocks/cracked_pearl_bricks_from_pearl_bricks_blasting" | "minecraft:recipes/transportation/mangrove_chest_boat" | "minecraft:recipes/decorations/gray_carpet" | "ae2:recipes/misc/tools/paintballs_red" | "minecraft:recipes/decorations/deepslate_tile_wall" | "minecraft:recipes/redstone/tripwire_hook" | "create:recipes/misc/crafting/kinetics/wooden_bracket" | "create:recipes/misc/crafting/kinetics/weighted_ejector" | "createdeco:recipes/building_blocks/mossy_blue_brick_stairs_from_mossy_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_brick_wall_from_tiled_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_short_verdant_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/andesite_window_pane" | "create:recipes/misc/smelting/zinc_ingot_from_raw_ore" | "minecraft:recipes/building_blocks/packed_mud" | "createdeco:recipes/decorations/decal_warning" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_verdant_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_na_magenta" | "createdeco:recipes/building_blocks/corner_verdant_brick_stairs_from_short_verdant_brick_stairs_stonecutting" | "minecraft:recipes/building_blocks/smooth_sandstone_slab" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_brown" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_long_verdant_bricks_stonecutting" | "ae2:recipes/misc/network/wireless_crafting_terminal" | "create:recipes/building_blocks/crafting/logistics/orange_postbox" | "minecraft:recipes/building_blocks/blue_terracotta" | "tconstruct:recipes/misc/common/materials/steel_nugget_from_ingot" | "createdeco:recipes/building_blocks/corner_dean_brick_slab_from_corner_dean_bricks_stonecutting" | "ae2:recipes/misc/network/cables/dense_smart_from_smart" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_verdant_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_flat_riveted_locometal" | "enderio:recipes/misc/stirling_generator" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_slashed_locometal" | "minecraft:recipes/building_blocks/cut_red_sandstone" | "railways:recipes/misc/crafting/palettes/wrapping/yellow_iron_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/battery_upgrade" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_short_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/mossy_verdant_bricks_from_vine" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_brass_wrapped_locometal_boiler" | "minecraft:recipes/decorations/purple_carpet" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_tiled_verdant_brick_stairs_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_slab" | "ae2:recipes/misc/tools/portable_fluid_cell_16k" | "create:recipes/building_blocks/polished_cut_granite_wall" | "enderio:recipes/misc/end_steel_grinding_ball" | "minecraft:recipes/misc/netherite_ingot" | "create:recipes/building_blocks/small_granite_brick_stairs_from_stone_types_granite_stonecutting" | "enderio:recipes/misc/pulsating_alloy_grinding_ball" | "railways:recipes/misc/stonecutting/palettes/cycling/black_locometal_pillar" | "tconstruct:recipes/misc/common/materials/steel_ingot_from_nuggets" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs" | "createdeco:recipes/misc/industrial_iron_nugget_from_industrial_iron_ingot" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_white" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_flat_riveted_locometal" | "create:recipes/building_blocks/cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/purple_iron_wrapped_locometal" | "ae2:recipes/misc/decorative/quartz_vibrant_glass" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_tiled_dusk_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/green_riveted_locometal" | "sophisticatedbackpacks:recipes/misc/advanced_deposit_upgrade" | "createdeco:recipes/decorations/yellow_placard_from_dyeing" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_umber_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/large_water_wheel" | "enderio:recipes/building_blocks/ender_fluid_conduit_upgrade" | "minecraft:adventure/trade_at_world_height" | "createdeco:recipes/building_blocks/pearl_bricks_from_corner_pearl_bricks_stonecutting" | "createdeco:recipes/decorations/gray_shipping_container" | "tconstruct:recipes/misc/common/materials/pig_iron_ingot_from_block" | "railways:recipes/misc/stonecutting/palettes/cycling/flat_riveted_locometal" | "storagedrawers:recipes/storagedrawers/cherry_drawers" | "minecraft:recipes/decorations/light_blue_stained_glass_pane_from_glass_pane" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_tiled_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/acacia_stairs" | "createdeco:recipes/building_blocks/short_red_brick_slab_from_short_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_red_brick_wall" | "create:recipes/building_blocks/small_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_short_verdant_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_flat_slashed_locometal" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_waxed_exposed_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_iron_wrapped_locometal" | "create:recipes/building_blocks/small_veridium_brick_stairs" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_tiled_blue_bricks_stonecutting" | "enderio:recipes/building_blocks/dark_steel_door" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_short_pearl_brick_slab_stonecutting" | "create:recipes/misc/crafting/materials/andesite_alloy" | "createdeco:recipes/building_blocks/tiled_scarlet_bricks_from_long_scarlet_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_red" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_dean_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/tiled_red_brick_wall" | "minecraft:recipes/decorations/candle" | "createdeco:recipes/building_blocks/corner_pearl_brick_stairs_from_tiled_pearl_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_brass_wrapped_locometal_boiler" | "enderio:recipes/building_blocks/recolor_fused_quartz_magenta" | "createdeco:recipes/decorations/andesite_mesh_fence_from_stonecutting" | "minecraft:recipes/misc/bone_meal_from_bone_block" | "create:recipes/building_blocks/cut_tuff_stairs_from_stone_types_tuff_stonecutting" | "storagedrawers:recipes/storagedrawers/personal_key_cofh" | "minecraft:nether/create_full_beacon" | "ae2:recipes/misc/tools/paintballs_lumen_gray" | "create:recipes/building_blocks/small_calcite_brick_stairs_from_stone_types_calcite_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/iron_wrapped_locometal" | "tconstruct:recipes/redstone/smeltery/seared/ingot_tank" | "createdeco:recipes/decorations/industrial_iron_support_wedge_from_stonecutting" | "createdeco:recipes/building_blocks/corner_blue_brick_wall" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_black" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_wall_from_verdant_bricks_stonecutting" | "create:recipes/misc/crafting/logistics/brass_funnel" | "minecraft:recipes/building_blocks/birch_slab" | "minecraft:recipes/misc/raw_gold" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_flat_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_locometal_pillar" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_pink" | "create:potato_cannon_collide" | "minecraft:recipes/decorations/oak_hanging_sign" | "minecraft:recipes/building_blocks/dye_lime_carpet" | "create:recipes/building_blocks/small_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_cyan" | "enderio:recipes/misc/energetic_alloy_nugget" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs" | "enderio:recipes/misc/pulsating_alloy_block" | "enderio:recipes/building_blocks/recolor_clear_glass_np_cyan" | "tconstruct:recipes/tools/tools/building/ender_staff" | "minecraft:recipes/misc/leather_horse_armor" | "createdeco:recipes/decorations/locked_zinc_door" | "tconstruct:recipes/redstone/smeltery/scorched/fuel_gauge" | "minecraft:recipes/building_blocks/cut_sandstone_slab_from_cut_sandstone_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_cyan" | "minecraft:recipes/transportation/oak_chest_boat" | "createdeco:recipes/decorations/decal_electrical" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_flat_slashed_locometal" | "createdeco:recipes/building_blocks/dean_brick_wall" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_short_dusk_bricks_stonecutting" | "minecraft:recipes/misc/copper_ingot_from_waxed_copper_block" | "createdeco:recipes/decorations/gray_placard_from_dyeing" | "createdeco:recipes/building_blocks/tiled_umber_bricks_from_long_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_tiled_pearl_bricks_stonecutting" | "create:recipes/misc/crafting/appliances/copper_diving_helmet" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_locometal_smokebox" | "minecraft:recipes/misc/tide_armor_trim_smithing_template" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_short_dean_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_cyan" | "ae2:recipes/misc/network/parts/quartz_fiber_part" | "minecraft:recipes/tools/diamond_hoe" | "create:recipes/building_blocks/crafting/logistics/cyan_table_cloth" | "minecraft:recipes/building_blocks/dark_oak_stairs" | "createdeco:recipes/building_blocks/short_dusk_brick_slab" | "create_connected:recipes/crafting/kinetics/overstress_clutch" | "createdeco:recipes/building_blocks/long_pearl_brick_wall_from_pearl_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_locometal_pillar" | "tconstruct:recipes/misc/common/materials/slimesteel_ingot_from_block" | "minecraft:recipes/building_blocks/granite_slab" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_from_honeycomb" | "enderio:recipes/building_blocks/recolor_clear_glass_d_pink" | "minecraft:nether/uneasy_alliance" | "enderio:recipes/building_blocks/recolor_clear_glass_e_white" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_brown" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_polished_blackstone_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_red_brick_stairs_from_corner_red_bricks_stonecutting" | "minecraft:recipes/redstone/redstone_from_blasting_redstone_ore" | "create:recipes/building_blocks/cut_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_light_gray" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_iron_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/wrapping/brown_brass_wrapped_locometal" | "create:recipes/misc/blasting/ingot_tin_compat_mekanism" | "createdeco:recipes/building_blocks/corner_red_brick_slab_from_bricks_stonecutting" | "create:recipes/building_blocks/cut_granite_from_stone_types_granite_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_bricks_from_umber_bricks_stonecutting" | "railways:recipes/transportation/benchcart" | "create:recipes/building_blocks/industrial_iron_window" | "tconstruct:recipes/misc/common/slime/ichor/crystal_growing" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_cyan" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_iron_wrapped_locometal_boiler" | "create_connected:recipes/crafting/kinetics/redstone_link_from_conversion" | "ae2:recipes/misc/decorative/chiseled_quartz_block" | "storagedrawers:recipes/storagedrawers/bamboo_drawers" | "createdeco:recipes/decorations/industrial_iron_catwalk_from_stonecutting" | "create:recipes/misc/crafting/kinetics/mechanical_plough" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_cyan" | "create:recipes/misc/smelting/tin_ingot_compat_thermal" | "tconstruct:recipes/decorations/common/glass/red_clear_stained_glass_pane" | "createdeco:recipes/building_blocks/long_verdant_brick_wall_from_corner_verdant_brick_wall_stonecutting" | "create:recipes/building_blocks/cut_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "create:recipes/misc/crafting/kinetics/belt_connector" | "minecraft:recipes/building_blocks/mossy_cobblestone_slab" | "enderio:recipes/building_blocks/recolor_clear_glass_green" | "createdeco:recipes/decorations/industrial_iron_bars" | "create:recipes/building_blocks/cut_asurine_slab" | "createdeco:recipes/building_blocks/short_pearl_brick_wall_from_pearl_brick_wall_stonecutting" | "createdeco:recipes/decorations/zinc_hull" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_stone_stairs_stonecutter" | "minecraft:recipes/building_blocks/polished_andesite_stairs_from_polished_andesite_stonecutting" | "tconstruct:recipes/decorations/common/iron_platform" | "storagedrawers:recipes/storagedrawers/acacia_trim" | "createdeco:recipes/building_blocks/long_blue_brick_wall" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_red" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_iron_wrapped_locometal_boiler" | "tconstruct:recipes/misc/common/slime/earth/crystal_smelting" | "createdeco:recipes/building_blocks/blue_brick_wall_from_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_tiled_pearl_bricks_stonecutting" | "minecraft:recipes/decorations/bamboo_fence" | "expatternprovider:recipes/misc/assembler_matrix_wall" | "createdeco:recipes/building_blocks/corner_pearl_brick_wall_from_tiled_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_wall_from_short_umber_brick_wall_stonecutting" | "create:recipes/misc/crafting/logistics/content_observer" | "createdeco:recipes/building_blocks/tiled_verdant_brick_wall_from_corner_verdant_bricks_stonecutting" | "minecraft:recipes/building_blocks/polished_granite_slab" | "create:recipes/building_blocks/crafting/logistics/red_table_cloth" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_flat_riveted_locometal" | "enderio:recipes/building_blocks/collision_token_clear_glass_da" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_red" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_locometal_smokebox" | "minecraft:recipes/decorations/gray_candle" | "ae2:recipes/misc/network/blocks/quantum_ring" | "minecraft:recipes/building_blocks/mossy_cobblestone_from_vine" | "enderio:recipes/building_blocks/collision_token_clear_glass_dp" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_brown" | "tconstruct:recipes/decorations/tables/scorched_anvil" | "ae2:recipes/misc/network/cables/dense_smart_brown" | "enderio:recipes/building_blocks/collision_token_clear_glass_dm" | "enderio:recipes/building_blocks/recolor_clear_glass_em_cyan" | "tconstruct:recipes/redstone/smeltery/scorched/fluid_cannon" | "createdeco:recipes/building_blocks/corner_pearl_brick_wall_from_corner_pearl_bricks_stonecutting" | "enderio:recipes/building_blocks/collision_token_clear_glass_ea" | "minecraft:recipes/decorations/cyan_bed" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_corner_blue_brick_slab_stonecutting" | "create:recipes/building_blocks/polished_cut_dripstone_wall" | "minecraft:recipes/building_blocks/jungle_stairs" | "enderio:recipes/building_blocks/collision_token_clear_glass_ep" | "enderio:recipes/building_blocks/collision_token_clear_glass_em" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_white" | "createdeco:recipes/building_blocks/tiled_dean_bricks_from_dean_bricks_stonecutting" | "minecraft:recipes/food/pumpkin_pie" | "minecraft:recipes/misc/host_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/cut_calcite_stairs" | "createdeco:recipes/building_blocks/blue_brick_slab_from_corner_blue_brick_slab_stonecutting" | "minecraft:husbandry/breed_an_animal" | "create:recipes/building_blocks/polished_cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/combat/netherite_helmet_smithing" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_tiled_dusk_bricks_stonecutting" | "minecraft:husbandry/complete_catalogue" | "createdeco:recipes/building_blocks/long_blue_brick_wall_from_tiled_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_long_dusk_bricks_stonecutting" | "minecraft:recipes/building_blocks/stripped_spruce_wood" | "create:recipes/building_blocks/small_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_wall_from_corner_scarlet_bricks_stonecutting" | "minecraft:recipes/decorations/brown_stained_glass_pane" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_cyan" | "tconstruct:recipes/decorations/common/glass/orange_clear_stained_glass_pane_from_panes" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_tiled_verdant_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/black_flat_riveted_locometal" | "create:recipes/building_blocks/deepslate_pillar_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_honeycomb" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_purple" | "tconstruct:recipes/redstone/world/wood/bloodshroom/fence_gate" | "ae2:recipes/misc/network/cables/smart_fluix" | "createdeco:recipes/building_blocks/dean_brick_wall_from_short_dean_brick_wall_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_cyan" | "create:recipes/misc/crafting/logistics/display_link" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_iron_wrapped_locometal_boiler" | "createdeco:recipes/decorations/gray_placard" | "minecraft:recipes/building_blocks/stripped_cherry_wood" | "minecraft:recipes/misc/light_blue_dye_from_blue_orchid" | "createdeco:recipes/building_blocks/long_pearl_bricks_from_short_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/red_nether_brick_slab_from_red_nether_bricks_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_pink" | "minecraft:recipes/building_blocks/lime_concrete_powder" | "createdeco:recipes/building_blocks/corner_dusk_brick_wall_from_tiled_dusk_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/corner_scarlet_brick_wall" | "create:recipes/building_blocks/crimson_window" | "create:recipes/building_blocks/cut_granite_brick_stairs_from_stone_types_granite_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_long_pearl_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_purple" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_locometal_smokebox" | "minecraft:recipes/building_blocks/dark_prismarine_stairs_from_dark_prismarine_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_magenta" | "create:train_portal" | "minecraft:recipes/redstone/spruce_button" | "sophisticatedbackpacks:recipes/misc/xp_pump_upgrade" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_paver_smelting" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_light_blue" | "createdeco:recipes/building_blocks/corner_verdant_brick_slab_from_corner_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_short_umber_brick_stairs_stonecutting" | "minecraft:recipes/misc/flower_banner_pattern" | "storagedrawers:recipes/storagedrawers/priority_key" | "ae2:recipes/misc/smelting/smooth_sky_stone_block" | "ae2:recipes/misc/tools/paintballs_lime" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_brown" | "tconstruct:recipes/misc/tables/book_substitute" | "createdeco:recipes/building_blocks/dean_brick_slab_from_tiled_dean_bricks_stonecutting" | "minecraft:recipes/redstone/dark_oak_door" | "createdeco:recipes/decorations/decal_down" | "enderio:recipes/misc/soularium_nugget" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_pink" | "createdeco:recipes/building_blocks/long_scarlet_brick_wall_from_corner_scarlet_bricks_stonecutting" | "createdeco:recipes/decorations/red_copper_lamp" | "minecraft:recipes/misc/coal_from_smelting_deepslate_coal_ore" | "create:brass" | "minecraft:recipes/redstone/hopper" | "create:recipes/misc/crafting/kinetics/mechanical_harvester" | "create:recipes/building_blocks/polished_cut_veridium_stairs_from_stone_types_veridium_stonecutting" | "createdeco:recipes/decorations/copper_bars_overlay" | "enderio:recipes/building_blocks/recolor_clear_glass_em_gray" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_copper_wrapped_locometal" | "minecraft:recipes/redstone/calibrated_sculk_sensor" | "createdeco:recipes/building_blocks/corner_verdant_brick_slab_from_long_verdant_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_corner_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_tiled_verdant_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/blue_brick_slab_from_short_blue_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_from_waxed_oxidized_copper_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/white_locometal_pillar" | "minecraft:recipes/misc/lime_dye" | "create:recipes/misc/crafting/materials/zinc_ingot_from_compacting" | "createdeco:recipes/building_blocks/cracked_red_brick_slab_from_cracked_red_bricks_stonecutting" | "create:recipes/building_blocks/small_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_black" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_scarlet_bricks_stonecutting" | "create:recipes/misc/crafting/palettes/scorchia" | "minecraft:recipes/misc/shaper_armor_trim_smithing_template" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_flat_riveted_locometal" | "create:recipes/misc/smoking/bread" | "createdeco:recipes/building_blocks/umber_brick_slab_from_long_umber_bricks_stonecutting" | "minecraft:recipes/building_blocks/tinted_glass" | "minecraft:recipes/building_blocks/dye_blue_wool" | "sophisticatedbackpacks:recipes/misc/smelting_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_brass_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/corner_verdant_brick_stairs_from_verdant_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_scoria_stairs" | "minecraft:recipes/redstone/comparator" | "minecraft:recipes/redstone/mangrove_pressure_plate" | "createdeco:recipes/building_blocks/cracked_umber_brick_stairs" | "create:recipes/building_blocks/polished_cut_granite_from_stone_types_granite_stonecutting" | "create:recipes/building_blocks/small_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "tconstruct:recipes/building_blocks/common/glass/green_clear_stained_glass" | "create:recipes/misc/crafting/appliances/tree_fertilizer" | "minecraft:recipes/building_blocks/red_stained_glass" | "minecraft:adventure/very_very_frightening" | "minecraft:story/lava_bucket" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_cyan" | "enderio:recipes/misc/dark_steel_ingot" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_plated_locometal" | "enderio:recipes/building_blocks/silent_polished_blackstone_pressure_plate" | "minecraft:recipes/building_blocks/quartz_stairs" | "create:recipes/misc/crafting/kinetics/secondary_linear_chassis_from_conversion" | "create:recipes/building_blocks/cut_crimsite_wall" | "ae2:recipes/misc/materials/carddistribution" | "minecraft:recipes/misc/copper_ingot_from_blasting_raw_copper" | "tconstruct:world/slime_collector" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_green" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_tiled_pearl_brick_slab_stonecutting" | "create:recipes/building_blocks/small_deepslate_brick_slab_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/layered_scoria_from_stone_types_scoria_stonecutting" | "minecraft:husbandry/ride_a_boat_with_a_goat" | "createdeco:recipes/decorations/brown_placard_from_dyeing" | "ae2:recipes/misc/decorative/cut_quartz_block_from_stonecutting" | "railways:recipes/misc/crafting/smokestack_coalburner" | "create:recipes/misc/crafting/kinetics/speedometer_from_conversion" | "createdeco:recipes/building_blocks/corner_verdant_brick_stairs_from_long_verdant_brick_stairs_stonecutting" | "minecraft:recipes/building_blocks/polished_deepslate_from_cobbled_deepslate_stonecutting" | "createdeco:recipes/decorations/yellow_shipping_container_from_dyeing_vaults" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_slab" | "createdeco:recipes/decorations/brass_catwalk_railing_from_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_a_red" | "create:recipes/building_blocks/polished_cut_dripstone_slab_recycling" | "minecraft:recipes/decorations/pink_stained_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_locometal_pillar" | "minecraft:recipes/misc/emerald_from_blasting_emerald_ore" | "createdeco:recipes/building_blocks/corner_blue_brick_slab_from_short_blue_brick_slab_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_flat_slashed_locometal" | "createdeco:recipes/decorations/red_placard" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_tiled_dean_bricks_stonecutting" | "ae2:main/network3" | "create:recipes/building_blocks/cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "tconstruct:recipes/decorations/world/wood/greenheart/hanging_sign" | "ae2:main/network2" | "enderio:recipes/misc/pulsating_crystal" | "createdeco:recipes/building_blocks/cracked_dean_bricks_from_dean_bricks_blasting" | "create_connected:recipes/crafting/kinetics/large_crank_wheel" | "ae2:main/network1" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_corner_umber_brick_stairs_stonecutting" | "minecraft:recipes/food/cooked_porkchop" | "minecraft:recipes/building_blocks/oak_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_flat_slashed_locometal" | "minecraft:husbandry/tame_an_animal" | "ae2:recipes/misc/network/parts/monitors_storage" | "createdeco:recipes/building_blocks/corner_blue_bricks_from_tiled_blue_bricks_stonecutting" | "minecraft:recipes/decorations/cyan_glazed_terracotta" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_tiled_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/iron_window" | "minecraft:recipes/tools/brush" | "minecraft:recipes/decorations/cyan_candle" | "minecraft:recipes/building_blocks/diorite_stairs_from_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_locometal_pillar" | "createdeco:recipes/building_blocks/corner_dean_bricks_from_short_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_scarlet_brick_slab_from_short_scarlet_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_da_orange" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_light_blue" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_blue" | "createdeco:recipes/building_blocks/short_scarlet_brick_wall_from_short_scarlet_bricks_stonecutting" | "minecraft:recipes/building_blocks/stripped_acacia_wood" | "tconstruct:recipes/misc/common/materials/cinderslime_block_from_ingots" | "copycats:recipes/crafting/copycat_byte" | "create:recipes/misc/crafting/curiosities/minecart_coupling" | "createdeco:recipes/building_blocks/long_blue_brick_wall_from_short_blue_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/tiled_verdant_brick_wall_from_short_verdant_brick_wall_stonecutting" | "minecraft:recipes/decorations/light_gray_bed" | "create:recipes/building_blocks/acacia_window_pane" | "minecraft:recipes/building_blocks/blackstone_stairs" | "createdeco:recipes/building_blocks/short_red_brick_slab_from_long_red_brick_slab_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_slashed_locometal" | "create:windmill_maxed" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_orange" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_short_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_wall_from_long_dusk_brick_wall_stonecutting" | "create:recipes/misc/crafting/kinetics/deployer" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_pearl_bricks_stonecutting" | "tconstruct:recipes/decorations/smeltery/scorched/table" | "create:recipes/building_blocks/polished_cut_tuff_wall_from_stone_types_tuff_stonecutting" | "createdeco:recipes/decorations/white_shipping_container" | "create:recipes/building_blocks/cut_limestone_wall_from_stone_types_limestone_stonecutting" | "createdeco:recipes/building_blocks/short_red_brick_wall_from_long_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs" | "minecraft:recipes/decorations/cyan_banner" | "expatternprovider:recipes/misc/assembler_matrix_glass" | "createdeco:recipes/decorations/decal_cross" | "createdeco:recipes/building_blocks/short_umber_bricks_from_tiled_umber_bricks_stonecutting" | "tconstruct:recipes/decorations/common/glass/brown_clear_stained_glass_pane_from_panes" | "enderio:recipes/building_blocks/recolor_clear_glass_p_yellow" | "minecraft:recipes/decorations/red_banner" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_iron_wrapped_locometal" | "create_connected:recipes/crafting/kinetics/clutch_from_conversion" | "minecraft:recipes/combat/iron_boots" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_orange" | "copycats:recipes/crafting/copycat_folding_door_from_conversion" | "minecraft:recipes/building_blocks/birch_planks" | "railways:recipes/misc/crafting/palettes/wrapping/copper_wrapped_locometal" | "createdeco:recipes/decorations/brass_mesh_fence" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_short_scarlet_bricks_stonecutting" | "copycats:recipes/crafting/copycat_wooden_button" | "create:recipes/building_blocks/acacia_window" | "create:recipes/misc/smelting/glass_from_tiled_glass" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_green" | "createdeco:recipes/building_blocks/corner_blue_brick_stairs_from_long_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/black_copper_wrapped_locometal" | "minecraft:recipes/decorations/magenta_glazed_terracotta" | "ae2:recipes/misc/tools/certus_quartz_spade" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_blue_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_gray" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_iron_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/polished_cut_deepslate_stairs" | "extra_gauges:recipes/redstone/display_link" | "minecraft:recipes/building_blocks/polished_granite_stairs_from_polished_granite_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_tiled_scarlet_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_purple" | "enderio:recipes/building_blocks/recolor_clear_glass_m_pink" | "ae2:recipes/misc/network/parts/energy_acceptor" | "enderio:recipes/misc/stone_gear" | "minecraft:recipes/building_blocks/mud_brick_stairs" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_verdant_brick_stairs_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_light_gray" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_magenta" | "minecraft:recipes/building_blocks/dye_light_gray_wool" | "ae2:recipes/misc/network/crafting/16k_cpu_crafting_storage" | "createdeco:recipes/building_blocks/corner_dusk_brick_slab_from_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_wall_from_tiled_dusk_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/mossy_dusk_bricks_from_moss_block" | "create:recipes/building_blocks/polished_cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "create:recipes/misc/crafting/logistics/brown_table_cloth_clear" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/light_gray_stained_glass" | "createdeco:recipes/building_blocks/corner_umber_brick_wall" | "railways:recipes/misc/crafting/palettes/wrapping/brown_iron_wrapped_locometal" | "tconstruct:recipes/decorations/gadgets/fancy_frame/clear" | "create:recipes/building_blocks/small_crimsite_brick_wall" | "minecraft:recipes/decorations/acacia_sign" | "ae2:recipes/misc/network/cables/covered_purple" | "ae2:recipes/misc/shaped/stairs/quartz_pillar" | "minecraft:recipes/building_blocks/brick_slab" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_cyan" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_white" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_brass_wrapped_locometal_boiler" | "enderio:recipes/misc/advanced_capacitor_bank_upgrade" | "ae2:recipes/misc/network/cells/spatial_storage_cell_2_cubed_storage" | "createdeco:recipes/building_blocks/mossy_pearl_brick_wall" | "minecraft:recipes/decorations/cherry_sign" | "createdeco:recipes/building_blocks/dean_bricks_from_long_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_verdant_brick_slab_from_verdant_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_lime" | "create:recipes/building_blocks/crafting/logistics/white_table_cloth_from_other_table_cloth" | "railways:recipes/misc/crafting/palettes/wrapping/white_iron_wrapped_locometal" | "tconstruct:recipes/redstone/smeltery/seared/chute_retextured" | "createdeco:recipes/decorations/lime_shipping_container" | "sophisticatedbackpacks:recipes/misc/stonecutter_upgrade" | "ae2:recipes/misc/tools/paintballs_brown" | "enderio:recipes/building_blocks/fluid_conduit" | "minecraft:recipes/misc/orange_dye_from_red_yellow" | "createdeco:recipes/building_blocks/scarlet_brick_stairs" | "railways:recipes/misc/crafting/track_switch_andesite" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_verdant_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_locometal_smokebox" | "enderio:recipes/redstone/resetting_lever_sixty_from_inv" | "minecraft:recipes/misc/gold_ingot_from_blasting_nether_gold_ore" | "create:fist_bump" | "minecraft:recipes/building_blocks/dye_orange_bed" | "minecraft:recipes/food/rabbit_stew_from_brown_mushroom" | "minecraft:recipes/building_blocks/magenta_concrete_powder" | "minecraft:recipes/decorations/green_bed" | "create:recipes/decorations/copper_table_cloth_from_ingots_copper_stonecutting" | "enderio:recipes/misc/conductive_alloy_block" | "createdeco:recipes/decorations/orange_shipping_container_from_dyeing_vaults" | "railways:recipes/misc/stonecutting/palettes/cycling/black_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_locometal_smokebox" | "minecraft:recipes/building_blocks/cut_sandstone_from_sandstone_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_light_gray" | "minecraft:recipes/decorations/campfire" | "railways:recipes/misc/stonecutting/palettes/cycling/red_locometal_smokebox" | "createdeco:recipes/building_blocks/short_verdant_brick_wall_from_tiled_verdant_brick_wall_stonecutting" | "minecraft:recipes/decorations/lime_stained_glass_pane" | "minecraft:recipes/misc/snout_armor_trim_smithing_template" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_cyan" | "minecraft:recipes/transportation/hopper_minecart" | "createdeco:recipes/building_blocks/short_pearl_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_plated_locometal" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_short_blue_bricks_stonecutting" | "createdeco:recipes/decorations/copper_support" | "createdeco:recipes/building_blocks/corner_dean_brick_stairs_from_short_dean_bricks_stonecutting" | "railways:recipes/combat/dying_existing_cap_light_blue" | "create:recipes/building_blocks/cut_ochrum_brick_wall" | "minecraft:recipes/building_blocks/terracotta" | "createdeco:recipes/building_blocks/long_verdant_brick_wall" | "storagedrawers:recipes/storagedrawers/warped_drawers" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_tiled_verdant_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_iron_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_locometal_smokebox" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_tiled_verdant_bricks_stonecutting" | "create:recipes/building_blocks/scoria_pillar_from_stone_types_scoria_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_slab_stonecutter" | "minecraft:recipes/redstone/jungle_trapdoor" | "createdeco:recipes/building_blocks/corner_pearl_brick_stairs_from_short_pearl_brick_stairs_stonecutting" | "create_connected:recipes/crafting/kinetics/vertical_parallel_gearbox_from_conversion" | "railways:recipes/misc/crafting/palettes/wrapping/black_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/chiseled_sandstone_from_sandstone_stonecutting" | "minecraft:recipes/building_blocks/polished_deepslate_slab_from_polished_deepslate_stonecutting" | "ae2wtlib:recipes/wireless_universal_terminal/upgrade_crafting" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_stonecutting" | "createdeco:recipes/decorations/brass_bars_overlay_from_stonecutting" | "create:recipes/building_blocks/crafting/logistics/pink_table_cloth_from_other_table_cloth" | "tconstruct:tools/one_shot" | "enderio:recipes/misc/soularium_ingot" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_copper_wrapped_locometal" | "tconstruct:smeltery/puny_smelting" | "createdeco:recipes/building_blocks/corner_pearl_bricks_from_short_pearl_bricks_stonecutting" | "tconstruct:recipes/decorations/world/wood/greenheart/sign" | "createdeco:recipes/building_blocks/corner_red_brick_wall_from_short_red_brick_wall_stonecutting" | "create:recipes/building_blocks/crafting/logistics/gray_postbox" | "minecraft:recipes/building_blocks/orange_terracotta" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_tiled_verdant_brick_slab_stonecutting" | "minecraft:recipes/misc/silence_armor_trim_smithing_template" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_tiled_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_red_brick_stairs_from_short_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_short_blue_bricks_stonecutting" | "minecraft:recipes/food/cooked_chicken_from_smoking" | "create:recipes/building_blocks/cut_deepslate_brick_slab_recycling" | "create:recipes/misc/crafting/kinetics/metal_girder" | "create:recipes/building_blocks/cut_asurine_brick_stairs" | "create:recipes/building_blocks/cut_diorite_stairs" | "ae2:recipes/misc/network/cables/covered_yellow" | "tconstruct:recipes/misc/smeltery/copper_can" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_tiled_dean_bricks_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_paver_slab" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_blue_bricks_stonecutting" | "minecraft:recipes/redstone/cherry_pressure_plate" | "minecraft:recipes/redstone/warped_pressure_plate" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_tiled_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_tiled_pearl_bricks_stonecutting" | "enderio:recipes/misc/basic_fluid_filter" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/stairs" | "enderio:recipes/building_blocks/recolor_fused_quartz_cyan" | "createdeco:recipes/building_blocks/tiled_red_brick_slab_from_corner_red_bricks_stonecutting" | "minecraft:recipes/food/cooked_salmon_from_campfire_cooking" | "createdeco:recipes/building_blocks/long_red_brick_stairs_from_corner_red_brick_stairs_stonecutting" | "expatternprovider:recipes/misc/precise_storage_bus" | "create:recipes/building_blocks/cut_andesite_brick_wall" | "createdeco:recipes/building_blocks/corner_umber_brick_slab_from_corner_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_umber_brick_stairs_from_short_umber_brick_stairs_stonecutting" | "tconstruct:recipes/building_blocks/common/glass/magenta_clear_stained_glass" | "create:recipes/building_blocks/cut_veridium_stairs" | "createdeco:recipes/building_blocks/long_red_brick_slab_from_tiled_red_brick_slab_stonecutting" | "create:recipes/building_blocks/cut_crimsite_from_stone_types_crimsite_stonecutting" | "createdeco:recipes/building_blocks/tiled_pearl_brick_wall_from_long_pearl_bricks_stonecutting" | "enderio:recipes/misc/pulsating_photovoltaic_module" | "createdeco:recipes/building_blocks/mossy_umber_brick_wall" | "create:recipes/building_blocks/small_ochrum_brick_slab" | "minecraft:recipes/redstone/bamboo_pressure_plate" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_green" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/ward_armor_trim_smithing_template_smithing_trim" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_corner_blue_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_m_black" | "railways:recipes/misc/stonecutting/palettes/cycling/red_plated_locometal" | "createdeco:recipes/decorations/andesite_bars" | "ae2:recipes/misc/network/cells/item_cell_housing" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_white" | "createdeco:recipes/decorations/red_placard_from_dyeing" | "ae2:recipes/misc/network/cables/smart_pink" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_flat_slashed_locometal" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_tiled_dean_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_locometal_boiler" | "tconstruct:recipes/redstone/smeltery/scorched/chute_retextured" | "createdeco:recipes/decorations/copper_coin" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_tiled_scarlet_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/long_umber_bricks_from_short_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_locometal_boiler" | "minecraft:recipes/building_blocks/chiseled_nether_bricks_from_nether_bricks_stonecutting" | "ae2:recipes/misc/network/cables/smart_orange" | "sophisticatedbackpacks:recipes/misc/advanced_pump_upgrade" | "createdeco:recipes/building_blocks/corner_verdant_brick_slab_from_long_verdant_bricks_stonecutting" | "tconstruct:recipes/building_blocks/world/wood/greenheart/slab" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_gray" | "create:recipes/building_blocks/polished_cut_asurine_wall" | "copycats:recipes/crafting/copycat_shaft" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingles_from_honeycomb" | "create:recipes/building_blocks/framed_glass_from_glass_colorless_stonecutting" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_long_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/chiseled_stone_bricks_from_stone_bricks_stonecutting" | "createdeco:recipes/building_blocks/scarlet_brick_wall" | "createdeco:recipes/building_blocks/corner_dusk_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/tiled_verdant_brick_wall_from_short_verdant_bricks_stonecutting" | "minecraft:recipes/decorations/pink_bed" | "enderio:recipes/building_blocks/recolor_clear_glass_a_cyan" | "minecraft:recipes/misc/coal_from_blasting_deepslate_coal_ore" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_copper_wrapped_locometal_boiler" | "enderio:recipes/building_blocks/recolor_clear_glass_m_green" | "enderio:recipes/redstone/resetting_lever_sixty_from_prev" | "enderio:recipes/building_blocks/invert_clear_glass_m" | "ae2:recipes/misc/block_cutter/walls/cut_quartz_wall" | "enderio:recipes/building_blocks/invert_clear_glass_p" | "ae2:recipes/misc/network/cells/item_storage_cell_1k_storage" | "ae2:recipes/misc/network/cables/glass_yellow" | "createdeco:recipes/decorations/industrial_iron_catwalk_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_plated_locometal" | "createdeco:recipes/building_blocks/tiled_dusk_brick_wall_from_long_dusk_brick_wall_stonecutting" | "minecraft:recipes/decorations/jungle_sign" | "create:recipes/misc/crafting/appliances/book" | "ae2wtlib:recipes/wireless_pattern_access_terminal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/exposed_cut_copper_from_exposed_copper_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_brick_wall_from_short_dean_bricks_stonecutting" | "ae2:recipes/misc/decorative/chiseled_quartz_block_from_stonecutting" | "create_connected:recipes/crafting/kinetics/fluid_vessel_from_conversion" | "tconstruct:foundry/alloyer" | "createdeco:recipes/building_blocks/long_dusk_brick_wall_from_long_dusk_bricks_stonecutting" | "minecraft:husbandry/feed_snifflet" | "createdeco:recipes/building_blocks/mossy_pearl_brick_wall_from_mossy_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/sandstone_slab_from_sandstone_stonecutting" | "create:recipes/misc/crafting/kinetics/copper_valve_handle" | "enderio:recipes/building_blocks/invert_clear_glass_a" | "create:recipes/building_blocks/cut_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_white" | "createdeco:recipes/building_blocks/corner_blue_bricks_from_blue_bricks_stonecutting" | "ae2:recipes/misc/misc/deconstruction_chiseled_certus_quartz" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_light_blue" | "minecraft:recipes/misc/netherite_ingot_from_netherite_block" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_dusk_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/short_red_bricks_from_tiled_red_bricks_stonecutting" | "create:recipes/building_blocks/small_crimsite_brick_stairs" | "create:recipes/building_blocks/cut_dripstone_brick_slab_recycling" | "minecraft:end/enter_end_gateway" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_purple" | "minecraft:recipes/building_blocks/bamboo_slab" | "create:recipes/building_blocks/cut_scoria_slab_recycling" | "railways:recipes/misc/stonecutting/palettes/cycling/green_flat_riveted_locometal" | "copycats:recipes/crafting/copycat_pane" | "tconstruct:recipes/misc/common/materials/amethyst_bronze_ingot_from_block" | "createdeco:recipes/building_blocks/mossy_red_brick_stairs" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_white" | "create_connected:recipes/crafting/kinetics/fluid_vessel" | "create:recipes/misc/crafting/kinetics/vertical_gearbox_from_conversion" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_green" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_purple" | "createdeco:recipes/building_blocks/short_dusk_bricks_from_dusk_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_light_blue" | "copycats:recipes/crafting/copycat_layer_from_half_layers" | "create_connected:recipes/crafting/kinetics/kinetic_battery" | "expatternprovider:recipes/misc/epa_upgrade" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_fancy_bricks_crafting" | "ae2:recipes/misc/tools/paintballs_blue" | "minecraft:recipes/redstone/oak_door" | "minecraft:recipes/building_blocks/dye_yellow_carpet" | "createdeco:recipes/building_blocks/dusk_brick_wall_from_tiled_dusk_bricks_stonecutting" | "create:recipes/building_blocks/copycat_panel_from_ingots_zinc_stonecutting" | "minecraft:recipes/misc/iron_ingot_from_iron_block" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_tiled_scarlet_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/light_blue_copper_wrapped_locometal" | "create:recipes/building_blocks/horizontal_framed_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_flat_riveted_locometal" | "create:recipes/misc/smelting/zinc_ingot_from_crushed" | "minecraft:recipes/decorations/end_stone_brick_wall_from_end_stone_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_blackstone_stonecutting" | "sophisticatedbackpacks:recipes/misc/auto_blasting_upgrade" | "create:recipes/misc/crafting/kinetics/propeller" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_locometal_boiler" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tile_stairs_from_honeycomb" | "ae2:recipes/misc/shaped/walls/smooth_sky_stone_block" | "createdeco:recipes/decorations/decal_no_entry" | "createdeco:recipes/building_blocks/dean_brick_slab_from_short_dean_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_locometal_smokebox" | "tconstruct:recipes/misc/common/materials/steel_block_from_ingots" | "expatternprovider:recipes/misc/tape" | "enderio:recipes/building_blocks/recolor_clear_glass_p_light_blue" | "minecraft:recipes/decorations/light_gray_candle" | "createdeco:recipes/building_blocks/short_dean_bricks_from_long_dean_bricks_stonecutting" | "enderio:recipes/tools/dark_steel_sword" | "create:recipes/building_blocks/calcite_pillar_from_stone_types_calcite_stonecutting" | "minecraft:recipes/building_blocks/melon" | "createdeco:recipes/building_blocks/short_blue_brick_wall_from_corner_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_brass_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_copper_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/polished_andesite_slab" | "create:recipes/building_blocks/polished_cut_ochrum_slab_recycling" | "createdeco:recipes/building_blocks/corner_dusk_bricks_from_short_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_pearl_brick_wall_from_short_pearl_bricks_stonecutting" | "ae2:recipes/misc/block_cutter/slabs/smooth_quartz_slab" | "create:recipes/building_blocks/cut_veridium_brick_stairs" | "create:recipes/building_blocks/diorite_from_stone_types_diorite_stonecutting" | "minecraft:recipes/decorations/yellow_stained_glass_pane_from_glass_pane" | "createdeco:recipes/building_blocks/mossy_dean_bricks_from_moss_block" | "create:recipes/building_blocks/cut_diorite_brick_wall_from_stone_types_diorite_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_stairs" | "enderio:recipes/building_blocks/recolor_clear_glass_na_light_gray" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_gray" | "minecraft:recipes/combat/golden_sword" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_plated_locometal" | "minecraft:end/elytra" | "minecraft:recipes/decorations/mangrove_sign" | "createdeco:recipes/building_blocks/corner_blue_brick_slab_from_tiled_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_red_brick_wall_from_bricks_stonecutting" | "createdeco:recipes/decorations/blue_iron_lamp" | "minecraft:recipes/redstone/redstone_lamp" | "createdeco:recipes/decorations/industrial_iron_hull" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_slab_from_corner_umber_brick_slab_stonecutting" | "tconstruct:recipes/decorations/common/glass/black_clear_stained_glass_pane_from_panes" | "minecraft:recipes/redstone/dispenser" | "create:recipes/building_blocks/polished_cut_limestone_stairs" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_light_gray" | "create_connected:recipes/crafting/palettes/copycat_wall_compat" | "createdeco:recipes/decorations/purple_shipping_container_from_dyeing_vaults" | "create:recipes/misc/crafting/appliances/cardboard_leggings" | "create:recipes/building_blocks/polished_cut_andesite_from_stone_types_andesite_stonecutting" | "minecraft:recipes/building_blocks/purpur_pillar_from_purpur_block_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_purple" | "createdeco:recipes/building_blocks/long_dusk_bricks_from_tiled_dusk_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_ochrum_stairs" | "minecraft:recipes/building_blocks/cobblestone_slab" | "enderio:recipes/misc/vibrant_alloy_nugget" | "create:recipes/misc/crafting/kinetics/encased_chain_drive" | "create:recipes/misc/crafting/kinetics/mechanical_drill" | "enderio:recipes/food/enderios" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_flat_riveted_locometal" | "createdeco:recipes/building_blocks/corner_umber_bricks_from_tiled_umber_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_p_lime" | "createdeco:recipes/building_blocks/tiled_umber_bricks_from_short_umber_bricks_stonecutting" | "minecraft:recipes/building_blocks/magenta_terracotta" | "minecraft:recipes/misc/brick" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_locometal_boiler" | "ae2:recipes/misc/tools/portable_item_cell_256k" | "tconstruct:recipes/decorations/common/glass/lime_clear_stained_glass_pane" | "storagedrawers:recipes/storagedrawers/cherry_trim" | "ae2:recipes/misc/network/cables/covered_green" | "create:recipes/building_blocks/cut_crimsite_stairs" | "create:recipes/misc/crafting/logistics/lime_table_cloth_clear" | "tconstruct:recipes/decorations/common/glass/black_clear_stained_glass_pane" | "create:recipes/building_blocks/polished_cut_veridium_stairs" | "minecraft:recipes/building_blocks/gold_block" | "createdeco:recipes/building_blocks/long_pearl_bricks_from_corner_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_short_dusk_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs_from_exposed_cut_copper_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_bricks_from_short_dean_bricks_stonecutting" | "createdeco:recipes/decorations/copper_mesh_fence_from_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_slashed_locometal" | "createdeco:recipes/building_blocks/corner_dean_brick_wall" | "createdeco:recipes/building_blocks/long_red_brick_stairs_from_short_red_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_locometal_pillar" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab" | "minecraft:recipes/decorations/armor_stand" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_brass_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/umber_brick_wall_from_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_iron_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_short_pearl_bricks_stonecutting" | "minecraft:recipes/transportation/acacia_boat" | "minecraft:recipes/redstone/iron_trapdoor" | "createdeco:recipes/building_blocks/short_dusk_bricks_from_long_dusk_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_cyan" | "railways:recipes/misc/crafting/buffer" | "createdeco:recipes/decorations/andesite_trapdoor" | "ae2:recipes/misc/materials/formationcore" | "minecraft:recipes/building_blocks/end_stone_brick_stairs" | "minecraft:recipes/decorations/jungle_fence" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_red" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_verdant_bricks_stonecutting" | "minecraft:recipes/misc/tide_armor_trim_smithing_template_smithing_trim" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_locometal_boiler" | "createdeco:recipes/building_blocks/tiled_blue_bricks_from_corner_blue_bricks_stonecutting" | "minecraft:recipes/decorations/mud_brick_wall_from_mud_bricks_stonecutting" | "minecraft:recipes/building_blocks/chiseled_quartz_block_from_quartz_block_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_orange" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_long_verdant_bricks_stonecutting" | "create:recipes/building_blocks/bamboo_window_pane" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_locometal_pillar" | "tconstruct:recipes/decorations/common/glass/green_clear_stained_glass_pane" | "tconstruct:recipes/decorations/world/wood/enderbark/sign" | "copycats:recipes/crafting/copycat_folding_door" | "tconstruct:recipes/decorations/gadgets/frame/diamond" | "createdeco:recipes/building_blocks/umber_brick_wall_from_short_umber_bricks_stonecutting" | "ae2:recipes/misc/decorative/sky_stone_brick_from_stonecutting" | "minecraft:recipes/building_blocks/cyan_terracotta" | "ae2:recipes/misc/network/blocks/energy_energy_acceptor" | "createdeco:recipes/decorations/decal_left" | "ae2:recipes/misc/shaped/stairs/fluix_block" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_short_umber_bricks_stonecutting" | "ae2:recipes/misc/network/blocks/io_condenser" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_light_blue" | "minecraft:story/follow_ender_eye" | "minecraft:recipes/building_blocks/weathered_cut_copper_from_weathered_copper_stonecutting" | "tconstruct:recipes/tools/gadgets/throwball/efln_ball" | "enderio:recipes/building_blocks/recolor_clear_glass_cyan" | "createdeco:recipes/building_blocks/long_blue_brick_wall_from_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_brass_wrapped_locometal_boiler" | "create:recipes/misc/smelting/ingot_lead_compat_immersiveengineering" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_brown" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_pink" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_locometal_pillar" | "enderio:recipes/redstone/resetting_lever_ten_from_prev" | "createdeco:recipes/building_blocks/cracked_umber_brick_slab" | "enderio:recipes/building_blocks/recolor_clear_glass_light_blue" | "minecraft:recipes/misc/iron_ingot_from_blasting_raw_iron" | "createdeco:recipes/building_blocks/dusk_bricks_from_corner_dusk_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_da_black" | "create:recipes/misc/crafting/materials/brass_ingot_from_compacting" | "create:steam_engine" | "createdeco:recipes/decorations/industrial_iron_trapdoor" | "minecraft:recipes/misc/blue_dye_from_cornflower" | "minecraft:recipes/redstone/slime_block" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_orange" | "createdeco:recipes/building_blocks/short_verdant_brick_wall_from_long_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_dean_bricks_from_corner_dean_bricks_stonecutting" | "ae2:recipes/misc/block_cutter/stairs/sky_stone_stairs" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_red" | "createdeco:recipes/decorations/gold_coinstack" | "create:recipes/misc/crafting/logistics/repackager_from_conversion" | "ae2:recipes/misc/network/cables/glass_cyan" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_lime" | "minecraft:recipes/building_blocks/acacia_wood" | "minecraft:recipes/decorations/polished_blackstone_brick_wall" | "ae2:recipes/misc/shaped/walls/sky_stone_small_brick" | "storagedrawers:recipes/storagedrawers/framing_table" | "tconstruct:recipes/redstone/smeltery/seared/gauge" | "minecraft:recipes/combat/wooden_sword" | "minecraft:recipes/decorations/gray_banner" | "minecraft:recipes/building_blocks/oak_planks" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_light_gray" | "createdeco:recipes/building_blocks/corner_scarlet_brick_stairs_from_short_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_dusk_brick_stairs_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_purple" | "minecraft:recipes/building_blocks/dye_blue_bed" | "createdeco:recipes/building_blocks/pearl_brick_wall_from_corner_pearl_brick_wall_stonecutting" | "ae2:recipes/misc/network/parts/energy_level_emitter" | "createdeco:recipes/building_blocks/mossy_scarlet_brick_wall_from_mossy_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_slashed_locometal" | "createdeco:recipes/building_blocks/short_red_brick_wall_from_bricks_stonecutting" | "minecraft:recipes/building_blocks/black_concrete_powder" | "createdeco:recipes/building_blocks/cracked_scarlet_brick_slab_from_cracked_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_corner_scarlet_brick_stairs_stonecutting" | "createdeco:recipes/decorations/brass_bars_from_stonecutting" | "minecraft:recipes/building_blocks/mud_bricks" | "create:recipes/building_blocks/cut_granite_brick_wall" | "minecraft:recipes/food/cooked_porkchop_from_smoking" | "createdeco:recipes/decorations/light_gray_placard_from_dyeing" | "enderio:recipes/misc/end_steel_block" | "createdeco:recipes/building_blocks/cracked_dean_brick_slab" | "create:recipes/misc/crafting/kinetics/train_trapdoor" | "minecraft:recipes/building_blocks/chiseled_nether_bricks" | "create:recipes/building_blocks/crafting/logistics/red_postbox_from_other_postbox" | "create:recipes/building_blocks/crafting/logistics/gray_table_cloth_from_other_table_cloth" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_short_pearl_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_purple" | "createdeco:recipes/decorations/copper_coinstack" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_fancy_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_red_brick_stairs_from_bricks_stonecutting" | "create:millstone" | "createdeco:recipes/misc/industrial_iron_ingot_from_industrial_iron_block" | "tconstruct:recipes/misc/common/materials/cobalt_ingot_smelting" | "tconstruct:recipes/redstone/world/wood/skyroot/button" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_plated_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_blue" | "tconstruct:recipes/decorations/common/copper_platform_waxing_oxidized" | "create_factory_logistics:recipes/misc/jar_packager" | "minecraft:recipes/redstone/bamboo_button" | "create:recipes/misc/blasting/ingot_silver_compat_ic2" | "minecraft:recipes/decorations/light_gray_carpet" | "create:recipes/building_blocks/cut_diorite_slab_recycling" | "createdeco:recipes/building_blocks/tiled_umber_brick_wall_from_short_umber_brick_wall_stonecutting" | "minecraft:recipes/misc/rib_armor_trim_smithing_template" | "tconstruct:recipes/decorations/world/wood/enderbark/fence" | "createdeco:recipes/building_blocks/corner_dean_brick_stairs_from_short_dean_brick_stairs_stonecutting" | "minecraft:recipes/combat/leather_boots" | "expatternprovider:recipes/misc/pre_bus" | "minecraft:recipes/misc/red_dye_from_tulip" | "minecraft:husbandry/axolotl_in_a_bucket" | "minecraft:recipes/decorations/cobblestone_wall_from_cobblestone_stonecutting" | "createdeco:recipes/building_blocks/short_umber_brick_wall_from_long_umber_brick_wall_stonecutting" | "minecraft:recipes/decorations/grindstone" | "minecraft:recipes/building_blocks/diamond_block" | "enderio:recipes/misc/energetic_photovoltaic_module" | "enderio:recipes/building_blocks/recolor_clear_glass_da_green" | "create_connected:recipes/crafting/kinetics/brass_gearbox_from_conversion" | "minecraft:recipes/decorations/yellow_carpet" | "minecraft:recipes/building_blocks/stripped_oak_wood" | "create:recipes/building_blocks/cut_calcite_wall" | "createdeco:recipes/building_blocks/long_red_brick_stairs_from_short_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_verdant_brick_wall_from_corner_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_long_verdant_brick_stairs_stonecutting" | "minecraft:nether/ride_strider_in_overworld_lava" | "create:recipes/building_blocks/polished_cut_andesite_slab_recycling" | "enderio:recipes/misc/redstone_alloy_ingot" | "create:recipes/building_blocks/crafting/logistics/light_blue_postbox_from_other_postbox" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_slashed_locometal" | "create:recipes/building_blocks/cut_dripstone_brick_slab_from_stone_types_dripstone_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_d_gray" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_white" | "minecraft:recipes/decorations/blue_banner" | "createdeco:recipes/building_blocks/corner_umber_bricks_from_short_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_corner_scarlet_brick_slab_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_locometal_smokebox" | "enderio:recipes/misc/redstone_xor_filter" | "createdeco:recipes/decorations/yellow_placard" | "minecraft:recipes/building_blocks/dark_prismarine_slab_from_dark_prismarine_stonecutting" | "tconstruct:recipes/decorations/gadgets/frame/gold" | "minecraft:recipes/building_blocks/polished_andesite_stairs_from_andesite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_copper_wrapped_locometal" | "ae2:recipes/misc/network/cables/dense_smart_fluix" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_brass_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_iron_wrapped_locometal" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs" | "create:recipes/misc/crafting/kinetics/copper_valve_handle_from_others" | "minecraft:recipes/decorations/deepslate_brick_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/misc/lapis_lazuli_from_blasting_deepslate_lapis_ore" | "create:recipes/building_blocks/weathered_iron_block_from_ingots_iron_stonecutting" | "create:recipes/building_blocks/small_ochrum_brick_stairs" | "createdeco:recipes/building_blocks/short_scarlet_brick_wall_from_tiled_scarlet_brick_wall_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_gray" | "ae2:recipes/misc/tools/portable_item_cell_64k" | "minecraft:recipes/misc/firework_rocket_simple" | "minecraft:nether/summon_wither" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_corner_dean_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/corner_red_brick_stairs_from_long_red_brick_stairs_stonecutting" | "create:recipes/building_blocks/small_scoria_brick_slab_recycling" | "createdeco:recipes/building_blocks/long_umber_bricks_from_tiled_umber_bricks_stonecutting" | "create:recipes/building_blocks/cut_crimsite_brick_wall" | "create:recipes/misc/crafting/kinetics/nozzle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_riveted_locometal" | "create:recipes/building_blocks/polished_cut_ochrum_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_iron_wrapped_locometal_boiler" | "ae2:recipes/misc/network/cables/dense_smart_orange" | "minecraft:recipes/building_blocks/red_nether_brick_slab" | "minecraft:recipes/building_blocks/cobblestone_stairs" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_blue" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_riveted_locometal" | "enderio:recipes/misc/energetic_alloy_nugget_to_ingot" | "createdeco:recipes/decorations/andesite_hull" | "createdeco:recipes/building_blocks/tiled_red_brick_slab_from_short_red_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/green_slashed_locometal" | "create:burner" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_magenta" | "createdeco:recipes/decorations/brass_hull" | "minecraft:recipes/decorations/pink_banner" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_locometal_boiler" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_light_blue" | "minecraft:recipes/building_blocks/waxed_exposed_copper_from_honeycomb" | "create:frogport" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_long_verdant_bricks_stonecutting" | "ae2:recipes/misc/network/cables/covered_light_gray" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_tiled_dusk_bricks_stonecutting" | "ae2:recipes/misc/network/cables/smart_brown" | "create:recipes/building_blocks/cut_granite_wall" | "minecraft:recipes/building_blocks/prismarine_slab" | "minecraft:recipes/decorations/orange_carpet" | "enderio:recipes/building_blocks/recolor_clear_glass_p_brown" | "create:recipes/misc/crafting/kinetics/mechanical_piston" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_gray" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_plated_locometal" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_crafting" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_white" | "minecraft:recipes/decorations/warped_hanging_sign" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_lime" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_iron_wrapped_locometal_boiler" | "enderio:recipes/misc/entity_filter" | "create:shifting_gears" | "createdeco:recipes/building_blocks/short_scarlet_brick_wall" | "createdeco:recipes/building_blocks/tiled_dean_brick_wall_from_long_dean_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/long_blue_brick_wall_from_corner_blue_brick_wall_stonecutting" | "create:recipes/misc/crafting/kinetics/encased_fan" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_plated_locometal" | "ae2:recipes/misc/materials/cardredstone" | "railways:recipes/misc/crafting/conductor_whistle" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_stonecutting" | "ae2:recipes/misc/network/parts/toggle_bus" | "createdeco:recipes/building_blocks/cracked_pearl_brick_wall_from_cracked_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/blue_brick_slab_from_corner_blue_bricks_stonecutting" | "create:recipes/building_blocks/crafting/logistics/black_postbox_from_other_postbox" | "ae2:recipes/misc/shaped/stairs/sky_stone_brick" | "extra_gauges:recipes/redstone/logic_gauge" | "create:recipes/building_blocks/cut_diorite_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_iron_wrapped_locometal" | "createdeco:recipes/decorations/copper_sheet_metal" | "tconstruct:foundry/manyullyn_lanterns" | "createdeco:recipes/building_blocks/corner_blue_brick_stairs_from_short_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_short_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/dean_brick_stairs" | "minecraft:recipes/building_blocks/polished_granite_stairs_from_granite_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_lime" | "create:track_crafting_factory" | "create:recipes/building_blocks/horizontal_framed_glass_pane_from_glass_panes_colorless_stonecutting" | "create:recipes/misc/crafting/kinetics/framed_glass_door" | "create:recipes/building_blocks/polished_cut_dripstone_stairs" | "minecraft:recipes/building_blocks/cyan_concrete_powder" | "createdeco:recipes/building_blocks/blue_brick_wall_from_corner_blue_brick_wall_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_lime" | "ae2:recipes/misc/tools/misctools_entropy_manipulator" | "create:recipes/misc/crafting/materials/electron_tube" | "enderio:recipes/building_blocks/recolor_clear_glass_e_magenta" | "create:recipes/building_blocks/cut_tuff_brick_slab_recycling" | "tconstruct:recipes/misc/common/materials/slimesteel_block_from_ingots" | "createdeco:recipes/building_blocks/verdant_brick_slab" | "ae2:main/network_tool" | "create:recipes/building_blocks/polished_cut_dripstone_from_stone_types_dripstone_stonecutting" | "create:recipes/decorations/copper_bars_from_ingots_copper_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_plated_locometal" | "minecraft:recipes/misc/nether_brick" | "create:recipes/building_blocks/small_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "create:recipes/building_blocks/cut_scorchia_stairs" | "create:recipes/misc/crafting/appliances/cardboard_sword" | "railways:recipes/misc/crafting/handcar" | "createdeco:recipes/building_blocks/dean_brick_wall_from_corner_dean_bricks_stonecutting" | "enderio:recipes/redstone/resetting_lever_five_inv_from_base" | "enderio:recipes/building_blocks/recolor_clear_glass_d_yellow" | "create:recipes/misc/smelting/ingot_silver_compat_immersiveengineering" | "createdeco:recipes/building_blocks/short_red_bricks_from_corner_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_long_dusk_bricks_stonecutting" | "ae2:recipes/misc/shaped/slabs/cut_quartz_block" | "create:recipes/building_blocks/jungle_window" | "createdeco:recipes/decorations/copper_catwalk_stairs" | "railways:recipes/combat/dying_existing_cap_pink" | "railways:recipes/misc/stonecutting/palettes/cycling/green_flat_slashed_locometal" | "minecraft:recipes/building_blocks/polished_deepslate_stairs" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_slashed_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_d_red" | "minecraft:recipes/decorations/shulker_box" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_pink" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_blue" | "createdeco:recipes/decorations/andesite_support" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_locometal_boiler" | "create:recipes/building_blocks/crafting/logistics/lime_postbox" | "enderio:recipes/building_blocks/recolor_clear_glass_np_purple" | "minecraft:recipes/misc/raiser_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/layered_andesite_from_stone_types_andesite_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_stairs" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_locometal_smokebox" | "ae2:recipes/misc/network/cables/covered_white" | "createdeco:recipes/building_blocks/corner_dean_brick_wall_from_short_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_orange" | "createdeco:recipes/building_blocks/mossy_dean_bricks_from_vine" | "copycats:recipes/crafting/copycat_sliding_door" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_purple" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_light_blue" | "tconstruct:recipes/decorations/common/glass/light_gray_clear_stained_glass_pane_from_panes" | "minecraft:recipes/transportation/powered_rail" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_blue" | "create:recipes/building_blocks/crafting/logistics/purple_table_cloth" | "createdeco:recipes/building_blocks/short_blue_bricks_from_tiled_blue_bricks_stonecutting" | "tconstruct:recipes/decorations/common/glass/red_clear_stained_glass_pane_from_panes" | "minecraft:recipes/misc/iron_ingot_from_nuggets" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_long_verdant_brick_stairs_stonecutting" | "tconstruct:smeltery/tool_forge" | "enderio:recipes/building_blocks/recolor_clear_glass_np_gray" | "minecraft:recipes/transportation/jungle_boat" | "createdeco:recipes/building_blocks/corner_pearl_brick_stairs_from_short_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dusk_brick_wall_from_long_dusk_brick_wall_stonecutting" | "createdeco:recipes/decorations/locked_andesite_door" | "ae2:recipes/misc/network/cables/dense_smart_gray" | "tconstruct:recipes/food/gadgets/cake/ichor" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab_from_cut_red_sandstone_stonecutting" | "minecraft:story/enter_the_end" | "enderio:recipes/misc/redstone_or_filter" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_iron_wrapped_locometal" | "tconstruct:recipes/building_blocks/world/wood/greenheart/stripped_log_to_wood" | "minecraft:recipes/building_blocks/stone_stairs" | "create:recipes/misc/smelting/iron_ingot_from_crushed" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_slashed_locometal" | "minecraft:recipes/building_blocks/purpur_slab_from_purpur_block_stonecutting" | "minecraft:recipes/transportation/rail" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_deepslate_bricks_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_stone_slab_stonecutter" | "extra_gauges:recipes/redstone/integer_selector" | "storagedrawers:recipes/storagedrawers/gold_storage_upgrade" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_gray" | "createdeco:recipes/decorations/copper_catwalk_railing_forge" | "create:recipes/misc/blasting/ingot_aluminium_compat_ic2" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_flat_riveted_locometal" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_honeycomb" | "minecraft:recipes/redstone/lever" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_purple" | "create:recipes/decorations/andesite_scaffolding_from_andesite_alloy_stonecutting" | "minecraft:nether/obtain_crying_obsidian" | "createdeco:recipes/building_blocks/corner_dusk_brick_stairs_from_tiled_dusk_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_short_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_dusk_brick_slab_from_tiled_dusk_brick_slab_stonecutting" | "tconstruct:recipes/tools/gadgets/throwball/glow_ball" | "railways:recipes/misc/crafting/palettes/wrapping/light_blue_brass_wrapped_locometal" | "create:recipes/building_blocks/polished_cut_limestone_wall_from_stone_types_limestone_stonecutting" | "minecraft:recipes/misc/pink_dye_from_pink_petals" | "chiselsandbits:chiselsandbits/collect_bits" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_flat_slashed_locometal" | "minecraft:husbandry/froglights" | "create:recipes/building_blocks/small_scorchia_bricks_from_stone_types_scorchia_stonecutting" | "createdeco:recipes/building_blocks/corner_verdant_brick_slab" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_brown" | "enderio:recipes/redstone/resetting_lever_sixty" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_locometal_pillar" | "create:recipes/building_blocks/cut_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_wall_from_tiled_umber_bricks_stonecutting" | "sophisticatedbackpacks:recipes/misc/smoking_upgrade" | "minecraft:recipes/building_blocks/smooth_red_sandstone_stairs_from_smooth_red_sandstone_stonecutting" | "create:recipes/building_blocks/cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_riveted_locometal" | "createdeco:recipes/building_blocks/verdant_bricks_from_long_verdant_bricks_stonecutting" | "sophisticatedbackpacks:recipes/misc/advanced_void_upgrade" | "railways:recipes/misc/crafting/portable_fuel_interface" | "minecraft:recipes/building_blocks/lime_terracotta" | "create:recipes/building_blocks/small_tuff_brick_stairs_from_stone_types_tuff_stonecutting" | "createdeco:recipes/decorations/decal_right" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_wall_stonecutter" | "minecraft:recipes/building_blocks/light_gray_terracotta" | "create:ejector_maxed" | "createdeco:recipes/building_blocks/tiled_scarlet_bricks_from_short_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_scarlet_brick_slab_stonecutting" | "create:recipes/building_blocks/crafting/logistics/red_table_cloth_from_other_table_cloth" | "create:recipes/building_blocks/cut_limestone_bricks_from_stone_types_limestone_stonecutting" | "create:recipes/misc/crafting/materials/brass_ingot_from_decompacting" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_long_dean_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/speedometer" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_light_gray" | "enderio:recipes/misc/conduit_binder_from_smelting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_waxed_weathered_cut_copper_stonecutting" | "tconstruct:recipes/redstone/world/wood/greenheart/button" | "minecraft:recipes/building_blocks/end_stone_brick_stairs_from_end_stone_brick_stonecutting" | "ae2:main/charger" | "createdeco:recipes/building_blocks/pearl_bricks_from_tiled_pearl_bricks_stonecutting" | "create:recipes/building_blocks/cut_veridium_bricks_from_stone_types_veridium_stonecutting" | "minecraft:recipes/building_blocks/pink_concrete_powder" | "minecraft:recipes/building_blocks/sandstone_slab" | "createdeco:recipes/building_blocks/cracked_dean_brick_stairs_from_cracked_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/blue_brick_wall_from_short_blue_brick_wall_stonecutting" | "ae2:recipes/misc/network/cables/glass_green" | "createdeco:recipes/building_blocks/short_red_brick_wall_from_short_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/cracked_red_brick_slab" | "minecraft:story/obtain_armor" | "enderio:recipes/misc/copper_alloy_ingot" | "create:recipes/building_blocks/polished_cut_andesite_stairs" | "enderio:recipes/misc/vibrant_capacitor_bank" | "create:diving_suit" | "createdeco:recipes/building_blocks/tiled_umber_brick_wall_from_long_umber_brick_wall_stonecutting" | "minecraft:recipes/decorations/gray_stained_glass_pane" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_tiled_scarlet_bricks_stonecutting" | "tconstruct:recipes/redstone/world/wood/skyroot/pressure_plate" | "create:recipes/building_blocks/small_diorite_bricks_from_stone_types_diorite_stonecutting" | "minecraft:recipes/food/dried_kelp_from_smelting" | "createdeco:recipes/building_blocks/short_umber_brick_wall_from_long_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_brass_wrapped_locometal_boiler" | "tconstruct:recipes/decorations/tables/tinkers_anvil" | "create:recipes/building_blocks/layered_diorite_from_stone_types_diorite_stonecutting" | "tconstruct:world/piggybackpack" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_black" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_short_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_verdant_bricks_stonecutting" | "createdeco:recipes/decorations/copper_bars_from_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_plated_locometal" | "enderio:recipes/building_blocks/silent_light_weighted_pressure_plate" | "tconstruct:recipes/redstone/smeltery/seared/ingot_gauge" | "create:recipes/building_blocks/polished_cut_deepslate_slab" | "minecraft:recipes/decorations/orange_candle" | "create:recipes/building_blocks/asurine_pillar_from_stone_types_asurine_stonecutting" | "createdeco:recipes/building_blocks/corner_umber_brick_wall_from_tiled_umber_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_orange" | "create:encased_fan" | "create:recipes/building_blocks/cut_diorite_wall_from_stone_types_diorite_stonecutting" | "ae2:recipes/misc/shaped/slabs/chiseled_quartz_block" | "minecraft:recipes/building_blocks/waxed_weathered_copper_from_honeycomb" | "minecraft:recipes/misc/iron_nugget_from_smelting" | "createdeco:recipes/building_blocks/short_dusk_brick_wall_from_corner_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_wall_from_short_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_plated_locometal" | "create:recipes/misc/crafting/kinetics/cuckoo_clock" | "createdeco:recipes/building_blocks/long_red_brick_wall_from_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_brown" | "minecraft:recipes/misc/copper_ingot_from_smelting_copper_ore" | "ae2:recipes/misc/block_cutter/stairs/quartz_brick_stairs" | "minecraft:recipes/food/baked_potato_from_campfire_cooking" | "create:recipes/building_blocks/cut_deepslate_stairs" | "createdeco:recipes/building_blocks/short_red_brick_wall_from_tiled_red_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/blue_brick_slab_from_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_red_brick_wall_from_long_red_bricks_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/blue_seat_from_other_seat" | "copycats:recipes/crafting/copycat_ghost_block" | "create:recipes/building_blocks/limestone_from_stone_types_limestone_stonecutting" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_corner_dusk_brick_slab_stonecutting" | "minecraft:husbandry/make_a_sign_glow" | "create:andesite_alloy" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_magenta" | "enderio:recipes/misc/drain" | "minecraft:recipes/building_blocks/dye_lime_wool" | "minecraft:recipes/redstone/acacia_pressure_plate" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_light_blue" | "create:water_wheel" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_short_blue_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/crimson_slab" | "createdeco:recipes/building_blocks/long_pearl_brick_wall_from_corner_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/mossy_verdant_brick_slab_from_mossy_verdant_bricks_stonecutting" | "ae2:recipes/misc/tools/paintballs_lumen_pink" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_gray" | "create:recipes/building_blocks/vertical_framed_glass_from_glass_colorless_stonecutting" | "ae2:recipes/misc/shaped/walls/quartz_bricks" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_magenta" | "tconstruct:recipes/decorations/common/glass/yellow_clear_stained_glass_pane_from_panes" | "ae2:recipes/misc/network/cables/glass_light_blue" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_tiled_scarlet_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_m_white" | "minecraft:recipes/building_blocks/green_stained_glass" | "ae2:recipes/misc/network/parts/annihilation_plane_alt" | "create:recipes/misc/crafting/logistics/pulse_timer" | "ae2:recipes/misc/network/cables/glass_black" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_cyan" | "createdeco:recipes/building_blocks/short_scarlet_brick_wall_from_scarlet_bricks_stonecutting" | "create:recipes/building_blocks/small_granite_brick_slab_recycling" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_stairs" | "ae2:recipes/misc/network/blocks/pattern_providers_interface" | "create:recipes/building_blocks/small_diorite_brick_wall_from_stone_types_diorite_stonecutting" | "minecraft:recipes/building_blocks/bookshelf" | "ae2:recipes/misc/block_cutter/stairs/fluix_stairs" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_long_dean_bricks_stonecutting" | "tconstruct:recipes/decorations/common/glass/light_blue_clear_stained_glass_pane_from_panes" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_scarlet_brick_stairs_stonecutting" | "tconstruct:recipes/decorations/world/wood/skyroot/hanging_sign" | "tconstruct:recipes/decorations/common/copper_platform_waxing_unaffected" | "createdeco:recipes/building_blocks/corner_umber_brick_slab_from_tiled_umber_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/corner_red_bricks_from_long_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/cracked_pearl_brick_stairs_from_cracked_pearl_bricks_stonecutting" | "create:recipes/building_blocks/small_tuff_bricks_from_stone_types_tuff_stonecutting" | "minecraft:story/iron_tools" | "ae2:recipes/misc/tools/certus_quartz_axe" | "create:recipes/misc/smelting/glass_pane_from_vertical_framed_glass_pane" | "createdeco:recipes/building_blocks/mossy_pearl_brick_slab_from_mossy_pearl_bricks_stonecutting" | "minecraft:recipes/combat/iron_chestplate" | "createdeco:recipes/decorations/brass_catwalk_stairs" | "expatternprovider:recipes/misc/oversize_interface" | "tconstruct:recipes/redstone/common/slime/ichor/slimeblock" | "minecraft:recipes/redstone/oak_trapdoor" | "tconstruct:recipes/food/gadgets/cake/magma" | "create_connected:recipes/crafting/kinetics/inverted_gearshift_from_conversion" | "enderio:recipes/misc/ensouled_chassis" | "ae2:recipes/misc/network/cells/spatial_storage_cell_2_cubed" | "create:recipes/building_blocks/limestone_pillar_from_stone_types_limestone_stonecutting" | "sophisticatedbackpacks:recipes/misc/chipped/mason_table_upgrade" | "create:honey_drain" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_iron_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/long_scarlet_brick_wall_from_long_scarlet_bricks_stonecutting" | "minecraft:recipes/building_blocks/purpur_slab" | "createdeco:recipes/decorations/green_iron_lamp" | "ae2:recipes/misc/misc/deconstruction_certus_quartz_block" | "minecraft:recipes/combat/stone_sword" | "minecraft:recipes/decorations/cobblestone_wall" | "createdeco:recipes/building_blocks/pearl_bricks_from_long_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_wall_from_corner_scarlet_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_short_umber_bricks_stonecutting" | "ae2:recipes/misc/network/blocks/energy_energy_acceptor_alt" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_locometal_smokebox" | "create:recipes/misc/smelting/ingot_lead_compat_mekanism" | "create:recipes/building_blocks/cut_asurine_from_stone_types_asurine_stonecutting" | "create:recipes/misc/crafting/logistics/desk_bell" | "expatternprovider:recipes/misc/crystal_fixer" | "createdeco:recipes/building_blocks/corner_umber_brick_wall_from_umber_bricks_stonecutting" | "minecraft:recipes/decorations/red_stained_glass_pane" | "minecraft:recipes/food/dried_kelp_from_campfire_cooking" | "createdeco:recipes/building_blocks/corner_umber_bricks_from_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_riveted_locometal" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_blue_bricks_stonecutting" | "minecraft:recipes/misc/gold_nugget_from_smelting" | "createdeco:recipes/building_blocks/corner_red_brick_wall_from_long_red_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_d_orange" | "createdeco:recipes/decorations/copper_mesh_fence" | "ae2:recipes/misc/tools/misctools_charged_staff" | "minecraft:recipes/misc/netherite_upgrade_smithing_template" | "minecraft:recipes/tools/stone_axe" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_lime" | "enderio:recipes/building_blocks/recolor_clear_glass_np_white" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_green" | "minecraft:recipes/decorations/blue_candle" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_brown" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_scarlet_brick_slab_stonecutting" | "tconstruct:recipes/misc/common/materials/rose_gold_ingot_from_nuggets" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_light_blue" | "create:recipes/misc/blasting/zinc_ingot_from_raw_ore" | "tconstruct:recipes/redstone/smeltery/seared/fuel_tank" | "minecraft:nether/ride_strider" | "create:recipes/misc/crafting/appliances/cardboard_helmet" | "createdeco:recipes/building_blocks/short_dusk_bricks_from_tiled_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_umber_brick_stairs_from_tiled_umber_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/long_dusk_brick_wall" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_light_gray" | "tconstruct:smeltery/tinkers_anvil" | "createdeco:recipes/building_blocks/short_pearl_bricks_from_long_pearl_bricks_stonecutting" | "sophisticatedbackpacks:recipes/misc/chipped/carpenters_table_upgrade" | "storagedrawers:recipes/storagedrawers/jungle_drawers" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_honeycomb" | "minecraft:recipes/misc/iron_nugget" | "create:recipes/building_blocks/cut_calcite_slab_from_stone_types_calcite_stonecutting" | "createdeco:recipes/building_blocks/corner_scarlet_brick_wall_from_tiled_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_wall_from_blue_brick_wall_stonecutting" | "minecraft:recipes/building_blocks/blue_stained_glass" | "create:self_deploying" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_slab_stonecutter" | "createdeco:recipes/building_blocks/scarlet_brick_wall_from_long_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_wall_from_short_blue_bricks_stonecutting" | "tconstruct:smeltery/cast_collector" | "minecraft:recipes/building_blocks/cut_copper_slab_from_cut_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_flat_riveted_locometal" | "copycats:recipes/crafting/copycat_stone_pressure_plate" | "expatternprovider:recipes/misc/ei_alt" | "minecraft:recipes/misc/iron_ingot_from_blasting_iron_ore" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_corner_scarlet_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/short_verdant_brick_slab" | "minecraft:recipes/misc/bucket" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_copper_wrapped_locometal" | "ae2:main/qnb" | "minecraft:recipes/building_blocks/diorite_slab" | "minecraft:adventure/bullseye" | "createdeco:recipes/building_blocks/corner_dusk_brick_wall" | "create:recipes/building_blocks/polished_cut_veridium_slab_from_stone_types_veridium_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_corner_dusk_brick_slab_stonecutting" | "minecraft:recipes/decorations/orange_stained_glass_pane" | "extra_gauges:recipes/redstone/display_collector" | "create:recipes/building_blocks/small_scoria_brick_stairs_from_stone_types_scoria_stonecutting" | "createdeco:recipes/decorations/zinc_mesh_fence" | "create:recipes/misc/crafting/kinetics/mechanical_roller" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_locometal_smokebox" | "createdeco:recipes/decorations/blue_brass_lamp" | "minecraft:recipes/combat/bow" | "minecraft:recipes/building_blocks/acacia_slab" | "minecraft:recipes/building_blocks/smooth_sandstone" | "tconstruct:recipes/misc/common/materials/queens_slime_ingot_from_block" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_dusk_bricks_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper" | "ae2:recipes/misc/block_cutter/walls/smooth_quartz_wall" | "enderio:recipes/building_blocks/recolor_fused_quartz_yellow" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_locometal_boiler" | "create:recipes/building_blocks/cut_diorite_bricks_from_stone_types_diorite_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_corner_pearl_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_flat_slashed_locometal" | "ae2:recipes/misc/block_cutter/slabs/sky_stone_small_brick_slab" | "enderio:recipes/building_blocks/recolor_clear_glass_m_light_blue" | "minecraft:recipes/decorations/orange_glazed_terracotta" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_white" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_plated_locometal" | "create:recipes/misc/crafting/materials/copper_nugget" | "minecraft:recipes/decorations/green_stained_glass_pane" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_corner_verdant_bricks_stonecutting" | "copycats:recipes/crafting/copycat_byte_panel" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_tiled_scarlet_bricks_stonecutting" | "ae2:recipes/misc/network/cables/glass_pink" | "ae2:recipes/misc/tools/network_memory_card" | "railways:recipes/misc/stonecutting/palettes/cycling/black_flat_slashed_locometal" | "create:steam_engine_maxed" | "createdeco:recipes/building_blocks/corner_dean_brick_stairs_from_dean_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/corner_dusk_bricks_from_dusk_bricks_stonecutting" | "enderio:recipes/misc/copper_alloy_grinding_ball" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_corner_verdant_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_short_blue_brick_stairs_stonecutting" | "minecraft:story/enter_the_nether" | "enderio:recipes/building_blocks/recolor_clear_glass_d_brown" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_crimsite_brick_slab_from_stone_types_crimsite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_iron_wrapped_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_p_pink" | "createdeco:recipes/building_blocks/long_red_brick_stairs_from_bricks_stonecutting" | "tconstruct:world/sky_island" | "create:recipes/misc/crafting/kinetics/filter" | "create:recipes/building_blocks/cut_andesite_stairs" | "createdeco:recipes/building_blocks/cracked_verdant_brick_stairs_from_cracked_verdant_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_plated_locometal" | "create:recipes/building_blocks/cut_limestone_brick_stairs" | "create:recipes/misc/crafting/kinetics/white_sail" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingle_slab_from_honeycomb" | "create:recipes/misc/crafting/tree_fertilizer" | "createdeco:recipes/building_blocks/cracked_dusk_brick_wall_from_cracked_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_wall_from_long_dean_brick_wall_stonecutting" | "tconstruct:recipes/redstone/world/wood/enderbark/trapdoor" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_flat_slashed_locometal" | "create:recipes/misc/crafting/logistics/package_frogport" | "minecraft:recipes/misc/pink_dye_from_pink_tulip" | "minecraft:recipes/building_blocks/mangrove_stairs" | "createdeco:recipes/building_blocks/mossy_umber_bricks_from_vine" | "sophisticatedbackpacks:recipes/misc/auto_smoking_upgrade" | "minecraft:recipes/decorations/spruce_sign" | "sophisticatedbackpacks:recipes/misc/diamond_backpack" | "create:recipes/building_blocks/cut_calcite_brick_wall" | "createdeco:recipes/decorations/iron_bars_overlay" | "createdeco:recipes/building_blocks/corner_scarlet_brick_wall_from_long_scarlet_brick_wall_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/green_locometal_pillar" | "createdeco:recipes/decorations/decal_fire_diamond" | "ae2:main/crafting_terminal" | "createdeco:recipes/decorations/purple_shipping_container" | "chiselsandbits:recipes/tools/chisel_netherite" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_yellow" | "minecraft:recipes/combat/netherite_leggings_smithing" | "createdeco:recipes/building_blocks/short_blue_brick_slab" | "tconstruct:recipes/smeltery/seared/seared_brick_kiln" | "minecraft:recipes/building_blocks/red_terracotta" | "ae2:recipes/misc/network/cables/dense_covered_purple" | "enderio:recipes/misc/painting_machine" | "create:recipes/building_blocks/small_diorite_brick_slab_recycling" | "tconstruct:recipes/misc/common/materials/cinderslime_ingot_from_block" | "createdeco:recipes/building_blocks/mossy_dean_brick_stairs" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_corner_scarlet_brick_stairs_stonecutting" | "tconstruct:recipes/misc/smeltery/sand_cast" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_wall_from_long_scarlet_brick_wall_stonecutting" | "tconstruct:recipes/misc/common/materials/pig_iron_block_from_ingots" | "tconstruct:recipes/redstone/smeltery/seared/drain_retextured" | "create:recipes/building_blocks/crafting/kinetics/red_seat" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_pink" | "createdeco:recipes/building_blocks/corner_umber_bricks_from_long_umber_bricks_stonecutting" | "minecraft:recipes/combat/golden_helmet" | "create:recipes/misc/smelting/glass_pane_from_framed_glass_pane" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_from_waxed_exposed_copper_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/light_gray_seat" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_splashing" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_locometal_pillar" | "create:recipes/building_blocks/cut_ochrum_stairs" | "minecraft:recipes/building_blocks/brick_slab_from_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_light_blue" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_flat_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_riveted_locometal" | "create:recipes/building_blocks/small_andesite_brick_wall" | "createdeco:recipes/building_blocks/corner_red_brick_wall_from_corner_red_bricks_stonecutting" | "createdeco:recipes/decorations/cyan_shipping_container_from_dyeing_vaults" | "ae2:recipes/misc/block_cutter/slabs/quartz_pillar_slab" | "createdeco:recipes/building_blocks/tiled_verdant_bricks_from_corner_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/cracked_blue_brick_stairs" | "create:recipes/building_blocks/crafting/logistics/brown_table_cloth_from_other_table_cloth" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_corner_dean_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/corner_umber_brick_slab_from_umber_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/corner_pearl_brick_stairs_from_corner_pearl_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_cyan" | "minecraft:recipes/decorations/composter" | "ae2:recipes/misc/decorative/sky_stone_brick" | "enderio:recipes/redstone/resetting_lever_sixty_inv_from_prev" | "enderio:recipes/redstone/resetting_lever_thirty_from_prev" | "tconstruct:recipes/redstone/world/wood/greenheart/pressure_plate" | "create:recipes/building_blocks/cut_ochrum_brick_slab" | "create:recipes/building_blocks/dripstone_block_from_stone_types_dripstone_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_bricks_from_corner_umber_bricks_stonecutting" | "create:recipes/building_blocks/cut_scorchia_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_locometal_pillar" | "ae2:recipes/misc/block_cutter/walls/sky_stone_brick_wall" | "create:recipes/building_blocks/cut_calcite_brick_stairs" | "minecraft:recipes/building_blocks/end_stone_bricks" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_starter_tier" | "createdeco:recipes/building_blocks/umber_brick_slab" | "minecraft:recipes/decorations/glow_item_frame" | "railways:recipes/misc/crafting/palettes/wrapping/light_gray_copper_wrapped_locometal" | "minecraft:husbandry/silk_touch_nest" | "minecraft:recipes/building_blocks/dark_prismarine_stairs" | "createdeco:recipes/decorations/orange_placard_from_dyeing" | "enderio:recipes/tools/staff_of_travelling" | "enderio:recipes/misc/redstone_alloy_grinding_ball" | "create:train_roadkill" | "sophisticatedbackpacks:recipes/misc/chipped/glassblower_upgrade" | "createdeco:recipes/building_blocks/tiled_dusk_bricks_from_corner_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_corner_umber_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_gray" | "createdeco:recipes/misc/industrial_iron_block" | "createdeco:recipes/decorations/andesite_catwalk_from_stonecutting" | "createdeco:recipes/decorations/magenta_shipping_container" | "createdeco:recipes/building_blocks/corner_scarlet_bricks_from_long_scarlet_bricks_stonecutting" | "createdeco:recipes/decorations/zinc_catwalk_forge" | "create:recipes/misc/crafting/kinetics/black_valve_handle_from_other_valve_handle" | "create:recipes/building_blocks/oxidized_copper_tile_stairs_from_oxidized_copper_tiles_stonecutting" | "minecraft:story/smelt_iron" | "minecraft:recipes/misc/orange_dye_from_torchflower" | "create:recipes/misc/smelting/ingot_tin_compat_mekanism" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_tiled_pearl_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_e_purple" | "minecraft:recipes/decorations/smoker" | "create:wrench_goggles" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_light_gray" | "railways:recipes/misc/crafting/palettes/wrapping/gray_iron_wrapped_locometal" | "create:recipes/building_blocks/crafting/logistics/blue_table_cloth" | "createdeco:recipes/building_blocks/corner_scarlet_brick_wall_from_tiled_scarlet_brick_wall_stonecutting" | "createdeco:recipes/decorations/andesite_support_wedge" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/log_to_wood" | "createdeco:recipes/building_blocks/short_red_brick_stairs_from_tiled_red_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_na_purple" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_orange" | "create:recipes/misc/blasting/ingot_osmium_compat_mekanism" | "minecraft:husbandry/wax_off" | "railways:recipes/misc/stonecutting/palettes/cycling/flat_slashed_locometal" | "ae2:recipes/misc/decorative/quartz_block" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_short_blue_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_riveted_locometal" | "createdeco:recipes/building_blocks/cracked_blue_brick_wall_from_cracked_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_corner_blue_bricks_stonecutting" | "createdeco:recipes/decorations/iron_bars_overlay_from_stonecutting" | "minecraft:recipes/misc/rib_armor_trim_smithing_template_smithing_trim" | "createdeco:recipes/building_blocks/corner_dusk_brick_stairs_from_dusk_brick_stairs_stonecutting" | "minecraft:recipes/decorations/lime_candle" | "minecraft:recipes/building_blocks/emerald_block" | "sophisticatedbackpacks:recipes/misc/chipped/tinkering_table_upgrade" | "minecraft:recipes/redstone/trapped_chest" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_orange" | "tconstruct:world/slimeskull" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_dusk_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_brown" | "ae2:recipes/misc/tools/nether_quartz_cutting_knife" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_slab" | "sophisticatedbackpacks:recipes/misc/advanced_magnet_upgrade_from_basic" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_short_verdant_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_brown" | "createdeco:recipes/building_blocks/umber_brick_wall_from_tiled_umber_bricks_stonecutting" | "create:rose_quartz" | "tconstruct:recipes/building_blocks/smeltery/scorched/polished_scorched_stone_stonecutting" | "create:recipes/misc/smelting/ingot_uranium_compat_ic2" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_red" | "ae2:recipes/misc/tools/fluix_axe" | "minecraft:recipes/building_blocks/sponge" | "create:recipes/building_blocks/cut_veridium_wall" | "createdeco:recipes/building_blocks/umber_brick_wall_from_long_umber_bricks_stonecutting" | "storagedrawers:recipes/storagedrawers/birch_trim" | "create:recipes/building_blocks/cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "create:recipes/misc/crafting/schematics/empty_schematic" | "createdeco:recipes/building_blocks/corner_dusk_brick_wall_from_tiled_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/cracked_verdant_brick_wall_from_cracked_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_short_verdant_brick_stairs_stonecutting" | "minecraft:recipes/redstone/warped_fence_gate" | "create:recipes/building_blocks/cut_veridium_brick_slab_recycling" | "enderio:recipes/misc/wood_gear" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_iron_wrapped_locometal" | "tconstruct:recipes/decorations/world/wood/bloodshroom/sign" | "tconstruct:recipes/decorations/common/glass/gray_clear_stained_glass_pane_from_panes" | "createdeco:recipes/building_blocks/short_blue_brick_wall_from_long_blue_bricks_stonecutting" | "create:recipes/misc/smelting/glass_pane_from_horizontal_framed_glass_pane" | "ae2:recipes/misc/network/crystal_resonance_generator" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_locometal_smokebox" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_riveted_locometal" | "create:package_chute_throw" | "enderio:recipes/misc/gold_ingot_from_smelting" | "storagedrawers:recipes/storagedrawers/void_upgrade" | "createdeco:recipes/building_blocks/short_red_brick_wall_from_long_red_brick_wall_stonecutting" | "minecraft:end/dragon_breath" | "create:recipes/misc/blasting/silver_ingot_compat_galosphere" | "createdeco:recipes/building_blocks/long_dusk_brick_wall_from_corner_dusk_bricks_stonecutting" | "railways:recipes/combat/dying_existing_cap_purple" | "enderio:recipes/building_blocks/recolor_clear_glass_np_red" | "createdeco:recipes/decorations/andesite_hull_from_stonecutting" | "create:recipes/misc/crafting/kinetics/blue_valve_handle_from_other_valve_handle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_locometal_boiler" | "enderio:recipes/building_blocks/recolor_clear_glass_p_orange" | "minecraft:recipes/building_blocks/white_concrete_powder" | "create:recipes/building_blocks/small_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/stripped_log_to_wood" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_short_blue_brick_stairs_stonecutting" | "minecraft:recipes/misc/music_disc_5" | "create:recipes/building_blocks/cut_dripstone_slab" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_light_blue" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_corner_umber_bricks_stonecutting" | "create:recipes/building_blocks/layered_crimsite_from_stone_types_crimsite_stonecutting" | "minecraft:recipes/building_blocks/lime_stained_glass" | "create:recipes/building_blocks/polished_cut_tuff_wall" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_corner_umber_bricks_stonecutting" | "minecraft:recipes/building_blocks/quartz_pillar_from_quartz_block_stonecutting" | "create:recipes/building_blocks/cut_tuff_wall" | "minecraft:recipes/redstone/cherry_trapdoor" | "create:recipes/misc/crafting/kinetics/brass_hand" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_brass_wrapped_locometal" | "enderio:recipes/misc/soul_binder" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_locometal_pillar" | "create:stressometer_maxed" | "minecraft:recipes/decorations/yellow_bed" | "create:recipes/building_blocks/layered_ochrum_from_stone_types_ochrum_stonecutting" | "tconstruct:tools/tool_smith" | "createdeco:recipes/building_blocks/mossy_umber_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_locometal_smokebox" | "create:recipes/building_blocks/cut_limestone_stairs" | "create:recipes/misc/crafting/logistics/redstone_requester" | "minecraft:recipes/redstone/cherry_button" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs" | "minecraft:recipes/misc/coal_from_blasting_coal_ore" | "create_connected:recipes/crafting/palettes/copycat_board_compat" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_locometal_smokebox" | "ae2:recipes/misc/network/cells/item_storage_cell_4k" | "createdeco:recipes/building_blocks/corner_dean_brick_slab_from_tiled_dean_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_corner_scarlet_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_pink" | "minecraft:recipes/building_blocks/chiseled_bookshelf" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_copper_wrapped_locometal_boiler" | "create:recipes/misc/crafting/appliances/clipboard" | "create:recipes/building_blocks/crafting/kinetics/black_seat_from_other_seat" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_corner_umber_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/corner_red_bricks_from_tiled_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dean_bricks_from_corner_dean_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_locometal_boiler" | "createdeco:recipes/building_blocks/tiled_umber_brick_wall" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_slashed_locometal" | "createdeco:recipes/decorations/red_brass_lamp" | "createdeco:recipes/decorations/cyan_shipping_container" | "ae2:recipes/misc/tools/paintballs_lumen_purple" | "create:recipes/building_blocks/cut_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "create:crafter_lazy_000" | "minecraft:recipes/building_blocks/nether_brick_stairs_from_nether_bricks_stonecutting" | "create:recipes/building_blocks/copper_shingle_stairs" | "ae2:recipes/misc/network/parts/export_bus" | "create:recipes/misc/crafting/kinetics/linear_chassis" | "create:recipes/building_blocks/cut_tuff_brick_stairs_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_red" | "createdeco:recipes/building_blocks/short_verdant_brick_wall_from_long_verdant_brick_wall_stonecutting" | "minecraft:recipes/building_blocks/spruce_wood" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_copper_wrapped_locometal_boiler" | "create:recipes/misc/crafting/kinetics/track_signal" | "ae2:recipes/misc/network/cables/smart_light_gray" | "minecraft:recipes/misc/yellow_dye_from_dandelion" | "ae2:recipes/misc/tools/paintballs_lumen_light_gray" | "enderio:recipes/building_blocks/recolor_clear_glass_gray" | "createdeco:recipes/building_blocks/mossy_pearl_bricks_from_vine" | "storagedrawers:recipes/storagedrawers/fill_level_upgrade" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_stairs" | "create:recipes/misc/crafting/kinetics/gantry_carriage" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_iron_wrapped_locometal_boiler" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_red" | "create_connected:recipes/crafting/kinetics/sequenced_pulse_generator" | "enderio:recipes/building_blocks/recolor_clear_glass_da_pink" | "minecraft:recipes/building_blocks/deepslate_bricks_from_polished_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_slashed_locometal" | "minecraft:recipes/misc/black_dye_from_wither_rose" | "minecraft:recipes/misc/bone_meal" | "create:speed_controller" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_brown" | "railways:recipes/misc/crafting/palettes/wrapping/blue_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/short_umber_brick_wall_from_corner_umber_brick_wall_stonecutting" | "create:recipes/building_blocks/tuff_pillar_from_stone_types_tuff_stonecutting" | "create:recipes/building_blocks/diorite_pillar_from_stone_types_diorite_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_slab_from_prismarine_stonecutting" | "create:recipes/building_blocks/weathered_iron_window_pane" | "minecraft:adventure/totem_of_undying" | "minecraft:recipes/decorations/cobbled_deepslate_wall" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_iron_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/prismarine_bricks" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_pink" | "create:recipes/misc/crafting/appliances/name_tag" | "minecraft:recipes/decorations/polished_deepslate_wall_from_cobbled_deepslate_stonecutting" | "tconstruct:recipes/building_blocks/world/wood/skyroot/planks" | "enderio:recipes/misc/slice_and_splice" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_brass_wrapped_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_a_pink" | "createdeco:recipes/building_blocks/tiled_verdant_brick_wall_from_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_tiled_dusk_bricks_stonecutting" | "minecraft:recipes/decorations/diorite_wall" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs" | "createdeco:recipes/building_blocks/short_verdant_brick_wall_from_verdant_brick_wall_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_locometal_boiler" | "createdeco:recipes/building_blocks/mossy_dusk_brick_wall_from_mossy_dusk_bricks_stonecutting" | "createdeco:recipes/decorations/decal_creeper" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_corner_verdant_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_white" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_blue" | "minecraft:recipes/decorations/stonecutter" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_long_umber_brick_stairs_stonecutting" | "createdeco:recipes/decorations/andesite_bars_overlay" | "tconstruct:recipes/misc/common/materials/netherite_ingot_from_nuggets" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_brass_wrapped_locometal_boiler" | "tconstruct:recipes/misc/common/materials/pig_iron_ingot_from_nuggets" | "ae2:recipes/misc/tools/nether_quartz_spade" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_copper_wrapped_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_black" | "create:recipes/building_blocks/crafting/logistics/light_gray_table_cloth" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_iron_wrapped_locometal_boiler" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_magenta" | "tconstruct:recipes/misc/common/slime/ichor/slimeball_from_congealed" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_locometal_pillar" | "minecraft:recipes/misc/sugar_from_honey_bottle" | "minecraft:recipes/building_blocks/dye_red_carpet" | "createdeco:recipes/decorations/locked_brass_door" | "tconstruct:recipes/misc/common/slime/sky/crystal_growing" | "chiselsandbits:chiselsandbits/find_chiselables" | "minecraft:husbandry/allay_deliver_cake_to_note_block" | "enderio:recipes/redstone/resetting_lever_sixty_inv" | "create:recipes/building_blocks/cut_limestone_brick_wall" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "enderio:recipes/misc/powered_spawner" | "minecraft:recipes/decorations/orange_stained_glass_pane_from_glass_pane" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_riveted_locometal" | "createdeco:recipes/decorations/lime_placard" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_light_gray" | "tconstruct:recipes/decorations/common/gold_bars" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_yellow" | "create_connected:recipes/crafting/kinetics/parallel_gearbox" | "minecraft:recipes/building_blocks/dye_green_bed" | "ae2wtlib:recipes/wireless_pattern_encoding_terminal" | "createdeco:recipes/building_blocks/tiled_umber_brick_wall_from_short_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_dean_brick_stairs_from_long_dean_brick_stairs_stonecutting" | "tconstruct:recipes/building_blocks/common/slime/sky/congealed" | "expatternprovider:recipes/misc/mod_storage_bus" | "createdeco:recipes/building_blocks/long_dean_brick_wall_from_long_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/quartz_pillar" | "createdeco:recipes/building_blocks/copper_window_pane" | "create:recipes/misc/crafting/logistics/powered_latch" | "ae2:recipes/misc/network/cables/smart_magenta" | "createdeco:recipes/building_blocks/short_red_brick_stairs_from_short_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/scarlet_brick_wall_from_tiled_scarlet_bricks_stonecutting" | "minecraft:recipes/decorations/magenta_bed" | "createdeco:recipes/decorations/zinc_catwalk_stairs_from_stonecutting" | "create:recipes/building_blocks/polished_cut_granite_slab_recycling" | "minecraft:recipes/redstone/honey_block" | "create:recipes/building_blocks/polished_cut_limestone_wall" | "minecraft:recipes/redstone/redstone" | "createdeco:recipes/building_blocks/corner_pearl_brick_wall_from_short_pearl_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/corner_scarlet_brick_wall_from_scarlet_brick_wall_stonecutting" | "minecraft:recipes/misc/coast_armor_trim_smithing_template_smithing_trim" | "createdeco:recipes/building_blocks/blue_bricks_from_tiled_blue_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_na_light_blue" | "railways:recipes/misc/crafting/palettes/wrapping/pink_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_locometal_boiler" | "storagedrawers:recipes/storagedrawers/crimson_drawers" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_lime" | "minecraft:recipes/transportation/spruce_boat" | "tconstruct:recipes/misc/common/materials/cobalt_ingot_from_nuggets" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_slashed_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_yellow" | "ae2:recipes/misc/network/cables/dense_covered_blue" | "copycats:recipes/crafting/copycat_panel_from_half_panels" | "ae2:recipes/misc/block_cutter/slabs/quartz_slab" | "expatternprovider:recipes/misc/water_cell" | "create:recipes/building_blocks/crimsite_pillar_from_stone_types_crimsite_stonecutting" | "copycats:recipes/crafting/copycat_stacked_half_layer_from_conversion" | "railways:recipes/misc/stonecutting/palettes/cycling/black_locometal_smokebox" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_black" | "minecraft:recipes/redstone/note_block" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_orange" | "createdeco:recipes/building_blocks/corner_pearl_brick_wall_from_tiled_pearl_brick_wall_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_em_light_blue" | "create_connected:recipes/crafting/kinetics/kinetic_bridge" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_copper_wrapped_locometal" | "minecraft:recipes/decorations/green_stained_glass_pane_from_glass_pane" | "enderio:recipes/building_blocks/recolor_fused_quartz_light_blue" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_umber_brick_slab_stonecutting" | "create:hose_pulley" | "createdeco:recipes/building_blocks/long_verdant_brick_wall_from_tiled_verdant_bricks_stonecutting" | "minecraft:recipes/decorations/crimson_hanging_sign" | "enderio:recipes/building_blocks/reinforced_obsidian_block" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_iron_wrapped_locometal" | "minecraft:recipes/decorations/lime_bed" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_riveted_locometal" | "create:recipes/building_blocks/polished_cut_granite_slab_from_stone_types_granite_stonecutting" | "create:recipes/misc/crafting/kinetics/empty_blaze_burner" | "createdeco:recipes/building_blocks/long_dean_brick_wall_from_short_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/smooth_stone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_slashed_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_slashed_locometal" | "create:recipes/building_blocks/crafting/kinetics/cyan_seat" | "create:recipes/building_blocks/small_asurine_brick_wall" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_riveted_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_light_blue" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_blue" | "minecraft:recipes/misc/beacon" | "create:recipes/misc/crafting/kinetics/millstone" | "create:recipes/building_blocks/crafting/logistics/light_blue_table_cloth_from_other_table_cloth" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_locometal_boiler" | "minecraft:recipes/building_blocks/cut_copper_from_copper_block_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_gray" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_gray" | "create:recipes/misc/crafting/materials/small_rose_quartz_tiles_from_conversion" | "createdeco:recipes/building_blocks/cracked_scarlet_brick_wall" | "ae2:recipes/misc/tools/paintballs_yellow" | "ae2:recipes/misc/network/cells/item_storage_cell_1k" | "createdeco:recipes/building_blocks/mossy_scarlet_brick_slab_from_mossy_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_short_scarlet_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_magenta" | "enderio:recipes/food/cake" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_pink" | "railways:recipes/misc/crafting/palettes/wrapping/blue_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/cherry_wood" | "createdeco:recipes/decorations/decal_fire" | "createdeco:recipes/building_blocks/short_pearl_brick_wall_from_long_pearl_brick_wall_stonecutting" | "minecraft:recipes/decorations/bamboo_sign" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_light_blue" | "ae2:recipes/misc/tools/matter_cannon" | "createdeco:recipes/building_blocks/corner_pearl_bricks_from_tiled_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/blue_ice" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_flat_slashed_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_magenta" | "createdeco:recipes/building_blocks/corner_pearl_brick_slab_from_long_pearl_brick_slab_stonecutting" | "create:recipes/misc/crafting/appliances/cardboard_chestplate" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_orange" | "minecraft:recipes/building_blocks/red_sandstone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_locometal_boiler" | "minecraft:recipes/decorations/pink_stained_glass_pane_from_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_iron_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_tuff_brick_wall_from_stone_types_tuff_stonecutting" | "create:recipes/misc/crafting/schematics/schematic_table" | "tconstruct:recipes/smeltery/scorched/scorched_brick_kiln" | "create:recipes/building_blocks/crafting/logistics/light_gray_postbox_from_other_postbox" | "ae2:recipes/misc/network/parts/monitors_conversion" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_corner_dusk_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_purple" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_yellow" | "copycats:recipes/crafting/copycat_half_layer_from_conversion" | "ae2:main/storage_cell" | "create:recipes/building_blocks/polished_cut_asurine_wall_from_stone_types_asurine_stonecutting" | "minecraft:recipes/building_blocks/bamboo_mosaic_stairs" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_lime" | "railways:recipes/misc/stonecutting/palettes/cycling/green_locometal_smokebox" | "tconstruct:recipes/decorations/world/wood/skyroot/fence" | "create:recipes/misc/crafting/logistics/cyan_table_cloth_clear" | "ae2:recipes/misc/network/cables/covered_gray" | "minecraft:recipes/misc/paper" | "create:recipes/building_blocks/polished_cut_tuff_stairs" | "tconstruct:smeltery/structure" | "create:backtank" | "tconstruct:recipes/decorations/smeltery/seared/seared_soul_glass_pane" | "minecraft:husbandry/kill_axolotl_target" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_flat_slashed_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/red_flat_riveted_locometal" | "create:recipes/building_blocks/small_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "ae2:recipes/misc/network/crafting/patterns_blank" | "ae2:recipes/misc/network/cells/fluid_storage_cell_4k" | "minecraft:recipes/building_blocks/warped_stairs" | "sophisticatedbackpacks:recipes/misc/alchemy_upgrade" | "create:recipes/building_blocks/small_scorchia_brick_wall" | "minecraft:recipes/building_blocks/white_stained_glass" | "ae2:recipes/misc/network/cables/dense_covered_lime" | "minecraft:recipes/decorations/blue_glazed_terracotta" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_magenta" | "minecraft:recipes/building_blocks/andesite_slab_from_andesite_stonecutting" | "createdeco:recipes/building_blocks/short_dean_bricks_from_tiled_dean_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_brass_wrapped_locometal" | "enderio:recipes/misc/pulsating_alloy_ingot" | "createdeco:recipes/building_blocks/corner_scarlet_brick_stairs_from_long_scarlet_brick_stairs_stonecutting" | "tconstruct:recipes/misc/common/materials/queens_slime_nugget_from_ingot" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_short_blue_brick_slab_stonecutting" | "create:recipes/building_blocks/cut_asurine_brick_slab_recycling" | "createdeco:recipes/building_blocks/tiled_verdant_brick_wall_from_corner_verdant_brick_wall_stonecutting" | "ae2:recipes/misc/shaped/walls/chiseled_quartz_block" | "minecraft:recipes/tools/lead" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_green" | "minecraft:recipes/decorations/warped_sign" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_yellow" | "ae2:recipes/misc/network/cells/view_cell_storage" | "createdeco:recipes/building_blocks/verdant_bricks_from_short_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_scarlet_bricks_from_tiled_scarlet_bricks_stonecutting" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_waxed_copper_block_stonecutting" | "enderio:recipes/misc/end_steel_nugget" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_gray" | "createdeco:recipes/building_blocks/corner_umber_brick_slab" | "minecraft:recipes/decorations/lodestone" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_flat_slashed_locometal" | "createdeco:recipes/building_blocks/corner_umber_brick_slab_from_short_umber_brick_slab_stonecutting" | "tconstruct:recipes/decorations/tables/part_builder" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_tiled_pearl_bricks_stonecutting" | "tconstruct:recipes/decorations/common/glass/white_clear_stained_glass_pane" | "expatternprovider:recipes/misc/wireless_ex_pat" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_locometal_pillar" | "create:recipes/building_blocks/cut_calcite_brick_slab_recycling" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_pink" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_pink" | "enderio:recipes/building_blocks/recolor_clear_glass_d_lime" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_light_blue" | "createdeco:recipes/building_blocks/corner_dean_brick_stairs_from_corner_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_pearl_bricks_from_tiled_pearl_bricks_stonecutting" | "createdeco:recipes/decorations/andesite_door" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_locometal_smokebox" | "create:recipes/building_blocks/crafting/logistics/white_postbox" | "ae2:recipes/misc/network/cells/fluid_storage_cell_1k" | "immersive_paintings:misc/painting" | "minecraft:adventure/honey_block_slide" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_brown" | "create_connected:recipes/crafting/kinetics/brake" | "extra_gauges:recipes/redstone/integer_gauge" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_brown" | "minecraft:recipes/redstone/dark_oak_pressure_plate" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_plated_locometal" | "createdeco:recipes/building_blocks/long_dean_brick_slab" | "minecraft:recipes/building_blocks/smooth_quartz_stairs_from_smooth_quartz_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_long_scarlet_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/industrial_iron_window_pane" | "create:recipes/building_blocks/small_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "minecraft:recipes/misc/iron_ingot_from_smelting_deepslate_iron_ore" | "minecraft:recipes/decorations/nether_brick_fence" | "ae2:recipes/misc/tools/nether_quartz_axe" | "createdeco:recipes/building_blocks/short_umber_bricks_from_long_umber_bricks_stonecutting" | "minecraft:recipes/misc/magenta_dye_from_allium" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_green" | "minecraft:recipes/misc/wayfinder_armor_trim_smithing_template_smithing_trim" | "create_connected:recipes/crafting/kinetics/fluid_tank_from_conversion" | "createdeco:recipes/decorations/decal_top_left" | "enderio:recipes/tools/coordinate_selector" | "minecraft:recipes/decorations/decorated_pot_simple" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_brass_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/cracked_deepslate_tiles" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingle_stairs_from_honeycomb" | "sophisticatedbackpacks:recipes/misc/advanced_alchemy_upgrade" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab" | "minecraft:recipes/decorations/stone_brick_walls_from_stone_stonecutting" | "ae2:recipes/misc/misc/deconstruction_certus_quartz_pillar" | "create:arm_many_targets" | "createdeco:recipes/building_blocks/corner_pearl_brick_wall_from_long_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_dean_brick_stairs_stonecutting" | "create:recipes/misc/smelting/silver_ingot_compat_iceandfire" | "minecraft:recipes/redstone/daylight_detector" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_brass_wrapped_locometal_boiler" | "create:recipes/misc/crafting/materials/copper_ingot" | "copycats:recipes/crafting/copycat_sliding_door_from_conversion" | "createdeco:recipes/building_blocks/verdant_brick_wall_from_tiled_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/cracked_pearl_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal_boiler" | "create:recipes/misc/crafting/kinetics/large_cogwheel" | "ae2:recipes/misc/network/parts/formation_plane_alt" | "sophisticatedbackpacks:recipes/misc/blasting_upgrade" | "enderio:recipes/building_blocks/recolor_clear_glass_d_blue" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_corner_verdant_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_wall_from_long_pearl_bricks_stonecutting" | "minecraft:recipes/combat/diamond_boots" | "ae2:recipes/misc/shaped/slabs/smooth_quartz_block" | "create:recipes/misc/crafting/kinetics/yellow_valve_handle_from_other_valve_handle" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_iron_wrapped_locometal_boiler" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_black" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_white" | "ae2:recipes/misc/decorative/quartz_glass" | "createdeco:recipes/building_blocks/long_dean_brick_wall_from_tiled_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_wall_from_dean_brick_wall_stonecutting" | "enderio:recipes/misc/iron_ingot_from_blasting" | "create:recipes/misc/crafting/kinetics/fluid_valve" | "railways:recipes/misc/crafting/palettes/wrapping/brown_copper_wrapped_locometal" | "create:recipes/decorations/andesite_table_cloth_from_andesite_alloy_stonecutting" | "create:recipes/building_blocks/small_dripstone_brick_stairs" | "ae2:recipes/misc/network/cables/dense_smart_cyan" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_corner_dusk_brick_slab_stonecutting" | "create:red_signal" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_corner_blue_brick_slab_stonecutting" | "minecraft:recipes/combat/iron_sword" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_flat_riveted_locometal" | "minecraft:recipes/misc/light_gray_dye_from_white_tulip" | "createdeco:recipes/building_blocks/mossy_dean_brick_wall_from_mossy_dean_bricks_stonecutting" | "ae2:recipes/misc/materials/cardvoid" | "createdeco:recipes/building_blocks/umber_brick_wall_from_long_umber_brick_wall_stonecutting" | "minecraft:recipes/tools/iron_pickaxe" | "createdeco:recipes/decorations/copper_catwalk_from_stonecutting" | "minecraft:recipes/building_blocks/polished_granite_stairs" | "enderio:recipes/building_blocks/recolor_clear_glass_a_magenta" | "chiselsandbits:recipes/tools/unseal" | "minecraft:recipes/building_blocks/dark_oak_slab" | "ae2:recipes/misc/misc/deconstruction_fluix_block" | "minecraft:recipes/transportation/mangrove_boat" | "create:recipes/misc/crafting/kinetics/light_blue_valve_handle_from_other_valve_handle" | "createdeco:recipes/building_blocks/long_verdant_brick_wall_from_verdant_brick_wall_stonecutting" | "create:recipes/building_blocks/cut_limestone_from_stone_types_limestone_stonecutting" | "ae2:recipes/misc/tools/portable_fluid_cell_64k" | "ae2:recipes/misc/network/crafting/64k_cpu_crafting_storage" | "create_connected:recipes/crafting/kinetics/brass_gearbox" | "minecraft:recipes/building_blocks/stone_brick_slab_from_stone_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_green" | "create:recipes/misc/crafting/logistics/andesite_table_cloth_clear" | "minecraft:recipes/building_blocks/smooth_sandstone_stairs_from_smooth_sandstone_stonecutting" | "createdeco:recipes/building_blocks/corner_red_brick_slab_from_corner_red_bricks_stonecutting" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_honeycomb" | "ae2:recipes/misc/tools/paintballs_lumen_brown" | "ae2:recipes/misc/network/cells/spatial_storage_cell_128_cubed" | "createdeco:recipes/building_blocks/corner_verdant_brick_wall_from_long_verdant_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/cracked_red_brick_stairs_from_cracked_red_bricks_stonecutting" | "createdeco:recipes/decorations/andesite_mesh_fence" | "minecraft:recipes/transportation/detector_rail" | "createdeco:recipes/building_blocks/umber_brick_slab_from_tiled_umber_bricks_stonecutting" | "ae2:recipes/misc/network/blocks/controller" | "minecraft:recipes/combat/shield" | "createdeco:recipes/building_blocks/corner_scarlet_brick_wall_from_short_scarlet_brick_wall_stonecutting" | "createrailwaysnavigator:navigator" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_long_verdant_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/corner_umber_brick_stairs_from_long_umber_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/scarlet_brick_wall_from_short_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_locometal_boiler" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_verdant_bricks_stonecutting" | "enderio:recipes/misc/end_steel_nugget_to_ingot" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_polished_deepslate_stonecutting" | "createdeco:recipes/building_blocks/corner_umber_brick_stairs_from_umber_brick_stairs_stonecutting" | "create:recipes/building_blocks/polished_cut_scoria_wall_from_stone_types_scoria_stonecutting" | "create:recipes/decorations/copper_ladder_from_ingots_copper_stonecutting" | "create:recipes/misc/crafting/kinetics/encased_chain_drive_from_zinc" | "minecraft:recipes/misc/dune_armor_trim_smithing_template" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_iron_wrapped_locometal" | "minecraft:recipes/misc/creeper_banner_pattern" | "ae2:recipes/misc/network/cells/item_storage_cell_256k_storage" | "ae2:recipes/misc/network/parts/toggle_bus_inverted_alt" | "createdeco:recipes/building_blocks/mossy_umber_brick_stairs_from_mossy_umber_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/controls" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_locometal_smokebox" | "createdeco:recipes/building_blocks/cracked_dean_brick_slab_from_cracked_dean_bricks_stonecutting" | "minecraft:recipes/decorations/iron_bars" | "ae2:recipes/misc/block_cutter/stairs/cut_quartz_stairs" | "create:recipes/building_blocks/cut_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "createdeco:recipes/building_blocks/short_pearl_brick_wall_from_pearl_bricks_stonecutting" | "minecraft:recipes/misc/copper_ingot" | "ae2:recipes/misc/network/cables/smart_cyan" | "create:recipes/building_blocks/cut_veridium_slab_from_stone_types_veridium_stonecutting" | "createdeco:recipes/building_blocks/short_verdant_brick_wall_from_short_verdant_bricks_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/scorched/polished_scorched_stone_crafting" | "ae2:recipes/misc/network/parts/tunnels_me" | "minecraft:recipes/building_blocks/dye_purple_wool" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/corner_scarlet_brick_slab_from_tiled_scarlet_brick_slab_stonecutting" | "minecraft:recipes/transportation/chest_minecart" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_corner_blue_brick_stairs_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_purple" | "createdeco:recipes/decorations/brown_shipping_container_from_dyeing_vaults" | "minecraft:recipes/building_blocks/netherite_block" | "create:recipes/building_blocks/cut_granite_slab_recycling" | "minecraft:recipes/decorations/red_carpet" | "createdeco:recipes/decorations/red_zinc_lamp" | "ae2:recipes/misc/tools/paintballs_black" | "minecraft:recipes/misc/wild_armor_trim_smithing_template" | "createdeco:recipes/building_blocks/long_blue_brick_wall_from_blue_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/mossy_pearl_bricks_from_moss_block" | "create:long_travel" | "minecraft:recipes/transportation/dark_oak_chest_boat" | "createdeco:recipes/building_blocks/corner_pearl_brick_slab_from_tiled_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/stone_brick_stairs_from_stone_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_wall" | "createdeco:recipes/building_blocks/verdant_bricks" | "createdeco:recipes/decorations/brass_facade_from_stonecutting" | "minecraft:recipes/building_blocks/mud_brick_slab" | "minecraft:adventure/lightning_rod_with_villager_no_fire" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_corner_scarlet_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_pink" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_locometal_boiler" | "createdeco:recipes/building_blocks/mossy_dusk_brick_stairs_from_mossy_dusk_bricks_stonecutting" | "sophisticatedbackpacks:recipes/misc/advanced_tool_swapper_upgrade" | "minecraft:recipes/brewing/glistering_melon_slice" | "minecraft:recipes/building_blocks/cracked_nether_bricks" | "minecraft:recipes/building_blocks/polished_deepslate_slab_from_cobbled_deepslate_stonecutting" | "expatternprovider:recipes/misc/silicon_block" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_long_umber_brick_slab_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_plated_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_magenta" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_waxed_cut_copper_stonecutting" | "createdeco:recipes/building_blocks/corner_verdant_brick_wall_from_short_verdant_brick_wall_stonecutting" | "tconstruct:recipes/misc/common/slime/ichor/crystal_smelting" | "minecraft:recipes/misc/wild_armor_trim_smithing_template_smithing_trim" | "createdeco:recipes/building_blocks/cracked_dusk_brick_wall" | "createdeco:recipes/building_blocks/corner_scarlet_brick_stairs_from_scarlet_bricks_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_paver_slab_stonecutter" | "create:recipes/building_blocks/crafting/kinetics/pink_seat" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_pink" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_yellow" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_corner_scarlet_bricks_stonecutting" | "enderio:recipes/tools/glider_wing" | "createdeco:recipes/building_blocks/cracked_pearl_brick_slab_from_cracked_pearl_bricks_stonecutting" | "create:recipes/building_blocks/mangrove_window_pane" | "create:recipes/building_blocks/polished_cut_calcite_slab_from_stone_types_calcite_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_tiled_umber_brick_slab_stonecutting" | "ae2:recipes/misc/network/cells/view_cell" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_locometal_pillar" | "createdeco:recipes/decorations/netherite_coinstack" | "minecraft:recipes/decorations/polished_deepslate_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/food/cooked_salmon_from_smoking" | "tconstruct:recipes/decorations/smeltery/seared/seared_glass_pane" | "createdeco:recipes/building_blocks/cracked_verdant_brick_wall" | "minecraft:recipes/tools/netherite_shovel_smithing" | "minecraft:recipes/brewing/glass_bottle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_brass_wrapped_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_red" | "createdeco:recipes/building_blocks/corner_red_bricks_from_short_red_bricks_stonecutting" | "ae2:recipes/misc/network/cables/glass_orange" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_yellow" | "minecraft:recipes/misc/lime_dye_from_smelting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_locometal_pillar" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_blue" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingle_slab_from_honeycomb" | "createdeco:recipes/decorations/green_copper_lamp" | "ae2:recipes/misc/network/cables/covered_fluix" | "enderio:recipes/misc/dark_steel_block" | "create:recipes/building_blocks/copycat_step_from_ingots_zinc_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/small_tuff_brick_slab" | "createdeco:recipes/building_blocks/brass_window" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_iron_wrapped_locometal_boiler" | "create_connected:recipes/crafting/kinetics/inventory_access_port" | "create:recipes/building_blocks/cut_diorite_brick_slab" | "enderio:recipes/misc/vibrant_alloy_nugget_to_ingot" | "createdeco:recipes/building_blocks/short_blue_bricks_from_long_blue_bricks_stonecutting" | "create:recipes/building_blocks/small_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "create:recipes/misc/crafting/logistics/redstone_contact" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_tiled_dusk_bricks_stonecutting" | "ae2:recipes/misc/tools/network_color_applicator" | "createdeco:recipes/building_blocks/long_red_bricks_from_short_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_dean_brick_wall_from_short_dean_brick_wall_stonecutting" | "tconstruct:recipes/decorations/common/copper_platform_waxing_weathered" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_locometal_smokebox" | "railways:recipes/misc/stonecutting/palettes/cycling/white_flat_riveted_locometal" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_corner_blue_brick_stairs_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab" | "sophisticatedbackpacks:recipes/misc/smoking_upgrade_from_smelting_upgrade" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_riveted_locometal" | "tconstruct:recipes/building_blocks/common/slime/ender/crystal_block" | "ae2:recipes/misc/tools/fluix_pickaxe" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_riveted_locometal" | "chiselsandbits:recipes/tools/quill" | "enderio:recipes/building_blocks/recolor_clear_glass_m_brown" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_orange" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_yellow" | "ae2:recipes/misc/shaped/slabs/sky_stone_brick" | "minecraft:recipes/brewing/fermented_spider_eye" | "minecraft:recipes/misc/iron_ingot_from_smelting_raw_iron" | "ae2:recipes/misc/network/cables/smart_fluix_clean" | "createdeco:recipes/building_blocks/corner_dean_brick_stairs_from_long_dean_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_locometal_smokebox" | "minecraft:recipes/misc/purple_dye" | "expatternprovider:recipes/misc/cobblestone_cell" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_yellow" | "create:recipes/building_blocks/cut_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "createdeco:recipes/building_blocks/long_red_bricks_from_corner_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_bricks_from_tiled_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_red_bricks_from_long_red_bricks_stonecutting" | "minecraft:recipes/building_blocks/waxed_cut_copper_from_waxed_copper_block_stonecutting" | "minecraft:recipes/building_blocks/dried_kelp_block" | "tconstruct:tools/tinker_tool" | "minecraft:recipes/building_blocks/quartz_bricks_from_quartz_block_stonecutting" | "create:recipes/building_blocks/cut_calcite_from_stone_types_calcite_stonecutting" | "create:recipes/building_blocks/cut_scorchia_slab_recycling" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_road_stairs_stonecutter" | "copycats:recipes/crafting/copycat_vertical_stairs" | "createdeco:recipes/building_blocks/pearl_brick_wall_from_short_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/verdant_brick_wall" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_flat_slashed_locometal" | "tconstruct:tools/material_master" | "create:recipes/building_blocks/small_deepslate_brick_slab_recycling" | "tconstruct:recipes/decorations/common/glass/yellow_clear_stained_glass_pane" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_pearl_bricks_stonecutting" | "tconstruct:foundry/structure" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_black" | "tconstruct:recipes/misc/common/materials/hepatizon_ingot_from_block" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_cyan" | "create:recipes/building_blocks/crafting/logistics/black_table_cloth" | "minecraft:recipes/building_blocks/dye_white_carpet" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_long_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/white_terracotta" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_copper_wrapped_locometal" | "minecraft:recipes/misc/white_dye_from_lily_of_the_valley" | "createdeco:recipes/decorations/zinc_support_wedge_from_stonecutting" | "create:recipes/misc/crafting/materials/andesite_alloy_from_zinc" | "minecraft:recipes/building_blocks/polished_blackstone_bricks_from_polished_blackstone_stonecutting" | "createdeco:recipes/decorations/zinc_catwalk_railing_forge" | "tconstruct:recipes/misc/common/materials/manyullyn_block_from_ingots" | "create:recipes/building_blocks/crafting/logistics/green_postbox_from_other_postbox" | "create:recipes/building_blocks/cut_granite_wall_from_stone_types_granite_stonecutting" | "createdeco:recipes/building_blocks/long_blue_brick_wall_from_corner_blue_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_magenta" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_stairs_stonecutter" | "createdeco:recipes/decorations/zinc_bars_overlay_from_stonecutting" | "ae2:recipes/misc/misc/chests_smooth_sky_stone" | "minecraft:recipes/building_blocks/dye_light_blue_bed" | "minecraft:recipes/decorations/lime_carpet" | "railways:recipes/misc/crafting/smokestack_diesel" | "createdeco:recipes/building_blocks/scarlet_bricks" | "createdeco:recipes/building_blocks/short_red_brick_slab_from_tiled_red_bricks_stonecutting" | "minecraft:recipes/building_blocks/stone_brick_slab_from_stone_bricks_stonecutting" | "tconstruct:recipes/decorations/smeltery/seared/basin" | "minecraft:recipes/misc/spire_armor_trim_smithing_template" | "create:recipes/misc/crafting/kinetics/stressometer_from_conversion" | "minecraft:recipes/building_blocks/stone_slab_from_stone_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/gray_brass_wrapped_locometal" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_tinted_glass" | "minecraft:recipes/tools/flint_and_steel" | "minecraft:recipes/building_blocks/dye_purple_carpet" | "minecraft:recipes/building_blocks/nether_bricks" | "create:recipes/building_blocks/andesite_pillar_from_stone_types_andesite_stonecutting" | "createdeco:recipes/building_blocks/long_red_brick_slab_from_long_red_bricks_stonecutting" | "create:recipes/building_blocks/scorchia_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/misc/sugar_from_sugar_cane" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_flat_riveted_locometal" | "minecraft:recipes/building_blocks/dye_magenta_bed" | "minecraft:recipes/decorations/respawn_anchor" | "tconstruct:recipes/building_blocks/smeltery/seared/grout_multiple" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_short_dean_brick_stairs_stonecutting" | "createdeco:recipes/decorations/blue_placard" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_yellow" | "copycats:recipes/crafting/copycat_wall" | "createdeco:recipes/building_blocks/mossy_umber_brick_wall_from_mossy_umber_bricks_stonecutting" | "ae2:recipes/misc/network/cables/glass_gray" | "createdeco:recipes/building_blocks/long_scarlet_brick_wall_from_tiled_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_locometal_smokebox" | "minecraft:recipes/decorations/mossy_cobblestone_wall" | "create:recipes/building_blocks/cut_veridium_slab_recycling" | "createdeco:recipes/building_blocks/mossy_umber_brick_slab_from_mossy_umber_bricks_stonecutting" | "minecraft:nether/get_wither_skull" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_wall_from_short_scarlet_bricks_stonecutting" | "tconstruct:recipes/misc/common/fantastic_foundry" | "createdeco:recipes/building_blocks/short_umber_brick_stairs" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_short_scarlet_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_short_umber_bricks_stonecutting" | "minecraft:recipes/decorations/diorite_wall_from_diorite_stonecutting" | "railways:recipes/misc/crafting/big_buffer" | "createdeco:recipes/building_blocks/tiled_blue_brick_wall_from_blue_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/magenta_valve_handle_from_other_valve_handle" | "copycats:recipes/crafting/copycat_trapdoor" | "create:recipes/misc/crafting/kinetics/white_sail_from_conversion" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_long_dusk_bricks_stonecutting" | "enderio:recipes/misc/sag_mill" | "create:recipes/building_blocks/small_granite_brick_slab_from_stone_types_granite_stonecutting" | "minecraft:recipes/tools/wooden_pickaxe" | "createdeco:recipes/building_blocks/corner_scarlet_brick_slab_from_long_scarlet_bricks_stonecutting" | "minecraft:recipes/building_blocks/cobbled_deepslate_stairs" | "minecraft:recipes/building_blocks/mossy_stone_brick_stairs" | "create:recipes/misc/crafting/kinetics/cyan_valve_handle_from_other_valve_handle" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_scarlet_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_wall" | "createdeco:recipes/building_blocks/umber_bricks_from_long_umber_bricks_stonecutting" | "create:recipes/building_blocks/cut_tuff_brick_slab" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone_from_polished_blackstone_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_long_dusk_bricks_stonecutting" | "create:recipes/building_blocks/framed_glass_pane_from_glass_panes_colorless_stonecutting" | "ae2:recipes/misc/network/cables/glass_fluix_clean" | "create:recipes/building_blocks/polished_cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "enderio:recipes/misc/copper_alloy_nugget" | "minecraft:recipes/food/baked_potato_from_smoking" | "create:recipes/building_blocks/small_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "create:recipes/building_blocks/cut_dripstone_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_brass_wrapped_locometal_boiler" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_yellow" | "createdeco:recipes/building_blocks/corner_pearl_brick_wall_from_long_pearl_brick_wall_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_glass" | "create:recipes/misc/smelting/ingot_silver_compat_ic2" | "minecraft:recipes/decorations/black_stained_glass_pane_from_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_copper_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/short_pearl_bricks_from_pearl_bricks_stonecutting" | "create:recipes/building_blocks/small_scoria_brick_stairs" | "ae2:recipes/misc/tools/paintballs_pink" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_flat_slashed_locometal" | "minecraft:recipes/decorations/red_candle" | "minecraft:story/upgrade_tools" | "create:recipes/building_blocks/cut_deepslate_brick_slab" | "expatternprovider:recipes/misc/fishbig" | "tconstruct:recipes/building_blocks/common/glass/black_clear_stained_glass" | "create:recipes/building_blocks/cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "createdeco:recipes/decorations/brown_placard" | "create:recipes/misc/crafting/logistics/magenta_table_cloth_clear" | "create:recipes/misc/crafting/kinetics/crafter_slot_cover" | "minecraft:recipes/misc/sentry_armor_trim_smithing_template_smithing_trim" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_pearl_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_copper_wrapped_locometal_boiler" | "create:arm_blaze_burner" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "ae2:recipes/misc/block_cutter/walls/chiseled_quartz_wall" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_tiled_dean_bricks_stonecutting" | "create:recipes/misc/smelting/silver_ingot_compat_thermal" | "minecraft:husbandry/tactical_fishing" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_light_gray" | "create:recipes/building_blocks/polished_cut_andesite_wall_from_stone_types_andesite_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_riveted_locometal" | "createdeco:recipes/building_blocks/short_dean_brick_slab" | "createdeco:recipes/building_blocks/corner_scarlet_brick_stairs_from_tiled_scarlet_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_a_brown" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_long_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_wall_from_short_scarlet_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_umber_brick_stairs" | "create:recipes/building_blocks/cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_da_yellow" | "create:recipes/building_blocks/small_calcite_bricks_from_stone_types_calcite_stonecutting" | "tconstruct:recipes/misc/common/slime/ender/crystal_smelting" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingle_stairs_from_honeycomb" | "minecraft:recipes/redstone/mangrove_trapdoor" | "create:recipes/building_blocks/oxidized_copper_shingle_stairs_from_oxidized_copper_shingles_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_wall_from_tiled_blue_bricks_stonecutting" | "sophisticatedbackpacks:recipes/misc/upgrade_base" | "chiselsandbits:chiselsandbits/make_tank" | "minecraft:recipes/redstone/oak_pressure_plate" | "tconstruct:recipes/tools/tools/building/sky_staff" | "ae2:recipes/misc/network/cells/item_storage_cell_64k_storage" | "create:recipes/building_blocks/crafting/logistics/pink_table_cloth" | "create:recipes/building_blocks/small_dripstone_brick_slab_from_stone_types_dripstone_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab" | "minecraft:recipes/building_blocks/polished_blackstone_stairs_from_polished_blackstone_stonecutting" | "create:recipes/misc/crafting/kinetics/schedule" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_plated_locometal" | "minecraft:recipes/redstone/dropper" | "tconstruct:recipes/building_blocks/common/slime/ichor/crystal_block" | "create:recipes/building_blocks/cut_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "ae2:recipes/misc/block_cutter/walls/quartz_brick_wall" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_blue" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_gray" | "createdeco:recipes/building_blocks/scarlet_brick_wall_from_corner_scarlet_brick_wall_stonecutting" | "ae2:recipes/misc/network/blocks/storage_drive" | "create:recipes/building_blocks/oxidized_copper_tile_slab" | "create:recipes/building_blocks/mangrove_window" | "create:recipes/building_blocks/warped_window_pane" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_slashed_locometal" | "create:recipes/building_blocks/cut_veridium_brick_slab" | "tconstruct:recipes/misc/common/materials/hepatizon_ingot_from_nuggets" | "minecraft:recipes/building_blocks/dye_light_blue_carpet" | "minecraft:recipes/building_blocks/purpur_block" | "createdeco:recipes/building_blocks/corner_blue_brick_wall_from_blue_brick_wall_stonecutting" | "create:recipes/building_blocks/small_andesite_brick_slab_recycling" | "railways:recipes/misc/crafting/palettes/wrapping/magenta_iron_wrapped_locometal" | "storagedrawers:recipes/storagedrawers/oak_trim" | "createdeco:recipes/decorations/zinc_bars" | "createdeco:recipes/building_blocks/short_pearl_brick_wall_from_corner_pearl_bricks_stonecutting" | "immersive_paintings:misc/graffiti" | "copycats:recipes/crafting/copycat_vertical_step" | "ae2:recipes/misc/shaped/stairs/quartz_bricks" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab_from_exposed_cut_copper_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_da_brown" | "createdeco:recipes/decorations/iron_hull_from_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/purple_copper_wrapped_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_light_blue" | "enderio:recipes/misc/travel_anchor" | "create:recipes/misc/crafting/appliances/cardboard_boots" | "minecraft:recipes/building_blocks/polished_granite" | "createdeco:recipes/building_blocks/cracked_red_bricks_from_bricks_smelting" | "minecraft:recipes/redstone/birch_trapdoor" | "storagedrawers:recipes/storagedrawers/emerald_storage_upgrade" | "createdeco:recipes/building_blocks/mossy_dusk_brick_wall" | "minecraft:recipes/redstone/spruce_trapdoor" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_white" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_yellow" | "minecraft:recipes/misc/quartz" | "create:recipes/building_blocks/crafting/kinetics/magenta_seat_from_other_seat" | "storagedrawers:recipes/storagedrawers/obsidian_storage_upgrade" | "create_connected:recipes/crafting/kinetics/item_vault_from_conversion" | "createdeco:recipes/building_blocks/dean_bricks_from_corner_dean_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_light_gray" | "minecraft:end/respawn_dragon" | "minecraft:recipes/decorations/soul_campfire" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_lime" | "create:recipes/building_blocks/cut_deepslate_slab" | "enderio:recipes/misc/nand_filter_from_and_filter" | "minecraft:recipes/food/cooked_mutton_from_campfire_cooking" | "create:recipes/misc/smelting/ingot_uranium_compat_immersiveengineering" | "createdeco:recipes/building_blocks/dean_brick_wall_from_long_dean_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_dripstone_slab" | "enderio:recipes/building_blocks/recolor_clear_glass_da_light_gray" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_road_slab_stonecutter" | "createdeco:recipes/building_blocks/scarlet_brick_wall_from_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_flat_slashed_locometal" | "createrailwaysnavigator:advanced_display" | "minecraft:recipes/building_blocks/crimson_hyphae" | "minecraft:recipes/building_blocks/dye_orange_wool" | "minecraft:recipes/building_blocks/yellow_concrete_powder" | "ae2:recipes/misc/network/cables/dense_smart_magenta" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_blue" | "create:recipes/building_blocks/crafting/logistics/lime_postbox_from_other_postbox" | "minecraft:recipes/building_blocks/purple_stained_glass" | "createdeco:recipes/building_blocks/corner_verdant_brick_slab_from_short_verdant_brick_slab_stonecutting" | "create_connected:recipes/crafting/kinetics/gearshift_from_conversion" | "createdeco:recipes/building_blocks/short_blue_bricks_from_corner_blue_bricks_stonecutting" | "ae2:recipes/misc/block_cutter/stairs/sky_stone_brick_stairs" | "createdeco:recipes/decorations/blue_shipping_container" | "create:recipes/building_blocks/crafting/kinetics/light_gray_seat_from_other_seat" | "create:recipes/building_blocks/cut_limestone_slab_recycling" | "minecraft:recipes/decorations/blue_carpet" | "minecraft:recipes/misc/snout_armor_trim_smithing_template_smithing_trim" | "enderio:recipes/building_blocks/recolor_clear_glass_m_orange" | "ae2:recipes/misc/network/cables/covered_cyan" | "ae2:recipes/misc/network/cables/glass_white" | "create:recipes/building_blocks/polished_cut_diorite_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_flat_riveted_locometal" | "tconstruct:recipes/building_blocks/common/glass/gray_clear_stained_glass" | "minecraft:recipes/building_blocks/polished_blackstone_from_blackstone_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_gray" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_red" | "expatternprovider:recipes/misc/wireless_connector" | "create:recipes/building_blocks/crafting/logistics/magenta_table_cloth_from_other_table_cloth" | "create:recipes/misc/crafting/curiosities/brown_toolbox" | "copycats:recipes/crafting/copycat_trapdoor_from_conversion" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_copper_wrapped_locometal" | "tconstruct:recipes/redstone/smeltery/scorched/drain" | "minecraft:recipes/decorations/polished_blackstone_wall_from_polished_blackstone_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_honeycomb" | "copycats:recipes/crafting/copycat_vertical_slice_from_conversion" | "minecraft:recipes/building_blocks/dripstone_block" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_tiled_pearl_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/light_gray_brass_wrapped_locometal" | "minecraft:adventure/avoid_vibration" | "create:recipes/building_blocks/polished_cut_diorite_slab_from_stone_types_diorite_stonecutting" | "railways:recipes/combat/dying_existing_cap_blue" | "enderio:place_capacitor_bank" | "createdeco:recipes/building_blocks/corner_blue_bricks_from_long_blue_bricks_stonecutting" | "ae2:recipes/misc/network/crafting/cpu_crafting_monitor" | "minecraft:recipes/decorations/acacia_fence" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_corner_pearl_brick_slab_stonecutting" | "create:recipes/building_blocks/polished_cut_deepslate_from_stone_types_deepslate_stonecutting" | "create:recipes/combat/crafting/appliances/netherite_diving_helmet" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_long_blue_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/scarlet_brick_slab" | "minecraft:recipes/misc/iron_ingot_from_blasting_deepslate_iron_ore" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_long_dusk_bricks_stonecutting" | "minecraft:recipes/building_blocks/dye_brown_carpet" | "create:recipes/building_blocks/small_limestone_brick_slab_recycling" | "minecraft:nether/return_to_sender" | "minecraft:recipes/building_blocks/sandstone" | "createdeco:recipes/building_blocks/corner_umber_brick_stairs_from_tiled_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_plated_locometal" | "createdeco:recipes/building_blocks/long_dusk_brick_wall_from_tiled_dusk_bricks_stonecutting" | "createdeco:recipes/decorations/zinc_bars_overlay" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_locometal_smokebox" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_long_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_verdant_bricks_from_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_scarlet_bricks_from_scarlet_bricks_stonecutting" | "create_connected:control_chip" | "create:recipes/building_blocks/polished_cut_diorite_slab_recycling" | "ae2:recipes/misc/shaped/stairs/sky_stone_small_brick" | "railways:recipes/combat/dying_existing_cap_lime" | "createdeco:recipes/decorations/zinc_catwalk_stairs" | "enderio:recipes/redstone/resetting_lever_three_hundred_inv_from_base" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_short_dusk_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/mossy_blue_brick_slab_from_mossy_blue_bricks_stonecutting" | "minecraft:recipes/decorations/brown_stained_glass_pane_from_glass_pane" | "minecraft:husbandry/obtain_sniffer_egg" | "createdeco:recipes/decorations/brass_coinstack" | "tconstruct:recipes/redstone/world/wood/skyroot/trapdoor" | "minecraft:recipes/decorations/brick_wall_from_bricks_stonecutting" | "ae2:recipes/misc/block_cutter/walls/sky_stone_wall" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab_from_exposed_copper_stonecutting" | "ae2:recipes/misc/shaped/walls/fluix_block" | "ae2:recipes/misc/network/cells/item_storage_components_cell_4k_part" | "create:recipes/building_blocks/crafting/logistics/brown_table_cloth" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_pearl_brick_wall_from_pearl_brick_wall_stonecutting" | "storagedrawers:recipes/storagedrawers/iron_storage_upgrade" | "createdeco:recipes/building_blocks/mossy_red_brick_stairs_from_mossy_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_brick_wall_from_umber_bricks_stonecutting" | "minecraft:recipes/food/cooked_cod_from_campfire_cooking" | "enderio:recipes/building_blocks/recolor_clear_glass_e_brown" | "createdeco:recipes/building_blocks/short_blue_bricks_from_blue_bricks_stonecutting" | "ae2:recipes/misc/materials/cardcapacity" | "createdeco:recipes/building_blocks/short_verdant_bricks_from_tiled_verdant_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_copper_wrapped_locometal" | "createdeco:recipes/decorations/blue_andesite_lamp" | "minecraft:recipes/misc/pink_dye_from_red_white_dye" | "create:recipes/building_blocks/small_veridium_brick_slab_from_stone_types_veridium_stonecutting" | "minecraft:recipes/redstone/jungle_pressure_plate" | "create:recipes/misc/crafting/kinetics/clockwork_bearing" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_slashed_locometal" | "createdeco:recipes/building_blocks/long_pearl_brick_wall_from_tiled_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/dean_brick_slab" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_short_umber_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/corner_scarlet_brick_wall_from_corner_scarlet_bricks_stonecutting" | "minecraft:recipes/misc/diamond_from_blasting_diamond_ore" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_polished_blackstone_stonecutting" | "create:recipes/building_blocks/dripstone_pillar_from_stone_types_dripstone_stonecutting" | "create:recipes/misc/blasting/ingot_nickel_compat_immersiveengineering" | "enderio:recipes/misc/pulsating_alloy_nugget" | "minecraft:recipes/building_blocks/polished_diorite_slab_from_polished_diorite_stonecutting" | "enderio:recipes/misc/conduit_binder_composite" | "railways:recipes/misc/stonecutting/palettes/cycling/white_flat_slashed_locometal" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab" | "minecraft:recipes/decorations/blackstone_wall_from_blackstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_brass_wrapped_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_purple" | "create:recipes/building_blocks/cut_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "ae2:recipes/misc/network/parts/formation_plane" | "create:copper_casing" | "ae2:recipes/misc/network/cables/smart_yellow" | "create:recipes/building_blocks/crafting/logistics/pink_postbox" | "enchantinginfuser:recipes/decorations/enchanting_infuser" | "minecraft:recipes/building_blocks/amethyst_block" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_corner_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_scarlet_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_riveted_locometal" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_short_scarlet_bricks_stonecutting" | "minecraft:husbandry/obtain_netherite_hoe" | "minecraft:recipes/decorations/light_gray_banner" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_corner_verdant_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_locometal_smokebox" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_flat_riveted_locometal" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_stone_smelting" | "minecraft:recipes/tools/iron_axe" | "create:recipes/misc/crafting/logistics/packager" | "minecraft:recipes/building_blocks/sea_lantern" | "ae2:main/p2p" | "create:recipes/building_blocks/crafting/logistics/black_postbox" | "create:recipes/misc/crafting/appliances/item_frame" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_red" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_yellow" | "createdeco:recipes/building_blocks/tiled_dean_brick_wall_from_corner_dean_brick_wall_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_iron_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_corner_scarlet_brick_slab_stonecutting" | "create:recipes/misc/crafting/curiosities/peculiar_bell" | "create:recipes/misc/crafting/logistics/item_hatch" | "createdeco:recipes/building_blocks/copper_window" | "create:recipes/building_blocks/polished_cut_diorite_slab" | "expatternprovider:recipes/misc/ex_io_port" | "create:recipes/misc/blasting/zinc_ingot_from_crushed" | "createdeco:recipes/building_blocks/corner_umber_brick_wall_from_corner_umber_bricks_stonecutting" | "create:recipes/building_blocks/small_limestone_brick_wall" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_corner_verdant_brick_stairs_stonecutting" | "minecraft:recipes/building_blocks/deepslate_tile_slab" | "minecraft:recipes/building_blocks/polished_diorite_from_diorite_stonecutting" | "create:recipes/building_blocks/small_calcite_brick_wall" | "tconstruct:recipes/building_blocks/common/glass/purple_clear_stained_glass" | "minecraft:recipes/building_blocks/nether_brick_slab_from_nether_bricks_stonecutting" | "railways:recipes/misc/crafting/small_buffer" | "minecraft:adventure/kill_a_mob" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_slashed_locometal" | "create:pipe_organ" | "sophisticatedbackpacks:recipes/misc/gold_backpack" | "createdeco:recipes/decorations/copper_door" | "enderio:recipes/building_blocks/recolor_clear_glass_a_light_gray" | "create:recipes/building_blocks/crafting/kinetics/brown_seat_from_other_seat" | "enderio:recipes/building_blocks/silent_dark_oak_pressure_plate" | "minecraft:recipes/building_blocks/deepslate_bricks_from_cobbled_deepslate_stonecutting" | "tconstruct:recipes/building_blocks/world/wood/enderbark/planks" | "create:recipes/building_blocks/polished_cut_asurine_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_copper_wrapped_locometal" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_stairs" | "createdeco:recipes/building_blocks/corner_pearl_brick_slab_from_pearl_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_dripstone_brick_slab" | "create:recipes/building_blocks/cut_deepslate_bricks_from_stone_types_deepslate_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_umber_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_yellow" | "extra_gauges:recipes/redstone/comparator_gauge" | "createdeco:recipes/building_blocks/tiled_verdant_brick_wall_from_tiled_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_bricks_from_corner_scarlet_bricks_stonecutting" | "minecraft:recipes/building_blocks/polished_andesite_slab_from_polished_andesite_stonecutting" | "createdeco:recipes/decorations/andesite_catwalk_stairs_from_stonecutting" | "createdeco:recipes/building_blocks/tiled_dusk_brick_wall_from_long_dusk_bricks_stonecutting" | "enderio:recipes/misc/vacuum_chest" | "minecraft:recipes/misc/raw_iron" | "create:recipes/building_blocks/cut_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs" | "create:recipes/building_blocks/cut_scoria_brick_slab" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_short_pearl_bricks_stonecutting" | "create_connected:overstress_clutch" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_orange" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_cyan" | "minecraft:recipes/misc/stick_from_bamboo_item" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper" | "create:recipes/misc/crafting/logistics/stock_ticker" | "minecraft:recipes/redstone/bamboo_fence_gate" | "createdeco:recipes/building_blocks/corner_dusk_brick_stairs_from_long_dusk_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_long_dean_brick_slab_stonecutting" | "create:fan_processing" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_cyan" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_copper_wrapped_locometal_boiler" | "create:water_supply" | "expatternprovider:recipes/misc/active_formation_plane" | "ae2:recipes/misc/tools/paintballs_white" | "createdeco:recipes/building_blocks/mossy_blue_bricks_from_moss_block" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_red" | "minecraft:recipes/misc/light_gray_dye_from_black_white_dye" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_waxed_copper_block_stonecutting" | "enderio:recipes/misc/energized_gear" | "createdeco:recipes/building_blocks/pearl_brick_wall_from_short_pearl_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_short_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_corner_blue_bricks_stonecutting" | "create:recipes/building_blocks/small_veridium_brick_wall" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_red" | "sophisticatedbackpacks:recipes/misc/auto_smoking_upgrade_from_auto_smelting_upgrade" | "create:recipes/building_blocks/layered_veridium_from_stone_types_veridium_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_wall_from_tiled_pearl_brick_wall_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_pink" | "create:recipes/misc/crafting/logistics/copper_table_cloth_clear" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_gray" | "create:recipes/building_blocks/polished_cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "create:recipes/building_blocks/warped_window" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_locometal_smokebox" | "create:recipes/misc/crafting/kinetics/adjustable_chain_gearshift" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_glass" | "minecraft:recipes/food/rabbit_stew_from_red_mushroom" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_tiled_dusk_bricks_stonecutting" | "railways:recipes/transportation/jukeboxcart" | "minecraft:recipes/tools/golden_hoe" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_red" | "copycats:recipes/crafting/copycat_wooden_pressure_plate" | "createdeco:recipes/building_blocks/long_dean_brick_stairs" | "createdeco:recipes/building_blocks/mossy_verdant_brick_stairs_from_mossy_verdant_bricks_stonecutting" | "create:recipes/misc/smelting/glass_from_horizontal_framed_glass" | "create:recipes/building_blocks/polished_cut_deepslate_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_plated_locometal" | "tconstruct:recipes/building_blocks/common/glass/yellow_clear_stained_glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_copper_wrapped_locometal_boiler" | "ae2:recipes/misc/network/crafting/cpu_crafting_accelerator" | "createdeco:recipes/building_blocks/long_pearl_brick_wall_from_tiled_pearl_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_wall_from_umber_bricks_stonecutting" | "create_connected:pulse_generator_infinite_loop" | "create:recipes/misc/blasting/ingot_lead_compat_mekanism" | "minecraft:recipes/building_blocks/cut_copper_slab_from_copper_block_stonecutting" | "ae2:recipes/misc/shaped/not_so_mysterious_cube" | "minecraft:recipes/food/mushroom_stew" | "create:factory_gauge" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_long_blue_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_light_blue" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab" | "create:recipes/misc/blasting/zinc_ingot_from_ore" | "ae2:recipes/misc/network/parts/level_emitter" | "minecraft:husbandry/balanced_diet" | "minecraft:recipes/building_blocks/gray_terracotta" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_gray" | "minecraft:recipes/food/cooked_cod" | "ae2:recipes/misc/network/parts/toggle_bus_alt" | "minecraft:recipes/building_blocks/bamboo_stairs" | "ae2:recipes/misc/network/cables/dense_covered_light_blue" | "copycats:recipes/crafting/copycat_cogwheel" | "minecraft:recipes/building_blocks/dye_yellow_bed" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_yellow" | "create:recipes/misc/crafting/materials/zinc_nugget_from_decompacting" | "sophisticatedbackpacks:recipes/misc/auto_blasting_upgrade_from_auto_smelting_upgrade" | "minecraft:recipes/building_blocks/bamboo_block" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_blue" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_short_verdant_bricks_stonecutting" | "minecraft:recipes/building_blocks/dye_gray_wool" | "createdeco:recipes/building_blocks/corner_dean_brick_stairs_from_dean_bricks_stonecutting" | "create:recipes/misc/crafting/logistics/stock_link_clear" | "createdeco:recipes/decorations/andesite_bars_overlay_from_stonecutting" | "expatternprovider:recipes/misc/ebus_in" | "minecraft:recipes/decorations/mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting" | "storagedrawers:recipes/storagedrawers/controller_slave" | "createdeco:recipes/building_blocks/corner_dean_brick_slab_from_short_dean_bricks_stonecutting" | "minecraft:recipes/decorations/black_stained_glass_pane" | "createdeco:recipes/building_blocks/short_umber_brick_wall_from_short_umber_bricks_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tile_slab_from_honeycomb" | "create:recipes/building_blocks/crafting/logistics/red_postbox" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_long_dusk_brick_slab_stonecutting" | "tconstruct:recipes/decorations/smeltery/scorched/scorched_soul_glass_pane" | "createdeco:recipes/building_blocks/dusk_brick_wall_from_long_dusk_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_plated_locometal" | "create:recipes/building_blocks/small_scoria_bricks_from_stone_types_scoria_stonecutting" | "minecraft:recipes/building_blocks/dye_gray_bed" | "ae2:recipes/misc/shaped/stairs/smooth_sky_stone_block" | "enderio:recipes/building_blocks/soul_chain" | "createdeco:recipes/building_blocks/short_red_brick_wall_from_tiled_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_short_verdant_bricks_stonecutting" | "enderio:recipes/misc/extraction_speed_upgrade_1_upgrade" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_corner_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_short_dusk_brick_stairs_stonecutting" | "tconstruct:recipes/tools/tools/building/flint_and_brick" | "create:recipes/misc/crafting/materials/rose_quartz" | "createdeco:recipes/decorations/light_blue_placard" | "create:train_casing_00" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs_from_weathered_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_slab_from_tiled_umber_brick_slab_stonecutting" | "minecraft:recipes/food/dried_kelp" | "minecraft:nether/use_lodestone" | "expatternprovider:recipes/misc/epp_part" | "create:recipes/building_blocks/cut_calcite_slab_recycling" | "sophisticatedbackpacks:recipes/misc/tank_upgrade" | "minecraft:recipes/building_blocks/mangrove_slab" | "tconstruct:smeltery/sand_casting" | "tconstruct:recipes/building_blocks/smeltery/scorched/nether_grout" | "createdeco:recipes/building_blocks/corner_pearl_brick_stairs" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_verdant_bricks_stonecutting" | "minecraft:recipes/building_blocks/red_sandstone_stairs_from_red_sandstone_stonecutting" | "ae2:recipes/misc/shaped/walls/cut_quartz_block" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_flat_slashed_locometal" | "tconstruct:recipes/misc/common/flint" | "create:recipes/building_blocks/layered_deepslate_from_stone_types_deepslate_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_short_scarlet_brick_slab_stonecutting" | "minecraft:recipes/decorations/anvil" | "enderio:recipes/misc/xp_vacuum" | "createdeco:recipes/decorations/iron_catwalk_railing_forge" | "ae2:recipes/misc/tools/paintballs_lumen_red" | "enderio:recipes/building_blocks/recolor_clear_glass_m_gray" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_from_honeycomb" | "create:recipes/misc/crafting/materials/raw_zinc_block" | "create:recipes/building_blocks/exposed_copper_shingle_stairs" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_blue_bricks_stonecutting" | "tconstruct:smeltery/mighty_smelting" | "create:cardboard_armor" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_locometal_smokebox" | "createdeco:recipes/building_blocks/tiled_red_brick_slab_from_bricks_stonecutting" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_polished_deepslate_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_wall_from_long_scarlet_bricks_stonecutting" | "createdeco:recipes/decorations/brass_catwalk_from_stonecutting" | "createdeco:recipes/building_blocks/corner_dean_brick_slab_from_tiled_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/cracked_umber_bricks_from_umber_bricks_blasting" | "ae2:recipes/misc/materials/cardfuzzy" | "minecraft:recipes/building_blocks/end_stone_bricks_from_end_stone_stonecutting" | "create:recipes/misc/crafting/appliances/filter_clear" | "tconstruct:tools/tinker_station" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_yellow" | "createdeco:recipes/building_blocks/short_dean_brick_wall_from_corner_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_corner_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_short_dusk_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_calcite_stairs" | "createdeco:recipes/decorations/andesite_facade_from_stonecutting" | "tconstruct:recipes/building_blocks/common/firewood/blazewood_slab" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_gray" | "createdeco:recipes/decorations/industrial_iron_catwalk_railing_forge" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_short_umber_brick_stairs_stonecutting" | "create:table_cloth_shop" | "minecraft:recipes/building_blocks/diorite_stairs" | "createdeco:recipes/building_blocks/umber_brick_slab_from_short_umber_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/green_terracotta" | "createdeco:recipes/decorations/iron_coin" | "create:recipes/building_blocks/crafting/logistics/lime_table_cloth_from_other_table_cloth" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_corner_pearl_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_brass_wrapped_locometal" | "create:recipes/building_blocks/small_granite_brick_slab" | "ae2:recipes/misc/network/cells/fluid_storage_cell_16k_storage" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_short_dusk_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/corner_red_brick_slab_from_short_red_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/corner_verdant_brick_wall_from_tiled_verdant_bricks_stonecutting" | "ae2:main/controller" | "createdeco:recipes/decorations/zinc_trapdoor" | "createdeco:recipes/building_blocks/short_umber_brick_wall_from_tiled_umber_brick_wall_stonecutting" | "create:recipes/building_blocks/small_crimsite_brick_slab" | "minecraft:recipes/building_blocks/mossy_stone_bricks_from_moss_block" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_locometal_smokebox" | "enderio:recipes/building_blocks/recolor_clear_glass_da_magenta" | "copycats:recipes/crafting/copycat_fluid_pipe" | "minecraft:recipes/misc/skull_banner_pattern" | "copycats:recipes/crafting/copycat_slope_layer" | "tconstruct:recipes/misc/common/slime/earth/slimeball_from_congealed" | "minecraft:recipes/brewing/brewing_stand" | "minecraft:recipes/root" | "enderio:recipes/redstone/resetting_lever_three_hundred_from_inv" | "railways:recipes/transportation/conductor_vent_from_industrial_iron_block_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/quartz_from_blasting" | "createdeco:recipes/decorations/lime_shipping_container_from_dyeing_vaults" | "minecraft:recipes/building_blocks/acacia_planks" | "create:recipes/building_blocks/industrial_iron_block_from_ingots_iron_stonecutting" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_short_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/cracked_blue_brick_stairs_from_cracked_blue_bricks_stonecutting" | "expatternprovider:recipes/misc/ex_drive" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_short_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_short_dusk_bricks_stonecutting" | "ae2:recipes/misc/shaped/slabs/quartz_pillar" | "createdeco:recipes/building_blocks/zinc_window" | "createdeco:recipes/decorations/locked_copper_door" | "minecraft:recipes/redstone/iron_door" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_wall" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_locometal_boiler" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_cyan" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_lime" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_slashed_locometal" | "minecraft:recipes/building_blocks/blackstone_stairs_from_blackstone_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_long_blue_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_long_pearl_brick_stairs_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_light_blue" | "create:recipes/building_blocks/cut_asurine_slab_recycling" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_red" | "createdeco:recipes/building_blocks/corner_scarlet_brick_wall_from_short_scarlet_bricks_stonecutting" | "minecraft:recipes/transportation/dark_oak_boat" | "create:recipes/building_blocks/cut_asurine_brick_wall" | "createdeco:recipes/building_blocks/long_pearl_brick_wall_from_short_pearl_brick_wall_stonecutting" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs" | "minecraft:recipes/misc/mojang_banner_pattern" | "minecraft:recipes/redstone/piston" | "createdeco:recipes/building_blocks/corner_dusk_brick_stairs_from_dusk_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_flat_slashed_locometal" | "sophisticatedbackpacks:recipes/misc/advanced_pickup_upgrade" | "enderio:recipes/building_blocks/recolor_clear_glass_em_yellow" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_lime" | "sophisticatedbackpacks:recipes/misc/iron_backpack" | "createdeco:recipes/building_blocks/short_red_brick_slab_from_bricks_stonecutting" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_polished_blackstone_stonecutting" | "tconstruct:recipes/redstone/smeltery/scorched/faucet" | "tconstruct:recipes/building_blocks/world/wood/skyroot/stairs" | "ae2:recipes/misc/tools/paintballs_green" | "tconstruct:recipes/misc/common/slime/sky/slimeball_from_congealed" | "create:recipes/building_blocks/vertical_framed_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_brass_wrapped_locometal_boiler" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_purple" | "minecraft:recipes/decorations/light_gray_stained_glass_pane" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs_from_weathered_copper_stonecutting" | "createdeco:recipes/building_blocks/corner_umber_brick_slab_from_umber_bricks_stonecutting" | "minecraft:recipes/redstone/acacia_button" | "tconstruct:recipes/decorations/smeltery/scorched/scorched_glass_pane" | "ae2:recipes/misc/tools/paintballs_lumen_blue" | "tconstruct:recipes/building_blocks/smeltery/scorched/nether_grout_multiple" | "minecraft:recipes/building_blocks/stone_bricks" | "createdeco:recipes/building_blocks/umber_brick_slab_from_long_umber_brick_slab_stonecutting" | "create:recipes/misc/crafting/logistics/black_table_cloth_clear" | "enderio:recipes/building_blocks/silent_spruce_pressure_plate" | "create:recipes/building_blocks/cut_scorchia_brick_slab_from_stone_types_scorchia_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_a_purple" | "create:recipes/misc/crafting/logistics/redstone_requester_clear" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_corner_dusk_brick_stairs_stonecutting" | "minecraft:recipes/decorations/blast_furnace" | "minecraft:recipes/decorations/red_nether_brick_wall" | "railways:recipes/combat/dying_existing_cap_light_gray" | "create:recipes/misc/crafting/kinetics/mechanical_saw" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_umber_brick_stairs_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_brown" | "tconstruct:recipes/misc/common/slime/ender/slimeball_from_block" | "tconstruct:recipes/decorations/common/glass/pink_clear_stained_glass_pane_from_panes" | "tconstruct:recipes/misc/common/slime/sky/crystal_smelting" | "createdeco:recipes/building_blocks/corner_dusk_brick_wall_from_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_long_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_tiled_blue_brick_slab_stonecutting" | "create:recipes/building_blocks/birch_window" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_corner_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_verdant_brick_wall_from_corner_verdant_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_em_orange" | "tconstruct:recipes/misc/common/materials/queens_slime_block_from_ingots" | "ae2:recipes/misc/decorative/smooth_quartz_block" | "railways:recipes/misc/crafting/palettes/wrapping/orange_iron_wrapped_locometal" | "minecraft:recipes/decorations/brown_banner" | "enderio:recipes/redstone/resetting_lever_thirty_from_inv" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_from_brick" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_flat_riveted_locometal" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_ending_dragons_breath" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_triangle_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/rotation_speed_controller" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_pearl_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_long_scarlet_bricks_stonecutting" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_cobbled_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/mangrove_planks" | "ae2:recipes/misc/network/cables/glass_blue" | "create:recipes/building_blocks/small_veridium_brick_slab" | "ae2:recipes/misc/network/parts/annihilation_plane_alt2" | "minecraft:recipes/misc/lapis_lazuli_from_smelting_deepslate_lapis_ore" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_corner_pearl_bricks_stonecutting" | "enderio:recipes/building_blocks/invert_clear_glass_ea" | "createdeco:recipes/decorations/yellow_industrial_iron_lamp" | "minecraft:recipes/building_blocks/brick_stairs" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_red" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_brass_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/umber_bricks_from_corner_umber_bricks_stonecutting" | "create_connected:recipes/crafting/kinetics/freewheel_clutch" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_copper_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/corner_umber_brick_slab_from_long_umber_bricks_stonecutting" | "enderio:recipes/building_blocks/invert_clear_glass_ep" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "enderio:recipes/building_blocks/invert_clear_glass_em" | "minecraft:recipes/misc/eye_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "createdeco:recipes/building_blocks/tiled_red_brick_wall_from_long_red_bricks_stonecutting" | "minecraft:recipes/decorations/lime_stained_glass_pane_from_glass_pane" | "enderio:recipes/tools/electromagnet" | "enderio:recipes/misc/redstone_not_filter" | "tconstruct:recipes/decorations/smeltery/scorched/basin" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_copper_wrapped_locometal" | "create:recipes/combat/crafting/appliances/netherite_diving_boots" | "createdeco:recipes/decorations/pink_shipping_container_from_dyeing_vaults" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_copper_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_dean_brick_slab_stonecutting" | "create:recipes/building_blocks/small_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_cyan" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_locometal_smokebox" | "ae2:recipes/misc/network/cells/spatial_components" | "enderio:recipes/building_blocks/recolor_fused_quartz_red" | "create:recipes/building_blocks/cut_tuff_brick_wall" | "tconstruct:foundry/plate_armor" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tiles_from_honeycomb" | "create:recipes/building_blocks/crafting/logistics/brown_postbox" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_tiled_pearl_brick_slab_stonecutting" | "enderio:recipes/building_blocks/dark_steel_bars" | "tconstruct:world/blood_island" | "tconstruct:recipes/food/gadgets/cake/earth" | "railways:recipes/misc/stonecutting/palettes/cycling/locometal_smokebox" | "railways:recipes/misc/stonecutting/palettes/cycling/slashed_locometal" | "create:recipes/building_blocks/crafting/logistics/lime_table_cloth" | "enderio:recipes/building_blocks/recolor_clear_glass_np_orange" | "minecraft:recipes/decorations/fletching_table" | "minecraft:recipes/decorations/brown_bed" | "minecraft:recipes/food/cooked_mutton_from_smoking" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_locometal_boiler" | "minecraft:recipes/building_blocks/polished_diorite_stairs" | "enderio:recipes/building_blocks/invert_clear_glass_da" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_enriched" | "minecraft:recipes/building_blocks/dye_brown_bed" | "ae2:main/facade" | "createdeco:recipes/building_blocks/corner_dean_brick_slab_from_dean_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_light_blue" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_stairs_stonecutter" | "enderio:recipes/misc/redstone_toggle_filter" | "createdeco:recipes/building_blocks/tiled_blue_brick_wall" | "minecraft:recipes/misc/gold_ingot_from_gold_block" | "ae2:recipes/misc/network/cables/glass_lime" | "tconstruct:recipes/decorations/common/glass/magenta_clear_stained_glass_pane_from_panes" | "enderio:recipes/building_blocks/invert_clear_glass_dp" | "enderio:recipes/misc/dark_steel_nugget_to_ingot" | "enderio:recipes/building_blocks/invert_clear_glass_dm" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_locometal_smokebox" | "create:recipes/misc/crafting/kinetics/portable_fluid_interface" | "create:recipes/misc/crafting/kinetics/wrench" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_light_gray" | "create:recipes/misc/crafting/kinetics/rose_quartz_lamp" | "create:recipes/misc/crafting/kinetics/steam_whistle" | "minecraft:recipes/decorations/purple_bed" | "tconstruct:recipes/decorations/tables/scorched_forge" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_tiled_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_slashed_locometal" | "create:recipes/building_blocks/crafting/kinetics/pink_seat_from_other_seat" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_tiled_pearl_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_blue" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_black" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_plated_locometal" | "create:recipes/building_blocks/oxidized_copper_shingle_slab_from_oxidized_copper_shingles_stonecutting" | "enderio:recipes/building_blocks/silent_crimson_pressure_plate" | "createdeco:recipes/decorations/red_industrial_iron_lamp" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_corner_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/quartz_slab" | "railways:recipes/misc/crafting/semaphore" | "enderio:recipes/redstone/resetting_lever_thirty" | "ae2:recipes/misc/tools/certus_quartz_pickaxe" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_corner_pearl_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_p_cyan" | "createdeco:recipes/building_blocks/long_dusk_bricks_from_short_dusk_bricks_stonecutting" | "create:sturdy_sheet" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_corner_blue_brick_stairs_stonecutting" | "minecraft:recipes/tools/golden_axe" | "expatternprovider:recipes/misc/ingredient_buffer" | "minecraft:husbandry/leash_all_frog_variants" | "create:recipes/misc/crafting/logistics/green_table_cloth_clear" | "createdeco:recipes/building_blocks/long_dusk_brick_wall_from_dusk_brick_wall_stonecutting" | "create:recipes/building_blocks/cut_limestone_slab_from_stone_types_limestone_stonecutting" | "create:recipes/building_blocks/cut_andesite_brick_slab" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_white" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_blue_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_deepslate_bricks_stonecutting" | "minecraft:recipes/decorations/orange_banner" | "createdeco:recipes/decorations/black_placard" | "ae2:recipes/misc/misc/deconstruction_certus_quartz_bricks" | "minecraft:recipes/decorations/oak_sign" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_green" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_purple" | "minecraft:recipes/building_blocks/red_concrete_powder" | "createdeco:recipes/building_blocks/umber_bricks_from_short_umber_bricks_stonecutting" | "ae2:recipes/misc/blasting/silicon_from_certus_quartz_dust" | "expatternprovider:recipes/misc/caner" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_short_dean_brick_slab_stonecutting" | "minecraft:recipes/tools/golden_pickaxe" | "tconstruct:recipes/decorations/smeltery/seared/table" | "expatternprovider:recipes/misc/ex_molecular_assembler" | "enderio:recipes/building_blocks/recolor_clear_glass_p_light_gray" | "create:recipes/building_blocks/crafting/logistics/green_table_cloth" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_light_gray" | "createdeco:recipes/building_blocks/dean_bricks_from_tiled_dean_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_plated_locometal" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_corner_dusk_bricks_stonecutting" | "minecraft:recipes/building_blocks/polished_deepslate_slab" | "create:recipes/misc/crafting/appliances/copper_backtank" | "createdeco:recipes/building_blocks/corner_dean_brick_slab_from_long_dean_bricks_stonecutting" | "ae2:recipes/misc/block_cutter/slabs/sky_stone_brick_slab" | "railways:recipes/combat/dying_existing_cap_cyan" | "railways:recipes/misc/crafting/palettes/wrapping/gray_copper_wrapped_locometal" | "minecraft:recipes/building_blocks/quartz_bricks" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_white" | "createdeco:recipes/building_blocks/long_umber_bricks_from_corner_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/corner_red_brick_slab_from_long_red_brick_slab_stonecutting" | "minecraft:end/dragon_egg" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_ladder" | "ae2:recipes/misc/decorative/light_detector" | "createdeco:recipes/building_blocks/corner_red_brick_slab_from_tiled_red_bricks_stonecutting" | "minecraft:recipes/building_blocks/lapis_block" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_short_scarlet_brick_stairs_stonecutting" | "create:recipes/building_blocks/polished_cut_calcite_slab" | "tconstruct:recipes/food/gadgets/cake/sky" | "createdeco:recipes/building_blocks/dean_brick_slab_from_long_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_corner_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/mossy_blue_brick_stairs" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_long_scarlet_bricks_stonecutting" | "minecraft:recipes/food/cooked_cod_from_smoking" | "railways:recipes/misc/stonecutting/palettes/cycling/black_plated_locometal" | "createdeco:recipes/building_blocks/corner_umber_brick_stairs_from_corner_umber_bricks_stonecutting" | "tconstruct:recipes/misc/common/tinkers_gadgetry" | "ae2:recipes/misc/tools/paintballs_orange" | "create:recipes/building_blocks/cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_lime" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_light_blue" | "minecraft:recipes/building_blocks/prismarine" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_iron_wrapped_locometal_boiler" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_cyan" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_orange" | "enderio:recipes/misc/dark_bimetal_gear" | "minecraft:recipes/misc/brown_dye" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_short_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_pearl_brick_stairs_from_pearl_brick_stairs_stonecutting" | "tconstruct:foundry/fantastic_foundry" | "create:recipes/building_blocks/cut_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_long_verdant_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/long_dusk_brick_wall_from_short_dusk_bricks_stonecutting" | "ae2:recipes/misc/network/cables/glass_brown" | "ae2:recipes/misc/network/wireless_terminal" | "create:recipes/building_blocks/exposed_copper_tile_slab" | "copycats:recipes/crafting/copycat_vertical_slope" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_light_blue" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs_from_tiled_red_bricks_stonecutting" | "create:recipes/building_blocks/cut_andesite_slab_from_stone_types_andesite_stonecutting" | "ae2wtlib:recipes/magnet_card" | "enderio:recipes/misc/xor_filter_from_xnor_filter" | "create:recipes/building_blocks/small_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_blue" | "storagedrawers:recipes/storagedrawers/compacting_drawers" | "create:recipes/building_blocks/cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "create:extendo_grip" | "create:recipes/building_blocks/cut_scoria_brick_stairs" | "create:recipes/building_blocks/polished_cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "create:recipes/building_blocks/cut_diorite_slab_from_stone_types_diorite_stonecutting" | "minecraft:recipes/misc/white_dye" | "createdeco:recipes/building_blocks/short_verdant_brick_wall_from_corner_verdant_brick_wall_stonecutting" | "create:recipes/building_blocks/crafting/logistics/magenta_postbox" | "enderio:recipes/building_blocks/recolor_clear_glass_da_gray" | "create:recipes/building_blocks/cut_scoria_brick_wall" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_riveted_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_blue" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_flat_slashed_locometal" | "enderio:recipes/misc/redstone_and_filter" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_flat_slashed_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_m_red" | "tconstruct:recipes/building_blocks/world/wood/enderbark/stairs" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_pink" | "create:recipes/building_blocks/small_deepslate_brick_slab" | "create:recipes/building_blocks/polished_cut_veridium_slab" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_blue_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_lime" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_green" | "ae2:recipes/misc/tools/paintballs_lumen_white" | "create:recipes/misc/crafting/appliances/chain_from_zinc" | "createdeco:recipes/building_blocks/pearl_brick_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/red_slashed_locometal" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_long_umber_brick_stairs_stonecutting" | "create:recipes/building_blocks/cut_veridium_brick_wall" | "createdeco:recipes/building_blocks/tiled_dean_brick_wall_from_tiled_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_red_brick_slab_from_corner_red_brick_slab_stonecutting" | "create:recipes/building_blocks/small_scoria_brick_slab" | "createdeco:recipes/building_blocks/tiled_pearl_brick_wall" | "createdeco:recipes/decorations/red_shipping_container_from_dyeing_vaults" | "createdeco:recipes/building_blocks/dusk_bricks_from_tiled_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_dusk_bricks_from_corner_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_short_dean_bricks_stonecutting" | "ae2:recipes/misc/shaped/stairs/sky_stone_block" | "enderio:recipes/building_blocks/recolor_clear_glass_em_blue" | "createdeco:recipes/building_blocks/corner_dean_bricks_from_dean_bricks_stonecutting" | "minecraft:recipes/combat/diamond_chestplate" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_umber_bricks_stonecutting" | "tconstruct:recipes/misc/common/materials_and_you" | "minecraft:story/mine_stone" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_flat_riveted_locometal" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_waxed_oxidized_cut_copper_stonecutting" | "minecraft:recipes/decorations/furnace" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_brass_wrapped_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_white" | "createdeco:recipes/building_blocks/cracked_dusk_bricks_from_dusk_bricks_blasting" | "minecraft:recipes/building_blocks/andesite_stairs" | "createdeco:recipes/decorations/copper_bars" | "create:recipes/misc/crafting/kinetics/mechanical_arm" | "minecraft:recipes/redstone/redstone_torch" | "railways:recipes/misc/crafting/palettes/wrapping/orange_brass_wrapped_locometal" | "createdeco:recipes/decorations/cyan_placard_from_dyeing" | "minecraft:recipes/misc/gold_ingot_from_blasting_raw_gold" | "minecraft:recipes/building_blocks/green_concrete_powder" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_lime" | "create:recipes/building_blocks/cut_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "create:recipes/misc/blasting/nickel_ingot_compat_thermal" | "create:recipes/misc/blasting/copper_ingot_from_crushed" | "tconstruct:recipes/decorations/world/wood/bloodshroom/hanging_sign" | "railways:recipes/misc/crafting/palettes/wrapping/lime_iron_wrapped_locometal" | "createdeco:recipes/building_blocks/corner_verdant_brick_wall_from_long_verdant_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/super_glue" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_magenta" | "railways:recipes/misc/crafting/palettes/wrapping/lime_brass_wrapped_locometal" | "createdeco:recipes/building_blocks/cracked_scarlet_brick_wall_from_cracked_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_dean_brick_slab_stonecutting" | "createdeco:recipes/decorations/industrial_iron_bars_overlay_from_stonecutting" | "create:recipes/building_blocks/cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "enderio:recipes/building_blocks/dark_steel_trapdoor" | "enderio:recipes/building_blocks/recolor_clear_glass_na_gray" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_pearl_brick_slab_stonecutting" | "tconstruct:recipes/decorations/common/glass/blue_clear_stained_glass_pane_from_panes" | "create:recipes/building_blocks/exposed_copper_shingle_slab" | "enderio:recipes/building_blocks/recolor_clear_glass_e_cyan" | "create:recipes/building_blocks/cut_crimsite_slab" | "minecraft:recipes/redstone/birch_door" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_blue" | "create:recipes/misc/crafting/logistics/pulse_extender" | "create:recipes/building_blocks/crimsite_from_stone_types_crimsite_stonecutting" | "create:recipes/misc/crafting/logistics/red_table_cloth_clear" | "enderio:recipes/building_blocks/invert_fused_quartz_dnp" | "enderio:recipes/misc/xnor_filter_from_xor_filter" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_cyan" | "storagedrawers:recipes/storagedrawers/diamond_storage_upgrade" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_umber_brick_stairs_stonecutting" | "minecraft:recipes/decorations/snow" | "createdeco:recipes/building_blocks/long_scarlet_brick_wall_from_scarlet_brick_wall_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper_from_oxidized_copper_stonecutting" | "enderio:recipes/building_blocks/invert_fused_quartz_dna" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_corner_dusk_bricks_stonecutting" | "enderio:recipes/building_blocks/invert_fused_quartz_dnm" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_long_dean_bricks_stonecutting" | "createdeco:recipes/decorations/iron_catwalk_forge" | "create:recipes/building_blocks/cut_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_orange" | "minecraft:recipes/building_blocks/stone_brick_stairs" | "create:recipes/building_blocks/cut_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "create:recipes/misc/crafting/materials/cardboard_from_bound_block" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_locometal_boiler" | "tconstruct:recipes/decorations/gadgets/fancy_frame/reversed_reversed_gold" | "createdeco:recipes/building_blocks/corner_dusk_brick_slab_from_short_dusk_bricks_stonecutting" | "ae2:recipes/misc/network/cells/item_storage_components_cell_1k_part" | "tconstruct:recipes/decorations/world/wood/greenheart/fence" | "createdeco:recipes/building_blocks/mossy_red_brick_wall_from_mossy_red_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_tuff_slab_from_stone_types_tuff_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_smelting_gold_ore" | "minecraft:recipes/building_blocks/stone_bricks_from_stone_stonecutting" | "create:recipes/building_blocks/crafting/logistics/orange_table_cloth" | "create:copper" | "enderio:recipes/building_blocks/recolor_clear_glass_em_lime" | "create:recipes/building_blocks/small_scoria_brick_slab_from_stone_types_scoria_stonecutting" | "createdeco:recipes/building_blocks/corner_dusk_brick_wall_from_dusk_brick_wall_stonecutting" | "tconstruct:recipes/misc/common/materials/hepatizon_block_from_ingots" | "createdeco:recipes/building_blocks/blue_brick_wall_from_long_blue_brick_wall_stonecutting" | "enderio:recipes/misc/aversion_obelisk" | "create:recipes/misc/smelting/glass_from_framed_glass" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs_from_bricks_stonecutting" | "createdeco:recipes/decorations/decal_down_right" | "createdeco:recipes/decorations/andesite_catwalk_railing_forge" | "minecraft:recipes/building_blocks/stone_slab" | "minecraft:recipes/decorations/black_carpet" | "minecraft:recipes/misc/gold_nugget_from_blasting" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_light_gray" | "createdeco:recipes/building_blocks/mossy_umber_brick_slab" | "createdeco:recipes/building_blocks/umber_bricks" | "minecraft:recipes/building_blocks/blue_concrete_powder" | "createdeco:recipes/building_blocks/corner_dusk_brick_stairs_from_short_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/blue_brick_slab_from_short_blue_bricks_stonecutting" | "ae2:recipes/misc/network/cables/dense_covered_fluix" | "createdeco:recipes/building_blocks/blue_brick_slab" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_long_dusk_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_long_umber_bricks_stonecutting" | "minecraft:recipes/building_blocks/crimson_planks" | "create_connected:recipes/crafting/kinetics/centrifugal_clutch" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_riveted_locometal" | "create:chute" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_cyan" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_dean_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/cracked_verdant_bricks_from_verdant_bricks_blasting" | "minecraft:recipes/building_blocks/black_terracotta" | "enderio:recipes/misc/extraction_speed_upgrade_2_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_brass_wrapped_locometal" | "createdeco:recipes/building_blocks/long_scarlet_bricks_from_corner_scarlet_bricks_stonecutting" | "create:recipes/building_blocks/cut_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "sophisticatedbackpacks:recipes/misc/magnet_upgrade" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_green" | "minecraft:recipes/food/cooked_rabbit" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_magenta" | "create:recipes/misc/crafting/appliances/crafting_blueprint" | "ae2:recipes/misc/tools/paintballs_lumen_lime" | "enderio:recipes/building_blocks/recolor_clear_glass_em_magenta" | "create:recipes/building_blocks/polished_cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "create:recipes/misc/crafting/logistics/orange_table_cloth_clear" | "enderio:recipes/building_blocks/invert_clear_glass_na" | "createdeco:recipes/decorations/zinc_coin" | "create:crushing_wheel" | "createdeco:recipes/building_blocks/mossy_scarlet_brick_wall" | "create:recipes/misc/crafting/kinetics/gearbox_from_conversion" | "storagedrawers:recipes/storagedrawers/acacia_drawers" | "enderio:recipes/building_blocks/recolor_clear_glass_magenta" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_riveted_locometal" | "enderio:recipes/building_blocks/invert_clear_glass_np" | "createdeco:recipes/building_blocks/cracked_verdant_brick_slab" | "create:recipes/building_blocks/cut_crimsite_brick_stairs" | "enderio:recipes/building_blocks/invert_clear_glass_nm" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_iron_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_riveted_locometal" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs" | "create:recipes/misc/crafting/kinetics/water_wheel" | "railways:recipes/misc/crafting/palettes/wrapping/cyan_iron_wrapped_locometal" | "create:recipes/building_blocks/cut_granite_slab_from_stone_types_granite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_copper_wrapped_locometal_boiler" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_locometal_smokebox" | "create:recipes/misc/blasting/silver_ingot_compat_oreganized" | "createdeco:recipes/building_blocks/mossy_dusk_brick_slab_from_mossy_dusk_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_brown" | "enderio:recipes/misc/energetic_alloy_block" | "create:recipes/building_blocks/cut_limestone_brick_slab_recycling" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_white" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_lime" | "createdeco:recipes/building_blocks/pearl_bricks_from_short_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_slab" | "createdeco:recipes/building_blocks/corner_blue_brick_wall_from_corner_blue_bricks_stonecutting" | "create:recipes/building_blocks/oxidized_copper_shingle_slab" | "railways:recipes/combat/dying_existing_cap_red" | "createdeco:recipes/decorations/andesite_catwalk_stairs" | "minecraft:recipes/building_blocks/chiseled_red_sandstone" | "create:recipes/building_blocks/crafting/kinetics/magenta_seat" | "minecraft:recipes/decorations/light_gray_stained_glass_pane_from_glass_pane" | "ae2:recipes/misc/tools/portable_fluid_cell_256k" | "minecraft:adventure/arbalistic" | "enderio:recipes/building_blocks/recolor_fused_quartz_orange" | "tconstruct:recipes/decorations/smeltery/scorched/lantern" | "storagedrawers:recipes/storagedrawers/remote_group_upgrade" | "createdeco:recipes/decorations/green_shipping_container" | "minecraft:recipes/building_blocks/pink_stained_glass" | "create:recipes/misc/crafting/kinetics/large_cogwheel_from_little" | "minecraft:recipes/building_blocks/black_stained_glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_flat_slashed_locometal" | "createdeco:recipes/decorations/green_placard_from_dyeing" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_blue" | "minecraft:recipes/building_blocks/cracked_polished_blackstone_bricks" | "minecraft:recipes/building_blocks/gray_stained_glass" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_long_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_blue_brick_stairs_from_long_blue_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_pearl_bricks_stonecutting" | "create:super_glue" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_blue" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_long_verdant_brick_stairs_stonecutting" | "minecraft:recipes/misc/map" | "ae2:recipes/misc/network/cables/dense_covered_light_gray" | "tconstruct:recipes/decorations/common/glass/vanilla/end_crystal" | "minecraft:recipes/building_blocks/cobbled_deepslate_slab" | "create:recipes/building_blocks/crafting/logistics/light_blue_postbox" | "create:recipes/building_blocks/cut_scorchia_wall" | "createdeco:recipes/building_blocks/short_umber_brick_wall_from_umber_bricks_stonecutting" | "ae2:recipes/misc/network/parts/terminals" | "create:recipes/building_blocks/tiled_glass_pane_from_glass_panes_colorless_stonecutting" | "minecraft:recipes/tools/shears" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_tiled_umber_brick_stairs_stonecutting" | "enderio:recipes/redstone/resetting_lever_five_inv" | "ae2:recipes/misc/misc/tiny_tnt" | "railways:recipes/misc/stonecutting/palettes/cycling/white_plated_locometal" | "createdeco:recipes/building_blocks/corner_red_brick_stairs_from_tiled_red_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_blue" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_light_gray" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_corner_blue_bricks_stonecutting" | "create:recipes/misc/crafting/materials/andesite_alloy_block" | "createdeco:recipes/decorations/green_andesite_lamp" | "tconstruct:recipes/misc/common/slime/ender/crystal_growing" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_copper_wrapped_locometal" | "minecraft:recipes/brewing/golden_carrot" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_flat_riveted_locometal" | "createdeco:recipes/decorations/industrial_iron_door" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_orange" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_plated_locometal" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_short_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_stairs" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_flat_riveted_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_brown" | "ae2:recipes/misc/network/crafting/1k_cpu_crafting_storage" | "tconstruct:recipes/redstone/smeltery/seared/drain" | "enderio:recipes/building_blocks/recolor_clear_glass_a_lime" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_lime" | "ae2:recipes/misc/network/cells/fluid_storage_cell_16k" | "minecraft:recipes/transportation/jungle_chest_boat" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_copper_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/corner_blue_brick_slab_from_blue_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_pink" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_light_gray" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_gray" | "enderio:recipes/misc/redstone_alloy_nugget_to_ingot" | "enderio:recipes/misc/vibrant_crystal" | "createdeco:recipes/building_blocks/short_dusk_brick_wall_from_dusk_brick_wall_stonecutting" | "expatternprovider:recipes/misc/pattern_modifier" | "minecraft:recipes/building_blocks/dye_pink_bed" | "minecraft:recipes/tools/spyglass" | "tconstruct:recipes/misc/common/materials/rose_gold_block_from_ingots" | "createdeco:recipes/building_blocks/iron_window_pane" | "railways:recipes/misc/crafting/smokestack_woodburner" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_corner_umber_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_wall_from_tiled_umber_brick_wall_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_brass_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_corner_pearl_brick_slab_stonecutting" | "minecraft:recipes/misc/red_dye_from_rose_bush" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_long_umber_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_yellow" | "sophisticatedbackpacks:recipes/misc/filter_upgrade" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_locometal_smokebox" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_soul_glass" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_white" | "create:recipes/building_blocks/ochrum_pillar_from_stone_types_ochrum_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_black" | "minecraft:recipes/building_blocks/cobblestone_slab_from_cobblestone_stonecutting" | "createdeco:recipes/building_blocks/tiled_pearl_brick_wall_from_corner_pearl_brick_wall_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_lime" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_magenta" | "create:recipes/building_blocks/bamboo_window" | "ae2:recipes/misc/network/cables/covered_red" | "create:recipes/building_blocks/cut_scoria_bricks_from_stone_types_scoria_stonecutting" | "copycats:recipes/crafting/copycat_flat_pane" | "minecraft:recipes/building_blocks/prismarine_slab_from_prismarine_stonecutting" | "createdeco:recipes/building_blocks/short_scarlet_brick_wall_from_scarlet_brick_wall_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_slab_from_stone_types_scorchia_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_copper_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab" | "createdeco:recipes/building_blocks/corner_dusk_brick_stairs_from_corner_dusk_bricks_stonecutting" | "minecraft:recipes/redstone/lightning_rod" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_black" | "minecraft:adventure/kill_all_mobs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_copper_wrapped_locometal" | "ae2:recipes/misc/network/cables/smart_purple" | "ae2:recipes/misc/network/cells/fluid_storage_cell_256k" | "minecraft:recipes/building_blocks/birch_wood" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_plated_locometal" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_corner_umber_bricks_stonecutting" | "create:recipes/misc/blasting/ingot_silver_compat_immersiveengineering" | "createdeco:recipes/building_blocks/mossy_verdant_brick_stairs" | "minecraft:recipes/decorations/crimson_sign" | "createdeco:recipes/building_blocks/corner_scarlet_brick_slab_from_short_scarlet_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_wall_from_corner_umber_brick_wall_stonecutting" | "tconstruct:recipes/misc/common/materials/rose_gold_nugget_from_ingot" | "createdeco:recipes/building_blocks/corner_blue_bricks_from_short_blue_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_a_blue" | "copycats:recipes/crafting/copycat_half_panel" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_blue_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_bricks_from_blackstone_stonecutting" | "create:recipes/misc/smelting/ingot_aluminum_compat_immersiveengineering" | "create:recipes/building_blocks/polished_cut_diorite_wall" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_short_dusk_bricks_stonecutting" | "create:recipes/misc/crafting/appliances/schedule_clear" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_light_blue" | "createdeco:recipes/building_blocks/long_blue_brick_wall_from_short_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_locometal_pillar" | "ae2:recipes/misc/misc/deconstruction_cut_certus_quartz_block" | "minecraft:recipes/building_blocks/dye_cyan_bed" | "enderio:recipes/misc/alloy_smelter" | "createdeco:recipes/building_blocks/corner_dean_brick_wall_from_tiled_dean_brick_wall_stonecutting" | "enderio:recipes/redstone/resetting_lever_ten_inv_from_base" | "createdeco:recipes/building_blocks/scarlet_brick_wall_from_long_scarlet_brick_wall_stonecutting" | "create:recipes/building_blocks/crafting/logistics/orange_postbox_from_other_postbox" | "create:recipes/misc/crafting/logistics/brass_table_cloth_clear" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_locometal_boiler" | "createdeco:recipes/building_blocks/dusk_brick_wall_from_short_dusk_bricks_stonecutting" | "minecraft:recipes/building_blocks/stripped_dark_oak_wood" | "copycats:recipes/crafting/copycat_slice_from_conversion" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_light_gray" | "minecraft:recipes/building_blocks/dye_yellow_wool" | "ae2:recipes/misc/network/cables/smart_lime" | "createdeco:recipes/building_blocks/cracked_umber_brick_stairs_from_cracked_umber_bricks_stonecutting" | "create:recipes/misc/crafting/logistics/pulse_repeater" | "create:extendo_grip_dual" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_red" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_lime" | "minecraft:recipes/building_blocks/iron_block" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_locometal_pillar" | "ae2:recipes/misc/network/cables/dense_covered_brown" | "createdeco:recipes/building_blocks/long_red_brick_slab_from_tiled_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_slab_from_umber_bricks_stonecutting" | "createdeco:recipes/decorations/copper_hull" | "create:recipes/misc/smelting/bread" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_corner_dusk_brick_stairs_stonecutting" | "minecraft:recipes/building_blocks/smooth_red_sandstone_stairs" | "enderio:recipes/building_blocks/recolor_clear_glass_np_lime" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab" | "create:recipes/misc/crafting/kinetics/furnace_minecart_from_contraption_cart" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_brown" | "create:recipes/misc/crafting/kinetics/green_valve_handle_from_other_valve_handle" | "sophisticatedbackpacks:recipes/misc/advanced_compacting_upgrade" | "enderio:recipes/misc/copper_ingot_from_blasting" | "createdeco:recipes/building_blocks/corner_pearl_brick_wall_from_pearl_brick_wall_stonecutting" | "ae2:recipes/misc/tools/certus_quartz_sword" | "create_connected:recipes/crafting/kinetics/vertical_brass_gearbox_from_conversion" | "minecraft:recipes/decorations/birch_hanging_sign" | "minecraft:recipes/decorations/deepslate_tile_wall_from_deepslate_bricks_stonecutting" | "create:recipes/building_blocks/cut_asurine_brick_slab" | "createdeco:recipes/building_blocks/dean_brick_slab_from_corner_dean_bricks_stonecutting" | "tconstruct:recipes/misc/common/materials/hepatizon_nugget_from_ingot" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_flat_riveted_locometal" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_short_pearl_brick_stairs_stonecutting" | "create:recipes/misc/crafting/logistics/blue_table_cloth_clear" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_dusk_bricks_stonecutting" | "tconstruct:recipes/decorations/tables/tinkers_chest" | "createdeco:recipes/decorations/yellow_iron_lamp" | "minecraft:recipes/redstone/birch_fence_gate" | "tconstruct:recipes/decorations/common/glass/magenta_clear_stained_glass_pane" | "minecraft:recipes/redstone/stone_button" | "ae2:recipes/misc/network/cables/dense_smart_lime" | "create:recipes/building_blocks/cut_dripstone_brick_stairs" | "expatternprovider:recipes/misc/mod_export_bus" | "createdeco:recipes/building_blocks/long_red_brick_wall" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_gray" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_plated_locometal" | "ae2:recipes/misc/network/parts/terminals_crafting" | "enderio:recipes/building_blocks/recolor_clear_glass_np_blue" | "storagedrawers:recipes/storagedrawers/drawer_puller" | "create:spout" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_iron_wrapped_locometal_boiler" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_light_gray" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_black" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_brass_wrapped_locometal" | "createdeco:recipes/building_blocks/cracked_red_brick_wall_from_cracked_red_bricks_stonecutting" | "enderio:adventure/richer" | "minecraft:recipes/building_blocks/stone" | "enderio:recipes/misc/fluid_tank" | "createdeco:recipes/building_blocks/corner_blue_brick_slab_from_tiled_blue_brick_slab_stonecutting" | "minecraft:recipes/decorations/green_carpet" | "minecraft:recipes/building_blocks/light_blue_terracotta" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_green" | "createdeco:recipes/decorations/iron_mesh_fence_from_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_blue" | "railways:recipes/misc/crafting/palettes/wrapping/light_blue_iron_wrapped_locometal" | "minecraft:recipes/transportation/bamboo_raft" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_white" | "ae2:recipes/misc/network/parts/panels_semi_dark_monitor_alt" | "create:recipes/building_blocks/small_crimsite_brick_slab_recycling" | "createdeco:recipes/building_blocks/cracked_umber_bricks_from_umber_bricks_smelting" | "createdeco:recipes/building_blocks/long_red_bricks_from_tiled_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_dusk_brick_wall_from_corner_dusk_brick_wall_stonecutting" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst" | "createdeco:recipes/decorations/iron_ladder_from_stonecutting" | "create:recipes/building_blocks/small_rose_quartz_tiles_from_polished_rose_quartz_stonecutting" | "minecraft:recipes/building_blocks/mossy_stone_brick_slab" | "copycats:recipes/crafting/copycat_flat_pane_from_conversion" | "minecraft:recipes/building_blocks/cut_copper" | "minecraft:recipes/redstone/stone_pressure_plate" | "tconstruct:recipes/building_blocks/world/wood/enderbark/slab" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_light_gray" | "create:recipes/building_blocks/cut_ochrum_brick_slab_recycling" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_lime" | "createdeco:recipes/building_blocks/tiled_dusk_brick_wall_from_corner_dusk_bricks_stonecutting" | "minecraft:recipes/building_blocks/dye_lime_bed" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_short_blue_bricks_stonecutting" | "ae2:recipes/misc/network/cables/dense_smart_blue" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_locometal_pillar" | "minecraft:adventure/spyglass_at_dragon" | "ae2:recipes/misc/network/cables/dense_covered_pink" | "sophisticatedbackpacks:recipes/misc/advanced_jukebox_upgrade" | "createdeco:recipes/building_blocks/verdant_brick_wall_from_corner_verdant_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/corner_red_brick_wall_from_bricks_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_wall_from_corner_dusk_brick_wall_stonecutting" | "create:recipes/building_blocks/deepslate_from_stone_types_deepslate_stonecutting" | "ae2:recipes/misc/network/cables/smart_blue" | "ae2:recipes/misc/network/cells/item_storage_components_cell_64k_part" | "createdeco:recipes/building_blocks/corner_blue_brick_wall_from_long_blue_brick_wall_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_blue" | "copycats:recipes/crafting/copycat_slope_from_conversion" | "minecraft:recipes/decorations/red_sandstone_wall_from_red_sandstone_stonecutting" | "minecraft:recipes/food/cookie" | "createdeco:recipes/building_blocks/zinc_window_pane" | "createdeco:recipes/building_blocks/corner_scarlet_brick_stairs_from_long_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_long_scarlet_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_locometal_pillar" | "create:recipes/building_blocks/small_asurine_brick_slab_recycling" | "minecraft:recipes/misc/fire_charge" | "minecraft:recipes/decorations/soul_torch" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_green" | "createdeco:recipes/building_blocks/long_pearl_brick_wall_from_corner_pearl_brick_wall_stonecutting" | "minecraft:recipes/building_blocks/yellow_terracotta" | "createdeco:recipes/building_blocks/long_verdant_brick_wall_from_tiled_verdant_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/corner_blue_brick_slab_from_blue_bricks_stonecutting" | "minecraft:recipes/misc/writable_book" | "createdeco:recipes/decorations/brass_door" | "createdeco:recipes/building_blocks/cracked_red_brick_wall" | "enderio:recipes/building_blocks/recolor_clear_glass_e_red" | "enderio:recipes/redstone/resetting_lever_thirty_inv_from_prev" | "create:recipes/building_blocks/crafting/logistics/green_postbox" | "create:recipes/building_blocks/polished_cut_granite_stairs" | "createdeco:recipes/building_blocks/dean_brick_wall_from_corner_dean_brick_wall_stonecutting" | "create_connected:recipes/crafting/palettes/copycat_slab_compat" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_flat_slashed_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_orange" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_yellow" | "createdeco:recipes/decorations/magenta_shipping_container_from_dyeing_vaults" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs" | "create:recipes/combat/crafting/appliances/netherite_backtank_from_netherite" | "createdeco:recipes/building_blocks/tiled_verdant_brick_wall_from_long_verdant_brick_wall_stonecutting" | "tconstruct:recipes/decorations/common/glass/light_gray_clear_stained_glass_pane" | "minecraft:recipes/food/bread" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_plated_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_iron_wrapped_locometal" | "minecraft:nether/obtain_ancient_debris" | "enderio:recipes/building_blocks/recolor_clear_glass_yellow" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_white" | "ae2:recipes/misc/decorative/fluix_block" | "minecraft:recipes/decorations/magenta_candle" | "create:recipes/building_blocks/cut_veridium_wall_from_stone_types_veridium_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs_from_exposed_copper_stonecutting" | "createdeco:recipes/building_blocks/tiled_red_brick_slab_from_corner_red_brick_slab_stonecutting" | "create:recipes/building_blocks/tuff_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/diorite" | "enderio:recipes/building_blocks/recolor_clear_glass_m_cyan" | "minecraft:recipes/building_blocks/dye_white_bed" | "createdeco:recipes/building_blocks/cracked_blue_bricks_from_blue_bricks_blasting" | "createdeco:recipes/decorations/iron_coinstack" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_blue_brick_stairs_stonecutting" | "enderio:recipes/building_blocks/dark_steel_pressure_plate" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_magenta" | "createdeco:recipes/building_blocks/tiled_umber_brick_wall_from_long_umber_bricks_stonecutting" | "minecraft:recipes/decorations/spruce_hanging_sign" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_riveted_locometal" | "minecraft:recipes/building_blocks/polished_granite_from_granite_stonecutting" | "create:recipes/building_blocks/cut_calcite_bricks_from_stone_types_calcite_stonecutting" | "create:recipes/misc/crafting/logistics/yellow_table_cloth_clear" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_copper_wrapped_locometal" | "create:recipes/building_blocks/cut_veridium_stairs_from_stone_types_veridium_stonecutting" | "createdeco:recipes/building_blocks/corner_verdant_brick_slab_from_short_verdant_bricks_stonecutting" | "ae2:recipes/misc/tools/paintballs_light_blue" | "createdeco:recipes/building_blocks/cracked_dusk_brick_slab" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab_from_oxidized_copper_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_e_light_gray" | "tconstruct:recipes/tools/common/slime/lead" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs_from_long_red_bricks_stonecutting" | "create:cart_pickup" | "createdeco:recipes/building_blocks/corner_scarlet_brick_slab" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_honeycomb" | "create:recipes/building_blocks/copper_tiles_from_ingots_copper_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_stairs_from_blackstone_stonecutting" | "create:recipes/building_blocks/cut_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_slashed_locometal" | "minecraft:recipes/redstone/redstone_from_smelting_redstone_ore" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_riveted_locometal" | "tconstruct:recipes/misc/common/slime/sky/slimeball_from_block" | "minecraft:recipes/building_blocks/hay_block" | "createdeco:recipes/building_blocks/short_pearl_bricks_from_corner_pearl_bricks_stonecutting" | "create:recipes/building_blocks/crafting/logistics/brown_postbox_from_other_postbox" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_copper_wrapped_locometal_boiler" | "tconstruct:recipes/decorations/gadgets/frame/manyullyn" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingle_slab_from_honeycomb" | "ae2:recipes/misc/block_cutter/walls/fluix_wall" | "create:recipes/building_blocks/weathered_copper_shingle_stairs_from_weathered_copper_shingles_stonecutting" | "minecraft:recipes/building_blocks/granite" | "createdeco:recipes/building_blocks/short_red_brick_stairs_from_corner_red_bricks_stonecutting" | "create:recipes/building_blocks/cut_granite_brick_slab" | "create:recipes/building_blocks/polished_cut_limestone_slab_recycling" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_dean_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/white_locometal_smokebox" | "minecraft:recipes/misc/emerald_from_smelting_deepslate_emerald_ore" | "minecraft:recipes/redstone/target" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_black" | "ae2:recipes/misc/block_cutter/slabs/sky_stone_slab" | "minecraft:recipes/redstone/crimson_door" | "create:recipes/misc/smelting/lead_ingot_compat_oreganized" | "createdeco:recipes/decorations/light_blue_shipping_container_from_dyeing_vaults" | "tconstruct:recipes/building_blocks/common/firewood/nahuatl_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_locometal_pillar" | "minecraft:recipes/redstone/acacia_door" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_long_verdant_bricks_stonecutting" | "createdeco:recipes/decorations/blue_shipping_container_from_dyeing_vaults" | "ae2:recipes/misc/network/blocks/interfaces_interface" | "minecraft:recipes/decorations/spruce_fence" | "minecraft:recipes/transportation/activator_rail" | "minecraft:recipes/tools/diamond_shovel" | "createdeco:recipes/building_blocks/cracked_scarlet_bricks_from_scarlet_bricks_smelting" | "minecraft:recipes/building_blocks/polished_granite_slab_from_polished_granite_stonecutting" | "createdeco:recipes/decorations/industrial_iron_catwalk_stairs_from_stonecutting" | "sophisticatedbackpacks:recipes/misc/netherite_backpack" | "minecraft:husbandry/safely_harvest_honey" | "create:recipes/building_blocks/polished_cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "enderio:recipes/building_blocks/item_conduit" | "ae2:recipes/misc/network/parts/panels_dark_monitor" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_green" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_short_umber_bricks_stonecutting" | "minecraft:adventure/spyglass_at_ghast" | "minecraft:adventure/trim_with_any_armor_pattern" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_black" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_black" | "tconstruct:recipes/combat/tools/armor/travelers_chestplate" | "copycats:recipes/crafting/copycat_slab_from_steps" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_red" | "createdeco:recipes/decorations/zinc_facade_from_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_short_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_red_bricks_from_bricks_stonecutting" | "createdeco:recipes/decorations/orange_placard" | "create:recipes/building_blocks/small_limestone_brick_slab" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_corner_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/dean_brick_wall_from_long_dean_brick_wall_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_slashed_locometal" | "tconstruct:recipes/decorations/smeltery/scorched/alloyer" | "create:long_train" | "copycats:recipes/crafting/copycat_panel_from_conversion" | "create:recipes/building_blocks/crafting/logistics/green_table_cloth_from_other_table_cloth" | "minecraft:recipes/building_blocks/polished_diorite_stairs_from_diorite_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_a_white" | "createdeco:recipes/building_blocks/scarlet_brick_wall_from_tiled_scarlet_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_long_pearl_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_flat_slashed_locometal" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_3" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_4" | "railways:recipes/misc/crafting/palettes/wrapping/black_iron_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_1" | "enderio:recipes/misc/redstone_timer_filter" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_2" | "create:recipes/building_blocks/cut_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/building_blocks/dye_black_carpet" | "ae2:recipes/misc/misc/deconstruction_smooth_certus_quartz_block" | "minecraft:recipes/building_blocks/waxed_copper_block_from_honeycomb" | "enderio:recipes/building_blocks/invert_fused_quartz_enp" | "minecraft:recipes/building_blocks/weathered_cut_copper" | "createdeco:recipes/building_blocks/corner_verdant_bricks_from_long_verdant_bricks_stonecutting" | "create:recipes/building_blocks/cut_scorchia_slab_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/redstone/warped_trapdoor" | "ae2:recipes/misc/shaped/slabs/smooth_sky_stone_block" | "create_connected:shear_pin" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_red" | "enderio:recipes/building_blocks/invert_fused_quartz_ena" | "enderio:recipes/building_blocks/invert_fused_quartz_enm" | "minecraft:recipes/building_blocks/dye_brown_wool" | "minecraft:recipes/redstone/light_weighted_pressure_plate" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_orange" | "expatternprovider:recipes/misc/ei_upgrade" | "minecraft:adventure/throw_trident" | "enderio:recipes/building_blocks/silent_stone_pressure_plate" | "minecraft:recipes/misc/conduit" | "create:recipes/building_blocks/spruce_window" | "createdeco:recipes/building_blocks/blue_bricks_from_short_blue_bricks_stonecutting" | "createdeco:recipes/decorations/brass_mesh_fence_from_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_green" | "create_connected:recipes/crafting/kinetics/item_silo_from_conversion" | "minecraft:recipes/building_blocks/prismarine_stairs_from_prismarine_stonecutting" | "ae2:main/presses" | "minecraft:recipes/decorations/green_candle" | "ae2:recipes/misc/network/cables/dense_covered_yellow" | "createdeco:recipes/decorations/blue_zinc_lamp" | "minecraft:recipes/building_blocks/polished_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_slashed_locometal" | "sophisticatedbackpacks:recipes/misc/blasting_upgrade_from_smelting_upgrade" | "storagedrawers:recipes/storagedrawers/crimson_trim" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_black" | "createdeco:recipes/building_blocks/tiled_red_brick_wall_from_long_red_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_tiled_blue_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/long_dean_brick_wall_from_corner_dean_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_long_dusk_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_short_pearl_brick_slab_stonecutting" | "ae2:recipes/misc/network/cells/fluid_cell_housing" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_white" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_from_waxed_weathered_copper_stonecutting" | "minecraft:recipes/redstone/repeater" | "minecraft:recipes/tools/compass" | "createdeco:recipes/building_blocks/corner_dean_brick_slab_from_short_dean_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/cracked_dean_bricks_from_dean_bricks_smelting" | "enderio:recipes/building_blocks/recolor_fused_quartz_black" | "create:recipes/misc/crafting/kinetics/fluid_pipe_vertical" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_black" | "createdeco:recipes/decorations/decal_down_left" | "minecraft:adventure/ol_betsy" | "minecraft:recipes/building_blocks/quartz_block" | "expatternprovider:recipes/misc/silicon_block_disassembler" | "createdeco:recipes/building_blocks/long_umber_brick_wall_from_short_umber_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_green" | "create:recipes/building_blocks/cut_crimsite_brick_slab" | "createdeco:recipes/decorations/andesite_catwalk_railing_from_stonecutting" | "ae2:recipes/misc/network/blocks/crystal_processing_growth_accelerator" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_tiled_dean_bricks_stonecutting" | "tconstruct:recipes/redstone/world/wood/skyroot/fence_gate" | "createdeco:recipes/building_blocks/corner_verdant_brick_stairs_from_corner_verdant_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_green" | "chiselsandbits:recipes/tools/chisel_diamond" | "minecraft:nether/netherite_armor" | "minecraft:recipes/building_blocks/birch_stairs" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_long_blue_brick_stairs_stonecutting" | "minecraft:recipes/building_blocks/purpur_pillar" | "minecraft:recipes/decorations/end_rod" | "create:recipes/building_blocks/small_veridium_brick_slab_recycling" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_red" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_tiled_dusk_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_ochrum_wall" | "createdeco:recipes/decorations/zinc_support" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_pink" | "createdeco:recipes/building_blocks/corner_red_brick_slab_from_long_red_bricks_stonecutting" | "minecraft:recipes/decorations/gray_stained_glass_pane_from_glass_pane" | "create:recipes/misc/crafting/kinetics/mechanical_pump" | "ae2:recipes/misc/decorative/sky_stone_small_brick_from_stonecutting" | "tconstruct:recipes/decorations/common/glass/cyan_clear_stained_glass_pane" | "minecraft:recipes/building_blocks/mossy_cobblestone_stairs" | "tconstruct:recipes/decorations/common/glass/light_blue_clear_stained_glass_pane" | "ae2:main/charged_quartz" | "ae2:recipes/misc/tools/fluix_shovel" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_lime" | "enderio:recipes/building_blocks/recolor_clear_glass_p_red" | "minecraft:recipes/decorations/gray_glazed_terracotta" | "createdeco:recipes/building_blocks/corner_dean_brick_wall_from_tiled_dean_bricks_stonecutting" | "enderio:recipes/misc/conductive_alloy_nugget_to_ingot" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_short_umber_brick_slab_stonecutting" | "createdeco:recipes/decorations/yellow_copper_lamp" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_light_gray" | "createdeco:recipes/building_blocks/corner_red_brick_stairs_from_long_red_bricks_stonecutting" | "minecraft:recipes/building_blocks/copper_block" | "enderio:recipes/misc/basic_item_filter" | "tconstruct:recipes/misc/common/materials/amethyst_bronze_block_from_ingots" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_brown" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_riveted_locometal" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_tiled_dusk_brick_slab_stonecutting" | "minecraft:recipes/misc/popped_chorus_fruit" | "minecraft:nether/distract_piglin" | "createdeco:recipes/building_blocks/verdant_brick_wall_from_short_verdant_bricks_stonecutting" | "ae2:recipes/misc/network/cables/dense_covered_red" | "minecraft:recipes/building_blocks/sandstone_stairs" | "sophisticatedbackpacks:recipes/misc/void_upgrade" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_pink" | "enderio:recipes/building_blocks/recolor_clear_glass_na_brown" | "createdeco:recipes/decorations/green_zinc_lamp" | "createdeco:recipes/building_blocks/short_blue_brick_wall_from_tiled_blue_brick_wall_stonecutting" | "create:mechanical_pump_0" | "create:recipes/building_blocks/polished_cut_limestone_from_stone_types_limestone_stonecutting" | "minecraft:recipes/food/dried_kelp_from_smoking" | "createdeco:recipes/building_blocks/cracked_umber_brick_slab_from_cracked_umber_bricks_stonecutting" | "create:recipes/building_blocks/cut_dripstone_stairs_from_stone_types_dripstone_stonecutting" | "createdeco:recipes/decorations/iron_sheet_metal" | "createdeco:recipes/building_blocks/blue_brick_wall_from_short_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/verdant_brick_wall_from_long_verdant_brick_wall_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_locometal_smokebox" | "createdeco:recipes/building_blocks/dusk_brick_slab" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_orange" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs_from_oxidized_copper_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_smelting_raw_gold" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/smooth_basalt" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_blue" | "create:recipes/building_blocks/small_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "createdeco:recipes/building_blocks/tiled_red_bricks_from_bricks_stonecutting" | "enderio:recipes/misc/weather_crystal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_copper_wrapped_locometal_boiler" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_stone_slab" | "minecraft:recipes/decorations/deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_locometal_pillar" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_long_dusk_bricks_stonecutting" | "ae2:recipes/misc/decorative/certus_quartz_bricks_from_stonecutting" | "create:recipes/building_blocks/polished_cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "create:recipes/building_blocks/crafting/logistics/orange_table_cloth_from_other_table_cloth" | "ae2:main/crafting_cpu" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_long_dean_bricks_stonecutting" | "minecraft:recipes/decorations/black_bed" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_locometal_pillar" | "ae2:recipes/misc/network/cables/covered_light_blue" | "create:recipes/building_blocks/crafting/kinetics/red_seat_from_other_seat" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_wall_from_scarlet_brick_wall_stonecutting" | "tconstruct:recipes/redstone/world/wood/greenheart/fence_gate" | "railways:recipes/combat/dying_existing_cap_magenta" | "createdeco:recipes/building_blocks/tiled_pearl_brick_wall_from_short_pearl_bricks_stonecutting" | "sophisticatedbackpacks:recipes/misc/backpack" | "ae2:recipes/misc/block_cutter/slabs/smooth_sky_stone_slab" | "enderio:recipes/building_blocks/recolor_clear_glass_d_magenta" | "createdeco:recipes/building_blocks/corner_dean_brick_wall_from_long_dean_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_long_umber_bricks_stonecutting" | "create:recipes/building_blocks/cut_granite_brick_slab_recycling" | "createdeco:recipes/decorations/andesite_catwalk_forge" | "minecraft:recipes/food/cooked_beef_from_smoking" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_slashed_locometal" | "storagedrawers:recipes/storagedrawers/shroud_key" | "create:recipes/building_blocks/crafting/logistics/yellow_table_cloth_from_other_table_cloth" | "createdeco:recipes/building_blocks/long_blue_brick_stairs" | "minecraft:nether/all_potions" | "createdeco:recipes/building_blocks/long_dean_brick_wall_from_corner_dean_bricks_stonecutting" | "create:recipes/building_blocks/crafting/logistics/purple_postbox_from_other_postbox" | "tconstruct:recipes/decorations/smeltery/seared/lantern" | "minecraft:recipes/misc/diamond_from_smelting_deepslate_diamond_ore" | "create:recipes/building_blocks/cut_andesite_bricks_from_stone_types_andesite_stonecutting" | "minecraft:recipes/combat/netherite_boots_smithing" | "minecraft:recipes/misc/light_blue_dye_from_blue_white_dye" | "ae2:recipes/misc/shaped/stairs/cut_quartz_block" | "createdeco:recipes/building_blocks/corner_dusk_brick_slab_from_long_dusk_bricks_stonecutting" | "minecraft:recipes/building_blocks/orange_concrete_powder" | "ae2:recipes/misc/block_cutter/slabs/cut_quartz_slab" | "create:recipes/building_blocks/crafting/kinetics/orange_seat_from_other_seat" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone" | "minecraft:recipes/building_blocks/raw_copper_block" | "minecraft:recipes/building_blocks/granite_stairs" | "create:recipes/building_blocks/small_andesite_bricks_from_stone_types_andesite_stonecutting" | "tconstruct:recipes/decorations/common/glass/clear_glass_pane" | "minecraft:recipes/building_blocks/dye_red_bed" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_short_dusk_bricks_stonecutting" | "minecraft:recipes/building_blocks/dye_black_bed" | "chiselsandbits:recipes/tools/bit_storage" | "createdeco:recipes/building_blocks/cracked_red_bricks_from_bricks_blasting" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_orange" | "createdeco:recipes/building_blocks/mossy_pearl_brick_stairs_from_mossy_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_dean_bricks_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_slab" | "minecraft:recipes/misc/leather" | "create:recipes/building_blocks/cut_dripstone_from_stone_types_dripstone_stonecutting" | "create:recipes/building_blocks/cut_veridium_from_stone_types_veridium_stonecutting" | "ae2:recipes/misc/tools/paintballs_lumen_black" | "createdeco:recipes/building_blocks/corner_verdant_brick_stairs_from_long_verdant_bricks_stonecutting" | "enderio:recipes/misc/double_layer_capacitor" | "tconstruct:recipes/misc/common/materials/slimesteel_nugget_from_ingot" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_flat_riveted_locometal" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_tinted_glass" | "create:recipes/misc/crafting/appliances/copper_diving_boots" | "minecraft:recipes/transportation/bamboo_chest_raft" | "ae2:recipes/misc/decorative/certus_quartz_pillar" | "tconstruct:recipes/misc/common/materials/cobalt_nugget_from_ingot" | "minecraft:recipes/building_blocks/raw_gold_block" | "minecraft:recipes/building_blocks/dye_red_wool" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_short_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_slashed_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_pink" | "enderio:recipes/building_blocks/energy_conduit" | "ae2:recipes/misc/network/cells/item_storage_components_cell_16k_part" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_long_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_scarlet_brick_wall_from_long_scarlet_bricks_stonecutting" | "ae2:main/storage_bus" | "copycats:recipes/crafting/copycat_light_weighted_pressure_plate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_locometal_boiler" | "enderio:recipes/building_blocks/recolor_clear_glass_a_green" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_green" | "ae2:recipes/misc/block_cutter/slabs/quartz_brick_slab" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_lime" | "create:track_0" | "minecraft:recipes/building_blocks/polished_blackstone_slab_from_blackstone_stonecutting" | "createdeco:recipes/building_blocks/corner_pearl_brick_stairs_from_long_pearl_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_m_magenta" | "minecraft:recipes/misc/gold_ingot_from_blasting_deepslate_gold_ore" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_flat_slashed_locometal" | "minecraft:recipes/redstone/spruce_pressure_plate" | "enderio:recipes/building_blocks/recolor_fused_quartz_lime" | "minecraft:recipes/building_blocks/granite_stairs_from_granite_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_tiled_umber_bricks_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_stairs_from_prismarine_stonecutting" | "tconstruct:recipes/decorations/tables/modifier_worktable" | "minecraft:recipes/misc/gold_ingot_from_blasting_gold_ore" | "ae2:recipes/misc/network/blocks/energy_energy_cell" | "tconstruct:recipes/redstone/world/wood/bloodshroom/door" | "enderio:recipes/building_blocks/recolor_fused_quartz_blue" | "create:recipes/misc/crafting/kinetics/clutch" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_orange" | "ae2wtlib:recipes/wireless_universal_terminal/upgrade_pattern_encoding" | "enderio:recipes/building_blocks/recolor_clear_glass_na_cyan" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_yellow" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_iron_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/refill_upgrade" | "createdeco:recipes/building_blocks/corner_verdant_brick_slab_from_tiled_verdant_brick_slab_stonecutting" | "ae2:recipes/misc/network/parts/cable_anchor" | "createdeco:recipes/building_blocks/corner_red_brick_stairs" | "minecraft:recipes/building_blocks/dye_blue_carpet" | "createdeco:recipes/building_blocks/tiled_red_brick_slab_from_tiled_red_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_riveted_locometal" | "createdeco:recipes/building_blocks/corner_dean_brick_stairs_from_tiled_dean_bricks_stonecutting" | "ae2wtlib:recipes/wireless_universal_terminal/ce" | "create:recipes/building_blocks/cut_dripstone_stairs" | "create:recipes/building_blocks/copper_tile_stairs" | "create:recipes/misc/crafting/curiosities/cake" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_riveted_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_purple" | "createdeco:recipes/building_blocks/corner_verdant_brick_wall_from_short_verdant_bricks_stonecutting" | "minecraft:recipes/decorations/magenta_banner" | "minecraft:recipes/tools/stone_pickaxe" | "createdeco:recipes/building_blocks/long_red_brick_stairs_from_tiled_red_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_copper_wrapped_locometal" | "create:recipes/building_blocks/cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "create:recipes/misc/crafting/kinetics/depot" | "ae2wtlib:recipes/wireless_universal_terminal/ca" | "minecraft:recipes/decorations/deepslate_brick_wall" | "railways:recipes/misc/stonecutting/palettes/cycling/red_riveted_locometal" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_blasting" | "createdeco:recipes/building_blocks/long_red_brick_stairs" | "minecraft:recipes/misc/black_dye" | "minecraft:recipes/food/honey_bottle" | "create:recipes/building_blocks/layered_calcite_from_stone_types_calcite_stonecutting" | "minecraft:recipes/misc/light_gray_dye_from_gray_white_dye" | "createdeco:recipes/building_blocks/scarlet_brick_wall_from_short_scarlet_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_scarlet_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_magenta" | "create:recipes/combat/crafting/appliances/netherite_backtank" | "minecraft:recipes/misc/iron_ingot_from_smelting_iron_ore" | "minecraft:recipes/decorations/lantern" | "create:recipes/building_blocks/cut_scorchia_brick_slab_recycling" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_yellow" | "createdeco:recipes/building_blocks/short_blue_brick_wall_from_long_blue_brick_wall_stonecutting" | "ae2:recipes/misc/network/blocks/storage_chest" | "create:recipes/misc/crafting/kinetics/minecart_from_contraption_cart" | "createdeco:recipes/building_blocks/long_blue_bricks_from_corner_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_brass_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_1_from_starter" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_iron_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/cobbled_deepslate_slab_from_cobbled_deepslate_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_blue" | "create:recipes/building_blocks/cut_diorite_brick_slab_recycling" | "create:recipes/building_blocks/ornate_iron_window" | "createdeco:recipes/building_blocks/tiled_dean_brick_wall" | "createdeco:recipes/building_blocks/tiled_pearl_brick_wall_from_pearl_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/attribute_filter" | "create:recipes/building_blocks/cut_crimsite_slab_recycling" | "enderio:recipes/building_blocks/recolor_clear_glass_p_gray" | "minecraft:adventure/fall_from_world_height" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingle_stairs_from_honeycomb" | "minecraft:recipes/decorations/blue_bed" | "createdeco:recipes/building_blocks/corner_dusk_brick_wall_from_short_dusk_bricks_stonecutting" | "create:recipes/building_blocks/cut_scorchia_brick_stairs" | "tconstruct:recipes/redstone/smeltery/seared/channel" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_white" | "tconstruct:recipes/building_blocks/world/wood/skyroot/log_to_wood" | "enderio:recipes/building_blocks/recolor_clear_glass_e_gray" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tile_slab_from_honeycomb" | "enderio:recipes/building_blocks/recolor_clear_glass_a_black" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_cyan" | "createdeco:recipes/building_blocks/corner_pearl_brick_wall" | "create:recipes/misc/crafting/materials/cardboard_from_block" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_plated_locometal" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_cobbled_deepslate_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_wall_from_short_scarlet_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/corner_blue_brick_stairs_from_short_blue_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_wall_from_short_dusk_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/cracked_verdant_brick_slab_from_cracked_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_wall" | "storagedrawers:recipes/storagedrawers/portability_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_riveted_locometal" | "ae2:recipes/misc/block_cutter/walls/quartz_pillar_wall" | "create:recipes/misc/crafting/kinetics/sail_frame_from_conversion" | "sophisticatedbackpacks:recipes/misc/chipped/botanist_workbench_upgrade" | "minecraft:recipes/misc/red_dye_from_beetroot" | "ae2:recipes/misc/tools/paintballs_lumen_green" | "create:display_link" | "enderio:recipes/building_blocks/recolor_clear_glass_m_yellow" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_light_blue" | "minecraft:recipes/tools/wooden_hoe" | "create:recipes/building_blocks/polished_cut_scorchia_from_stone_types_scorchia_stonecutting" | "copycats:recipes/crafting/copycat_board" | "sophisticatedbackpacks:recipes/misc/pickup_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_copper_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_brass_wrapped_locometal" | "createdeco:recipes/building_blocks/corner_umber_brick_wall_from_long_umber_bricks_stonecutting" | "ae2wtlib:recipes/wireless_universal_terminal/ae" | "minecraft:recipes/decorations/granite_wall" | "ae2:recipes/misc/network/cables/glass_fluix" | "createdeco:recipes/decorations/copper_facade_from_stonecutting" | "enderio:recipes/redstone/resetting_lever_three_hundred_from_prev" | "create:recipes/building_blocks/copper_tile_slab_from_copper_tiles_stonecutting" | "createdeco:recipes/building_blocks/long_red_brick_slab_from_corner_red_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_tiled_dusk_brick_slab_stonecutting" | "tconstruct:recipes/misc/common/slime/ichor/slimeball_from_block" | "create:recipes/misc/crafting/schematics/schematicannon" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_locometal_boiler" | "createdeco:recipes/building_blocks/short_scarlet_brick_wall_from_corner_scarlet_brick_wall_stonecutting" | "minecraft:recipes/redstone/oak_fence_gate" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_flat_riveted_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/red_locometal_pillar" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_corner_dusk_bricks_stonecutting" | "minecraft:husbandry/bred_all_animals" | "createdeco:recipes/building_blocks/corner_pearl_brick_stairs_from_long_pearl_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_tiled_scarlet_brick_slab_stonecutting" | "tconstruct:recipes/misc/common/materials/copper_nugget_from_ingot" | "enderio:recipes/misc/vibrant_gear" | "createdeco:recipes/decorations/decal_skull" | "createdeco:recipes/building_blocks/mossy_dusk_brick_stairs" | "tconstruct:recipes/redstone/world/wood/enderbark/door" | "create:recipes/building_blocks/cut_tuff_slab" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_stone_stairs" | "tconstruct:recipes/misc/common/glass/vanilla/beacon" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_brass_wrapped_locometal" | "createdeco:recipes/building_blocks/tiled_blue_bricks_from_long_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_dean_brick_slab_from_dean_brick_slab_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/green_plated_locometal" | "create:saw_processing" | "minecraft:recipes/misc/charcoal" | "minecraft:recipes/building_blocks/stone_brick_slab" | "enderio:recipes/tools/experience_rod" | "createdeco:recipes/building_blocks/long_red_brick_wall_from_corner_red_bricks_stonecutting" | "minecraft:recipes/building_blocks/polished_granite_slab_from_granite_stonecutting" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_haunting" | "ae2:recipes/misc/block_cutter/walls/sky_stone_small_brick_wall" | "minecraft:recipes/building_blocks/polished_andesite_from_andesite_stonecutting" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_long_scarlet_brick_stairs_stonecutting" | "ae2:recipes/misc/tools/nether_quartz_pickaxe" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_brown" | "enderio:recipes/misc/redstone_sensor_filter" | "minecraft:recipes/tools/iron_shovel" | "create:recipes/building_blocks/cut_asurine_slab_from_stone_types_asurine_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_np_black" | "ae2:recipes/misc/network/cells/spatial_storage_cell_16_cubed_storage" | "sophisticatedbackpacks:recipes/misc/jukebox_upgrade" | "create:recipes/misc/crafting/kinetics/lime_valve_handle_from_other_valve_handle" | "create:recipes/misc/crafting/materials/brass_block_from_compacting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_flat_slashed_locometal" | "createdeco:recipes/building_blocks/tiled_pearl_bricks_from_long_pearl_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_plated_locometal" | "minecraft:recipes/decorations/item_frame" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_brass_wrapped_locometal" | "createdeco:recipes/building_blocks/tiled_red_brick_wall_from_corner_red_brick_wall_stonecutting" | "minecraft:recipes/building_blocks/cut_copper_slab" | "createdeco:recipes/building_blocks/tiled_red_bricks_from_corner_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_corner_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_verdant_bricks_from_long_verdant_bricks_stonecutting" | "enderio:recipes/misc/nor_filter_from_or_filter" | "create:recipes/building_blocks/jungle_window_pane" | "create:recipes/building_blocks/crimson_window_pane" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_short_umber_bricks_stonecutting" | "enderio:recipes/misc/iron_gear" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_dusk_bricks_stonecutting" | "tconstruct:recipes/decorations/gadgets/fancy_frame/reversed_gold" | "create:recipes/misc/crafting/kinetics/shaft" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_short_blue_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_cyan" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_brass_wrapped_locometal" | "createdeco:recipes/building_blocks/dean_brick_wall_from_tiled_dean_brick_wall_stonecutting" | "minecraft:recipes/misc/coast_armor_trim_smithing_template" | "minecraft:recipes/combat/diamond_helmet" | "create:recipes/misc/crafting/materials/bound_cardboard_block" | "createdeco:recipes/building_blocks/short_umber_brick_wall_from_umber_brick_wall_stonecutting" | "create:recipes/misc/crafting/kinetics/white_valve_handle_from_other_valve_handle" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_purple" | "tconstruct:recipes/tools/tools/building/earth_staff" | "minecraft:adventure/walk_on_powder_snow_with_leather_boots" | "enderio:recipes/building_blocks/recolor_clear_glass_np_green" | "create:deployer" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_locometal_boiler" | "minecraft:recipes/misc/raiser_armor_trim_smithing_template" | "create_connected:recipes/crafting/kinetics/inverted_clutch_from_conversion" | "tconstruct:recipes/decorations/common/glass/gray_clear_stained_glass_pane" | "enderio:recipes/building_blocks/recolor_clear_glass_da_cyan" | "createdeco:recipes/building_blocks/long_pearl_brick_wall" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_copper_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_iron_wrapped_locometal" | "create:recipes/building_blocks/small_calcite_brick_stairs" | "enderio:recipes/misc/wood_gear_corner" | "createdeco:recipes/decorations/pink_placard" | "create:recipes/misc/crafting/kinetics/hand_crank" | "storagedrawers:recipes/storagedrawers/upgrade_template" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_asurine_wall_from_stone_types_asurine_stonecutting" | "create:recipes/building_blocks/small_calcite_brick_slab_recycling" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_short_verdant_brick_slab_stonecutting" | "ae2:recipes/misc/network/wireless_access_point" | "create:recipes/building_blocks/copper_tile_slab" | "tconstruct:recipes/building_blocks/smeltery/scorched/chiseled_scorched_bricks_stonecutting" | "tconstruct:recipes/combat/tools/armor/travelers_pants" | "create:recipes/building_blocks/cut_tuff_brick_stairs" | "expatternprovider:recipes/misc/assembler_matrix_frame" | "minecraft:recipes/building_blocks/cyan_stained_glass" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_corner_scarlet_brick_slab_stonecutting" | "minecraft:recipes/tools/netherite_axe_smithing" | "enderio:recipes/tools/yeta_wrench" | "ae2:recipes/misc/network/blocks/interfaces_interface_alt" | "railways:recipes/misc/crafting/smokestack_oilburner" | "minecraft:recipes/building_blocks/andesite" | "enderio:recipes/building_blocks/recolor_clear_glass_p_magenta" | "minecraft:recipes/building_blocks/cut_sandstone_slab_from_sandstone_stonecutting" | "createdeco:recipes/building_blocks/corner_scarlet_brick_wall_from_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_locometal_pillar" | "createdeco:recipes/building_blocks/short_red_brick_slab" | "createdeco:recipes/building_blocks/long_red_bricks_from_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_gray" | "createdeco:recipes/building_blocks/short_pearl_brick_wall_from_corner_pearl_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/long_blue_brick_wall_from_tiled_blue_brick_wall_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_iron_wrapped_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_white" | "ae2:recipes/misc/tools/paintballs_lumen_yellow" | "minecraft:recipes/building_blocks/blackstone_slab" | "createdeco:recipes/building_blocks/mossy_red_brick_wall" | "create:recipes/building_blocks/small_deepslate_brick_stairs" | "minecraft:story/form_obsidian" | "createdeco:recipes/building_blocks/short_dusk_brick_wall_from_long_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_long_blue_bricks_stonecutting" | "create:recipes/building_blocks/layered_scorchia_from_stone_types_scorchia_stonecutting" | "create:haunted_bell" | "createdeco:recipes/building_blocks/corner_blue_brick_stairs_from_corner_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_slashed_locometal" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_corner_dean_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_copper_wrapped_locometal" | "create:recipes/misc/crafting/materials/cardboard_block" | "enderio:recipes/building_blocks/collision_token_fused_quartz_dp" | "enderio:recipes/building_blocks/collision_token_fused_quartz_dm" | "createdeco:recipes/building_blocks/corner_blue_brick_stairs_from_blue_brick_stairs_stonecutting" | "create:recipes/building_blocks/cut_calcite_wall_from_stone_types_calcite_stonecutting" | "createdeco:recipes/building_blocks/brass_window_pane" | "tconstruct:recipes/building_blocks/common/glass/red_clear_stained_glass" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_dusk_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_slab_from_polished_blackstone_stonecutting" | "enderio:recipes/building_blocks/collision_token_fused_quartz_ea" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_blue" | "tconstruct:recipes/decorations/common/glass/purple_clear_stained_glass_pane" | "createdeco:recipes/decorations/decal_fluid" | "enderio:recipes/building_blocks/collision_token_fused_quartz_em" | "createdeco:recipes/building_blocks/dean_brick_slab_from_short_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_wall_from_corner_dean_brick_wall_stonecutting" | "createdeco:recipes/decorations/decal_ice" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_flat_riveted_locometal" | "enderio:recipes/building_blocks/collision_token_fused_quartz_ep" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_lime" | "createdeco:recipes/building_blocks/mossy_red_bricks_from_moss_block" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_gray" | "minecraft:nether/loot_bastion" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_iron_wrapped_locometal_boiler" | "tconstruct:recipes/building_blocks/common/glass/brown_clear_stained_glass" | "create:recipes/misc/campfire_cooking/bread" | "ae2:recipes/misc/network/blocks/pattern_providers_interface_alt" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_corner_scarlet_bricks_stonecutting" | "tconstruct:recipes/misc/common/materials/raw_cobalt_from_raw_block" | "storagedrawers:recipes/storagedrawers/drawer_key" | "create:recipes/building_blocks/cut_diorite_slab" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_tiled_blue_bricks_stonecutting" | "minecraft:recipes/redstone/jungle_door" | "create:recipes/building_blocks/small_deepslate_bricks_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/granite_pillar_from_stone_types_granite_stonecutting" | "create:recipes/building_blocks/polished_cut_crimsite_slab" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_short_pearl_bricks_stonecutting" | "create:recipes/building_blocks/crafting/logistics/cyan_postbox_from_other_postbox" | "createdeco:recipes/decorations/decal_flow" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_copper_wrapped_locometal_boiler" | "ae2:recipes/misc/network/parts/terminals_pattern_access" | "enderio:adventure/rich" | "copycats:recipes/crafting/copycat_fence" | "tconstruct:recipes/decorations/gadgets/frame/netherite" | "tconstruct:world/ancient_tools" | "copycats:recipes/crafting/copycat_vertical_stairs_from_conversion" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_iron_wrapped_locometal_boiler" | "create_connected:sequenced_pulse_generator" | "createdeco:recipes/decorations/industrial_iron_ladder_from_stonecutting" | "create:recipes/building_blocks/cut_andesite_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_locometal_pillar" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_waxed_exposed_cut_copper_stonecutting" | "enderio:recipes/building_blocks/collision_token_fused_quartz_da" | "createdeco:recipes/building_blocks/long_verdant_bricks_from_tiled_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_corner_scarlet_bricks_stonecutting" | "copycats:recipes/crafting/copycat_half_layer" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_locometal_pillar" | "createdeco:recipes/building_blocks/dusk_bricks" | "tconstruct:recipes/building_blocks/smeltery/seared/grout" | "ae2:main/spatial_ioport" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_dusk_brick_slab_stonecutting" | "create:recipes/misc/crafting/materials/experience_nugget_from_block" | "create:recipes/misc/crafting/kinetics/orange_valve_handle_from_other_valve_handle" | "enderio:recipes/misc/iron_ingot_from_smelting" | "create:recipes/building_blocks/polished_cut_granite_wall_from_stone_types_granite_stonecutting" | "ae2:main/compass" | "createdeco:recipes/building_blocks/short_red_brick_slab_from_long_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_verdant_brick_wall_from_tiled_verdant_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_wall_from_long_dean_bricks_stonecutting" | "ae2:recipes/misc/materials/advancedcard" | "ae2:main/glass_cable" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_orange" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_lime" | "createdeco:recipes/building_blocks/tiled_dusk_brick_wall_from_corner_dusk_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/cracked_scarlet_brick_slab" | "create:recipes/misc/crafting/kinetics/gray_valve_handle_from_other_valve_handle" | "create:mechanical_press" | "createdeco:recipes/building_blocks/cracked_pearl_brick_wall" | "create:recipes/misc/crafting/kinetics/turntable" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_slashed_locometal" | "minecraft:recipes/tools/wooden_shovel" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_tiled_blue_bricks_stonecutting" | "minecraft:recipes/decorations/bamboo_mosaic" | "minecraft:recipes/building_blocks/purpur_stairs" | "ae2:recipes/misc/tools/paintballs_lumen_magenta" | "minecraft:recipes/building_blocks/mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_lime" | "createdeco:recipes/building_blocks/short_blue_brick_wall_from_blue_bricks_stonecutting" | "createdeco:recipes/decorations/industrial_iron_support" | "railways:recipes/misc/crafting/palettes/wrapping/orange_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_riveted_locometal" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_tiled_verdant_bricks_stonecutting" | "minecraft:recipes/decorations/crimson_fence" | "create:recipes/misc/crafting/appliances/clipboard_clear" | "create:recipes/misc/crafting/logistics/purple_table_cloth_clear" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab_from_red_sandstone_stonecutting" | "enderio:recipes/misc/extraction_speed_upgrade_4" | "enderio:recipes/misc/extraction_speed_upgrade_1" | "enderio:recipes/misc/extraction_speed_upgrade_3" | "enderio:recipes/misc/extraction_speed_upgrade_2" | "chiselsandbits:chiselsandbits/root" | "minecraft:recipes/building_blocks/stripped_crimson_hyphae" | "createdeco:recipes/decorations/netherite_coin" | "createdeco:recipes/building_blocks/short_dusk_brick_wall_from_tiled_dusk_bricks_stonecutting" | "create_connected:recipes/crafting/palettes/copycat_vertical_step_compat" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_dusk_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_orange" | "enderio:recipes/building_blocks/recolor_fused_quartz_light_gray" | "enderio:recipes/redstone/resetting_lever_three_hundred_inv" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_iron_wrapped_locometal" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_long_umber_bricks_stonecutting" | "railways:recipes/combat/dying_existing_cap_brown" | "create:recipes/building_blocks/cut_andesite_brick_slab_recycling" | "create:recipes/misc/smelting/ingot_uranium_compat_mekanism" | "create:recipes/building_blocks/layered_dripstone_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/misc/yellow_dye_from_sunflower" | "storagedrawers:recipes/storagedrawers/oak_drawers" | "minecraft:recipes/brewing/cauldron" | "createdeco:recipes/building_blocks/cracked_verdant_brick_stairs" | "create:recipes/building_blocks/cut_andesite_wall_from_stone_types_andesite_stonecutting" | "create:recipes/building_blocks/polished_cut_scoria_slab_from_stone_types_scoria_stonecutting" | "create:recipes/misc/crafting/kinetics/track_observer" | "create:recipes/decorations/andesite_bars_from_andesite_alloy_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_cyan" | "create:recipes/misc/crafting/kinetics/sticker" | "storagedrawers:recipes/storagedrawers/min_redstone_upgrade" | "createdeco:recipes/building_blocks/long_blue_brick_slab" | "minecraft:adventure/root" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs" | "createdeco:recipes/building_blocks/long_red_brick_slab_from_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/dean_brick_slab_from_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dusk_brick_wall" | "ae2:recipes/misc/network/cables/dense_covered_gray" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_yellow" | "enderio:recipes/misc/vibrant_alloy_ingot" | "ae2:recipes/misc/block_cutter/walls/quartz_wall" | "enderio:recipes/misc/primitive_alloy_smelter" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_tiled_pearl_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/corner_dusk_brick_slab_from_dusk_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_orange" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_flat_slashed_locometal" | "minecraft:recipes/misc/ender_eye" | "tconstruct:recipes/misc/common/slime/earth/crystal_growing" | "minecraft:recipes/redstone/redstone_block" | "ae2:main/spatial_explorer" | "minecraft:recipes/decorations/dark_oak_hanging_sign" | "createdeco:recipes/building_blocks/corner_pearl_brick_slab_from_corner_pearl_bricks_stonecutting" | "tconstruct:recipes/redstone/common/slime/ender/slimeblock" | "ae2:recipes/misc/shaped/stairs/smooth_quartz_block" | "ae2:recipes/misc/shaped/walls/sky_stone_block" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_short_scarlet_brick_stairs_stonecutting" | "create:recipes/misc/crafting/kinetics/smart_fluid_pipe" | "enderio:recipes/misc/and_filter_from_nand_filter" | "create:recipes/building_blocks/polished_cut_tuff_slab_recycling" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_green" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_long_scarlet_bricks_stonecutting" | "create:recipes/misc/crafting/materials/raw_zinc" | "minecraft:recipes/decorations/nether_brick_wall_from_nether_bricks_stonecutting" | "minecraft:recipes/decorations/red_stained_glass_pane_from_glass_pane" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_ending_dragon_head" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_slashed_locometal" | "copycats:recipes/crafting/copycat_block_from_slabs" | "ae2:recipes/misc/network/cables/dense_smart_light_blue" | "create:recipes/building_blocks/cut_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "createdeco:recipes/decorations/copper_hull_from_stonecutting" | "ae2:recipes/misc/decorative/sky_stone_small_brick" | "createdeco:recipes/building_blocks/corner_dusk_brick_stairs_from_short_dusk_brick_stairs_stonecutting" | "minecraft:recipes/decorations/deepslate_tile_wall_from_cobbled_deepslate_stonecutting" | "create:recipes/building_blocks/small_limestone_bricks_from_stone_types_limestone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_locometal_pillar" | "create:recipes/building_blocks/small_asurine_brick_slab" | "create:recipes/building_blocks/polished_cut_scorchia_wall" | "create:recipes/building_blocks/small_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "createdeco:recipes/building_blocks/corner_umber_brick_slab_from_short_umber_bricks_stonecutting" | "create:recipes/building_blocks/cut_granite_brick_stairs" | "minecraft:recipes/decorations/bamboo_hanging_sign" | "create:recipes/building_blocks/small_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_flat_riveted_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_magenta" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_locometal_smokebox" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tiles_from_honeycomb" | "expatternprovider:recipes/misc/wireless_hub" | "createdeco:recipes/decorations/brass_coin" | "sophisticatedbackpacks:recipes/misc/pump_upgrade" | "create:recipes/building_blocks/ornate_iron_window_pane" | "ae2:main/growth_accelerator" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_riveted_locometal" | "create:recipes/building_blocks/scorchia_pillar_from_stone_types_scorchia_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_black" | "create:recipes/building_blocks/small_asurine_brick_stairs" | "ae2:recipes/misc/tools/paintballs_magenta" | "createdeco:recipes/decorations/purple_placard_from_dyeing" | "ae2:recipes/misc/network/cells/spatial_storage_cell_128_cubed_storage" | "minecraft:recipes/decorations/light_blue_carpet" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_stairs_stonecutter" | "create:recipes/building_blocks/cut_scoria_wall" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_slashed_locometal" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_long_pearl_bricks_stonecutting" | "railways:recipes/misc/crafting/smokestack_long" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_brass_wrapped_locometal_boiler" | "create:recipes/misc/crafting/logistics/pink_table_cloth_clear" | "createdeco:recipes/decorations/iron_catwalk_railing_from_stonecutting" | "ae2:recipes/misc/block_cutter/stairs/chiseled_quartz_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_brass_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/quartz_slab_from_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_tiled_pearl_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_purple" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_red" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_plated_locometal" | "ae2:recipes/misc/network/blocks/spatial_io_pylon" | "railways:recipes/misc/stonecutting/palettes/cycling/red_flat_slashed_locometal" | "create:recipes/building_blocks/cut_veridium_slab" | "createdeco:recipes/building_blocks/short_dusk_bricks_from_corner_dusk_bricks_stonecutting" | "minecraft:recipes/combat/crossbow" | "create:recipes/building_blocks/crafting/logistics/blue_postbox_from_other_postbox" | "createdeco:recipes/building_blocks/dusk_brick_wall_from_dusk_bricks_stonecutting" | "chiselsandbits:recipes/tools/chisel_gold" | "minecraft:recipes/building_blocks/cracked_deepslate_bricks" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/mossy_verdant_brick_wall" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_magenta" | "minecraft:recipes/building_blocks/warped_planks" | "createdeco:recipes/decorations/copper_trapdoor" | "createdeco:recipes/building_blocks/corner_dean_bricks_from_tiled_dean_bricks_stonecutting" | "create:recipes/building_blocks/crafting/logistics/black_table_cloth_from_other_table_cloth" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab" | "minecraft:recipes/decorations/warped_fence" | "enderio:recipes/misc/advanced_item_filter" | "minecraft:recipes/decorations/black_glazed_terracotta" | "tconstruct:recipes/misc/common/materials/copper_ingot_from_nuggets" | "create:recipes/building_blocks/crafting/kinetics/green_seat" | "railways:recipes/combat/dying_existing_cap_yellow" | "create:recipes/building_blocks/cut_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs" | "ae2:recipes/misc/network/cables/dense_smart_purple" | "enderio:recipes/building_blocks/silent_jungle_pressure_plate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_copper_wrapped_locometal_boiler" | "minecraft:recipes/misc/gray_dye" | "create:train_whistle" | "createdeco:recipes/building_blocks/corner_blue_brick_wall_from_tiled_blue_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/corner_umber_brick_slab_from_tiled_umber_bricks_stonecutting" | "create:recipes/building_blocks/cut_limestone_wall" | "createdeco:recipes/building_blocks/cracked_dusk_brick_slab_from_cracked_dusk_bricks_stonecutting" | "minecraft:recipes/decorations/barrel" | "enderio:recipes/building_blocks/silent_acacia_pressure_plate" | "ae2:recipes/misc/tools/paintballs_gray" | "create:recipes/building_blocks/polished_cut_diorite_stairs" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_cyan" | "minecraft:recipes/misc/orange_dye_from_orange_tulip" | "sophisticatedbackpacks:recipes/misc/anvil_upgrade" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_corner_pearl_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/long_dean_bricks_from_dean_bricks_stonecutting" | "copycats:recipes/crafting/copycat_vertical_slope_from_conversion" | "ae2:recipes/misc/network/parts/terminals_pattern_encoding" | "createdeco:recipes/building_blocks/corner_red_brick_slab_from_tiled_red_brick_slab_stonecutting" | "copycats:recipes/crafting/copycat_stairs" | "create:recipes/misc/crafting/materials/rose_quartz_tiles_from_conversion" | "enderio:recipes/building_blocks/recolor_clear_glass_purple" | "tconstruct:recipes/decorations/common/glass/white_clear_stained_glass_pane_from_panes" | "createdeco:recipes/building_blocks/corner_umber_brick_wall_from_tiled_umber_brick_wall_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_locometal_smokebox" | "create:recipes/misc/smelting/ingot_nickel_compat_immersiveengineering" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_slashed_locometal" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_short_verdant_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_wall_from_long_blue_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/corner_dusk_brick_slab" | "createdeco:recipes/building_blocks/long_red_brick_stairs_from_tiled_red_bricks_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/purple_seat" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_copper_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_short_dean_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_andesite_wall" | "create:recipes/building_blocks/weathered_copper_tile_slab" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_road_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_copper_wrapped_locometal" | "ae2:recipes/misc/network/cables/glass_magenta" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_tiled_verdant_bricks_stonecutting" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_polished_deepslate_stonecutting" | "create:recipes/building_blocks/polished_cut_granite_slab" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_corner_blue_bricks_stonecutting" | "minecraft:recipes/decorations/lime_banner" | "minecraft:recipes/decorations/white_bed" | "createdeco:recipes/building_blocks/short_verdant_brick_wall_from_tiled_verdant_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_orange" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_long_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_pearl_bricks_from_long_pearl_bricks_stonecutting" | "create:recipes/building_blocks/crafting/logistics/cyan_postbox" | "create:recipes/building_blocks/polished_cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/weathered_copper_tile_slab_from_weathered_copper_tiles_stonecutting" | "minecraft:recipes/decorations/nether_brick_wall" | "ae2:recipes/misc/network/cables/covered_pink" | "createdeco:recipes/building_blocks/cracked_pearl_bricks_from_pearl_bricks_smelting" | "createdeco:recipes/building_blocks/long_umber_bricks_from_umber_bricks_stonecutting" | "minecraft:recipes/misc/ward_armor_trim_smithing_template" | "create:recipes/building_blocks/crafting/logistics/yellow_postbox" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_magenta" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_light_gray" | "tconstruct:recipes/decorations/tables/crafting_station" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_corner_pearl_brick_stairs_stonecutting" | "create:recipes/misc/crafting/appliances/linked_controller" | "minecraft:recipes/misc/copper_ingot_from_smelting_deepslate_copper_ore" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_flat_slashed_locometal" | "create:recipes/building_blocks/cut_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_short_dusk_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_brass_wrapped_locometal" | "minecraft:recipes/misc/gold_ingot_from_smelting_deepslate_gold_ore" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_tiled_umber_bricks_stonecutting" | "ae2:recipes/misc/shaped/stairs/quartz_block" | "create:compacting" | "chiselsandbits:recipes/tools/chiseled_printer" | "minecraft:recipes/redstone/redstone_from_blasting_deepslate_redstone_ore" | "create:recipes/misc/crafting/kinetics/radial_chassis" | "enderio:recipes/redstone/resetting_lever_five" | "create:stock_ticker" | "create:recipes/building_blocks/vertical_framed_glass_pane_from_glass_panes_colorless_stonecutting" | "ae2:recipes/misc/tools/certus_quartz_hoe" | "chiselsandbits:recipes/tools/sealant" | "tconstruct:recipes/building_blocks/world/wood/enderbark/stripped_log_to_wood" | "create:recipes/building_blocks/small_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_bricks_from_blue_bricks_stonecutting" | "minecraft:recipes/misc/copper_ingot_from_blasting_copper_ore" | "minecraft:recipes/building_blocks/dye_green_carpet" | "minecraft:recipes/building_blocks/mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting" | "create:recipes/building_blocks/cut_ochrum_slab" | "ae2:recipes/misc/network/cells/item_storage_cell_16k" | "createdeco:recipes/building_blocks/corner_blue_brick_slab_from_short_blue_bricks_stonecutting" | "createdeco:recipes/decorations/brass_catwalk_forge" | "minecraft:recipes/building_blocks/polished_diorite_slab_from_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_locometal_smokebox" | "create:recipes/misc/smelting/nickel_ingot_compat_thermal" | "createdeco:recipes/decorations/brass_support_wedge" | "createdeco:recipes/building_blocks/long_red_brick_wall_from_corner_red_brick_wall_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/magenta_dye_from_blue_red_white_dye" | "minecraft:recipes/building_blocks/purple_concrete_powder" | "createdeco:recipes/building_blocks/long_blue_brick_wall_from_long_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_corner_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_red_brick_wall_from_corner_red_brick_wall_stonecutting" | "minecraft:adventure/read_power_of_chiseled_bookshelf" | "createdeco:recipes/building_blocks/tiled_pearl_bricks_from_pearl_bricks_stonecutting" | "minecraft:recipes/redstone/cherry_door" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/cut_copper_stairs" | "enderio:recipes/building_blocks/invert_fused_quartz_p" | "enderio:recipes/building_blocks/invert_fused_quartz_m" | "storagedrawers:recipes/storagedrawers/keyring" | "create:recipes/misc/crafting/kinetics/sticky_mechanical_piston" | "create:recipes/building_blocks/exposed_copper_shingle_slab_from_exposed_copper_shingles_stonecutting" | "enderio:recipes/building_blocks/invert_fused_quartz_a" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_dusk_brick_slab_stonecutting" | "tconstruct:tools/make_part" | "createdeco:recipes/building_blocks/long_red_brick_wall_from_short_red_brick_wall_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_d_light_blue" | "create:recipes/building_blocks/cut_scoria_wall_from_stone_types_scoria_stonecutting" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_corner_pearl_bricks_stonecutting" | "enderio:recipes/misc/xp_obelisk" | "create_connected:overpowered_brake_0" | "create:recipes/building_blocks/cut_dripstone_wall" | "create:recipes/misc/crafting/appliances/attribute_filter_clear" | "ae2:recipes/misc/tools/nether_quartz_hoe" | "createdeco:recipes/building_blocks/tiled_red_brick_wall_from_short_red_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_umber_brick_stairs_stonecutting" | "minecraft:recipes/combat/spectral_arrow" | "minecraft:recipes/decorations/white_stained_glass_pane" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_plated_locometal" | "railways:recipes/misc/crafting/wooden_headstock_link_and_pin" | "tconstruct:recipes/redstone/smeltery/scorched/ingot_tank" | "minecraft:recipes/decorations/ender_chest" | "railways:recipes/misc/crafting/palettes/wrapping/blue_brass_wrapped_locometal" | "minecraft:recipes/decorations/dark_oak_sign" | "createdeco:recipes/decorations/decal_radioactive" | "create:recipes/misc/crafting/materials/experience_block" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_magenta" | "createdeco:recipes/building_blocks/dean_brick_slab_from_tiled_dean_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_short_scarlet_brick_slab_stonecutting" | "create:recipes/building_blocks/veridium_pillar_from_stone_types_veridium_stonecutting" | "createdeco:recipes/decorations/brass_support" | "minecraft:story/mine_diamond" | "minecraft:recipes/building_blocks/cut_copper_stairs_from_cut_copper_stonecutting" | "createdeco:recipes/building_blocks/tiled_red_brick_slab_from_long_red_brick_slab_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_locometal_pillar" | "tconstruct:recipes/decorations/tables/part_chest" | "create:belt" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_wall" | "createdeco:recipes/building_blocks/mossy_dean_brick_slab_from_mossy_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/mossy_blue_brick_wall" | "enderio:recipes/building_blocks/recolor_clear_glass_blue" | "createdeco:recipes/building_blocks/long_scarlet_bricks_from_short_scarlet_bricks_stonecutting" | "ae2:recipes/misc/network/blocks/energy_vibration_chamber" | "minecraft:recipes/misc/pink_dye_from_peony" | "create:recipes/building_blocks/crafting/logistics/blue_table_cloth_from_other_table_cloth" | "create:recipes/misc/crafting/kinetics/goggles" | "sophisticatedbackpacks:recipes/misc/iron_backpack_from_copper" | "create:recipes/misc/crafting/materials/andesite_alloy_from_block" | "minecraft:recipes/misc/coal_from_smelting_coal_ore" | "create:recipes/misc/crafting/kinetics/copper_door" | "minecraft:nether/find_fortress" | "createdeco:recipes/building_blocks/mossy_red_bricks_from_vine" | "minecraft:recipes/building_blocks/polished_blackstone_bricks" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_wall_from_tiled_scarlet_bricks_stonecutting" | "ae2:recipes/misc/network/cables/smart_light_blue" | "createdeco:recipes/building_blocks/mossy_blue_brick_wall_from_mossy_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_slashed_locometal" | "minecraft:recipes/decorations/red_sandstone_wall" | "enderio:recipes/redstone/resetting_lever_ten_from_inv" | "createdeco:recipes/building_blocks/short_blue_brick_stairs" | "create:recipes/building_blocks/cut_scorchia_brick_wall" | "createdeco:recipes/building_blocks/corner_umber_brick_stairs_from_long_umber_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_orange" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_brown" | "minecraft:recipes/tools/stone_shovel" | "ae2:recipes/misc/materials/annihilationcore" | "createdeco:recipes/decorations/magenta_placard_from_dyeing" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/mossy_dean_brick_slab" | "create:lava_wheel_00000" | "enderio:recipes/building_blocks/soularium_pressure_plate" | "create:recipes/misc/blasting/ingot_lead_compat_immersiveengineering" | "create:recipes/misc/crafting/kinetics/whisk" | "minecraft:recipes/building_blocks/brown_terracotta" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_orange" | "tconstruct:recipes/decorations/gadgets/punji" | "create:recipes/misc/crafting/kinetics/display_board" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_corner_dean_bricks_stonecutting" | "create:recipes/building_blocks/small_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "createdeco:recipes/building_blocks/verdant_brick_wall_from_short_verdant_brick_wall_stonecutting" | "enderio:recipes/building_blocks/silent_dark_steel_pressure_plate" | "tconstruct:recipes/misc/common/materials/amethyst_bronze_ingot_from_nuggets" | "minecraft:recipes/building_blocks/polished_basalt" | "minecraft:recipes/building_blocks/oak_wood" | "minecraft:recipes/building_blocks/smooth_quartz_stairs" | "minecraft:recipes/misc/slime_ball" | "create:recipes/misc/smelting/ingot_aluminium_compat_ic2" | "createdeco:recipes/building_blocks/tiled_dean_bricks_from_long_dean_bricks_stonecutting" | "createdeco:recipes/decorations/industrial_iron_coin" | "ae2:recipes/misc/blasting/sky_stone_block" | "ae2wtlib:recipes/quantum_bridge_card" | "create:recipes/building_blocks/polished_cut_calcite_slab_recycling" | "minecraft:recipes/building_blocks/dye_green_wool" | "minecraft:recipes/decorations/cherry_hanging_sign" | "ae2:recipes/misc/network/crafting/molecular_assembler" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_short_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/jungle_slab" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_corner_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_wall_from_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_verdant_brick_wall_from_verdant_brick_wall_stonecutting" | "create:recipes/building_blocks/polished_cut_scorchia_slab_from_stone_types_scorchia_stonecutting" | "enderio:recipes/building_blocks/pressurized_fluid_conduit_upgrade" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_pink" | "minecraft:recipes/decorations/light_blue_candle" | "create:recipes/misc/smelting/ingot_tin_compat_ic2" | "enderio:recipes/building_blocks/recolor_clear_glass_lime" | "ae2:recipes/misc/network/crafting/4k_cpu_crafting_storage" | "createdeco:recipes/building_blocks/tiled_red_brick_slab" | "create:recipes/building_blocks/framed_glass_pane" | "createdeco:recipes/decorations/zinc_sheet_metal" | "create:recipes/building_blocks/polished_cut_asurine_slab_recycling" | "create:recipes/building_blocks/polished_cut_scoria_wall" | "minecraft:recipes/building_blocks/mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_riveted_locometal" | "minecraft:recipes/food/cooked_beef" | "tconstruct:recipes/building_blocks/common/glass/orange_clear_stained_glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/tiled_umber_brick_wall_from_corner_umber_brick_wall_stonecutting" | "minecraft:recipes/decorations/red_bed" | "createdeco:recipes/building_blocks/corner_dusk_bricks_from_long_dusk_bricks_stonecutting" | "createdeco:recipes/decorations/light_blue_placard_from_dyeing" | "createdeco:recipes/building_blocks/short_pearl_brick_wall_from_short_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_scarlet_brick_stairs_from_scarlet_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_locometal_smokebox" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_iron_wrapped_locometal_boiler" | "create:recipes/misc/crafting/kinetics/piston_extension_pole" | "createdeco:recipes/building_blocks/corner_dean_brick_stairs_from_tiled_dean_brick_stairs_stonecutting" | "minecraft:recipes/redstone/heavy_weighted_pressure_plate" | "createdeco:recipes/building_blocks/cracked_red_brick_stairs" | "extra_gauges:recipes/redstone/string_gauge" | "tconstruct:recipes/building_blocks/common/slime/sky/crystal_block" | "minecraft:recipes/transportation/warped_fungus_on_a_stick" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_long_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_dean_bricks_from_short_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/stripped_jungle_wood" | "create:recipes/building_blocks/polished_cut_calcite_from_stone_types_calcite_stonecutting" | "tconstruct:recipes/misc/common/materials/cobalt_block_from_ingots" | "create:recipes/building_blocks/oak_window_pane" | "copycats:recipes/crafting/copycat_iron_door" | "create:recipes/building_blocks/spruce_window_pane" | "create:recipes/building_blocks/small_diorite_brick_slab" | "createdeco:recipes/building_blocks/verdant_brick_wall_from_corner_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_blue_brick_stairs_from_tiled_blue_bricks_stonecutting" | "ae2:recipes/misc/shaped/walls/quartz_pillar" | "createdeco:recipes/building_blocks/corner_dusk_bricks_from_tiled_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_blue_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_iron_wrapped_locometal_boiler" | "ae2:recipes/misc/network/blocks/crank" | "create:recipes/building_blocks/crafting/logistics/blue_postbox" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_corner_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_blue_brick_wall_from_long_blue_bricks_stonecutting" | "minecraft:recipes/building_blocks/bone_block" | "sophisticatedbackpacks:recipes/misc/advanced_restock_upgrade" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_green" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_corner_umber_brick_stairs_stonecutting" | "minecraft:recipes/misc/magenta_dye_from_lilac" | "create:recipes/misc/crafting/materials/zinc_ingot_from_decompacting" | "ae2:recipes/misc/block_cutter/stairs/quartz_pillar_stairs" | "createdeco:recipes/building_blocks/corner_verdant_brick_wall_from_verdant_brick_wall_stonecutting" | "tconstruct:recipes/brewing/common/slime/magma_cream" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_freezing" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal" | "enderio:recipes/misc/octadic_capacitor" | "minecraft:recipes/misc/melon_seeds" | "minecraft:recipes/building_blocks/magma_block" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_long_dean_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_corner_verdant_brick_slab_stonecutting" | "create_mechanical_extruder:recipes/misc/crafting/mechanical_extruder" | "createdeco:recipes/building_blocks/long_dusk_brick_wall_from_tiled_dusk_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_short_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_wall_from_tiled_dean_bricks_stonecutting" | "copycats:recipes/crafting/copycat_block" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_pink" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_corner_umber_bricks_stonecutting" | "expatternprovider:recipes/misc/threshold_export_bus" | "createdeco:recipes/building_blocks/corner_scarlet_bricks_from_scarlet_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_magenta" | "minecraft:recipes/building_blocks/smooth_quartz_slab_from_smooth_quartz_stonecutting" | "create:recipes/building_blocks/cut_scoria_brick_slab_recycling" | "tconstruct:recipes/combat/tools/armor/travelers_goggles" | "minecraft:recipes/food/cake" | "minecraft:recipes/combat/iron_leggings" | "create:recipes/misc/crafting/kinetics/mechanical_crafter" | "createdeco:recipes/building_blocks/short_pearl_brick_wall" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_brown" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_light_blue" | "create:recipes/building_blocks/cut_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "minecraft:recipes/decorations/gray_bed" | "minecraft:recipes/misc/emerald_from_smelting_emerald_ore" | "minecraft:recipes/building_blocks/coarse_dirt" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_dusk_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_pearl_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_gray" | "minecraft:recipes/building_blocks/light_gray_concrete_powder" | "createdeco:recipes/building_blocks/cracked_scarlet_brick_stairs" | "create:recipes/building_blocks/small_diorite_brick_wall" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_verdant_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_flat_riveted_locometal" | "createdeco:recipes/building_blocks/blue_brick_stairs" | "enderio:recipes/building_blocks/recolor_clear_glass_em_light_gray" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_flat_riveted_locometal" | "minecraft:recipes/combat/leather_leggings" | "copycats:recipes/crafting/copycat_vertical_step_from_conversion" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_road_smelting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_riveted_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_da_red" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_copper_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_pearl_brick_slab_stonecutting" | "minecraft:recipes/redstone/crimson_button" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_slashed_locometal" | "tconstruct:recipes/decorations/common/glass/pink_clear_stained_glass_pane" | "create:recipes/building_blocks/polished_cut_veridium_wall_from_stone_types_veridium_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_black" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_copper_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/tiled_blue_brick_wall_from_corner_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_corner_scarlet_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/long_blue_bricks_from_blue_bricks_stonecutting" | "createdeco:recipes/decorations/iron_facade_from_stonecutting" | "minecraft:recipes/combat/diamond_leggings" | "createdeco:recipes/building_blocks/corner_dean_brick_wall_from_corner_dean_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/black_slashed_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_blue" | "enderio:recipes/misc/basic_capacitor" | "create:recipes/misc/smelting/gold_ingot_from_crushed" | "create:hose_pulley_lava" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_white" | "tconstruct:recipes/redstone/world/wood/bloodshroom/button" | "tconstruct:recipes/building_blocks/world/wood/skyroot/stripped_log_to_wood" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_locometal_pillar" | "minecraft:recipes/building_blocks/cherry_slab" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_waxed_weathered_copper_stonecutting" | "ae2:recipes/misc/network/cables/smart_white" | "create:recipes/building_blocks/small_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_light_gray" | "tconstruct:recipes/misc/common/materials/amethyst_bronze_nugget_from_ingot" | "sophisticatedbackpacks:recipes/misc/everlasting_upgrade" | "minecraft:end/kill_dragon" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_gray" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_brass_wrapped_locometal_boiler" | "create:recipes/misc/smelting/scoria" | "railways:recipes/misc/crafting/fuel_tank" | "minecraft:recipes/decorations/stone_brick_wall" | "minecraft:recipes/redstone/dark_oak_fence_gate" | "minecraft:recipes/decorations/prismarine_wall_from_prismarine_stonecutting" | "minecraft:recipes/building_blocks/dye_light_gray_bed" | "createdeco:recipes/building_blocks/tiled_dusk_brick_wall_from_short_dusk_bricks_stonecutting" | "createdeco:recipes/decorations/andesite_sheet_metal" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_brick" | "create:recipes/building_blocks/copper_shingle_slab" | "minecraft:recipes/misc/blue_dye" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_white" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_ochrum_wall_from_stone_types_ochrum_stonecutting" | "copycats:recipes/crafting/copycat_slab" | "enderio:recipes/misc/energetic_alloy_ingot" | "createdeco:recipes/building_blocks/long_verdant_brick_wall_from_short_verdant_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_black" | "createdeco:recipes/building_blocks/umber_bricks_from_tiled_umber_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/analog_lever" | "ae2netanalyser:recipes/misc/analyser" | "enderio:recipes/building_blocks/recolor_clear_glass_d_purple" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_pink" | "minecraft:recipes/misc/cyan_dye" | "createdeco:recipes/building_blocks/mossy_scarlet_brick_stairs" | "tconstruct:recipes/redstone/smeltery/scorched/drain_retextured" | "create_connected:recipes/crafting/palettes/copycat_stairs_compat" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_long_pearl_bricks_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tiles_from_honeycomb" | "create:recipes/misc/blasting/silver_ingot_compat_thermal" | "minecraft:nether/create_beacon" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_light_blue" | "ae2:recipes/misc/network/blocks/spatial_io_port" | "createdeco:recipes/building_blocks/corner_blue_brick_wall_from_tiled_blue_bricks_stonecutting" | "enderio:recipes/misc/vibrant_photovoltaic_module" | "minecraft:recipes/building_blocks/crimson_stairs" | "enderio:recipes/building_blocks/silent_warped_pressure_plate" | "copycats:recipes/crafting/copycat_catwalk" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_slashed_locometal" | "createdeco:recipes/building_blocks/corner_blue_brick_stairs_from_tiled_blue_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/corner_verdant_bricks_from_verdant_bricks_stonecutting" | "minecraft:recipes/building_blocks/bamboo_mosaic_slab" | "minecraft:recipes/decorations/yellow_glazed_terracotta" | "railways:recipes/misc/stonecutting/palettes/cycling/white_riveted_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_blue" | "ae2:recipes/misc/shaped/walls/smooth_quartz_block" | "create:recipes/misc/crafting/logistics/redstone_link" | "ae2:recipes/misc/network/parts/storage_bus" | "sophisticatedbackpacks:recipes/misc/auto_smelting_upgrade" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_lime" | "ae2:recipes/misc/block_cutter/slabs/chiseled_quartz_slab" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_long_umber_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/cart_assembler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_locometal_pillar" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_green" | "createdeco:recipes/building_blocks/dean_brick_wall_from_short_dean_bricks_stonecutting" | "create:recipes/building_blocks/exposed_copper_shingle_stairs_from_exposed_copper_shingles_stonecutting" | "create:recipes/misc/crafting/kinetics/controller_rail" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_blackstone_stonecutting" | "expatternprovider:recipes/misc/wireless_tool" | "create:recipes/building_blocks/small_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/redstone/dark_oak_trapdoor" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_tiled_pearl_brick_stairs_stonecutting" | "create:recipes/building_blocks/tiled_glass_pane" | "enderio:recipes/building_blocks/recolor_clear_glass_em_pink" | "createdeco:recipes/building_blocks/dusk_brick_wall" | "createdeco:recipes/decorations/green_brass_lamp" | "enderio:recipes/misc/wired_charger" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_flat_riveted_locometal" | "createdeco:recipes/decorations/industrial_iron_coinstack" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_plated_locometal" | "createdeco:recipes/building_blocks/short_dean_brick_wall" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/misc/book" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_gray" | "createdeco:recipes/building_blocks/long_red_brick_wall_from_tiled_red_bricks_stonecutting" | "create:recipes/building_blocks/small_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_seething" | "create:recipes/building_blocks/crafting/kinetics/brown_seat" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_brass_wrapped_locometal" | "minecraft:recipes/misc/dune_armor_trim_smithing_template_smithing_trim" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_long_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_corner_verdant_brick_stairs_stonecutting" | "minecraft:recipes/building_blocks/brown_stained_glass" | "createdeco:recipes/building_blocks/tiled_verdant_brick_wall_from_long_verdant_bricks_stonecutting" | "ae2:recipes/misc/block_cutter/walls/smooth_sky_stone_wall" | "minecraft:recipes/decorations/brown_carpet" | "createdeco:recipes/decorations/zinc_ladder_from_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_lime" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_long_dean_brick_stairs_stonecutting" | "minecraft:recipes/combat/netherite_sword_smithing" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_corner_verdant_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/long_dusk_brick_wall_from_dusk_bricks_stonecutting" | "expatternprovider:recipes/misc/ex_inscriber" | "create:pulley_maxed" | "railways:recipes/misc/crafting/palettes/wrapping/red_brass_wrapped_locometal" | "create:recipes/building_blocks/veridium_from_stone_types_veridium_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/short_red_brick_slab_from_tiled_red_brick_slab_stonecutting" | "minecraft:recipes/misc/diamond" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_copper_wrapped_locometal" | "minecraft:recipes/food/cooked_chicken" | "create:recipes/building_blocks/small_veridium_bricks_from_stone_types_veridium_stonecutting" | "ae2:recipes/misc/network/cells/fluid_storage_cell_4k_storage" | "create:chocolate_bucket" | "create:recipes/building_blocks/asurine_from_stone_types_asurine_stonecutting" | "tconstruct:tools/modified" | "createdeco:recipes/building_blocks/corner_blue_brick_stairs_from_blue_bricks_stonecutting" | "create:recipes/building_blocks/cut_deepslate_wall" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_light_blue" | "create:recipes/building_blocks/small_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "create:recipes/misc/crafting/kinetics/mysterious_cuckoo_clock" | "createdeco:recipes/building_blocks/short_red_brick_stairs" | "tconstruct:recipes/misc/smeltery/red_sand_cast" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_light_blue" | "create:recipes/building_blocks/cut_granite_brick_wall_from_stone_types_granite_stonecutting" | "create:recipes/building_blocks/cut_asurine_stairs_from_stone_types_asurine_stonecutting" | "create:recipes/building_blocks/small_andesite_brick_stairs" | "ae2:recipes/misc/block_cutter/slabs/fluix_slab" | "expatternprovider:recipes/misc/circuit_cutter" | "minecraft:recipes/building_blocks/brown_concrete_powder" | "minecraft:end/levitate" | "create:recipes/misc/blasting/tin_ingot_compat_thermal" | "ae2:recipes/misc/decorative/certus_quartz_pillar_from_stonecutting" | "ae2:recipes/misc/materials/cardcrafting" | "minecraft:recipes/building_blocks/cracked_stone_bricks" | "enderio:recipes/misc/infinity_rod" | "createdeco:recipes/decorations/industrial_iron_catwalk_railing_from_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_short_verdant_brick_stairs_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_a_yellow" | "create:recipes/building_blocks/small_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "create:recipes/building_blocks/cut_dripstone_brick_wall" | "createdeco:recipes/decorations/white_shipping_container_from_dyeing_vaults" | "minecraft:recipes/building_blocks/stone_brick_stairs_from_stone_bricks_stonecutting" | "tconstruct:recipes/combat/tools/armor/travelers_shield" | "createdeco:recipes/building_blocks/mossy_verdant_brick_wall_from_mossy_verdant_bricks_stonecutting" | "enchantinginfuser:recipes/decorations/advanced_enchanting_infuser" | "createdeco:recipes/decorations/brass_hull_from_stonecutting" | "create:recipes/misc/crafting/kinetics/track_station" | "minecraft:recipes/building_blocks/light_blue_concrete_powder" | "create:recipes/building_blocks/cut_diorite_wall" | "storagedrawers:recipes/storagedrawers/detached_drawer" | "minecraft:recipes/building_blocks/glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_brass_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_corner_umber_bricks_stonecutting" | "create:cardboard" | "chiselsandbits:recipes/tools/measuring_tape" | "enderio:recipes/misc/copper_ingot_from_smelting" | "create:recipes/building_blocks/crafting/logistics/magenta_table_cloth" | "create_connected:root" | "createdeco:recipes/building_blocks/tiled_pearl_bricks_from_corner_pearl_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_green" | "ae2:recipes/misc/network/cables/dense_smart_red" | "ae2:main/fluix" | "minecraft:recipes/transportation/minecart" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_corner_verdant_bricks_stonecutting" | "create:andesite_casing" | "create:recipes/building_blocks/crafting/kinetics/gray_seat" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_magenta" | "createdeco:recipes/building_blocks/short_dean_brick_wall_from_short_dean_bricks_stonecutting" | "ae2:recipes/misc/network/cables/covered_black" | "tconstruct:recipes/food/gadgets/cake/blood" | "minecraft:recipes/tools/iron_hoe" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_polished_deepslate_stonecutting" | "tconstruct:recipes/building_blocks/common/glass/pink_clear_stained_glass" | "minecraft:recipes/misc/bowl" | "create:recipes/building_blocks/polished_cut_granite_stairs_from_stone_types_granite_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_black" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_riveted_locometal" | "minecraft:recipes/building_blocks/dye_orange_carpet" | "ae2:recipes/misc/tools/nether_quartz_sword" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_yellow" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_crafting" | "create:recipes/building_blocks/crafting/kinetics/white_seat_from_other_seat" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_yellow" | "minecraft:recipes/tools/clock" | "tconstruct:foundry/blaze" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_long_verdant_bricks_stonecutting" | "ae2:recipes/misc/network/cells/item_storage_cell_4k_storage" | "createdeco:recipes/building_blocks/short_umber_bricks_from_umber_bricks_stonecutting" | "minecraft:recipes/decorations/red_glazed_terracotta" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_cyan" | "minecraft:adventure/whos_the_pillager_now" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_purple" | "create:recipes/building_blocks/small_asurine_bricks_from_stone_types_asurine_stonecutting" | "enderio:recipes/misc/redstone_filter_base" | "create:recipes/building_blocks/cut_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "minecraft:recipes/food/baked_potato" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_locometal_pillar" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_tiled_scarlet_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_riveted_locometal" | "minecraft:recipes/decorations/green_banner" | "create:recipes/building_blocks/cherry_window_pane" | "create_connected:recipes/crafting/kinetics/redstone_link_wildcard" | "create:recipes/misc/smelting/silver_ingot_compat_oreganized" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_corner_dusk_brick_stairs_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_nuggets" | "tconstruct:recipes/building_blocks/common/glass/white_clear_stained_glass" | "createdeco:recipes/building_blocks/corner_verdant_brick_wall_from_verdant_bricks_stonecutting" | "create:recipes/building_blocks/cut_scorchia_bricks_from_stone_types_scorchia_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_magenta" | "createdeco:recipes/decorations/gray_shipping_container_from_dyeing_vaults" | "create:recipes/building_blocks/polished_cut_crimsite_from_stone_types_crimsite_stonecutting" | "createdeco:recipes/building_blocks/short_dusk_brick_wall_from_corner_dusk_brick_wall_stonecutting" | "create_connected:recipes/crafting/kinetics/six_way_gearbox_from_conversion" | "create:recipes/building_blocks/cut_deepslate_brick_wall" | "minecraft:recipes/misc/wayfinder_armor_trim_smithing_template" | "create:recipes/building_blocks/layered_granite_from_stone_types_granite_stonecutting" | "railways:recipes/misc/crafting/track_coupler" | "createdeco:recipes/building_blocks/tiled_dean_brick_wall_from_dean_brick_wall_stonecutting" | "storagedrawers:recipes/storagedrawers/personal_key" | "createdeco:recipes/misc/netherite_nugget_from_netherite_ingot" | "create:anvil_plough" | "ae2:main/ioport" | "createdeco:recipes/building_blocks/cracked_blue_bricks_from_blue_bricks_smelting" | "minecraft:recipes/building_blocks/bricks" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_light_gray" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_fence" | "createdeco:recipes/building_blocks/long_scarlet_brick_wall_from_scarlet_bricks_stonecutting" | "minecraft:recipes/decorations/painting" | "create:stressometer" | "tconstruct:recipes/building_blocks/common/slime/ender/congealed" | "minecraft:recipes/building_blocks/waxed_cut_copper" | "copycats:recipes/crafting/copycat_stacked_half_layer" | "ae2:recipes/misc/tools/fluix_hoe" | "enderio:recipes/building_blocks/recolor_clear_glass_np_yellow" | "minecraft:recipes/combat/arrow" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_locometal_pillar" | "ae2:recipes/misc/network/blocks/spatial_anchor" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_corner_scarlet_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_tiled_blue_brick_stairs_stonecutting" | "tconstruct:recipes/redstone/smeltery/scorched/fuel_tank" | "create_factory_logistics:recipes/misc/network_link" | "createdeco:recipes/building_blocks/corner_red_brick_wall_from_long_red_brick_wall_stonecutting" | "sophisticatedbackpacks:recipes/misc/chipped/alchemy_bench_upgrade" | "railways:recipes/misc/crafting/palettes/wrapping/cyan_brass_wrapped_locometal" | "create:recipes/building_blocks/polished_cut_veridium_slab_recycling" | "minecraft:recipes/building_blocks/polished_deepslate_stairs_from_polished_deepslate_stonecutting" | "minecraft:recipes/misc/vex_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/redstone/acacia_trapdoor" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_corner_pearl_brick_stairs_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tiles_from_honeycomb" | "tconstruct:recipes/redstone/common/glass/vanilla/daylight_detector" | "ae2:recipes/misc/network/blocks/energy_dense_energy_cell" | "create:recipes/building_blocks/polished_cut_andesite_slab" | "enderio:recipes/building_blocks/recolor_clear_glass_e_pink" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_purple" | "createdeco:recipes/building_blocks/mossy_pearl_brick_slab" | "create:train" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_long_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_tiled_blue_bricks_stonecutting" | "minecraft:recipes/food/cooked_salmon" | "minecraft:recipes/building_blocks/cherry_stairs" | "copycats:recipes/crafting/copycat_heavy_weighted_pressure_plate" | "expatternprovider:recipes/misc/assembler_matrix_crafter" | "create_connected:recipes/crafting/kinetics/encased_chain_cogwheel" | "createdeco:recipes/building_blocks/short_scarlet_bricks_from_tiled_scarlet_bricks_stonecutting" | "create:recipes/building_blocks/small_tuff_brick_stairs" | "ae2:recipes/misc/network/cables/smart_red" | "tconstruct:recipes/decorations/common/glass/blue_clear_stained_glass_pane" | "createdeco:recipes/building_blocks/umber_brick_wall_from_corner_umber_bricks_stonecutting" | "createdeco:recipes/decorations/pink_placard_from_dyeing" | "copycats:recipes/crafting/copycat_stone_button" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_magenta" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_copper_wrapped_locometal_boiler" | "enderio:recipes/misc/pulsating_alloy_nugget_to_ingot" | "createdeco:recipes/building_blocks/corner_dean_brick_wall_from_short_dean_brick_wall_stonecutting" | "createdeco:recipes/decorations/red_iron_lamp" | "createdeco:recipes/building_blocks/short_scarlet_bricks_from_long_scarlet_bricks_stonecutting" | "create:recipes/building_blocks/cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_slashed_locometal" | "createdeco:recipes/building_blocks/tiled_pearl_bricks_from_short_pearl_bricks_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_wall_stonecutter" | "createdeco:recipes/building_blocks/industrial_iron_window" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_green" | "minecraft:recipes/building_blocks/red_nether_brick_stairs_from_red_nether_bricks_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/orange_seat" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_corner_umber_brick_stairs_stonecutting" | "chiselsandbits:recipes/tools/modification_table" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_red" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_blue" | "createdeco:recipes/building_blocks/tiled_red_brick_slab_from_short_red_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_pink" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_corner_dean_brick_slab_stonecutting" | "create:recipes/building_blocks/weathered_copper_tile_stairs" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_red" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_riveted_locometal" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingles_from_honeycomb" | "minecraft:recipes/building_blocks/dye_cyan_wool" | "ae2:recipes/misc/tools/portable_item_cell_16k" | "minecraft:recipes/decorations/andesite_wall_from_andesite_stonecutting" | "tconstruct:recipes/building_blocks/common/slime/earth/congealed" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_black" | "minecraft:recipes/building_blocks/waxed_cut_copper_from_honeycomb" | "minecraft:recipes/building_blocks/nether_brick_stairs" | "create:recipes/building_blocks/cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "createdeco:recipes/decorations/gold_coin" | "expatternprovider:recipes/misc/ei" | "tconstruct:recipes/decorations/common/copper_platform_waxing_exposed" | "minecraft:recipes/building_blocks/smooth_red_sandstone_slab" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_brown" | "tconstruct:recipes/decorations/common/firewood/blazewood_fence" | "ae2:recipes/misc/shaped/walls/quartz_block" | "create:brass_casing" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_tiled_scarlet_bricks_stonecutting" | "copycats:recipes/crafting/copycat_corner_slice" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_light_blue" | "enderio:recipes/building_blocks/recolor_fused_quartz_gray" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_corner_verdant_brick_stairs_stonecutting" | "minecraft:recipes/tools/fishing_rod" | "createdeco:recipes/building_blocks/long_red_brick_stairs_from_long_red_bricks_stonecutting" | "create:recipes/building_blocks/crafting/logistics/pink_postbox_from_other_postbox" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_verdant_brick_slab_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_slashed_locometal" | "createdeco:recipes/building_blocks/tiled_dusk_bricks_from_dusk_bricks_stonecutting" | "create:recipes/building_blocks/copper_tile_stairs_from_copper_tiles_stonecutting" | "minecraft:recipes/building_blocks/chiseled_deepslate_from_cobbled_deepslate_stonecutting" | "create:recipes/building_blocks/layered_tuff_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/chiseled_stone_bricks" | "minecraft:recipes/building_blocks/nether_brick_slab" | "create:recipes/building_blocks/cut_granite_slab" | "minecraft:recipes/misc/pumpkin_seeds" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_brass_wrapped_locometal" | "createdeco:recipes/building_blocks/corner_verdant_brick_slab_from_tiled_verdant_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/mechanical_bearing" | "createdeco:recipes/building_blocks/corner_umber_brick_stairs_from_short_umber_bricks_stonecutting" | "create:cross_streams" | "minecraft:recipes/decorations/mud_brick_wall" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_copper_wrapped_locometal_boiler" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_black" | "enderio:recipes/building_blocks/recolor_clear_glass_d_cyan" | "enderio:recipes/building_blocks/recolor_clear_glass_orange" | "minecraft:recipes/building_blocks/red_sandstone" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_flat_riveted_locometal" | "minecraft:husbandry/tadpole_in_a_bucket" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_slashed_locometal" | "minecraft:recipes/redstone/dark_oak_button" | "ae2:recipes/misc/smelting/silicon_from_certus_quartz_dust" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tile_stairs_from_honeycomb" | "createdeco:recipes/decorations/copper_catwalk_forge" | "createdeco:recipes/building_blocks/long_blue_bricks_from_tiled_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_bricks_from_corner_dean_bricks_stonecutting" | "minecraft:recipes/decorations/beehive" | "createdeco:recipes/building_blocks/blue_bricks" | "minecraft:recipes/tools/netherite_hoe_smithing" | "copycats:recipes/crafting/copycat_door" | "createdeco:recipes/building_blocks/short_verdant_bricks_from_long_verdant_bricks_stonecutting" | "minecraft:recipes/food/cooked_rabbit_from_smoking" | "createdeco:recipes/decorations/yellow_shipping_container" | "create:recipes/misc/crafting/kinetics/train_door" | "ae2:recipes/misc/shaped/slabs/quartz_block" | "minecraft:recipes/building_blocks/nether_wart_block" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_tiled_pearl_bricks_stonecutting" | "enderio:recipes/misc/vibrant_alloy_block" | "create:recipes/building_blocks/cut_deepslate_slab_recycling" | "minecraft:recipes/building_blocks/dye_pink_wool" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_brass_wrapped_locometal_boiler" | "ae2:recipes/misc/network/cells/fluid_storage_cell_256k_storage" | "ae2:recipes/misc/network/cables/dense_covered_black" | "minecraft:recipes/decorations/cobbled_deepslate_wall_from_cobbled_deepslate_stonecutting" | "create:recipes/building_blocks/andesite_from_stone_types_andesite_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_scarlet_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_gray" | "createdeco:recipes/building_blocks/blue_brick_slab_from_tiled_blue_brick_slab_stonecutting" | "createdeco:recipes/decorations/decal_top_right" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_brown" | "ae2:recipes/misc/network/blocks/crystal_processing_charger" | "minecraft:recipes/building_blocks/stripped_birch_wood" | "create:recipes/misc/crafting/schematics/schematic_and_quill" | "create:recipes/building_blocks/cut_andesite_from_stone_types_andesite_stonecutting" | "create:windmill" | "createdeco:recipes/decorations/iron_support_wedge_from_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_short_scarlet_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/plated_locometal" | "minecraft:recipes/building_blocks/smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting" | "ae2:recipes/misc/network/cables/dense_covered_cyan" | "ae2:recipes/misc/shaped/stairs/chiseled_quartz_block" | "minecraft:recipes/building_blocks/prismarine_brick_stairs" | "minecraft:recipes/decorations/prismarine_wall" | "create:recipes/misc/crafting/kinetics/linear_chassis_from_conversion" | "createdeco:recipes/building_blocks/dusk_brick_wall_from_corner_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_corner_dean_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_yellow" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_copper_wrapped_locometal_boiler" | "minecraft:recipes/transportation/acacia_chest_boat" | "create_connected:kinetic_battery" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/cyan_copper_wrapped_locometal" | "create_connected:recipes/crafting/palettes/copycat_step_from_conversion" | "enderio:recipes/building_blocks/recolor_clear_glass_np_pink" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_long_dusk_bricks_stonecutting" | "minecraft:recipes/decorations/white_candle" | "createdeco:recipes/building_blocks/short_red_brick_wall_from_corner_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/verdant_bricks_from_tiled_verdant_bricks_stonecutting" | "minecraft:recipes/combat/turtle_helmet" | "minecraft:recipes/building_blocks/mud_brick_stairs_from_mud_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_dusk_brick_wall_from_short_dusk_brick_wall_stonecutting" | "tconstruct:recipes/redstone/world/wood/enderbark/button" | "minecraft:recipes/building_blocks/oak_stairs" | "enderio:recipes/building_blocks/recolor_clear_glass_e_orange" | "minecraft:recipes/building_blocks/polished_andesite_slab_from_andesite_stonecutting" | "createdeco:recipes/decorations/blue_copper_lamp" | "create:recipes/building_blocks/copper_shingles_from_ingots_copper_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_brown" | "sophisticatedbackpacks:recipes/misc/smithing_upgrade" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_white" | "createdeco:recipes/building_blocks/corner_red_brick_wall_from_tiled_red_bricks_stonecutting" | "create:recipes/building_blocks/weathered_iron_window" | "create_connected:recipes/crafting/palettes/copycat_beam_compat" | "create:recipes/building_blocks/crafting/kinetics/cyan_seat_from_other_seat" | "create:recipes/misc/crafting/kinetics/fluid_pipe" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_blue_bricks_stonecutting" | "storagedrawers:recipes/storagedrawers/warped_trim" | "create:recipes/building_blocks/polished_cut_crimsite_stairs" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_withering" | "ae2:recipes/misc/network/cables/glass_light_gray" | "minecraft:recipes/misc/netherite_scrap" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs" | "minecraft:story/enchant_item" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_flat_slashed_locometal" | "createdeco:recipes/building_blocks/corner_dean_bricks_from_long_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_short_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_dusk_brick_wall_from_corner_dusk_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_brass_wrapped_locometal" | "create:recipes/building_blocks/cut_tuff_stairs" | "ae2:recipes/misc/tools/network_tool" | "create_connected:recipes/crafting/palettes/copycat_fence_gate_compat" | "minecraft:recipes/decorations/chain" | "createdeco:recipes/decorations/blue_placard_from_dyeing" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_locometal_boiler" | "create:recipes/building_blocks/cut_scoria_from_stone_types_scoria_stonecutting" | "createdeco:recipes/building_blocks/long_pearl_brick_wall_from_short_pearl_bricks_stonecutting" | "minecraft:recipes/decorations/oak_fence" | "storagedrawers:recipes/storagedrawers/jungle_trim" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_red" | "create:recipes/building_blocks/ochrum_from_stone_types_ochrum_stonecutting" | "enderio:recipes/tools/cold_fire_igniter" | "createdeco:recipes/building_blocks/corner_red_brick_wall_from_tiled_red_brick_wall_stonecutting" | "tconstruct:recipes/redstone/world/wood/greenheart/trapdoor" | "createdeco:recipes/building_blocks/long_umber_brick_wall_from_tiled_umber_brick_wall_stonecutting" | "minecraft:recipes/redstone/mangrove_door" | "createdeco:recipes/building_blocks/tiled_red_brick_slab_from_long_red_bricks_stonecutting" | "create:display_board_0" | "minecraft:recipes/redstone/redstone_from_smelting_deepslate_redstone_ore" | "create:steam_whistle" | "minecraft:recipes/food/cooked_porkchop_from_campfire_cooking" | "createdeco:recipes/building_blocks/long_pearl_brick_wall_from_long_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_tiled_dean_bricks_stonecutting" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_smoking" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_blue_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_corner_umber_brick_stairs_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_enp_brown" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_yellow" | "enderio:recipes/misc/vibrant_capacitor_bank_upgrade" | "tconstruct:tools/perfect_aim" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/planks" | "minecraft:recipes/decorations/light_blue_stained_glass_pane" | "minecraft:adventure/spyglass_at_parrot" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_tiled_scarlet_bricks_stonecutting" | "create:recipes/misc/crafting/logistics/white_table_cloth_clear" | "create:recipes/building_blocks/small_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_white" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_plated_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_flat_slashed_locometal" | "ae2:recipes/misc/network/blocks/interfaces_interface_part" | "create:recipes/misc/blasting/ingot_uranium_compat_immersiveengineering" | "createdeco:recipes/building_blocks/corner_verdant_bricks_from_short_verdant_bricks_stonecutting" | "enderio:recipes/building_blocks/pressurized_fluid_conduit" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_tiled_verdant_bricks_stonecutting" | "minecraft:recipes/decorations/end_stone_brick_wall" | "storagedrawers:recipes/storagedrawers/max_redstone_upgrade" | "createdeco:recipes/decorations/light_gray_shipping_container_from_dyeing_vaults" | "createdeco:recipes/building_blocks/corner_red_brick_wall" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_plated_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_pink" | "tconstruct:recipes/redstone/smeltery/seared/seared_casting_tank" | "minecraft:recipes/decorations/mangrove_hanging_sign" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_riveted_locometal" | "minecraft:recipes/decorations/black_banner" | "storagedrawers:recipes/storagedrawers/mangrove_drawers" | "create:recipes/building_blocks/small_granite_brick_wall_from_stone_types_granite_stonecutting" | "storagedrawers:recipes/storagedrawers/birch_drawers" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_black" | "create:recipes/misc/crafting/logistics/stock_link" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_iron_wrapped_locometal" | "create:recipes/misc/blasting/ingot_uranium_compat_ic2" | "createdeco:recipes/building_blocks/tiled_scarlet_bricks_from_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_long_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/sandstone_stairs_from_sandstone_stonecutting" | "ae2:recipes/misc/tools/paintballs_cyan" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_blue" | "enderio:recipes/misc/stick" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_slashed_locometal" | "createdeco:recipes/building_blocks/dean_brick_wall_from_tiled_dean_bricks_stonecutting" | "tconstruct:recipes/redstone/smeltery/scorched/chute" | "createdeco:recipes/building_blocks/long_red_brick_wall_from_short_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_scarlet_brick_wall_from_long_scarlet_brick_wall_stonecutting" | "ae2:recipes/misc/tools/paintballs_lumen_orange" | "enderio:recipes/building_blocks/recolor_clear_glass_na_orange" | "createdeco:recipes/building_blocks/mossy_blue_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_iron_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/long_pearl_brick_slab" | "create:recipes/building_blocks/cut_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "enderio:recipes/redstone/resetting_lever_thirty_inv" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_iron_wrapped_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_red" | "sophisticatedbackpacks:recipes/misc/compacting_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_brass_wrapped_locometal_boiler" | "tconstruct:recipes/building_blocks/world/wood/skyroot/slab" | "tconstruct:recipes/misc/common/materials/pig_iron_nugget_from_ingot" | "minecraft:recipes/decorations/light_blue_banner" | "minecraft:recipes/decorations/smithing_table" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_long_scarlet_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/cut_sandstone_slab" | "createdeco:recipes/decorations/pink_shipping_container" | "createdeco:recipes/building_blocks/tiled_red_brick_wall_from_tiled_red_bricks_stonecutting" | "ae2:recipes/misc/decorative/quartz_fixture_from_anchors" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_corner_dean_bricks_stonecutting" | "createdeco:recipes/decorations/purple_placard" | "create:recipes/building_blocks/oxidized_copper_tile_stairs" | "tconstruct:recipes/decorations/common/glass/green_clear_stained_glass_pane_from_panes" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_short_verdant_bricks_stonecutting" | "minecraft:recipes/transportation/tnt_minecart" | "enderio:recipes/building_blocks/recolor_clear_glass_na_red" | "ae2:recipes/misc/tools/certus_quartz_wrench" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_magenta" | "ae2:recipes/misc/tools/nether_quartz_wrench" | "create:crusher_maxed_0000" | "enderio:recipes/misc/dark_steel_grinding_ball" | "create:recipes/misc/smelting/copper_ingot_from_crushed" | "create:recipes/building_blocks/small_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_locometal_smokebox" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs_from_oxidized_cut_copper_stonecutting" | "ae2:recipes/misc/network/cables/covered_magenta" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs_from_corner_red_bricks_stonecutting" | "createdeco:recipes/decorations/brass_support_wedge_from_stonecutting" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_long_umber_brick_slab_stonecutting" | "storagedrawers:recipes/storagedrawers/controller" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_purple" | "tconstruct:recipes/building_blocks/common/firewood/nahuatl_slab" | "create:recipes/building_blocks/polished_cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/brown_candle" | "tconstruct:recipes/decorations/common/glass/cyan_clear_stained_glass_pane_from_panes" | "minecraft:husbandry/wax_on" | "minecraft:recipes/building_blocks/purple_terracotta" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_sanding" | "create:recipes/misc/crafting/logistics/light_gray_table_cloth_clear" | "createdeco:recipes/decorations/zinc_catwalk_from_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_lime" | "minecraft:adventure/play_jukebox_in_meadows" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_black" | "create:recipes/building_blocks/polished_cut_dripstone_stairs_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/misc/green_dye" | "createdeco:recipes/building_blocks/tiled_red_brick_wall_from_short_red_bricks_stonecutting" | "minecraft:recipes/building_blocks/dark_prismarine" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_flat_slashed_locometal" | "minecraft:adventure/hero_of_the_village" | "railways:recipes/misc/stonecutting/palettes/cycling/riveted_locometal" | "createdeco:recipes/decorations/black_shipping_container_from_dyeing_vaults" | "createdeco:recipes/building_blocks/cracked_verdant_bricks_from_verdant_bricks_smelting" | "minecraft:recipes/building_blocks/smooth_stone" | "create_connected:recipes/crafting/kinetics/vertical_six_way_gearbox_from_conversion" | "createdeco:recipes/building_blocks/corner_dean_brick_wall_from_long_dean_bricks_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_slab_recycling" | "create:recipes/misc/crafting/logistics/andesite_tunnel" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_green" | "minecraft:recipes/building_blocks/dye_pink_carpet" | "createdeco:recipes/decorations/industrial_iron_catwalk_forge" | "createdeco:recipes/building_blocks/tiled_dusk_brick_wall_from_tiled_dusk_bricks_stonecutting" | "copycats:recipes/crafting/copycat_box" | "enderio:recipes/misc/or_filter_from_nor_filter" | "enderio:recipes/misc/stone_gear_upgrade" | "create:recipes/building_blocks/crafting/logistics/light_gray_table_cloth_from_other_table_cloth" | "minecraft:recipes/building_blocks/packed_ice" | "expatternprovider:recipes/misc/epp_alt" | "ae2:recipes/misc/block_cutter/stairs/sky_stone_small_brick_stairs" | "createdeco:recipes/building_blocks/blue_brick_wall_from_tiled_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dusk_brick_wall_from_tiled_dusk_brick_wall_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_white" | "minecraft:recipes/building_blocks/quartz_stairs_from_quartz_block_stonecutting" | "createdeco:recipes/building_blocks/short_verdant_bricks_from_corner_verdant_bricks_stonecutting" | "enderio:recipes/misc/redstone_alloy_nugget" | "enderio:recipes/building_blocks/recolor_clear_glass_np_magenta" | "createdeco:recipes/building_blocks/corner_red_brick_wall_from_short_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_short_verdant_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_cyan" | "minecraft:recipes/building_blocks/deepslate_tiles" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_corner_dusk_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/warped_hyphae" | "enderio:recipes/building_blocks/recolor_clear_glass_ena_light_blue" | "minecraft:recipes/redstone/jungle_button" | "createdeco:recipes/building_blocks/long_blue_bricks_from_short_blue_bricks_stonecutting" | "createdeco:recipes/decorations/industrial_iron_mesh_fence_from_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_bricks_from_corner_verdant_bricks_stonecutting" | "storagedrawers:recipes/storagedrawers/bamboo_trim" | "enderio:recipes/building_blocks/recolor_clear_glass_dp_brown" | "railways:recipes/combat/dying_existing_cap_gray" | "create:recipes/building_blocks/crafting/kinetics/lime_seat_from_other_seat" | "createdeco:recipes/building_blocks/scarlet_bricks_from_corner_scarlet_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_em_black" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_flat_slashed_locometal" | "expatternprovider:recipes/misc/epp" | "tconstruct:recipes/redstone/smeltery/seared/faucet" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_pink" | "enderio:recipes/misc/redstone_counting_filter" | "createdeco:recipes/decorations/copper_catwalk_stairs_from_stonecutting" | "ae2:recipes/misc/network/wireless_booster" | "tconstruct:world/slimesuit" | "expatternprovider:recipes/misc/epa" | "sophisticatedbackpacks:recipes/misc/advanced_magnet_upgrade" | "enderio:recipes/building_blocks/end_steel_bars" | "minecraft:recipes/building_blocks/red_nether_bricks" | "ae2:recipes/misc/network/cables/dense_covered_white" | "minecraft:recipes/decorations/cyan_carpet" | "copycats:recipes/crafting/copycat_pane_from_conversion" | "tconstruct:recipes/decorations/common/gold_platform" | "minecraft:husbandry/root" | "create:recipes/building_blocks/cut_granite_bricks_from_stone_types_granite_stonecutting" | "tconstruct:recipes/tools/tools/building/ichor_staff" | "minecraft:recipes/transportation/birch_boat" | "tconstruct:smeltery/abilities" | "minecraft:recipes/building_blocks/cobbled_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_short_dean_bricks_stonecutting" | "ae2:recipes/misc/network/cables/dense_covered_orange" | "createdeco:recipes/building_blocks/short_red_brick_slab_from_corner_red_bricks_stonecutting" | "ae2:recipes/misc/network/cables/dense_covered_green" | "createdeco:recipes/building_blocks/long_scarlet_bricks_from_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_tiled_dean_brick_slab_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/purple_seat_from_other_seat" | "createdeco:recipes/building_blocks/long_verdant_brick_wall_from_short_verdant_brick_wall_stonecutting" | "minecraft:recipes/redstone/crimson_trapdoor" | "minecraft:recipes/decorations/green_glazed_terracotta" | "enderio:recipes/building_blocks/silent_oak_pressure_plate" | "create:recipes/misc/blasting/lead_ingot_compat_thermal" | "create:recipes/building_blocks/cut_ochrum_brick_stairs" | "enderio:recipes/building_blocks/recolor_clear_glass_em_white" | "createdeco:recipes/building_blocks/short_pearl_brick_wall_from_tiled_pearl_brick_wall_stonecutting" | "createdeco:recipes/decorations/andesite_support_wedge_from_stonecutting" | "ae2:recipes/misc/network/cables/dense_smart_pink" | "minecraft:adventure/trade" | "minecraft:recipes/building_blocks/deepslate" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_corner_blue_brick_stairs_stonecutting" | "minecraft:recipes/decorations/white_carpet" | "ae2:main/pattern_encoding_terminal" | "minecraft:recipes/transportation/cherry_chest_boat" | "tconstruct:recipes/building_blocks/world/wood/greenheart/log_to_wood" | "minecraft:recipes/building_blocks/dark_prismarine_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_flat_slashed_locometal" | "create:recipes/building_blocks/cut_scoria_slab" | "create:recipes/misc/smelting/glass_pane_from_tiled_glass_pane" | "minecraft:recipes/building_blocks/jack_o_lantern" | "minecraft:recipes/transportation/birch_chest_boat" | "minecraft:recipes/decorations/glass_pane" | "createdeco:recipes/decorations/brown_shipping_container" | "minecraft:recipes/decorations/purple_banner" | "createdeco:recipes/building_blocks/corner_dean_brick_slab" | "minecraft:recipes/building_blocks/magenta_stained_glass" | "create:recipes/building_blocks/crafting/logistics/purple_postbox" | "createdeco:recipes/building_blocks/long_dean_brick_wall_from_tiled_dean_brick_wall_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_light_gray" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_long_pearl_bricks_stonecutting" | "minecraft:recipes/transportation/oak_boat" | "create:recipes/decorations/brass_scaffolding_from_ingots_brass_stonecutting" | "ae2:recipes/misc/network/cables/dense_covered_magenta" | "railways:recipes/misc/crafting/smokestack_streamlined" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_plated_locometal" | "create:recipes/building_blocks/polished_cut_scorchia_stairs" | "createdeco:recipes/building_blocks/mossy_dean_brick_wall" | "tconstruct:recipes/redstone/smeltery/scorched/duct" | "create:recipes/building_blocks/small_granite_brick_wall" | "minecraft:recipes/building_blocks/smooth_stone_slab_from_smooth_stone_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_corner_dean_brick_slab_stonecutting" | "minecraft:recipes/decorations/deepslate_tile_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_em_green" | "createdeco:recipes/building_blocks/cracked_dean_brick_wall" | "enderio:recipes/building_blocks/recolor_clear_glass_light_gray" | "createdeco:recipes/building_blocks/verdant_brick_wall_from_verdant_bricks_stonecutting" | "minecraft:recipes/redstone/warped_button" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_riveted_locometal" | "minecraft:recipes/decorations/stone_brick_wall_from_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/red_nether_brick_stairs" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_light_gray" | "create:recipes/misc/crafting/kinetics/brass_door" | "createdeco:recipes/building_blocks/tiled_dean_brick_wall_from_short_dean_brick_wall_stonecutting" | "createdeco:recipes/decorations/yellow_brass_lamp" | "tconstruct:world/ender_island" | "minecraft:recipes/building_blocks/mossy_cobblestone_from_moss_block" | "botanypots:husbandry/get_hopper_pot" | "minecraft:recipes/redstone/acacia_fence_gate" | "minecraft:recipes/building_blocks/coal_block" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_iron_wrapped_locometal_boiler" | "storagedrawers:recipes/storagedrawers/spruce_drawers" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_honeycomb" | "railways:recipes/misc/crafting/palettes/wrapping/brass_wrapped_locometal" | "minecraft:recipes/building_blocks/spruce_slab" | "enderio:recipes/building_blocks/recolor_clear_glass_da_purple" | "minecraft:recipes/decorations/polished_blackstone_wall_from_blackstone_stonecutting" | "tconstruct:recipes/food/common/cheese_ingot_from_block" | "enderio:recipes/misc/crafter" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_dean_bricks_stonecutting" | "minecraft:recipes/decorations/white_stained_glass_pane_from_glass_pane" | "create:recipes/misc/crafting/kinetics/windmill_bearing" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_corner_verdant_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_blue_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_ochrum_from_stone_types_ochrum_stonecutting" | "createdeco:recipes/building_blocks/cracked_dusk_bricks_from_dusk_bricks_smelting" | "create:recipes/building_blocks/cut_asurine_bricks_from_stone_types_asurine_stonecutting" | "sophisticatedbackpacks:recipes/misc/advanced_filter_upgrade" | "minecraft:recipes/redstone/bamboo_door" | "minecraft:recipes/misc/shaper_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/cut_tuff_slab_recycling" | "create:recipes/misc/crafting/materials/sand_paper" | "create:recipes/building_blocks/layered_limestone_from_stone_types_limestone_stonecutting" | "createdeco:recipes/building_blocks/cracked_umber_brick_wall" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_long_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_tiled_umber_brick_slab_stonecutting" | "create:recipes/building_blocks/polished_cut_calcite_wall_from_stone_types_calcite_stonecutting" | "createdeco:recipes/building_blocks/mossy_verdant_brick_slab" | "minecraft:recipes/redstone/oak_button" | "create:recipes/misc/crafting/kinetics/basin" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_long_dean_brick_stairs_stonecutting" | "create:belt_funnel_kiss" | "create:recipes/building_blocks/dark_oak_window_pane" | "createdeco:recipes/building_blocks/corner_scarlet_brick_stairs" | "createdeco:recipes/building_blocks/cracked_pearl_brick_stairs" | "minecraft:recipes/misc/vex_armor_trim_smithing_template" | "create:recipes/building_blocks/cut_calcite_slab" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_scarlet_bricks_stonecutting" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone_from_blackstone_stonecutting" | "createdeco:recipes/decorations/iron_support" | "createdeco:recipes/building_blocks/tiled_dusk_bricks_from_long_dusk_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_locometal_smokebox" | "createdeco:recipes/decorations/andesite_bars_from_stonecutting" | "tconstruct:recipes/redstone/common/slime/sky/slimeblock" | "createdeco:recipes/building_blocks/short_red_bricks_from_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_wall" | "sophisticatedbackpacks:recipes/misc/inception_upgrade" | "minecraft:recipes/building_blocks/exposed_cut_copper" | "storagedrawers:recipes/storagedrawers/mangrove_trim" | "create:linked_controller" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_dusk_bricks_stonecutting" | "create:recipes/building_blocks/crafting/logistics/cyan_table_cloth_from_other_table_cloth" | "create:recipes/building_blocks/polished_cut_diorite_wall_from_stone_types_diorite_stonecutting" | "create:recipes/misc/crafting/materials/transmitter" | "minecraft:recipes/misc/diamond_from_blasting_deepslate_diamond_ore" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/small_calcite_brick_slab" | "enderio:recipes/misc/impulse_hopper" | "sophisticatedbackpacks:recipes/misc/stack_downgrade_tier_1" | "sophisticatedbackpacks:recipes/misc/stack_downgrade_tier_3" | "sophisticatedbackpacks:recipes/misc/stack_downgrade_tier_2" | "minecraft:recipes/building_blocks/dye_purple_bed" | "minecraft:recipes/redstone/jungle_fence_gate" | "createdeco:recipes/building_blocks/long_pearl_bricks_from_pearl_bricks_stonecutting" | "create:recipes/misc/crafting/materials/zinc_block_from_compacting" | "immersive_paintings:misc/glow_graffiti" | "expatternprovider:recipes/misc/oversize_interface_alt" | "minecraft:recipes/building_blocks/dye_light_gray_carpet" | "ae2:main/portable_cell" | "minecraft:recipes/redstone/warped_door" | "enderio:recipes/building_blocks/recolor_fused_quartz_p_cyan" | "enderio:recipes/building_blocks/recolor_clear_glass_a_light_blue" | "minecraft:recipes/decorations/dark_oak_fence" | "create:recipes/misc/crafting/logistics/andesite_funnel" | "create:recipes/building_blocks/crafting/kinetics/light_blue_seat_from_other_seat" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_brown" | "createdeco:recipes/building_blocks/blue_bricks_from_long_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_pearl_brick_wall_from_long_pearl_bricks_stonecutting" | "railways:recipes/misc/crafting/smokestack_caboosestyle" | "createdeco:recipes/building_blocks/tiled_verdant_bricks_from_verdant_bricks_stonecutting" | "createdeco:recipes/decorations/iron_hull" | "createdeco:recipes/building_blocks/mossy_scarlet_brick_slab" | "create:recipes/building_blocks/polished_cut_asurine_stairs" | "enderio:recipes/building_blocks/recolor_clear_glass_d_white" | "enderio:recipes/building_blocks/recolor_clear_glass_p_green" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_light_gray" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_purple" | "createdeco:recipes/building_blocks/pearl_brick_wall_from_pearl_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_e_red" | "createdeco:recipes/building_blocks/corner_pearl_brick_slab_from_short_pearl_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_locometal_pillar" | "create:recipes/building_blocks/polished_cut_limestone_slab_from_stone_types_limestone_stonecutting" | "copycats:recipes/crafting/copycat_slice" | "minecraft:recipes/redstone/observer" | "tconstruct:internal/starting_book" | "createdeco:recipes/building_blocks/corner_scarlet_brick_wall_from_long_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_iron_wrapped_locometal_boiler" | "tconstruct:recipes/redstone/world/wood/bloodshroom/pressure_plate" | "create:recipes/building_blocks/crafting/logistics/light_blue_table_cloth" | "enderio:recipes/redstone/resetting_lever_three_hundred_inv_from_prev" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_long_umber_brick_stairs_stonecutting" | "create:recipes/building_blocks/crafting/logistics/white_postbox_from_other_postbox" | "enderio:recipes/building_blocks/redstone_conduit" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_corner_dean_brick_stairs_stonecutting" | "minecraft:recipes/decorations/torch" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_long_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_iron_wrapped_locometal" | "create_connected:recipes/crafting/kinetics/linked_transmitter_from_conversion" | "createdeco:recipes/building_blocks/mossy_verdant_bricks_from_moss_block" | "create:recipes/building_blocks/crafting/logistics/white_table_cloth" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_brass_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/umber_brick_stairs" | "tconstruct:recipes/food/common/cheese_block_from_ingot" | "minecraft:recipes/building_blocks/dark_oak_planks" | "enderio:recipes/misc/soularium_grinding_ball" | "ae2:recipes/misc/tools/paintballs_light_gray" | "create:recipes/building_blocks/small_dripstone_brick_slab_recycling" | "minecraft:recipes/building_blocks/red_sandstone_stairs" | "create:recipes/building_blocks/crafting/logistics/magenta_postbox_from_other_postbox" | "create:recipes/misc/crafting/logistics/stockpile_switch" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_iron_wrapped_locometal_boiler" | "create:recipes/building_blocks/birch_window_pane" | "create:recipes/misc/crafting/kinetics/chain_conveyor" | "create:recipes/building_blocks/small_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "tconstruct:recipes/building_blocks/common/basalt_blast_furnace" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_light_blue" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_light_gray" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_flat_riveted_locometal" | "createdeco:recipes/building_blocks/mossy_scarlet_bricks_from_moss_block" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_riveted_locometal" | "create:recipes/building_blocks/polished_cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/polished_cut_andesite_slab_from_stone_types_andesite_stonecutting" | "createdeco:recipes/decorations/industrial_iron_mesh_fence" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_short_pearl_brick_stairs_stonecutting" | "minecraft:recipes/decorations/magenta_carpet" | "create:recipes/building_blocks/polished_cut_calcite_wall" | "tconstruct:recipes/building_blocks/world/wood/greenheart/planks" | "createdeco:recipes/building_blocks/tiled_pearl_brick_wall_from_tiled_pearl_bricks_stonecutting" | "tconstruct:tools/part_builder" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_gray" | "create:recipes/misc/crafting/materials/red_sand_paper" | "tconstruct:recipes/misc/common/materials/manyullyn_ingot_from_nuggets" | "enderio:recipes/building_blocks/recolor_clear_glass_em_brown" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs_from_short_red_brick_stairs_stonecutting" | "ae2:recipes/misc/network/cables/glass_purple" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_flat_riveted_locometal" | "minecraft:recipes/building_blocks/andesite_stairs_from_andesite_stonecutting" | "createdeco:recipes/decorations/light_gray_shipping_container" | "tconstruct:recipes/decorations/common/firewood/nahuatl_fence" | "enderio:recipes/building_blocks/recolor_clear_glass_m_light_gray" | "tconstruct:recipes/misc/common/slime/ender/slimeball_from_congealed" | "create:recipes/building_blocks/crafting/logistics/gray_table_cloth" | "create:recipes/misc/blasting/ingot_aluminum_compat_immersiveengineering" | "enderio:recipes/misc/copper_alloy_nugget_to_ingot" | "tconstruct:recipes/building_blocks/common/slime/earth/crystal_block" | "create:recipes/building_blocks/cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "ae2:recipes/misc/network/cables/covered_lime" | "enderio:recipes/building_blocks/recolor_fused_quartz_pink" | "createdeco:recipes/decorations/green_shipping_container_from_dyeing_vaults" | "tconstruct:recipes/decorations/world/wood/bloodshroom/fence" | "createdeco:recipes/building_blocks/long_dean_brick_wall_from_dean_brick_wall_stonecutting" | "minecraft:recipes/building_blocks/spruce_planks" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnp_purple" | "railways:recipes/misc/crafting/remote_lens" | "createdeco:recipes/decorations/magenta_placard" | "tconstruct:recipes/redstone/smeltery/seared/duct" | "minecraft:recipes/building_blocks/polished_diorite_slab" | "tconstruct:recipes/decorations/smeltery/seared/melter" | "create:train_crash" | "createdeco:recipes/building_blocks/cracked_dusk_brick_stairs" | "createdeco:recipes/building_blocks/long_dean_brick_wall_from_dean_bricks_stonecutting" | "tconstruct:recipes/redstone/smeltery/seared/fluid_cannon" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_pearl_bricks_stonecutting" | "createdeco:recipes/decorations/zinc_door" | "enderio:recipes/misc/advanced_capacitor_bank" | "tconstruct:world/clay_island" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_plated_locometal" | "ae2:recipes/misc/network/cables/covered_orange" | "createdeco:recipes/building_blocks/corner_verdant_bricks_from_tiled_verdant_bricks_stonecutting" | "ae2:recipes/misc/tools/certus_quartz_cutting_knife" | "create:recipes/misc/crafting/kinetics/sequenced_gearshift" | "extra_gauges:recipes/redstone/passive_gauge" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_corner_verdant_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_green" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_locometal_smokebox" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_deepslate_tiles_stonecutting" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_corner_dusk_brick_stairs_stonecutting" | "minecraft:recipes/misc/host_armor_trim_smithing_template" | "create:recipes/building_blocks/cut_ochrum_from_stone_types_ochrum_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_umber_brick_slab_stonecutting" | "ae2:main/recursive" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_short_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_slashed_locometal" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_corner_dusk_bricks_stonecutting" | "minecraft:recipes/misc/light_gray_dye_from_azure_bluet" | "storagedrawers:recipes/storagedrawers/redstone_upgrade" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_corner_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_stairs" | "enderio:recipes/building_blocks/recolor_clear_glass_m_blue" | "minecraft:recipes/building_blocks/smooth_quartz" | "ae2:recipes/misc/network/cables/dense_smart_black" | "enderio:recipes/building_blocks/collision_token_clear_glass_p" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_light_gray" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_flat_riveted_locometal" | "create:recipes/building_blocks/polished_cut_limestone_slab" | "storagedrawers:recipes/storagedrawers/spruce_trim" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_brass_wrapped_locometal_boiler" | "enderio:recipes/building_blocks/collision_token_clear_glass_m" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_long_blue_brick_slab_stonecutting" | "create:recipes/building_blocks/small_scoria_brick_wall" | "tconstruct:recipes/combat/gadgets/shuriken/quartz_shuriken" | "enderio:recipes/building_blocks/collision_token_clear_glass_a" | "minecraft:recipes/decorations/blue_stained_glass_pane" | "createdeco:recipes/building_blocks/tiled_blue_bricks_from_short_blue_bricks_stonecutting" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_waxed_exposed_copper_stonecutting" | "ae2:recipes/misc/network/cables/covered_blue" | "enderio:recipes/building_blocks/recolor_clear_glass_na_black" | "createdeco:recipes/building_blocks/andesite_window" | "minecraft:adventure/craft_decorated_pot_using_only_sherds" | "createdeco:recipes/building_blocks/tiled_pearl_brick_wall_from_pearl_brick_wall_stonecutting" | "railways:recipes/combat/dying_existing_cap_green" | "create:recipes/misc/crafting/logistics/factory_gauge" | "createdeco:recipes/building_blocks/short_blue_brick_wall_from_tiled_blue_bricks_stonecutting" | "create:mechanical_arm" | "minecraft:recipes/decorations/acacia_hanging_sign" | "create:recipes/misc/crafting/logistics/factory_gauge_clear" | "tconstruct:world/tinkers_gadgetry" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_long_scarlet_brick_stairs_stonecutting" | "minecraft:recipes/building_blocks/dye_gray_carpet" | "create:recipes/misc/crafting/materials/brass_nugget_from_decompacting" | "create:recipes/misc/crafting/kinetics/item_drain" | "create:recipes/building_blocks/small_diorite_brick_stairs" | "createdeco:recipes/building_blocks/corner_scarlet_brick_stairs_from_corner_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_short_verdant_bricks_stonecutting" | "create:recipes/building_blocks/rose_quartz_block_from_rose_quartz_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_magenta" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_blue" | "createdeco:recipes/building_blocks/cracked_umber_brick_wall_from_cracked_umber_bricks_stonecutting" | "minecraft:recipes/decorations/red_nether_brick_wall_from_red_nether_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_flat_slashed_locometal" | "create:recipes/building_blocks/cut_asurine_wall" | "enderio:recipes/building_blocks/recolor_clear_glass_p_black" | "minecraft:recipes/building_blocks/blackstone_slab_from_blackstone_stonecutting" | "enderio:recipes/misc/black_paper" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_locometal_pillar" | "createdeco:recipes/building_blocks/short_scarlet_bricks_from_corner_scarlet_bricks_stonecutting" | "minecraft:recipes/redstone/cherry_fence_gate" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs" | "createdeco:recipes/building_blocks/short_umber_brick_slab" | "create:recipes/misc/crafting/kinetics/mechanical_mixer" | "minecraft:recipes/building_blocks/chiseled_red_sandstone_from_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/jungle_planks" | "minecraft:recipes/building_blocks/chiseled_quartz_block" | "ae2:recipes/misc/network/cables/dense_smart_green" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_blue" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_purple" | "minecraft:recipes/redstone/bamboo_trapdoor" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_long_scarlet_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/framed_glass_trapdoor" | "railways:recipes/misc/stonecutting/palettes/cycling/locometal_pillar" | "enderio:recipes/building_blocks/recolor_fused_quartz_dm_pink" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_tiled_verdant_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_wall_from_tiled_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_umber_brick_wall_from_corner_umber_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_deepslate_wall" | "create:recipes/building_blocks/crafting/kinetics/black_seat" | "create:recipes/decorations/andesite_ladder_from_andesite_alloy_stonecutting" | "create:packager" | "create:recipes/combat/crafting/appliances/netherite_diving_boots_from_netherite" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_ladder" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_locometal_smokebox" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_waxed_weathered_copper_stonecutting" | "enderio:recipes/building_blocks/silent_heavy_weighted_pressure_plate" | "createdeco:recipes/decorations/copper_bars_overlay_from_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_np_brown" | "createdeco:recipes/decorations/black_placard_from_dyeing" | "create:recipes/misc/crafting/kinetics/red_valve_handle_from_other_valve_handle" | "minecraft:recipes/building_blocks/dye_light_blue_wool" | "createdeco:recipes/building_blocks/tiled_pearl_brick_wall_from_long_pearl_brick_wall_stonecutting" | "createdeco:recipes/decorations/black_shipping_container" | "railways:recipes/misc/crafting/palettes/wrapping/yellow_copper_wrapped_locometal" | "minecraft:recipes/redstone/sticky_piston" | "tconstruct:recipes/decorations/tables/tinkers_forge" | "createdeco:recipes/building_blocks/short_dean_brick_stairs" | "tconstruct:recipes/building_blocks/common/firewood/blazewood_stairs" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_cobbled_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_iron_wrapped_locometal" | "createdeco:recipes/building_blocks/long_umber_brick_wall_from_short_umber_brick_wall_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_light_gray" | "create:recipes/building_blocks/polished_cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "minecraft:adventure/kill_mob_near_sculk_catalyst" | "minecraft:recipes/building_blocks/end_stone_brick_slab_from_end_stone_brick_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_copper_wrapped_locometal" | "enderio:recipes/misc/conductive_alloy_nugget" | "create:recipes/misc/crafting/logistics/packager_from_conversion" | "createdeco:recipes/building_blocks/blue_brick_wall" | "minecraft:recipes/building_blocks/waxed_oxidized_copper_from_honeycomb" | "tconstruct:recipes/building_blocks/world/wood/greenheart/stairs" | "createdeco:recipes/building_blocks/corner_dean_brick_wall_from_dean_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_yellow" | "create:recipes/building_blocks/small_andesite_brick_slab" | "create:recipes/building_blocks/exposed_copper_tile_slab_from_exposed_copper_tiles_stonecutting" | "createdeco:recipes/building_blocks/short_verdant_brick_wall" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_corner_pearl_brick_stairs_stonecutting" | "minecraft:recipes/decorations/mangrove_fence" | "enderio:recipes/misc/vibrant_alloy_grinding_ball" | "create:recipes/misc/crafting/kinetics/fluid_tank" | "createdeco:recipes/building_blocks/long_dusk_bricks_from_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_tiled_scarlet_bricks_stonecutting" | "create_connected:recipes/crafting/palettes/copycat_block_compat" | "chiselsandbits:recipes/tools/wrench" | "createdeco:recipes/decorations/locked_industrial_iron_door" | "minecraft:recipes/food/cooked_mutton" | "railways:recipes/misc/crafting/palettes/wrapping/pink_iron_wrapped_locometal" | "ae2:recipes/misc/network/cells/fluid_storage_cell_64k" | "minecraft:recipes/building_blocks/deepslate_tile_stairs" | "createdeco:recipes/building_blocks/tiled_dusk_brick_wall_from_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_scarlet_brick_slab_from_scarlet_brick_slab_stonecutting" | "tconstruct:recipes/misc/common/materials/manyullyn_ingot_from_block" | "create:recipes/building_blocks/calcite_from_stone_types_calcite_stonecutting" | "createdeco:recipes/decorations/green_industrial_iron_lamp" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_white" | "railways:recipes/misc/crafting/palettes/wrapping/magenta_brass_wrapped_locometal" | "create:recipes/building_blocks/industrial_iron_window_pane" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_flat_riveted_locometal" | "createdeco:recipes/building_blocks/short_red_brick_stairs_from_long_red_bricks_stonecutting" | "minecraft:adventure/sniper_duel" | "enderio:recipes/building_blocks/recolor_clear_glass_da_light_blue" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_slashed_locometal" | "create:track_signal" | "tconstruct:recipes/redstone/world/wood/enderbark/pressure_plate" | "minecraft:recipes/building_blocks/polished_andesite_stairs" | "create:recipes/decorations/copper_scaffolding_from_ingots_copper_stonecutting" | "minecraft:recipes/transportation/furnace_minecart" | "minecraft:nether/root" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_gray" | "ae2:recipes/misc/shaped/slabs/quartz_bricks" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_corner_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_flat_slashed_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_ep_red" | "createdeco:recipes/building_blocks/corner_dean_brick_slab_from_long_dean_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_wall_from_long_verdant_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/track_observer_from_other_plates" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_locometal_boiler" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_magenta" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_dusk_brick_stairs_from_tiled_dusk_bricks_stonecutting" | "create:musical_arm" | "createdeco:recipes/decorations/copper_support_wedge_from_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_flat_slashed_locometal" | "createdeco:recipes/decorations/yellow_zinc_lamp" | "minecraft:recipes/decorations/end_stone_brick_wall_from_end_stone_brick_stonecutting" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_tiled_umber_bricks_stonecutting" | "tconstruct:recipes/misc/common/materials/rose_gold_ingot_from_block" | "ae2:recipes/misc/network/cells/item_storage_components_cell_256k_part" | "tconstruct:recipes/building_blocks/common/slime/ichor/congealed" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_long_dean_brick_stairs_stonecutting" | "enderio:recipes/building_blocks/invert_clear_glass_dnp" | "createdeco:recipes/building_blocks/tiled_dusk_brick_wall_from_short_dusk_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_long_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_long_dusk_brick_stairs_stonecutting" | "enderio:recipes/building_blocks/invert_clear_glass_dna" | "createdeco:recipes/building_blocks/cracked_blue_brick_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_plated_locometal" | "create:recipes/building_blocks/cut_calcite_brick_stairs_from_stone_types_calcite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_plated_locometal" | "enderio:recipes/misc/soularium_block" | "enderio:recipes/building_blocks/invert_clear_glass_dnm" | "minecraft:recipes/decorations/white_banner" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_pink" | "copycats:recipes/crafting/copycat_slab_from_beams" | "tconstruct:recipes/building_blocks/common/glass/lime_clear_stained_glass" | "copycats:recipes/crafting/copycat_vertical_slice" | "enderio:recipes/building_blocks/recolor_clear_glass_brown" | "createdeco:recipes/building_blocks/short_pearl_bricks_from_tiled_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/dye_magenta_wool" | "railways:recipes/misc/crafting/palettes/wrapping/red_iron_wrapped_locometal" | "createdeco:recipes/building_blocks/long_red_brick_stairs_from_corner_red_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_scorchia_slab" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_purple" | "expatternprovider:recipes/misc/ex_charger" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_road_stairs" | "tconstruct:foundry/encyclopedia" | "tconstruct:tools/travelers_gear" | "createdeco:recipes/building_blocks/short_blue_brick_wall" | "create:recipes/building_blocks/polished_cut_tuff_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_flat_slashed_locometal" | "createdeco:recipes/building_blocks/corner_verdant_brick_wall" | "minecraft:recipes/building_blocks/dark_oak_wood" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_flat_riveted_locometal" | "expatternprovider:recipes/misc/epp_upgrade" | "createdeco:recipes/building_blocks/long_umber_brick_wall_from_umber_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_bricks_from_verdant_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_lime" | "enderio:recipes/building_blocks/recolor_clear_glass_dm_lime" | "createdeco:recipes/building_blocks/short_dean_brick_wall_from_tiled_dean_brick_wall_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_copper_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_omega_tier" | "minecraft:recipes/building_blocks/polished_blackstone" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_orange" | "minecraft:recipes/misc/diamond_from_smelting_diamond_ore" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_flat_riveted_locometal" | "create:recipes/building_blocks/cut_andesite_wall" | "railways:recipes/combat/dying_existing_cap_white" | "createdeco:recipes/building_blocks/tiled_dusk_brick_wall_from_dusk_brick_wall_stonecutting" | "chiselsandbits:recipes/tools/chisel_iron" | "create:recipes/building_blocks/cut_andesite_stairs_from_stone_types_andesite_stonecutting" | "minecraft:recipes/building_blocks/smooth_sandstone_stairs" | "create:recipes/building_blocks/cut_scoria_brick_stairs_from_stone_types_scoria_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_corner_pearl_bricks_stonecutting" | "copycats:recipes/crafting/copycat_fence_gate" | "railways:recipes/misc/stonecutting/palettes/cycling/white_slashed_locometal" | "createdeco:recipes/building_blocks/corner_verdant_brick_stairs_from_tiled_verdant_brick_stairs_stonecutting" | "create_connected:recipes/crafting/kinetics/crank_wheel" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cracked_bricks_smelting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_iron_wrapped_locometal" | "copycats:recipes/crafting/copycat_ladder" | "minecraft:recipes/misc/lapis_lazuli" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_waxed_exposed_cut_copper_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_ea_white" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_brown" | "ae2:recipes/misc/network/cells/fluid_storage_cell_64k_storage" | "ae2:recipes/misc/materials/cardspeed" | "enderio:recipes/building_blocks/recolor_clear_glass_dnp_lime" | "minecraft:recipes/misc/eye_armor_trim_smithing_template" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_slashed_locometal" | "enderio:recipes/building_blocks/recolor_clear_glass_np_light_blue" | "createdeco:recipes/building_blocks/short_umber_brick_wall_from_tiled_umber_bricks_stonecutting" | "create:diving_suit_lava" | "ae2:recipes/misc/network/cables/glass_red" | "create:cuckoo_clock" | "tconstruct:recipes/redstone/smeltery/seared/duct_retextured" | "create:recipes/building_blocks/cut_granite_stairs_from_stone_types_granite_stonecutting" | "create:recipes/misc/crafting/logistics/powered_toggle_latch" | "createdeco:recipes/building_blocks/cracked_scarlet_bricks_from_scarlet_bricks_blasting" | "minecraft:adventure/salvage_sherd" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_slab_stonecutter" | "enderio:recipes/misc/end_steel_ingot" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_short_dean_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_enm_blue" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_flat_slashed_locometal" | "createdeco:recipes/building_blocks/corner_pearl_brick_wall_from_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_short_pearl_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_short_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_tiled_blue_brick_stairs_stonecutting" | "minecraft:story/cure_zombie_villager" | "createdeco:recipes/decorations/industrial_iron_facade_from_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_iron_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_brass_wrapped_locometal" | "storagedrawers:recipes/storagedrawers/quantify_key" | "create:recipes/building_blocks/small_granite_bricks_from_stone_types_granite_stonecutting" | "createdeco:recipes/decorations/brass_catwalk_railing_forge" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_tiled_blue_brick_stairs_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tile_stairs_from_honeycomb" | "enderio:recipes/building_blocks/silent_soularium_pressure_plate" | "minecraft:recipes/tools/recovery_compass" | "ae2:recipes/misc/network/cables/dense_covered_fluix_clean" | "createdeco:recipes/decorations/orange_shipping_container" | "storagedrawers:recipes/storagedrawers/dark_oak_trim" | "enderio:recipes/building_blocks/recolor_fused_quartz_ena_orange" | "enderio:recipes/building_blocks/recolor_clear_glass_m_lime" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_orange" | "tconstruct:recipes/decorations/common/glass/orange_clear_stained_glass_pane" | "create:drain" | "minecraft:end/find_end_city" | "createdeco:recipes/building_blocks/mossy_umber_bricks_from_moss_block" | "minecraft:recipes/redstone/mangrove_fence_gate" | "create:recipes/misc/blasting/ingot_uranium_compat_mekanism" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_pink" | "create:recipes/building_blocks/polished_cut_scoria_slab_recycling" | "create:recipes/building_blocks/cut_deepslate_brick_slab_from_stone_types_deepslate_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_tiled_verdant_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/polished_cut_veridium_wall" | "immersive_paintings:misc/glow_painting" | "minecraft:recipes/building_blocks/polished_andesite" | "minecraft:recipes/decorations/lime_glazed_terracotta" | "railways:recipes/misc/crafting/palettes/wrapping/green_iron_wrapped_locometal" | "createdeco:recipes/building_blocks/mossy_dean_brick_stairs_from_mossy_dean_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_slashed_locometal" | "ae2:recipes/misc/materials/basiccard" | "enderio:recipes/building_blocks/recolor_fused_quartz_d_cyan" | "createdeco:recipes/building_blocks/blue_brick_wall_from_long_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/mossy_scarlet_brick_stairs_from_mossy_scarlet_bricks_stonecutting" | "ae2:recipes/misc/tools/portable_item_cell_1k" | "create:recipes/misc/crafting/kinetics/cogwheel" | "create:recipes/building_blocks/cut_tuff_slab_from_stone_types_tuff_stonecutting" | "createdeco:recipes/building_blocks/verdant_brick_wall_from_long_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_red_brick_stairs_from_short_red_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/corner_umber_brick_slab_from_long_umber_brick_slab_stonecutting" | "minecraft:recipes/transportation/carrot_on_a_stick" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab" | "create:recipes/building_blocks/small_dripstone_brick_wall" | "ae2:recipes/misc/tools/portable_item_cell_4k" | "createdeco:recipes/building_blocks/corner_dusk_brick_slab_from_corner_dusk_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/red_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_dean_brick_wall_from_dean_brick_wall_stonecutting" | "create:recipes/building_blocks/cut_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_slab_from_short_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_corner_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/muddy_mangrove_roots" | "minecraft:recipes/building_blocks/red_sandstone_slab_from_red_sandstone_stonecutting" | "enderio:recipes/building_blocks/recolor_clear_glass_na_pink" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_short_pearl_bricks_stonecutting" | "enderio:recipes/tools/empty_soul_vial" | "create:recipes/building_blocks/polished_cut_asurine_from_stone_types_asurine_stonecutting" | "ae2:recipes/misc/shaped/slabs/fluix_block" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_verdant_brick_slab_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_enm_red" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_short_pearl_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_plated_locometal" | "createdeco:recipes/building_blocks/blue_brick_wall_from_corner_blue_bricks_stonecutting" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "sophisticatedbackpacks:recipes/misc/copper_backpack" | "create:recipes/building_blocks/cherry_window" | "tconstruct:recipes/misc/common/materials/cobalt_ingot_from_block" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/scarlet_bricks_from_long_scarlet_bricks_stonecutting" | "expatternprovider:recipes/misc/ei_part" | "minecraft:recipes/building_blocks/warped_slab" | "createdeco:recipes/building_blocks/corner_verdant_brick_stairs_from_tiled_verdant_bricks_stonecutting" | "createdeco:recipes/decorations/industrial_iron_sheet_metal" | "createdeco:recipes/decorations/zinc_coinstack" | "enderio:recipes/misc/soularium_nugget_to_ingot" | "minecraft:recipes/redstone/spruce_door" | "enderio:recipes/building_blocks/recolor_clear_glass_m_purple" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_locometal_pillar" | "minecraft:recipes/redstone/spruce_fence_gate" | "enderio:recipes/building_blocks/recolor_clear_glass_red" | "minecraft:recipes/building_blocks/chiseled_stone_bricks_stone_from_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_slashed_locometal" | "createdeco:recipes/building_blocks/corner_pearl_brick_slab_from_short_pearl_brick_slab_stonecutting" | "create:recipes/misc/crafting/appliances/dough" | "expatternprovider:recipes/misc/tag_storage_bus" | "create:recipes/building_blocks/weathered_copper_tile_stairs_from_weathered_copper_tiles_stonecutting" | "createdeco:recipes/building_blocks/dean_bricks_from_short_dean_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_lime" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_tiled_pearl_bricks_stonecutting" | "enderio:recipes/misc/enchanter" | "ae2:recipes/misc/network/cables/smart_green" | "minecraft:recipes/building_blocks/dye_white_wool" | "createdeco:recipes/building_blocks/corner_pearl_bricks_from_pearl_bricks_stonecutting" | "minecraft:recipes/decorations/light_blue_glazed_terracotta" | "create:recipes/misc/blasting/gold_ingot_from_crushed" | "createdeco:recipes/building_blocks/pearl_bricks" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_pink" | "create:recipes/misc/crafting/kinetics/contraption_controls" | "create:recipes/building_blocks/polished_cut_asurine_slab_from_stone_types_asurine_stonecutting" | "create:recipes/building_blocks/small_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "minecraft:recipes/building_blocks/prismarine_stairs" | "create:recipes/misc/crafting/kinetics/flywheel" | "create:recipes/misc/crafting/kinetics/hose_pulley" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_verdant_bricks_stonecutting" | "minecraft:recipes/building_blocks/deepslate_tiles_from_polished_deepslate_stonecutting" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_tiled_blue_bricks_stonecutting" | "minecraft:recipes/building_blocks/deepslate_tiles_from_deepslate_bricks_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_brick" | "minecraft:recipes/building_blocks/mangrove_wood" | "ae2:recipes/misc/network/parts/panels_semi_dark_monitor" | "createdeco:recipes/building_blocks/verdant_brick_stairs" | "tconstruct:recipes/decorations/common/glass/brown_clear_stained_glass_pane" | "create:recipes/building_blocks/small_ochrum_brick_wall" | "create:recipes/building_blocks/small_tuff_brick_wall_from_stone_types_tuff_stonecutting" | "create:contraption_actors" | "minecraft:recipes/misc/gold_ingot_from_smelting_nether_gold_ore" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_pearl_brick_stairs_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/white_seat" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_locometal_smokebox" | "create:recipes/building_blocks/cut_calcite_brick_slab" | "minecraft:recipes/building_blocks/yellow_stained_glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/spire_armor_trim_smithing_template_smithing_trim" | "enderio:recipes/building_blocks/recolor_fused_quartz_a_purple" | "tconstruct:recipes/misc/common/materials/raw_cobalt_block_from_raws" | "create:recipes/building_blocks/rose_quartz_tiles_from_polished_rose_quartz_stonecutting" | "createdeco:recipes/decorations/zinc_support_wedge" | "minecraft:recipes/redstone/mangrove_button" | "createdeco:recipes/building_blocks/corner_scarlet_brick_slab_from_tiled_scarlet_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_m_red" | "createdeco:recipes/building_blocks/long_red_brick_slab_from_corner_red_bricks_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingles_from_honeycomb" | "railways:recipes/combat/dying_existing_cap_orange" | "createdeco:recipes/building_blocks/corner_blue_brick_slab_from_corner_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_wall_from_long_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_locometal_boiler" | "enderio:recipes/building_blocks/recolor_fused_quartz_dp_blue" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_slashed_locometal" | "ae2:recipes/misc/network/cables/dense_smart_yellow" | "create:recipes/building_blocks/cut_scoria_brick_slab_from_stone_types_scoria_stonecutting" | "createdeco:recipes/building_blocks/short_blue_brick_wall_from_short_blue_bricks_stonecutting" | "minecraft:recipes/building_blocks/polished_basalt_from_basalt_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_slab" | "chiselsandbits:recipes/tools/bit_bag" | "createdeco:recipes/building_blocks/long_dusk_brick_slab" | "ae2:recipes/misc/decorative/cut_quartz_block" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_green" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_plated_locometal" | "ae2:recipes/misc/block_cutter/stairs/quartz_stairs" | "create:recipes/building_blocks/polished_cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/building_blocks/white_wool_from_string" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_tiled_dean_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_flat_riveted_locometal" | "minecraft:recipes/decorations/yellow_banner" | "createdeco:recipes/building_blocks/dean_brick_slab_from_corner_dean_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/deepslate_brick_slab" | "minecraft:recipes/building_blocks/polished_diorite_stairs_from_polished_diorite_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_tiled_umber_bricks_stonecutting" | "create:recipes/building_blocks/cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "ae2:recipes/misc/materials/cardinverter" | "minecraft:recipes/redstone/polished_blackstone_pressure_plate" | "createdeco:recipes/building_blocks/dean_bricks" | "enderio:recipes/misc/soul_engine" | "create:recipes/building_blocks/small_deepslate_brick_wall" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_dusk_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_flat_riveted_locometal" | "create:recipes/building_blocks/crafting/logistics/purple_table_cloth_from_other_table_cloth" | "tconstruct:recipes/redstone/smeltery/scorched/channel" | "copycats:recipes/crafting/copycat_large_cogwheel" | "create:recipes/building_blocks/cut_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "minecraft:recipes/decorations/magenta_stained_glass_pane_from_glass_pane" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_tiled_umber_brick_stairs_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_np_brown" | "copycats:recipes/crafting/copycat_vertical_half_layer_from_conversion" | "tconstruct:recipes/building_blocks/common/glass/blue_clear_stained_glass" | "minecraft:recipes/brewing/blaze_powder" | "minecraft:end/root" | "tconstruct:recipes/decorations/tables/cast_chest" | "ae2:recipes/misc/materials/cardenergy" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_gray" | "createdeco:recipes/building_blocks/long_dean_brick_wall" | "tconstruct:recipes/misc/common/materials/cinderslime_ingot_from_nuggets" | "create:recipes/decorations/brass_table_cloth_from_ingots_brass_stonecutting" | "create_connected:recipes/crafting/kinetics/parallel_gearbox_from_conversion" | "sophisticatedbackpacks:recipes/misc/chipped/loom_table_upgrade" | "enderio:recipes/building_blocks/dark_steel_ladder" | "createdeco:recipes/building_blocks/verdant_brick_wall_from_tiled_verdant_brick_wall_stonecutting" | "minecraft:recipes/decorations/moss_carpet" | "minecraft:recipes/decorations/cyan_stained_glass_pane_from_glass_pane" | "minecraft:recipes/redstone/crimson_fence_gate" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper" | "enderio:recipes/misc/basic_capacitor_bank" | "createdeco:recipes/building_blocks/long_red_brick_wall_from_tiled_red_brick_wall_stonecutting" | "create:recipes/misc/crafting/kinetics/vertical_gearbox" | "botanypots:husbandry/get_basic_pot" | "enderio:recipes/building_blocks/recolor_fused_quartz_enp_red" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_tiled_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/gray_concrete_powder" | "create:foods" | "tconstruct:recipes/decorations/tables/crafting_station_from_logs" | "copycats:recipes/crafting/copycat_slab_from_panels" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_white" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_locometal_pillar" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_flat_riveted_locometal" | "minecraft:recipes/building_blocks/glowstone" | "create:recipes/building_blocks/oak_window" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_long_verdant_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_brass_wrapped_locometal" | "createdeco:recipes/decorations/industrial_iron_bars_overlay" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_long_dusk_brick_stairs_stonecutting" | "tconstruct:tools/netherite_tier" | "enderio:recipes/building_blocks/recolor_clear_glass_p_purple" | "minecraft:recipes/decorations/cartography_table" | "create:recipes/misc/crafting/appliances/package_filter_clear" | "createdeco:recipes/decorations/blue_industrial_iron_lamp" | "tconstruct:tools/upgrade_slots" | "createdeco:recipes/building_blocks/long_verdant_bricks_from_short_verdant_bricks_stonecutting" | "minecraft:recipes/building_blocks/chiseled_deepslate" | "create:recipes/misc/crafting/kinetics/nixie_tube" | "minecraft:recipes/misc/iron_nugget_from_blasting" | "sophisticatedbackpacks:recipes/misc/restock_upgrade" | "enderio:recipes/building_blocks/recolor_fused_quartz_dna_purple" | "createdeco:recipes/decorations/brass_trapdoor" | "minecraft:husbandry/plant_any_sniffer_seed" | "minecraft:adventure/adventuring_time" | "minecraft:recipes/building_blocks/dye_cyan_carpet" | "tconstruct:recipes/redstone/world/wood/bloodshroom/trapdoor" | "createdeco:recipes/building_blocks/tiled_blue_brick_wall_from_long_blue_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_ochrum_wall_from_stone_types_ochrum_stonecutting" | "createdeco:recipes/decorations/yellow_andesite_lamp" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_locometal_pillar" | "tconstruct:recipes/redstone/smeltery/scorched/duct_retextured" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_tiled_dean_brick_stairs_stonecutting" | "createdeco:recipes/misc/netherite_ingot" | "enderio:recipes/building_blocks/recolor_clear_glass_na_green" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_riveted_locometal" | "minecraft:husbandry/plant_seed" | "minecraft:nether/find_bastion" | "createdeco:recipes/building_blocks/corner_pearl_brick_slab" | "create:recipes/building_blocks/crafting/kinetics/lime_seat" | "createdeco:recipes/decorations/lime_placard_from_dyeing" | "railways:recipes/misc/crafting/palettes/wrapping/white_brass_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_flat_slashed_locometal" | "minecraft:recipes/decorations/flower_pot" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_copper_wrapped_locometal" | "ae2:recipes/misc/network/cables/smart_black" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_tiled_dean_brick_stairs_stonecutting" | "create:recipes/misc/smelting/silver_ingot_compat_galosphere" | "sophisticatedbackpacks:recipes/misc/tool_swapper_upgrade" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_deepslate_bricks_stonecutting" | "create:recipes/building_blocks/layered_asurine_from_stone_types_asurine_stonecutting" | "railways:recipes/combat/dying_existing_cap_black" | "minecraft:recipes/decorations/sandstone_wall" | "create_factory_logistics:recipes/misc/factory_fluid_gauge" | "create:recipes/misc/crafting/kinetics/purple_valve_handle_from_other_valve_handle" | "ae2:recipes/misc/shaped/slabs/sky_stone_block" | "create:recipes/misc/smelting/glass_from_vertical_framed_glass" | "tconstruct:recipes/redstone/common/slime/sticky_piston" | "create_connected:recipes/crafting/kinetics/item_silo" | "minecraft:recipes/decorations/andesite_wall" | "minecraft:recipes/building_blocks/andesite_slab" | "minecraft:recipes/misc/light_gray_dye_from_oxeye_daisy" | "create:recipes/misc/crafting/kinetics/metal_bracket" | "ae2:recipes/misc/network/blocks/inscribers" | "createdeco:recipes/building_blocks/corner_blue_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_flat_riveted_locometal" | "createdeco:recipes/building_blocks/cracked_dean_brick_wall_from_cracked_dean_bricks_stonecutting" | "create:recipes/building_blocks/cut_ochrum_slab_recycling" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_tiled_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/corner_blue_brick_stairs" | "enderio:recipes/building_blocks/silent_birch_pressure_plate" | "minecraft:recipes/building_blocks/cobblestone_stairs_from_cobblestone_stonecutting" | "enderio:recipes/misc/pressurized_fluid_tank" | "expatternprovider:recipes/misc/ex_drive_upgrade" | "enderio:recipes/building_blocks/invert_clear_glass_enp" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_copper_wrapped_locometal_boiler" | "minecraft:recipes/misc/wheat" | "enderio:recipes/building_blocks/invert_clear_glass_enm" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_riveted_locometal" | "enderio:recipes/building_blocks/recolor_fused_quartz_na_magenta" | "minecraft:recipes/redstone/birch_pressure_plate" | "railways:recipes/misc/stonecutting/riveted_locometal" | "minecraft:recipes/building_blocks/purpur_stairs_from_purpur_block_stonecutting" | "minecraft:recipes/building_blocks/cut_red_sandstone_from_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/diorite_slab_from_diorite_stonecutting" | "createdeco:recipes/decorations/brass_sheet_metal" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_long_scarlet_bricks_stonecutting" | "enderio:recipes/building_blocks/invert_clear_glass_ena" | "enderio:recipes/redstone/resetting_lever_ten_inv" | "minecraft:recipes/decorations/pink_carpet" | "create:portable_storage_interface" | "storagedrawers:recipes/storagedrawers/balance_fill_upgrade" | "create:conductor" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_long_blue_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_em_black" | "create_connected:recipes/crafting/kinetics/cross_connector" | "ae2:main/root" | "enderio:recipes/building_blocks/recolor_clear_glass_na_white" | "tconstruct:recipes/decorations/world/wood/skyroot/sign" | "tconstruct:recipes/food/gadgets/cake/ender" | "enderio:recipes/building_blocks/recolor_clear_glass_nm_white" | "ae2:recipes/misc/network/blocks/io_port" | "createdeco:recipes/building_blocks/long_scarlet_brick_wall_from_tiled_scarlet_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/corner_scarlet_brick_stairs_from_short_scarlet_brick_stairs_stonecutting" | "create:recipes/building_blocks/cut_dripstone_brick_stairs_from_stone_types_dripstone_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_tiled_dusk_brick_stairs_stonecutting" | "minecraft:recipes/tools/netherite_pickaxe_smithing" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_tiled_dusk_brick_stairs_stonecutting" | "minecraft:nether/fast_travel" | "tconstruct:recipes/brewing/common/glass/vanilla/glass_bottle" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_short_dusk_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/short_red_brick_stairs_from_long_red_brick_stairs_stonecutting" | "create:recipes/building_blocks/copper_shingle_slab_from_copper_shingles_stonecutting" | "create:precision_mechanism" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/deepslate_tiles_from_cobbled_deepslate_stonecutting" | "ae2:recipes/misc/network/crafting/cpu_crafting_unit" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_tiled_verdant_brick_stairs_stonecutting" | "enderio:recipes/building_blocks/ender_fluid_conduit" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_flat_riveted_locometal" | "tconstruct:recipes/building_blocks/common/glass/light_gray_clear_stained_glass" | "minecraft:recipes/redstone/tnt" | "create:recipes/building_blocks/cut_tuff_bricks_from_stone_types_tuff_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_ea_black" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_waxed_oxidized_copper_stonecutting" | "createdeco:recipes/decorations/zinc_hull_from_stonecutting" | "create:recipes/building_blocks/small_limestone_brick_stairs" | "enderio:recipes/misc/conductive_alloy_ingot" | "minecraft:recipes/decorations/enchanting_table" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_tiled_scarlet_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/short_red_brick_stairs_from_bricks_stonecutting" | "create:recipes/misc/blasting/lead_ingot_compat_oreganized" | "create_connected:recipes/crafting/kinetics/inventory_bridge" | "tconstruct:recipes/misc/common/materials/slimesteel_ingot_from_nuggets" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_dean_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_plated_locometal" | "createdeco:recipes/building_blocks/mossy_red_brick_slab_from_mossy_red_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_light_gray" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_iron_wrapped_locometal_boiler" | "minecraft:recipes/tools/stone_hoe" | "enderio:recipes/building_blocks/recolor_fused_quartz_nm_yellow" | "createdeco:recipes/building_blocks/corner_scarlet_brick_slab_from_long_scarlet_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_scarlet_brick_wall_from_tiled_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_brass_wrapped_locometal" | "minecraft:recipes/decorations/jungle_hanging_sign" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_flat_riveted_locometal" | "minecraft:recipes/building_blocks/spruce_stairs" | "create:recipes/misc/blasting/silver_ingot_compat_iceandfire" | "sophisticatedbackpacks:recipes/misc/crafting_upgrade" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_plated_locometal" | "createdeco:recipes/building_blocks/tiled_dusk_brick_wall" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_corner_dean_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/magenta_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_tiled_dusk_brick_stairs_stonecutting" | "enderio:recipes/misc/redstone_alloy_block" | "tconstruct:recipes/redstone/smeltery/scorched/proxy_tank" | "tconstruct:recipes/redstone/smeltery/seared/fuel_gauge" | "minecraft:recipes/decorations/black_candle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_riveted_locometal" | "create:recipes/building_blocks/small_crimsite_brick_slab_from_stone_types_crimsite_stonecutting" | "create:recipes/misc/crafting/kinetics/item_vault" | "create:recipes/building_blocks/crafting/kinetics/gray_seat_from_other_seat" | "minecraft:recipes/decorations/mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting" | "createdeco:recipes/building_blocks/long_red_brick_slab" | "tconstruct:recipes/decorations/smeltery/seared/heater" | "enderio:recipes/building_blocks/recolor_clear_glass_dnm_pink" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_slashed_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_locometal_smokebox" | "minecraft:recipes/decorations/loom" | "create:recipes/building_blocks/exposed_copper_tile_stairs_from_exposed_copper_tiles_stonecutting" | "createdeco:recipes/building_blocks/tiled_pearl_brick_wall_from_corner_pearl_bricks_stonecutting" | "minecraft:recipes/tools/diamond_axe" | "enderio:recipes/building_blocks/recolor_clear_glass_dna_yellow" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_short_blue_bricks_stonecutting" | "minecraft:recipes/building_blocks/end_stone_brick_stairs_from_end_stone_stonecutting" | "minecraft:recipes/misc/emerald_from_blasting_deepslate_emerald_ore" | "createdeco:recipes/decorations/iron_mesh_fence" | "minecraft:recipes/decorations/scaffolding" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_long_scarlet_bricks_stonecutting" | "tconstruct:recipes/redstone/world/wood/greenheart/door" | "ae2:recipes/misc/tools/paintballs_lumen_light_blue" | "enderio:recipes/building_blocks/recolor_fused_quartz_ep_light_blue" | "createdeco:recipes/building_blocks/scarlet_brick_wall_from_corner_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_locometal_boiler" | "createdeco:recipes/decorations/copper_catwalk_railing_from_stonecutting" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_pearl_brick_stairs_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper" | "create:recipes/building_blocks/cut_granite_stairs" | "createdeco:recipes/building_blocks/cracked_blue_brick_slab_from_cracked_blue_bricks_stonecutting" | "create:recipes/building_blocks/small_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "create:recipes/misc/crafting/kinetics/pink_valve_handle_from_other_valve_handle" | "minecraft:recipes/misc/raw_copper" | "createdeco:recipes/building_blocks/corner_dusk_brick_slab_from_long_dusk_brick_slab_stonecutting" | "create:recipes/building_blocks/copper_shingle_stairs_from_copper_shingles_stonecutting" | "create:recipes/misc/crafting/kinetics/gearshift" | "chiselsandbits:recipes/tools/chisel_stone" | "createdeco:recipes/building_blocks/long_umber_brick_wall_from_corner_umber_bricks_stonecutting" | "tconstruct:recipes/redstone/smeltery/seared/chute" | "minecraft:story/root" | "enderio:recipes/misc/gold_ingot_from_blasting" | "minecraft:recipes/building_blocks/dye_black_wool" | "create:recipes/building_blocks/tiled_glass_from_glass_colorless_stonecutting" | "ae2:recipes/misc/tools/paintballs_lumen_cyan" | "createdeco:recipes/building_blocks/corner_verdant_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_iron_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_limestone_brick_slab" | "expatternprovider:recipes/misc/oversize_interface_part" | "create:recipes/building_blocks/crafting/kinetics/yellow_seat" | "tconstruct:recipes/decorations/common/cobalt_platform" | "ae2:recipes/misc/misc/chests_sky_stone" | "createdeco:recipes/building_blocks/corner_pearl_brick_slab_from_pearl_brick_slab_stonecutting" | "create:recipes/misc/crafting/appliances/slime_ball" | "createdeco:recipes/building_blocks/corner_blue_brick_wall_from_short_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_wall_from_dean_bricks_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_dnm_gray" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_from_honeycomb" | "createdeco:recipes/decorations/iron_catwalk_stairs" | "minecraft:recipes/misc/copper_ingot_from_smelting_raw_copper" | "create:recipes/building_blocks/cut_tuff_wall_from_stone_types_tuff_stonecutting" | "createdeco:recipes/building_blocks/short_blue_brick_wall_from_blue_brick_wall_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_paver_stairs_stonecutter" | "minecraft:recipes/building_blocks/snow_block" | "createdeco:recipes/decorations/green_placard" | "create:recipes/building_blocks/crafting/logistics/light_gray_postbox" | "enderio:recipes/redstone/resetting_lever_sixty_inv_from_base" | "minecraft:recipes/decorations/polished_blackstone_wall" | "create:recipes/building_blocks/cut_asurine_stairs" | "minecraft:recipes/decorations/honeycomb_block" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tile_slab_from_honeycomb" | "minecraft:recipes/combat/golden_leggings" | "minecraft:recipes/misc/lapis_lazuli_from_smelting_lapis_ore" | "createdeco:recipes/building_blocks/short_verdant_brick_wall_from_verdant_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_brass_wrapped_locometal" | "createdeco:recipes/building_blocks/corner_umber_brick_wall_from_long_umber_brick_wall_stonecutting" | "createdeco:recipes/building_blocks/corner_verdant_brick_stairs_from_verdant_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/corner_pearl_brick_slab_from_tiled_pearl_brick_slab_stonecutting" | "minecraft:recipes/food/cooked_beef_from_campfire_cooking" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_flat_slashed_locometal" | "ae2:recipes/misc/network/cells/item_storage_cell_16k_storage" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_brass_wrapped_locometal" | "create:cardboard_armor_trim" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_flat_slashed_locometal" | "createdeco:recipes/decorations/iron_support_wedge" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_long_pearl_brick_stairs_stonecutting" | "enderio:recipes/building_blocks/recolor_fused_quartz_da_red" | "create_connected:recipes/crafting/kinetics/six_way_gearbox_from_parallel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_flat_riveted_locometal" | "create:recipes/building_blocks/polished_cut_scorchia_slab_recycling";
    type RecipeId = "tconstruct:tools/modifiers/salvage/upgrade/fireprimer" | "mysticalagriculture:seed/crafting/tin" | "tconstruct:tools/parts/casting/bow_grip_composite" | "railways:sequenced_assembly/track_biomesoplenty_umbran_wide" | "ae2:matter_cannon/nuggets/yttrium" | "create:crafting/logistics/black_postbox_from_other_postbox" | "create:milling/charcoal" | "createdeco:tiled_pearl_brick_slab_from_long_pearl_bricks_stonecutting" | "createdeco:blue_brick_wall_from_tiled_blue_bricks_stonecutting" | "mysticalagriculture:essence/minecraft/milk_bucket" | "create:milling/compat/environmental/violet" | "minecraft:stonecutter" | "createdeco:dusk_brick_slab_from_corner_dusk_bricks_stonecutting" | "enderio:recolor_fused_quartz_ea_lime" | "minecraft:bone_block" | "botanypots:botanypots/crafting/brown_concrete_botany_pot" | "createdeco:long_scarlet_brick_wall" | "tconstruct:smeltery/casting/metal/iron/ingot_gold_cast" | "ae2:inscriber/certus_quartz_dust" | "tconstruct:smeltery/casting/metal/uranium/coin_gold_cast" | "create:cutting/runtime_generated/compat/minecraft/jungle_log_to_stripped_jungle_log" | "create:cutting/runtime_generated/compat/minecraft/oak_planks_to_oak_sign" | "create:cut_granite_wall" | "enderio:recolor_clear_glass_dm_red" | "mysticalagriculture:seed/reprocessor/rock_crystal" | "minecraft:deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "ae2:network/cells/item_storage_cell_256k_storage" | "enderio:resetting_lever_ten_inv_from_prev" | "createdeco:mossy_umber_brick_wall" | "tconstruct:common/glass/pink_clear_stained_glass_pane" | "create:oak_window" | "createdeco:long_red_bricks_from_bricks_stonecutting" | "thermal:machines/press/unpacking/press_sandstone_unpacking" | "create:cut_diorite_from_stone_types_diorite_stonecutting" | "sophisticatedbackpacks:void_upgrade" | "thermal:fuels/lapidary/lapidary_lapis" | "createdeco:short_red_brick_stairs_from_tiled_red_brick_stairs_stonecutting" | "create:brass_ladder_from_ingots_brass_stonecutting" | "thermal:machines/crucible/crucible_glowstone_dust" | "enderio:enchanting/loyalty" | "createdeco:corner_umber_brick_stairs_from_short_umber_brick_stairs_stonecutting" | "minecraft:cobblestone_wall" | "railways:crafting/palettes/dyeing_8x/light_gray_slashed_locometal" | "enderio:recolor_clear_glass_m_yellow" | "tconstruct:smeltery/melting/metal/rose_gold/block" | "mysticalagradditions:supremium_paxel" | "minecraft:raw_copper" | "railways:crafting/palettes/dyeing_1x/light_blue_iron_wrapped_locometal" | "tconstruct:smeltery/melting/scorched/pane_soul" | "tconstruct:tools/severing/wither_skeleton_skull" | "tconstruct:smeltery/melting/metal/refined_glowstone/axes" | "thermal:machines/smelter/smelter_netherite_plate_to_ingot" | "createdeco:long_dean_bricks_from_tiled_dean_bricks_stonecutting" | "create:splashing/endergetic/petrified_end_corrock_block" | "thermal:earth_charge/prismarine_shard_from_prismarine_bricks" | "createdeco:andesite_catwalk_from_stonecutting" | "create:crushing/compat/elementaryores/ore_lapis_end" | "thermal:black_concrete_powder_with_slag" | "thermal:machines/pulverizer/pulverizer_raw_lead" | "minecraft:map_extending" | "tconstruct:smeltery/scorched/scorched_bricks_crafting" | "createdeco:tiled_red_brick_wall" | "minecraft:spruce_sign" | "mysticalagriculture:soulstone_cobble_stairs" | "minecraft:cut_copper_slab_from_copper_block_stonecutting" | "enderio:grindingball/flint" | "botanypots:minecraft/soil/netherrack" | "create:filling/compat/immersiveengineering/treated_wood_in_spout" | "createdeco:copper_catwalk_stairs" | "createdeco:corner_pearl_brick_stairs_from_long_pearl_brick_stairs_stonecutting" | "create:crushing/raw_silver" | "sophisticatedbackpacks:advanced_refill_upgrade" | "enderio:recolor_clear_glass_d_lime" | "minecraft:glow_item_frame" | "create_more_additions:electrum/building/fence" | "tconstruct:smeltery/melting/metal/invar/gear" | "create:deploying/cut_copper_slab_from_deoxidising" | "enderio:recolor_clear_glass_p_purple" | "thermal:machines/centrifuge/centrifuge_oil_red_sand" | "railways:sequenced_assembly/track_bamboo_narrow" | "tconstruct:smeltery/melting/metal/constantan/block" | "minecraft:copper_block" | "railways:sequenced_assembly/track_tfc_white_cedar_wide" | "mysticalagriculture:essence/minecraft/beef" | "tconstruct:smeltery/casting/seared/bricks/stairs" | "tconstruct:smeltery/casting/metal/nickel/gear_gold_cast" | "railways:sequenced_assembly/track_crimson_narrow" | "tconstruct:smeltery/entity_melting/heads/zombie" | "enderio:recolor_fused_quartz_ea_blue" | "minecraft:green_stained_glass" | "mysticalagriculture:stonecutting/soulstone_bricks_from_soulstone" | "thermal:machines/pulverizer/pulverizer_lapis" | "create:small_veridium_brick_slab_recycling" | "minecraft:sandstone_slab_from_sandstone_stonecutting" | "tconstruct:tools/building/pickaxe" | "mysticalagriculture:augment/haste_i" | "enderio:sag_milling/cactus" | "createdeco:short_scarlet_brick_wall" | "tconstruct:tools/modifiers/salvage/upgrade/sinistral" | "tconstruct:common/materials/manyullyn_block_from_ingots" | "createdeco:long_red_brick_stairs_from_tiled_red_bricks_stonecutting" | "createdeco:purple_shipping_container_from_dyeing_vaults" | "createdeco:long_blue_brick_stairs_from_long_blue_bricks_stonecutting" | "createdeco:short_pearl_brick_wall_from_long_pearl_bricks_stonecutting" | "tconstruct:smeltery/casting/metal/iron/rod_sand_cast" | "tconstruct:smeltery/casting/metal/enderium/plate_gold_cast" | "enderio:recolor_fused_quartz_enm_magenta" | "tconstruct:smeltery/melting/metal/osmium/oreberry" | "thermal:devices/tree_extractor/tree_extractor_cherry" | "mysticalagriculture:augment/absorption_i" | "tconstruct:smeltery/casting/metal/slimesteel/block" | "thermal:diving_fabric" | "create:cutting/runtime_generated/compat/minecraft/crimson_hyphae_to_stripped_crimson_hyphae" | "automobility:frame/standard_orange" | "createdeco:corner_umber_brick_slab_from_short_umber_brick_slab_stonecutting" | "minecraft:cut_sandstone_slab" | "tconstruct:smeltery/casts/sand/molding/hammer_head" | "railways:crafting/palettes/dyeing_1x/gray_locometal_pillar" | "railways:mechanical_crafting/green_locometal_boiler" | "enderio:alloy_smelting/organic_green_dye_double_clippings" | "tconstruct:common/materials/pig_iron_ingot_from_block" | "tconstruct:smeltery/melting/metal/tin/plate" | "createdeco:verdant_brick_slab" | "tconstruct:tools/modifiers/worktable/extract/upgrade" | "tconstruct:tools/modifiers/salvage/ability/bucketing" | "botanypots:mysticalagriculture/crop/nether_quartz" | "create:deploying/copper_tile_stairs_from_deoxidising" | "minecraft:mojang_banner_pattern" | "enderio:recolor_clear_glass_d_blue" | "ae2:matter_cannon/nuggets/indium" | "minecraft:golden_hoe" | "ae2:tools/misctools_charged_staff" | "mysticalagriculture:augment/strength_ii" | "botanypots:mysticalagriculture/crop/osmium" | "createdeco:umber_brick_wall_from_short_umber_brick_wall_stonecutting" | "minecraft:dye_green_bed" | "create_more_additions:electrum_jewel" | "botanypots:mysticalagriculture/crop/pig" | "enderio:recolor_clear_glass_ep_black" | "enderio:recolor_clear_glass_ea_light_blue" | "create:crafting/kinetics/cyan_seat_from_other_seat" | "tconstruct:smeltery/seared/seared_ladder" | "create:deploying/exposed_copper_shingle_stairs_from_deoxidising" | "mysticalagriculture:seed/infusion/chicken" | "tconstruct:tools/materials/melting/ice" | "railways:crafting/palettes/dyeing_1x/black_iron_wrapped_locometal" | "enderio:recolor_clear_glass_dm_cyan" | "thermal:machines/crystallizer/crystallizer_quartz" | "enderio:recolor_fused_quartz_da_brown" | "tconstruct:tools/modifiers/ability/leaping" | "tconstruct:tools/modifiers/salvage/ability/snowdrift" | "createdeco:cracked_umber_brick_slab" | "bellsandwhistles:grab_rails/brass_grab_rails_stonecutting" | "minecraft:purpur_block" | "railways:crafting/palettes/wrapping/iron_wrapped_locometal" | "minecraft:polished_blackstone_slab" | "railways:mechanical_crafting/red_copper_wrapped_locometal_boiler" | "mysticalagriculture:essence/minecraft/obsidian" | "thermal:machines/press/unpacking/press_emerald_unpacking" | "thermal:devices/tree_extractor/tree_extractor_jungle" | "tconstruct:smeltery/casting/metal/copper/nugget_sand_cast" | "railways:sequenced_assembly/track_tfc_sequoia_wide" | "thermal:machines/pulverizer/pulverizer_sulfur" | "minecraft:gray_concrete_powder" | "tconstruct:smeltery/melting/metal/lead/tools_complement_excavator" | "enderio:recolor_fused_quartz_d_cyan" | "create:crafting/kinetics/mechanical_roller" | "create_factory_logistics:network_link_qualification_create_factory_abstractions_empty" | "minecraft:redstone_from_blasting_redstone_ore" | "ae2:tools/paintballs_light_blue" | "railways:crafting/track_coupler" | "tconstruct:tools/materials/composite/whitestone_from_tin" | "tconstruct:tools/modifiers/upgrade/springy" | "railways:crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal_boiler" | "mysticalagriculture:essence/create/veridium" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "createdeco:corner_verdant_bricks_from_long_verdant_bricks_stonecutting" | "createdeco:mossy_pearl_bricks_from_moss_block" | "createdeco:cracked_dusk_brick_stairs" | "createdeco:corner_dean_bricks_from_dean_bricks_stonecutting" | "createdeco:cracked_dusk_brick_stairs_from_cracked_dusk_bricks_stonecutting" | "createdeco:corner_dusk_brick_slab_from_dusk_brick_slab_stonecutting" | "tconstruct:smeltery/seared/seared_bricks_stonecutting" | "railways:crafting/palettes/dyeing_1x/light_gray_brass_wrapped_locometal_boiler" | "railways:crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal_boiler" | "mysticalagriculture:seed/infusion/ghast" | "tconstruct:smeltery/casting/metal/refined_obsidian/block" | "ae2:matter_cannon/nuggets/bismuth" | "create:cutting/runtime_generated/compat/minecraft/acacia_planks_to_acacia_fence_gate" | "create:item_application/brass_casing_from_log" | "create:bamboo_window_pane" | "railways:crafting/palettes/dyeing_1x/pink_locometal_smokebox" | "createdeco:long_red_brick_slab_from_corner_red_brick_slab_stonecutting" | "railways:crafting/palettes/dyeing_1x/pink_riveted_locometal" | "create:smelting/ingot_silver_compat_ic2" | "tconstruct:common/materials/queens_slime_ingot_from_nuggets" | "create:crafting/kinetics/chute" | "create:brass_scaffolding_from_ingots_brass_stonecutting" | "thermal:machines/pulverizer/pulverizer_quartz" | "extendedae_plus:4x_crafting_accelerator" | "create:crafting/kinetics/cyan_valve_handle_from_other_valve_handle" | "tconstruct:smeltery/melting/metal/lead/sheetmetal" | "tconstruct:smeltery/melting/metal/gold/nether_gold_ore" | "thermal:machines/crystallizer/crystallizer_sulfur" | "createdeco:short_red_bricks_from_tiled_red_bricks_stonecutting" | "copycats:crafting/copycat_vertical_half_layer_from_conversion" | "tconstruct:tools/modifiers/defense/magic_protection" | "tconstruct:smeltery/casting/slime/ender/bottle" | "createdeco:tiled_verdant_bricks_from_verdant_bricks_stonecutting" | "enderio:recolor_clear_glass_dnm_light_gray" | "tconstruct:smeltery/melting/metal/invar/nugget" | "enderio:recolor_clear_glass_d_white" | "botanypots:botanypots/crafting/red_concrete_hopper_botany_pot" | "railways:crafting/palettes/dyeing_1x/lime_slashed_locometal" | "create:polished_cut_asurine_stairs" | "tconstruct:tools/materials/melting/platinum" | "chiselsandbits:chisel_gold" | "thermal:machines/bottler/bottler_magenta_concrete" | "create:crafting/kinetics/fluid_tank" | "create:cutting/runtime_generated/compat/minecraft/acacia_wood_to_stripped_acacia_wood" | "create:smoking/bread" | "tconstruct:tools/materials/ancient/nugget" | "createdeco:dusk_brick_stairs_from_tiled_dusk_brick_stairs_stonecutting" | "mysticalagriculture:seed/reprocessor/uraninite" | "minecraft:orange_stained_glass_pane_from_glass_pane" | "tconstruct:tools/parts/casting/tough_binding_gold_cast" | "tconstruct:tools/materials/slimeskin/composite/ichor_cleaning" | "thermal:machines/smelter/smelter_copper_ore" | "tconstruct:tools/recycling/general" | "create_connected:crafting/palettes/copycat_fence_compat" | "mysticalagriculture:stonecutting/soulstone_bricks_stairs_from_soulstone_bricks" | "createdeco:long_verdant_brick_stairs_from_verdant_brick_stairs_stonecutting" | "mysticalagriculture:essence/appliedenergistics2/engineering_press" | "botanypots:botanypots/crafting/orange_glazed_terracotta_compact_hopper_botany_pot" | "createdeco:dean_brick_slab_from_tiled_dean_bricks_stonecutting" | "tconstruct:common/slime/ichor/slimeball_from_congealed" | "minecraft:iron_ingot_from_nuggets" | "tconstruct:smeltery/casting/soul/glass" | "minecraft:golden_pickaxe" | "tconstruct:smeltery/casting/metal/slimesteel/nugget_gold_cast" | "createdeco:tiled_blue_brick_stairs_from_blue_bricks_stonecutting" | "enderio:recolor_fused_quartz_p_yellow" | "railways:sequenced_assembly/track_byg_white_mangrove_wide" | "mysticalagriculture:augment/step_assist" | "thermal:stonecutting/chiseled_rich_slag_from_stonecutting" | "create:filling/compat/regions_unexplored/silt_grass_block" | "create:deploying/waxed_copper_tile_stairs_from_adding_wax" | "railways:crafting/palettes/dyeing_8x/magenta_brass_wrapped_locometal_boiler" | "create:filling/builders_tea" | "railways:sequenced_assembly/track_blackstone_wide" | "tconstruct:smeltery/melting/metal/copper/gear" | "create:milling/compat/botania/yellow_petal" | "minecraft:redstone_torch" | "botanypots:minecraft/crop/sugar_cane" | "tconstruct:smeltery/melting/metal/signalum/ingot" | "createdeco:short_dean_bricks_from_corner_dean_bricks_stonecutting" | "thermal:machines/smelter/smelter_redstone_ore" | "createdeco:orange_placard" | "create:small_tuff_brick_stairs" | "tconstruct:tools/modifiers/salvage/upgrade/swift_sneak" | "mysticalagriculture:seed/crafting/rubber" | "create:crafting/kinetics/deployer" | "immersive_paintings:glow_painting" | "createdeco:short_red_brick_slab_from_tiled_red_bricks_stonecutting" | "minecraft:gray_bed" | "storagedrawers:crimson_full_drawers_4" | "create:crafting/materials/andesite_alloy" | "tconstruct:tools/modifiers/salvage/ability/spitting" | "createdeco:pearl_brick_stairs_from_corner_pearl_bricks_stonecutting" | "minecraft:white_terracotta" | "thermal:machines/pulverizer/pulverizer_copper_ore" | "storagedrawers:crimson_full_drawers_2" | "enderio:recolor_fused_quartz_na_green" | "storagedrawers:quantify_key" | "storagedrawers:crimson_full_drawers_1" | "minecraft:armor_stand" | "enderio:glider_wing" | "tconstruct:smeltery/casts/red_sand/molding/repair_kit" | "thermal:machines/bottler/bottler_black_concrete" | "enderio:resetting_lever_ten_inv" | "minecraft:pink_stained_glass_pane" | "minecraft:blue_dye_from_cornflower" | "create:cutting/runtime_generated/compat/tconstruct/bloodshroom_planks_to_bloodshroom_fence" | "tconstruct:smeltery/melting/scorched/faucet" | "sophisticatedbackpacks:chipped/alchemy_bench_upgrade" | "mysticalagriculture:essence/minecraft/oak_sapling" | "automobility:frame/pineapple" | "ae2:network/parts/panels_monitor" | "tconstruct:tools/parts/casting/bow_limb_sand_cast" | "minecraft:brown_banner" | "enderio:recolor_clear_glass_enm_green" | "minecraft:warped_hyphae" | "enderio:recolor_clear_glass_enp_red" | "mysticalagriculture:seed/reprocessor/tin" | "createdeco:long_dean_brick_slab_from_long_dean_bricks_stonecutting" | "railways:sequenced_assembly/track_twilightforest_sortingwood_wide" | "railways:sequenced_assembly/track_quark_azalea_wide" | "createdeco:corner_blue_brick_stairs_from_tiled_blue_brick_stairs_stonecutting" | "create:crimsite_pillar_from_stone_types_crimsite_stonecutting" | "botanypots:minecraft/soil/deepslate_gold_ore" | "tconstruct:common/materials/pig_iron_ingot_from_nuggets" | "ae2:shaped/stairs/chiseled_quartz_block" | "mysticalagriculture:essence/botania/white_mystical_flower" | "createaddition:compat/immersiveengineering/item_application/kiln_brick" | "tconstruct:smeltery/melting/metal/iron/nugget" | "create:cutting/runtime_generated/compat/minecraft/stripped_acacia_log_to_acacia_planks" | "createdeco:tiled_pearl_brick_wall_from_corner_pearl_bricks_stonecutting" | "enderio:recolor_fused_quartz_ena_pink" | "createdeco:long_scarlet_brick_wall_from_tiled_scarlet_bricks_stonecutting" | "minecraft:green_bed" | "createdeco:tiled_umber_brick_wall_from_umber_brick_wall_stonecutting" | "automobility:launch_gel" | "minecraft:red_sandstone_slab_from_red_sandstone_stonecutting" | "mysticalagriculture:essence/minecraft/gunpowder" | "tconstruct:smeltery/scorched/table" | "enderio:recolor_clear_glass_dnp_light_blue" | "thermal:machines/press/unpacking/press_rubber_unpacking" | "create:small_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "tconstruct:tools/modifiers/upgrade/offhanded" | "enderio:recolor_fused_quartz_dnm_purple" | "createdeco:blue_brick_slab" | "ae2:tools/paintballs_red" | "tconstruct:smeltery/casting/water/blue_concrete" | "botanypots:minecraft/soil/dried_kelp" | "minecraft:prismarine_brick_slab_from_prismarine_stonecutting" | "railways:crafting/palettes/dyeing_8x/orange_flat_riveted_locometal" | "create:crushing/silver_ore" | "createdeco:zinc_facade_from_stonecutting" | "create:crafting/logistics/red_table_cloth" | "thermal:storage/lumium_block" | "minecraft:waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "create_connected:crafting/palettes/copycat_catwalk" | "minecraft:gray_banner" | "minecraft:warped_stairs" | "tconstruct:smeltery/casting/metal/netherite/ingot_sand_cast" | "tconstruct:smeltery/melting/metal/bronze/shovel" | "botanypots:minecraft/soil/nether_quartz_ore" | "create:crushing/compat/silentgems/peridot_ore" | "ae2:network/cells/fluid_storage_cell_16k_storage" | "tconstruct:tools/modifiers/salvage/upgrade/reinforced" | "ae2:tools/paintballs_gray" | "minecraft:smooth_sandstone_slab" | "railways:crafting/palettes/dyeing_8x/purple_plated_locometal" | "tconstruct:tools/materials/hepatizon/nugget" | "minecraft:rail" | "create:cutting/runtime_generated/compat/minecraft/crimson_planks_to_crimson_trapdoor" | "tconstruct:smeltery/casts/sand/builder_cast/tough_binding" | "enderio:recolor_clear_glass_ena_light_gray" | "createdeco:tiled_umber_brick_wall_from_long_umber_brick_wall_stonecutting" | "botanypots:mysticalagriculture/soil/supremium_farmland" | "tconstruct:tools/materials/enderslime_vine" | "thermal:machines/crystallizer/crystallizer_emerald" | "railways:stonecutting/palettes/cycling/blue_slashed_locometal" | "create:cutting/compat/ars_nouveau/red_archwood_wood" | "tconstruct:smeltery/casting/metal/lead/nugget_gold_cast" | "ae2:network/cells/fluid_storage_cell_256k" | "create:milling/compat/biomesoplenty/rose" | "chiselsandbits:chisel_diamond" | "enderio:sag_milling/cobblestone" | "createdeco:mossy_umber_brick_slab_from_mossy_umber_bricks_stonecutting" | "create:deploying/exposed_cut_copper_slab_from_removing_wax" | "tconstruct:smeltery/melting/metal/slimesteel/nugget" | "tconstruct:smeltery/entity_melting/terracube" | "tconstruct:tools/modifiers/salvage/ability/brushing" | "createdeco:long_pearl_brick_wall_from_short_pearl_bricks_stonecutting" | "botanypots:botanypots/crafting/magenta_concrete_botany_pot" | "enderio:recolor_clear_glass_ea_orange" | "enderio:enchanting/fire_protection" | "create_connected:crafting/kinetics/empty_fan_catalyst_from_smoking" | "tconstruct:smeltery/melting/metal/silver/dust" | "tconstruct:smeltery/alloys/molten_invar" | "tconstruct:tools/materials/melting/steel" | "minecraft:polished_blackstone_from_blackstone_stonecutting" | "mysticalagradditions:tconstruct/casting/prudentium/ingot_sand_cast" | "createdeco:tiled_verdant_brick_slab_from_corner_verdant_brick_slab_stonecutting" | "tconstruct:world/wood/bloodshroom/hanging_sign" | "tconstruct:tools/materials/composite/slimewood_composite" | "tconstruct:tools/severing/turtle_shell" | "create:splashing/runtime_generated/compat/minecraft/purple_concrete_powder_to_purple_concrete" | "copycats:crafting/copycat_panel_from_half_panels" | "mysticalagriculture:seed/reprocessor/nature" | "tconstruct:smeltery/melting/metal/cobalt/reinforcement" | "enderio:recolor_clear_glass_brown" | "createaddition:rolling/aluminum_plate" | "mysticalagriculture:augment/poison_resistance" | "thermal:fuels/stirling/stirling_coal_coke_block" | "minecraft:crimson_planks" | "minecraft:smooth_red_sandstone" | "mysticalagriculture:supremium_ingot_block" | "tconstruct:smeltery/casts/sand/molding/large_plate" | "thermal:machines/press/packing3x3/press_copper_nugget_packing" | "railways:crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal" | "tconstruct:tools/materials/nahuatl" | "createdeco:long_red_bricks_from_corner_red_bricks_stonecutting" | "ae2:network/cells/item_storage_cell_16k_storage" | "railways:crafting/palettes/dyeing_8x/gray_locometal_smokebox" | "thermal:machines/press/packing3x3/press_raw_silver_packing" | "createdeco:short_verdant_brick_stairs_from_tiled_verdant_brick_stairs_stonecutting" | "railways:crafting/palettes/dyeing_8x/lime_copper_wrapped_locometal_boiler" | "minecraft:iron_nugget_from_blasting" | "thermal:machines/refinery/refinery_crude_oil" | "storagedrawers:priority_key" | "enderio:alloy_smelting/industrial_insulation_block" | "thermal:machines/press/unpacking/press_raw_silver_unpacking" | "railways:sequenced_assembly/track_biomesoplenty_redwood" | "tconstruct:tools/severing/player_head" | "create:milling/azure_bluet" | "enderio:recolor_clear_glass_p_brown" | "thermal:parts/lapis_gear" | "tconstruct:smeltery/melting/metal/bronze/helmet" | "copycats:crafting/copycat_half_panel" | "createdeco:black_placard_from_dyeing" | "ae2:matter_cannon/nuggets/cerium" | "minecraft:green_stained_glass_pane" | "minecraft:black_concrete_powder" | "createdeco:short_umber_brick_slab_from_umber_bricks_stonecutting" | "tconstruct:smeltery/casting/diamond/block" | "minecraft:quartz_pillar" | "railways:crafting/palettes/dyeing_8x/cyan_copper_wrapped_locometal" | "enderio:painting/painted_stairs" | "create:deploying/waxed_copper_shingles_from_adding_wax" | "railways:sequenced_assembly/track_natures_spirit_willow_wide" | "ae2:tools/certus_quartz_pickaxe" | "minecraft:dye_red_wool" | "create:crafting/logistics/purple_postbox" | "enderio:enchanting/impaling" | "mysticalagriculture:essence/minecraft/heart_of_the_sea" | "createdeco:short_dusk_brick_wall_from_short_dusk_bricks_stonecutting" | "create_connected:crafting/kinetics/redstone_link_wildcard" | "tconstruct:world/wood/bloodshroom/door" | "tconstruct:common/flint" | "railways:crafting/palettes/dyeing_8x/brown_flat_slashed_locometal" | "thermal:machines/smelter/smelter_glass_enderium" | "enderio:recolor_fused_quartz_e_light_gray" | "createdeco:yellow_shipping_container" | "railways:crafting/palettes/dyeing_8x/light_blue_copper_wrapped_locometal_boiler" | "createdeco:brass_bars_overlay_from_stonecutting" | "minecraft:blue_dye" | "minecraft:polished_diorite_slab_from_polished_diorite_stonecutting" | "thermal:smelting/bronze_ingot_from_dust_blasting" | "tconstruct:tools/building/hand_axe" | "thermal:machines/press/packing3x3/press_invar_nugget_packing" | "enderio:recolor_clear_glass_na_brown" | "createdeco:cracked_dean_bricks_from_dean_bricks_smelting" | "ae2:matter_cannon/nuggets/bromine" | "thermal:machines/smelter/smelter_invar_armor" | "railways:sequenced_assembly/track_jungle_wide" | "createdeco:long_scarlet_bricks_from_corner_scarlet_bricks_stonecutting" | "mysticalagriculture:essence/tconstruct/slimesteel_ingot" | "tconstruct:smeltery/melting/metal/nickel/ingot" | "automobility:engine/stone_engine" | "createdeco:blue_zinc_lamp" | "createdeco:tiled_umber_brick_slab_from_tiled_umber_bricks_stonecutting" | "tconstruct:smeltery/casting/metal/lead/block" | "railways:crafting/palettes/dyeing_8x/orange_brass_wrapped_locometal" | "minecraft:wooden_axe" | "railways:sequenced_assembly/track_oak" | "mysticalagradditions:essence/neutron_nugget" | "tconstruct:smeltery/casting/metal/constantan/block" | "mysticalagriculture:stonecutting/soulstone_bricks_wall_from_soulstone_bricks" | "ae2:decorative/light_detector" | "create:small_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "mysticalagriculture:enchanter/blast_protection" | "tconstruct:smeltery/casting/metal/tin/nugget_gold_cast" | "create:smelting/ingot_silver_compat_immersiveengineering" | "bellsandwhistles:bogie_steps/andesite_bogie_steps_stonecutting" | "enchantinginfuser:advanced_enchanting_infuser" | "create:oak_window_pane" | "tconstruct:smeltery/casting/slime/ichor/congealed" | "tconstruct:tools/materials/treated_wood" | "thermal:machines/smelter/smelter_bronze_plate_to_ingot" | "minecraft:stone_stairs_from_stone_stonecutting" | "create:polished_cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "createdeco:industrial_iron_nugget_from_industrial_iron_ingot" | "mysticalagriculture:essence/mekanism/refined_obsidian_ingot" | "thermal:machines/press/packing3x3/press_lumium_packing" | "minecraft:dried_kelp" | "railways:sequenced_assembly/track_blackstone_narrow" | "enderio:wired_charger" | "create:andesite_from_stone_types_andesite_stonecutting" | "createdeco:copper_support_wedge" | "minecraft:iron_bars" | "create:crafting/appliances/package_filter_clear" | "createdeco:long_pearl_brick_stairs_from_short_pearl_bricks_stonecutting" | "railways:crafting/palettes/dyeing_1x/magenta_brass_wrapped_locometal" | "mysticalagriculture:seed/reprocessor/mithril" | "tconstruct:smeltery/melting/scorched/lantern" | "createdeco:long_dean_brick_slab_from_dean_bricks_stonecutting" | "tconstruct:common/slime/earth/congealed" | "tconstruct:smeltery/casts/gold/tough_handle" | "enderio:sag_milling/grass" | "createdeco:tiled_blue_bricks_from_corner_blue_bricks_stonecutting" | "createdeco:tiled_scarlet_brick_stairs_from_corner_scarlet_bricks_stonecutting" | "createdeco:long_red_brick_wall_from_tiled_red_brick_wall_stonecutting" | "tconstruct:smeltery/melting/diamond/axes" | "mysticalagriculture:seed/infusion/copper" | "tconstruct:tools/severing/chicken_feather" | "tconstruct:smeltery/casting/obsidian/chest" | "createdeco:long_verdant_brick_stairs" | "railways:crafting/palettes/dyeing_8x/brown_iron_wrapped_locometal_boiler" | "tconstruct:tools/modifiers/ability/luck_level_1" | "create:horizontal_framed_glass_pane_from_glass_panes_colorless_stonecutting" | "mysticalagriculture:awakened_supremium_upgrade" | "tconstruct:tools/modifiers/ability/luck_level_3" | "tconstruct:tools/modifiers/ability/luck_level_2" | "tconstruct:common/glass/blue_clear_stained_glass_pane" | "mysticalagradditions:tertium_paxel" | "create:crafting/curiosities/minecart_coupling" | "create:cut_deepslate_brick_slab" | "create:cutting/runtime_generated/compat/minecraft/stripped_bamboo_block_to_bamboo_planks" | "createdeco:long_dean_brick_wall_from_tiled_dean_bricks_stonecutting" | "create:deploying/oxidized_copper_shingle_stairs_from_removing_wax" | "create:cut_granite_stairs_from_stone_types_granite_stonecutting" | "automobility:frame/standard_black" | "create:crushing/compat/byg/emeraldite_ore" | "enderio:fluid_conduit" | "minecraft:mud_brick_wall_from_mud_bricks_stonecutting" | "create:milling/wheat" | "mysticalagriculture:seed/crafting/end_steel" | "create:polished_cut_diorite_slab_from_stone_types_diorite_stonecutting" | "create:compacting/honey" | "mysticalagriculture:seed/infusion/blazing_crystal" | "create:milling/compat/botania/light_gray_petal" | "ae2:misc/chests_sky_stone" | "railways:stonecutting/palettes/cycling/light_blue_flat_slashed_locometal" | "create:milling/grass" | "thermal:machines/pulverizer/pulverizer_blitz_rod" | "create:splashing/ic2/crushed_raw_uranium" | "createdeco:long_dusk_bricks_from_tiled_dusk_bricks_stonecutting" | "thermal:machines/press/press_lumium_nugget_to_coin" | "createdeco:scarlet_brick_stairs_from_corner_scarlet_brick_stairs_stonecutting" | "tconstruct:tools/materials/casting/invar" | "railways:crafting/palettes/dyeing_1x/cyan_plated_locometal" | "botanypots:botanypots/crafting/light_gray_concrete_hopper_botany_pot" | "createdeco:long_scarlet_brick_slab_from_short_scarlet_bricks_stonecutting" | "railways:stonecutting/palettes/cycling/black_plated_locometal" | "create_more_additions:electrum/equipment/electrum_sword" | "tconstruct:tools/modifiers/salvage/ability/slurping" | "enderio:recolor_clear_glass_dnp_black" | "createdeco:long_red_brick_wall_from_short_red_bricks_stonecutting" | "minecraft:deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "create:splashing/runtime_generated/compat/minecraft/blue_concrete_powder_to_blue_concrete" | "create:crafting/appliances/cardboard_helmet" | "tconstruct:smeltery/melting/metal/bronze/mekanism_shield" | "botanypots:botanypots/crafting/light_blue_glazed_terracotta_botany_pot" | "thermal:earth_charge/emerald_dust_from_emerald" | "railways:mechanical_crafting/lime_locometal_boiler" | "createdeco:long_scarlet_brick_wall_from_short_scarlet_bricks_stonecutting" | "thermal:devices/tree_extractor/tree_extractor_boost_phytogro" | "botanypots:minecraft/crop/melon" | "mysticalagradditions:prudentium_apple" | "minecraft:torch" | "createdeco:short_dean_brick_slab_from_corner_dean_brick_slab_stonecutting" | "createdeco:brass_support_wedge" | "railways:stonecutting/palettes/cycling/yellow_locometal_pillar" | "ae2:matter_cannon/nuggets/titanium" | "mysticalagriculture:essence/redstone_arsenal/flux_ingot" | "tconstruct:smeltery/melting/scorched/grout" | "tconstruct:tools/modifiers/slotless/embellishment/wood/slimewood_greenheart" | "create:crafting/logistics/light_blue_table_cloth_clear" | "botanypots:minecraft/crop/pumpkin" | "create:crafting/kinetics/black_seat" | "createdeco:corner_umber_brick_wall_from_long_umber_bricks_stonecutting" | "mysticalagradditions:tconstruct/casting/prudentium/ingot_gold_cast" | "create:milling/allium" | "create:cutting/runtime_generated/compat/thermal/rubberwood_log_to_stripped_rubberwood_log" | "thermal:machines/bottler/bottler_brown_concrete" | "tconstruct:smeltery/casting/metal/invar/plate_gold_cast" | "createdeco:corner_umber_bricks_from_umber_bricks_stonecutting" | "enderio:recolor_clear_glass_m_black" | "createdeco:long_pearl_brick_slab_from_pearl_brick_slab_stonecutting" | "createdeco:short_dusk_bricks_from_long_dusk_bricks_stonecutting" | "railways:sequenced_assembly/track_quark_ancient_narrow" | "tconstruct:common/firewood/nahuatl_fence" | "mysticalagriculture:seed/reprocessor/marble" | "createaddition:charging/weathered_copper_shingles" | "tconstruct:smeltery/melting/amethyst/bud_large" | "create_connected:item_application/freezing_catalyst_from_empty" | "thermal:smelting/cinnabar_from_smelting" | "tconstruct:smeltery/casts/sand/builder_block/tool_binding" | "create:crafting/copper/waxed_oxidized_copper_shingles_from_honeycomb" | "railways:crafting/palettes/dyeing_1x/orange_flat_riveted_locometal" | "create_more_additions:electrum/equipment/electrum_leggings" | "botanypots:mysticalagriculture/crop/flux_infused_gem" | "tconstruct:common/firewood/blazewood_slab" | "create:splashing/runtime_generated/compat/minecraft/pink_concrete_powder_to_pink_concrete" | "mysticalagriculture:gear/prudentium_axe" | "bellsandwhistles:door_steps/copper_grab_rails_stonecutting" | "createdeco:verdant_brick_stairs_from_long_verdant_brick_stairs_stonecutting" | "minecraft:cherry_slab" | "thermal:machines/smelter/smelter_iron_dust" | "railways:sequenced_assembly/track_blue_skies_starlit" | "createdeco:corner_dusk_brick_wall_from_short_dusk_bricks_stonecutting" | "create:cutting/runtime_generated/compat/thermal/rubberwood_planks_to_rubberwood_button" | "railways:stonecutting/palettes/cycling/red_locometal_pillar" | "create:milling/clay" | "railways:crafting/palettes/dyeing_1x/orange_iron_wrapped_locometal" | "botanypots:mysticalagriculture/crop/conductive_alloy" | "tconstruct:smeltery/casting/metal/invar/nugget_sand_cast" | "tconstruct:tools/modifiers/upgrade/scope" | "enderio:recolor_fused_quartz_na_white" | "expatternprovider:ex_emc_import_bus" | "create:pressing/compat/immersiveengineering/plate_aluminum" | "create:crushing/compat/immersiveengineering/coal_coke" | "createdeco:tiled_verdant_brick_stairs_from_verdant_brick_stairs_stonecutting" | "createdeco:yellow_placard_from_dyeing" | "createdeco:long_verdant_brick_slab_from_long_verdant_bricks_stonecutting" | "minecraft:orange_bed" | "create:crafting/materials/bound_cardboard_block" | "mysticalagriculture:seed/infusion/fluix" | "createdeco:corner_verdant_brick_wall_from_verdant_brick_wall_stonecutting" | "tconstruct:smeltery/casting/metal/refined_obsidian/ingot_sand_cast" | "create:milling/compat/atmospheric/hot_monkey_brush" | "ae2:network/cells/item_storage_cell_16k" | "railways:crafting/palettes/dyeing_8x/pink_riveted_locometal" | "create:filling/glowstone" | "tconstruct:smeltery/melting/metal/pig_iron/ingot" | "railways:sequenced_assembly/track_create_dd_smoked_narrow" | "enderio:recolor_fused_quartz_a_cyan" | "botanypots:mysticalagriculture/crop/refined_glowstone" | "tconstruct:smeltery/casting/filling/seared_ingot_gauge" | "thermal:augments/potion_duration_augment" | "minecraft:red_stained_glass_pane" | "tconstruct:compat/treated_wood" | "create:splashing/gravel" | "railways:sequenced_assembly/track_biomesoplenty_dead_narrow" | "create:crafting/kinetics/andesite_door" | "railways:stonecutting/palettes/cycling/pink_locometal_smokebox" | "thermal:machines/pulverizer/pulverizer_ender_pearl" | "railways:sequenced_assembly/track_tfc_blackwood_wide" | "mysticalagriculture:essence/minecraft/cobbled_deepslate" | "enderio:recolor_fused_quartz_na_magenta" | "createdeco:andesite_bars_overlay_from_stonecutting" | "enderio:recolor_clear_glass_e_white" | "mysticalagradditions:tconstruct/tools/casting/inferium" | "minecraft:dark_oak_planks" | "tconstruct:tools/armor/plate_boots" | "minecraft:granite_wall" | "createdeco:dean_brick_wall_from_corner_dean_brick_wall_stonecutting" | "tconstruct:smeltery/casting/metal/netherite/ingot_gold_cast" | "create:crushing/raw_lead_block" | "thermal:augments/machine_null_augment" | "railways:stonecutting/palettes/cycling/light_blue_slashed_locometal" | "tconstruct:smeltery/casting/amethyst/block" | "thermal:device_soil_infuser" | "createdeco:corner_dusk_brick_wall_from_long_dusk_brick_wall_stonecutting" | "minecraft:mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting" | "botanypots:mysticalagradditions/crop/awakened_draconium" | "minecraft:warped_fence" | "createaddition:compat/tconstruct/hepatizon" | "railways:crafting/track_switch_andesite" | "botanypots:minecraft/crop/kelp" | "railways:crafting/palettes/dyeing_1x/black_flat_riveted_locometal" | "mysticalagriculture:soulstone_slab" | "tconstruct:smeltery/casting/blazewood_fence" | "tconstruct:tools/materials/slimewood/skyroot_planks" | "createdeco:industrial_iron_ladder_from_stonecutting" | "enderio:collision_token_clear_glass_p" | "enderio:recolor_fused_quartz_dnm_lime" | "enderio:collision_token_clear_glass_m" | "enderio:collision_token_clear_glass_a" | "minecraft:loom" | "thermal:machines/press/unpacking/press_redstone_unpacking" | "chiselsandbits:mirror_over_y" | "chiselsandbits:mirror_over_z" | "mysticalagriculture:gear/prudentium_bow" | "chiselsandbits:mirror_over_x" | "tconstruct:smeltery/melting/seared/melter" | "create:smelting/copper_ingot_from_crushed" | "createdeco:corner_verdant_brick_stairs_from_long_verdant_brick_stairs_stonecutting" | "tconstruct:smeltery/melting/metal/electrum/ingot" | "create:small_calcite_brick_stairs" | "thermal:machines/press/press_tin_ingot_to_coin" | "mysticalagriculture:augment/mining_aoe_iii" | "enderio:recolor_fused_quartz_enm_purple" | "createdeco:short_dean_brick_stairs_from_corner_dean_brick_stairs_stonecutting" | "mysticalagradditions:gaia_spirit_crux" | "thermal:machines/press/packing2x2/press_bricks_packing" | "createdeco:umber_brick_stairs_from_tiled_umber_bricks_stonecutting" | "create:crafting/appliances/name_tag" | "tconstruct:smeltery/melting/slime/earth/sapling" | "thermal:machines/smelter/smelter_lead_plate_to_ingot" | "railways:crafting/palettes/dyeing_1x/green_locometal_pillar" | "tconstruct:smeltery/melting/obsidian/dust" | "tconstruct:smeltery/casting/metal/enderium/gear_sand_cast" | "enderio:painting/painted_wall_frompainted" | "minecraft:polished_blackstone" | "createdeco:dean_brick_slab_from_tiled_dean_brick_slab_stonecutting" | "createdeco:long_umber_bricks_from_corner_umber_bricks_stonecutting" | "createdeco:corner_umber_brick_slab" | "botanypots:minecraft/crop/sweet_berry_bush" | "tconstruct:tools/parts/casting/bow_limb_gold_cast" | "createdeco:corner_verdant_brick_stairs_from_short_verdant_brick_stairs_stonecutting" | "tconstruct:smeltery/melting/quartz/geore/cluster" | "create:crafting/logistics/white_postbox_from_other_postbox" | "botanypots:mysticalagriculture/crop/queens_slime" | "minecraft:dye_purple_carpet" | "railways:crafting/palettes/dyeing_1x/blue_plated_locometal" | "mysticalagriculture:essence/minecraft/porkchop" | "tconstruct:smeltery/melting/metal/brass/dust" | "railways:crafting/palettes/dyeing_8x/purple_locometal_smokebox" | "ae2:tools/nether_quartz_pickaxe" | "enderio:recolor_fused_quartz_ep_red" | "mysticalagriculture:gear/imperium_leggings" | "tconstruct:tools/severing/spider_head" | "minecraft:deepslate_brick_slab" | "tconstruct:smeltery/melting/metal/gold/boots" | "ae2wtlib:pattern_access/wireless_pattern_access_terminal" | "railways:crafting/palettes/dyeing_1x/cyan_riveted_locometal" | "minecraft:polished_blackstone_brick_stairs_from_blackstone_stonecutting" | "createdeco:tiled_dusk_brick_slab_from_corner_dusk_brick_slab_stonecutting" | "enderio:recolor_fused_quartz_dnm_blue" | "enderio:alloy_smelting/ender_pearl" | "thermal:machines/sawmill/sawmill_mangrove_logs" | "tconstruct:tools/materials/melting/pewter" | "createdeco:mossy_umber_brick_stairs_from_mossy_umber_bricks_stonecutting" | "create:milling/compat/byg/cyan_rose" | "ae2:tools/paintballs_purple" | "enderio:recolor_clear_glass_enm_white" | "enderio:ae_covered_dense_cable" | "sophisticatedbackpacks:compacting_upgrade" | "createdeco:umber_brick_slab_from_umber_bricks_stonecutting" | "create:milling/compat/byg/fairy_slipper" | "thermal:fuels/lapidary/lapidary_diamond" | "mysticalagriculture:soulium_ingot_block" | "mysticalagriculture:souls/porkchop" | "mysticalagriculture:seed/infusion/cyanite" | "thermal:storage/invar_nugget_from_ingot" | "botanypots:botanypots/crafting/magenta_glazed_terracotta_botany_pot" | "create:cut_crimsite_from_stone_types_crimsite_stonecutting" | "mysticalagriculture:seed/crafting/elementium" | "tconstruct:smeltery/casts/sand/molding/tool_handle" | "create:cutting/runtime_generated/compat/thermal/rubberwood_planks_to_rubberwood_slab" | "railways:crafting/palettes/dyeing_1x/white_locometal_pillar" | "createdeco:umber_brick_stairs_from_short_umber_brick_stairs_stonecutting" | "create:layered_granite_from_stone_types_granite_stonecutting" | "create:crafting/logistics/repackager_from_conversion" | "createdeco:long_scarlet_bricks_from_tiled_scarlet_bricks_stonecutting" | "tconstruct:tables/modifier_worktable" | "minecraft:acacia_sign" | "tconstruct:common/glass/yellow_clear_stained_glass_pane" | "minecraft:chest_minecart" | "enderio:grindingball/conductive_alloy_grinding_ball" | "tconstruct:smeltery/casting/scorched/brick_gold_cast" | "mysticalagriculture:seed/infusion/mithril" | "tconstruct:tools/parts/casting/bow_grip_sand_cast" | "thermal:machines/press/unpacking/press_snow_unpacking" | "create:crafting/logistics/brass_funnel" | "minecraft:baked_potato_from_campfire_cooking" | "tconstruct:smeltery/entity_melting/heads/piglin" | "enderio:recolor_fused_quartz_m_orange" | "create:compacting/ice" | "mysticalagriculture:essence/common/constantan_ingot" | "railways:crafting/palettes/dyeing_1x/cyan_flat_slashed_locometal" | "tconstruct:smeltery/scorched/faucet" | "minecraft:deepslate_bricks_from_polished_deepslate_stonecutting" | "createdeco:tiled_umber_brick_stairs_from_corner_umber_brick_stairs_stonecutting" | "tconstruct:tools/materials/wood/sticks" | "thermal:machines/insolator/insolator_fire_coral" | "mysticalagriculture:enchanter/riptide" | "tconstruct:tools/modifiers/worktable/remove_modifier_venom" | "createdeco:locked_industrial_iron_door" | "railways:sequenced_assembly/track_byg_fir_narrow" | "create:crushing/amethyst_block" | "create:cutting/runtime_generated/compat/minecraft/warped_planks_to_warped_button" | "createdeco:short_scarlet_brick_stairs_from_scarlet_brick_stairs_stonecutting" | "createdeco:tiled_red_brick_stairs_from_long_red_bricks_stonecutting" | "createdeco:short_blue_bricks_from_long_blue_bricks_stonecutting" | "tconstruct:smeltery/casting/metal/nickel/nugget_sand_cast" | "extra_gauges:integer_gauge" | "railways:crafting/palettes/dyeing_1x/light_blue_brass_wrapped_locometal" | "thermal:ice_grenade_4" | "enderio:alloy_smelting/energetic_alloy_ingot" | "enderio:resetting_lever_three_hundred_from_inv" | "createdeco:tiled_pearl_brick_wall_from_short_pearl_brick_wall_stonecutting" | "tconstruct:smeltery/melting/metal/manyullyn/ingot" | "railways:crafting/conductor_whistle" | "createaddition:liquid_burning/compat/thermal/heavy_oil" | "createdeco:tiled_verdant_brick_slab_from_verdant_brick_slab_stonecutting" | "ae2:misc/deconstruction_certus_quartz_bricks" | "createdeco:tiled_blue_brick_slab_from_long_blue_brick_slab_stonecutting" | "enderio:recolor_fused_quartz_dnp_lime" | "tconstruct:smeltery/seared/seared_brick_kiln" | "create:crafting/logistics/display_link" | "enderio:recolor_clear_glass_light_blue" | "enderio:ender_fluid_conduit_upgrade" | "enderio:soulbinding/broken_spawner" | "minecraft:red_stained_glass_pane_from_glass_pane" | "createdeco:long_scarlet_brick_slab_from_tiled_scarlet_bricks_stonecutting" | "enderio:sag_milling/vibrant_crystal" | "tconstruct:tools/modifiers/upgrade/padded" | "minecraft:waxed_cut_copper_stairs_from_waxed_copper_block_stonecutting" | "tconstruct:tools/modifiers/salvage/ability/silky" | "thermal:machines/centrifuge/centrifuge_blue_orchid" | "create:splashing/thermal/crushed_raw_nickel" | "thermal:fuels/numismatic/numismatic_bronze_coin" | "create:crushing/osmium_ore" | "tconstruct:tools/modifiers/salvage/ability/pockets" | "tconstruct:smeltery/casts/sand/molding/leggings_plating" | "tconstruct:smeltery/casting/metal/cobalt/nugget_gold_cast" | "mysticalagradditions:imperium_coal" | "tconstruct:smeltery/melting/metal/osmium/dust" | "create:milling/compat/regions_unexplored/hibiscus" | "createdeco:long_dean_brick_stairs_from_corner_dean_bricks_stonecutting" | "tconstruct:common/glass/pink_clear_stained_glass_pane_from_panes" | "mysticalagriculture:seed/crafting/hepatizon" | "mysticalagriculture:essence/minecraft/honeycomb" | "minecraft:polished_diorite_stairs_from_polished_diorite_stonecutting" | "mysticalagriculture:essence/common/tungsten_ingot" | "botanypots:botanypots/crafting/red_glazed_terracotta_hopper_botany_pot" | "tconstruct:smeltery/melting/clay/pot" | "sophisticatedbackpacks:advanced_restock_upgrade" | "thermal:augments/rf_coil_storage_augment" | "thermal:machines/insolator/insolator_sunflower" | "createdeco:short_verdant_brick_stairs_from_verdant_brick_stairs_stonecutting" | "create:framed_glass_from_glass_colorless_stonecutting" | "create_connected:crafting/kinetics/brake" | "minecraft:warped_sign" | "railways:sequenced_assembly/track_tfc_chestnut_narrow" | "tconstruct:smeltery/melting/obsidian/block" | "mysticalagriculture:essence/minecraft/jungle_sapling" | "tconstruct:common/glass/yellow_clear_stained_glass" | "createaddition:crafting/rolling_mill" | "tconstruct:smeltery/seared/seared_stone_slab" | "minecraft:bamboo_sign" | "tconstruct:smeltery/melting/metal/refined_obsidian/mekanism_shield" | "thermal:ice_tnt" | "tconstruct:smeltery/casting/filling/seared_lantern_full" | "create:crafting/kinetics/spout" | "thermal:machines/press/unpacking/press_niter_unpacking" | "tconstruct:smeltery/casting/metal/aluminum/wire_sand_cast" | "create:cutting/runtime_generated/compat/minecraft/stripped_mangrove_log_to_mangrove_planks" | "enderio:recolor_fused_quartz_dp_light_gray" | "create:haunting/soul_torch" | "enderio:recolor_fused_quartz_dnp_blue" | "create_more_additions:renewable_silver" | "tconstruct:smeltery/casting/metal/netherite/block" | "mysticalagriculture:seed/crafting/flux_infused_ingot" | "mysticalagradditions:essence/dragon_head" | "create:copper_scaffolding_from_ingots_copper_stonecutting" | "tconstruct:smeltery/melting/metal/copper/geore/cluster" | "mysticalagriculture:mystical_flower_agglomeratio" | "ae2:network/cables/dense_smart_cyan" | "botanypots:minecraft/soil/dark_oak_wood" | "minecraft:lime_glazed_terracotta" | "createdeco:tiled_red_brick_stairs_from_short_red_bricks_stonecutting" | "create:cut_scoria_brick_slab_recycling" | "enderio:recolor_clear_glass_e_cyan" | "mysticalagriculture:seed/reprocessor/ruby" | "createdeco:blue_placard_from_dyeing" | "createdeco:long_pearl_brick_stairs_from_tiled_pearl_brick_stairs_stonecutting" | "mysticalagriculture:souls/glow_ink_sac" | "enderio:recolor_clear_glass_d_green" | "createdeco:tiled_verdant_brick_wall_from_long_verdant_bricks_stonecutting" | "create:cut_calcite_brick_wall" | "railways:crafting/palettes/dyeing_8x/light_blue_locometal_pillar" | "railways:crafting/palettes/dyeing_1x/white_brass_wrapped_locometal" | "tconstruct:smeltery/melting/metal/platinum/ore_sparse" | "thermal:machines/press/packing3x3/press_prismarine_bricks_packing" | "tconstruct:tools/materials/osmium/block" | "create:crushing/compat/silentgems/citrine_ore" | "botanypots:botanypots/crafting/gray_concrete_hopper_botany_pot" | "create:milling/compat/regions_unexplored/blue_lupine" | "create:crafting/kinetics/framed_glass_trapdoor" | "thermal:machines/press/unpacking/press_lead_unpacking" | "create:cut_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "thermal:machines/press/packing2x2/press_magma_packing" | "create:crafting/kinetics/secondary_linear_chassis_from_conversion" | "create:deploying/weathered_copper_shingle_slab_from_removing_wax" | "create_connected:crafting/palettes/copycat_vertical_step_compat" | "thermal:smelting/slag_from_smelting" | "railways:stonecutting/riveted_locometal" | "botanypots:mysticalagriculture/crop/lapis_lazuli" | "create_more_additions:silver/crushed_raw_silver_from_crushing_deepslate_ore" | "create:crushing/compat/druidcraft/amber_ore" | "enderio:sag_milling/orange_tulip" | "tconstruct:smeltery/melting/metal/lead/block" | "tconstruct:gadgets/frame/gold" | "tconstruct:smeltery/melting/slime/ender/bud_cluster" | "botanypots:botanypots/crafting/orange_concrete_hopper_botany_pot" | "mysticalagriculture:infusion_pedestal" | "tconstruct:tables/crafting_station_from_logs" | "tconstruct:tables/tinker_station_damaging/lava_bucket" | "tconstruct:smeltery/casts/red_sand/molding/gears" | "copycats:crafting/copycat_box" | "create:milling/compat/byg/allium_flower_bush" | "tconstruct:smeltery/casts/gold/nuggets" | "enderio:alloy_smelting/fused_quartz_d_from_main_alt" | "createdeco:long_verdant_brick_slab" | "tconstruct:smeltery/casting/metal/invar/coin_gold_cast" | "botanypots:mysticalagriculture/crop/sheep" | "mysticalagriculture:imperium_ingot_uncraft" | "tconstruct:smeltery/casting/metal/bronze/ingot_gold_cast" | "mysticalagradditions:insanium_ingot_uncraft" | "enderio:sag_milling/leaves" | "tconstruct:tools/modifiers/slotless/overslime/ichor_block" | "tconstruct:tools/materials/slimesteel/nugget" | "create:milling/lilac" | "createdeco:long_scarlet_brick_wall_from_corner_scarlet_bricks_stonecutting" | "createdeco:tiled_dusk_brick_slab_from_dusk_brick_slab_stonecutting" | "createdeco:tiled_umber_brick_slab_from_corner_umber_bricks_stonecutting" | "createaddition:charging/exposed_copper" | "tconstruct:tools/modifiers/worktable/enchantment_converting/slotless_tool" | "minecraft:iron_block" | "minecraft:dark_oak_door" | "tconstruct:common/materials/manyullyn_nugget_from_ingot" | "railways:sequenced_assembly/track_natures_spirit_olive_narrow" | "createdeco:short_blue_brick_wall_from_blue_brick_wall_stonecutting" | "enderio:sag_milling/ender_crystal" | "ae2:matter_cannon/nuggets/technetium" | "tconstruct:tools/modifiers/salvage/ability/pathing" | "create:deploying/weathered_copper_tile_slab_from_removing_wax" | "createdeco:dusk_brick_stairs_from_long_dusk_brick_stairs_stonecutting" | "enderio:alloy_smelting/fused_quartz_e_from_main_alt" | "railways:sequenced_assembly/track_ender" | "thermal:smelting/iron_ingot_from_dust_blasting" | "tconstruct:smeltery/casts/red_sand/builder_cast/rods" | "mysticalagriculture:augment/attack_aoe_i" | "enderio:painting/painted_stairs_frompainted" | "thermal:storage/lumium_nugget_from_ingot" | "tconstruct:tools/recycling/war_pick" | "create:exposed_copper_tile_stairs_from_exposed_copper_tiles_stonecutting" | "mysticalagriculture:seed/crafting/platinum" | "railways:crafting/palettes/dyeing_8x/black_iron_wrapped_locometal_boiler" | "thermal:brown_concrete_powder_with_slag" | "tconstruct:smeltery/casting/metal/netherite/nugget_sand_cast" | "create:milling/compat/byg/amaranth" | "thermal:machines/sawmill/sawmill_warped_stems" | "create:crafting/materials/rose_quartz" | "create:crushing/compat/neapolitan/ice" | "minecraft:copper_ingot_from_blasting_deepslate_copper_ore" | "create:crafting/materials/rose_quartz_tiles_from_conversion" | "tconstruct:smeltery/melting/metal/steel/chestplate" | "create:cutting/runtime_generated/compat/minecraft/stripped_warped_stem_to_warped_planks" | "thermal:machines/smelter/smelter_glass_obsidian" | "enderio:sag_milling/clay" | "ae2:matter_cannon/nuggets/phosphorus" | "tconstruct:smeltery/melting/metal/steel/leggings" | "enderio:recolor_clear_glass_dp_green" | "tconstruct:compat/ceramics/porcelain/gauge" | "ae2:matter_cannon/nuggets/electrum" | "mysticalagriculture:seed/crafting/mithril" | "chiselsandbits:bit_bag" | "minecraft:golden_boots" | "create:splashing/runtime_generated/compat/minecraft/black_concrete_powder_to_black_concrete" | "minecraft:pink_dye_from_red_white_dye" | "thermal:machines/smelter/smelter_silver_dust" | "botanypots:minecraft/crop/crimson_fungus" | "tconstruct:smeltery/casts/gold/leggings_plating" | "railways:crafting/palettes/dyeing_8x/orange_iron_wrapped_locometal" | "automobility:wheel/bejeweled_wheel" | "mysticalagriculture:gear/awakened_supremium_boots" | "botanypots:mysticalagriculture/crop/ironwood" | "automobility:wheel/street_wheel" | "minecraft:cherry_planks" | "tconstruct:smeltery/seared/chute_retextured" | "railways:crafting/palettes/dyeing_1x/yellow_locometal_pillar" | "tconstruct:tools/modifiers/ability/spilling" | "tconstruct:smeltery/melting/metal/refined_glowstone/shovel" | "thermal:machines/press/packing2x2/press_honeycomb_packing" | "minecraft:nether_brick_wall_from_nether_bricks_stonecutting" | "minecraft:oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "mysticalagradditions:imperium_apple" | "minecraft:silence_armor_trim_smithing_template" | "minecraft:smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting" | "enderio:energy_conduit" | "create:crushing/nether_gold_ore" | "tconstruct:tools/severing/spider_eye" | "tconstruct:tools/modifiers/slotless/recapitated" | "create:crafting/logistics/orange_table_cloth" | "tconstruct:smeltery/casting/metal/osmium/block" | "ae2:inscriber/logic_processor_press" | "tconstruct:smeltery/melting/metal/netherite/shovel" | "enderio:soulbinding/frank_n_zombie" | "createdeco:copper_coin" | "enderio:recolor_fused_quartz_enm_light_blue" | "extendedae_plus:64x_crafting_accelerator" | "mysticalagriculture:tertium_block" | "tconstruct:tools/materials/slimewood/enderbark_logs" | "createdeco:mossy_dusk_bricks_from_vine" | "enderio:recolor_clear_glass_em_cyan" | "create:filling/honeyed_apple" | "tconstruct:smeltery/melting/metal/osmium/helmet" | "createdeco:blue_brick_wall_from_corner_blue_bricks_stonecutting" | "thermal:smelting/lead_ingot_from_ore_smelting" | "mysticalagriculture:seed/reprocessor/pig_iron" | "mysticalagriculture:augment/absorption_iv" | "create:crushing/deepslate_zinc_ore" | "tconstruct:smeltery/casting/obsidian/nahuatl" | "mysticalagriculture:essence/minecraft/potato" | "ae2:network/cables/smart_red" | "createaddition:crafting/modular_accumulator_gold" | "tconstruct:smeltery/melting/metal/nicrosil/ingot" | "railways:sequenced_assembly/track_twilightforest_canopy_wide" | "create_connected:crafting/palettes/copycat_vertical_step_from_conversion" | "tconstruct:smeltery/casting/metal/steel/block" | "createdeco:corner_scarlet_brick_stairs_from_short_scarlet_bricks_stonecutting" | "minecraft:light_blue_concrete_powder" | "tconstruct:smeltery/casting/metal/rose_gold/gear_sand_cast" | "tconstruct:tools/materials/wood/logs/oak" | "minecraft:granite_stairs" | "enderio:grindingball/vibrant_alloy_grinding_ball" | "create:small_deepslate_brick_slab" | "mysticalagriculture:souls/rabbit" | "create:haunting/infested_chiseled_stone_bricks" | "create:oxidized_copper_tile_stairs_from_oxidized_copper_tiles_stonecutting" | "mysticalagriculture:augment/absorption_ii" | "enderio:recolor_fused_quartz_d_red" | "createdeco:dean_brick_slab" | "tconstruct:tools/parts/builder/tool_binding" | "thermal:machines/centrifuge/centrifuge_invar_dust" | "tconstruct:smeltery/melting/metal/gold/ore_singular" | "createdeco:locked_andesite_door" | "create:vertical_framed_glass_pane_from_glass_panes_colorless_stonecutting" | "thermal:rockwool/gray_rockwool_from_dye" | "thermal:machine_smelter" | "createaddition:mixing/netherrack" | "create:deploying/copper_shingle_slab_from_deoxidising" | "tconstruct:smeltery/casting/metal/dawnstone/nugget_sand_cast" | "railways:crafting/palettes/dyeing_1x/white_iron_wrapped_locometal_boiler" | "tconstruct:world/wood/greenheart/door" | "thermal:machines/bottler/bottler_gray_concrete" | "tconstruct:smeltery/casts/sand/builder_cast/tool_handle" | "tconstruct:smeltery/casting/metal/uranium/coin_sand_cast" | "minecraft:dye_orange_wool" | "enderio:tank_fill/light_gray_concrete" | "tconstruct:smeltery/melting/metal/refined_glowstone/helmet" | "tconstruct:smeltery/melting/metal/aluminum/ore_sparse" | "immersive_aircraft:warship" | "tconstruct:tools/modifiers/salvage/ability/frost_walker" | "mysticalagriculture:prosperity_gemstone" | "botanypots:minecraft/soil/mycelium" | "tconstruct:smeltery/melting/metal/lead/ore_sparse" | "create:crafting/logistics/purple_table_cloth_clear" | "mysticalagriculture:seed/infusion/knightmetal" | "createdeco:tiled_blue_brick_stairs_from_tiled_blue_bricks_stonecutting" | "createrailwaysnavigator:advanced_display_small" | "mysticalagriculture:upgrade_base" | "createdeco:tiled_verdant_bricks_from_corner_verdant_bricks_stonecutting" | "tconstruct:tools/parts/builder/maille" | "createdeco:long_red_brick_wall_from_corner_red_brick_wall_stonecutting" | "enderio:recolor_fused_quartz_enp_brown" | "minecraft:cyan_banner" | "ae2:network/cables/smart_fluix" | "create:veridium_from_stone_types_veridium_stonecutting" | "create:crafting/materials/copper_nugget" | "enderio:resetting_lever_thirty" | "tconstruct:tools/modifiers/slotless/embellishment/wood/blazewood" | "railways:crafting/palettes/dyeing_8x/orange_copper_wrapped_locometal" | "createdeco:short_umber_brick_slab_from_umber_brick_slab_stonecutting" | "tconstruct:tools/armor/travelers_swapping_metal" | "create:crafting/kinetics/gray_seat" | "createdeco:long_blue_bricks_from_short_blue_bricks_stonecutting" | "thermal:machines/smelter/smelter_electrum_dust" | "thermal:machines/press/unpacking/press_rich_slag_unpacking" | "create:crafting/materials/zinc_ingot_from_decompacting" | "minecraft:dye_yellow_wool" | "railways:sequenced_assembly/track_cherry_narrow" | "minecraft:magenta_carpet" | "create:crafting/kinetics/contraption_controls" | "mysticalagradditions:tconstruct/tools/materials/inferium/ingot" | "tconstruct:smeltery/melting/metal/brass/ingot" | "railways:sequenced_assembly/track_byg_jacaranda" | "createdeco:verdant_brick_stairs_from_tiled_verdant_brick_stairs_stonecutting" | "tconstruct:smeltery/melting/diamond/gear" | "thermal:machines/smelter/smelter_gold_dust" | "thermal:machines/insolator/insolator_bamboo" | "create:small_diorite_brick_wall" | "create:crafting/logistics/packager" | "thermal:machines/smelter/smelter_alloy_constantan" | "tconstruct:smeltery/melting/metal/bronze/boots" | "mysticalagriculture:essence/minecraft/magma_cream" | "tconstruct:tools/materials/wood/planks/default" | "minecraft:lectern" | "createdeco:light_gray_shipping_container_from_dyeing_vaults" | "create:cut_andesite_brick_wall" | "createdeco:short_dusk_brick_wall_from_corner_dusk_brick_wall_stonecutting" | "botanypots:mysticalagriculture/soil/prudentium_farmland" | "tconstruct:smeltery/melting/emerald/geore/bud_medium" | "minecraft:smooth_stone_slab" | "create:milling/beetroot" | "create:cutting/runtime_generated/compat/minecraft/jungle_planks_to_jungle_button" | "create:crushing/raw_aluminum_block" | "tconstruct:smeltery/melting/metal/rose_gold/dust" | "enderio:tank_fill/green_concrete" | "railways:crafting/palettes/dyeing_8x/lime_locometal_smokebox" | "tconstruct:smeltery/casting/metal/pig_iron/nugget_gold_cast" | "tconstruct:common/gold_platform" | "minecraft:mossy_cobblestone_from_vine" | "create:deploying/oxidized_copper_shingles_from_removing_wax" | "tconstruct:smeltery/melting/fuel/blaze" | "tconstruct:smeltery/melting/metal/cobalt/ingot" | "tconstruct:smeltery/melting/glass/sand" | "createdeco:dean_brick_wall_from_tiled_dean_brick_wall_stonecutting" | "tconstruct:smeltery/casting/metal/slimesteel/nugget_sand_cast" | "create:small_andesite_brick_wall" | "tconstruct:tools/materials/pewter/nugget" | "thermal:machines/insolator/insolator_red_tulip" | "create:crafting/kinetics/adjustable_chain_gearshift" | "thermal:ice_charge/obsidian_from_lava_bucket" | "bellsandwhistles:pilots/polished_calcite_pilot" | "createdeco:long_scarlet_brick_stairs_from_scarlet_bricks_stonecutting" | "tconstruct:smeltery/casts/sand/molding/ingots" | "enderio:tank_fill/orange_concrete" | "mysticalagriculture:gear/tertium_hoe" | "createdeco:pressing/coins/gold_coin" | "createdeco:decal_cross" | "create:smelting/glass_from_framed_glass" | "tconstruct:tools/materials/steel/block" | "tconstruct:smeltery/casting/metal/lumium/coin_gold_cast" | "createaddition:crafting/portable_energy_interface" | "ae2:shaped/walls/quartz_block" | "createdeco:dusk_brick_wall_from_short_dusk_brick_wall_stonecutting" | "thermal:smelting/silver_ingot_from_raw_smelting" | "ae2:network/blocks/energy_energy_acceptor_alt" | "mysticalagriculture:seed/reprocessor/slimesteel" | "createdeco:andesite_catwalk_railing_forge" | "botanypots:mysticalagriculture/crop/sky_stone" | "createdeco:short_pearl_brick_slab_from_long_pearl_bricks_stonecutting" | "railways:crafting/palettes/dyeing_8x/blue_plated_locometal" | "railways:sequenced_assembly/track_tfc_kapok" | "thermal:tools/wrench" | "minecraft:dark_prismarine_slab_from_dark_prismarine_stonecutting" | "enderio:recolor_clear_glass_ena_purple" | "create:oxidized_copper_shingle_stairs" | "createdeco:cracked_pearl_brick_wall_from_cracked_pearl_bricks_stonecutting" | "create:pressing/compat/betterendforge/pink_moss_path" | "mysticalagriculture:blank_skull" | "railways:sequenced_assembly/track_create_dd_rose_wide" | "createaddition:crushing/diamond" | "railways:crafting/palettes/dyeing_8x/purple_locometal_boiler" | "mysticalagriculture:supremium_gemstone_block" | "enderio:pulsating_crystal" | "botanypots:tconstruct/soil/ichor_slime_dirt" | "create:deploying/oxidized_cut_copper_slab_from_removing_wax" | "createdeco:mossy_dean_bricks_from_vine" | "mysticalagradditions:tconstruct/melting/tertium/ingot" | "tconstruct:common/glass/vanilla/daylight_detector" | "createdeco:long_dusk_brick_stairs_from_tiled_dusk_bricks_stonecutting" | "minecraft:pink_concrete_powder" | "immersive_aircraft:propeller" | "mysticalagriculture:essence/minecraft/glow_ink_sac" | "ae2:tools/nether_quartz_cutting_knife" | "mysticalagriculture:prudentium_upgrade" | "enderio:recolor_clear_glass_dnm_magenta" | "railways:crafting/palettes/dyeing_8x/orange_riveted_locometal" | "tconstruct:smeltery/casting/metal/hepatizon/nugget_sand_cast" | "mysticalagriculture:augment/night_vision" | "railways:crafting/palettes/dyeing_8x/magenta_copper_wrapped_locometal" | "minecraft:andesite_wall" | "createdeco:corner_dean_bricks_from_long_dean_bricks_stonecutting" | "mysticalagriculture:seed/reprocessor/amethyst" | "createdeco:mossy_blue_bricks_from_moss_block" | "thermal:rubberwood_stairs" | "minecraft:raiser_armor_trim_smithing_template_smithing_trim" | "enderio:alloy_smelting/end_steel_ingot" | "createdeco:dusk_brick_wall_from_long_dusk_brick_wall_stonecutting" | "tconstruct:smeltery/melting/metal/tungsten/dust" | "createdeco:tiled_dean_brick_wall_from_dean_bricks_stonecutting" | "tconstruct:compat/ceramics/filling_cracked_clay_bucket" | "createdeco:tiled_dean_brick_wall_from_short_dean_bricks_stonecutting" | "createdeco:long_pearl_brick_wall_from_tiled_pearl_brick_wall_stonecutting" | "tconstruct:tools/materials/slimewood/greenheart_logs" | "enderio:recolor_fused_quartz_a_yellow" | "mysticalagriculture:seed/infusion/netherite" | "createdeco:scarlet_brick_slab_from_short_scarlet_bricks_stonecutting" | "railways:sequenced_assembly/track_byg_witch_hazel" | "thermal:machines/pulverizer/pulverizer_blizz_rod" | "botanypots:minecraft/pot_interaction/till_coarse_dirt_to_dirt" | "railways:mechanical_crafting/green_brass_wrapped_locometal_boiler" | "createdeco:long_umber_brick_stairs_from_tiled_umber_bricks_stonecutting" | "railways:crafting/palettes/dyeing_1x/cyan_copper_wrapped_locometal" | "createdeco:long_blue_brick_slab_from_short_blue_bricks_stonecutting" | "create:milling/compat/environmental/red_hibiscus" | "create:weathered_copper_tile_stairs" | "enderio:recolor_fused_quartz_dna_white" | "railways:crafting/palettes/dyeing_8x/cyan_flat_riveted_locometal" | "create:deploying/oxidized_copper_tile_stairs_from_removing_wax" | "thermal:rubberwood_hanging_sign" | "create:crafting/kinetics/smart_fluid_pipe" | "ae2:blasting/silicon_from_certus_quartz_dust" | "botanypots:botanypots/crafting/pink_terracotta_botany_pot" | "thermal:storage/cured_rubber_block" | "tconstruct:smeltery/melting/metal/invar/sword" | "create:polished_cut_veridium_from_stone_types_veridium_stonecutting" | "tconstruct:tools/modifiers/slotless/draconic_from_scales" | "create:filling/compat/vampirism/cursed_grass" | "createdeco:tiled_verdant_brick_slab_from_tiled_verdant_bricks_stonecutting" | "storagedrawers:keybutton_drawer" | "minecraft:brown_glazed_terracotta" | "automobility:frame/standard_light_blue" | "tconstruct:smeltery/casting/metal/cobalt/ingot_gold_cast" | "mysticalagriculture:seed/reprocessor/earth" | "create:cut_scoria_wall" | "thermal:machines/press/unpacking/press_lumium_unpacking" | "botanypots:botanypots/crafting/light_blue_concrete_compact_hopper_botany_pot" | "minecraft:warped_trapdoor" | "mysticalagriculture:essence/appliedenergistics2/fluix" | "ae2:network/parts/annihilation_plane_alt2" | "railways:sequenced_assembly/track_mangrove" | "create:crafting/kinetics/fluid_pipe_vertical" | "ae2:network/cells/spatial_components" | "createdeco:short_pearl_brick_stairs_from_short_pearl_bricks_stonecutting" | "thermal:storage/niter_from_block" | "create:crafting/kinetics/lime_valve_handle_from_other_valve_handle" | "create:crafting/kinetics/mechanical_arm" | "botanypots:botanypots/crafting/blue_concrete_compact_hopper_botany_pot" | "thermal:armor/beekeeper_boots" | "createdeco:long_umber_brick_wall_from_short_umber_brick_wall_stonecutting" | "create:milling/compat/byg/peach_leather_flower" | "tconstruct:smeltery/scorched/scorched_bricks_stairs" | "createdeco:long_dean_brick_stairs_from_dean_bricks_stonecutting" | "create:cut_diorite_bricks_from_stone_types_diorite_stonecutting" | "createdeco:zinc_door" | "enderio:recolor_clear_glass_a_lime" | "copycats:crafting/copycat_vertical_stairs_from_conversion" | "railways:mechanical_crafting/white_locometal_boiler" | "mysticalagriculture:essence/minecraft/warped_stem" | "mysticalagriculture:gear/supremium_sword" | "tconstruct:gadgets/cake/magma" | "tconstruct:smeltery/casting/metal/signalum/block" | "create:cutting/runtime_generated/compat/minecraft/warped_hyphae_to_stripped_warped_hyphae" | "railways:crafting/palettes/dyeing_1x/yellow_iron_wrapped_locometal_boiler" | "create:cut_diorite_stairs" | "automobility:frame/standard_brown" | "enderio:basic_capacitor" | "thermal:machines/press/packing2x2/press_quartz_packing" | "create:crushing/deepslate_lapis_ore" | "enderio:recolor_clear_glass_dna_pink" | "ae2:decorative/certus_quartz_bricks" | "createdeco:scarlet_brick_wall_from_long_scarlet_bricks_stonecutting" | "minecraft:light_gray_dye_from_azure_bluet" | "enderio:alloy_smelting/fused_quartz" | "create:cutting/runtime_generated/compat/minecraft/birch_planks_to_birch_door" | "botanypots:mysticalagriculture/crop/titanium" | "enderio:recolor_clear_glass_dp_cyan" | "tconstruct:smeltery/melting/metal/netherite/helmet" | "botanypots:minecraft/soil/andesite" | "storagedrawers:warped_trim" | "thermal:machines/press/unpacking/press_invar_nugget_unpacking" | "enderio:redstone_alloy_grinding_ball" | "minecraft:magenta_candle" | "enderio:conduit_binder_from_blasting" | "createdeco:short_verdant_brick_stairs_from_corner_verdant_brick_stairs_stonecutting" | "tconstruct:tools/modifiers/salvage/upgrade/pierce" | "create:milling/compat/byg/crocus" | "create:cutting/runtime_generated/compat/tconstruct/stripped_greenheart_wood_to_greenheart_planks" | "railways:sequenced_assembly/track_byg_palm_narrow" | "tconstruct:smeltery/casts/gold/helmet_plating" | "createdeco:pink_placard" | "create:crushing/compat/silentgems/moldavite_ore" | "mysticalagriculture:seed/infusion/basalt" | "mysticalagriculture:seed/infusion/dye" | "createdeco:tiled_dean_brick_wall_from_dean_brick_wall_stonecutting" | "enderio:recolor_fused_quartz_np_cyan" | "create:cutting/runtime_generated/compat/tconstruct/greenheart_planks_to_greenheart_fence_gate" | "createdeco:umber_brick_slab_from_long_umber_brick_slab_stonecutting" | "create:crushing/compat/galosphere/amethyst" | "createdeco:long_umber_brick_stairs_from_short_umber_brick_stairs_stonecutting" | "createdeco:corner_dean_bricks_from_short_dean_bricks_stonecutting" | "tconstruct:tools/modifiers/upgrade/speedy_from_block" | "railways:crafting/palettes/dyeing_1x/light_blue_flat_riveted_locometal" | "tconstruct:smeltery/casting/metal/tin/plate_sand_cast" | "create:splashing/stained_glass" | "enderio:sag_milling/lapis" | "mysticalagradditions:supremium_coal" | "tconstruct:smeltery/casting/metal/gold/ingot_gold_cast" | "sophisticatedbackpacks:advanced_tool_swapper_upgrade" | "thermal:machines/smelter/smelter_alloy_invar" | "create:crafting/kinetics/large_water_wheel" | "create:polished_cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "createdeco:tiled_pearl_brick_wall_from_pearl_bricks_stonecutting" | "createaddition:compat/immersiveengineering/item_application/reinforced_blast_brick" | "create:milling/compat/regions_unexplored/light_gray_snowbelle" | "railways:sequenced_assembly/track_byg_embur_wide" | "create:smelting/lead_ingot_compat_oreganized" | "minecraft:note_block" | "tconstruct:smeltery/casts/gold/coins" | "mysticalagriculture:seed/infusion/nether" | "railways:crafting/palettes/dyeing_8x/light_blue_iron_wrapped_locometal_boiler" | "create:cutting/runtime_generated/compat/minecraft/oak_planks_to_oak_fence" | "enderio:recolor_clear_glass_a_blue" | "mysticalagriculture:seed/infusion/basalz" | "botanypots:minecraft/crop/cocoa_beans" | "tconstruct:smeltery/casts/red_sand/builder_block/boots_plating" | "create_connected:crafting/kinetics/centrifugal_clutch" | "createdeco:cracked_scarlet_brick_stairs_from_cracked_scarlet_bricks_stonecutting" | "ae2:tools/nether_quartz_axe" | "bellsandwhistles:grab_rails/andesite_grab_rails" | "minecraft:weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "minecraft:end_crystal" | "enderio:sag_milling/wheat" | "mysticalagriculture:seed/reprocessor/blazing_crystal" | "bellsandwhistles:station_platform_stonecutter" | "mysticalagradditions:dragon_egg" | "createdeco:long_pearl_brick_slab_from_corner_pearl_bricks_stonecutting" | "minecraft:shulker_box" | "createdeco:red_iron_lamp" | "tconstruct:tools/modifiers/salvage/ability/bursting" | "ae2:network/cables/covered_blue" | "minecraft:white_carpet" | "createdeco:andesite_trapdoor" | "createdeco:corner_umber_brick_slab_from_umber_brick_slab_stonecutting" | "minecraft:mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting" | "thermal:fuels/numismatic/numismatic_netherite_coin" | "create_more_additions:silver/crushed_raw_silver_from_crushing_raw_silver" | "thermal:lightning_grenade_4" | "tconstruct:tools/modifiers/upgrade/netherite" | "create:blasting/nickel_ingot_compat_thermal" | "mysticalagriculture:seed/reprocessor/turtle" | "create_more_additions:silver/building/button" | "createdeco:corner_blue_bricks_from_short_blue_bricks_stonecutting" | "tconstruct:smeltery/casts/red_sand/builder_cast/repair_kit" | "enderio:silent_crimson_pressure_plate" | "tconstruct:smeltery/casts/sand/builder_block/leggings_plating" | "railways:crafting/palettes/dyeing_1x/brown_riveted_locometal" | "minecraft:magenta_stained_glass" | "railways:crafting/palettes/dyeing_8x/gray_locometal_pillar" | "minecraft:iron_trapdoor" | "tconstruct:smeltery/melting/metal/constantan/sheetmetal" | "createdeco:mossy_dean_brick_wall" | "storagedrawers:personal_key_cofh" | "create:cutting/runtime_generated/compat/thermal/rubberwood_planks_to_rubberwood_sign" | "createdeco:short_blue_brick_stairs_from_blue_brick_stairs_stonecutting" | "expatternprovider:ex_drive_upgrade" | "thermal:machines/bottler/bottler_pink_concrete" | "createaddition:rolling/brass_ingot" | "minecraft:acacia_pressure_plate" | "enderio:recolor_clear_glass_ep_orange" | "createdeco:corner_red_brick_slab_from_long_red_brick_slab_stonecutting" | "create_connected:item_application/haunting_catalyst_from_empty" | "create:cutting/runtime_generated/compat/tconstruct/enderbark_planks_to_enderbark_fence" | "mysticalagriculture:supremium_essence" | "copycats:crafting/copycat_board" | "botanypots:mysticalagriculture/crop/wood" | "createaddition:charging/copper_shingle_stairs" | "minecraft:deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "botanypots:botanypots/crafting/yellow_concrete_botany_pot" | "railways:crafting/palettes/dyeing_8x/gray_locometal_boiler" | "tconstruct:smeltery/melting/metal/iron/nugget_3" | "create:filling/compat/farmersdelight/milk_bottle" | "createdeco:scarlet_brick_wall_from_tiled_scarlet_bricks_stonecutting" | "tconstruct:smeltery/melting/metal/iron/geore/shard" | "create:cut_asurine_brick_stairs" | "railways:sequenced_assembly/track_tfc_acacia_wide" | "thermal:machines/insolator/insolator_nether_wart" | "tconstruct:world/wood/skyroot/fence_gate" | "minecraft:polished_andesite_slab_from_polished_andesite_stonecutting" | "create:crushing/compat/simplefarming/oat" | "ae2:network/cables/covered_lime" | "create:crafting/kinetics/gearshift" | "mysticalagriculture:essence/minecraft/red_concrete" | "createdeco:black_shipping_container" | "create_connected:crafting/kinetics/kinetic_bridge" | "tconstruct:common/materials/amethyst_bronze_ingot_from_block" | "create:crushing/crimsite" | "mysticalagriculture:gear/prudentium_scythe" | "tconstruct:smeltery/melting/emerald/geore/cluster" | "tconstruct:tools/materials/composite/darkthread" | "createdeco:corner_blue_brick_wall_from_corner_blue_bricks_stonecutting" | "railways:sequenced_assembly/track_twilightforest_minewood_wide" | "create:cutting/compat/ars_nouveau/green_archwood_log" | "enderio:recolor_fused_quartz_d_light_blue" | "tconstruct:smeltery/melting/metal/lead/leggings" | "tconstruct:tools/modifiers/upgrade/severing" | "createdeco:dusk_brick_wall_from_dusk_bricks_stonecutting" | "minecraft:lime_banner" | "railways:sequenced_assembly/lime_conductor_cap" | "railways:sequenced_assembly/track_byg_redwood_narrow" | "createdeco:short_pearl_brick_stairs_from_tiled_pearl_bricks_stonecutting" | "tconstruct:smeltery/casting/metal/pig_iron/block" | "tconstruct:smeltery/melting/metal/dawnstone/nugget" | "tconstruct:smeltery/scorched/scorched_soul_glass" | "createdeco:corner_pearl_brick_wall_from_pearl_brick_wall_stonecutting" | "minecraft:deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "railways:mechanical_crafting/green_copper_wrapped_locometal_boiler" | "tconstruct:tools/modifiers/ability/ambidextrous" | "create:polished_cut_andesite_wall" | "minecraft:cut_copper_from_copper_block_stonecutting" | "thermal:smelting/enderium_ingot_from_dust_smelting" | "copycats:crafting/copycat_step_from_conversion" | "tconstruct:smeltery/casting/metal/refined_obsidian/ingot_gold_cast" | "tconstruct:smeltery/melting/metal/steel/gear" | "createdeco:mossy_red_brick_slab" | "enderio:recolor_clear_glass_np_gray" | "enderio:mek_advanced_pressurized_tube" | "thermal:machines/insolator/insolator_poppy" | "botanypots:minecraft/pot_interaction/till_farmland" | "mysticalagriculture:essence/minecraft/apple" | "tconstruct:smeltery/casts/sand/builder_cast/chestplate_plating" | "mysticalagriculture:gear/inferium_bow" | "create:cutting/runtime_generated/compat/minecraft/jungle_planks_to_jungle_door" | "railways:crafting/palettes/wrapping/cyan_iron_wrapped_locometal" | "railways:sequenced_assembly/track_natures_spirit_maple" | "tconstruct:smeltery/melting/obsidian/beacon" | "createdeco:pressing/coins/iron_coin" | "tconstruct:smeltery/casting/metal/brass/ingot_sand_cast" | "mysticalagriculture:tinkering_table" | "sophisticatedbackpacks:advanced_alchemy_upgrade" | "create:deploying/weathered_copper_from_removing_wax" | "thermal:machines/centrifuge/centrifuge_orange_wool" | "tconstruct:tools/materials/invar/block" | "enderio:sag_milling/vines" | "tconstruct:smeltery/casting/metal/tin/plate_gold_cast" | "copycats:crafting/copycat_vertical_step_from_conversion" | "tconstruct:smeltery/melting/metal/gold/nugget" | "create_connected:crafting/palettes/copycat_block_compat" | "minecraft:crimson_sign" | "enderio:recolor_clear_glass_orange" | "copycats:crafting/copycat_door" | "thermal:storage/sugar_cane_from_block" | "railways:sequenced_assembly/track_byg_maple" | "create:crafting/copper/waxed_copper_shingles_from_honeycomb" | "mysticalagriculture:augment/jump_boost_i" | "minecraft:stone_brick_slab" | "mysticalagriculture:essence/common/tin_ingot" | "createdeco:tiled_dean_brick_slab_from_corner_dean_bricks_stonecutting" | "mysticalagriculture:seed/infusion/redstone" | "tconstruct:smeltery/melting/metal/electrum/nugget" | "railways:sequenced_assembly/track_quark_blossom" | "thermal:storage/tar_block" | "railways:crafting/fuel_tank" | "create:cutting/runtime_generated/compat/minecraft/warped_planks_to_warped_door" | "railways:crafting/palettes/dyeing_1x/blue_locometal_boiler" | "create:small_andesite_brick_stairs" | "tconstruct:tools/modifiers/slotless/rebalanced_abilities" | "tconstruct:smeltery/casting/metal/zinc/ingot_sand_cast" | "tconstruct:tools/modifiers/ability/trick_quiver" | "ae2:network/cables/glass_lime" | "create:milling/compat/ae2/sky_stone_block" | "minecraft:stone_slab_from_stone_stonecutting" | "tconstruct:smeltery/casts/red_sand/builder_cast/gears" | "tconstruct:smeltery/melting/metal/signalum/nugget" | "minecraft:gray_glazed_terracotta" | "createdeco:andesite_window_pane" | "enderio:recolor_fused_quartz_dna_green" | "mysticalagriculture:end_agglomeratio" | "createdeco:long_blue_brick_wall_from_corner_blue_brick_wall_stonecutting" | "thermal:machines/insolator/insolator_cocoa_beans" | "create:cutting/runtime_generated/compat/tconstruct/skyroot_planks_to_skyroot_door" | "create:cut_calcite_wall" | "thermal:machines/press/unpacking/press_wheat_unpacking" | "create:cutting/runtime_generated/compat/tconstruct/enderbark_planks_to_enderbark_trapdoor" | "botanypots:tconstruct/soil/earth_earth_slime_grass" | "tconstruct:smeltery/scorched/scorched_bricks_stairs_stonecutter" | "ae2:misc/deconstruction_chiseled_certus_quartz" | "mysticalagriculture:seed/infusion/gaia_spirit" | "ae2:matter_cannon/nuggets/boron" | "tconstruct:smeltery/casting/metal/pig_iron/nugget_sand_cast" | "thermal:machines/press/press_dandelion_to_latex" | "createdeco:iron_mesh_fence_from_stonecutting" | "enderio:resetting_lever_sixty" | "create:crimson_window_pane" | "railways:crafting/palettes/wrapping/blue_iron_wrapped_locometal" | "mysticalagriculture:machine_frame" | "thermal:fuels/numismatic/numismatic_lead_coin" | "mysticalagradditions:insanium_coal_block" | "createdeco:andesite_window" | "createdeco:tiled_red_brick_stairs_from_corner_red_brick_stairs_stonecutting" | "create:crafting/kinetics/white_sail_from_conversion" | "create:cut_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "tconstruct:smeltery/melting/diamond/horse_armor" | "enderio:painting/painted_glowstone_frompainted" | "minecraft:honey_bottle" | "mysticalagriculture:awakening_pedestal" | "create:milling/compat/botania/gray_petal" | "enderio:recolor_fused_quartz_nm_purple" | "createdeco:corner_dusk_bricks_from_short_dusk_bricks_stonecutting" | "createdeco:tiled_umber_bricks_from_umber_bricks_stonecutting" | "createdeco:corner_dusk_bricks_from_long_dusk_bricks_stonecutting" | "tconstruct:common/copper_platform_waxing_weathered" | "tconstruct:smeltery/melting/seared/ingot_tank" | "railways:crafting/palettes/dyeing_1x/purple_iron_wrapped_locometal_boiler" | "ae2:tools/portable_item_cell_1k" | "tconstruct:tables/pattern" | "tconstruct:smeltery/casting/filling/scorched_ingot_gauge" | "create:crafting/kinetics/gantry_shaft" | "ae2:network/cables/glass_blue" | "enderio:recolor_fused_quartz_p_white" | "minecraft:lapis_lazuli" | "tconstruct:smeltery/casting/metal/lead/nugget_sand_cast" | "tconstruct:smeltery/casting/filling/seared_fuel_tank" | "createdeco:tiled_scarlet_brick_slab_from_corner_scarlet_brick_slab_stonecutting" | "ae2:tools/portable_item_cell_4k" | "tconstruct:smeltery/casting/scorched/brick_sand_cast" | "enderio:recolor_fused_quartz_ep_gray" | "tconstruct:smeltery/scorched/scorched_road_smelting" | "createaddition:pressing/zinc_ingot" | "thermal:machines/press/unpacking/press_lumium_nugget_unpacking" | "minecraft:quartz_block" | "copycats:crafting/copycat_half_layer_from_conversion" | "create:cut_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "create:cutting/compat/ars_nouveau/purple_archwood_log" | "tconstruct:smeltery/casting/slime/ichor/roots" | "mysticalagriculture:souls/chicken" | "create:splashing/runtime_generated/compat/minecraft/white_concrete_powder_to_white_concrete" | "thermal:storage/constantan_ingot_from_block" | "createdeco:corner_dean_brick_wall_from_short_dean_brick_wall_stonecutting" | "createdeco:corner_blue_brick_slab_from_long_blue_bricks_stonecutting" | "mysticalagriculture:seed/infusion/ironwood" | "mysticalagriculture:seed/reprocessor/soulium" | "createdeco:long_scarlet_brick_wall_from_scarlet_bricks_stonecutting" | "mysticalagriculture:souls/wither_skeleton_skull" | "create:milling/compat/byg/green_tulip" | "tconstruct:smeltery/melting/metal/cobalt/ore_sparse" | "createdeco:lime_shipping_container_from_dyeing_vaults" | "createdeco:short_dusk_brick_slab_from_corner_dusk_bricks_stonecutting" | "createdeco:copper_facade_from_stonecutting" | "create:deploying/waxed_oxidized_copper_tiles_from_adding_wax" | "enderio:recolor_fused_quartz_p_green" | "thermal:machines/smelter/smelter_lead_armor" | "ae2:matter_cannon/nuggets/cesium" | "thermal:machines/press/press_tin_ingot_to_plate" | "thermal:machines/press/packing3x3/press_cinnabar_packing" | "create_more_additions:silver/silver_nuggets_from_splashing_crushed_raw_silver" | "tconstruct:smeltery/casts/sand/builder_block/gems" | "create:splashing/crushed_raw_gold" | "tconstruct:tools/modifiers/slotless/overslime/ichor_bottle_crafting_table" | "minecraft:coast_armor_trim_smithing_template" | "minecraft:dune_armor_trim_smithing_template" | "create:crafting/logistics/brown_table_cloth_clear" | "tconstruct:tools/materials/casting/cobalt" | "create:cut_veridium_stairs" | "createdeco:industrial_iron_sheet_metal" | "railways:stonecutting/palettes/cycling/red_flat_riveted_locometal" | "minecraft:polished_blackstone_stairs_from_blackstone_stonecutting" | "mysticalagriculture:seed/infusion/vibrant_alloy" | "enderio:recolor_clear_glass_dp_light_gray" | "mysticalagriculture:gear/inferium_axe" | "mysticalagriculture:seed/reprocessor/aluminum" | "thermal:machines/centrifuge/centrifuge_yellow_wool" | "tconstruct:tools/modifiers/ability/warping" | "tconstruct:smeltery/melting/metal/silver/leggings" | "tconstruct:smeltery/casting/metal/copper/wire_sand_cast" | "mysticalagriculture:seed/reprocessor/lead" | "createdeco:tiled_scarlet_brick_wall_from_long_scarlet_brick_wall_stonecutting" | "enderio:recolor_clear_glass_a_purple" | "mysticalagriculture:soulium_ingot_block_uncraft" | "railways:sequenced_assembly/track_byg_zelkova_narrow" | "botanypots:botanypots/crafting/cyan_terracotta_hopper_botany_pot" | "create:crafting/kinetics/orange_seat_from_other_seat" | "minecraft:white_candle" | "minecraft:polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "tconstruct:smeltery/casting/metal/lumium/coin_sand_cast" | "enderio:enchanting/protection" | "minecraft:cobbled_deepslate_wall_from_cobbled_deepslate_stonecutting" | "create:cutting/runtime_generated/compat/minecraft/acacia_planks_to_acacia_fence" | "create:small_asurine_brick_stairs" | "createdeco:zinc_support" | "mysticalagriculture:seed/infusion/end" | "tconstruct:smeltery/melting/metal/gold/chestplate" | "thermal:machines/press/packing2x2/press_string_packing" | "createdeco:scarlet_brick_stairs_from_scarlet_bricks_stonecutting" | "minecraft:golden_carrot" | "enderio:xnor_filter_from_xor_filter" | "tconstruct:smeltery/seared/seared_cobble_wall" | "enderio:recolor_fused_quartz_ea_light_blue" | "ae2:network/cells/fluid_cell_housing" | "railways:dying_existing_cap_purple" | "botanypots:botanypots/crafting/blue_terracotta_botany_pot" | "railways:crafting/palettes/dyeing_8x/gray_iron_wrapped_locometal" | "mysticalagriculture:prudentium_ingot" | "mysticalagriculture:witherproof_block" | "enderio:slice_and_splice" | "mysticalagradditions:tconstruct/casting/inferium/nugget_sand_cast" | "create:deploying/exposed_copper_tiles_from_deoxidising" | "create:cutting/runtime_generated/compat/minecraft/warped_planks_to_warped_pressure_plate" | "createdeco:pressing/coins/copper_coin" | "thermal:fuels/numismatic/numismatic_copper_coin" | "createdeco:short_pearl_brick_wall_from_pearl_brick_wall_stonecutting" | "createdeco:tiled_red_brick_stairs_from_corner_red_bricks_stonecutting" | "create:crafting/kinetics/attribute_filter" | "mysticalagradditions:tconstruct/casting/inferium/ingot_sand_cast" | "tconstruct:smeltery/entity_melting/blaze" | "thermal:fuels/gourmand/gourmand_beetroot_block" | "tconstruct:smeltery/casting/metal/dawnstone/nugget_gold_cast" | "mysticalagradditions:tconstruct/melting/supremium/block" | "ae2:network/blocks/io_port" | "thermal:rubberwood_boat" | "tconstruct:tools/modifiers/upgrade/haste_from_dust" | "thermal:machines/press/packing3x3/press_iron_nugget_packing" | "minecraft:cherry_sign" | "tconstruct:smeltery/melting/metal/gold/bell" | "mysticalagriculture:tertium_ingot_uncraft" | "railways:crafting/palettes/dyeing_8x/blue_flat_riveted_locometal" | "create:crushing/deepslate_gold_ore" | "tconstruct:world/wood/bloodshroom/fence_gate" | "tconstruct:tools/modifiers/salvage/upgrade/feather_falling" | "thermal:machines/centrifuge/centrifuge_honeycomb" | "railways:sequenced_assembly/orange_conductor_cap" | "copycats:crafting/copycat_block_from_slabs" | "railways:crafting/palettes/wrapping/green_iron_wrapped_locometal" | "copycats:crafting/copycat_fence" | "enderio:recolor_fused_quartz_d_black" | "thermal:fire_grenade_4" | "tconstruct:tools/materials/rotten_flesh" | "railways:crafting/palettes/dyeing_1x/magenta_locometal_pillar" | "mysticalagriculture:seed/crafting/soulium" | "createdeco:tiled_umber_brick_slab_from_long_umber_brick_slab_stonecutting" | "minecraft:exposed_cut_copper_stairs" | "create:crafting/copper/waxed_exposed_copper_shingle_stairs_from_honeycomb" | "create:polished_cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "createdeco:tiled_scarlet_brick_slab_from_scarlet_bricks_stonecutting" | "botanypots:mysticalagriculture/crop/rock_crystal" | "mysticalagradditions:tconstruct/tools/casting/supremium" | "mysticalagriculture:seed/crafting/pig" | "tconstruct:smeltery/casting/metal/aluminum/coin_sand_cast" | "railways:crafting/palettes/dyeing_8x/white_brass_wrapped_locometal" | "tconstruct:tools/building/ender_staff" | "thermal:augments/machine_cycle_augment" | "minecraft:stripped_mangrove_wood" | "tconstruct:smeltery/casting/metal/tungsten/nugget_sand_cast" | "railways:sequenced_assembly/magenta_conductor_cap" | "minecraft:light_weighted_pressure_plate" | "angelring:reinforced_angel_ring" | "mysticalagriculture:seed/infusion/iridium" | "minecraft:dye_green_wool" | "create:crafting/appliances/netherite_diving_helmet" | "create:cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "mysticalagriculture:seed/infusion/osmium" | "create:crafting/logistics/brown_postbox_from_other_postbox" | "create:deploying/weathered_cut_copper_stairs_from_deoxidising" | "sophisticatedbackpacks:diamond_backpack" | "enderio:recolor_fused_quartz_nm_brown" | "enderio:redstone_alloy_ingot" | "enderio:recolor_clear_glass_ena_lime" | "minecraft:pink_banner" | "create:polished_cut_granite_stairs_from_stone_types_granite_stonecutting" | "thermal:machines/press/packing3x3/press_constantan_nugget_packing" | "tconstruct:common/fantastic_foundry" | "minecraft:copper_ingot_from_waxed_copper_block" | "railways:sequenced_assembly/track_quark_blossom_narrow" | "createdeco:short_pearl_brick_slab" | "thermal:augments/machine_speed_augment" | "ae2:block_cutter/slabs/sky_stone_small_brick_slab" | "create:cut_deepslate_slab_recycling" | "railways:mechanical_crafting/red_iron_wrapped_locometal_boiler" | "tconstruct:smeltery/casts/sand/builder_block/tough_binding" | "thermal:armor/hazmat_helmet" | "tconstruct:smeltery/casting/emerald/block" | "mysticalagriculture:enchanter/thorns" | "enderio:recolor_fused_quartz_na_pink" | "create:splashing/ice" | "tconstruct:smeltery/melting/diamond/geore/bud_medium" | "tconstruct:smeltery/melting/metal/silver/coin" | "mysticalagriculture:augment/strength_i" | "createdeco:long_scarlet_brick_stairs_from_long_scarlet_bricks_stonecutting" | "mysticalagriculture:prudentium_block_combine" | "create:splashing/endergetic/petrified_nether_corrock" | "create:deploying/exposed_copper_tile_slab_from_deoxidising" | "railways:crafting/palettes/dyeing_1x/light_blue_riveted_locometal" | "tconstruct:smeltery/melting/diamond/jukebox" | "minecraft:cut_copper_slab_from_cut_copper_stonecutting" | "create:cutting/runtime_generated/compat/tconstruct/stripped_enderbark_log_to_enderbark_planks" | "thermal:parts/enderium_gear" | "enderio:impulse_hopper" | "automobility:attachment/rear/cartography_table" | "expatternprovider:water_cell" | "tconstruct:smeltery/casting/scorched/glass_tinted" | "mysticalagriculture:soulium_block" | "railways:stonecutting/palettes/cycling/cyan_flat_riveted_locometal" | "thermal:machines/press/unpacking/press_raw_lead_unpacking" | "mysticalagriculture:essence/minecraft/music_disc_otherside" | "railways:sequenced_assembly/track_twilightforest_darkwood_narrow" | "mysticalagriculture:essence/minecraft/horn_coral" | "createdeco:industrial_iron_catwalk_from_stonecutting" | "tconstruct:smeltery/melting/slime/ender/crystal_block" | "enderio:recolor_clear_glass_dna_purple" | "railways:sequenced_assembly/track_biomesoplenty_magic_wide" | "thermal:machines/press/packing2x2/press_prismarine_packing" | "enderio:recolor_clear_glass_ena_blue" | "createdeco:tiled_verdant_brick_wall_from_short_verdant_bricks_stonecutting" | "create:small_calcite_bricks_from_stone_types_calcite_stonecutting" | "copycats:crafting/copycat_stairs_from_conversion" | "create:copper_shingle_stairs" | "tconstruct:smeltery/melting/metal/copper/nugget" | "create:milling/compat/regions_unexplored/white_snowbelle" | "enderio:recolor_fused_quartz_p_magenta" | "botanypots:botanypots/crafting/green_glazed_terracotta_compact_hopper_botany_pot" | "minecraft:copper_ingot_from_smelting_copper_ore" | "tconstruct:smeltery/casting/metal/hepatizon/nugget_gold_cast" | "ae2:matter_cannon/nuggets/sodium" | "create:haunting/glow_berries" | "tconstruct:smeltery/melting/metal/lumium/coin" | "create:small_granite_bricks_from_stone_types_granite_stonecutting" | "minecraft:iron_pickaxe" | "ae2:shaped/not_so_mysterious_cube" | "createdeco:short_dean_brick_wall_from_dean_brick_wall_stonecutting" | "tconstruct:tools/parts/builder/hammer_head" | "create:cutting/runtime_generated/compat/minecraft/oak_planks_to_oak_slab" | "minecraft:spruce_button" | "createdeco:tiled_dusk_brick_wall_from_dusk_bricks_stonecutting" | "create:cut_andesite_from_stone_types_andesite_stonecutting" | "createdeco:short_verdant_brick_slab" | "ae2:network/cables/glass_orange" | "tconstruct:smeltery/casting/metal/netherite/ancient_repair_kit_sand_cast" | "ae2:materials/cardinverter" | "create:splashing/runtime_generated/compat/minecraft/lime_concrete_powder_to_lime_concrete" | "tconstruct:smeltery/melting/metal/iron/chain_boots" | "ae2:network/cells/fluid_storage_cell_256k_storage" | "create:crushing/asurine" | "minecraft:deepslate_tiles" | "mysticalagriculture:seed/infusion/slime" | "tconstruct:gadgets/frame/diamond" | "create_connected:crafting/kinetics/kinetic_battery" | "botanypots:mysticalagriculture/crop/bronze" | "botanypots:minecraft/soil/deepslate_iron_ore" | "minecraft:nether_brick_stairs_from_nether_bricks_stonecutting" | "thermal:machines/crystallizer/crystallizer_lapis" | "mysticalagriculture:seed/reprocessor/signalum" | "railways:crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal_boiler" | "thermal:tools/xp_crystal" | "copycats:crafting/copycat_iron_door" | "createdeco:short_red_brick_stairs_from_long_red_brick_stairs_stonecutting" | "createdeco:netherite_nugget_from_netherite_ingot" | "extra_gauges:string_gauge" | "createdeco:corner_verdant_brick_slab_from_long_verdant_bricks_stonecutting" | "expatternprovider:epp_part" | "enderio:recolor_fused_quartz_dna_cyan" | "railways:sequenced_assembly/track_byg_sythian" | "createdeco:dusk_brick_stairs_from_short_dusk_bricks_stonecutting" | "tconstruct:smeltery/casts/sand/builder_cast/small_axe_head" | "enderio:recolor_clear_glass_d_magenta" | "tconstruct:smeltery/casting/metal/gold/ingot_sand_cast" | "railways:sequenced_assembly/track_tfc_oak_wide" | "createdeco:verdant_brick_wall_from_long_verdant_brick_wall_stonecutting" | "ae2:network/cables/covered_fluix_clean" | "tconstruct:tools/materials/melting/scorched_stone" | "mysticalagriculture:essence/minecraft/snow_block" | "railways:crafting/palettes/dyeing_8x/light_gray_brass_wrapped_locometal" | "minecraft:yellow_dye_from_dandelion" | "create:item_application/bound_cardboard_inworld" | "botanypots:mysticalagradditions/crop/dragon_egg" | "enderio:recolor_clear_glass_dm_yellow" | "mysticalagriculture:seed/crafting/soularium" | "mysticalagriculture:soulstone_bricks" | "minecraft:sentry_armor_trim_smithing_template_smithing_trim" | "railways:crafting/palettes/dyeing_1x/blue_copper_wrapped_locometal" | "createdeco:corner_verdant_brick_stairs_from_verdant_bricks_stonecutting" | "create:crafting/kinetics/item_drain" | "create:deepslate_pillar_from_stone_types_deepslate_stonecutting" | "minecraft:eye_armor_trim_smithing_template" | "enderio:recolor_fused_quartz_ea_purple" | "create:cut_tuff_brick_wall" | "thermal:machines/insolator/insolator_dandelion" | "tconstruct:smeltery/melting/metal/iron/tripwire" | "create:crafting/appliances/crafting_blueprint" | "botanypots:mysticalagriculture/crop/tin" | "thermal:smelting/lead_ingot_from_dust_blasting" | "storagedrawers:jungle_full_drawers_1" | "storagedrawers:personal_key_cycle" | "tconstruct:tools/modifiers/salvage/ability/boundless" | "ae2:tools/network_memory_card" | "createdeco:pink_shipping_container_from_dyeing_vaults" | "tconstruct:smeltery/casting/metal/bronze/ingot_sand_cast" | "storagedrawers:upgrade_template" | "ae2:network/cells/spatial_storage_cell_128_cubed" | "tconstruct:smeltery/casts/red_sand/builder_cast/large_plate" | "minecraft:polished_blackstone_brick_slab_from_blackstone_stonecutting" | "railways:crafting/palettes/dyeing_1x/blue_riveted_locometal" | "railways:stonecutting/palettes/cycling/brown_riveted_locometal" | "bellsandwhistles:headlight_2" | "createdeco:short_dean_brick_stairs_from_corner_dean_bricks_stonecutting" | "minecraft:mangrove_button" | "railways:stonecutting/palettes/cycling/orange_flat_slashed_locometal" | "createdeco:long_red_brick_slab_from_short_red_bricks_stonecutting" | "createdeco:corner_verdant_bricks_from_tiled_verdant_bricks_stonecutting" | "create:cutting/runtime_generated/compat/minecraft/spruce_planks_to_spruce_slab" | "tconstruct:smeltery/casting/metal/gold/plate_gold_cast" | "minecraft:yellow_bed" | "enderio:recolor_clear_glass_p_black" | "enderio:recolor_fused_quartz_m_light_gray" | "createdeco:corner_pearl_brick_slab_from_short_pearl_bricks_stonecutting" | "tconstruct:smeltery/casting/metal/iron/plate_sand_cast" | "tconstruct:tools/modifiers/salvage/upgrade/shield_strap" | "minecraft:nether_brick_slab_from_nether_bricks_stonecutting" | "enderio:recolor_clear_glass_ep_brown" | "createdeco:long_pearl_brick_wall" | "minecraft:waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "tconstruct:common/slime/earth/crystal_block" | "create:cutting/compat/regions_unexplored/ashen_wood" | "createdeco:corner_verdant_brick_stairs_from_short_verdant_bricks_stonecutting" | "tconstruct:smeltery/casts/sand/molding/nuggets" | "create:cutting/runtime_generated/compat/minecraft/acacia_planks_to_acacia_door" | "create_more_additions:electrum/equipment/electrum_hoe" | "create:layered_crimsite_from_stone_types_crimsite_stonecutting" | "railways:crafting/palettes/dyeing_1x/gray_locometal_boiler" | "ae2:network/cables/covered_fluix" | "mysticalagriculture:seed/crafting/nether" | "minecraft:purple_candle" | "tconstruct:smeltery/melting/metal/rose_gold/ingot" | "tconstruct:smeltery/melting/metal/signalum/coin" | "tconstruct:smeltery/seared/seared_glass" | "mysticalagriculture:seed/crafting/blazing_crystal" | "mysticalagriculture:gear/prudentium_fishing_rod" | "createdeco:long_dean_brick_slab_from_tiled_dean_bricks_stonecutting" | "tconstruct:tools/modifiers/slotless/rebalanced_defense" | "railways:crafting/palettes/dyeing_1x/white_locometal_boiler" | "mysticalagradditions:tconstruct/melting/prudentium/nugget" | "createdeco:tiled_dusk_brick_wall_from_tiled_dusk_bricks_stonecutting" | "thermal:machines/insolator/insolator_kelp" | "create:crushing/raw_tin_block" | "railways:crafting/palettes/dyeing_8x/blue_iron_wrapped_locometal" | "create:small_tuff_brick_slab" | "railways:crafting/palettes/dyeing_8x/gray_flat_riveted_locometal" | "railways:crafting/palettes/wrapping/gray_copper_wrapped_locometal" | "botanypots:botanypots/crafting/light_gray_terracotta_hopper_botany_pot" | "minecraft:cobblestone_stairs" | "thermal:machines/smelter/smelter_diamond_ore" | "create:milling/compat/buzzier_bees/pink_clover" | "create:cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "thermal:machines/bottler/bottler_mossy_cobblestone" | "tconstruct:smeltery/entity_melting/shulker" | "tconstruct:tools/modifiers/slotless/embellishment/wood/bamboo" | "createdeco:orange_shipping_container" | "createdeco:long_scarlet_brick_stairs" | "tconstruct:smeltery/melting/metal/silver/block" | "create:cut_scorchia_brick_wall" | "mysticalagriculture:soulium_spawner/sheep" | "thermal:storage/silver_nugget_from_ingot" | "createdeco:short_umber_brick_wall_from_corner_umber_bricks_stonecutting" | "tconstruct:smeltery/melting/metal/brass/nugget" | "createdeco:andesite_mesh_fence_from_stonecutting" | "mysticalagriculture:seed/reprocessor/dragon_egg" | "tconstruct:tools/modifiers/defense/revitalizing" | "tconstruct:smeltery/casting/scorched/brick_composite" | "create:polished_cut_scoria_slab_recycling" | "enderio:recolor_fused_quartz_dna_yellow" | "mysticalagriculture:seed/infusion/dragon_egg" | "create:cut_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "create:mechanical_crafting/crushing_wheel" | "tconstruct:tools/modifiers/slotless/embellishment/slime/sky" | "createdeco:long_blue_brick_wall_from_short_blue_brick_wall_stonecutting" | "thermal:machines/centrifuge/centrifuge_blue_rockwool" | "createdeco:umber_brick_stairs_from_long_umber_brick_stairs_stonecutting" | "minecraft:sentry_armor_trim_smithing_template" | "tconstruct:common/materials/cobalt_ingot_smelting" | "railways:sequenced_assembly/track_tfc_birch_narrow" | "railways:crafting/palettes/dyeing_1x/yellow_brass_wrapped_locometal" | "createdeco:short_scarlet_brick_slab_from_tiled_scarlet_brick_slab_stonecutting" | "enderio:recolor_fused_quartz_dnm_light_blue" | "tconstruct:smeltery/scorched/lantern" | "create:milling/compat/environmental/red_lotus_flower" | "createdeco:cracked_red_brick_wall" | "thermal:red_concrete_powder_with_slag" | "create:cut_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "createaddition:pressing/steel_ingot" | "enderio:silent_birch_pressure_plate" | "ae2:shaped/slabs/sky_stone_block" | "enderio:recolor_clear_glass_a_light_blue" | "createdeco:long_pearl_brick_slab_from_short_pearl_brick_slab_stonecutting" | "tconstruct:tools/materials/melting/gold" | "mysticalagriculture:soulium_ingot_recraft" | "railways:stonecutting/palettes/cycling/magenta_flat_riveted_locometal" | "create_more_additions:electrum/building/stairs" | "create:deploying/waxed_exposed_copper_shingle_slab_from_adding_wax" | "mysticalagriculture:seed/infusion/cobalt" | "create:crafting/kinetics/yellow_valve_handle_from_other_valve_handle" | "mysticalagriculture:essence/refinedstorage/quartz_enriched_iron_ingot" | "minecraft:repeater" | "railways:sequenced_assembly/track_tfc_kapok_wide" | "railways:stonecutting/palettes/cycling/blue_flat_riveted_locometal" | "createdeco:corner_scarlet_brick_wall" | "createdeco:short_dusk_brick_stairs_from_corner_dusk_brick_stairs_stonecutting" | "minecraft:iron_leggings" | "create:emptying/compat/alexsmobs/lava_bottle" | "createdeco:cracked_red_bricks_from_bricks_smelting" | "thermal:machines/insolator/insolator_cherry_sapling" | "create:rose_quartz_block_from_rose_quartz_stonecutting" | "thermal:machines/pulverizer/pulverizer_nickel_ore" | "railways:crafting/palettes/dyeing_8x/green_flat_riveted_locometal" | "minecraft:book_cloning" | "botanypots:minecraft/crop/warped_fungus" | "enderio:recolor_clear_glass_enp_blue" | "botanypots:botanypots/crafting/cyan_concrete_hopper_botany_pot" | "enderio:recolor_fused_quartz_dm_orange" | "tconstruct:smeltery/melting/slime/ichor/ball" | "thermal:machines/press/press_electrum_nugget_to_coin" | "mysticalagriculture:essence/twilightforest/knightmetal_ingot" | "tconstruct:smeltery/melting/emerald/ore_singular" | "tconstruct:tools/modifiers/salvage/ability/bouncy" | "thermal:machines/press/packing3x3/press_dried_kelp_packing" | "create:cut_andesite_wall_from_stone_types_andesite_stonecutting" | "railways:crafting/palettes/dyeing_8x/blue_locometal_boiler" | "minecraft:mushroom_stew" | "tconstruct:smeltery/casting/metal/slimesteel/ingot_gold_cast" | "mysticalagriculture:supremium_ingot_uncraft" | "ae2:block_cutter/stairs/quartz_brick_stairs" | "mysticalagriculture:gear/tertium_boots" | "thermal:machines/smelter/smelter_alloy_electrum" | "railways:sequenced_assembly/track_byg_embur" | "ae2:shaped/stairs/fluix_block" | "createdeco:brass_coin" | "railways:crafting/palettes/dyeing_8x/orange_iron_wrapped_locometal_boiler" | "botanypots:botanypots/crafting/red_glazed_terracotta_compact_hopper_botany_pot" | "enderio:recolor_clear_glass_black" | "ae2:block_cutter/slabs/quartz_slab" | "tconstruct:common/materials/slimesteel_nugget_from_ingot" | "create:copper_tile_stairs_from_copper_tiles_stonecutting" | "tconstruct:tools/materials/melting/constantan" | "mysticalagradditions:tconstruct/melting/inferium/nugget" | "minecraft:prismarine_brick_slab" | "createaddition:filling/chocolate_cake" | "minecraft:lapis_lazuli_from_blasting_deepslate_lapis_ore" | "tconstruct:smeltery/casting/metal/netherite/nugget_gold_cast" | "thermal:smelting/cured_rubber_from_smelting" | "mysticalagriculture:seed/reprocessor/blaze" | "mysticalagriculture:essence/enderio/pulsating_alloy_ingot" | "tconstruct:smeltery/casts/red_sand/molding/helmet_plating" | "enderio:soulbinding/enticing_crystal" | "mysticalagriculture:prosperity_shard_smelted" | "enderio:painting/painted_wall" | "ae2:network/cells/item_storage_components_cell_256k_part" | "mysticalagradditions:tconstruct/tools/materials/prudentium/block" | "minecraft:polished_andesite_from_andesite_stonecutting" | "tconstruct:smeltery/casting/quartz/granite" | "storagedrawers:jungle_full_drawers_4" | "storagedrawers:jungle_full_drawers_2" | "thermal:press_packing_2x2_die" | "create:cut_granite_slab_recycling" | "minecraft:mud_brick_slab_from_mud_bricks_stonecutting" | "create:deploying/waxed_oxidized_copper_shingle_stairs_from_adding_wax" | "createdeco:brass_trapdoor" | "tconstruct:smeltery/casting/seared/smeltery_controller" | "enderio:recolor_clear_glass_enp_lime" | "thermal:machines/centrifuge/centrifuge_pink_wool" | "tconstruct:tools/severing/rabbit_foot" | "mysticalagriculture:seed/reprocessor/inferium" | "createaddition:filling/treated_wood_planks" | "mysticalagriculture:inferium_block_uncraft" | "enderio:recolor_fused_quartz_np_light_gray" | "tconstruct:smeltery/casting/metal/silver/gear_gold_cast" | "createdeco:long_pearl_brick_stairs_from_pearl_brick_stairs_stonecutting" | "minecraft:smooth_stone_slab_from_smooth_stone_stonecutting" | "create:cut_calcite_bricks_from_stone_types_calcite_stonecutting" | "createdeco:dusk_brick_slab_from_long_dusk_bricks_stonecutting" | "createdeco:tiled_blue_brick_slab" | "minecraft:clock" | "tconstruct:tools/materials/amethyst_bronze/block" | "create:crafting/appliances/netherite_diving_helmet_from_netherite" | "enderio:alloy_smelting/soularium_ingot" | "mysticalagriculture:seed/crafting/grains_of_infinity" | "create:cutting/compat/ars_nouveau/stripped_red_archwood_wood" | "railways:crafting/palettes/dyeing_8x/cyan_locometal_boiler" | "createdeco:short_umber_brick_wall_from_umber_bricks_stonecutting" | "tconstruct:smeltery/casting/metal/gold/block" | "bellsandwhistles:pilots/polished_deepslate_pilot_from_cut" | "railways:sequenced_assembly/track_create_dd_spirit" | "create:milling/compat/byg/protea_flower" | "create:filling/compat/neapolitan/milk_bottle" | "mysticalagradditions:tconstruct/casting/inferium/block" | "thermal:armor/beekeeper_leggings" | "minecraft:blue_ice" | "ae2:block_cutter/stairs/quartz_stairs" | "railways:benchcart" | "tconstruct:smeltery/scorched/scorched_road_stairs_stonecutter" | "minecraft:diamond_leggings" | "createdeco:long_umber_brick_wall_from_long_umber_bricks_stonecutting" | "create:deploying/exposed_cut_copper_stairs_from_removing_wax" | "minecraft:purple_stained_glass" | "railways:crafting/palettes/wrapping/pink_brass_wrapped_locometal" | "tconstruct:smeltery/melting/metal/iron/boots" | "enderio:recolor_fused_quartz_p_cyan" | "createdeco:copper_window" | "railways:stonecutting/palettes/cycling/brown_plated_locometal" | "createdeco:long_dusk_brick_stairs_from_dusk_bricks_stonecutting" | "enderio:sag_milling/blaze_powder" | "create:polished_cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "tconstruct:smeltery/melting/metal/electrum/block" | "tconstruct:smeltery/casting/slime/sky/slimeball" | "minecraft:polished_andesite_slab_from_andesite_stonecutting" | "minecraft:dye_black_bed" | "createdeco:short_dean_brick_slab_from_corner_dean_bricks_stonecutting" | "mysticalagriculture:seed/reprocessor/creeper" | "botanypots:botanypots/crafting/pink_glazed_terracotta_botany_pot" | "railways:crafting/palettes/dyeing_1x/blue_locometal_smokebox" | "createdeco:dean_bricks" | "mysticalagriculture:seed/infusion/nether_quartz" | "tconstruct:smeltery/casts/sand/molding/plates" | "create:milling/sunflower" | "minecraft:mossy_stone_bricks_from_moss_block" | "expatternprovider:assembler_matrix_speed" | "enderio:recolor_fused_quartz_da_black" | "enderio:pressurized_fluid_conduit" | "botanypots:tconstruct/soil/earth_ichor_slime_grass" | "enderio:advanced_item_filter" | "createdeco:short_verdant_brick_slab_from_long_verdant_bricks_stonecutting" | "mysticalagriculture:seed/reprocessor/fiery_ingot" | "createdeco:corner_blue_brick_wall_from_blue_brick_wall_stonecutting" | "createdeco:cracked_blue_bricks_from_blue_bricks_smelting" | "tconstruct:tools/modifiers/ability/reach" | "tconstruct:tools/modifiers/salvage/ability/firestarter" | "createdeco:corner_pearl_brick_slab_from_corner_pearl_bricks_stonecutting" | "thermal:smelting/lumium_ingot_from_dust_blasting" | "railways:crafting/palettes/dyeing_8x/cyan_locometal_smokebox" | "createdeco:corner_red_brick_stairs_from_long_red_brick_stairs_stonecutting" | "createaddition:rolling/copper_ingot" | "createdeco:short_dusk_brick_stairs_from_long_dusk_brick_stairs_stonecutting" | "create:crafting/kinetics/mechanical_piston" | "mysticalagriculture:soulium_spawner/wither_skeleton" | "create:splashing/oreganized/crushed_raw_silver" | "mysticalagriculture:soulstone_bricks_slab" | "createdeco:mossy_scarlet_brick_wall_from_mossy_scarlet_bricks_stonecutting" | "enderio:silent_stone_pressure_plate" | "railways:sequenced_assembly/track_tfc_pine_narrow" | "minecraft:wooden_shovel" | "railways:sequenced_assembly/track_twilightforest_twilight_oak_narrow" | "tconstruct:smeltery/casts/sand/builder_cast/wires" | "createdeco:decal_down_right" | "enderio:recolor_fused_quartz_black" | "createdeco:long_umber_brick_slab_from_tiled_umber_bricks_stonecutting" | "mysticalagriculture:seed/crafting/silver" | "botanypots:mysticalagriculture/crop/enderman" | "minecraft:bamboo_trapdoor" | "createdeco:long_blue_brick_stairs_from_corner_blue_bricks_stonecutting" | "create:deploying/waxed_copper_block_from_adding_wax" | "create:item_application/railway_casing" | "minecraft:waxed_copper_block_from_honeycomb" | "mysticalagriculture:souls/blaze_rod" | "mysticalagriculture:gear/supremium_leggings" | "create:copper_bars_from_ingots_copper_stonecutting" | "enderio:recolor_clear_glass_nm_pink" | "minecraft:warped_fungus_on_a_stick" | "createdeco:copper_door" | "createdeco:long_red_bricks_from_short_red_bricks_stonecutting" | "createdeco:tiled_dean_brick_slab_from_short_dean_bricks_stonecutting" | "enderio:copper_alloy_grinding_ball" | "create:pressing/aether_dirt_path_from_grass" | "createdeco:scarlet_bricks_from_tiled_scarlet_bricks_stonecutting" | "mysticalagriculture:witherproof_bricks" | "minecraft:gold_ingot_from_smelting_raw_gold" | "sophisticatedbackpacks:smithing_upgrade" | "tconstruct:common/glass/light_blue_clear_stained_glass" | "tconstruct:tools/modifiers/salvage/defense/golden" | "enderio:recolor_fused_quartz_e_gray" | "createdeco:zinc_hull" | "minecraft:cooked_cod_from_smoking" | "createdeco:pearl_brick_stairs_from_tiled_pearl_brick_stairs_stonecutting" | "tconstruct:tools/modifiers/salvage/ability/bulk_quiver" | "create:cutting/runtime_generated/compat/tconstruct/greenheart_log_to_stripped_greenheart_log" | "tconstruct:smeltery/melting/metal/bronze/gear" | "railways:mechanical_crafting/pink_locometal_boiler" | "ae2:charger/charged_certus_quartz_crystal" | "tconstruct:smeltery/casts/red_sand/builder_cast/wires" | "enderio:recolor_clear_glass_dna_gray" | "create:deploying/copper_tiles_from_removing_wax" | "mysticalagriculture:essence/minecraft/music_disc_cat" | "railways:stonecutting/palettes/cycling/purple_locometal_smokebox" | "botanypots:mysticalagriculture/crop/saltpeter" | "mysticalagriculture:essence/gems/sapp