ItemEvents.tooltip(event => {
    let /** @type{Internal.ItemTooltipEventJS$StaticTooltipHandlerFromJS_} */tooltipFn =
        (item, advanced, text) => {
            let wrenchType = item.nbt?.defaultWrenchType;
            text.add(1, Text.of("Automagically transforms into the correct wrench for the mod you're interacting with").darkGray());
            if (wrenchType) {
                let displayName = Item.of(wrenchType).displayName;
                text.add(2, [
                    Text.of("Will transform into ").darkGray(),
                    Text.of(displayName).gray(),
                    Text.of(" when no other wrench is appropriate").darkGray(),
                ]);
            }
        };

    event.addAdvanced("ae2:certus_quartz_wrench", tooltipFn);
    event.addAdvanced("ae2:nether_quartz_wrench", tooltipFn);
    event.addAdvanced("ae2:network_tool", tooltipFn);
    event.addAdvanced("create:wrench", tooltipFn);
    event.addAdvanced("enderio:yeta_wrench", tooltipFn);
    event.addAdvanced("thermal:wrench", tooltipFn);
});