const $FunnelBlockEntity = Java.loadClass("com.simibubi.create.content.logistics.funnel.FunnelBlockEntity");
Ponder.registry(event => {
    const /** @type{Internal.PonderStoryBoard_} */ compostScene = (scene, util) => {
        scene.showBasePlate();
        const /** @type{Internal.WorldInstructions} */world = scene.world;

        for (let y = 2; y < 6; y++) {
            world.showSection([3, y, 2, 3, y, 1], Facing.DOWN);
            scene.idle(3);
        }
        scene
            .showControls(40, [3.5, 6, 2.5], "down")
            .withItem("minecraft:oak_sapling");

        scene
            .text(
                60,
                "As you most likely already know, the Composter can be used to"
                + " convert organic materials into Bone Meal.",
                [3, 3.5, 2.5],
            )
            .placeNearTarget();

        scene.idle(30);
        world.createItemEntity([3.5, 2, 1.5], [0, 0, 0], "minecraft:bone_meal");
        world.modifyBlockEntity([3, 2, 1], $FunnelBlockEntity, be => be.flap(false));

        scene.idle(40);

        for (let y = 1; y < 6; y++) {
            world.showSection([1, y, 2], Facing.DOWN);
            scene.idle(3);
        }
        scene
            .showControls(40, [1.6, 6, 2.5], "down")
            .withItem("minecraft:oak_sapling");

        scene
            .text(
                60,
                "The Batch Composter is very similar, but it instead produces Compost.",
                [1, 3.5, 2.5],
            )
            .placeNearTarget()
            .attachKeyFrame();

        scene.idle(30);
        let a = world.createItemEntity([1.5, 2, 2.5], [0, 0, 0], "thermal:compost");
        scene.idle(30);
        let b = world.createItemEntity([1.5, 2, 2.5], [0, 0, 0], "thermal:compost");
        scene
            .text(
                60,
                "Using upgraded components on the Batch Composter will increase its"
                + " processing speed.",
                [1, 3.5, 2.5],
            )
            .placeNearTarget()
            .attachKeyFrame();
        scene.idle(20);
        scene
            .showControls(40, [1.5, 3.5, 2], "right")
            .rightClick()
            .withItem("thermal:upgrade_augment_3");
        scene.idle(10);
        let d = world.createItemEntity([1.5, 2, 2.5], [0, 0, 0], "thermal:compost");
        scene.idle(20);
        let e = world.createItemEntity([1.5, 2, 2.5], [0, 0, 0], "thermal:compost");
        scene.idle(20);
        world.removeEntity(a);
        world.removeEntity(b);
        world.removeEntity(c);
        world.removeEntity(d);
        world.removeEntity(e);
        world.setBlock([1, 2, 2], "minecraft:barrel", false);
        world.showSection([1, 2, 2], Facing.SOUTH);
        scene.text(
            60,
            "Since Compost can be used to fertilise plants in the same way as"
            + " Bone Meal, and the Batch Composter is easier to automate, it's"
            + " generally worth upgrading to the Batch Composter.",
        );
    };
    event.create("minecraft:bone_meal")
        .scene("compost", "Compost and the Batch Composter", "kubejs:compost", compostScene);
    event.create("minecraft:composter")
        .scene("compost", "Compost and the Batch Composter", "kubejs:compost", compostScene);
    event.create("thermal:compost")
        .scene("compost", "Compost and the Batch Composter", "kubejs:compost", compostScene);
    event.create("thermal:device_composter")
        .scene("compost", "Compost and the Batch Composter", "kubejs:compost", compostScene);
});