// priority: 0

// Visit the wiki for more info - https://kubejs.com/
JEIEvents.hideFluids(event => {
    event.hide("mysticalagradditions:molten_soulium");
});
JEIEvents.hideItems(event => {
    const disabledItems = {
        angelring: [
            "energetic_angel_ring",
            "leadstone_angel_ring",
            "hardened_angel_ring",
            "reinforced_angel_ring",
            "resonant_angel_ring",
        ],
        mysticalagradditions: [
            "inferium_coal_block",
            "inferium_coal",
            "prudentium_coal_block",
            "prudentium_coal",
            "tertium_coal_block",
            "tertium_coal",
            "imperium_coal_block",
            "imperium_coal",
            "supremium_coal_block",
            "supremium_coal",
            "insanium_coal_block",
            "insanium_coal",
            "nether_inferium_ore",
            "nether_prosperity_ore",
            "end_inferium_ore",
            "end_prosperity_ore",
            "nether_star_crux",
            "dragon_egg_crux",
            "nether_star_shard",
            "dragon_egg_chunk",
            "dragon_scale",
            "inferium_paxel",
            "prudentium_paxel",
            "tertium_paxel",
            "imperium_paxel",
            "supremium_paxel",
            "awakened_supremium_paxel",
            "molten_soulium_bucket",
        ],
        mysticalagriculture: [
            "inferium_furnace",
            "prudentium_furnace",
            "tertium_furnace",
            "imperium_furnace",
            "supremium_furnace",
            "awakened_supremium_furnace",
            "awakened_supremium_essence",
            "awakened_supremium_ingot",
            "soulium_ingot",
            "awakened_supremium_ingot_block",
            "soulium_ingot_block",
            "awakened_supremium_nugget",
            "soulium_nugget",
            "awakened_supremium_block",
            "soulium_block",
            "awakened_supremium_gemstone",
            "soulium_gemstone",
            "awakened_supremium_gemstone_block",
            "soulium_gemstone_block",
            "soulium_ore",
            "infusion_pedestal",
            "infusion_altar",
            "awakening_pedestal",
            "awakening_altar",
            "essence_vessel",
            "tinkering_table",
            "enchanter",
            "soul_extractor",
            "harvester",
            "soulium_spawner",
            "prosperity_seed_base",
            "soulium_seed_base",
            "soulium_dust",
            "cognizant_dust",
            "soulium_dagger",
            "passive_soulium_dagger",
            "hostile_soulium_dagger",
            "creative_soulium_dagger",
            "air_agglomeratio",
            "earth_agglomeratio",
            "water_agglomeratio",
            "fire_agglomeratio",
            "nature_agglomeratio",
            "dye_agglomeratio",
            "nether_agglomeratio",
            "coral_agglomeratio",
            "honey_agglomeratio",
            "prismarine_agglomeratio",
            "end_agglomeratio",
            "experience_droplet",
            "wand",
            "unattuned_augment",
            "soul_jar",
            "experience_capsule",
            "diamond_sickle",
            "diamond_scythe",
            "awakened_supremium_upgrade",
            "awakened_supremium_watering_can",
            "absorption_i_augment",
            "absorption_ii_augment",
            "absorption_iii_augment",
            "absorption_iv_augment",
            "absorption_v_augment",
            "attack_aoe_i_augment",
            "attack_aoe_ii_augment",
            "attack_aoe_iii_augment",
            "blindness_resistance_augment",
            "fire_resistance_augment",
            "flight_augment",
            "haste_i_augment",
            "haste_ii_augment",
            "haste_iii_augment",
            "health_boost_i_augment",
            "health_boost_ii_augment",
            "health_boost_iii_augment",
            "health_boost_iv_augment",
            "health_boost_v_augment",
            "hunger_resistance_augment",
            "jump_boost_i_augment",
            "jump_boost_ii_augment",
            "jump_boost_iii_augment",
            "luck_i_augment",
            "luck_ii_augment",
            "luck_iii_augment",
            "mining_aoe_i_augment",
            "mining_aoe_ii_augment",
            "mining_aoe_iii_augment",
            "mining_aoe_iv_augment",
            "mining_fatigue_resistance_augment",
            "nausea_resistance_augment",
            "night_vision_augment",
            "no_fall_damage_augment",
            "pathing_aoe_i_augment",
            "pathing_aoe_ii_augment",
            "pathing_aoe_iii_augment",
            "pathing_aoe_iv_augment",
            "poison_resistance_augment",
            "slow_falling_augment",
            "slowness_resistance_augment",
            "speed_i_augment",
            "speed_ii_augment",
            "speed_iii_augment",
            "step_assist_augment",
            "strength_i_augment",
            "strength_ii_augment",
            "strength_iii_augment",
            "tilling_aoe_i_augment",
            "tilling_aoe_ii_augment",
            "tilling_aoe_iii_augment",
            "tilling_aoe_iv_augment",
            "water_breathing_augment",
            "weakness_resistance_augment",
            "wither_resistance_augment",
        ],
        automobility: [
            "slope",
            "steep_slope",
        ],
    };
    for (let [mod, items] of Object.entries(disabledItems)) {
        items.forEach(item => {
            event.hide(`${mod}:${item}`);
        });
    }
    for (let plant of [
        "air", "earth", "water", "fire", "stone", "dirt", "wood", "ice",
        "deepslate", "nature", "dye", "nether", "coal", "coral", "honey",
        "amethyst", "pig", "chicken", "cow", "sheep", "squid", "fish", "slime",
        "turtle", "rubber", "silicon", "sulfur", "aluminum", "saltpeter",
        "apatite", "grains_of_infinity", "marble", "limestone", "basalt", "iron",
        "copper", "nether_quartz", "glowstone", "redstone", "obsidian",
        "prismarine", "zombie", "skeleton", "creeper", "spider", "rabbit", "tin",
        "bronze", "zinc", "brass", "silver", "lead", "graphite", "blizz", "blitz",
        "basalz", "amethyst_bronze", "slimesteel", "pig_iron", "copper_alloy",
        "redstone_alloy", "conductive_alloy", "sky_stone", "certus_quartz",
        "gold", "lapis_lazuli", "end", "experience", "blaze", "ghast", "enderman",
        "steel", "nickel", "constantan", "electrum", "invar", "mithril",
        "tungsten", "titanium", "uranium", "chrome", "ruby", "sapphire",
        "peridot", "soulium", "signalum", "lumium", "cobalt", "rose_gold",
        "soularium", "dark_steel", "pulsating_alloy", "energetic_alloy", "fluix",
        "diamond", "emerald", "netherite", "wither_skeleton", "platinum",
        "iridium", "enderium", "manyullyn", "queens_slime", "hepatizon",
        "vibrant_alloy", "end_steel", "nether_star", "dragon_egg",
    ]) {
        event.hide(`mysticalagriculture:${plant}_seeds`);
        event.hide(`mysticalagriculture:${plant}_essence`);
    }
    for (let tier of ["inferium", "prudentium", "tertium", "imperium", "supremium", "awakened_supremium"]) {
        event.hide(`mysticalagriculture:${tier}_sword`);
        event.hide(`mysticalagriculture:${tier}_pickaxe`);
        event.hide(`mysticalagriculture:${tier}_axe`);
        event.hide(`mysticalagriculture:${tier}_shovel`);
        event.hide(`mysticalagriculture:${tier}_hoe`);
        event.hide(`mysticalagriculture:${tier}_bow`);
        event.hide(`mysticalagriculture:${tier}_crossbow`);
        event.hide(`mysticalagriculture:${tier}_shears`);
        event.hide(`mysticalagriculture:${tier}_fishing_rod`);
        event.hide(`mysticalagriculture:${tier}_sickle`);
        event.hide(`mysticalagriculture:${tier}_scythe`);
        event.hide(`mysticalagriculture:${tier}_helmet`);
        event.hide(`mysticalagriculture:${tier}_chestplate`);
        event.hide(`mysticalagriculture:${tier}_leggings`);
        event.hide(`mysticalagriculture:${tier}_boots`);
    }
    event.hide(Item.of("patchouli:guide_book").withNBT({"patchouli:book": "mysticalagriculture:guide"}));
});
JEIEvents.addItems(event => {
    event.add("cb_microblock:stone_saw");
    event.add("cb_microblock:iron_saw");
    event.add("cb_microblock:diamond_saw");
});